/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipFile;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.BuildInfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class FaultSystemSolution
extends ModuleContainer<OpenSHA_Module>
implements ArchivableModule,
SubModule<ModuleArchive<OpenSHA_Module>> {
    protected FaultSystemRupSet rupSet;
    protected double[] rates;
    ModuleArchive<OpenSHA_Module> archive;
    public static final String NESTING_PREFIX = "solution/";
    public static final String RATES_FILE_NAME = "rates.csv";
    private HashMap<String, double[]> particRatesCache = new HashMap();
    private HashMap<String, double[]> nucleationRatesCache = new HashMap();
    private double[] totParticRatesCache;
    private Map<PaleoProbabilityModel, double[]> paleoVisibleRatesCache;

    protected FaultSystemSolution() {
    }

    public FaultSystemSolution(FaultSystemRupSet rupSet, double[] rates) {
        this.init(rupSet, rates);
        if (!this.hasModule(BuildInfoModule.class)) {
            try {
                this.addModule(BuildInfoModule.detect());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void init(FaultSystemRupSet rupSet, double[] rates) {
        this.rupSet = rupSet;
        this.rates = rates;
        Preconditions.checkNotNull((Object)rupSet, (Object)"Rupture set cannot be null");
        Preconditions.checkNotNull((Object)rates, (Object)"Rates cannot be null");
        Preconditions.checkArgument((rates.length == rupSet.getNumRuptures() ? 1 : 0) != 0, (Object)"# rates and ruptures is inconsistent!");
    }

    public ModuleArchive<OpenSHA_Module> getArchive() {
        FaultSystemRupSet oRupSet;
        if (this.archive == null) {
            this.archive = new ModuleArchive();
        }
        if ((oRupSet = this.archive.getModule(FaultSystemRupSet.class)) == null) {
            this.archive.addModule(this.rupSet);
        } else {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(this.archive.getModule(FaultSystemRupSet.class)));
        }
        FaultSystemSolution sol = this.archive.getModule(FaultSystemSolution.class);
        if (sol == null) {
            this.archive.addModule(this);
        } else {
            Preconditions.checkState((sol == this ? 1 : 0) != 0);
        }
        return this.archive;
    }

    public void write(File file) throws IOException {
        this.getArchive().write(file);
    }

    public void write(ArchiveOutput output) throws IOException {
        this.getArchive().write(output);
    }

    public static boolean isSolution(ZipFile zip) {
        return zip.getEntry("solution/rates.csv") != null || zip.getEntry("rates.bin") != null;
    }

    public static boolean isSolution(ArchiveInput input) throws IOException {
        return input.hasEntry("solution/rates.csv") || input.hasEntry("rates.bin");
    }

    public static FaultSystemSolution load(File file) throws IOException {
        return FaultSystemSolution.load(ArchiveInput.getDefaultInput(file));
    }

    public static FaultSystemSolution load(File file, FaultSystemRupSet rupSet) throws IOException {
        return FaultSystemSolution.load(ArchiveInput.getDefaultInput(file), rupSet);
    }

    public static FaultSystemSolution load(ZipFile zip) throws IOException {
        return FaultSystemSolution.load(zip, null);
    }

    public static FaultSystemSolution load(ZipFile zip, FaultSystemRupSet rupSet) throws IOException {
        if (rupSet == null && zip.getEntry("rup_sections.bin") != null && zip.getEntry("rates.bin") != null) {
            System.err.println("WARNING: this is a legacy fault sytem solution, that file format is deprecated. Will attempt to load it using the legacy file loader. See https://opensha.org/File-Formats for more information.");
            try {
                return U3FaultSystemIO.loadSolAsApplicable(zip, null);
            }
            catch (DocumentException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        return FaultSystemSolution.load(new ArchiveInput.ZipFileInput(zip), rupSet);
    }

    public static FaultSystemSolution load(ArchiveInput input) throws IOException {
        return FaultSystemSolution.load(input, null);
    }

    public static FaultSystemSolution load(ArchiveInput input, FaultSystemRupSet rupSet) throws IOException {
        ModuleArchive<Object> archive;
        if (rupSet == null && input.hasEntry("rup_sections.bin") && input.hasEntry("rates.bin")) {
            System.err.println("WARNING: this is a legacy fault sytem solution, that file format is deprecated. Will attempt to load it using the legacy file loader. See https://opensha.org/File-Formats for more information.");
            Preconditions.checkState((boolean)(input instanceof ArchiveInput.FileBacked), (Object)"Can only do a deprecated load from zip files (this isn't file-backed)");
            try {
                return U3FaultSystemIO.loadSolAsApplicable(((ArchiveInput.FileBacked)input).getInputFile());
            }
            catch (DocumentException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        if (rupSet == null) {
            archive = new ModuleArchive<FaultSystemSolution>(input, FaultSystemSolution.class);
        } else {
            archive = new ModuleArchive(input);
            archive.addModule(rupSet);
        }
        FaultSystemSolution sol = archive.getModule(FaultSystemSolution.class);
        if (sol == null && !input.hasEntry("modules.json") && input.hasEntry("ruptures/indices.csv") && input.hasEntry("solution/rates.csv")) {
            System.err.println("WARNING: solution archive is missing modules.json, trying to load it anyway");
            archive.loadUnlistedModule(FaultSystemRupSet.class, "ruptures/");
            Preconditions.checkState((boolean)archive.hasModule(FaultSystemRupSet.class), (Object)"Failed to load unlisted rupture set module");
            archive.loadUnlistedModule(FaultSystemSolution.class, NESTING_PREFIX);
            Preconditions.checkState((boolean)archive.hasModule(FaultSystemSolution.class), (Object)"Failed to load unlisted solution module");
            sol = archive.getModule(FaultSystemSolution.class);
        }
        Preconditions.checkState((sol != null ? 1 : 0) != 0, (Object)"Failed to load solution module from archive (see above error messages)");
        Preconditions.checkNotNull((Object)sol.rupSet, (Object)"rupture set not loaded?");
        Preconditions.checkNotNull(sol.archive, (Object)"archive should have been set automatically");
        if (sol.hasAvailableModule(GridSourceList.class) && !sol.hasAvailableModule(GridSourceList.Precomputed.class)) {
            System.err.println("WARNING: solution archive refers to old GridSourceList module class that is now abstract, updating with Precomputed variant.");
            sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<GridSourceList>(){

                @Override
                public GridSourceList call() throws Exception {
                    return archive.loadUnlistedModule(GridSourceList.Precomputed.class, FaultSystemSolution.NESTING_PREFIX);
                }
            }, GridSourceList.class);
        }
        return sol;
    }

    @Override
    public String getName() {
        return "Solution";
    }

    @Override
    protected String getNestingPrefix() {
        return NESTING_PREFIX;
    }

    public static CSVFile<String> buildRatesCSV(FaultSystemSolution sol) {
        CSVFile<String> ratesCSV = new CSVFile<String>(true);
        ratesCSV.addLine("Rupture Index", "Annual Rate");
        double[] rates = sol.getRateForAllRups();
        for (int r = 0; r < rates.length; ++r) {
            ratesCSV.addLine((String[])new String[]{"" + r, "" + rates[r]});
        }
        return ratesCSV;
    }

    @Override
    public final void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        CSV_BackedModule.writeToArchive(FaultSystemSolution.buildRatesCSV(this), output, entryPrefix, RATES_FILE_NAME);
    }

    public static double[] loadRatesCSV(CSVFile<String> ratesCSV) {
        double[] rates = new double[ratesCSV.getNumRows() - 1];
        for (int r = 0; r < rates.length; ++r) {
            Preconditions.checkState((ratesCSV.getInt(r + 1, 0) == r ? 1 : 0) != 0, (Object)"Rates CSV out of order or not 0-based");
            rates[r] = ratesCSV.getDouble(r + 1, 1);
        }
        return rates;
    }

    @Override
    public final void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        Preconditions.checkNotNull(this.archive, (Object)"archive must be set before initialization");
        if (this.rupSet == null) {
            this.rupSet = this.archive.getModule(FaultSystemRupSet.class);
        }
        Preconditions.checkNotNull((Object)this.rupSet, (Object)"Rupture set not found in archive");
        if (this.verbose) {
            System.out.println("\tLoading rates CSV...");
        }
        CSVFile<String> ratesCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, RATES_FILE_NAME);
        this.rates = FaultSystemSolution.loadRatesCSV(ratesCSV);
        Preconditions.checkState((this.rates.length == this.rupSet.getNumRuptures() ? 1 : 0) != 0, (Object)"Unexpected number of rows in rates CSV");
        if (this.archive != null) {
            if (!this.hasAvailableModule(GridSourceProvider.class)) {
                if (input.hasEntry(entryPrefix + "grid_mech_weights.csv")) {
                    try {
                        System.out.println("Trying to load unlisted MFDGridSourceProvider module");
                        this.archive.loadUnlistedModule(MFDGridSourceProvider.Default.class, entryPrefix, this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (input.hasEntry(entryPrefix + "grid_sources.csv")) {
                    try {
                        System.out.println("Trying to load unlisted GridSourceList module");
                        this.archive.loadUnlistedModule(GridSourceList.Precomputed.class, entryPrefix, this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (input.hasEntry(entryPrefix + "rup_mfds.csv") && !this.hasAvailableModule(RupMFDsModule.class)) {
                try {
                    System.out.println("Trying to load unlisted RupMFDsModule module");
                    this.archive.loadUnlistedModule(RupMFDsModule.class, entryPrefix, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (input.hasEntry(entryPrefix + "sub_seismo_on_fault_mfds.csv") && !this.hasAvailableModule(SubSeismoOnFaultMFDs.class)) {
                try {
                    System.out.println("Trying to load unlisted SubSeismoOnFaultMFDs module");
                    this.archive.loadUnlistedModule(SubSeismoOnFaultMFDs.class, entryPrefix, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public final Class<? extends ArchivableModule> getLoadingClass() {
        return FaultSystemSolution.class;
    }

    @Override
    public void setParent(ModuleArchive<OpenSHA_Module> parent) throws IllegalStateException {
        FaultSystemSolution oSol = parent.getModule(FaultSystemSolution.class, false);
        Preconditions.checkState((oSol == null || oSol == this ? 1 : 0) != 0);
        this.archive = parent;
    }

    @Override
    public ModuleArchive<OpenSHA_Module> getParent() {
        return this.archive;
    }

    public FaultSystemSolution copy(ModuleArchive<OpenSHA_Module> newArchive) throws IllegalStateException {
        FaultSystemRupSet oRupSet = newArchive.getModule(FaultSystemRupSet.class);
        if (oRupSet == null) {
            newArchive.addModule(this.rupSet);
        } else {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(oRupSet));
        }
        FaultSystemRupSet copyRS = newArchive.getModule(FaultSystemRupSet.class);
        Preconditions.checkNotNull((Object)copyRS);
        FaultSystemSolution copy = new FaultSystemSolution(copyRS, Arrays.copyOf(this.rates, this.rates.length));
        this.loadAllAvailableModules();
        for (final OpenSHA_Module module : this.getModules(true)) {
            copy.addAvailableModule((Callable<OpenSHA_Module>)new Callable<OpenSHA_Module>(){
                final /* synthetic */ FaultSystemSolution this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public OpenSHA_Module call() throws Exception {
                    return module;
                }
            }, module.getClass());
        }
        copy.loadAllAvailableModules();
        newArchive.addModule(copy);
        return copy;
    }

    public FaultSystemRupSet getRupSet() {
        return this.rupSet;
    }

    public double getRateForRup(int rupIndex) {
        return this.rates[rupIndex];
    }

    public double[] getRateForAllRups() {
        return this.rates;
    }

    public double getTotalRateForAllFaultSystemRups() {
        double totRate = 0.0;
        for (double rate : this.getRateForAllRups()) {
            totRate += rate;
        }
        return totRate;
    }

    public String getInfoString() {
        InfoModule info = this.getModule(InfoModule.class);
        if (info != null) {
            return info.getText();
        }
        return null;
    }

    public void setInfoString(String info) {
        if (info == null) {
            this.removeModuleInstances(InfoModule.class);
        } else {
            this.addModule(new InfoModule(info));
        }
    }

    public GridSourceProvider getGridSourceProvider() {
        return this.getModule(GridSourceProvider.class);
    }

    public void setGridSourceProvider(GridSourceProvider gridSourceProvider) {
        this.addModule(gridSourceProvider);
    }

    public void setShowProgress(boolean showProgress) {
        this.rupSet.setShowProgress(showProgress);
    }

    public void clearCache() {
        this.rupSet.clearCache();
        this.clearSolutionCacheOnly();
    }

    public void clearSolutionCacheOnly() {
        this.particRatesCache.clear();
        this.nucleationRatesCache.clear();
        this.totParticRatesCache = null;
        this.paleoVisibleRatesCache = null;
    }

    public double[][] getSectionPairRupRates() {
        double[][] rates = new double[this.rupSet.getNumSections()][this.rupSet.getNumSections()];
        for (int r = 0; r < this.rupSet.getNumRuptures(); ++r) {
            List<Integer> indices = this.rupSet.getSectionsIndicesForRup(r);
            double rate = this.getRateForRup(r);
            if (rate == 0.0) continue;
            for (int s = 1; s < indices.size(); ++s) {
                double[] dArray = rates[indices.get(s - 1)];
                int n = indices.get(s);
                dArray[n] = dArray[n] + rate;
                double[] dArray2 = rates[indices.get(s)];
                int n2 = indices.get(s - 1);
                dArray2[n2] = dArray2[n2] + rate;
            }
        }
        return rates;
    }

    public double calcParticRateForSect(int sectIndex, double magLow, double magHigh) {
        return this.calcParticRateForAllSects(magLow, magHigh)[sectIndex];
    }

    private double doCalcParticRateForSect(int sectIndex, double magLow, double magHigh) {
        double partRate = 0.0;
        RupMFDsModule mfds = this.getModule(RupMFDsModule.class);
        for (int r : this.rupSet.getRupturesForSection(sectIndex)) {
            double mag = this.rupSet.getMagForRup(r);
            DiscretizedFunc mfd = this.getRupMagDist(mfds, r);
            if (mfd == null || mfd.size() == 1) {
                if (!(mag >= magLow) || !(mag < magHigh)) continue;
                partRate += this.getRateForRup(r);
                continue;
            }
            for (Point2D pt : mfd) {
                if (!(pt.getX() >= magLow) || !(pt.getX() < magHigh)) continue;
                partRate += pt.getY();
            }
        }
        return partRate;
    }

    public synchronized double[] calcParticRateForAllSects(double magLow, double magHigh) {
        String key = (float)magLow + "_" + (float)magHigh;
        if (!this.particRatesCache.containsKey(key)) {
            double[] particRates = new double[this.rupSet.getNumSections()];
            CalcProgressBar p = null;
            if (this.rupSet.isShowProgress()) {
                p = new CalcProgressBar("Calculating Participation Rates", "Calculating Participation Rates");
            }
            for (int i = 0; i < particRates.length; ++i) {
                if (p != null) {
                    p.updateProgress(i, particRates.length);
                }
                particRates[i] = this.doCalcParticRateForSect(i, magLow, magHigh);
            }
            if (p != null) {
                p.dispose();
            }
            this.particRatesCache.put(key, particRates);
        }
        return Arrays.copyOf(this.particRatesCache.get(key), this.rupSet.getNumSections());
    }

    public double calcNucleationRateForSect(int sectIndex, double magLow, double magHigh) {
        return this.calcNucleationRateForAllSects(magLow, magHigh)[sectIndex];
    }

    private double doCalcNucleationRateForSect(int sectIndex, double magLow, double magHigh) {
        double nucleationRate = 0.0;
        RupMFDsModule mfds = this.getModule(RupMFDsModule.class);
        for (int r : this.rupSet.getRupturesForSection(sectIndex)) {
            double mag = this.rupSet.getMagForRup(r);
            DiscretizedFunc mfd = this.getRupMagDist(mfds, r);
            if (mfd == null || mfd.size() == 1) {
                if (!(mag >= magLow) || !(mag < magHigh)) continue;
                double rate = this.getRateForRup(r);
                double sectArea = this.rupSet.getAreaForSection(sectIndex);
                double rupArea = this.rupSet.getAreaForRup(r);
                nucleationRate += rate * (sectArea / rupArea);
                continue;
            }
            double sectArea = this.rupSet.getAreaForSection(sectIndex);
            double rupArea = this.rupSet.getAreaForRup(r);
            for (Point2D pt : mfd) {
                if (!(pt.getX() >= magLow) || !(pt.getX() < magHigh)) continue;
                nucleationRate += pt.getY() * (sectArea / rupArea);
            }
        }
        return nucleationRate;
    }

    public synchronized double[] calcNucleationRateForAllSects(double magLow, double magHigh) {
        String key = (float)magLow + "_" + (float)magHigh;
        if (!this.nucleationRatesCache.containsKey(key)) {
            double[] nucleationRates = new double[this.rupSet.getNumSections()];
            CalcProgressBar p = null;
            if (this.rupSet.isShowProgress()) {
                p = new CalcProgressBar("Calculating Nucleation Rates", "Calculating Participation Rates");
            }
            for (int i = 0; i < nucleationRates.length; ++i) {
                if (p != null) {
                    p.updateProgress(i, nucleationRates.length);
                }
                nucleationRates[i] = this.doCalcNucleationRateForSect(i, magLow, magHigh);
            }
            if (p != null) {
                p.dispose();
            }
            this.nucleationRatesCache.put(key, nucleationRates);
        }
        return Arrays.copyOf(this.nucleationRatesCache.get(key), this.rupSet.getNumSections());
    }

    public double calcTotParticRateForSect(int sectIndex) {
        return this.calcTotParticRateForAllSects()[sectIndex];
    }

    private double doCalcTotParticRateForSect(int sectIndex) {
        double partRate = 0.0;
        for (int r : this.rupSet.getRupturesForSection(sectIndex)) {
            partRate += this.getRateForRup(r);
        }
        return partRate;
    }

    public synchronized double[] calcTotParticRateForAllSects() {
        if (this.totParticRatesCache == null) {
            this.totParticRatesCache = new double[this.rupSet.getNumSections()];
            CalcProgressBar p = null;
            if (this.rupSet.isShowProgress()) {
                p = new CalcProgressBar("Calculating Total Participation Rates", "Calculating Total Participation Rates");
            }
            for (int i = 0; i < this.totParticRatesCache.length; ++i) {
                if (p != null) {
                    p.updateProgress(i, this.totParticRatesCache.length);
                }
                this.totParticRatesCache[i] = this.doCalcTotParticRateForSect(i);
            }
            if (p != null) {
                p.dispose();
            }
        }
        return Arrays.copyOf(this.totParticRatesCache, this.rupSet.getNumSections());
    }

    public double calcTotPaleoVisibleRateForSect(int sectIndex, PaleoProbabilityModel paleoProbModel) {
        double[] paleoRates;
        if (this.paleoVisibleRatesCache != null && (paleoRates = this.paleoVisibleRatesCache.get(paleoProbModel)) != null) {
            return paleoRates[sectIndex];
        }
        return this.doCalcTotPaleoVisibleRateForSect(sectIndex, paleoProbModel);
    }

    private double doCalcTotPaleoVisibleRateForSect(int sectIndex, PaleoProbabilityModel paleoProbModel) {
        double partRate = 0.0;
        for (int r : this.rupSet.getRupturesForSection(sectIndex)) {
            partRate += this.getRateForRup(r) * paleoProbModel.getProbPaleoVisible(this.rupSet, r, sectIndex);
        }
        return partRate;
    }

    public synchronized double[] calcTotPaleoVisibleRateForAllSects(PaleoProbabilityModel paleoProbModel) {
        double[] paleoRates;
        if (this.paleoVisibleRatesCache == null) {
            this.paleoVisibleRatesCache = Maps.newHashMap();
        }
        if ((paleoRates = this.paleoVisibleRatesCache.get(paleoProbModel)) == null) {
            paleoRates = new double[this.rupSet.getNumSections()];
            this.paleoVisibleRatesCache.put(paleoProbModel, paleoRates);
            CalcProgressBar p = null;
            if (this.rupSet.isShowProgress()) {
                p = new CalcProgressBar("Calculating Paleo Visible Rates", "Calculating Paleo Visible Rates");
            }
            for (int i = 0; i < paleoRates.length; ++i) {
                if (p != null) {
                    p.updateProgress(i, paleoRates.length);
                }
                paleoRates[i] = this.doCalcTotPaleoVisibleRateForSect(i, paleoProbModel);
            }
            if (p != null) {
                p.dispose();
            }
        }
        return Arrays.copyOf(paleoRates, paleoRates.length);
    }

    public SummedMagFreqDist calcNucleationMFD_forParentSect(int parentSectionID, double minMag, double maxMag, int numMag) {
        SummedMagFreqDist mfd = new SummedMagFreqDist(minMag, maxMag, numMag);
        for (int sectIndex = 0; sectIndex < this.rupSet.getNumSections(); ++sectIndex) {
            if (this.rupSet.getFaultSectionData(sectIndex).getParentSectionId() != parentSectionID) continue;
            IncrementalMagFreqDist subMFD = this.calcNucleationMFD_forSect(sectIndex, minMag, maxMag, numMag);
            mfd.addIncrementalMagFreqDist(subMFD);
        }
        return mfd;
    }

    public IncrementalMagFreqDist calcNucleationMFD_forSect(int sectIndex, double minMag, double maxMag, int numMag) {
        return this.calcNucleationMFD_forSect(sectIndex, this.rupSet.getRupturesForSection(sectIndex), minMag, maxMag, numMag);
    }

    public IncrementalMagFreqDist calcNucleationMFD_forSect(int sectIndex, Collection<Integer> rups, double minMag, double maxMag, int numMag) {
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, maxMag, numMag);
        RupMFDsModule mfds = this.getModule(RupMFDsModule.class);
        if (rups != null) {
            double sectArea = this.rupSet.getAreaForSection(sectIndex);
            for (int r : rups) {
                double nucleationScalar = sectArea / this.rupSet.getAreaForRup(r);
                DiscretizedFunc rupMagDist = this.getRupMagDist(mfds, r);
                if (rupMagDist == null) {
                    mfd.addResampledMagRate(this.rupSet.getMagForRup(r), this.getRateForRup(r) * nucleationScalar, true);
                    continue;
                }
                for (Point2D pt : rupMagDist) {
                    mfd.addResampledMagRate(pt.getX(), pt.getY() * nucleationScalar, true);
                }
            }
        }
        return mfd;
    }

    public IncrementalMagFreqDist calcParticipationMFD_forParentSect(int parentSectionID, double minMag, double maxMag, int numMag) {
        return this.calcParticipationMFD_forRups(this.rupSet.getRupturesForParentSection(parentSectionID), minMag, maxMag, numMag);
    }

    public IncrementalMagFreqDist calcParticipationMFD_forRups(Collection<Integer> rupIndexes, double minMag, double maxMag, int numMag) {
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, maxMag, numMag);
        RupMFDsModule mfds = this.getModule(RupMFDsModule.class);
        if (rupIndexes != null) {
            for (int r : rupIndexes) {
                DiscretizedFunc rupMagDist = this.getRupMagDist(mfds, r);
                if (rupMagDist == null) {
                    mfd.addResampledMagRate(this.rupSet.getMagForRup(r), this.getRateForRup(r), true);
                    continue;
                }
                for (Point2D pt : rupMagDist) {
                    mfd.addResampledMagRate(pt.getX(), pt.getY(), true);
                }
            }
        }
        return mfd;
    }

    public IncrementalMagFreqDist calcParticipationMFD_forSect(int sectIndex, double minMag, double maxMag, int numMag) {
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, maxMag, numMag);
        List<Integer> rups = this.rupSet.getRupturesForSection(sectIndex);
        RupMFDsModule mfds = this.getModule(RupMFDsModule.class);
        if (rups != null) {
            for (int r : rups) {
                DiscretizedFunc rupMagDist = this.getRupMagDist(mfds, r);
                if (rupMagDist == null) {
                    mfd.addResampledMagRate(this.rupSet.getMagForRup(r), this.getRateForRup(r), true);
                    continue;
                }
                for (Point2D pt : rupMagDist) {
                    mfd.addResampledMagRate(pt.getX(), pt.getY(), true);
                }
            }
        }
        return mfd;
    }

    public IncrementalMagFreqDist calcTotalNucleationMFD(double minMag, double maxMag, double delta) {
        return this.calcNucleationMFD_forRegion(null, minMag, maxMag, delta, true);
    }

    public IncrementalMagFreqDist calcNucleationMFD_forRegion(Region region, double minMag, double maxMag, double delta, boolean traceOnly) {
        return this.calcNucleationMFD_forRegion(region, minMag, maxMag, delta, traceOnly, null);
    }

    public IncrementalMagFreqDist calcNucleationMFD_forRegion(Region region, double minMag, double maxMag, double delta, boolean traceOnly, TectonicRegionType trt) {
        int numMag = (int)((maxMag - minMag) / delta + 0.5) + 1;
        return this.calcNucleationMFD_forRegion(region, minMag, maxMag, numMag, traceOnly, trt);
    }

    public IncrementalMagFreqDist calcNucleationMFD_forRegion(Region region, double minMag, double maxMag, int numMag, boolean traceOnly) {
        return this.calcNucleationMFD_forRegion(region, minMag, maxMag, numMag, traceOnly, (TectonicRegionType)null);
    }

    public IncrementalMagFreqDist calcNucleationMFD_forRegion(Region region, double minMag, double maxMag, int numMag, boolean traceOnly, TectonicRegionType trt) {
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, maxMag, numMag);
        double[] fractRupsInside = null;
        if (region != null) {
            fractRupsInside = this.rupSet.getFractRupsInsideRegion(region, traceOnly);
        }
        RupSetTectonicRegimes trts = null;
        if (trt != null) {
            trts = this.getRupSet().requireModule(RupSetTectonicRegimes.class);
        }
        RupMFDsModule mfds = this.getModule(RupMFDsModule.class);
        for (int r = 0; r < this.rupSet.getNumRuptures(); ++r) {
            double fractInside = 1.0;
            if (region != null) {
                fractInside = fractRupsInside[r];
            }
            if (trt != null && trt != trts.get(r) || !(fractInside > 0.0)) continue;
            DiscretizedFunc rupMagDist = this.getRupMagDist(mfds, r);
            if (rupMagDist == null) {
                mfd.addResampledMagRate(this.rupSet.getMagForRup(r), this.getRateForRup(r) * fractInside, true);
                continue;
            }
            for (Point2D pt : rupMagDist) {
                mfd.addResampledMagRate(pt.getX(), pt.getY() * fractInside, true);
            }
        }
        return mfd;
    }

    private DiscretizedFunc getRupMagDist(RupMFDsModule mfds, int rupIndex) {
        if (mfds != null) {
            return mfds.getRuptureMFD(rupIndex);
        }
        return null;
    }

    public double getTotalFaultSolutionMomentRate() {
        double totalSolutionMoment = 0.0;
        for (int rup = 0; rup < this.rupSet.getNumRuptures(); ++rup) {
            totalSolutionMoment += this.getRateForRup(rup) * MagUtils.magToMoment(this.rupSet.getMagForRup(rup));
        }
        return totalSolutionMoment;
    }

    public static void main(String[] args) throws Exception {
        File baseDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets");
        File inputFile = new File(baseDir, "fm3_1_ucerf3.zip");
        File destFile = new File("/tmp/new_format_u3.zip");
        U3FaultSystemSolution orig = U3FaultSystemIO.loadSol(inputFile);
        orig.getArchive().write(destFile);
        FaultSystemSolution loaded = FaultSystemSolution.load(destFile);
        Preconditions.checkState((boolean)orig.rupSet.isEquivalentTo(loaded.rupSet));
    }
}

