/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dom4j.Document;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRuptureBuilder;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.NoJumpsFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.NoProxyFaultConnectionsFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.SplayConnectionsOnlyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.NetRuptureCoulombFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.CumulativeProbPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CoulombSectRatioProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeCoulombProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeSlipRateProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.AdaptiveClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveBilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveUnilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.NoConnectivityStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.PlausibleClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.SectCountAdaptiveRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCache;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.inversion.coulomb.CoulombRates;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class RuptureSets {
    private static Map<String, RupSetScalingRelationship> scaleOptions = null;

    public static List<? extends FaultSection> getNSHM23SubSects(String state) throws IOException {
        return GeoJSONFaultReader.buildNSHM23SubSects(state);
    }

    public static RupSetSubsectioningModel getDefaultSubSectModel(RupSetFaultModel fm) {
        if (fm instanceof RupSetSubsectioningModel) {
            return (RupSetSubsectioningModel)((Object)fm);
        }
        RupSetDeformationModel defaultDM = fm.getDefaultDeformationModel();
        if (defaultDM instanceof RupSetSubsectioningModel) {
            return (RupSetSubsectioningModel)((Object)defaultDM);
        }
        return SubSectionBuilder.DEAFULT_BUILDER;
    }

    static RupSetConfig deserializeConfig(Class<? extends RupSetConfig> clazz, List<? extends FaultSection> subSects, RupSetScalingRelationship scale, File jsonFile) throws IOException {
        return RuptureSets.deserializeConfig(clazz, subSects, scale, new BufferedReader(new FileReader(jsonFile)));
    }

    static RupSetConfig deserializeConfig(Class<? extends RupSetConfig> clazz, List<? extends FaultSection> subSects, RupSetScalingRelationship scale, Reader jsonReader) {
        Gson gson = RuptureSets.buildGson();
        RupSetConfig config = (RupSetConfig)gson.fromJson(jsonReader, clazz);
        config.init(subSects, scale);
        return config;
    }

    static void serializeConfig(RupSetConfig config, File jsonFile) throws IOException {
        RuptureSets.serializeConfig(config, new BufferedWriter(new FileWriter(jsonFile)));
    }

    static void serializeConfig(RupSetConfig config, Writer jsonWriter) throws IOException {
        Gson gson = RuptureSets.buildGson();
        gson.toJson((Object)config, (Appendable)jsonWriter);
        jsonWriter.close();
    }

    private static Gson buildGson() {
        return new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().serializeSpecialFloatingPointValues().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, RupSetScalingRelationship> getScalingRelOptions() {
        if (scaleOptions != null) return scaleOptions;
        Class<RuptureSets> clazz = RuptureSets.class;
        synchronized (RuptureSets.class) {
            if (scaleOptions != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return scaleOptions;
            }
            LinkedHashMap<String, RupSetScalingRelationship> ret = new LinkedHashMap<String, RupSetScalingRelationship>();
            for (ScalingRelationships scalingRelationships : ScalingRelationships.values()) {
                if (!(scalingRelationships.getNodeWeight(null) > 0.0)) continue;
                ret.put(scalingRelationships.name(), scalingRelationships);
            }
            ret.put(ScalingRelationships.AVE_UCERF2.name(), ScalingRelationships.AVE_UCERF2);
            ret.put(ScalingRelationships.MEAN_UCERF3.name(), ScalingRelationships.MEAN_UCERF3);
            for (Enum enum_ : NSHM23_ScalingRelationships.values()) {
                if (!(enum_.getNodeWeight(null) > 0.0)) continue;
                ret.put(enum_.name(), (RupSetScalingRelationship)((Object)enum_));
            }
            ret.put("MEAN_NSHM23", NSHM23_ScalingRelationships.AVERAGE);
            scaleOptions = ret;
            // ** MonitorExit[var0] (shouldn't be in output)
            return scaleOptions;
        }
    }

    private static Options createOptions(Presets preset) {
        Options ops = new Options();
        ops.addOption(FaultSysTools.helpOption());
        ops.addOption(FaultSysTools.threadsOption());
        Option subSectsOption = new Option("s", "sub-sections", true, "Path to GeoJSON file containing subsections from which to build a rupture set. Must supply this or a UCERF3 fault model (via --fault-model)");
        subSectsOption.setRequired(false);
        ops.addOption(subSectsOption);
        Option faultModelOption = new Option("f", "fault-model", true, "UCERF3 Fault Model, used to fetch UCERF3 subsections as an alternative to --sub-sections. Options: " + FaultSysTools.enumOptions(FaultModels.class));
        faultModelOption.setRequired(false);
        ops.addOption(faultModelOption);
        Option scaleOption = new Option("sc", "scale", true, "Scaling relationship to use (for rupture magnitudes & average slips). Options: " + RuptureSets.getScalingRelOptions().keySet().stream().collect(Collectors.joining(", ")));
        scaleOption.setRequired(true);
        ops.addOption(scaleOption);
        Option presetOption = new Option("p", "preset", true, "Rupture set plausibility configuration preset. Presets may have their own command line options, which can be seen by selecting them and supplying the --help argument. Options: " + FaultSysTools.enumOptions(Presets.class));
        presetOption.setRequired(true);
        ops.addOption(presetOption);
        if (preset != null) {
            preset.addExtraOptions(ops);
        }
        Option configOption = new Option("c", "config", true, "Rupture set plausibility configuration JSON file to override default parameters for the selected preset.");
        configOption.setRequired(false);
        ops.addOption(configOption);
        Option wcOption = new Option("wc", "write-config", false, "Flag to write the default configuration JSON file for the given preset instead of a rupture set, which can then be edited and passed back in with the --config option when building a rupture set.");
        wcOption.setRequired(false);
        ops.addOption(wcOption);
        Option jdOption = new Option("jd", "jump-distance", true, "Set the maximum jump distance (default varies by preset).");
        jdOption.setRequired(false);
        ops.addOption(jdOption);
        Option outputOption = new Option("of", "output-file", true, "Path to write output Fault System Rupture Set file. If the supplied path is a directory, then a file name will be determined programatically and placed in that directory.");
        outputOption.setRequired(true);
        ops.addOption(outputOption);
        ops.addOption(FaultSysTools.cacheDirOption());
        return ops;
    }

    private static void writePresetDefaults(Presets preset, File file, CommandLine cmd) throws IOException {
        if (file.exists() && file.isDirectory()) {
            file = new File(file, preset.name() + ".json");
        }
        System.out.println("Writing default configuration for " + String.valueOf((Object)preset) + " to: " + file.getAbsolutePath());
        ScalingRelationships scale = ScalingRelationships.MEAN_UCERF3;
        List subSects = List.of();
        RupSetConfig config = preset.build(subSects, scale, cmd);
        RuptureSets.serializeConfig(config, file);
    }

    public static void main(String[] args) {
        Presets preset = null;
        block2: for (int i = 0; i < args.length; ++i) {
            if (!args[i].trim().equals("-p") && !args[i].trim().equals("--preset") || i >= args.length - 1) continue;
            String arg = args[i + 1].trim().toUpperCase();
            for (Presets testPreset : Presets.values()) {
                if (!arg.equals(testPreset.name())) continue;
                preset = testPreset;
                continue block2;
            }
        }
        Options options = RuptureSets.createOptions(preset);
        CommandLine cmd = FaultSysTools.parseOptions(options, args, RuptureSets.class);
        FaultSysTools.checkPrintHelp(options, cmd, RuptureSets.class);
        try {
            RupSetConfig config;
            List<? extends FaultSection> sects;
            if (preset == null) {
                preset = Presets.valueOf(cmd.getOptionValue("preset").trim().toUpperCase());
            }
            System.out.println("Rupture plausibility preset: " + String.valueOf(preset));
            File outputFile = new File(cmd.getOptionValue("output-file"));
            if (cmd.hasOption("write-config")) {
                RuptureSets.writePresetDefaults(preset, outputFile, cmd);
                System.exit(0);
            }
            if (cmd.hasOption("sub-sections")) {
                Preconditions.checkArgument((!cmd.hasOption("fault-model") ? 1 : 0) != 0, (Object)"Shouldn't supply both --sub-sections and --fault-model");
                File inputFile = new File(cmd.getOptionValue("sub-sections"));
                Preconditions.checkState((boolean)inputFile.exists(), (String)"Input file doesn't exist: %s", (Object)inputFile.getAbsolutePath());
                String fName = inputFile.getName().trim().toLowerCase();
                if (fName.endsWith(".xml")) {
                    Document doc = XMLUtils.loadDocument(inputFile);
                    sects = U3FaultSystemIO.fsDataFromXML(doc.getRootElement());
                } else {
                    if (!fName.endsWith(".json") && !fName.endsWith(".geojson")) {
                        System.err.println("Warning: expected a GeoJSON file, but input file has an unexpected extension: " + inputFile.getName() + "\nWill attemp to parse as GeoJSON anyway. See file format details at https://opensha.org/Geospatial-File-Formats");
                    }
                    sects = GeoJSONFaultReader.readFaultSections(inputFile);
                }
            } else {
                Preconditions.checkArgument((boolean)cmd.hasOption("fault-model"), (Object)"Must supply either --sub-sections or --fault-model");
                String fmStr = cmd.getOptionValue("fault-model");
                FaultModels fm = FaultModels.valueOf(fmStr.trim().toUpperCase());
                Preconditions.checkNotNull((Object)fm, (String)"Unknown fault model: %s", (Object)fmStr);
                sects = fm.getDefaultDeformationModel().build(fm, RuptureSets.getDefaultSubSectModel(fm), null);
            }
            System.out.println("Loaded " + sects.size() + " sub-sections");
            for (int i = 0; i < sects.size(); ++i) {
                int id = sects.get(i).getSectionId();
                Preconditions.checkState((id == i ? 1 : 0) != 0, (String)"Subsections must be listed in order of increasing ID, and IDs must be 0-based and contiguous. Bad ID=%s at index=%s.", (int)id, (int)i);
            }
            Preconditions.checkArgument((boolean)cmd.hasOption("scale"), (Object)"Must supply scaling relationship (via --scale option)");
            RupSetScalingRelationship scale = RuptureSets.getScalingRelOptions().get(cmd.getOptionValue("scale"));
            System.out.println("Scaling relationship: " + String.valueOf(scale));
            if (cmd.hasOption("config")) {
                File jsonFile = new File(cmd.getOptionValue("config"));
                Preconditions.checkArgument((boolean)jsonFile.exists(), (String)"JSON configuration file doesn't exist: %s", (Object)jsonFile.getAbsolutePath());
                config = preset.deserialize(sects, scale, jsonFile);
            } else {
                config = preset.build(sects, scale, cmd);
            }
            if (cmd.hasOption("jump-distance")) {
                config.setMaxJumpDist(Double.parseDouble(cmd.getOptionValue("jump-distance")));
            }
            File cacheDir = FaultSysTools.getCacheDir(cmd);
            config.setCacheDir(cacheDir);
            config.setAutoCache(cacheDir != null && cacheDir.exists());
            FaultSystemRupSet rupSet = config.build(FaultSysTools.getNumThreads(cmd));
            if (outputFile.exists() && outputFile.isDirectory()) {
                outputFile = new File(outputFile, config.getRupSetFileName());
            }
            rupSet.write(outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static abstract class RupSetConfig {
        private transient File cacheDir;
        private transient File distAzCacheFile;
        private transient int numAzCached = 0;
        private transient int numDistCached = 0;
        private transient SectionDistanceAzimuthCalculator distAzCalc;
        private boolean autoCache = true;
        private transient int numThreads = 1;

        public abstract List<? extends FaultSection> getSubSects();

        public abstract PlausibilityConfiguration getPlausibilityConfig();

        public abstract RuptureGrowingStrategy getGrowingStrategy();

        public abstract String getRupSetFileName();

        public abstract RupSetScalingRelationship getScalingRelationship();

        protected abstract void init(List<? extends FaultSection> var1, RupSetScalingRelationship var2);

        public synchronized SectionDistanceAzimuthCalculator getDistAzCalc() {
            if (this.distAzCalc == null) {
                List<? extends FaultSection> sects = this.getSubSects();
                this.distAzCalc = new SectionDistanceAzimuthCalculator(sects);
                File cacheDir = this.getCacheDir();
                if (cacheDir != null && cacheDir.exists()) {
                    String name = this.distAzCalc.getDefaultCacheFileName();
                    this.distAzCacheFile = new File(cacheDir, name);
                    if (this.distAzCacheFile.exists()) {
                        try {
                            this.distAzCalc.loadCacheFile(this.distAzCacheFile);
                            this.numAzCached = this.distAzCalc.getNumCachedAzimuths();
                            this.numDistCached = this.distAzCalc.getNumCachedDistances();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return this.distAzCalc;
        }

        protected File getCacheDir() {
            if (this.cacheDir == null) {
                this.cacheDir = FaultSysTools.getCacheDir();
            }
            return this.cacheDir;
        }

        public void setCacheDir(File cacheDir) {
            this.cacheDir = cacheDir;
        }

        public void setAutoCache(boolean autoCache) {
            this.autoCache = autoCache;
        }

        public boolean isAutoCache() {
            return this.autoCache;
        }

        public void updateCache() {
            if (this.distAzCacheFile != null && (this.numAzCached < this.distAzCalc.getNumCachedAzimuths() || this.numDistCached < this.distAzCalc.getNumCachedDistances())) {
                System.out.println("Writing dist/az cache to " + this.distAzCacheFile.getAbsolutePath());
                try {
                    this.distAzCalc.writeCacheFile(this.distAzCacheFile);
                    this.numAzCached = this.distAzCalc.getNumCachedAzimuths();
                    this.numDistCached = this.distAzCalc.getNumCachedDistances();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        protected int getNumThreads() {
            return this.numThreads;
        }

        public abstract void setMaxJumpDist(double var1);

        public FaultSystemRupSet build(int numThreads) {
            this.numThreads = numThreads;
            PlausibilityConfiguration config = this.getPlausibilityConfig();
            System.out.println("Initializing connections w/ " + numThreads + " threads...");
            if (numThreads > 1) {
                config.getConnectionStrategy().checkBuildThreaded(numThreads);
            } else {
                config.getConnectionStrategy().getClusters();
            }
            ClusterRuptureBuilder builder = new ClusterRuptureBuilder(config);
            System.out.println("Building ruptures with " + numThreads + " threads...");
            Stopwatch watch = Stopwatch.createStarted();
            List<ClusterRupture> rups = builder.build(this.getGrowingStrategy(), numThreads);
            watch.stop();
            long millis = watch.elapsed(TimeUnit.MILLISECONDS);
            double secs = (double)millis / 1000.0;
            double mins = secs / 60.0;
            DecimalFormat timeDF = new DecimalFormat("0.00");
            System.out.println("Built " + ClusterRuptureBuilder.countDF.format(rups.size()) + " ruptures in " + timeDF.format(secs) + " secs = " + timeDF.format(mins) + " mins. Total rate: " + ClusterRuptureBuilder.rupRateStr(rups.size(), millis));
            if (this.isAutoCache()) {
                this.updateCache();
            }
            return ClusterRuptureBuilder.buildClusterRupSet(this.getScalingRelationship(), this.getSubSects(), this.getPlausibilityConfig(), rups);
        }
    }

    private static enum Presets {
        UCERF3(U3RupSetConfig.class){

            @Override
            public RupSetConfig build(List<? extends FaultSection> subSects, RupSetScalingRelationship scale, CommandLine cmd) {
                return new U3RupSetConfig(subSects, scale);
            }
        }
        ,
        COULOMB(CoulombRupSetConfig.class){

            @Override
            public RupSetConfig build(List<? extends FaultSection> subSects, RupSetScalingRelationship scale, CommandLine cmd) {
                CoulombRupSetConfig config = new CoulombRupSetConfig(subSects, null, scale);
                config.setBilateral(cmd.hasOption("bilateral"));
                if (cmd.hasOption("bilateral-variation-mode")) {
                    config.setBilateralVariationMode(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.valueOf(cmd.getOptionValue("bilateral-variation-mode")));
                }
                if (cmd.hasOption("max-length")) {
                    config.setMaxRupLength(Double.parseDouble(cmd.getOptionValue("max-length")));
                }
                return config;
            }

            @Override
            public void addExtraOptions(Options ops) {
                ops.addOption(null, "max-length", true, "Maximum rupture length (in km).");
                ops.addOption(null, "bilateral", false, "Flag to enable bilateral rupture. Also see --bilateral-variation-mode.");
                ops.addOption(null, "bilateral-variation-mode", true, "Bilateral variation mode, see figure 13 of Milner et al. (2022). Options:" + FaultSysTools.enumOptions(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.class));
            }
        }
        ,
        SIMPLE_AZIMUTHAL(SimpleAzimuthalRupSetConfig.class){

            @Override
            public RupSetConfig build(List<? extends FaultSection> subSects, RupSetScalingRelationship scale, CommandLine cmd) {
                return new SimpleAzimuthalRupSetConfig(subSects, scale);
            }
        }
        ,
        SEGMENTED(FullySegmentedRupSetConfig.class){

            @Override
            public RupSetConfig build(List<? extends FaultSection> subSects, RupSetScalingRelationship scale, CommandLine cmd) {
                return new FullySegmentedRupSetConfig(subSects, scale);
            }
        };

        private Class<? extends RupSetConfig> configClass;

        private Presets(Class<? extends RupSetConfig> configClass) {
            this.configClass = configClass;
        }

        public abstract RupSetConfig build(List<? extends FaultSection> var1, RupSetScalingRelationship var2, CommandLine var3);

        public void addExtraOptions(Options ops) {
        }

        public RupSetConfig deserialize(List<? extends FaultSection> subSects, RupSetScalingRelationship scale, Reader jsonReader) {
            return RuptureSets.deserializeConfig(this.configClass, subSects, scale, jsonReader);
        }

        public RupSetConfig deserialize(List<? extends FaultSection> subSects, RupSetScalingRelationship scale, File jsonFile) throws IOException {
            return RuptureSets.deserializeConfig(this.configClass, subSects, scale, jsonFile);
        }
    }

    public static class FullySegmentedRupSetConfig
    extends RupSetConfig {
        private List<? extends FaultSection> subSects;
        private RupSetScalingRelationship scale;
        @Expose
        private int minSectsPerParent = 1;

        public FullySegmentedRupSetConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.init(subSects, scale);
        }

        public void setMinSectsPerParent(int minSectsPerParent) {
            this.minSectsPerParent = minSectsPerParent;
        }

        @Override
        protected void init(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.subSects = subSects;
            this.scale = scale;
        }

        @Override
        public List<? extends FaultSection> getSubSects() {
            return this.subSects;
        }

        @Override
        public PlausibilityConfiguration getPlausibilityConfig() {
            NoConnectivityStrategy connStrat = new NoConnectivityStrategy(this.getSubSects(), this.getDistAzCalc());
            PlausibilityConfiguration.Builder builder = PlausibilityConfiguration.builder((ClusterConnectionStrategy)connStrat, this.subSects);
            builder.add(new NoJumpsFilter());
            if (this.minSectsPerParent > 1) {
                builder.minSectsPerParent(this.minSectsPerParent, false, false);
            }
            return builder.build();
        }

        @Override
        public RuptureGrowingStrategy getGrowingStrategy() {
            ExhaustiveUnilateralRuptureGrowingStrategy strat = new ExhaustiveUnilateralRuptureGrowingStrategy();
            return strat;
        }

        @Override
        public String getRupSetFileName() {
            return "segmented.zip";
        }

        @Override
        public RupSetScalingRelationship getScalingRelationship() {
            return this.scale;
        }

        @Override
        public void setMaxJumpDist(double maxJumpDist) {
        }
    }

    public static class CoulombRupSetConfig
    extends RupSetConfig {
        private List<? extends FaultSection> subSects;
        private String fmPrefix;
        private RupSetScalingRelationship scale;
        @Expose
        private int minSectsPerParent = 2;
        @Expose
        private boolean noIndirectPaths = true;
        @Expose
        private float slipRateProb = 0.05f;
        @Expose
        private boolean slipIncludeLonger = false;
        @Expose
        private float cffFractInts = 0.75f;
        @Expose
        private int cffRatioN = 2;
        @Expose
        private float cffRatioThresh = 0.5f;
        @Expose
        private float cffRelativeProb = 0.01f;
        @Expose
        private boolean favorableJumps = true;
        @Expose
        private float jumpProbThresh = 0.001f;
        @Expose
        private float cmlRakeThresh = 360.0f;
        @Expose
        private double maxLength = 0.0;
        @Expose
        private double maxJumpDist = 15.0;
        @Expose
        private boolean plausibleConnections = true;
        @Expose
        private double adaptiveMinDist = 6.0;
        @Expose
        private float adaptiveSectFract = 0.1f;
        @Expose
        private boolean bilateral = false;
        @Expose
        private ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations bilateralMode = ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.EQUAL_LEN;
        @Expose
        private boolean splays = false;
        @Expose
        private double stiffGridSpacing = 2.0;
        @Expose
        private double coeffOfFriction = 0.5;
        @Expose
        private boolean connectProxyFaults = true;
        private PlausibilityConfiguration config;
        private RuptureGrowingStrategy growingStrat;
        private String fileName;
        private File stiffnessCacheFile;
        private AggregatedStiffnessCache stiffnessCache;
        private int stiffnessCacheSize;
        private SubSectStiffnessCalculator stiffnessCalc;

        public CoulombRupSetConfig(RupSetFaultModel fm, RupSetScalingRelationship scale) throws IOException {
            this(fm.getDefaultDeformationModel().build(fm, RuptureSets.getDefaultSubSectModel(fm), null), fm.getFilePrefix().toLowerCase(), scale);
        }

        public CoulombRupSetConfig(List<? extends FaultSection> subSects, String fmPrefix, RupSetScalingRelationship scale) {
            this.fmPrefix = fmPrefix;
            this.init(subSects, scale);
        }

        @Override
        protected void init(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.subSects = subSects;
            this.scale = scale;
        }

        @Override
        public List<? extends FaultSection> getSubSects() {
            return this.subSects;
        }

        @Override
        public synchronized PlausibilityConfiguration getPlausibilityConfig() {
            if (this.config == null) {
                this.update();
            }
            return this.config;
        }

        @Override
        public synchronized RuptureGrowingStrategy getGrowingStrategy() {
            if (this.growingStrat == null) {
                this.update();
            }
            return this.growingStrat;
        }

        @Override
        public synchronized String getRupSetFileName() {
            if (this.fileName == null) {
                this.update();
            }
            return this.fileName;
        }

        @Override
        public RupSetScalingRelationship getScalingRelationship() {
            return this.scale;
        }

        public void setMinSectsPerParent(int minSectsPerParent) {
            this.clear();
            this.minSectsPerParent = minSectsPerParent;
        }

        public void setNoIndirectPaths(boolean noIndirectPaths) {
            this.clear();
            this.noIndirectPaths = noIndirectPaths;
        }

        public void setSlipRateProb(float slipRateProb) {
            this.clear();
            this.slipRateProb = slipRateProb;
        }

        public void setSlipIncludeLonger(boolean slipIncludeLonger) {
            this.clear();
            this.slipIncludeLonger = slipIncludeLonger;
        }

        public void setCffFractInts(float cffFractInts) {
            this.clear();
            this.cffFractInts = cffFractInts;
        }

        public void setCffRatioN(int cffRatioN) {
            this.clear();
            this.cffRatioN = cffRatioN;
        }

        public void setCffRatioThresh(float cffRatioThresh) {
            this.clear();
            this.cffRatioThresh = cffRatioThresh;
        }

        public void setCffRelativeProb(float cffRelativeProb) {
            this.clear();
            this.cffRelativeProb = cffRelativeProb;
        }

        public void setFavorableJumps(boolean favorableJumps) {
            this.clear();
            this.favorableJumps = favorableJumps;
        }

        public void setJumpProbThresh(float jumpProbThresh) {
            this.clear();
            this.jumpProbThresh = jumpProbThresh;
        }

        public void setCmlRakeThresh(float cmlRakeThresh) {
            this.clear();
            this.cmlRakeThresh = cmlRakeThresh;
        }

        public void setMaxRupLength(double maxLength) {
            this.clear();
            this.maxLength = maxLength;
        }

        @Override
        public void setMaxJumpDist(double maxJumpDist) {
            this.clear();
            this.maxJumpDist = maxJumpDist;
        }

        public void setPlausibleConnections(boolean plausibleConnections) {
            this.clear();
            this.plausibleConnections = plausibleConnections;
        }

        public void setAdaptiveMinDist(double adaptiveMinDist) {
            this.clear();
            this.adaptiveMinDist = adaptiveMinDist;
        }

        public void setAdaptiveSectFract(float adaptiveSectFract) {
            this.clear();
            this.adaptiveSectFract = adaptiveSectFract;
        }

        public void setBilateral(boolean bilateral) {
            this.clear();
            this.bilateral = bilateral;
        }

        public void setBilateralVariationMode(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations bilateralMode) {
            this.clear();
            this.bilateralMode = bilateralMode;
        }

        public void setSplays(boolean splays) {
            this.clear();
            this.splays = splays;
        }

        public void setStiffGridSpacing(double stiffGridSpacing) {
            this.clear();
            this.stiffGridSpacing = stiffGridSpacing;
        }

        public void setCoeffOfFriction(double coeffOfFriction) {
            this.clear();
            this.coeffOfFriction = coeffOfFriction;
        }

        public void setConnectProxyFaults(boolean connectProxyFaults) {
            this.clear();
            this.connectProxyFaults = connectProxyFaults;
        }

        private synchronized void clear() {
            this.config = null;
            this.growingStrat = null;
            this.fileName = null;
            this.stiffnessCache = null;
            this.stiffnessCacheFile = null;
            this.stiffnessCacheSize = -1;
            this.stiffnessCalc = null;
        }

        @Override
        public void updateCache() {
            if (this.stiffnessCache != null && this.stiffnessCacheFile != null && this.stiffnessCacheSize < this.stiffnessCache.calcCacheSize()) {
                System.out.println("Writing stiffness cache to " + this.stiffnessCacheFile.getAbsolutePath());
                try {
                    this.stiffnessCache.writeCacheFile(this.stiffnessCacheFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("DONE writing stiffness cache");
            }
            super.updateCache();
        }

        public SubSectStiffnessCalculator getStiffnessCalc() {
            if (this.stiffnessCalc == null) {
                this.stiffnessCalc = new SubSectStiffnessCalculator(this.subSects, this.stiffGridSpacing, 30000.0, 30000.0, this.coeffOfFriction, SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP, 1.0);
                this.stiffnessCache = this.stiffnessCalc.getAggregationCache(SubSectStiffnessCalculator.StiffnessType.CFF);
            }
            return this.stiffnessCalc;
        }

        private synchronized void update() {
            ClusterConnectionStrategy connectionStrategy;
            Object outputName;
            SubSectStiffnessCalculator stiffnessCalc = this.getStiffnessCalc();
            File cacheDir = this.getCacheDir();
            if (cacheDir != null && cacheDir.exists()) {
                this.stiffnessCacheFile = new File(cacheDir, this.stiffnessCache.getCacheFileName());
                this.stiffnessCacheSize = 0;
                if (this.stiffnessCacheFile.exists()) {
                    try {
                        this.stiffnessCacheSize = this.stiffnessCache.loadCacheFile(this.stiffnessCacheFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            AggregatedStiffnessCalculator sumAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
            AggregatedStiffnessCalculator fractIntsAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.NUM_POSITIVE, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.NORM_BY_COUNT);
            Object object = outputName = this.fmPrefix == null || this.fmPrefix.isBlank() ? this.subSects.size() + "sects" : this.fmPrefix;
            if (this.stiffGridSpacing != 2.0) {
                outputName = (String)outputName + "_stiff" + new DecimalFormat("0.#").format(this.stiffGridSpacing) + "km";
            }
            if (this.coeffOfFriction != 0.5) {
                outputName = (String)outputName + "_coeff" + (float)this.coeffOfFriction;
            }
            SectionDistanceAzimuthCalculator distAzCalc = this.getDistAzCalc();
            if (this.plausibleConnections) {
                System.out.println("Building plausible connections w/ " + this.getNumThreads() + " threads...");
                DistCutoffClosestSectClusterConnectionStrategy neighborsConnStrat = new DistCutoffClosestSectClusterConnectionStrategy(this.subSects, distAzCalc, 0.1);
                neighborsConnStrat.checkBuildThreaded(this.getNumThreads());
                ArrayList<PlausibilityFilter> connFilters = new ArrayList<PlausibilityFilter>();
                if (!this.connectProxyFaults) {
                    connFilters.add(new NoProxyFaultConnectionsFilter());
                }
                if (this.cffRatioThresh > 0.0f) {
                    connFilters.add(new CumulativeProbabilityFilter(this.cffRatioThresh, new CoulombSectRatioProb(sumAgg, this.cffRatioN, this.favorableJumps, (float)this.maxJumpDist, distAzCalc)));
                    if (this.cffRelativeProb > 0.0f) {
                        connFilters.add(new PathPlausibilityFilter(new CumulativeProbPathEvaluator(this.cffRatioThresh, PlausibilityResult.FAIL_HARD_STOP, new CoulombSectRatioProb(sumAgg, this.cffRatioN, this.favorableJumps, (float)this.maxJumpDist, distAzCalc)), new CumulativeProbPathEvaluator(this.cffRelativeProb, PlausibilityResult.FAIL_HARD_STOP, new RelativeCoulombProb(sumAgg, neighborsConnStrat, false, true, this.favorableJumps, (float)this.maxJumpDist, distAzCalc))));
                    }
                } else if (this.cffRelativeProb > 0.0f) {
                    connFilters.add(new CumulativeProbabilityFilter(this.cffRatioThresh, new RelativeCoulombProb(sumAgg, neighborsConnStrat, false, true, this.favorableJumps, (float)this.maxJumpDist, distAzCalc)));
                }
                if (this.cffFractInts > 0.0f) {
                    connFilters.add(new NetRuptureCoulombFilter(fractIntsAgg, this.cffFractInts));
                }
                connectionStrategy = new PlausibleClusterConnectionStrategy(this.subSects, distAzCalc, this.maxJumpDist, PlausibleClusterConnectionStrategy.JUMP_SELECTOR_DEFAULT, connFilters);
                outputName = (String)outputName + "_plausibleMulti" + new DecimalFormat("0.#").format(this.maxJumpDist) + "km";
                connectionStrategy.checkBuildThreaded(this.getNumThreads());
                System.out.println("DONE building plausible connections");
            } else {
                connectionStrategy = new DistCutoffClosestSectClusterConnectionStrategy(this.subSects, distAzCalc, this.maxJumpDist);
                if (this.maxJumpDist != 5.0) {
                    outputName = (String)outputName + "_" + new DecimalFormat("0.#").format(this.maxJumpDist) + "km";
                }
            }
            if (this.adaptiveMinDist > 0.0 && this.adaptiveMinDist < this.maxJumpDist) {
                connectionStrategy = new AdaptiveClusterConnectionStrategy(connectionStrategy, this.adaptiveMinDist, 1);
                outputName = (String)outputName + "_adaptive" + new DecimalFormat("0.#").format(this.adaptiveMinDist) + "km";
            }
            PlausibilityConfiguration.Builder configBuilder = PlausibilityConfiguration.builder(connectionStrategy, this.subSects);
            if (this.minSectsPerParent > 1) {
                configBuilder.minSectsPerParent(this.minSectsPerParent, true, true);
            }
            if (this.noIndirectPaths) {
                configBuilder.noIndirectPaths(true);
                outputName = (String)outputName + "_direct";
            }
            if (this.cmlRakeThresh > 0.0f) {
                configBuilder.cumulativeRakeChange(this.cmlRakeThresh);
                outputName = (String)outputName + "_cmlRake" + (int)this.cmlRakeThresh;
            }
            if (this.maxLength > 0.0) {
                configBuilder.maxLength(this.maxLength);
                outputName = (String)outputName + "_maxLen" + (int)this.maxLength;
            }
            if (!this.connectProxyFaults) {
                outputName = (String)outputName + "_noProxyConn";
                configBuilder.noProxyConnections();
            }
            if (this.jumpProbThresh > 0.0f) {
                configBuilder.cumulativeProbability(this.jumpProbThresh, new Shaw07JumpDistProb(1.0, 3.0));
                outputName = (String)outputName + "_jumpP" + this.jumpProbThresh;
            }
            if (this.slipRateProb > 0.0f) {
                configBuilder.cumulativeProbability(this.slipRateProb, new RelativeSlipRateProb(connectionStrategy, true, this.slipIncludeLonger));
                outputName = (String)outputName + "_slipP" + this.slipRateProb + "incr";
                if (!this.slipIncludeLonger) {
                    outputName = (String)outputName + "CapDist";
                }
            }
            if (this.cffFractInts > 0.0f) {
                configBuilder.netRupCoulomb(fractIntsAgg, (Range<Float>)Range.greaterThan((Comparable)Float.valueOf(this.cffFractInts)));
                outputName = (String)outputName + "_cff" + this.cffFractInts + "IntsPos";
            }
            ArrayList<CumulativeProbPathEvaluator> combPathEvals = new ArrayList<CumulativeProbPathEvaluator>();
            ArrayList<CallSite> combPathPrefixes = new ArrayList<CallSite>();
            float fractPathsThreshold = 0.0f;
            String fractPathsStr = "";
            float favorableDist = Float.max((float)this.maxJumpDist, 10.0f);
            Object favStr = "";
            if (this.favorableJumps) {
                favStr = "Fav";
                if (favorableDist != (float)this.maxJumpDist) {
                    favStr = (String)favStr + (int)favorableDist;
                }
            }
            if (this.cffRelativeProb > 0.0f) {
                RelativeCoulombProb cffProbCalc = new RelativeCoulombProb(sumAgg, connectionStrategy, false, true, this.favorableJumps, favorableDist, distAzCalc);
                CumulativeProbPathEvaluator cffProbPathEval = new CumulativeProbPathEvaluator(this.cffRelativeProb, PlausibilityResult.FAIL_HARD_STOP, cffProbCalc);
                combPathEvals.add(cffProbPathEval);
                combPathPrefixes.add((CallSite)((Object)("cff" + (String)favStr + "P" + this.cffRelativeProb)));
            }
            if (this.cffRatioThresh > 0.0f) {
                CumulativeProbPathEvaluator cffRatioPatchEval = new CumulativeProbPathEvaluator(this.cffRatioThresh, PlausibilityResult.FAIL_HARD_STOP, new CoulombSectRatioProb(sumAgg, this.cffRatioN, this.favorableJumps, favorableDist, distAzCalc));
                combPathEvals.add(cffRatioPatchEval);
                combPathPrefixes.add((CallSite)((Object)("cff" + (String)favStr + "RatioN" + this.cffRatioN + "P" + this.cffRatioThresh)));
            }
            Preconditions.checkState((combPathEvals.size() == combPathPrefixes.size() ? 1 : 0) != 0);
            if (!combPathEvals.isEmpty()) {
                configBuilder.path(fractPathsThreshold, combPathEvals.toArray(new NucleationClusterEvaluator[0]));
                outputName = (String)outputName + "_";
                if (combPathEvals.size() > 1) {
                    outputName = (String)outputName + "comb" + combPathEvals.size();
                }
                outputName = (String)outputName + fractPathsStr;
                if (fractPathsStr.isEmpty() && combPathEvals.size() == 1) {
                    outputName = (String)outputName + "path";
                } else {
                    outputName = (String)outputName + "Path";
                    if (combPathEvals.size() > 1) {
                        outputName = (String)outputName + "s";
                    }
                }
                outputName = (String)outputName + "_" + Joiner.on((String)"_").join(combPathPrefixes);
            }
            if (this.splays) {
                configBuilder.maxSplays(1);
                outputName = (String)outputName + "_max1Splays";
                configBuilder.splayLength(50.0, false, true, true);
                outputName = (String)outputName + "_splayLen50km";
                configBuilder.splayLength(0.5, true, true, true);
                outputName = (String)outputName + "OrHalf";
                configBuilder.addFirst(new SplayConnectionsOnlyFilter(connectionStrategy, true));
                outputName = (String)outputName + "_splayConn";
            } else {
                configBuilder.maxSplays(0);
            }
            if (this.bilateral) {
                this.growingStrat = new ExhaustiveBilateralRuptureGrowingStrategy(this.bilateralMode, false);
                outputName = (String)outputName + "_bilateral";
            } else {
                this.growingStrat = new ExhaustiveUnilateralRuptureGrowingStrategy();
            }
            if (this.adaptiveSectFract > 0.0f) {
                SectCountAdaptiveRuptureGrowingStrategy adaptiveStrat = new SectCountAdaptiveRuptureGrowingStrategy(this.growingStrat, this.adaptiveSectFract, true, this.minSectsPerParent);
                configBuilder.add(adaptiveStrat.buildConnPointCleanupFilter(connectionStrategy));
                outputName = (String)outputName + "_sectFractGrow" + this.adaptiveSectFract;
                this.growingStrat = adaptiveStrat;
            }
            this.config = configBuilder.build();
            this.fileName = outputName = (String)outputName + ".zip";
        }
    }

    public static class SimpleSubductionRupSetConfig
    extends RupSetConfig {
        private List<? extends FaultSection> subSects;
        private RupSetScalingRelationship scale;
        @Expose
        private float jumpAzimuthChange = 60.0f;
        @Expose
        private int minSectsPerParent = 0;
        @Expose
        private float minAspectRatio = 0.67f;
        @Expose
        private double maxJumpDist = 5.0;
        @Expose
        private float adaptiveSectFract = 0.0f;

        public SimpleSubductionRupSetConfig(RupSetFaultModel fm, RupSetScalingRelationship scale) throws IOException {
            this(fm.getDefaultDeformationModel().build(fm, RuptureSets.getDefaultSubSectModel(fm), null), scale);
        }

        public SimpleSubductionRupSetConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.init(subSects, scale);
        }

        @Override
        protected void init(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.subSects = subSects;
            this.scale = scale;
        }

        @Override
        public List<? extends FaultSection> getSubSects() {
            return this.subSects;
        }

        @Override
        public PlausibilityConfiguration getPlausibilityConfig() {
            SectionDistanceAzimuthCalculator distAzCalc = this.getDistAzCalc();
            if (distAzCalc.getNumCachedDistances() == 0) {
                distAzCalc.setDiscretization(5.0);
            }
            DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(this.getSubSects(), distAzCalc, this.maxJumpDist);
            PlausibilityConfiguration.Builder builder = PlausibilityConfiguration.builder((ClusterConnectionStrategy)connStrat, this.subSects);
            if (this.minSectsPerParent > 1) {
                builder.minSectsPerParent(this.minSectsPerParent, true, true);
            }
            JumpAzimuthChangeFilter.SimpleAzimuthCalc azCalc = new JumpAzimuthChangeFilter.SimpleAzimuthCalc(distAzCalc);
            if (this.jumpAzimuthChange > 0.0f) {
                builder.jumpAzChange(azCalc, this.jumpAzimuthChange);
            }
            if (this.minAspectRatio > 0.0f) {
                builder.minAspectRatio(this.minAspectRatio, true, true);
            }
            return builder.build();
        }

        @Override
        public RuptureGrowingStrategy getGrowingStrategy() {
            RuptureGrowingStrategy strat = new ExhaustiveUnilateralRuptureGrowingStrategy();
            if (this.adaptiveSectFract > 0.0f) {
                strat = new SectCountAdaptiveRuptureGrowingStrategy(strat, this.adaptiveSectFract, true, this.minSectsPerParent);
            }
            return strat;
        }

        @Override
        public String getRupSetFileName() {
            ArrayList<CallSite> elements = new ArrayList<CallSite>();
            if (this.minAspectRatio > 0.0f) {
                elements.add((CallSite)((Object)("aspect" + (int)this.minAspectRatio)));
            }
            if (this.jumpAzimuthChange > 0.0f) {
                elements.add((CallSite)((Object)("jumpAz" + (int)this.jumpAzimuthChange)));
            }
            if (this.minSectsPerParent > 0) {
                elements.add((CallSite)((Object)(this.minSectsPerParent + "sectsPerParent")));
            }
            if (this.adaptiveSectFract > 0.0f) {
                elements.add((CallSite)((Object)("fractGrow" + this.adaptiveSectFract)));
            }
            return Joiner.on((String)"_").join(elements) + ".zip";
        }

        @Override
        public RupSetScalingRelationship getScalingRelationship() {
            return this.scale;
        }

        @Override
        public void setMaxJumpDist(double maxJumpDist) {
            this.maxJumpDist = maxJumpDist;
        }

        public void setMinSectsPerParent(int minSectsPerParent) {
            this.minSectsPerParent = minSectsPerParent;
        }

        public void setAdaptiveSectFract(float adaptiveSectFract) {
            this.adaptiveSectFract = adaptiveSectFract;
        }
    }

    public static class SimpleAzimuthalRupSetConfig
    extends RupSetConfig {
        private List<? extends FaultSection> subSects;
        private RupSetScalingRelationship scale;
        @Expose
        private float jumpAzimuthChange = 60.0f;
        @Expose
        private float totalAzimuthChange = 60.0f;
        @Expose
        private boolean leftLateralFlipAzimuth = true;
        @Expose
        private float cumulativeAzimuthChange = 560.0f;
        @Expose
        private float cumulativeRakeChange = 180.0f;
        @Expose
        private int minSectsPerParent = 2;
        @Expose
        private double maxJumpDist = 5.0;
        @Expose
        private float adaptiveSectFract = 0.0f;

        public SimpleAzimuthalRupSetConfig(RupSetFaultModel fm, RupSetScalingRelationship scale) throws IOException {
            this(fm.getDefaultDeformationModel().build(fm, RuptureSets.getDefaultSubSectModel(fm), null), scale);
        }

        public SimpleAzimuthalRupSetConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.init(subSects, scale);
        }

        @Override
        protected void init(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.subSects = subSects;
            this.scale = scale;
        }

        @Override
        public List<? extends FaultSection> getSubSects() {
            return this.subSects;
        }

        @Override
        public PlausibilityConfiguration getPlausibilityConfig() {
            DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(this.getSubSects(), this.getDistAzCalc(), this.maxJumpDist);
            PlausibilityConfiguration.Builder builder = PlausibilityConfiguration.builder((ClusterConnectionStrategy)connStrat, this.subSects);
            if (this.minSectsPerParent > 0) {
                builder.minSectsPerParent(this.minSectsPerParent, true, true);
            }
            JumpAzimuthChangeFilter.AzimuthCalc azCalc = this.leftLateralFlipAzimuth ? new JumpAzimuthChangeFilter.LeftLateralFlipAzimuthCalc(this.getDistAzCalc(), (Range<Double>)Range.closed((Comparable)Double.valueOf(-45.0), (Comparable)Double.valueOf(45.0))) : new JumpAzimuthChangeFilter.SimpleAzimuthCalc(this.getDistAzCalc());
            if (this.jumpAzimuthChange > 0.0f) {
                builder.jumpAzChange(azCalc, this.jumpAzimuthChange);
            }
            if (this.totalAzimuthChange > 0.0f) {
                builder.totAzChange(azCalc, this.totalAzimuthChange, true, false);
            }
            if (this.cumulativeAzimuthChange > 0.0f) {
                builder.cumulativeAzChange(this.cumulativeAzimuthChange);
            }
            if (this.cumulativeRakeChange > 0.0f) {
                builder.cumulativeRakeChange(this.cumulativeRakeChange);
            }
            return builder.build();
        }

        @Override
        public RuptureGrowingStrategy getGrowingStrategy() {
            RuptureGrowingStrategy strat = new ExhaustiveUnilateralRuptureGrowingStrategy();
            if (this.adaptiveSectFract > 0.0f) {
                strat = new SectCountAdaptiveRuptureGrowingStrategy(strat, this.adaptiveSectFract, true, this.minSectsPerParent);
            }
            return strat;
        }

        @Override
        public String getRupSetFileName() {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (this.jumpAzimuthChange > 0.0f) {
                elements.add("jumpAz" + (int)this.jumpAzimuthChange);
            }
            if (this.totalAzimuthChange > 0.0f) {
                elements.add("totalAz" + (int)this.totalAzimuthChange);
            }
            if (this.leftLateralFlipAzimuth && (this.jumpAzimuthChange > 0.0f || this.totalAzimuthChange > 0.0f)) {
                elements.add("llFlip");
            }
            if (this.cumulativeAzimuthChange > 0.0f) {
                elements.add("cmlAz" + (int)this.cumulativeAzimuthChange);
            }
            if (this.cumulativeRakeChange > 0.0f) {
                elements.add("cmlRake" + (int)this.cumulativeRakeChange);
            }
            if (this.minSectsPerParent > 0) {
                elements.add(this.minSectsPerParent + "sectsPerParent");
            }
            if (this.adaptiveSectFract > 0.0f) {
                elements.add("fractGrow" + this.adaptiveSectFract);
            }
            return Joiner.on((String)"_").join(elements) + ".zip";
        }

        @Override
        public RupSetScalingRelationship getScalingRelationship() {
            return this.scale;
        }

        @Override
        public void setMaxJumpDist(double maxJumpDist) {
            this.maxJumpDist = maxJumpDist;
        }

        public void setMinSectsPerParent(int minSectsPerParent) {
            this.minSectsPerParent = minSectsPerParent;
        }

        public void setAdaptiveSectFract(float adaptiveSectFract) {
            this.adaptiveSectFract = adaptiveSectFract;
        }
    }

    public static class U3RupSetConfig
    extends RupSetConfig {
        private List<? extends FaultSection> subSects;
        private FaultModels fm;
        private RupSetScalingRelationship scale;
        @Expose
        private double maxJumpDist = 5.0;
        @Expose
        private float adaptiveSectFract = 0.0f;

        public U3RupSetConfig(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.init(subSects, scale);
        }

        private void detectFM(List<? extends FaultSection> subSects) {
            if (subSects.size() == 2606) {
                this.fm = FaultModels.FM3_1;
            } else if (subSects.size() == 2664) {
                this.fm = FaultModels.FM3_2;
            } else {
                System.err.println("WARNING: UCERF3 rupture set configuration was supplied with a non-UCERF3 fault model, disabling Coulomb (as it was precomputed for UCERF3 FM3.1 and FM3.2 only)");
                this.fm = null;
            }
        }

        public U3RupSetConfig(FaultModels fm, RupSetScalingRelationship scale) throws IOException {
            this.fm = fm;
            this.subSects = fm.getDefaultDeformationModel().build(fm, null, null);
            this.scale = scale;
        }

        @Override
        public List<? extends FaultSection> getSubSects() {
            return this.subSects;
        }

        @Override
        public PlausibilityConfiguration getPlausibilityConfig() {
            try {
                CoulombRates coulombRates = null;
                if (this.fm != null) {
                    coulombRates = CoulombRates.loadUCERF3CoulombRates(this.fm);
                }
                return PlausibilityConfiguration.getUCERF3(this.subSects, this.getDistAzCalc(), coulombRates, this.maxJumpDist);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        @Override
        public RuptureGrowingStrategy getGrowingStrategy() {
            RuptureGrowingStrategy strat = new ExhaustiveUnilateralRuptureGrowingStrategy();
            if (this.adaptiveSectFract > 0.0f) {
                strat = new SectCountAdaptiveRuptureGrowingStrategy(strat, this.adaptiveSectFract, true, 2);
            }
            return strat;
        }

        public void setAdaptiveSectFract(float adaptiveSectFract) {
            this.adaptiveSectFract = adaptiveSectFract;
        }

        @Override
        public String getRupSetFileName() {
            Object str = this.fm == null ? this.subSects.size() + "sects" : this.fm.encodeChoiceString().toLowerCase();
            str = (String)str + "_reproduce_ucerf3";
            if (this.adaptiveSectFract > 0.0f) {
                str = (String)str + "_fractGrow" + this.adaptiveSectFract;
            }
            return (String)str + ".zip";
        }

        @Override
        public RupSetScalingRelationship getScalingRelationship() {
            return this.scale;
        }

        @Override
        protected void init(List<? extends FaultSection> subSects, RupSetScalingRelationship scale) {
            this.subSects = subSects;
            this.scale = scale;
            this.detectFM(subSects);
        }

        @Override
        public void setMaxJumpDist(double maxJumpDist) {
            this.maxJumpDist = maxJumpDist;
        }
    }

    private static class CacheKey {
        private final LogicTreeNode[] cacheNodes;

        private CacheKey(LogicTreeNode[] cacheNodes) {
            Preconditions.checkState((cacheNodes.length > 0 ? 1 : 0) != 0);
            this.cacheNodes = cacheNodes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.cacheNodes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Arrays.equals(this.cacheNodes, other.cacheNodes);
        }
    }

    public static class Cache {
        private Map<CacheKey, FaultSystemRupSet> cache = new HashMap<CacheKey, FaultSystemRupSet>();

        public FaultSystemRupSet get(LogicTreeNode ... cacheNodes) {
            return this.cache.get(new CacheKey(cacheNodes));
        }

        public void put(FaultSystemRupSet rupSet, LogicTreeNode ... cacheNodes) {
            this.cache.put(new CacheKey(cacheNodes), rupSet);
        }
    }
}

