/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeHazardCompare;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeSimplifiedMapCurveWriter;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_SiteLogicTreeHazardCurveCalc;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;

public class LogicTreeSimplifiedMapDataWriter {
    private static final DecimalFormat timeDF = new DecimalFormat("0.0");

    public static void main(String[] args) {
        try {
            LogicTreeSimplifiedMapDataWriter.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void run(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("USAGE: LogicTreeSimplifiedMapDataWriter <results.zip> <output.zip>");
            System.exit(1);
        }
        File inputFile = new File(args[0]);
        Preconditions.checkState((boolean)inputFile.exists());
        File outputFile = new File(args[1]);
        ArchiveInput input = ArchiveInput.getDefaultInput(inputFile);
        ArchiveOutput output = ArchiveOutput.getDefaultOutput(outputFile, input);
        LogicTree<LogicTreeNode> tree = LogicTree.read(new InputStreamReader(new BufferedInputStream(input.getInputStream("logic_tree.json"))));
        SolHazardMapCalc.ReturnPeriods[] rps = SolHazardMapCalc.MAP_RPS;
        int treeSize = tree.size();
        ArrayList<Double> branchWeights = new ArrayList<Double>(treeSize);
        double sumWeights = 0.0;
        for (int i = 0; i < treeSize; ++i) {
            double weight = tree.getBranchWeight(i);
            branchWeights.add(weight);
            sumWeights += weight;
        }
        if (!Precision.equals((double)sumWeights, (double)1.0, (double)1.0E-5)) {
            double scalar = 1.0 / sumWeights;
            for (int i = 0; i < treeSize; ++i) {
                branchWeights.set(i, (Double)branchWeights.get(i) * scalar);
            }
        }
        Feature gridRegFeature = Feature.read(new InputStreamReader(new BufferedInputStream(input.getInputStream("gridded_region.geojson"))));
        GriddedRegion gridReg = GriddedRegion.fromFeature(gridRegFeature);
        System.out.println("Writing logic tree JSON and CSVs");
        CSVFile<String> logicTreeCSV = LogicTreeSimplifiedMapCurveWriter.buildLogicTreeCSV(tree, branchWeights);
        output.putNextEntry("gridded_region.geojson");
        OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
        Feature.write(gridReg.toFeature(), writer);
        ((Writer)writer).flush();
        output.closeEntry();
        tree.writeToArchive(output, "");
        output.putNextEntry("logic_tree.csv");
        logicTreeCSV.writeToStream(output.getOutputStream());
        output.closeEntry();
        logicTreeCSV = null;
        double[] periods = LogicTreeHazardCompare.detectHazardPeriods(new SolHazardMapCalc.ReturnPeriods[]{SolHazardMapCalc.ReturnPeriods.TWO_IN_50}, input);
        input.close();
        LogicTreeHazardCompare loader = new LogicTreeHazardCompare(null, tree, inputFile, rps, periods, gridReg.getSpacing());
        Stopwatch overallWatch = Stopwatch.createStarted();
        ExecutorService exec = Executors.newFixedThreadPool(FaultSysTools.defaultNumThreads());
        for (int p = 0; p < periods.length; ++p) {
            String perUnits;
            Object perLabel;
            if (periods[p] == -1.0) {
                perLabel = "PGV";
                perUnits = "cm/s";
            } else if (periods[p] == 0.0) {
                perLabel = "PGA";
                perUnits = "g";
            } else {
                perLabel = (float)periods[p] + "s SA";
                perUnits = "g";
            }
            for (SolHazardMapCalc.ReturnPeriods rp : rps) {
                System.out.println("Doing " + (String)perLabel + ", " + String.valueOf((Object)rp));
                String csvName = MPJ_SiteLogicTreeHazardCurveCalc.getSitePeriodPrefix("map", periods[p]) + "_" + rp.name() + ".csv";
                GriddedGeoDataSet[] maps = loader.loadMaps(rp, periods[p]);
                Preconditions.checkState((maps.length == treeSize ? 1 : 0) != 0);
                System.out.println("\tLoading mean");
                GriddedGeoDataSet meanMap = loader.loadPrecomputedMeanMap("mean", rp, periods[p]);
                if (meanMap == null) {
                    System.out.println("\tHave to calculate mean");
                    meanMap = loader.buildMean(maps);
                }
                System.out.println("\tCalculating Min/Max");
                GriddedGeoDataSet min = loader.buildMin(maps, branchWeights);
                GriddedGeoDataSet max = loader.buildMax(maps, branchWeights);
                System.out.println("\tCalculating SD/COV");
                GriddedGeoDataSet sd = new GriddedGeoDataSet(gridReg);
                GriddedGeoDataSet cov = new GriddedGeoDataSet(gridReg);
                LogicTreeHazardCompare.calcSD_COV(maps, branchWeights, meanMap, sd, cov, exec);
                System.out.println("\tCalculating NCDFs");
                LightFixedXFunc[] ncdfs = loader.buildNormCDFs(maps, branchWeights);
                System.out.println("\tCalculating median");
                GriddedGeoDataSet medianMap = loader.calcMapAtPercentile(ncdfs, gridReg, 50.0);
                System.out.println("\tCalculating " + LogicTreeSimplifiedMapCurveWriter.FRACTILES.length + " fractiles");
                GriddedGeoDataSet[] percentileMaps = new GriddedGeoDataSet[LogicTreeSimplifiedMapCurveWriter.FRACTILES.length];
                for (int f = 0; f < percentileMaps.length; ++f) {
                    percentileMaps[f] = loader.calcMapAtPercentile(ncdfs, gridReg, LogicTreeSimplifiedMapCurveWriter.FRACTILES[f] * 100.0);
                }
                System.out.println("\tWriting CSV");
                CSVFile csv = new CSVFile(true);
                ArrayList<String> header = new ArrayList<String>(9 + LogicTreeSimplifiedMapCurveWriter.PERCENTILE_HEADERS.length);
                header.add("Grid Index");
                header.add("Latitude");
                header.add("Longitude");
                header.add("Mean");
                header.add("Median");
                header.add("Standard Deviation");
                header.add("COV");
                header.add("Min");
                for (String pHeader : LogicTreeSimplifiedMapCurveWriter.PERCENTILE_HEADERS) {
                    header.add(pHeader);
                }
                header.add("Max");
                csv.addLine(header);
                for (int i = 0; i < meanMap.size(); ++i) {
                    ArrayList<CallSite> line = new ArrayList<CallSite>(header.size());
                    line.add((CallSite)((Object)("" + i)));
                    Location loc = gridReg.getLocation(i);
                    line.add((CallSite)((Object)("" + (float)loc.lat)));
                    line.add((CallSite)((Object)("" + (float)loc.lon)));
                    line.add((CallSite)((Object)("" + meanMap.get(i))));
                    line.add((CallSite)((Object)("" + medianMap.get(i))));
                    line.add((CallSite)((Object)("" + sd.get(i))));
                    line.add((CallSite)((Object)("" + cov.get(i))));
                    line.add((CallSite)((Object)("" + min.get(i))));
                    for (int f = 0; f < percentileMaps.length; ++f) {
                        line.add((CallSite)((Object)("" + percentileMaps[f].get(i))));
                    }
                    line.add((CallSite)((Object)("" + max.get(i))));
                    csv.addLine(line);
                }
                output.putNextEntry(csvName);
                csv.writeToStream(output.getOutputStream());
                output.closeEntry();
            }
        }
        exec.shutdown();
        output.close();
        System.out.println("DONE");
        overallWatch.stop();
        System.out.println("Took " + LogicTreeSimplifiedMapDataWriter.timeStr(overallWatch));
        System.exit(0);
    }

    private static String timeStr(Stopwatch watch) {
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        if (secs > 60.0) {
            double mins = secs / 60.0;
            if (mins > 60.0) {
                return timeDF.format(mins / 60.0) + "h";
            }
            return timeDF.format(mins) + "m";
        }
        return timeDF.format(secs) + "s";
    }
}

