/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.calc.params.filters.SourceFilters;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.SiteAdaptiveSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysHazardCalcSettings;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.faultSurface.FiniteApproxPointSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;

public class QuickGriddedHazardMapCalc {
    private Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmpeSuppliers;
    private double period;
    private DiscretizedFunc xVals;
    private Map<TectonicRegionType, Double> trtMaxDists;
    private Map<TectonicRegionType, EvenlyDiscretizedFunc> trtLogSpacedDiscrs;
    private Map<TectonicRegionType, double[]> trtDistVals;
    private Map<TectonicRegionType, DiscretizedFunc> trtDistDiscr;
    private ConcurrentMap<UniquePointRupture, DiscretizedFunc[]> rupExceedsMap = new ConcurrentHashMap<UniquePointRupture, DiscretizedFunc[]>();
    private GriddedSeismicitySettings gridSettings;
    private int minNodeCalcsForSourcewise;
    public static final int NUM_DISCR_DEFAULT = 150;
    private static double FIRST_NONZERO_DIST_BIN = 0.1;
    private static boolean INCLUDE_RUPS_IN_NODE_CALCS = true;
    private static boolean LIMIT_SOURCE_CALC_TO_ACTUAL_MAX_DIST = true;
    private boolean trtWarned = false;
    private boolean trackStats = false;
    private AtomicInteger sourcesProcessed = new AtomicInteger();
    private AtomicInteger numNonTruePointSources = new AtomicInteger();
    private AtomicInteger numRupwise = new AtomicInteger();
    private AtomicInteger numSourcewise = new AtomicInteger();
    private AtomicLong numCacheMisses = new AtomicLong();
    private AtomicLong numCacheHits = new AtomicLong();

    public QuickGriddedHazardMapCalc(Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmpeSuppliers, double period, DiscretizedFunc xVals, SourceFilterManager sourceFitlers, GriddedSeismicitySettings gridSettings) {
        this(gmpeSuppliers, period, xVals, sourceFitlers, gridSettings, 150);
    }

    public QuickGriddedHazardMapCalc(Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmpeSuppliers, double period, DiscretizedFunc xVals, SourceFilterManager sourceFitlers, GriddedSeismicitySettings gridSettings, int numDiscr) {
        this.gmpeSuppliers = gmpeSuppliers;
        this.period = period;
        this.xVals = xVals;
        this.gridSettings = gridSettings;
        this.minNodeCalcsForSourcewise = 3 * numDiscr / 2;
        this.trtMaxDists = new EnumMap<TectonicRegionType, Double>(TectonicRegionType.class);
        this.trtLogSpacedDiscrs = new EnumMap<TectonicRegionType, EvenlyDiscretizedFunc>(TectonicRegionType.class);
        this.trtDistVals = new EnumMap<TectonicRegionType, double[]>(TectonicRegionType.class);
        this.trtDistDiscr = new EnumMap<TectonicRegionType, DiscretizedFunc>(TectonicRegionType.class);
        for (TectonicRegionType trt : gmpeSuppliers.keySet()) {
            double maxDist = SolHazardMapCalc.getMaxDistForTRT(sourceFitlers, trt);
            this.trtMaxDists.put(trt, maxDist);
            EvenlyDiscretizedFunc logSpacedDiscr = new EvenlyDiscretizedFunc(Math.log(FIRST_NONZERO_DIST_BIN), Math.log(maxDist + 5.0), numDiscr - 1);
            this.trtLogSpacedDiscrs.put(trt, logSpacedDiscr);
            double[] distVals = new double[numDiscr];
            for (int i = 1; i < distVals.length; ++i) {
                distVals[i] = Math.exp(logSpacedDiscr.getX(i - 1));
            }
            this.trtDistVals.put(trt, distVals);
            this.trtDistDiscr.put(trt, new LightFixedXFunc(distVals, new double[distVals.length]));
        }
    }

    /*
     * WARNING - void declaration
     */
    public DiscretizedFunc[] calc(GridSourceProvider gridProv, GriddedRegion gridReg, ExecutorService exec, int threads) {
        void var10_17;
        void var10_15;
        ArbitrarilyDiscretizedFunc logXVals = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : this.xVals) {
            logXVals.set(Math.log(pt.getX()), 0.0);
        }
        ArrayDeque<Integer> sourceIndexes = new ArrayDeque<Integer>(gridProv.getNumSources());
        for (int i2 = 0; i2 < gridProv.getNumSources(); ++i2) {
            sourceIndexes.add(i2);
        }
        ArrayList<Future<DiscretizedFunc[]>> calcFutures = new ArrayList<Future<DiscretizedFunc[]>>(threads);
        for (int i3 = 0; i3 < threads; ++i3) {
            calcFutures.add(exec.submit(new CalcCallable(gridProv, logXVals, gridReg, sourceIndexes)));
        }
        DiscretizedFunc[] curves = null;
        for (Future future : calcFutures) {
            DiscretizedFunc[] threadCurves;
            try {
                threadCurves = (DiscretizedFunc[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            if (threadCurves == null) continue;
            if (curves == null) {
                curves = threadCurves;
                continue;
            }
            for (int i4 = 0; i4 < curves.length; ++i4) {
                for (int k = 0; k < curves[i4].size(); ++k) {
                    curves[i4].set(k, curves[i4].getY(k) * threadCurves[i4].getY(k));
                }
            }
        }
        Preconditions.checkNotNull(curves, (Object)"Curves never initialized?");
        double[] linearX = new double[this.xVals.size()];
        boolean bl = false;
        while (var10_15 < linearX.length) {
            linearX[var10_15] = this.xVals.getX((int)var10_15);
            ++var10_15;
        }
        boolean bl2 = false;
        while (var10_17 < curves.length) {
            double[] yVals = new double[linearX.length];
            for (int j = 0; j < logXVals.size(); ++j) {
                yVals[j] = 1.0 - curves[var10_17].getY(j);
            }
            curves[var10_17] = new LightFixedXFunc(linearX, yVals);
            ++var10_17;
        }
        return curves;
    }

    private void quickSourceCalc(GriddedRegion gridReg, ProbEqkSource origSource, ScalarIMR gmpe, DiscretizedFunc[] curves) {
        double[] xValsArray = new double[curves[0].size()];
        for (int i = 0; i < xValsArray.length; ++i) {
            xValsArray[i] = curves[0].getX(i);
        }
        LightFixedXFunc exceedFunc = new LightFixedXFunc(xValsArray, new double[xValsArray.length]);
        TectonicRegionType trt = origSource.getTectonicRegionType();
        if (!this.trtMaxDists.containsKey(trt)) {
            Preconditions.checkState((this.trtMaxDists.keySet().size() == 1 ? 1 : 0) != 0);
            trt = this.trtMaxDists.keySet().iterator().next();
        }
        double maxDist = this.trtMaxDists.get(trt);
        double[] distVals = this.trtDistVals.get(trt);
        EvenlyDiscretizedFunc logSpacedDiscr = this.trtLogSpacedDiscrs.get(trt);
        DiscretizedFunc distDiscr = this.trtDistDiscr.get(trt);
        ArrayList nodeIndexesList = new ArrayList();
        ArrayList nodeDistsList = new ArrayList();
        ArrayList<Double> nodeMaxDistsList = new ArrayList<Double>();
        ArrayList<ProbEqkSource> sourceInstances = new ArrayList<ProbEqkSource>();
        HashMap<ProbEqkSource, Integer> sourceInstancesMap = new HashMap<ProbEqkSource, Integer>();
        SiteAdaptiveSource adaptive = origSource instanceof SiteAdaptiveSource ? (SiteAdaptiveSource)((Object)origSource) : null;
        nodeIndexesList.add(new ArrayList());
        nodeDistsList.add(new ArrayList());
        nodeMaxDistsList.add(0.0);
        sourceInstances.add(origSource);
        sourceInstancesMap.put(origSource, 0);
        Site site = new Site(gridReg.getLocation(0));
        for (int i = 0; i < gridReg.getNodeCount(); ++i) {
            Integer sourceIndex;
            Location loc = gridReg.getLocation(i);
            site.setLocation(loc);
            double dist = origSource.getMinDistance(site);
            if (!(dist <= maxDist)) continue;
            if (adaptive != null) {
                ProbEqkSource mySource = adaptive.getForSite(site);
                sourceIndex = (Integer)sourceInstancesMap.get(mySource);
                if (sourceIndex == null) {
                    sourceIndex = sourceInstances.size();
                    sourceInstances.add(mySource);
                    nodeIndexesList.add(new ArrayList());
                    nodeDistsList.add(new ArrayList());
                    nodeMaxDistsList.add(0.0);
                    sourceInstancesMap.put(mySource, sourceIndex);
                }
            } else {
                sourceIndex = 0;
            }
            List nodeIndexes = (List)nodeIndexesList.get(sourceIndex);
            List nodeDists = (List)nodeDistsList.get(sourceIndex);
            nodeIndexes.add(i);
            nodeDists.add(dist);
            double prevMax = (Double)nodeMaxDistsList.get(sourceIndex);
            if (!(dist > prevMax)) continue;
            nodeMaxDistsList.set(sourceIndex, dist);
        }
        if (nodeIndexesList.size() == 1 && ((List)nodeIndexesList.get(0)).isEmpty()) {
            return;
        }
        for (int n = 0; n < nodeIndexesList.size(); ++n) {
            double maxSiteDist;
            ProbEqkSource theSource = (ProbEqkSource)sourceInstances.get(n);
            List nodeIndexes = (List)nodeIndexesList.get(n);
            List nodeDists = (List)nodeDistsList.get(n);
            if (nodeIndexes.isEmpty()) continue;
            int numNodes = nodeIndexes.size();
            int nodeCalcs = INCLUDE_RUPS_IN_NODE_CALCS ? numNodes * theSource.getNumRuptures() : numNodes;
            boolean truePointSource = true;
            boolean allSameLoc = true;
            Location loc0 = null;
            List<ProbEqkRupture> rups = theSource.getRuptureList();
            for (ProbEqkRupture rup : rups) {
                RuptureSurface surf = rup.getRuptureSurface();
                if (!(surf instanceof PointSurface)) {
                    truePointSource = false;
                    break;
                }
                if (!allSameLoc) continue;
                Location loc = ((PointSurface)surf).getLocation();
                if (loc0 == null) {
                    loc0 = loc;
                    continue;
                }
                allSameLoc = (float)loc.lat == (float)loc0.lat && (float)loc.lon == (float)loc0.lon;
            }
            if (this.trackStats) {
                this.sourcesProcessed.incrementAndGet();
            }
            if (!truePointSource) {
                if (this.trackStats) {
                    this.numNonTruePointSources.incrementAndGet();
                }
                Preconditions.checkState((exceedFunc.size() == curves[0].size() ? 1 : 0) != 0);
                Preconditions.checkState((exceedFunc.getX(0) == curves[0].getX(0) ? 1 : 0) != 0);
                for (ProbEqkRupture rup : rups) {
                    gmpe.setEqkRupture(rup);
                    double lnBase = Math.log1p(-rup.getProbability());
                    for (int l = 0; l < numNodes; ++l) {
                        int index = (Integer)nodeIndexes.get(l);
                        gmpe.setSiteLocation(gridReg.getLocation(index));
                        gmpe.getExceedProbabilities(exceedFunc);
                        for (int k = 0; k < exceedFunc.size(); ++k) {
                            curves[index].set(k, curves[index].getY(k) * Math.exp(lnBase * exceedFunc.getY(k)));
                        }
                    }
                }
                continue;
            }
            if (!allSameLoc || nodeCalcs < this.minNodeCalcsForSourcewise || numNodes < theSource.getNumRuptures()) {
                if (this.trackStats) {
                    this.numRupwise.incrementAndGet();
                }
                double[] logDists = null;
                if (allSameLoc) {
                    logDists = new double[numNodes];
                    for (int l = 0; l < logDists.length; ++l) {
                        logDists[l] = Math.log((Double)nodeDists.get(l));
                    }
                }
                for (ProbEqkRupture rup : rups) {
                    DiscretizedFunc[] exceeds = this.getCacheRupExceeds(rup, gmpe, curves[0], distVals, distDiscr);
                    Location rupLoc = allSameLoc ? null : ((PointSurface)rup.getRuptureSurface()).getLocation();
                    double lnBase = Math.log1p(-rup.getProbability());
                    for (int l = 0; l < numNodes; ++l) {
                        double logDist;
                        double dist;
                        int index = (Integer)nodeIndexes.get(l);
                        if (allSameLoc) {
                            dist = (Double)nodeDists.get(l);
                            logDist = logDists[l];
                        } else {
                            dist = LocationUtils.horzDistanceFast(rupLoc, gridReg.getLocation(index));
                            logDist = Math.log(dist);
                        }
                        this.quickInterp(exceeds, exceedFunc, dist, logDist, logSpacedDiscr, distDiscr);
                        for (int k = 0; k < exceedFunc.size(); ++k) {
                            curves[index].set(k, curves[index].getY(k) * Math.exp(lnBase * exceedFunc.getY(k)));
                        }
                    }
                }
                continue;
            }
            if (this.trackStats) {
                this.numSourcewise.incrementAndGet();
            }
            int numDistsToCalc = distVals.length;
            double[] calcDistVals = distVals;
            if (LIMIT_SOURCE_CALC_TO_ACTUAL_MAX_DIST && (maxSiteDist = ((Double)nodeMaxDistsList.get(n)).doubleValue()) < 0.9 * maxDist) {
                int maxDistIndex = Arrays.binarySearch(distVals, maxSiteDist);
                if (maxDistIndex < 0) {
                    maxDistIndex = -(maxDistIndex + 1);
                }
                if (++maxDistIndex < distVals.length - 1) {
                    numDistsToCalc = maxDistIndex + 1;
                    calcDistVals = Arrays.copyOf(distVals, numDistsToCalc);
                }
            }
            DiscretizedFunc[] sourceNonExceeds = new DiscretizedFunc[xValsArray.length];
            for (int k = 0; k < sourceNonExceeds.length; ++k) {
                double[] yVals = new double[numDistsToCalc];
                for (int i = 0; i < yVals.length; ++i) {
                    yVals[i] = 1.0;
                }
                sourceNonExceeds[k] = new LightFixedXFunc(calcDistVals, yVals);
            }
            for (ProbEqkRupture rup : rups) {
                DiscretizedFunc[] exceeds = this.getCacheRupExceeds(rup, gmpe, curves[0], distVals, distDiscr);
                double lnBase = Math.log(1.0 - rup.getProbability());
                for (int i = 0; i < sourceNonExceeds.length; ++i) {
                    for (int k = 0; k < numDistsToCalc; ++k) {
                        sourceNonExceeds[i].set(k, sourceNonExceeds[i].getY(k) * Math.exp(lnBase * exceeds[i].getY(k)));
                    }
                }
            }
            for (int l = 0; l < numNodes; ++l) {
                int index = (Integer)nodeIndexes.get(l);
                double dist = (Double)nodeDists.get(l);
                this.quickInterp(sourceNonExceeds, exceedFunc, dist, Math.log(dist), logSpacedDiscr, distDiscr);
                for (int k = 0; k < exceedFunc.size(); ++k) {
                    curves[index].set(k, curves[index].getY(k) * exceedFunc.getY(k));
                }
            }
        }
    }

    private void quickInterp(DiscretizedFunc[] exceeds, DiscretizedFunc exceedFunc, double dist, double logDist, EvenlyDiscretizedFunc logSpacedDiscr, DiscretizedFunc distDiscr) {
        if ((float)dist == 0.0f) {
            for (int i = 0; i < exceedFunc.size(); ++i) {
                exceedFunc.set(i, exceeds[i].getY(0));
            }
        } else {
            double x;
            double x2;
            double x1;
            int x1Ind = dist < distDiscr.getX(1) ? 0 : 1 + (int)Math.floor((logDist - logSpacedDiscr.getMinX()) / logSpacedDiscr.getDelta());
            int x2Ind = x1Ind + 1;
            boolean logX = x1Ind > 0;
            boolean logY = false;
            if (logX) {
                x1 = logSpacedDiscr.getX(x1Ind - 1);
                x2 = logSpacedDiscr.getX(x2Ind - 1);
                x = logDist;
            } else {
                x1 = distDiscr.getX(x1Ind);
                x2 = distDiscr.getX(x2Ind);
                x = dist;
            }
            double xRatio = (x - x1) / (x2 - x1);
            for (int i = 0; i < exceedFunc.size(); ++i) {
                double y;
                double y1 = exceeds[i].getY(x1Ind);
                double y2 = exceeds[i].getY(x2Ind);
                boolean myLogY = false;
                if (y1 == 0.0 && y2 == 0.0) {
                    y = 0.0;
                } else {
                    if (myLogY) {
                        y1 = Math.log(y1);
                        y2 = Math.log(y2);
                    }
                    y = y1 + xRatio * (y2 - y1);
                    if (myLogY) {
                        y = Math.exp(y);
                    }
                }
                exceedFunc.set(i, y);
            }
        }
    }

    private DiscretizedFunc[] getCacheRupExceeds(ProbEqkRupture rup, ScalarIMR gmpe, DiscretizedFunc xVals, double[] distVals, DiscretizedFunc distDiscr) {
        UniquePointRupture uRup = new UniquePointRupture(rup);
        DiscretizedFunc[] exceeds = (DiscretizedFunc[])this.rupExceedsMap.get(uRup);
        if (exceeds == null) {
            exceeds = new DiscretizedFunc[xVals.size()];
            for (int i = 0; i < exceeds.length; ++i) {
                exceeds[i] = new LightFixedXFunc(distVals, new double[distVals.length]);
            }
            PointSurface pSurf = (PointSurface)rup.getRuptureSurface();
            Location srcLoc = pSurf.getLocation();
            gmpe.setEqkRupture(rup);
            double[] xValsArray = new double[xVals.size()];
            for (int i = 0; i < xValsArray.length; ++i) {
                xValsArray[i] = xVals.getX(i);
            }
            LightFixedXFunc exceedFunc = new LightFixedXFunc(xValsArray, new double[xValsArray.length]);
            for (int i = 0; i < distDiscr.size(); ++i) {
                double dist = distDiscr.getX(i);
                Location siteLoc = (float)dist == 0.0f ? srcLoc : LocationUtils.location(srcLoc, 0.0, dist);
                gmpe.setSiteLocation(siteLoc);
                gmpe.getExceedProbabilities(exceedFunc);
                for (int j = 0; j < exceedFunc.size(); ++j) {
                    exceeds[j].set(i, exceedFunc.getY(j));
                }
            }
            this.rupExceedsMap.putIfAbsent(uRup, exceeds);
            if (this.trackStats) {
                this.numCacheMisses.incrementAndGet();
            }
        } else if (this.trackStats) {
            this.numCacheHits.incrementAndGet();
        }
        return exceeds;
    }

    public static void main(String[] args) throws IOException {
        ModuleContainer.VERBOSE_DEFAULT = false;
        FaultSystemSolution sol = FaultSystemSolution.load(new File("/data/kevin/nshm23/batch_inversions/2024_12_12-prvi25_crustal_subduction_combined_branches/combined_branch_averaged_solution.zip"));
        Map<TectonicRegionType, AttenRelRef> trtGMMs = Map.of(TectonicRegionType.ACTIVE_SHALLOW, AttenRelRef.USGS_PRVI_ACTIVE, TectonicRegionType.SUBDUCTION_INTERFACE, AttenRelRef.USGS_PRVI_INTERFACE, TectonicRegionType.SUBDUCTION_SLAB, AttenRelRef.USGS_PRVI_SLAB);
        Region region = PRVI25_RegionLoader.loadPRVI_Tight();
        double spacing = 0.025;
        INCLUDE_RUPS_IN_NODE_CALCS = true;
        LIMIT_SOURCE_CALC_TO_ACTUAL_MAX_DIST = true;
        int numDiscr = 150;
        FIRST_NONZERO_DIST_BIN = 0.1;
        GridSourceProvider gridProv = sol.getGridSourceProvider();
        ArbitrarilyDiscretizedFunc xVals = new IMT_Info().getDefaultHazardCurve("PGA");
        int threads = 32;
        double period = 0.0;
        SourceFilterManager sourceFilters = new SourceFilterManager(SourceFilters.TRT_DIST_CUTOFFS);
        GriddedSeismicitySettings gridSettings = GriddedSeismicitySettings.DEFAULT;
        gridSettings = gridSettings.forSupersamplingSettings(GridCellSupersamplingSettings.QUICK);
        QuickGriddedHazardMapCalc calc = new QuickGriddedHazardMapCalc(trtGMMs, period, xVals, sourceFilters, gridSettings, numDiscr);
        System.out.println("Cache distances:");
        for (TectonicRegionType trt : calc.trtDistVals.keySet()) {
            System.out.println(trt.name() + ":\t" + Joiner.on((String)",").join((Iterable)Doubles.asList((double[])calc.trtDistVals.get(trt))));
        }
        calc.trackStats = true;
        GriddedRegion gridReg = new GriddedRegion(region, spacing, GriddedRegion.ANCHOR_0_0);
        System.out.println("Have " + gridReg.getNodeCount() + " sites");
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        Stopwatch watch = Stopwatch.createStarted();
        DiscretizedFunc[] quickCurves = calc.calc(gridProv, gridReg, exec, threads);
        watch.stop();
        double quickSecs1 = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.println("Quick 1 took " + (float)quickSecs1 + " s");
        DecimalFormat pDF = new DecimalFormat("0.00%");
        long numCacheHits = calc.numCacheHits.get();
        long numCacheMisses = calc.numCacheMisses.get();
        System.out.println("Calc #1 hits = " + numCacheHits + "/" + (numCacheHits + numCacheMisses) + " (" + pDF.format((double)numCacheHits / (double)(numCacheHits + numCacheMisses)) + ")");
        int numSourceCalcs = calc.sourcesProcessed.get();
        int numNonTruePointSources = calc.numNonTruePointSources.get();
        int numRupwise = calc.numRupwise.get();
        int numSourcewise = calc.numSourcewise.get();
        System.out.println("Calc #1 types for " + numSourceCalcs + " source calculations:\n\t" + numNonTruePointSources + " (" + pDF.format((double)numNonTruePointSources / (double)numSourceCalcs) + ") not true point sources\n\t" + numRupwise + " (" + pDF.format((double)numRupwise / (double)numSourceCalcs) + ") done rupture-wise\n\t" + numSourcewise + " (" + pDF.format((double)numSourcewise / (double)numSourceCalcs) + ") done source-wise");
        calc.numCacheHits.set(0L);
        calc.numCacheMisses.set(0L);
        calc.sourcesProcessed.set(0);
        calc.numNonTruePointSources.set(0);
        calc.numRupwise.set(0);
        calc.numSourcewise.set(0);
        watch.reset();
        watch.start();
        calc.calc(gridProv, gridReg, exec, threads);
        watch.stop();
        double quickSecs2 = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        exec.shutdown();
        System.out.println("Quick 2 took " + (float)quickSecs2 + " s");
        numCacheHits = calc.numCacheHits.get();
        numCacheMisses = calc.numCacheMisses.get();
        System.out.println("Calc #1 hits = " + numCacheHits + "/" + (numCacheHits + numCacheMisses) + " (" + pDF.format((double)numCacheHits / (double)(numCacheHits + numCacheMisses)) + ")");
        numSourceCalcs = calc.sourcesProcessed.get();
        numNonTruePointSources = calc.numNonTruePointSources.get();
        numRupwise = calc.numRupwise.get();
        numSourcewise = calc.numSourcewise.get();
        System.out.println("Calc #2 types for " + numSourceCalcs + " source calculations:\n\t" + numNonTruePointSources + " (" + pDF.format((double)numNonTruePointSources / (double)numSourceCalcs) + ") not true point sources\n\t" + numRupwise + " (" + pDF.format((double)numRupwise / (double)numSourceCalcs) + ") done rupture-wise\n\t" + numSourcewise + " (" + pDF.format((double)numSourcewise / (double)numSourceCalcs) + ") done source-wise");
        SolHazardMapCalc tradCalc = new SolHazardMapCalc(sol, trtGMMs, gridReg, IncludeBackgroundOption.ONLY, period);
        tradCalc.setSourceFilter(sourceFilters);
        tradCalc.setGriddedSeismicitySettings(gridSettings);
        watch.reset();
        watch.start();
        tradCalc.calcHazardCurves(threads);
        watch.stop();
        double tradSecs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.println("Quick 1 took " + (float)quickSecs1 + " s");
        System.out.println("Quick 2 took " + (float)quickSecs2 + " s");
        System.out.println("Traditional took " + (float)tradSecs + " s");
        DiscretizedFunc[] tradCurves = tradCalc.getCurves(0.0);
        DiscretizedFunc avgTrad = QuickGriddedHazardMapCalc.avgCurves(tradCurves);
        DiscretizedFunc avgQuick = QuickGriddedHazardMapCalc.avgCurves(quickCurves);
        System.out.println("Regional average curve stats:");
        System.out.println("\tWORST:  \t" + (float)QuickGriddedHazardMapCalc.worstDiff(avgTrad, avgQuick, true, 0.0) + "%\t" + (float)QuickGriddedHazardMapCalc.worstDiff(avgTrad, avgQuick, false, 0.0));
        System.out.println("\tAVERAGE:\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(avgTrad, avgQuick, true, 0.0) + "%\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(avgTrad, avgQuick, false, 0.0));
        System.out.println("\t2in50:\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(avgTrad, avgQuick, true, 4.0E-4) + "%\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(avgTrad, avgQuick, false, 4.0E-4));
        System.out.println("All curve stats:");
        System.out.println("\tWORST:  \t" + (float)QuickGriddedHazardMapCalc.worstDiff(tradCurves, quickCurves, true, 0.0) + "%\t" + (float)QuickGriddedHazardMapCalc.worstDiff(tradCurves, quickCurves, false, 0.0));
        System.out.println("\tWORST 2in50:  \t" + (float)QuickGriddedHazardMapCalc.worstDiff(tradCurves, quickCurves, true, 4.0E-4) + "%\t" + (float)QuickGriddedHazardMapCalc.worstDiff(tradCurves, quickCurves, false, 4.0E-4));
        System.out.println("\tAVERAGE:\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(tradCurves, quickCurves, true, 0.0) + "%\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(tradCurves, quickCurves, false, 0.0));
        System.out.println("\tAVERAGE 2in50:\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(tradCurves, quickCurves, true, 4.0E-4) + "%\t" + (float)QuickGriddedHazardMapCalc.avgAbsDiff(tradCurves, quickCurves, false, 4.0E-4));
    }

    private static DiscretizedFunc avgCurves(DiscretizedFunc[] curves) {
        double[] xVals = new double[curves[0].size()];
        for (int i = 0; i < xVals.length; ++i) {
            xVals[i] = curves[0].getX(i);
        }
        double[] yVals = new double[xVals.length];
        for (DiscretizedFunc curve : curves) {
            for (int i = 0; i < xVals.length; ++i) {
                int n = i;
                yVals[n] = yVals[n] + curve.getY(i);
            }
        }
        double scale = 1.0 / (double)curves.length;
        int i = 0;
        while (i < yVals.length) {
            int n = i++;
            yVals[n] = yVals[n] * scale;
        }
        return new LightFixedXFunc(xVals, yVals);
    }

    private static double worstDiff(DiscretizedFunc curve1, DiscretizedFunc curve2, boolean pDiff, double atProb) {
        return QuickGriddedHazardMapCalc.worstDiff(new DiscretizedFunc[]{curve1}, new DiscretizedFunc[]{curve2}, pDiff, atProb);
    }

    private static double worstDiff(DiscretizedFunc[] curves1, DiscretizedFunc[] curves2, boolean pDiff, double atProb) {
        double worst = 0.0;
        double absWorst = 0.0;
        for (int n = 0; n < curves1.length; ++n) {
            if (atProb > 0.0) {
                double abs;
                double y1 = curves1[n].getFirstInterpolatedX_inLogXLogYDomain(atProb);
                double y2 = curves2[n].getFirstInterpolatedX_inLogXLogYDomain(atProb);
                double diff = y2 - y1;
                if (pDiff) {
                    diff = 100.0 * diff / y1;
                }
                if (!((abs = Math.abs(diff)) > absWorst)) continue;
                absWorst = abs;
                worst = diff;
                continue;
            }
            for (int i = 0; i < curves1[n].size(); ++i) {
                double abs;
                double y1 = curves1[n].getY(i);
                double y2 = curves2[n].getY(i);
                double diff = y2 - y1;
                if (pDiff) {
                    diff = 100.0 * diff / y1;
                }
                if (!((abs = Math.abs(diff)) > absWorst)) continue;
                absWorst = abs;
                worst = diff;
            }
        }
        return worst;
    }

    private static double avgAbsDiff(DiscretizedFunc curve1, DiscretizedFunc curve2, boolean pDiff, double atProb) {
        return QuickGriddedHazardMapCalc.avgAbsDiff(new DiscretizedFunc[]{curve1}, new DiscretizedFunc[]{curve2}, pDiff, atProb);
    }

    private static double avgAbsDiff(DiscretizedFunc[] curves1, DiscretizedFunc[] curves2, boolean pDiff, double atProb) {
        double sum = 0.0;
        int num = 0;
        for (int n = 0; n < curves1.length; ++n) {
            if (atProb > 0.0) {
                double y1 = curves1[n].getFirstInterpolatedX_inLogXLogYDomain(atProb);
                double y2 = curves2[n].getFirstInterpolatedX_inLogXLogYDomain(atProb);
                double diff = y2 - y1;
                if (pDiff) {
                    diff = 100.0 * diff / y1;
                }
                double abs = Math.abs(diff);
                sum += abs;
                ++num;
                continue;
            }
            for (int i = 0; i < curves1[n].size(); ++i) {
                double y1 = curves1[n].getY(i);
                double y2 = curves2[n].getY(i);
                double diff = y2 - y1;
                if (pDiff) {
                    diff = 100.0 * diff / y1;
                }
                double abs = Math.abs(diff);
                sum += abs;
                ++num;
            }
        }
        return sum / (double)num;
    }

    private class CalcCallable
    implements Callable<DiscretizedFunc[]> {
        private DiscretizedFunc[] curves;
        private GridSourceProvider gridProv;
        private DiscretizedFunc logXVals;
        private GriddedRegion gridReg;
        private ArrayDeque<Integer> sourceIndexes;

        public CalcCallable(GridSourceProvider gridProv, DiscretizedFunc logXVals, GriddedRegion gridReg, ArrayDeque<Integer> sourceIndexes) {
            this.gridProv = gridProv;
            this.logXVals = logXVals;
            this.gridReg = gridReg;
            this.sourceIndexes = sourceIndexes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public DiscretizedFunc[] call() {
            Object yVals;
            EnumMap<TectonicRegionType, ScalarIMR> gmpeMap;
            try {
                int i;
                gmpeMap = new EnumMap<TectonicRegionType, ScalarIMR>(TectonicRegionType.class);
                for (TectonicRegionType trt : this.gridProv.getTectonicRegionTypes()) {
                    Supplier<ScalarIMR> gmmSupplier = QuickGriddedHazardMapCalc.this.gmpeSuppliers.get(trt);
                    if (gmmSupplier == null && QuickGriddedHazardMapCalc.this.gmpeSuppliers.size() == 1) {
                        TectonicRegionType trtWeHave = QuickGriddedHazardMapCalc.this.gmpeSuppliers.keySet().iterator().next();
                        if (!QuickGriddedHazardMapCalc.this.trtWarned) {
                            QuickGriddedHazardMapCalc quickGriddedHazardMapCalc = QuickGriddedHazardMapCalc.this;
                            // MONITORENTER : quickGriddedHazardMapCalc
                            if (!QuickGriddedHazardMapCalc.this.trtWarned) {
                                System.err.println("WARNING: no GMPE supplied for TRT " + String.valueOf(trt) + ", using the only one we have (for " + String.valueOf(trtWeHave) + ")");
                                QuickGriddedHazardMapCalc.this.trtWarned = true;
                            }
                            // MONITOREXIT : quickGriddedHazardMapCalc
                        }
                        gmmSupplier = QuickGriddedHazardMapCalc.this.gmpeSuppliers.get(trtWeHave);
                    }
                    Preconditions.checkNotNull(gmmSupplier, (String)"No GMPE supplied for TRT: %s", (Object)trt);
                    ScalarIMR gmm = gmmSupplier.get();
                    FaultSysHazardCalcSettings.setIMforPeriod(gmm, QuickGriddedHazardMapCalc.this.period);
                    Site testSite = new Site(new Location(0.0, 0.0));
                    testSite.addParameterList(gmm.getSiteParams());
                    gmm.setSite(testSite);
                    gmpeMap.put(trt, gmm);
                }
                double[] xValArray = new double[this.logXVals.size()];
                for (i = 0; i < xValArray.length; ++i) {
                    xValArray[i] = this.logXVals.getX(i);
                }
                this.curves = new DiscretizedFunc[this.gridReg.getNodeCount()];
                for (i = 0; i < this.curves.length; ++i) {
                    yVals = new double[xValArray.length];
                    for (int j = 0; j < ((double[])yVals).length; ++j) {
                        yVals[j] = 1.0;
                    }
                    this.curves[i] = new LightFixedXFunc(xValArray, (double[])yVals);
                }
            }
            catch (Throwable t) {
                throw ExceptionUtils.asRuntimeException(t);
            }
            while (true) {
                ArrayDeque<Integer> arrayDeque = this.sourceIndexes;
                yVals = arrayDeque;
                // MONITORENTER : arrayDeque
                if (this.sourceIndexes.isEmpty()) {
                    // MONITOREXIT : yVals
                    return this.curves;
                }
                int sourceID = this.sourceIndexes.pop();
                // MONITOREXIT : yVals
                ProbEqkSource source = this.gridProv.getSource(sourceID, 1.0, null, QuickGriddedHazardMapCalc.this.gridSettings);
                TectonicRegionType trt = source.getTectonicRegionType();
                ScalarIMR gmpe = (ScalarIMR)gmpeMap.get(trt);
                QuickGriddedHazardMapCalc.this.quickSourceCalc(this.gridReg, source, gmpe, this.curves);
            }
        }
    }

    static class UniquePointRupture {
        private final double rake;
        private final double mag;
        private final double zTOR;
        private final double width;
        private final double dip;
        private final boolean footwall;
        private final double zHyp;
        private final PointSourceDistanceCorrection distCorr;
        private final int hash;

        public UniquePointRupture(EqkRupture rup) {
            Location loc;
            this.rake = rup.getAveRake();
            this.mag = rup.getMag();
            RuptureSurface surf = rup.getRuptureSurface();
            this.zTOR = surf.getAveRupTopDepth();
            this.width = surf.getAveWidth();
            this.dip = surf.getAveDip();
            PointSurface ptSurf = (PointSurface)surf;
            Location ptLoc = ptSurf.getLocation();
            this.footwall = surf instanceof FiniteApproxPointSurface ? ((FiniteApproxPointSurface)surf).isOnFootwall() : surf.getDistanceX(loc = LocationUtils.location(ptLoc, 0.0, 50.0)) < 0.0;
            this.distCorr = ptSurf.getDistanceCorrection();
            Location hypo = rup.getHypocenterLocation();
            this.zHyp = hypo == null ? ptLoc.getDepth() : hypo.getDepth();
            this.hash = Objects.hash(this.dip, this.footwall, this.mag, this.rake, this.width, this.zTOR, this.distCorr, this.zHyp);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniquePointRupture other = (UniquePointRupture)obj;
            return this.hash == other.hash && this.footwall == other.footwall && this.distCorr == other.distCorr && Double.doubleToLongBits(this.zHyp) == Double.doubleToLongBits(other.zHyp) && Double.doubleToLongBits(this.dip) == Double.doubleToLongBits(other.dip) && Double.doubleToLongBits(this.mag) == Double.doubleToLongBits(other.mag) && Double.doubleToLongBits(this.rake) == Double.doubleToLongBits(other.rake) && Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width) && Double.doubleToLongBits(this.zTOR) == Double.doubleToLongBits(other.zTOR);
        }
    }
}

