/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.MathArrays;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.faultSysSolution.hazard.AbstractLTVarianceDecomposition;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeHazardCompare;

public class SparseLTVarianceDecomposition
extends AbstractLTVarianceDecomposition {
    public SparseLTVarianceDecomposition(LogicTree<?> tree, List<LogicTreeLevel<?>> uniqueSamplingLevels, ExecutorService exec) {
        super(tree, uniqueSamplingLevels, exec);
    }

    @Override
    public AbstractLTVarianceDecomposition.VarianceContributionResult calcMapVarianceContributionForLevel(int levelIndex, LogicTreeLevel<?> level, Map<LogicTreeNode, List<GriddedGeoDataSet>> choiceMaps, Map<LogicTreeNode, List<Double>> choiceMapWeights) {
        Preconditions.checkState((this.allMaps.length == this.tree.size() ? 1 : 0) != 0);
        Preconditions.checkState((this.allMaps.length == this.allWeights.size() ? 1 : 0) != 0);
        if (this.uniqueSamplingLevels.contains(level)) {
            return null;
        }
        ArrayList<LogicTreeNode> choices = new ArrayList<LogicTreeNode>();
        ArrayList<GriddedGeoDataSet> choiceMeanMaps = new ArrayList<GriddedGeoDataSet>();
        ArrayList<Double> choiceWeights = new ArrayList<Double>();
        for (LogicTreeNode choice : choiceMapWeights.keySet()) {
            double sumWeight = 0.0;
            for (double weight : choiceMapWeights.get(choice)) {
                sumWeight += weight;
            }
            if (!(sumWeight > 0.0)) continue;
            choices.add(choice);
            choiceWeights.add(sumWeight);
            choiceMeanMaps.add(LogicTreeHazardCompare.buildMean(choiceMaps.get(choice), choiceMapWeights.get(choice)));
        }
        double[] weightsArray = MathArrays.normalizeArray((double[])Doubles.toArray(choiceWeights), (double)choiceWeights.size());
        if (choices.size() < 2) {
            return null;
        }
        double sumVar = 0.0;
        double maxVar = 0.0;
        double maxFractVar = 0.0;
        double sumCOV = 0.0;
        double maxCOV = 0.0;
        double maxFractCOV = 0.0;
        int numFinite = 0;
        Variance varCalc = new Variance(false);
        for (int i = 0; i < this.meanMap.size(); ++i) {
            double mean = this.meanMap.get(i);
            if (!(mean > 0.0) || !Double.isFinite(mean)) continue;
            double[] values = new double[choices.size()];
            for (int c = 0; c < choices.size(); ++c) {
                values[c] = ((GriddedGeoDataSet)choiceMeanMaps.get(c)).get(i);
            }
            double var = varCalc.evaluate(values, weightsArray, mean);
            double fullVar = this.fullVariance.get(i);
            if (!Double.isFinite(var)) continue;
            maxVar = Math.max(maxVar, var);
            maxFractVar = Math.max(maxFractVar, var / fullVar);
            sumVar += var;
            double sd = Math.sqrt(var);
            double cov = sd / mean;
            maxCOV = Math.max(maxCOV, cov);
            double fullCOV = Math.sqrt(fullVar) / mean;
            maxFractCOV = Math.max(maxFractCOV, cov / fullCOV);
            sumCOV += cov;
            ++numFinite;
        }
        if (numFinite > 0) {
            return new AbstractLTVarianceDecomposition.VarianceContributionResult(sumVar / (double)numFinite, maxVar, maxFractVar, sumCOV / (double)numFinite, maxCOV, maxFractCOV);
        }
        return null;
    }

    @Override
    public String getHeading() {
        return "Logic Tree Variance Contributions";
    }

    @Override
    public List<String> buildLines(List<AbstractLTVarianceDecomposition.VarianceContributionResult> results) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("This table summarizes how each logic tree branching level contributes to the overall variance in the model.");
        lines.add("");
        lines.add("This logic tree appears to be randomly-downsampled, so we estimate variance at each level as the weighted variance of the mean maps for each for each choice at that level. This method is less accurate than the marginal-averaging method used for complete logic trees because we are estimating branch-level variance from a few mean maps rather than the full distribution.");
        if (this.uniqueSamplingLevels.size() > 1) {
            lines.add("");
            lines.add("This logic tree contains multiple random sampling levels and variance cannot be decomposed between them. They are bundled into a single line of the table.");
        }
        lines.add("");
        lines.add("Both spatially averaged and maximum contributions are reported for each level.");
        lines.add("");
        double fullVarSum = 0.0;
        double fullVarMax = 0.0;
        int numValid = 0;
        for (int i = 0; i < this.fullVariance.size(); ++i) {
            double var = this.fullVariance.get(i);
            double mean = this.meanMap.get(i);
            if (!Double.isFinite(var) || !Double.isFinite(mean)) continue;
            double cov = Math.sqrt(var) / mean;
            fullVarSum += var;
            fullVarMax = Math.max(fullVarMax, var);
            ++numValid;
        }
        double fullVar = fullVarSum / (double)numValid;
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine("Branch Level", "Average Variance Contribution", "Maximum Variance Contribution");
        int numLevels = this.tree.getLevels().size();
        Preconditions.checkState((results.size() == numLevels ? 1 : 0) != 0);
        int numWithResults = 0;
        for (int l = 0; l < numLevels; ++l) {
            AbstractLTVarianceDecomposition.VarianceContributionResult varResult = results.get(l);
            if (varResult == null) continue;
            ++numWithResults;
            LogicTreeLevel level = (LogicTreeLevel)this.tree.getLevels().get(l);
            Object levelName = level.getName();
            if (this.uniqueSamplingLevels.size() > 1 && this.uniqueSamplingLevels.get(0) == level) {
                levelName = this.uniqueSamplingLevels.size() + " sampling levels: ";
                for (int i = 0; i < this.uniqueSamplingLevels.size(); ++i) {
                    if (i > 0) {
                        levelName = (String)levelName + ", ";
                    }
                    levelName = (String)levelName + ((LogicTreeLevel)this.uniqueSamplingLevels.get(i)).getShortName();
                }
            }
            double fractVar = varResult.meanVarianceContribution / fullVar;
            table.addLine(new String[]{levelName, LogicTreeHazardCompare.pDF.format(fractVar), LogicTreeHazardCompare.pDF.format(varResult.maxFractionalVarianceContribution)});
        }
        if (!this.uniqueSamplingLevels.isEmpty()) {
            double sumAvgVarContrib = 0.0;
            for (AbstractLTVarianceDecomposition.VarianceContributionResult varResult : results) {
                if (varResult == null) continue;
                sumAvgVarContrib += varResult.meanVarianceContribution;
            }
            double unexplainedFractVar = 1.0 - sumAvgVarContrib / fullVar;
            Object levelName = "Unexplained, potentially attributable to ";
            if (this.uniqueSamplingLevels.size() > 1) {
                levelName = (String)levelName + this.uniqueSamplingLevels.size() + " sampling levels: ";
                for (int i = 0; i < this.uniqueSamplingLevels.size(); ++i) {
                    if (i > 0) {
                        levelName = (String)levelName + ", ";
                    }
                    levelName = (String)levelName + ((LogicTreeLevel)this.uniqueSamplingLevels.get(i)).getShortName();
                }
            } else {
                levelName = (String)levelName + ((LogicTreeLevel)this.uniqueSamplingLevels.get(0)).getName();
            }
            table.addLine(new String[]{levelName, LogicTreeHazardCompare.pDF.format(unexplainedFractVar), ""});
        }
        if (numWithResults < 2) {
            return null;
        }
        lines.addAll(table.build());
        lines.add("");
        return lines;
    }
}

