/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard.mpj;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ExecutorUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.AbstractSitewiseThreadedLogicTreeCalc;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysHazardCalcSettings;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.imr.AttenRelSupplier;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;

public class MPJ_SiteLogicTreeHazardCurveCalc
extends MPJTaskCalculator {
    public static final String SITES_CSV_FILE_NAME = "sites.csv";
    private CSVFile<String> inputSitesCSV;
    private List<Site> sites;
    private static final double[] PERIODS_DEFAULT = new double[]{0.0, 1.0};
    private double[] periods = PERIODS_DEFAULT;
    private static final IncludeBackgroundOption GRID_SEIS_DEFAULT = IncludeBackgroundOption.INCLUDE;
    private IncludeBackgroundOption gridSeisOp = GRID_SEIS_DEFAULT;
    private GriddedSeismicitySettings griddedSettings;
    private Map<TectonicRegionType, AttenRelSupplier> gmms;
    private SourceFilterManager sourceFilters;
    private SolutionLogicTree solTree;
    private LogicTree<?> tree;
    private AbstractSitewiseThreadedLogicTreeCalc calc;
    private DiscretizedFunc[] xVals;
    private File outputDir;
    private List<String> sitePrefixes;
    private List<List<CSVFile<String>>> siteCSVs;
    private ExecutorService exec;
    private File branchOutputDir;
    private File outputFile;
    private boolean recalc;
    private HashSet<Integer> doneIndexes;

    public MPJ_SiteLogicTreeHazardCurveCalc(CommandLine cmd) throws IOException {
        super(cmd);
        LogicTree<LogicTreeNode> tree;
        Object logicTreeFile;
        this.shuffle = false;
        File inputFile = new File(cmd.getOptionValue("input-file"));
        Preconditions.checkState((boolean)inputFile.exists());
        if (inputFile.isDirectory()) {
            Preconditions.checkArgument((boolean)cmd.hasOption("logic-tree"), (Object)"Must supply logic tree file if input-file is a results directory");
            logicTreeFile = new File(cmd.getOptionValue("logic-tree"));
            Preconditions.checkArgument((boolean)((File)logicTreeFile).exists(), (String)"Logic tree file doesn't exist: %s", (Object)((File)logicTreeFile).getAbsolutePath());
            tree = LogicTree.read((File)logicTreeFile);
            this.solTree = new SolutionLogicTree.ResultsDirReader(inputFile, tree);
        } else if (cmd.hasOption("logic-tree")) {
            logicTreeFile = new File(cmd.getOptionValue("logic-tree"));
            Preconditions.checkArgument((boolean)((File)logicTreeFile).exists(), (String)"Logic tree file doesn't exist: %s", (Object)((File)logicTreeFile).getAbsolutePath());
            tree = LogicTree.read((File)logicTreeFile);
            this.solTree = SolutionLogicTree.load(inputFile, tree);
        } else {
            this.solTree = SolutionLogicTree.load(inputFile);
        }
        this.tree = this.solTree.getLogicTree();
        if (this.rank == 0) {
            this.debug("Loaded " + this.solTree.getLogicTree().size() + " tree nodes/solutions");
        }
        this.outputDir = new File(cmd.getOptionValue("output-dir"));
        if (cmd.hasOption("gridded-seis")) {
            this.gridSeisOp = IncludeBackgroundOption.valueOf(cmd.getOptionValue("gridded-seis"));
        }
        this.griddedSettings = FaultSysHazardCalcSettings.getGridSeisSettings(cmd);
        if (this.gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
            this.debug("Gridded settings: " + String.valueOf(this.griddedSettings));
        }
        this.sourceFilters = FaultSysHazardCalcSettings.getSourceFilters(cmd);
        this.gmms = FaultSysHazardCalcSettings.getGMMs(cmd);
        if (this.rank == 0) {
            this.debug("GMMs:");
            for (TectonicRegionType trt : this.gmms.keySet()) {
                this.debug("\tGMM for " + trt.name() + ": " + this.gmms.get(trt).getName());
            }
        }
        if (cmd.hasOption("periods")) {
            ArrayList<Double> periodsList = new ArrayList<Double>();
            String periodsStr = cmd.getOptionValue("periods");
            if (periodsStr.contains(",")) {
                String[] split = periodsStr.split(",");
                for (String str : split) {
                    periodsList.add(Double.parseDouble(str));
                }
            } else {
                periodsList.add(Double.parseDouble(periodsStr));
            }
            this.periods = Doubles.toArray(periodsList);
        }
        File sitesFile = new File(cmd.getOptionValue("sites-file"));
        Preconditions.checkState((boolean)sitesFile.exists());
        this.inputSitesCSV = CSVFile.readFile(sitesFile, true);
        this.sites = MPJ_SiteLogicTreeHazardCurveCalc.parseSitesCSV(this.inputSitesCSV, FaultSysHazardCalcSettings.getDefaultRefSiteParams(this.gmms));
        this.sitePrefixes = new ArrayList<String>();
        this.siteCSVs = new ArrayList<List<CSVFile<String>>>();
        for (Site site : this.sites) {
            if (this.rank == 0) {
                this.debug("Site " + site.getName() + " at " + String.valueOf(site.getLocation()));
                for (Parameter param : site) {
                    this.debug(param.getName() + ": " + String.valueOf(param.getValue()));
                }
            }
            this.sitePrefixes.add(FileNameUtils.simplify(site.getName()));
            this.siteCSVs.add(null);
        }
        this.recalc = cmd.hasOption("recalc");
        this.branchOutputDir = new File(this.outputDir, "branch_results");
        if (this.rank == 0) {
            Preconditions.checkState((this.outputDir.exists() || this.outputDir.mkdir() ? 1 : 0) != 0);
            this.clearPreviousProcessDirs(false);
            this.initBranchDirs();
            this.outputFile = cmd.hasOption("output-file") ? new File(cmd.getOptionValue("output-file")) : new File(this.outputDir.getParentFile(), this.outputDir.getName() + ".zip");
        }
        int threads = this.getNumThreads();
        this.exec = ExecutorUtils.newBlockingThreadPool(threads);
        this.calc = new AbstractSitewiseThreadedLogicTreeCalc(this.exec, this.sites.size(), this.solTree, this.gmms, this.periods, this.gridSeisOp, this.griddedSettings, this.sourceFilters){

            @Override
            public Site siteForIndex(int siteIndex, Map<TectonicRegionType, ScalarIMR> gmms) {
                return MPJ_SiteLogicTreeHazardCurveCalc.this.sites.get(siteIndex);
            }

            @Override
            public void debug(String message) {
                MPJ_SiteLogicTreeHazardCurveCalc.this.debug(message);
            }
        };
        this.xVals = this.calc.getXVals();
        this.calc.setDoGmmInputCache(cmd.hasOption("cache-gmm-inputs"));
    }

    protected Collection<Integer> getDoneIndexes() {
        return this.doneIndexes;
    }

    public static List<Site> parseSitesCSV(CSVFile<String> sitesCSV, ParameterList siteParams) {
        ArrayList<Site> sites = new ArrayList<Site>();
        for (int row = 0; row < sitesCSV.getNumRows(); ++row) {
            if (row == 0) {
                try {
                    sitesCSV.getDouble(row, 1);
                    sitesCSV.getDouble(row, 2);
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            String siteName = sitesCSV.get(row, 0).trim();
            double lat = sitesCSV.getDouble(row, 1);
            double lon = sitesCSV.getDouble(row, 2);
            Location loc = new Location(lat, lon);
            Site site = new Site(loc, siteName);
            if (siteParams != null) {
                for (Parameter<?> param : siteParams) {
                    site.addParameter((Parameter)param.clone());
                }
                for (int col = 3; col < sitesCSV.getNumCols(); ++col) {
                    String paramName = sitesCSV.get(0, col);
                    boolean found = false;
                    for (Parameter<?> param : site) {
                        if (!param.getName().toLowerCase().equals(paramName.toLowerCase())) continue;
                        found = true;
                        if (param instanceof DoubleParameter) {
                            ((DoubleParameter)param).setValue(sitesCSV.getDouble(row, col));
                            continue;
                        }
                        if (param instanceof StringParameter) {
                            ((StringParameter)param).setValue(sitesCSV.get(row, col));
                            continue;
                        }
                        if (param instanceof BooleanParameter) {
                            ((BooleanParameter)param).setValue(sitesCSV.getBoolean(row, col));
                            continue;
                        }
                        throw new IllegalStateException("Site parameter " + paramName + " could not be set, unsupported type: " + param.getClass().getName());
                    }
                    if (found) continue;
                    System.err.println("WARNING: GMM does not have parameter " + paramName + ", skipping from site CSV");
                }
            }
            sites.add(site);
        }
        Preconditions.checkState((!sites.isEmpty() ? 1 : 0) != 0);
        return sites;
    }

    protected int getNumTasks() {
        return this.tree.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateBatch(int[] batch) throws Exception {
        for (int branchIndex : batch) {
            File branchCSV;
            if (!this.recalc && (branchCSV = this.getBranchCSV(branchIndex)).exists()) {
                try {
                    int row;
                    this.debug("reading previously written branch CSV: " + branchCSV.getAbsolutePath());
                    CSVFile<String> csv = CSVFile.readFile(branchCSV, true);
                    int expectedRows = 1 + this.sites.size() * this.periods.length;
                    Preconditions.checkState((csv.getNumRows() == expectedRows ? 1 : 0) != 0, (String)"Expected %s rows, have %s for branch %s csv", (Object)expectedRows, (Object)csv.getNumRows(), (Object)branchIndex);
                    int[] periodIndexes = new int[expectedRows];
                    int[] siteIndexes = new int[expectedRows];
                    for (row = 1; row < expectedRows; ++row) {
                        float period = csv.getFloat(row, 0);
                        int periodIndex = -1;
                        for (int p = 0; p < this.periods.length; ++p) {
                            if ((float)this.periods[p] != period) continue;
                            periodIndex = p;
                            break;
                        }
                        Preconditions.checkState((periodIndex >= 0 ? 1 : 0) != 0, (String)"Period not found: %s", (Object)Float.valueOf(period));
                        periodIndexes[row] = periodIndex;
                        String siteName = csv.get(row, 1);
                        int siteIndex = -1;
                        for (int s = 0; s < this.sites.size(); ++s) {
                            if (!siteName.equals(this.sites.get(s).getName())) continue;
                            siteIndex = s;
                            break;
                        }
                        Preconditions.checkState((siteIndex >= 0 ? 1 : 0) != 0, (String)"Site not found: %s", (Object)siteName);
                        siteIndexes[row] = siteIndex;
                        List<CSVFile<String>> csvs = this.getInitSiteCSVs(siteIndex);
                        int myCols = csv.getNumCols();
                        int periodCols = csvs.get(periodIndex).getNumCols();
                        Preconditions.checkState((periodCols == myCols - 1 ? 1 : 0) != 0, (String)"Unexpected number of columns, branchCSV has %s and expected %s", (int)myCols, (int)(periodCols + 1));
                    }
                    for (row = 1; row < expectedRows; ++row) {
                        List<CSVFile<String>> csvs2 = this.getInitSiteCSVs(siteIndexes[row]);
                        List<String> line = csv.getLine(row);
                        csvs2.get(periodIndexes[row]).addLine(line.subList(1, line.size()));
                    }
                    this.debug("Skipping " + branchIndex + " (already done)");
                    continue;
                }
                catch (Exception e) {
                    this.debug("error reading cache for " + branchIndex + ", will recalculate: " + e.getMessage());
                }
            }
            DiscretizedFunc[][] curves = this.calc.calcForBranch(branchIndex);
            LogicTreeBranch<?> branch = this.tree.getBranch(branchIndex);
            List<String> csvHeader = null;
            ArrayList sitesPeriodCSVLines = new ArrayList(this.sites.size());
            for (int siteIndex = 0; siteIndex < this.sites.size(); ++siteIndex) {
                Object node2;
                List<CSVFile<String>> csvs;
                List<List<CSVFile<String>>> csvs2 = this.siteCSVs;
                synchronized (csvs2) {
                    csvs = this.getInitSiteCSVs(siteIndex);
                }
                if (csvHeader == null) {
                    csvHeader = csvs.get(0).getLine(0);
                }
                ArrayList<Object> commonPrefix = new ArrayList<Object>();
                commonPrefix.add(this.sites.get(siteIndex).getName());
                commonPrefix.add("" + branchIndex);
                commonPrefix.add("" + this.tree.getBranchWeight(branchIndex));
                for (Object node2 : branch) {
                    commonPrefix.add(node2.getShortName());
                }
                ArrayList sitePeriodCSVLines = new ArrayList();
                sitesPeriodCSVLines.add(sitePeriodCSVLines);
                node2 = csvs;
                synchronized (node2) {
                    for (int p = 0; p < this.periods.length; ++p) {
                        ArrayList<Object> line = new ArrayList<Object>(commonPrefix.size() + this.xVals[p].size());
                        line.addAll(commonPrefix);
                        for (Point2D pt : curves[siteIndex][p]) {
                            line.add("" + pt.getY());
                        }
                        csvs.get(p).addLine((List<String>)line);
                        sitePeriodCSVLines.add(line);
                    }
                    continue;
                }
            }
            File branchCSVFile = null;
            CSVFile branchCSV2 = null;
            for (int siteIndex = 0; siteIndex < this.sites.size(); ++siteIndex) {
                if (branchCSV2 == null) {
                    branchCSVFile = this.getBranchCSV(branchIndex);
                    branchCSV2 = new CSVFile(true);
                    ArrayList<String> header = new ArrayList<String>(csvHeader.size() + 1);
                    header.add("Period (s)");
                    header.addAll(csvHeader);
                    branchCSV2.addLine(header);
                }
                for (int p = 0; p < this.periods.length; ++p) {
                    List line = (List)((List)sitesPeriodCSVLines.get(siteIndex)).get(p);
                    ArrayList<CallSite> periodLine = new ArrayList<CallSite>(line.size() + 1);
                    periodLine.add((CallSite)((Object)("" + (float)this.periods[p])));
                    periodLine.addAll(line);
                    branchCSV2.addLine(periodLine);
                }
            }
            branchCSV2.writeToFile(branchCSVFile);
        }
    }

    private void initBranchDirs() {
        Preconditions.checkState((this.branchOutputDir.exists() || this.branchOutputDir.mkdir() ? 1 : 0) != 0);
        int numBranches = this.getNumTasks();
        if (numBranches > 1000) {
            for (int branchIndex = 0; branchIndex < numBranches; branchIndex += 1000) {
                File branchDir = this.getBranchDir(branchIndex);
                if (branchDir.exists()) continue;
                Preconditions.checkState((branchDir.exists() || branchDir.mkdir() ? 1 : 0) != 0);
            }
        }
    }

    private File getBranchCSV(int branchIndex) {
        File branchDir = this.getBranchDir(branchIndex);
        return new File(branchDir, "branch_" + branchIndex + ".csv");
    }

    private File getBranchDir(int branchIndex) {
        int numBranches = this.getNumTasks();
        if (numBranches > 1000) {
            int bundleIndex = branchIndex / 1000;
            return new File(this.branchOutputDir, "branches_" + bundleIndex * 1000 + "_" + (bundleIndex + 1) * 1000);
        }
        return this.branchOutputDir;
    }

    private List<CSVFile<String>> getInitSiteCSVs(int siteIndex) {
        List<CSVFile<String>> csvs = this.siteCSVs.get(siteIndex);
        if (csvs == null) {
            csvs = new ArrayList<CSVFile<String>>();
            LogicTreeBranch<?> branch = this.tree.getBranch(0);
            for (int p = 0; p < this.periods.length; ++p) {
                CSVFile csv = new CSVFile(true);
                ArrayList<Object> header = new ArrayList<Object>();
                header.add("Site Name");
                header.add("Branch Index");
                header.add("Branch Weight");
                for (int l = 0; l < branch.size(); ++l) {
                    header.add(branch.getLevel(l).getShortName());
                }
                for (Point2D pt : this.xVals[p]) {
                    header.add("" + (float)pt.getX());
                }
                csv.addLine(header);
                csvs.add(csv);
            }
            this.siteCSVs.set(siteIndex, csvs);
        }
        return csvs;
    }

    private void writeProcessCSVs() throws IOException {
        File processDir = new File(this.outputDir, "process_" + this.rank);
        Preconditions.checkState((processDir.exists() || processDir.mkdir() ? 1 : 0) != 0);
        for (int s = 0; s < this.sites.size(); ++s) {
            List<CSVFile<String>> csvs = this.siteCSVs.get(s);
            if (csvs == null) continue;
            for (int p = 0; p < csvs.size(); ++p) {
                CSVFile<String> csv = csvs.get(p);
                String csvName = this.getCSVName(s, p);
                csv.writeToFile(new File(processDir, csvName));
            }
        }
    }

    protected void doFinalAssembly() throws Exception {
        this.exec.shutdown();
        if (this.rank > 0) {
            this.writeProcessCSVs();
        }
        MPI.COMM_WORLD.Barrier();
        if (this.rank == 0) {
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(this.outputFile));
            ZipOutputStream zout = new ZipOutputStream(bout);
            zout.putNextEntry(new ZipEntry(SITES_CSV_FILE_NAME));
            this.inputSitesCSV.writeToStream(zout);
            zout.closeEntry();
            zout.putNextEntry(new ZipEntry(this.tree.getFileName()));
            this.tree.writeToStream(new BufferedOutputStream(zout));
            zout.closeEntry();
            OutputStreamWriter zipWriter = new OutputStreamWriter(new BufferedOutputStream(zout));
            for (int s = 0; s < this.sites.size(); ++s) {
                List<CSVFile<String>> csvs = this.siteCSVs.get(s);
                String siteName = this.sites.get(s).getName();
                for (int p = 0; p < this.periods.length; ++p) {
                    int numWritten = 0;
                    String csvName = this.getCSVName(s, p);
                    FileWriter fw = new FileWriter(new File(this.outputDir, csvName));
                    zout.putNextEntry(new ZipEntry(csvName));
                    for (int rank = 0; rank < this.size; ++rank) {
                        CSVFile<String> csv;
                        if (rank == 0) {
                            csv = csvs == null ? null : csvs.get(p);
                        } else {
                            File processDir = new File(this.outputDir, "process_" + rank);
                            Preconditions.checkState((boolean)processDir.exists(), (String)"Process %s dir doesn't exist: %s", (int)rank, (Object)processDir.getAbsolutePath());
                            File sourceCSVFile = new File(processDir, csvName);
                            csv = sourceCSVFile.exists() ? CSVFile.readFile(sourceCSVFile, true) : null;
                        }
                        if (csv == null) {
                            this.debug("No curves from " + rank + " for site " + siteName + ", period=" + (float)this.periods[p]);
                            continue;
                        }
                        int myNum = csv.getNumRows() - 1;
                        this.debug("Merging in " + myNum + " curves from " + rank + " for site " + siteName + ", period=" + (float)this.periods[p]);
                        if (numWritten == 0) {
                            String headerLine = csv.getLineStr(0) + "\n";
                            fw.write(headerLine);
                            zipWriter.write(headerLine);
                        }
                        for (int row = 1; row < csv.getNumRows(); ++row) {
                            ++numWritten;
                            String line = csv.getLineStr(row) + "\n";
                            fw.write(line);
                            zipWriter.write(line);
                        }
                    }
                    Preconditions.checkState((numWritten == this.tree.size() ? 1 : 0) != 0, (String)"Wrote %s curves for site %s period %s, expected %s", (Object)numWritten, (Object)siteName, (Object)this.periods[p], (Object)this.tree.size());
                    fw.close();
                    zipWriter.flush();
                    zout.closeEntry();
                }
            }
            zout.close();
            this.clearPreviousProcessDirs(true);
        }
    }

    private void clearPreviousProcessDirs(boolean ensureExists) {
        for (int rank = 0; rank < this.size; ++rank) {
            File processDir = new File(this.outputDir, "process_" + rank);
            if (ensureExists && rank > 0) {
                Preconditions.checkState((boolean)processDir.exists());
            } else if (!processDir.exists()) continue;
            this.debug("Clearing out cache directory for process " + rank + ": " + processDir.getAbsolutePath());
            FileUtils.deleteRecursive(processDir);
        }
    }

    public static String getSitePeriodPrefix(String siteName, double period) {
        return MPJ_SiteLogicTreeHazardCurveCalc.getSitePeriodPrefixConcat(FileNameUtils.simplify(siteName), period);
    }

    private static String getSitePeriodPrefixConcat(String sitePrefix, double period) {
        Object ret = sitePrefix;
        ret = period == -1.0 ? (String)ret + "_pgv" : (period == 0.0 ? (String)ret + "_pga" : (String)ret + "_sa_" + (float)period);
        return ret;
    }

    private String getCSVName(int siteIndex, int periodIndex) {
        return MPJ_SiteLogicTreeHazardCurveCalc.getSitePeriodPrefixConcat(this.sitePrefixes.get(siteIndex), this.periods[periodIndex]) + ".csv";
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        FaultSysHazardCalcSettings.addCommonOptions(ops, false);
        ops.addRequiredOption("if", "input-file", true, "Path to input file (solution logic tree zip)");
        ops.addOption("lt", "logic-tree", true, "Path to logic tree JSON file, required if a results directory is supplied with --input-file");
        ops.addRequiredOption("sf", "sites-file", true, "Path to sites CSV file");
        ops.addRequiredOption("od", "output-dir", true, "Path to output directory");
        ops.addOption("of", "output-file", true, "Path to output zip file. Default will be based on the output directory");
        ops.addOption("gs", "gridded-seis", true, "Gridded seismicity option. One of " + FaultSysTools.enumOptions(IncludeBackgroundOption.class) + ". Default: " + GRID_SEIS_DEFAULT.name());
        ops.addOption(null, "recalc", false, "Flag to force recalculation (ignore checkpoints)");
        ops.addOption(null, "cache-gmm-inputs", false, "Flag to enable caching of GMM inputs (for nshmp-haz GMMs)");
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_SiteLogicTreeHazardCurveCalc.createOptions();
            CommandLine cmd = MPJ_SiteLogicTreeHazardCurveCalc.parse((Options)options, (String[])args, MPJ_SiteLogicTreeHazardCurveCalc.class);
            MPJ_SiteLogicTreeHazardCurveCalc driver = new MPJ_SiteLogicTreeHazardCurveCalc(cmd);
            driver.run();
            MPJ_SiteLogicTreeHazardCurveCalc.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_SiteLogicTreeHazardCurveCalc.abortAndExit((Throwable)t);
        }
    }
}

