/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfigurationFactory;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionSolver;
import org.opensha.sha.earthquake.faultSysSolution.modules.ConnectivityClusters;
import org.opensha.sha.earthquake.faultSysSolution.modules.InitialSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfits;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.modules.WaterLevelRates;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.ConnectivityCluster;

public class ClusterSpecificInversionSolver
extends InversionSolver.Default {
    protected RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getRuptureExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        return null;
    }

    protected boolean shouldInvert(ConnectivityCluster cluster) {
        return true;
    }

    @Override
    public FaultSystemSolution run(FaultSystemRupSet rupSet, InversionConfigurationFactory factory, LogicTreeBranch<?> branch, int threads, CommandLine cmd) throws IOException {
        ArrayList clusters;
        RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel = this.getRuptureExclusionModel(rupSet, branch);
        if (rupExclusionModel != null) {
            clusters = ConnectivityCluster.build(rupSet, rupExclusionModel);
            rupSet.addModule(new ConnectivityClusters(rupSet, clusters));
        } else if (rupSet.hasModule(ConnectivityClusters.class)) {
            clusters = rupSet.requireModule(ConnectivityClusters.class).get();
        } else {
            ConnectivityClusters clusterModule = ConnectivityClusters.build(rupSet);
            rupSet.addModule(clusterModule);
            clusters = clusterModule.get();
        }
        Preconditions.checkState((!clusters.isEmpty() ? 1 : 0) != 0, (Object)"No clusters found?");
        clusters = new ArrayList(clusters);
        Collections.sort(clusters, ConnectivityCluster.rupCountComparator);
        Collections.reverse(clusters);
        if (clusters.size() > 1) {
            System.out.println("Will invert for " + clusters.size() + " separate connectivity clusters");
            ArrayList<FaultSystemSolution> solutions = new ArrayList<FaultSystemSolution>(clusters.size());
            int numInverted = 0;
            for (ConnectivityCluster cluster : clusters) {
                Object clusterName = cluster.toString();
                if (cluster.getParentSectIDs().size() == 1) {
                    int sectIndex = cluster.getSectIDs().iterator().next();
                    String parentName = rupSet.getFaultSectionData(sectIndex).getParentSectionName();
                    clusterName = (String)clusterName + ", " + parentName;
                }
                if (!this.shouldInvert(cluster)) {
                    solutions.add(null);
                    System.out.println("Skipping inversion for cluster: " + (String)clusterName);
                    continue;
                }
                System.out.println("Handling cluster: " + (String)clusterName);
                System.out.println("Building subset rupture set for " + (String)clusterName);
                FaultSystemRupSet clusterRupSet = rupSet.getForSectionSubSet(cluster.getSectIDs(), rupExclusionModel);
                System.out.println("Building subset inversion configuration for " + (String)clusterName);
                InversionConfiguration config = factory.buildInversionConfig(clusterRupSet, branch, threads);
                if (config == null) {
                    solutions.add(null);
                    continue;
                }
                if (cmd != null) {
                    config = InversionConfiguration.builder(config).forCommandLine(cmd).build();
                }
                solutions.add(this.run(clusterRupSet, config));
                ++numInverted;
            }
            System.out.println("Finished " + numInverted + " cluster-specific inversions, combining");
            if (numInverted == 0) {
                return null;
            }
            double[] rates = new double[rupSet.getNumRuptures()];
            double[] waterLevelRates = null;
            double[] initialRates = null;
            ArrayList<InversionMisfits> solMisfits = new ArrayList<InversionMisfits>();
            HashMap<ConnectivityCluster, InversionMisfitStats> clusterMisfitsMap = new HashMap<ConnectivityCluster, InversionMisfitStats>();
            InversionMisfitProgress largestProgress = null;
            for (int i = 0; i < solutions.size(); ++i) {
                InitialSolution subsetInitial;
                ConnectivityCluster cluster = (ConnectivityCluster)clusters.get(i);
                FaultSystemSolution clusterSol = (FaultSystemSolution)solutions.get(i);
                if (clusterSol == null) continue;
                FaultSystemRupSet clusterRupSet = clusterSol.getRupSet();
                RuptureSubSetMappings mappings = clusterRupSet.requireModule(RuptureSubSetMappings.class);
                WaterLevelRates subsetWL = clusterSol.getModule(WaterLevelRates.class);
                if (subsetWL != null && waterLevelRates == null) {
                    waterLevelRates = new double[rates.length];
                }
                if ((subsetInitial = clusterSol.getModule(InitialSolution.class)) != null && initialRates == null) {
                    initialRates = new double[rates.length];
                }
                for (int subsetID = 0; subsetID < clusterRupSet.getNumRuptures(); ++subsetID) {
                    int fullID = mappings.getOrigRupID(subsetID);
                    Preconditions.checkState((rates[fullID] == 0.0 ? 1 : 0) != 0, (String)"Rupture %s (%s in the subset solution) was already non-zero (%s), used in multiple clusters?", (Object)fullID, (Object)subsetID, (Object)rates[fullID]);
                    rates[fullID] = clusterSol.getRateForRup(subsetID);
                    if (subsetWL != null) {
                        waterLevelRates[fullID] = subsetWL.get(subsetID);
                    }
                    if (subsetInitial == null) continue;
                    initialRates[fullID] = subsetInitial.get(subsetID);
                }
                InversionMisfits misfits = clusterSol.requireModule(InversionMisfits.class);
                solMisfits.add(misfits);
                clusterMisfitsMap.put(cluster, misfits.getMisfitStats());
                if (largestProgress != null) continue;
                largestProgress = clusterSol.getModule(InversionMisfitProgress.class);
            }
            FaultSystemSolution sol = new FaultSystemSolution(rupSet, rates);
            if (waterLevelRates != null) {
                sol.addModule(new WaterLevelRates(waterLevelRates));
            }
            if (initialRates != null) {
                sol.addModule(new InitialSolution(initialRates));
            }
            InversionMisfits misfits = InversionMisfits.appendSeparate(solMisfits);
            sol.addModule(misfits);
            sol.addModule(misfits.getMisfitStats());
            sol.addModule(new ConnectivityClusters.ConnectivityClusterSolutionMisfits(sol, clusterMisfitsMap, largestProgress));
            SolutionLogicTree.SolutionProcessor processor = factory.getSolutionLogicTreeProcessor();
            if (processor != null) {
                processor.processSolution(sol, branch);
            }
            return sol;
        }
        ConnectivityCluster cluster = (ConnectivityCluster)clusters.get(0);
        if (!this.shouldInvert(cluster)) {
            return null;
        }
        System.out.println("Only 1 connectivity cluster, will run regular inversion");
        InversionConfiguration config = factory.buildInversionConfig(rupSet, branch, threads);
        if (branch != rupSet.getModule(LogicTreeBranch.class)) {
            rupSet.addModule(branch);
        }
        if (cmd != null) {
            config = InversionConfiguration.builder(config).forCommandLine(cmd).build();
        }
        FaultSystemSolution sol = this.run(rupSet, config);
        SolutionLogicTree.SolutionProcessor processor = factory.getSolutionLogicTreeProcessor();
        if (processor != null) {
            processor.processSolution(sol, branch);
        }
        return sol;
    }
}

