/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.primitives.Doubles;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class JumpProbabilityConstraint
extends InversionConstraint {
    public static final boolean D = false;
    protected transient FaultSystemRupSet rupSet;
    private transient Map<Jump.UniqueDistJump, List<Integer>> jumpRupsMap;
    @JsonAdapter(value=JumpProbabilityCalc.GenericJumpProbCalcAdapter.class)
    private JumpProbabilityCalc jumpProbCalc;
    private static final double MAX_WEIGHT_SCALAR = 100000.0;

    protected JumpProbabilityConstraint(String name, String shortName, double weight, boolean inequality, ConstraintWeightingType weightingType, FaultSystemRupSet rupSet, JumpProbabilityCalc jumpProbCalc) {
        super(name, shortName, weight, inequality, weightingType);
        this.setRuptureSet(rupSet);
        this.jumpProbCalc = jumpProbCalc;
    }

    private synchronized void checkInitJumpRups() {
        if (this.jumpRupsMap == null) {
            this.jumpRupsMap = new HashMap<Jump.UniqueDistJump, List<Integer>>();
            ClusterRuptures cRups = this.rupSet.requireModule(ClusterRuptures.class);
            for (int r = 0; r < cRups.size(); ++r) {
                ClusterRupture rup = cRups.get(r);
                for (Jump jump : rup.getJumpsIterable()) {
                    Jump.UniqueDistJump udJump = new Jump.UniqueDistJump(jump);
                    List<Integer> jumpRups = this.jumpRupsMap.get(udJump);
                    if (jumpRups == null) {
                        jumpRups = new ArrayList<Integer>();
                        this.jumpRupsMap.put(udJump, jumpRups);
                    }
                    jumpRups.add(r);
                    udJump = udJump.reverse();
                    jumpRups = this.jumpRupsMap.get(udJump);
                    if (jumpRups == null) {
                        jumpRups = new ArrayList<Integer>();
                        this.jumpRupsMap.put(udJump, jumpRups);
                    }
                    jumpRups.add(r);
                }
            }
        }
    }

    @Override
    public int getNumRows() {
        this.checkInitJumpRups();
        return this.jumpRupsMap.size();
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        this.checkInitJumpRups();
        ArrayList<Jump.UniqueDistJump> allJumps = new ArrayList<Jump.UniqueDistJump>(this.jumpRupsMap.keySet());
        allJumps.sort(Jump.id_comparator);
        long count = 0L;
        int row = startRow;
        ClusterRuptures cRups = this.rupSet.requireModule(ClusterRuptures.class);
        HashBasedTable departingSectJumpProbs = HashBasedTable.create();
        for (Jump.UniqueDistJump jump : allJumps) {
            List<Integer> rupsUsingJump = this.jumpRupsMap.get(jump);
            Preconditions.checkNotNull((Object)(rupsUsingJump != null ? 1 : 0));
            Preconditions.checkState((!rupsUsingJump.isEmpty() ? 1 : 0) != 0);
            DataUtils.MinMaxAveTracker probTrack = new DataUtils.MinMaxAveTracker();
            for (int r : rupsUsingJump) {
                ClusterRupture rup = cRups.get(r);
                RuptureTreeNavigator nav = rup.getTreeNavigator();
                Jump myJump = nav.getJump(jump.fromSection, jump.toSection);
                Preconditions.checkState((myJump.fromSection.getSectionId() == jump.fromSection.getSectionId() ? 1 : 0) != 0);
                if (!myJump.fromCluster.endSects.contains((Object)myJump.fromSection)) {
                    myJump = new Jump(myJump.fromSection, myJump.fromCluster.reversed(), myJump.toSection, myJump.toCluster, myJump.distance);
                }
                Preconditions.checkState((boolean)myJump.fromCluster.endSects.contains((Object)myJump.fromSection));
                if (!myJump.toCluster.startSect.equals(myJump.toSection)) {
                    myJump = new Jump(myJump.fromSection, myJump.fromCluster, myJump.toSection, myJump.toCluster.reversed(), myJump.distance);
                }
                Preconditions.checkState((boolean)myJump.toCluster.startSect.equals(myJump.toSection));
                double prob = this.jumpProbCalc.calcJumpProbability(rup, myJump, false);
                probTrack.addValue(prob);
            }
            double avgRupProbUsing = probTrack.getAverage();
            departingSectJumpProbs.put((Object)jump.fromSection.getSectionId(), (Object)jump, (Object)avgRupProbUsing);
        }
        Map<Integer, List<FaultSection>> parentSectsMap = this.rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        for (Jump.UniqueDistJump jump : allJumps) {
            double jumpCondProb;
            List<Integer> rupsUsingJump = this.jumpRupsMap.get(jump);
            Preconditions.checkNotNull((Object)(rupsUsingJump != null ? 1 : 0));
            Preconditions.checkState((!rupsUsingJump.isEmpty() ? 1 : 0) != 0);
            int fromID = jump.fromSection.getSectionId();
            List<Integer> allJumpsForDepartingSect = this.rupSet.getRupturesForSection(fromID);
            Preconditions.checkState((allJumpsForDepartingSect.size() >= rupsUsingJump.size() ? 1 : 0) != 0);
            double myJumpProb = (Double)departingSectJumpProbs.get((Object)fromID, (Object)jump);
            Preconditions.checkState((Double.isFinite(myJumpProb) && myJumpProb >= 0.0 && myJumpProb <= 1.0 ? 1 : 0) != 0, (String)"Bad jumpProb=%s for jump %s", (Object)myJumpProb, (Object)jump);
            if (this.inequality) {
                jumpCondProb = myJumpProb;
            } else {
                double sumAllProbs = 0.0;
                Iterator iterator = departingSectJumpProbs.row((Object)fromID).values().iterator();
                while (iterator.hasNext()) {
                    double jumpProb = (Double)iterator.next();
                    sumAllProbs += jumpProb;
                }
                List<FaultSection> parentSects = parentSectsMap.get(jump.fromSection.getParentSectionId());
                int indexInParent = parentSects.indexOf(jump.fromSection);
                Preconditions.checkState((indexInParent >= 0 ? 1 : 0) != 0);
                sumAllProbs = indexInParent > 0 && indexInParent < parentSects.size() - 1 ? (sumAllProbs += 1.0) : Math.max(sumAllProbs, 1.0);
                Preconditions.checkState((Double.isFinite(sumAllProbs) && sumAllProbs >= 0.0 ? 1 : 0) != 0, (String)"Bad sumAllProb=%s for jump %s", (Object)myJumpProb, (Object)jump);
                jumpCondProb = myJumpProb / sumAllProbs;
            }
            count += this.encodeRow(A, d, row++, jump, jumpCondProb, rupsUsingJump, allJumpsForDepartingSect);
        }
        return count;
    }

    protected abstract long encodeRow(DoubleMatrix2D var1, double[] var2, int var3, Jump var4, double var5, Collection<Integer> var7, Collection<Integer> var8);

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        rupSet.requireModule(ClusterRuptures.class);
        this.rupSet = rupSet;
    }

    public static class RelativeRate
    extends JumpProbabilityConstraint {
        @JsonAdapter(value=RateEstAdapter.class)
        private SectParticipationRateEstimator rateEst;

        public RelativeRate(double weight, boolean inequality, FaultSystemRupSet rupSet, JumpProbabilityCalc jumpProbCalc) {
            this(weight, inequality, rupSet, jumpProbCalc, null);
        }

        public RelativeRate(double weight, boolean inequality, FaultSystemRupSet rupSet, JumpProbabilityCalc jumpProbCalc, SectParticipationRateEstimator rateEst) {
            super("Relative Rate Jump Probability Constraint, " + jumpProbCalc.getName(), "RelRateJumpProb", weight, inequality, ConstraintWeightingType.UNNORMALIZED, rupSet, jumpProbCalc);
            this.rateEst = rateEst;
        }

        @Override
        protected long encodeRow(DoubleMatrix2D A, double[] d, int row, Jump jump, double jumpCondProb, Collection<Integer> rupsUsingJump, Collection<Integer> allJumpsForDepartingSect) {
            double probModWeight;
            long count = 0L;
            double maxWeight = this.weight * 100000.0;
            double rateEstWeight = this.weight;
            if (this.rateEst != null) {
                double estRate = this.rateEst.estimateSectParticRate(jump.fromSection.getSectionId());
                rateEstWeight = estRate > 0.0 ? (rateEstWeight /= estRate) : maxWeight;
            }
            if ((probModWeight = rateEstWeight / jumpCondProb) > maxWeight) {
                probModWeight = maxWeight;
            }
            HashSet<Integer> setUsingJump = new HashSet<Integer>(rupsUsingJump);
            double scalarIn = probModWeight * (1.0 - jumpCondProb);
            double scalarOut = -probModWeight * jumpCondProb;
            Preconditions.checkState((boolean)Double.isFinite(scalarIn), (String)"Bad scalarIn=%s for jump %s with jumpCondProb=%s and weight=%s", (Object)scalarIn, (Object)jump, (Object)jumpCondProb, (Object)probModWeight);
            Preconditions.checkState((boolean)Double.isFinite(scalarOut), (String)"Bad scalarOut=%s for jump %s with jumpCondProb=%s and weight=%s", (Object)scalarOut, (Object)jump, (Object)jumpCondProb, (Object)probModWeight);
            for (int r : allJumpsForDepartingSect) {
                if (setUsingJump.contains(r)) {
                    this.setA(A, row, r, scalarIn);
                    continue;
                }
                this.setA(A, row, r, scalarOut);
            }
            d[row] = 0.0;
            return count += (long)allJumpsForDepartingSect.size();
        }
    }

    private static class RateEstAdapter
    extends TypeAdapter<SectParticipationRateEstimator> {
        private RateEstAdapter() {
        }

        public void write(JsonWriter out, SectParticipationRateEstimator value) throws IOException {
            out.beginArray();
            for (double val : value.estimateSectParticRates()) {
                out.value(val);
            }
            out.endArray();
        }

        public SectParticipationRateEstimator read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            ArrayList<Double> vals = new ArrayList<Double>();
            while (in.hasNext()) {
                vals.add(in.nextDouble());
            }
            in.endArray();
            final double[] valArray = Doubles.toArray(vals);
            return new SectParticipationRateEstimator(){
                final /* synthetic */ RateEstAdapter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public double[] estimateSectParticRates() {
                    return valArray;
                }

                @Override
                public double estimateSectParticRate(int sectionIndex) {
                    return valArray[sectionIndex];
                }

                @Override
                public double[] estimateRuptureRates() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    @JsonAdapter(value=RateEstAdapter.class)
    public static class InitialModelParticipationRateEstimator
    implements SectParticipationRateEstimator {
        private double[] particRates;
        private double[] initialSol;

        public InitialModelParticipationRateEstimator(FaultSystemRupSet rupSet, double[] initialSol) {
            this.initialSol = initialSol;
            this.particRates = new FaultSystemSolution(rupSet, initialSol).calcTotParticRateForAllSects();
        }

        @Override
        public double estimateSectParticRate(int sectionIndex) {
            return this.particRates[sectionIndex];
        }

        @Override
        public double[] estimateSectParticRates() {
            return this.particRates;
        }

        @Override
        public double[] estimateRuptureRates() {
            return this.initialSol;
        }
    }

    @JsonAdapter(value=RateEstAdapter.class)
    public static interface SectParticipationRateEstimator {
        public double[] estimateSectParticRates();

        public double estimateSectParticRate(int var1);

        public double[] estimateRuptureRates();
    }

    public static class ProxySlip
    extends JumpProbabilityConstraint {
        private transient AveSlipModule aveSlips;
        private transient SlipAlongRuptureModel slipAlongModel;
        private transient SectSlipRates slipRates;

        public ProxySlip(double weight, boolean inequality, FaultSystemRupSet rupSet, JumpProbabilityCalc jumpProbCalc) {
            super("Proxy Slip Jump Probability Constraint, " + jumpProbCalc.getName(), "SlipJumpProb", weight, inequality, ConstraintWeightingType.NORMALIZED, rupSet, jumpProbCalc);
        }

        @Override
        protected long encodeRow(DoubleMatrix2D A, double[] d, int row, Jump jump, double jumpCondProb, Collection<Integer> rupsUsingJump, Collection<Integer> allJumpsForDepartingSect) {
            double maxWeight;
            long count = 0L;
            double totTargetSlip = this.slipRates.getSlipRate(jump.fromSection.getSectionId());
            double relTargetSlip = jumpCondProb * totTargetSlip;
            ConstraintWeightingType weightType = this.getWeightingType();
            double aScalar = this.weight * weightType.getA_Scalar(relTargetSlip, Double.NaN);
            if (aScalar > (maxWeight = this.weight * 100000.0)) {
                aScalar = maxWeight;
            }
            for (int rup : rupsUsingJump) {
                double[] slips = this.slipAlongModel.calcSlipOnSectionsForRup(this.rupSet, this.aveSlips, rup);
                List<Integer> sects = this.rupSet.getSectionsIndicesForRup(rup);
                double slip = Double.NaN;
                for (int i = 0; i < slips.length; ++i) {
                    int sect = sects.get(i);
                    if (sect != jump.fromSection.getSectionId()) continue;
                    slip = slips[i];
                    break;
                }
                Preconditions.checkState((boolean)Double.isFinite(slip));
                this.setA(A, row, rup, slip * aScalar);
                ++count;
            }
            d[row] = this.weight * weightType.getD(relTargetSlip, Double.NaN);
            return count;
        }

        @Override
        public void setRuptureSet(FaultSystemRupSet rupSet) {
            this.aveSlips = rupSet.requireModule(AveSlipModule.class);
            this.slipAlongModel = rupSet.requireModule(SlipAlongRuptureModel.class);
            this.slipRates = rupSet.requireModule(SectSlipRates.class);
            super.setRuptureSet(rupSet);
        }
    }
}

