/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.faultSurface.FaultSection;

public class LaplacianSmoothingInversionConstraint
extends InversionConstraint {
    public static final String NAME = "Laplacian Smoothing";
    public static final String SHORT_NAME = "LaplaceSmooth";
    private transient FaultSystemRupSet rupSet;
    private HashSet<Integer> parentIDs;

    public LaplacianSmoothingInversionConstraint(FaultSystemRupSet rupSet, double weight) {
        this(rupSet, weight, null);
    }

    public LaplacianSmoothingInversionConstraint(FaultSystemRupSet rupSet, double weight, HashSet<Integer> parentIDs) {
        super(NAME + (parentIDs == null ? "" : " (select parents)"), SHORT_NAME, weight, false);
        this.rupSet = rupSet;
        this.parentIDs = parentIDs;
    }

    @Override
    public int getNumRows() {
        int parentID;
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        for (FaultSection iterator : this.rupSet.getFaultSectionDataList()) {
            parentID = iterator.getParentSectionId();
            if (this.parentIDs != null && !this.parentIDs.contains(parentID)) continue;
            parentIDs.add(parentID);
        }
        int totalNumMFDSmoothnessConstraints = 0;
        Iterator iterator = parentIDs.iterator();
        while (iterator.hasNext()) {
            parentID = (Integer)iterator.next();
            ArrayList<Integer> sectsForParent = new ArrayList<Integer>();
            for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
                int sectParentID = faultSection.getParentSectionId();
                if (sectParentID != parentID) continue;
                sectsForParent.add(faultSection.getSectionId());
            }
            if (sectsForParent.size() <= 2) continue;
            totalNumMFDSmoothnessConstraints += sectsForParent.size() - 2;
        }
        return totalNumMFDSmoothnessConstraints;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int rowIndex = startRow;
        HashMap<Integer, ArrayList<FaultSection>> parentSectsMap = new HashMap<Integer, ArrayList<FaultSection>>();
        for (FaultSection iterator : this.rupSet.getFaultSectionDataList()) {
            Integer parentID = iterator.getParentSectionId();
            if (this.parentIDs != null && !this.parentIDs.contains(parentID)) continue;
            ArrayList<FaultSection> parentSects = (ArrayList<FaultSection>)parentSectsMap.get(parentID);
            if (parentSects == null) {
                parentSects = new ArrayList<FaultSection>();
                parentSectsMap.put(parentID, parentSects);
            }
            parentSects.add(iterator);
        }
        ArrayList sortedParentIDs = new ArrayList(parentSectsMap.keySet());
        Collections.sort(sortedParentIDs);
        Iterator iterator = sortedParentIDs.iterator();
        while (iterator.hasNext()) {
            int parentID = (Integer)iterator.next();
            List sectsForParent = (List)parentSectsMap.get(parentID);
            ArrayList<HashSet<Integer>> sectRupLists = new ArrayList<HashSet<Integer>>();
            for (FaultSection sect : sectsForParent) {
                sectRupLists.add(new HashSet<Integer>(this.rupSet.getRupturesForSection(sect.getSectionId())));
            }
            for (int j = 1; j < sectsForParent.size() - 2; ++j) {
                HashSet sect1Hash = (HashSet)sectRupLists.get(j - 1);
                HashSet sect2Hash = (HashSet)sectRupLists.get(j);
                HashSet sect3Hash = (HashSet)sectRupLists.get(j + 1);
                ArrayList<Integer> sect1Rups = new ArrayList<Integer>();
                ArrayList<Integer> sect2Rups = new ArrayList<Integer>();
                ArrayList<Integer> sect3Rups = new ArrayList<Integer>();
                for (Integer sect1Rup : sect1Hash) {
                    if (sect2Hash.contains(sect1Rup)) continue;
                    sect1Rups.add(sect1Rup);
                }
                for (Integer sect2Rup : sect2Hash) {
                    if (sect1Hash.contains(sect2Rup) && sect3Hash.contains(sect2Rup)) continue;
                    sect2Rups.add(sect2Rup);
                }
                for (Integer sect3Rup : sect3Hash) {
                    if (sect2Hash.contains(sect3Rup)) continue;
                    sect3Rups.add(sect3Rup);
                }
                Iterator iterator2 = sect1Rups.iterator();
                while (iterator2.hasNext()) {
                    int rup = (Integer)iterator2.next();
                    this.setA(A, rowIndex, rup, this.weight);
                    ++numNonZeroElements;
                }
                iterator2 = sect2Rups.iterator();
                while (iterator2.hasNext()) {
                    int rup = (Integer)iterator2.next();
                    this.setA(A, rowIndex, rup, -this.weight);
                    ++numNonZeroElements;
                }
                iterator2 = sect3Rups.iterator();
                while (iterator2.hasNext()) {
                    int rup = (Integer)iterator2.next();
                    this.setA(A, rowIndex, rup, this.weight);
                    ++numNonZeroElements;
                }
                d[rowIndex] = 0.0;
                ++rowIndex;
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

