/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class SubSectMFDInversionConstraint
extends InversionConstraint {
    public static final String NAME = "Subsection Nucleation MFD";
    public static final String SHORT_NAME = "SectNuclMFD";
    private transient FaultSystemRupSet rupSet;
    private List<? extends IncrementalMagFreqDist> constraints;
    private boolean nucleation;

    public SubSectMFDInversionConstraint(FaultSystemRupSet rupSet, double weight, ConstraintWeightingType weightType, List<? extends IncrementalMagFreqDist> constraints, boolean nucleation) {
        super(weightType.applyNamePrefix("Subsection " + (nucleation ? "Nucleation" : "Participation") + " MFD"), weightType.applyShortNamePrefix("SubSect" + (nucleation ? "Nucl" : "Part") + "MFD"), weight, false, weightType);
        this.constraints = constraints;
        this.setRuptureSet(rupSet);
        this.nucleation = nucleation;
    }

    @Override
    public int getNumRows() {
        int numRows = 0;
        for (IncrementalMagFreqDist incrementalMagFreqDist : this.constraints) {
            if (incrementalMagFreqDist == null) continue;
            EvenlyDiscretizedFunc stdDevs = this.weightingType == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY ? ((UncertainIncrMagFreqDist)incrementalMagFreqDist).getStdDevs() : null;
            for (int i = 0; i < incrementalMagFreqDist.size(); ++i) {
                if (!(incrementalMagFreqDist.getY(i) > 0.0) && (stdDevs == null || !(stdDevs.getY(i) > 0.0))) continue;
                ++numRows;
            }
        }
        return numRows;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int numSections = this.rupSet.getNumSections();
        int rowIndex = startRow;
        for (int sect = 0; sect < numSections; ++sect) {
            IncrementalMagFreqDist constraint = this.constraints.get(sect);
            if (constraint == null) continue;
            int numMagBins = constraint.size();
            List<Integer> rupturesForSect = this.rupSet.getRupturesForSection(sect);
            EvenlyDiscretizedFunc stdDevs = null;
            if (this.weightingType == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) {
                Preconditions.checkState((boolean)(constraint instanceof UncertainIncrMagFreqDist), (Object)"Uncertainty-weighted subsection MFD constraint chosen, but sub section MFDs don't have uncertainties attached.");
                stdDevs = ((UncertainIncrMagFreqDist)constraint).getStdDevs();
            }
            for (int magBin = 0; magBin < numMagBins; ++magBin) {
                int i;
                double stdDev;
                double rate = constraint.getY(magBin);
                double d2 = stdDev = stdDevs == null ? Double.NaN : stdDevs.getY(magBin);
                if (!(rate > 0.0) && (stdDevs == null || !(stdDev > 0.0))) continue;
                double scalar = this.weightingType.getA_Scalar(rate, stdDev);
                ArrayList<Integer> rupturesForMagBin = new ArrayList<Integer>();
                for (i = 0; i < rupturesForSect.size(); ++i) {
                    double mag = this.rupSet.getMagForRup(rupturesForSect.get(i));
                    if (constraint.getClosestXIndex(mag) != magBin) continue;
                    rupturesForMagBin.add(rupturesForSect.get(i));
                }
                for (i = 0; i < rupturesForMagBin.size(); ++i) {
                    int rup = (Integer)rupturesForMagBin.get(i);
                    double val = this.weight * scalar;
                    if (this.nucleation) {
                        double rupArea = this.rupSet.getAreaForRup(rup);
                        double sectArea = this.rupSet.getAreaForSection(sect);
                        val *= sectArea / rupArea;
                    }
                    this.setA(A, rowIndex, rup, val);
                    ++numNonZeroElements;
                }
                d[rowIndex] = this.weight * this.weightingType.getD(rate, stdDev);
                ++rowIndex;
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        Preconditions.checkState((rupSet.getNumSections() == this.constraints.size() ? 1 : 0) != 0, (Object)"Rupture set subsection count and constraint count are inconsistent");
        this.rupSet = rupSet;
    }
}

