/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import org.opensha.commons.eq.MagUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;

public class TotalMomentInversionConstraint
extends InversionConstraint {
    public static final String NAME = "Total Moment";
    public static final String SHORT_NAME = "TotMoment";
    private transient FaultSystemRupSet rupSet;
    private double totalMomentTarget;

    public TotalMomentInversionConstraint(FaultSystemRupSet rupSet, double weight, double totalMomentTarget) {
        super(NAME, SHORT_NAME, weight, false);
        this.rupSet = rupSet;
        this.totalMomentTarget = totalMomentTarget;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int numRuptures = this.rupSet.getNumRuptures();
        for (int rup = 0; rup < numRuptures; ++rup) {
            this.setA(A, startRow, rup, this.weight * MagUtils.magToMoment(this.rupSet.getMagForRup(rup)));
            ++numNonZeroElements;
        }
        d[startRow] = this.weight * this.totalMomentTarget;
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

