/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.mpj;

import edu.usc.kmilner.mpj.taskDispatch.AsyncPostBatchHook;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.util.BranchAverageSolutionCreator;

public abstract class AbstractAsyncLogicTreeWriter
extends AsyncPostBatchHook {
    private File outputDir;
    private SolutionLogicTree.SolutionProcessor processor;
    protected BranchWeightProvider weightProv;
    protected Map<String, BranchAverageSolutionCreator> baCreators;
    protected SolutionLogicTree.FileBuilder sltBuilder;
    private CompletableFuture<Void> writingLoadedFuture;
    private CompletableFuture<Void> processingLoadedFuture;
    private boolean[] dones;
    private LogicTree<?> tree;

    public AbstractAsyncLogicTreeWriter(File outputDir, SolutionLogicTree.SolutionProcessor processor, LogicTree<?> tree) {
        super(1);
        this.outputDir = outputDir;
        this.processor = processor;
        this.tree = tree;
        this.weightProv = tree.getWeightProvider();
        this.baCreators = new HashMap<String, BranchAverageSolutionCreator>();
        this.dones = new boolean[this.getNumTasks()];
    }

    public File getOutputFile(File resultsDir) {
        return new File(resultsDir.getParentFile(), resultsDir.getName() + ".zip");
    }

    public File getBAOutputFile(File resultsDir, String baPrefix) {
        return AbstractAsyncLogicTreeWriter.baFile(resultsDir, baPrefix);
    }

    public abstract int getNumTasks();

    public abstract void debug(String var1);

    public abstract LogicTreeBranch<?> getBranch(int var1);

    public abstract FaultSystemSolution getSolution(LogicTreeBranch<?> var1, int var2) throws IOException;

    public abstract void abortAndExit(Throwable var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void batchProcessedAsync(int[] batch, int processIndex) {
        this.memoryDebug("AsyncLogicTree: beginning async call with batch size " + batch.length + " from " + processIndex + ": " + this.getCountsString());
        boolean[] blArray = this.dones;
        synchronized (this.dones) {
            try {
                if (this.sltBuilder == null) {
                    this.sltBuilder = new SolutionLogicTree.FileBuilder(this.processor, new ArchiveOutput.ApacheZipFileOutput(this.getOutputFile(this.outputDir)));
                    this.sltBuilder.setWeightProv(this.weightProv);
                }
                for (int index : batch) {
                    this.dones[index] = true;
                    this.doProcessIndex(index);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abortAndExit(e, 2);
            }
            this.memoryDebug("AsyncLogicTree: exiting async process, stats: " + this.getCountsString());
            return;
        }
    }

    protected void doProcessIndex(int index) throws IOException {
        final LogicTreeBranch<?> branch = this.getBranch(index);
        this.debug("AsyncLogicTree: calcDone " + index + " = branch " + String.valueOf(branch));
        final FaultSystemSolution sol = this.getSolution(branch, index);
        if (sol == null) {
            return;
        }
        if (this.writingLoadedFuture != null) {
            this.writingLoadedFuture.join();
        }
        this.writingLoadedFuture = CompletableFuture.runAsync(new Runnable(){
            final /* synthetic */ AbstractAsyncLogicTreeWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.sltBuilder.solution(sol, branch);
                }
                catch (Exception e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
        if (this.baCreators != null) {
            if (this.processingLoadedFuture != null) {
                this.processingLoadedFuture.join();
            }
            this.processingLoadedFuture = CompletableFuture.runAsync(new Runnable(){
                final /* synthetic */ AbstractAsyncLogicTreeWriter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    String baPrefix = AbstractAsyncLogicTreeWriter.getBA_prefix(branch);
                    if (baPrefix == null) {
                        this.this$0.debug("AsyncLogicTree won't branch average, all levels affect properties.csv");
                    } else {
                        if (!this.this$0.baCreators.containsKey(baPrefix)) {
                            this.this$0.baCreators.put(baPrefix, new BranchAverageSolutionCreator(this.this$0.weightProv));
                        }
                        BranchAverageSolutionCreator baCreator = this.this$0.baCreators.get(baPrefix);
                        try {
                            baCreator.addSolution(sol, branch);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.flush();
                            this.this$0.debug("AsyncLogicTree: Branch averaging failed for branch " + String.valueOf(branch) + ", disabling averaging");
                            this.this$0.baCreators = null;
                        }
                    }
                }
            });
        }
    }

    public static String getBA_prefix(LogicTreeBranch<?> branch) {
        Object baPrefix = null;
        boolean allAffect = true;
        for (int i = 0; i < branch.size(); ++i) {
            if (branch.getLevel(i).affects("indices.csv", true)) {
                baPrefix = baPrefix == null ? "" : (String)baPrefix + "_";
                baPrefix = (String)baPrefix + branch.getValue(i).getFilePrefix();
                continue;
            }
            allAffect = false;
        }
        if (allAffect) {
            return null;
        }
        if (baPrefix == null) {
            return "";
        }
        return baPrefix;
    }

    public static Map<String, List<LogicTreeBranch<?>>> getBranchAveragePrefixes(LogicTree<?> tree) {
        HashMap commonPrefixes = new HashMap();
        for (LogicTreeBranch<?> branch : tree) {
            String prefix = AbstractAsyncLogicTreeWriter.getBA_prefix(branch);
            if (prefix == null) continue;
            List<LogicTreeBranch<?>> branches = commonPrefixes.get(prefix);
            if (branches == null) {
                branches = new ArrayList();
                commonPrefixes.put(prefix, branches);
            }
            commonPrefixes.get(prefix).add(branch);
        }
        return commonPrefixes;
    }

    public static Map<String, File> getBranchAverageSolutionFileMap(File resultsDir, LogicTree<?> tree) {
        Set<String> commonPrefixes = AbstractAsyncLogicTreeWriter.getBranchAveragePrefixes(tree).keySet();
        HashMap<String, File> ret = new HashMap<String, File>();
        for (String prefix : commonPrefixes) {
            ret.put(prefix, AbstractAsyncLogicTreeWriter.baFile(resultsDir, prefix));
        }
        return ret;
    }

    public static List<File> getBranchAverageSolutionFiles(File resultsDir, LogicTree<?> tree) {
        Set<String> commonPrefixes = AbstractAsyncLogicTreeWriter.getBranchAveragePrefixes(tree).keySet();
        ArrayList<File> ret = new ArrayList<File>();
        for (String prefix : commonPrefixes) {
            ret.add(AbstractAsyncLogicTreeWriter.baFile(resultsDir, prefix));
        }
        return ret;
    }

    private static File baFile(File resultsDir, String baPrefix) {
        Object prefix = resultsDir.getName();
        if (!baPrefix.isBlank()) {
            prefix = (String)prefix + "_" + baPrefix;
        }
        return new File(resultsDir.getParentFile(), (String)prefix + "_branch_averaged.zip");
    }

    public void shutdown() {
        super.shutdown();
        if (this.writingLoadedFuture != null) {
            this.writingLoadedFuture.join();
        }
        if (this.processingLoadedFuture != null) {
            this.processingLoadedFuture.join();
        }
        this.memoryDebug("AsyncLogicTree: finalizing logic tree zip");
        try {
            this.sltBuilder.sortLogicTreeBranchesToMatchTree(this.tree);
            this.sltBuilder.close();
        }
        catch (IOException e) {
            this.memoryDebug("AsyncLogicTree: failed to build logic tree zip");
            e.printStackTrace();
        }
        if (this.baCreators != null && !this.baCreators.isEmpty()) {
            for (String baPrefix : this.baCreators.keySet()) {
                File baFile = this.getBAOutputFile(this.outputDir, baPrefix);
                this.memoryDebug("AsyncLogicTree: building " + baFile.getAbsolutePath());
                try {
                    FaultSystemSolution baSol = this.baCreators.get(baPrefix).build();
                    baSol.write(baFile);
                }
                catch (Exception e) {
                    this.memoryDebug("AsyncLogicTree: failed to build BA for " + baFile.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
    }

    private void memoryDebug(String info) {
        info = info == null || ((String)info).isBlank() ? "" : (String)info + "; ";
        System.gc();
        Runtime rt = Runtime.getRuntime();
        long totalMB = rt.totalMemory() / 1024L / 1024L;
        long freeMB = rt.freeMemory() / 1024L / 1024L;
        long usedMB = totalMB - freeMB;
        this.debug((String)info + "mem t/u/f: " + totalMB + "/" + usedMB + "/" + freeMB);
    }
}

