/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import com.google.common.base.Preconditions;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import java.util.Arrays;

public class ColumnOrganizedAnnealingData {
    public final DoubleMatrix2D A;
    public final double[] d;
    public final int nRows;
    public final int nCols;
    final int[][] colRows;
    final double[][] colA_values;
    final int maxRowsPerCol;

    public ColumnOrganizedAnnealingData(DoubleMatrix2D A, double[] d) {
        Preconditions.checkNotNull((Object)A, (Object)"A is null");
        Preconditions.checkNotNull((Object)d, (Object)"d is null");
        this.nRows = A.rows();
        this.nCols = A.columns();
        Preconditions.checkArgument((this.nRows > 0 ? 1 : 0) != 0, (Object)"nRow of A must be > 0");
        Preconditions.checkArgument((this.nCols > 0 ? 1 : 0) != 0, (Object)"nCol of A must be > 0");
        Preconditions.checkArgument((d.length == this.nRows ? 1 : 0) != 0, (Object)"d matrix must be same lenth as nRow of A");
        this.A = A;
        this.d = d;
        this.colRows = new int[this.nCols][];
        this.colA_values = new double[this.nCols][];
        if (A instanceof SparseDoubleMatrix2D) {
            System.out.println("Column compressing A matrix");
            A = ((SparseDoubleMatrix2D)A).getColumnCompressed(true);
        }
        if (A instanceof SparseCCDoubleMatrix2D) {
            Dcs_common.Dcs dcs = ((SparseCCDoubleMatrix2D)A).elements();
            int[] rowIndexesA = dcs.i;
            int[] columnPointersA = dcs.p;
            double[] valuesA = dcs.x;
            int maxRowsPerCol = 0;
            for (int col = 0; col < this.nCols; ++col) {
                int low = columnPointersA[col];
                int high = columnPointersA[col + 1];
                int len = high - low;
                maxRowsPerCol = Integer.max(maxRowsPerCol, len);
                this.colRows[col] = new int[len];
                this.colA_values[col] = new double[len];
                int index = 0;
                for (int k = low; k < high; ++k) {
                    this.colRows[col][index] = rowIndexesA[k];
                    this.colA_values[col][index] = valuesA[k];
                    ++index;
                }
            }
            this.maxRowsPerCol = maxRowsPerCol;
        } else {
            System.out.println("Re-organizing A matrix into colmn vectors, this may be slow. Suggest using SparseDoubleMatrix or SparseCCDoubleMatrix for large matrices.");
            int maxRowsPerCol = 0;
            double[] tmpVals = new double[this.nRows];
            int[] tmpRows = new int[this.nRows];
            for (int col = 0; col < this.nCols; ++col) {
                int index = 0;
                for (int row = 0; row < this.nRows; ++row) {
                    double val = A.get(row, col);
                    if (val == 0.0) continue;
                    tmpVals[index] = val;
                    tmpRows[index] = row;
                    ++index;
                }
                maxRowsPerCol = Integer.max(maxRowsPerCol, index);
                this.colRows[col] = Arrays.copyOf(tmpRows, index);
                this.colA_values[col] = Arrays.copyOf(tmpVals, index);
            }
            this.maxRowsPerCol = maxRowsPerCol;
        }
    }
}

