/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.jfree.data.Range;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionInputGenerator;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ColumnOrganizedAnnealingData;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.AnnealingProgress;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.ProgressTrackingCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.CoolingScheduleType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.GenerationFunctionType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;

public interface SimulatedAnnealing {
    public static final int plot_width = 1000;
    public static final int plot_height = 800;

    public void setCalculationParams(CoolingScheduleType var1, NonnegativityConstraintType var2, GenerationFunctionType var3);

    public CoolingScheduleType getCoolingFunc();

    public void setCoolingFunc(CoolingScheduleType var1);

    public NonnegativityConstraintType getNonnegativeityConstraintAlgorithm();

    public void setNonnegativeityConstraintAlgorithm(NonnegativityConstraintType var1);

    public GenerationFunctionType getPerturbationFunc();

    public void setPerturbationFunc(GenerationFunctionType var1);

    public void setVariablePerturbationBasis(double[] var1);

    public void setRuptureSampler(IntegerSampler var1);

    public double[] getBestSolution();

    public double[] getInitialSolution();

    public int getNumNonZero();

    public double[] getBestEnergy();

    public double[] calculateEnergy(double[] var1);

    public double[] calculateEnergy(double[] var1, double[] var2, double[] var3);

    public double[] calculateEnergy(double[] var1, double[] var2, double[] var3, List<ConstraintRange> var4);

    public double[] getBestMisfit();

    public double[] getBestInequalityMisfit();

    public ColumnOrganizedAnnealingData getEqualityData();

    public DoubleMatrix2D getA();

    public double[] getD();

    public ColumnOrganizedAnnealingData getInequalityData();

    public DoubleMatrix2D getA_ineq();

    public double[] getD_ineq();

    public void setInputs(ColumnOrganizedAnnealingData var1, ColumnOrganizedAnnealingData var2);

    public void setAll(ColumnOrganizedAnnealingData var1, ColumnOrganizedAnnealingData var2, double[] var3, double[] var4, double[] var5, double[] var6, int var7);

    public void setResults(double[] var1, double[] var2);

    public void setResults(double[] var1, double[] var2, double[] var3, double[] var4, int var5);

    public void setConstraintRanges(List<ConstraintRange> var1);

    public List<ConstraintRange> getConstraintRanges();

    public InversionState iterate(long var1);

    public InversionState iterate(CompletionCriteria var1);

    public void setRandom(Random var1);

    public InversionState iterate(InversionState var1, CompletionCriteria var2);

    default public void writeRateVsRankPlot(File outputDir, String prefix, double[] minimumRuptureRates) throws IOException {
        double[] solutionRates = this.getBestSolution();
        double[] adjustedRates = null;
        if (minimumRuptureRates != null) {
            adjustedRates = InversionInputGenerator.adjustSolutionForWaterLevel(this.getBestSolution(), minimumRuptureRates);
        }
        SimulatedAnnealing.writeRateVsRankPlot(outputDir, prefix, solutionRates, adjustedRates, this.getInitialSolution());
    }

    default public void writePlots(CompletionCriteria criteria, File outputDir, String prefix, double[] minimumRuptureRates) throws IOException {
        int numRuptures = minimumRuptureRates == null ? -1 : minimumRuptureRates.length;
        this.writeRateVsRankPlot(outputDir, prefix + "_rate_dist", minimumRuptureRates);
        if (criteria instanceof ProgressTrackingCompletionCriteria) {
            SimulatedAnnealing.writeProgressPlots(((ProgressTrackingCompletionCriteria)criteria).getProgress(), outputDir, prefix, numRuptures);
        }
    }

    public static void writeRateVsRankPlot(File outputDir, String prefix, double[] ratesNoMin, double[] rates, double[] initialState) throws IOException {
        SimulatedAnnealing.writeRateVsRankPlot(outputDir, prefix, ratesNoMin, rates, initialState, null, null);
    }

    public static void writeRateVsRankPlot(File outputDir, String prefix, double[] ratesNoMin, double[] rates, double[] initialState, double[] compRates, double[] compRatesNoMin) throws IOException {
        SimulatedAnnealing.writeRateVsRankPlot(outputDir, prefix, ratesNoMin, rates, initialState, compRates, compRatesNoMin, "Rupture Rate Distribution");
    }

    public static void writeRateVsRankPlot(File outputDir, String prefix, double[] ratesNoMin, double[] rates, double[] initialState, double[] compRates, double[] compRatesNoMin, String title) throws IOException {
        int i;
        if (compRatesNoMin != null && compRates == compRatesNoMin) {
            compRatesNoMin = null;
        }
        ratesNoMin = SimulatedAnnealing.getSorted(ratesNoMin);
        rates = SimulatedAnnealing.getSorted(rates);
        boolean hasWL = false;
        for (int r = 0; r < rates.length; ++r) {
            if (ratesNoMin[r] == rates[r]) continue;
            hasWL = true;
            break;
        }
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, ratesNoMin.length, 1.0);
        func.setName("Inversion Rates");
        for (int i2 = 0; i2 < ratesNoMin.length; ++i2) {
            func.set(i2, ratesNoMin[i2]);
        }
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(func);
        ArrayList<PlotCurveCharacterstics> chars = Lists.newArrayList((Object[])new PlotCurveCharacterstics[]{new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLUE)});
        EvenlyDiscretizedFunc initialFunc = new EvenlyDiscretizedFunc(0.0, initialState.length, 1.0);
        initialFunc.setName("Initial Solution");
        double[] initialSorted = SimulatedAnnealing.getSorted(initialState);
        for (int i3 = 0; i3 < initialSorted.length; ++i3) {
            initialFunc.set(i3, initialSorted[i3]);
        }
        funcs.add(0, initialFunc);
        chars.add(0, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GREEN));
        if (hasWL) {
            EvenlyDiscretizedFunc adjFunc = new EvenlyDiscretizedFunc(0.0, ratesNoMin.length, 1.0);
            adjFunc.setName("Final Solution");
            for (i = 0; i < rates.length; ++i) {
                adjFunc.set(i, rates[i]);
            }
            funcs.add(0, adjFunc);
            chars.add(0, new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        }
        if (compRates != null) {
            compRates = SimulatedAnnealing.getSorted(compRates);
            EvenlyDiscretizedFunc compFunc = new EvenlyDiscretizedFunc(0.0, compRates.length, 1.0);
            compFunc.setName("Comparison Solution");
            for (i = 0; i < compRates.length; ++i) {
                compFunc.set(i, compRates[i]);
            }
            funcs.add(compFunc);
            if (compRatesNoMin != null && compRatesNoMin != compRates) {
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, new Color(0, 0, 0, 127)));
                compRatesNoMin = SimulatedAnnealing.getSorted(compRatesNoMin);
                EvenlyDiscretizedFunc adjFunc = new EvenlyDiscretizedFunc(0.0, compRatesNoMin.length, 1.0);
                adjFunc.setName("Comparison Inversion Rates");
                for (int i4 = 0; i4 < compRatesNoMin.length; ++i4) {
                    adjFunc.set(i4, compRatesNoMin[i4]);
                }
                funcs.add(adjFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
            } else {
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 4.0f, new Color(0, 0, 0, 127)));
            }
        }
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.setYLog(true);
        PlotSpec spec = new PlotSpec(funcs, (List<PlotCurveCharacterstics>)chars, title, "Rank", "Rate (per year)");
        spec.setLegendInset(true);
        gp.drawGraphPanel(spec);
        double maxVal = 0.0;
        double minVal = Double.POSITIVE_INFINITY;
        for (DiscretizedFunc discretizedFunc : funcs) {
            double myMinNonZero = Double.POSITIVE_INFINITY;
            double myMax = 0.0;
            for (Point2D pt : discretizedFunc) {
                if (!(pt.getY() > 0.0)) continue;
                myMax = Math.max(myMax, pt.getY());
                myMinNonZero = Math.min(myMinNonZero, pt.getY());
            }
            if (!(myMax > 0.0)) continue;
            maxVal = Math.max(maxVal, myMax);
            minVal = Math.min(minVal, myMinNonZero);
        }
        if (Double.isFinite(minVal) && minVal > 1.0E-16 && minVal < maxVal) {
            maxVal = Math.pow(10.0, Math.ceil(Math.log10(maxVal)));
            minVal = Math.pow(10.0, Math.floor(Math.log10(minVal)));
            gp.getYAxis().setRange(new Range(minVal, maxVal));
        }
        File file = new File(outputDir, prefix);
        gp.saveAsPNG(file.getAbsolutePath() + ".png", 1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf", 1000, 800);
        funcs = new ArrayList();
        chars = new ArrayList<PlotCurveCharacterstics>();
        if (hasWL) {
            funcs.add(SimulatedAnnealing.getCumulative(rates, true, "Final Solution, Rate >= Rank"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            funcs.add(SimulatedAnnealing.getCumulative(rates, false, "Final Solution, Rate <= Rank"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, Color.BLACK));
        }
        funcs.add(SimulatedAnnealing.getCumulative(ratesNoMin, true, "Inversion Rates, Rate >= Rank"));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLUE));
        funcs.add(SimulatedAnnealing.getCumulative(ratesNoMin, false, "Inversion Rates, Rate <= Rank"));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 4.0f, Color.BLUE));
        if (compRates != null) {
            funcs.add(SimulatedAnnealing.getCumulative(compRates, true, "Comparison Solution, Rate >= Rank"));
            if (compRatesNoMin != null && compRates != compRatesNoMin) {
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, new Color(0, 0, 0, 127)));
                funcs.add(SimulatedAnnealing.getCumulative(compRatesNoMin, true, "Comparison Inversion Rates, Rate >= Rank"));
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
            } else {
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 4.0f, new Color(0, 0, 0, 127)));
            }
        }
        spec = new PlotSpec(funcs, chars, "Cumulative " + title, "Rank", "Cumulative Rate (per year)");
        spec.setLegendInset(true);
        gp.drawGraphPanel(spec);
        gp.setAutoRange();
        file = new File(outputDir, prefix + "_cumulative");
        gp.saveAsPNG(file.getAbsolutePath() + ".png", 1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf", 1000, 800);
    }

    private static EvenlyDiscretizedFunc getCumulative(double[] rates, boolean rateAbove, String name) {
        EvenlyDiscretizedFunc cmlFunc = new EvenlyDiscretizedFunc(0.0, rates.length, 1.0);
        cmlFunc.setName(name);
        if (rateAbove) {
            double sum = 0.0;
            int r = rates.length;
            while (--r >= 0) {
                cmlFunc.set(r, sum += rates[r]);
            }
        } else {
            double sum = 0.0;
            for (int r = 0; r < rates.length; ++r) {
                cmlFunc.set(r, sum += rates[r]);
            }
        }
        return cmlFunc;
    }

    public static void writeProgressPlots(AnnealingProgress track, File outputDir, String prefix, int numRuptures) throws IOException {
        SimulatedAnnealing.writeProgressPlots(track, outputDir, prefix, numRuptures, null);
    }

    public static void writeProgressPlots(AnnealingProgress track, File outputDir, String prefix, int numRuptures, AnnealingProgress compTrack) throws IOException {
        List<PlotSpec> combSpecs;
        int i;
        ArbitrarilyDiscretizedFunc perturbsVsIters = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc worseKeptsVsIters = track.hasWorseKepts() ? new ArbitrarilyDiscretizedFunc() : null;
        ArbitrarilyDiscretizedFunc nonZerosVsIters = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc percentNonZerosVsIters = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc compTotalTime = null;
        ArbitrarilyDiscretizedFunc compTotalIters = null;
        ArbitrarilyDiscretizedFunc compPerturb = null;
        ArbitrarilyDiscretizedFunc compPercentNonZeros = null;
        ArbitrarilyDiscretizedFunc compNonZero = null;
        if (compTrack != null) {
            compTotalTime = new ArbitrarilyDiscretizedFunc("Comparison Total");
            compTotalIters = new ArbitrarilyDiscretizedFunc("Comparison Total");
            compPerturb = new ArbitrarilyDiscretizedFunc();
            compPercentNonZeros = new ArbitrarilyDiscretizedFunc();
            compNonZero = new ArbitrarilyDiscretizedFunc();
            for (int i2 = 0; i2 < compTrack.size(); ++i2) {
                double[] energy = compTrack.getEnergies(i2);
                long time = compTrack.getTime(i2);
                double mins = (double)time / 1000.0 / 60.0;
                long perturb = compTrack.getNumPerturbations(i2);
                long iter = compTrack.getIterations(i2);
                int nonZeros = compTrack.getNumNonZero(i2);
                compTotalTime.set(mins, energy[0]);
                compTotalIters.set(iter, energy[0]);
                compPerturb.set(iter, (double)perturb);
                compNonZero.set(iter, (double)nonZeros);
                if (numRuptures <= 0 || compPercentNonZeros == null) continue;
                if (nonZeros > numRuptures) {
                    compPercentNonZeros = null;
                    continue;
                }
                compPercentNonZeros.set(iter, 100.0 * (double)nonZeros / (double)numRuptures);
            }
        }
        ImmutableList<String> types = track.getEnergyTypes();
        int num = types.size();
        ArrayList<ArbitrarilyDiscretizedFunc> timeFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<ArbitrarilyDiscretizedFunc> iterFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        boolean[] hasNonZeros = new boolean[num];
        for (i = 0; i < num; ++i) {
            timeFuncs.add(new ArbitrarilyDiscretizedFunc((String)types.get(i)));
            iterFuncs.add(new ArbitrarilyDiscretizedFunc((String)types.get(i)));
        }
        for (i = 0; i < track.size(); ++i) {
            double[] energy = track.getEnergies(i);
            long time = track.getTime(i);
            double mins = (double)time / 1000.0 / 60.0;
            long perturb = track.getNumPerturbations(i);
            long iter = track.getIterations(i);
            int nonZeros = track.getNumNonZero(i);
            for (int j = 0; j < energy.length; ++j) {
                ((ArbitrarilyDiscretizedFunc)timeFuncs.get(j)).set(mins, energy[j]);
                ((ArbitrarilyDiscretizedFunc)iterFuncs.get(j)).set(iter, energy[j]);
                if (!(energy[j] > 0.0)) continue;
                hasNonZeros[j] = true;
            }
            perturbsVsIters.set(iter, (double)perturb);
            if (worseKeptsVsIters != null) {
                worseKeptsVsIters.set(iter, (double)track.getNumWorseKept(i));
            }
            nonZerosVsIters.set(iter, (double)nonZeros);
            if (numRuptures <= 0) continue;
            percentNonZerosVsIters.set(iter, 100.0 * (double)nonZeros / (double)numRuptures);
        }
        ArrayList<PlotCurveCharacterstics> energyChars = SimulatedAnnealing.getEnergyBreakdownChars();
        int i3 = energyChars.size();
        while (--i3 >= 0) {
            if (hasNonZeros[i3]) continue;
            energyChars.remove(i3);
            timeFuncs.remove(i3);
            iterFuncs.remove(i3);
        }
        num = timeFuncs.size();
        ArrayList<PlotCurveCharacterstics> extraChars = SimulatedAnnealing.getEnergyExtraChars();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        for (int i4 = 0; i4 < num; ++i4) {
            if (i4 < energyChars.size()) {
                chars.add(energyChars.get(i4));
                continue;
            }
            int extraIndex = i4 - energyChars.size();
            chars.add(extraChars.get(extraIndex % extraChars.size()));
        }
        PlotCurveCharacterstics compChar = new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, new Color(0, 0, 0, 127));
        if (compTrack != null) {
            timeFuncs.add(compTotalTime);
            iterFuncs.add(compTotalIters);
            chars.add(compChar);
        }
        PlotCurveCharacterstics perturbChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.CYAN.darker());
        PlotCurveCharacterstics nzChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.ORANGE.darker());
        PlotCurveCharacterstics worseChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.RED.darker());
        String timeLabel = "Time (minutes)";
        String iterationsLabel = "Iterations";
        String energyLabel = "Energy";
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        double energyAter5percent = ((ArbitrarilyDiscretizedFunc)iterFuncs.get(1)).getY((int)(((double)((ArbitrarilyDiscretizedFunc)iterFuncs.get(1)).size() - 1.0) * 0.05 + 0.5));
        double bestEnergy = track.getEnergies(track.size() - 1)[0];
        double energyPlotMax = bestEnergy < 5.0 ? energyAter5percent * 1.2 : (bestEnergy < 20.0 ? 50.0 : (bestEnergy < 40.0 ? 100.0 : (bestEnergy < 250.0 ? 500.0 : (bestEnergy < 500.0 ? 1000.0 : Math.max(1000.0, energyAter5percent * 1.2)))));
        double energyPlotMin = 0.0;
        double timeMin = 0.0;
        double itersMin = 0.0;
        double timeMax = ((ArbitrarilyDiscretizedFunc)timeFuncs.get(0)).getMaxX();
        double iterMax = ((ArbitrarilyDiscretizedFunc)iterFuncs.get(0)).getMaxX();
        gp.setUserBounds(timeMin, timeMax, energyPlotMin, energyPlotMax);
        PlotSpec eVtSpec = new PlotSpec(timeFuncs, chars, "Energy Vs Time", timeLabel, energyLabel);
        eVtSpec.setLegendInset(true);
        gp.drawGraphPanel(eVtSpec);
        gp.saveAsPNG(new File(outputDir, prefix + "_energy_vs_time.png").getAbsolutePath(), 1000, 800);
        gp.saveAsPDF(new File(outputDir, prefix + "_energy_vs_time.pdf").getAbsolutePath(), 1000, 800);
        gp.setUserBounds(itersMin, iterMax, energyPlotMin, energyPlotMax);
        PlotSpec eViSpec = new PlotSpec(iterFuncs, chars, "Energy Vs Iterations", iterationsLabel, energyLabel);
        eViSpec.setLegendInset(true);
        gp.drawGraphPanel(eViSpec);
        gp.saveAsPNG(new File(outputDir, prefix + "_energy_vs_iters.png").getAbsolutePath(), 1000, 800);
        gp.saveAsPDF(new File(outputDir, prefix + "_energy_vs_iters.pdf").getAbsolutePath(), 1000, 800);
        ArrayList<ArbitrarilyDiscretizedFunc> perturbFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> perturbChars = new ArrayList<PlotCurveCharacterstics>();
        perturbFuncs.add(perturbsVsIters);
        perturbChars.add(perturbChar);
        ArrayList<ArbitrarilyDiscretizedFunc> nzFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> nzChars = new ArrayList<PlotCurveCharacterstics>();
        if (numRuptures > 0) {
            nzFuncs.add(percentNonZerosVsIters);
        } else {
            nzFuncs.add(nonZerosVsIters);
        }
        nzChars.add(nzChar);
        if (compTrack != null) {
            perturbFuncs.add(compPerturb);
            perturbChars.add(compChar);
            if (numRuptures > 0) {
                if (compPercentNonZeros != null) {
                    nzFuncs.add(compPercentNonZeros);
                    nzChars.add(compChar);
                }
            } else {
                nzFuncs.add(compNonZero);
                nzChars.add(compChar);
            }
        }
        gp.setAutoRange();
        String combTitle = "Perturbations & Non-Zero Rates Vs Iters";
        PlotSpec pSpec = new PlotSpec(perturbFuncs, perturbChars, combTitle, iterationsLabel, "# Perturbations");
        PlotSpec nzSpec = new PlotSpec(nzFuncs, nzChars, combTitle, iterationsLabel, numRuptures > 0 ? "% Non-Zero Rates" : "# Non-Zero Rates");
        if (worseKeptsVsIters != null) {
            ArrayList<ArbitrarilyDiscretizedFunc> worseFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> worseChars = new ArrayList<PlotCurveCharacterstics>();
            worseFuncs.add(worseKeptsVsIters);
            worseChars.add(worseChar);
            PlotSpec worseSpec = new PlotSpec(worseFuncs, worseChars, combTitle, iterationsLabel, "# Worse Pertubs Kept");
            combSpecs = List.of(nzSpec, worseSpec, pSpec);
        } else {
            combSpecs = List.of(nzSpec, pSpec);
        }
        pSpec.setLegendInset(false);
        List<Range> combXRanges = List.of(new Range(0.0, iterMax));
        gp.drawGraphPanel(combSpecs, false, false, combXRanges, null);
        gp.saveAsPNG(new File(outputDir, prefix + "_perturb_vs_iters.png").getAbsolutePath(), 1000, worseKeptsVsIters != null ? 1120 : 800);
    }

    public static ArrayList<PlotCurveCharacterstics> getEnergyBreakdownChars() {
        ArrayList<PlotCurveCharacterstics> energyChars = new ArrayList<PlotCurveCharacterstics>();
        energyChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
        energyChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
        energyChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GREEN));
        energyChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
        return energyChars;
    }

    public static ArrayList<PlotCurveCharacterstics> getEnergyExtraChars() {
        ArrayList<PlotCurveCharacterstics> energyChars = new ArrayList<PlotCurveCharacterstics>();
        for (Color color : GraphPanel.defaultColor) {
            energyChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color.darker()));
        }
        return energyChars;
    }

    private static double[] getSorted(double[] rates) {
        double[] newrates = Arrays.copyOf(rates, rates.length);
        Arrays.sort(newrates);
        ArrayUtils.reverse((double[])newrates);
        return newrates;
    }
}

