/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.time.StopWatch;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ExecutorUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionInputGenerator;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ColumnOrganizedAnnealingData;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SerialSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.AnnealingProgress;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompoundCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.EnergyChangeCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.EnergyCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationsPerVariableCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.ProgressTrackingCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.TimeCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.VariableSubTimeCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.CoolingScheduleType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.GenerationFunctionType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;
import scratch.UCERF3.utils.MatrixIO;

public class ThreadedSimulatedAnnealing
implements SimulatedAnnealing {
    private static final boolean D = true;
    public static final String XML_METADATA_NAME = "ThreadedSimulatedAnnealing";
    private CompletionCriteria subCompletionCriteria;
    private boolean startSubIterationsAtZero;
    private TimeCompletionCriteria checkPointCriteria;
    private File checkPointFileBase;
    private int numThreads;
    private List<? extends SimulatedAnnealing> sas;
    private ExecutorService exec;
    private double[] Ebest = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
    private double[] xbest = null;
    private int numNonZero;
    private double[] misfit = null;
    private double[] misfit_ineq = null;
    private double[] initialState;
    private List<ConstraintRange> constraintRanges;
    private boolean average = false;
    private boolean verbose = true;
    private double relativeSmoothnessWt;
    private ColumnOrganizedAnnealingData equalityData;
    private ColumnOrganizedAnnealingData inequalityData;
    private static DecimalFormat tDF = new DecimalFormat("0.#");
    private static DecimalFormat cDF = new DecimalFormat("#");
    protected static DecimalFormat pDF;

    public ThreadedSimulatedAnnealing(DoubleMatrix2D A, double[] d, double[] initialState, int numThreads, CompletionCriteria subCompetionCriteria) {
        this(A, d, initialState, 0.0, null, null, numThreads, subCompetionCriteria);
    }

    public ThreadedSimulatedAnnealing(DoubleMatrix2D A, double[] d, double[] initialState, double relativeSmoothnessWt, DoubleMatrix2D A_ineq, double[] d_ineq, int numThreads, CompletionCriteria subCompetionCriteria) {
        this(new ColumnOrganizedAnnealingData(A, d), A_ineq == null ? null : new ColumnOrganizedAnnealingData(A_ineq, d_ineq), initialState, relativeSmoothnessWt, numThreads, subCompetionCriteria);
    }

    public ThreadedSimulatedAnnealing(ColumnOrganizedAnnealingData equalityData, ColumnOrganizedAnnealingData inequalityData, double[] initialState, double relativeSmoothnessWt, int numThreads, CompletionCriteria subCompetionCriteria) {
        this.relativeSmoothnessWt = relativeSmoothnessWt;
        Preconditions.checkState((numThreads > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 thread");
        ArrayList<SerialSimulatedAnnealing> sas = new ArrayList<SerialSimulatedAnnealing>();
        for (int i = 0; i < numThreads; ++i) {
            sas.add(new SerialSimulatedAnnealing(equalityData, inequalityData, initialState, relativeSmoothnessWt));
        }
        this.init(sas, subCompetionCriteria, false);
    }

    public ThreadedSimulatedAnnealing(List<? extends SimulatedAnnealing> sas, CompletionCriteria subCompetionCriteria) {
        this.init(sas, subCompetionCriteria, false);
    }

    public ThreadedSimulatedAnnealing(List<? extends SimulatedAnnealing> sas, CompletionCriteria subCompetionCriteria, boolean average) {
        this.init(sas, subCompetionCriteria, average);
    }

    private void init(List<? extends SimulatedAnnealing> sas, CompletionCriteria subCompetionCriteria, boolean average) {
        Preconditions.checkState((!sas.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least 1 thread");
        Preconditions.checkNotNull((Object)subCompetionCriteria, (Object)"subCompetionCriteria cannot be null");
        this.numThreads = sas.size();
        this.subCompletionCriteria = subCompetionCriteria;
        this.sas = sas;
        for (SimulatedAnnealing simulatedAnnealing : sas) {
            if (!(simulatedAnnealing instanceof ThreadedSimulatedAnnealing)) continue;
            ((ThreadedSimulatedAnnealing)simulatedAnnealing).verbose = false;
        }
        SimulatedAnnealing sa0 = sas.get(0);
        this.initialState = sa0.getInitialSolution();
        this.xbest = sa0.getBestSolution();
        this.numNonZero = sa0.getNumNonZero();
        this.equalityData = sa0.getEqualityData();
        this.inequalityData = sa0.getInequalityData();
        this.average = average;
    }

    public List<? extends SimulatedAnnealing> getSAs() {
        return this.sas;
    }

    public void setSubCompletionCriteria(CompletionCriteria subCompletionCriteria) {
        this.subCompletionCriteria = subCompletionCriteria;
    }

    public CompletionCriteria getSubCompetionCriteria() {
        return this.subCompletionCriteria;
    }

    public boolean isStartSubIterationsAtZero() {
        return this.startSubIterationsAtZero;
    }

    public void setStartSubIterationsAtZero(boolean startSubIterationsAtZero) {
        this.startSubIterationsAtZero = startSubIterationsAtZero;
    }

    public void setCheckPointCriteria(TimeCompletionCriteria checkPointCriteria, File checkPointFilePrefix) {
        this.checkPointCriteria = checkPointCriteria;
        this.checkPointFileBase = checkPointFilePrefix;
    }

    public void setAverage(boolean average) {
        this.average = average;
    }

    public boolean isAverage() {
        return this.average;
    }

    protected static CompletionCriteria getForStartIter(long startIter, CompletionCriteria subComp) {
        if (subComp instanceof IterationCompletionCriteria) {
            long iters = ((IterationCompletionCriteria)subComp).getMinIterations();
            subComp = new IterationCompletionCriteria(startIter + iters);
        } else if (subComp instanceof IterationsPerVariableCompletionCriteria) {
            double otersPerVariable = ((IterationsPerVariableCompletionCriteria)subComp).getItersPerVariable();
            subComp = new IterationsPerVariableCompletionCriteria(otersPerVariable, startIter);
        }
        return subComp;
    }

    @Override
    public void setCalculationParams(CoolingScheduleType coolingFunc, NonnegativityConstraintType nonnegativeityConstraintAlgorithm, GenerationFunctionType perturbationFunc) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setCalculationParams(coolingFunc, nonnegativeityConstraintAlgorithm, perturbationFunc);
        }
    }

    @Override
    public CoolingScheduleType getCoolingFunc() {
        return this.sas.get(0).getCoolingFunc();
    }

    @Override
    public void setCoolingFunc(CoolingScheduleType coolingFunc) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setCoolingFunc(coolingFunc);
        }
    }

    @Override
    public NonnegativityConstraintType getNonnegativeityConstraintAlgorithm() {
        return this.sas.get(0).getNonnegativeityConstraintAlgorithm();
    }

    @Override
    public void setNonnegativeityConstraintAlgorithm(NonnegativityConstraintType nonnegativeityConstraintAlgorithm) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setNonnegativeityConstraintAlgorithm(nonnegativeityConstraintAlgorithm);
        }
    }

    @Override
    public GenerationFunctionType getPerturbationFunc() {
        return this.sas.get(0).getPerturbationFunc();
    }

    @Override
    public void setPerturbationFunc(GenerationFunctionType perturbationFunc) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setPerturbationFunc(perturbationFunc);
        }
    }

    @Override
    public void setRuptureSampler(IntegerSampler rupSampler) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setRuptureSampler(rupSampler);
        }
    }

    @Override
    public void setVariablePerturbationBasis(double[] variablePerturbBasis) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setVariablePerturbationBasis(variablePerturbBasis);
        }
    }

    @Override
    public double[] getBestSolution() {
        return this.xbest;
    }

    @Override
    public double[] getBestEnergy() {
        return this.Ebest;
    }

    @Override
    public double[] getBestMisfit() {
        return this.misfit;
    }

    @Override
    public double[] getBestInequalityMisfit() {
        return this.misfit_ineq;
    }

    @Override
    public void setResults(double[] Ebest, double[] xbest) {
        int numNonZero = 0;
        for (double x : xbest) {
            if (!(x > 0.0)) continue;
            ++numNonZero;
        }
        this.setResults(Ebest, xbest, null, null, numNonZero);
    }

    @Override
    public void setResults(double[] Ebest, double[] xbest, double[] misfit, double[] misfit_ineq, int numNonZero) {
        this.Ebest = Ebest;
        this.xbest = xbest;
        this.misfit = misfit;
        this.misfit_ineq = misfit_ineq;
        this.numNonZero = numNonZero;
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setResults(Ebest, xbest, misfit, misfit_ineq, numNonZero);
        }
    }

    @Override
    public InversionState iterate(long numIterations) {
        return this.iterate(null, new IterationCompletionCriteria(numIterations));
    }

    @Override
    public InversionState iterate(CompletionCriteria completion) {
        return this.iterate(null, completion);
    }

    protected void beforeRound(InversionState state, int rounds) {
    }

    protected void afterRound(InversionState prevState, InversionState newState, int rounds) {
    }

    @Override
    public InversionState iterate(InversionState startingState, CompletionCriteria criteria) {
        CompletionCriteria wrapped;
        boolean rangeTrack;
        if (this.verbose) {
            System.out.println("Threaded Simulated Annealing starting with " + this.numThreads + " threads, " + String.valueOf(criteria) + ", SUB: " + String.valueOf(this.subCompletionCriteria));
        }
        boolean bl = rangeTrack = this.constraintRanges != null && !this.constraintRanges.isEmpty();
        if (rangeTrack && criteria instanceof ProgressTrackingCompletionCriteria) {
            ((ProgressTrackingCompletionCriteria)criteria).setConstraintRanges(this.constraintRanges);
        }
        StopWatch watch = new StopWatch();
        watch.start();
        StopWatch checkPointWatch = null;
        long numCheckPoints = 0L;
        if (this.checkPointCriteria != null) {
            checkPointWatch = new StopWatch();
            checkPointWatch.start();
        }
        long startIter = startingState == null ? 0L : startingState.iterations;
        long startPerturbs = startingState == null ? 0L : startingState.numPerturbsKept;
        long startWorseKept = startingState == null ? 0L : startingState.numWorseValuesKept;
        long perturbs = startPerturbs;
        long worseKept = startWorseKept;
        if (this.subCompletionCriteria instanceof VariableSubTimeCompletionCriteria) {
            ((VariableSubTimeCompletionCriteria)this.subCompletionCriteria).setGlobalCriteria(criteria);
        }
        if (criteria == this.subCompletionCriteria && criteria instanceof ProgressTrackingCompletionCriteria) {
            criteria = ((ProgressTrackingCompletionCriteria)criteria).getCriteria();
        }
        CompletionCriteria.EstimationCompletionCriteria estCriteria = null;
        if (criteria instanceof CompletionCriteria.EstimationCompletionCriteria) {
            estCriteria = (CompletionCriteria.EstimationCompletionCriteria)criteria;
        } else if (criteria instanceof ProgressTrackingCompletionCriteria && (wrapped = ((ProgressTrackingCompletionCriteria)criteria).getCriteria()) instanceof CompletionCriteria.EstimationCompletionCriteria) {
            estCriteria = (CompletionCriteria.EstimationCompletionCriteria)wrapped;
        }
        if (this.exec == null) {
            String nameAdd = "TSA-" + (this.average ? "avg" : "worker");
            this.exec = ExecutorUtils.newDaemonThreadPool(this.numThreads, nameAdd);
        }
        int rounds = 0;
        long iter = startIter;
        double[] prevBestE = null;
        InversionState state = new InversionState(watch.getTime(), iter, this.Ebest, perturbs, worseKept, this.numNonZero, this.xbest, this.misfit, this.misfit_ineq, this.constraintRanges);
        while (!criteria.isSatisfied(state)) {
            int i;
            this.beforeRound(state, rounds);
            if (this.subCompletionCriteria instanceof VariableSubTimeCompletionCriteria) {
                ((VariableSubTimeCompletionCriteria)this.subCompletionCriteria).setGlobalState(watch, iter, this.Ebest, perturbs);
            }
            if (this.checkPointCriteria != null && this.checkPointCriteria.isSatisfied(new InversionState(checkPointWatch.getTime(), iter, this.Ebest, perturbs, worseKept, this.numNonZero, this.xbest, this.misfit, this.misfit_ineq, this.constraintRanges))) {
                System.out.println("Writing checkpoint after " + iter + " iterations. Ebest: " + Doubles.join((String)", ", (double[])this.Ebest));
                long millis = this.checkPointCriteria.getMillis();
                String name = this.checkPointFileBase.getName() + "_checkpoint_" + TimeCompletionCriteria.getTimeStr(millis *= ++numCheckPoints);
                File checkPointFile = new File(this.checkPointFileBase.getParentFile(), name + ".bin");
                try {
                    this.writeBestSolution(checkPointFile, null);
                    this.writeRateVsRankPlot(checkPointFile.getParentFile(), name + "_rate_dist", null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                checkPointWatch.reset();
                checkPointWatch.start();
            }
            ArrayList<Future<SACall>> futures = new ArrayList<Future<SACall>>();
            long threadStartIter = this.startSubIterationsAtZero ? 0L : iter;
            InversionState threadStartState = new InversionState(state.elapsedTimeMillis, threadStartIter, this.Ebest, perturbs, worseKept, this.numNonZero, this.xbest, this.misfit, this.misfit_ineq, this.constraintRanges);
            for (i = 0; i < this.numThreads; ++i) {
                futures.add(this.exec.submit(new SACall(this.sas.get(i), threadStartState, this.subCompletionCriteria)));
            }
            if (this.average && this.numThreads > 1) {
                double rateMult = 1.0 / (double)this.numThreads;
                double[] newE = null;
                double[] newX = null;
                double[] newMisfit = null;
                double[] newMisfitIneq = null;
                long prevPerturbs = perturbs;
                long prevWorseKept = worseKept;
                for (int i2 = 0; i2 < this.numThreads; ++i2) {
                    SACall thread;
                    try {
                        thread = (SACall)((Future)futures.get(i2)).get();
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    if (thread.fatal) {
                        throw ExceptionUtils.asRuntimeException(thread.t);
                    }
                    SimulatedAnnealing sa = this.sas.get(i2);
                    double[] dArray = sa.getBestEnergy();
                    double[] xbest = sa.getBestSolution();
                    double[] misfit = sa.getBestMisfit();
                    double[] misfit_ineq = sa.getBestInequalityMisfit();
                    if (newE == null) {
                        newE = new double[4];
                        newX = new double[xbest.length];
                        if (misfit != null) {
                            newMisfit = new double[misfit.length];
                        }
                        if (misfit_ineq != null) {
                            newMisfitIneq = new double[misfit_ineq.length];
                        }
                    }
                    ThreadedSimulatedAnnealing.addScaled(newE, dArray, rateMult);
                    ThreadedSimulatedAnnealing.addScaled(newX, xbest, rateMult);
                    if (newMisfit != null) {
                        ThreadedSimulatedAnnealing.addScaled(newMisfit, misfit, rateMult);
                    }
                    if (newMisfitIneq != null) {
                        ThreadedSimulatedAnnealing.addScaled(newMisfitIneq, misfit_ineq, rateMult);
                    }
                    perturbs += thread.endState.numPerturbsKept - prevPerturbs;
                    worseKept += thread.endState.numWorseValuesKept - prevWorseKept;
                    iter = Long.max(thread.endState.iterations, iter);
                }
                this.numNonZero = 0;
                for (void var42_49 : newX) {
                    if (!(var42_49 > 0.0)) continue;
                    ++this.numNonZero;
                }
                this.Ebest = newE;
                this.xbest = newX;
                this.misfit = newMisfit;
                this.misfit_ineq = newMisfitIneq;
            } else {
                for (i = 0; i < this.numThreads; ++i) {
                    SACall sACall;
                    try {
                        sACall = (SACall)((Future)futures.get(i)).get();
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    if (sACall.fatal) {
                        throw ExceptionUtils.asRuntimeException(sACall.t);
                    }
                    SimulatedAnnealing sa = this.sas.get(i);
                    double[] E = sa.getBestEnergy();
                    if (E[0] < this.Ebest[0]) {
                        this.Ebest = E;
                        this.xbest = sa.getBestSolution();
                        this.misfit = sa.getBestMisfit();
                        this.misfit_ineq = sa.getBestInequalityMisfit();
                        this.numNonZero = sa.getNumNonZero();
                        perturbs = sACall.endState.numPerturbsKept;
                        worseKept = sACall.endState.numWorseValuesKept;
                    }
                    iter = Long.max(sACall.endState.iterations, iter);
                }
            }
            ++rounds;
            if (rangeTrack) {
                this.Ebest = this.sas.get(0).calculateEnergy(this.xbest, this.misfit, this.misfit_ineq, this.constraintRanges);
            }
            InversionState prevState = state;
            state = new InversionState(watch.getTime(), iter, this.Ebest, perturbs, worseKept, this.numNonZero, this.xbest, this.misfit, this.misfit_ineq, this.constraintRanges);
            this.afterRound(prevState, state, rounds);
            if (this.verbose) {
                double secs = (double)watch.getTime() / 1000.0;
                int ips = (int)((double)iter / secs + 0.5);
                String timeStr = "Threaded total round " + rounds + " DONE after " + ThreadedSimulatedAnnealing.timeStr(watch.getTime()) + ", " + cDF.format(iter) + " total iterations (" + cDF.format(ips) + " /sec).";
                if (estCriteria != null) {
                    double fractDone = estCriteria.estimateFractCompleted(state);
                    long timeEst = estCriteria.estimateTimeLeft(state);
                    timeStr = timeStr + "\t" + pDF.format(fractDone) + " done (" + ThreadedSimulatedAnnealing.timeStr(timeEst) + " left).";
                }
                System.out.println(timeStr);
                System.out.println(cDF.format(this.numNonZero) + "/" + cDF.format(this.xbest.length) + " = " + pDF.format((double)this.numNonZero / (double)this.xbest.length) + " non-zero rates.\tBest energy after " + cDF.format(perturbs) + " total perturbations:");
                this.printEnergies(this.Ebest, prevBestE, this.constraintRanges);
                prevBestE = this.Ebest;
            }
            for (SimulatedAnnealing simulatedAnnealing : this.sas) {
                simulatedAnnealing.setResults(this.Ebest, this.xbest, this.misfit, this.misfit_ineq, this.numNonZero);
            }
        }
        watch.stop();
        if (this.verbose) {
            System.out.println("Threaded annealing schedule completed.");
            System.out.println("Done with Inversion after " + ThreadedSimulatedAnnealing.timeStr(watch.getTime()) + ".");
            System.out.println("Rounds: " + rounds);
            System.out.println("Total Iterations: " + iter);
            System.out.println("Total Perturbations: " + perturbs);
            System.out.println("Best energy:");
            this.printEnergies(this.Ebest, null, this.constraintRanges);
        }
        return state;
    }

    public void shutdown() {
        if (this.exec != null) {
            this.exec.shutdown();
            this.exec = null;
        }
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            if (!(simulatedAnnealing instanceof ThreadedSimulatedAnnealing)) continue;
            ((ThreadedSimulatedAnnealing)simulatedAnnealing).shutdown();
        }
    }

    public static String timeStr(long millis) {
        double secs = (double)millis / 1000.0;
        if (secs < 60.0) {
            return tDF.format(secs) + " secs";
        }
        double mins = secs / 60.0;
        if (mins < 60.0) {
            return ThreadedSimulatedAnnealing.twoPartTimeStr((int)mins, "min", secs - (double)((int)mins) * 60.0, "secs");
        }
        double hours = mins / 60.0;
        return ThreadedSimulatedAnnealing.twoPartTimeStr((int)hours, "hour", mins - (double)((int)hours) * 60.0, "mins");
    }

    static String twoPartTimeStr(int first, String firstUnits, double remainder, String remainderUnits) {
        String ret = first + " " + firstUnits;
        if (!firstUnits.endsWith("s") && first > 1) {
            ret = ret + "s";
        }
        if (remainder < 0.01) {
            return ret;
        }
        return ret + " " + tDF.format(remainder) + " " + remainderUnits;
    }

    private void printEnergies(double[] Ebest, double[] prev, List<ConstraintRange> constraintRanges) {
        int numIneq = this.inequalityData == null ? 0 : this.inequalityData.nRows;
        ThreadedSimulatedAnnealing.printEnergies(Ebest, prev, constraintRanges, this.relativeSmoothnessWt, numIneq);
    }

    private static void printEnergies(double[] Ebest, double[] prev, List<ConstraintRange> constraintRanges, double entropyWeight, int numIneqRows) {
        int ind;
        ArrayList<Object> strs = new ArrayList<Object>();
        block6: for (int i = 0; i < Ebest.length; ++i) {
            Object str;
            switch (i) {
                case 0: {
                    str = "Total:\t";
                    break;
                }
                case 1: {
                    if (!(entropyWeight > 0.0) && numIneqRows <= 0) continue block6;
                    str = "Equality:\t";
                    break;
                }
                case 2: {
                    if (!(entropyWeight > 0.0)) continue block6;
                    str = "Entropy:\t";
                    break;
                }
                case 3: {
                    if (numIneqRows <= 0) continue block6;
                    str = "Inequality:\t";
                    break;
                }
                default: {
                    ind = i - 4;
                    str = constraintRanges == null || ind >= constraintRanges.size() || constraintRanges.get(ind) == null ? "Constraint " + ind + ":\t" : constraintRanges.get((int)ind).shortName + ":\t";
                }
            }
            str = (String)str + (float)Ebest[i];
            if (prev != null) {
                double diff = Ebest[i] - prev[i];
                str = (String)str + " (";
                if (diff > 0.0) {
                    str = (String)str + "+";
                }
                str = (String)str + pDF.format(diff / prev[i]) + ")";
            }
            strs.add(str);
        }
        int cols = strs.size() > 9 ? 4 : (strs.size() > 4 ? 3 : strs.size());
        int lines = strs.size() / cols;
        if (strs.size() % cols != 0) {
            ++lines;
        }
        ind = 0;
        for (int l = 0; l < lines; ++l) {
            StringBuilder str = new StringBuilder();
            for (int c = 0; c < cols && ind < strs.size(); ++c) {
                str.append("\t").append((String)strs.get(ind++));
            }
            System.out.println(str.toString());
        }
    }

    private static void addScaled(double[] dest, double[] source, double scale) {
        for (int i = 0; i < dest.length; ++i) {
            int n = i;
            dest[n] = dest[n] + source[i] * scale;
        }
    }

    @Override
    public void setRandom(Random r) {
        if (this.sas.size() == 1) {
            this.sas.get(0).setRandom(r);
        } else {
            for (SimulatedAnnealing simulatedAnnealing : this.sas) {
                simulatedAnnealing.setRandom(new Random(r.nextLong()));
            }
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        Preconditions.checkState((numThreads <= this.numThreads ? 1 : 0) != 0, (Object)"Can only decrease number of threads for now");
        this.numThreads = numThreads;
        while (this.sas.size() > numThreads) {
            this.sas.remove(this.sas.size() - 1);
        }
    }

    @Override
    public void setConstraintRanges(List<ConstraintRange> constraintRanges) {
        this.constraintRanges = constraintRanges;
        if (constraintRanges == null) {
            if (this.Ebest.length > 4) {
                this.Ebest = Arrays.copyOf(this.Ebest, 4);
            }
        } else if (this.Ebest.length < constraintRanges.size() + 4) {
            int curLen = this.Ebest.length;
            this.Ebest = Arrays.copyOf(this.Ebest, 4 + constraintRanges.size());
            for (int i = curLen; i < this.Ebest.length; ++i) {
                this.Ebest[i] = Double.POSITIVE_INFINITY;
            }
        }
    }

    @Override
    public List<ConstraintRange> getConstraintRanges() {
        return this.constraintRanges;
    }

    public static Options createOptionsNoInputs() {
        Options ops = SerialSimulatedAnnealing.createOptions();
        Option subOption = new Option("s", "sub-completion", true, "number of sub iterations. Optionally, append 's' to specify in seconds or 'm' to specify in minutes instead of iterations. You can also specify a range of times in the form 'time,time'.");
        subOption.setRequired(true);
        ops.addOption(subOption);
        Option numThreadsOption = new Option("t", "num-threads", true, "number of threads (percentage of available can also be specified, for example, '50%')");
        numThreadsOption.setRequired(true);
        ops.addOption(numThreadsOption);
        Option solutionFileOption = new Option("sol", "solution-file", true, "file to store solution");
        solutionFileOption.setRequired(false);
        ops.addOption(solutionFileOption);
        Option timeOption = new Option("time", "completion-time", true, "time to anneal. append 's' for secionds, 'm' for minutes, 'h' for hours. default is millis.");
        timeOption.setRequired(false);
        ops.addOption(timeOption);
        Option iterOption = new Option("iter", "completion-iterations", true, "num iterations to anneal");
        iterOption.setRequired(false);
        ops.addOption(iterOption);
        Option energyOption = new Option("energy", "completion-energy", true, "energy maximum to anneal to");
        energyOption.setRequired(false);
        ops.addOption(energyOption);
        Option deltaEnergyOption = new Option("delenergy", "completion-delta-energy", true, "energy change completion criteria. Format: <time>,<%>,<diff>. For example: 60,1.5,2 means a look back period of 60 minutes, a minimum percent improvement of 1.5%, and a minimum actual energy change of 2.");
        deltaEnergyOption.setRequired(false);
        ops.addOption(deltaEnergyOption);
        Option smoothnessWeightOption = new Option("smoothness", "smoothness-weight", true, "weight for the entropy constraint");
        smoothnessWeightOption.setRequired(false);
        ops.addOption(smoothnessWeightOption);
        Option initial = new Option("i", "initial-state-file", true, "initial state file (optional...default is all zeros)");
        initial.setRequired(false);
        ops.addOption(initial);
        Option progressFileOption = new Option("p", "progress-file", true, "file to store progress results");
        progressFileOption.setRequired(false);
        ops.addOption(progressFileOption);
        Option subIterationsStartOption = new Option("zero", "start-sub-iters-zero", false, "flag to start all sub iterations at zero instead of the true iteration count");
        subIterationsStartOption.setRequired(false);
        ops.addOption(subIterationsStartOption);
        Option checkPointOption = new Option("chk", "checkpoint", true, "will write out solutions on the given time interval. append 's' for secionds, 'm' for minutes, 'h' for hours. default is millis.");
        checkPointOption.setRequired(false);
        ops.addOption(checkPointOption);
        Option plotsOption = new Option("plot", "plots", false, "write a variety of plots to the filesystem when annealing has completed");
        plotsOption.setRequired(false);
        ops.addOption(plotsOption);
        return ops;
    }

    public static Options createOptions() {
        Options ops = ThreadedSimulatedAnnealing.createOptionsNoInputs();
        Option aMatrix = new Option("a", "a-matrix-file", true, "A matrix file");
        aMatrix.setRequired(false);
        ops.addOption(aMatrix);
        Option dMatrix = new Option("d", "d-matrix-file", true, "D matrix file");
        dMatrix.setRequired(false);
        ops.addOption(dMatrix);
        Option a_MFDMatrix = new Option("aineq", "a-ineq-matrix-file", true, "A inequality matrix file");
        a_MFDMatrix.setRequired(false);
        ops.addOption(a_MFDMatrix);
        Option d_MFDMatrix = new Option("dineq", "d-ineq-matrix-file", true, "D inequality matrix file");
        d_MFDMatrix.setRequired(false);
        ops.addOption(d_MFDMatrix);
        Option zipInputs = new Option("zip", "zip-file", true, "Zip file containing all inputs. File names must be a.bin, d.bin, and optionally: initial.bin, a_ineq.bin, d_ineq.bin, minimumRuptureRates.bin, metadata.txt");
        zipInputs.setRequired(false);
        ops.addOption(zipInputs);
        return ops;
    }

    public static String subCompletionCriteriaToArgument(CompletionCriteria subCompletion) {
        return ThreadedSimulatedAnnealing.subCompletionCriteriaToArgument("sub-completion", subCompletion);
    }

    public static String subCompletionCriteriaToArgument(String argName, CompletionCriteria subCompletion) {
        return "--" + argName + " " + ThreadedSimulatedAnnealing.subCompletionArgVal(subCompletion);
    }

    public static String subCompletionArgVal(CompletionCriteria subCompletion) {
        if (subCompletion instanceof IterationCompletionCriteria) {
            return "" + ((IterationCompletionCriteria)subCompletion).getMinIterations();
        }
        if (subCompletion instanceof TimeCompletionCriteria) {
            return ((TimeCompletionCriteria)subCompletion).getTimeStr();
        }
        if (subCompletion instanceof VariableSubTimeCompletionCriteria) {
            return ((VariableSubTimeCompletionCriteria)subCompletion).getTimeStr();
        }
        throw new UnsupportedOperationException("Can't create command line argument for: " + String.valueOf(subCompletion));
    }

    public static String completionCriteriaToArgument(CompletionCriteria criteria) {
        if (criteria instanceof EnergyCompletionCriteria) {
            return "--completion-energy " + ((EnergyCompletionCriteria)criteria).getMaxEnergy();
        }
        if (criteria instanceof IterationCompletionCriteria) {
            return "--completion-iterations " + ((IterationCompletionCriteria)criteria).getMinIterations();
        }
        if (criteria instanceof TimeCompletionCriteria) {
            return "--completion-time " + ((TimeCompletionCriteria)criteria).getTimeStr();
        }
        if (criteria instanceof CompoundCompletionCriteria) {
            Object str = null;
            for (CompletionCriteria subCriteria : ((CompoundCompletionCriteria)criteria).getCriteria()) {
                str = str == null ? "" : (String)str + " ";
                str = (String)str + ThreadedSimulatedAnnealing.completionCriteriaToArgument(subCriteria);
            }
            return str;
        }
        if (criteria instanceof ProgressTrackingCompletionCriteria) {
            throw new IllegalArgumentException("ProgressTrackingCompletionCriteria not supported,use --progress-file instead");
        }
        throw new UnsupportedOperationException("Can't create command line argument for: " + String.valueOf(criteria));
    }

    public static CompletionCriteria parseCompletionCriteria(CommandLine cmd) {
        ArrayList<CompletionCriteria> criterias = new ArrayList<CompletionCriteria>();
        if (cmd.hasOption("time")) {
            String timeStr = cmd.getOptionValue("time");
            long time = timeStr.toLowerCase().endsWith("s") ? (long)(Double.parseDouble(timeStr.substring(0, timeStr.length() - 1)) * 1000.0) : (timeStr.toLowerCase().endsWith("m") ? (long)(Double.parseDouble(timeStr.substring(0, timeStr.length() - 1)) * 1000.0 * 60.0) : (timeStr.toLowerCase().endsWith("h") ? (long)(Double.parseDouble(timeStr.substring(0, timeStr.length() - 1)) * 1000.0 * 60.0 * 60.0) : Long.parseLong(timeStr)));
            criterias.add(new TimeCompletionCriteria(time));
        }
        if (cmd.hasOption("iter")) {
            criterias.add(new IterationCompletionCriteria(Long.parseLong(cmd.getOptionValue("iter"))));
        }
        if (cmd.hasOption("energy")) {
            criterias.add(new EnergyCompletionCriteria(Double.parseDouble(cmd.getOptionValue("energy"))));
        }
        if (cmd.hasOption("delenergy")) {
            criterias.add(EnergyChangeCompletionCriteria.fromCommandLineArgument(cmd.getOptionValue("delenergy")));
        }
        if (criterias.size() == 0) {
            throw new IllegalArgumentException("must specify at least one completion criteria!");
        }
        CompletionCriteria criteria = criterias.size() == 1 ? (CompletionCriteria)criterias.get(0) : new CompoundCompletionCriteria(criterias);
        if (cmd.hasOption("progress-file")) {
            File progressFile = new File(cmd.getOptionValue("progress-file"));
            criteria = new ProgressTrackingCompletionCriteria(criteria, progressFile);
        }
        return criteria;
    }

    public static CompletionCriteria parseSubCompletionCriteria(String optionVal) {
        if (optionVal.contains(",")) {
            String[] times = optionVal.split(",");
            Preconditions.checkArgument((times.length == 2 ? 1 : 0) != 0, (Object)("must specify exactly 2 times if using multiple option: " + optionVal));
            long maxTime = TimeCompletionCriteria.parseTimeString(times[0]);
            long minTime = TimeCompletionCriteria.parseTimeString(times[1]);
            Preconditions.checkArgument((maxTime >= minTime ? 1 : 0) != 0, (Object)("max must be greater than min! (" + optionVal + ")"));
            return new VariableSubTimeCompletionCriteria(maxTime, minTime);
        }
        if (optionVal.endsWith("s") || optionVal.endsWith("m") || optionVal.endsWith("h") || optionVal.endsWith("mi")) {
            return TimeCompletionCriteria.fromTimeString(optionVal);
        }
        return new IterationCompletionCriteria(Long.parseLong(optionVal));
    }

    public static int parseNumThreads(String threadsVal) {
        if (threadsVal.endsWith("%")) {
            threadsVal = threadsVal.substring(0, threadsVal.length() - 1);
            double threadPercent = Double.parseDouble(threadsVal);
            int avail = Runtime.getRuntime().availableProcessors();
            double threadDouble = (double)avail * threadPercent * 0.01;
            int numThreads = (int)(threadDouble + 0.5);
            System.out.println("Percentage based threads..." + threadsVal + "% of " + avail + " = " + threadDouble + " = " + numThreads);
            return numThreads < 1 ? 1 : numThreads;
        }
        return Integer.parseInt(threadsVal);
    }

    public static ThreadedSimulatedAnnealing parseOptions(CommandLine cmd) throws IOException {
        DoubleMatrix2D A = null;
        double[] d = null;
        double[] initialState = null;
        DoubleMatrix2D A_ineq = null;
        double[] d_ineq = null;
        ArrayList<ConstraintRange> constraintRanges = null;
        if (cmd.hasOption("zip")) {
            ZipEntry rangeEntry;
            ZipEntry initial_entry;
            ZipEntry d_ineq_entry;
            File zipFile = new File(cmd.getOptionValue("zip"));
            System.out.println("Opening zip file: " + zipFile.getAbsolutePath());
            ZipFile zip = new ZipFile(zipFile);
            ZipEntry a_entry = zip.getEntry("a.bin");
            A = MatrixIO.loadSparse(new BufferedInputStream(zip.getInputStream(a_entry)), SparseCCDoubleMatrix2D.class);
            ZipEntry d_entry = zip.getEntry("d.bin");
            d = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(d_entry)), A.rows() * 8);
            ZipEntry a_ineq_entry = zip.getEntry("a_ineq.bin");
            if (a_ineq_entry != null) {
                A_ineq = MatrixIO.loadSparse(new BufferedInputStream(zip.getInputStream(a_ineq_entry)), SparseCCDoubleMatrix2D.class);
            }
            if ((d_ineq_entry = zip.getEntry("d_ineq.bin")) != null && A_ineq != null) {
                d_ineq = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(d_ineq_entry)), A_ineq.rows() * 8);
            }
            if ((initial_entry = zip.getEntry("initial.bin")) != null) {
                initialState = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(initial_entry)), A.columns() * 8);
            }
            if ((rangeEntry = zip.getEntry("constraintRanges.csv")) != null) {
                constraintRanges = new ArrayList<ConstraintRange>();
                CSVFile<String> rangeCSV = CSVFile.readStream(zip.getInputStream(rangeEntry), true);
                for (int row = 1; row < rangeCSV.getNumRows(); ++row) {
                    String name = rangeCSV.get(row, 0);
                    String shortName = rangeCSV.get(row, 1);
                    boolean inequality = rangeCSV.getBoolean(row, 2);
                    int startRow = rangeCSV.getInt(row, 3);
                    int endRow = rangeCSV.getInt(row, 4);
                    constraintRanges.add(new ConstraintRange(name, shortName, startRow, endRow, inequality, Double.NaN, null));
                }
            }
            zip.close();
        } else {
            File aFile = new File(cmd.getOptionValue("a"));
            System.out.println("Loading A matrix from: " + aFile.getAbsolutePath());
            A = MatrixIO.loadSparse(aFile, SparseCCDoubleMatrix2D.class);
            File dFile = new File(cmd.getOptionValue("d"));
            System.out.println("Loading d matrix from: " + dFile.getAbsolutePath());
            d = MatrixIO.doubleArrayFromFile(dFile);
            if (cmd.hasOption("aineq")) {
                File a_ineqFile = new File(cmd.getOptionValue("aineq"));
                System.out.println("Loading A_ineq matrix from: " + a_ineqFile.getAbsolutePath());
                A_ineq = MatrixIO.loadSparse(a_ineqFile, SparseCCDoubleMatrix2D.class);
            }
            if (cmd.hasOption("dineq")) {
                File d_ineqFile = new File(cmd.getOptionValue("dineq"));
                System.out.println("Loading d_ineq matrix from: " + d_ineqFile.getAbsolutePath());
                d_ineq = MatrixIO.doubleArrayFromFile(d_ineqFile);
            }
            if (cmd.hasOption("i")) {
                File initialFile = new File(cmd.getOptionValue("i"));
                System.out.println("Loading initialState from: " + initialFile.getAbsolutePath());
                initialState = MatrixIO.doubleArrayFromFile(initialFile);
            }
        }
        return ThreadedSimulatedAnnealing.parseOptions(cmd, A, d, initialState, A_ineq, d_ineq, constraintRanges);
    }

    public static ThreadedSimulatedAnnealing parseOptions(CommandLine cmd, DoubleMatrix2D A, double[] d, double[] initialState, DoubleMatrix2D A_ineq, double[] d_ineq, List<ConstraintRange> constraintRanges) throws IOException {
        double relativeSmoothnessWt = cmd.hasOption("smoothness") ? Double.parseDouble(cmd.getOptionValue("smoothness")) : 0.0;
        if (initialState == null) {
            initialState = new double[A.columns()];
        }
        CompletionCriteria subCompletionCriteria = ThreadedSimulatedAnnealing.parseSubCompletionCriteria(cmd.getOptionValue("s"));
        int numThreads = ThreadedSimulatedAnnealing.parseNumThreads(cmd.getOptionValue("t"));
        ThreadedSimulatedAnnealing tsa = new ThreadedSimulatedAnnealing(A, d, initialState, relativeSmoothnessWt, A_ineq, d_ineq, numThreads, subCompletionCriteria);
        for (SimulatedAnnealing simulatedAnnealing : tsa.sas) {
            ((SerialSimulatedAnnealing)simulatedAnnealing).setCalculationParamsFromOptions(cmd);
        }
        if (cmd.hasOption("zero")) {
            tsa.setStartSubIterationsAtZero(true);
        }
        if (cmd.hasOption("checkpoint")) {
            File checkPointFilePrefix;
            String time = cmd.getOptionValue("checkpoint");
            TimeCompletionCriteria timeCompletionCriteria = TimeCompletionCriteria.fromTimeString(time);
            if (cmd.hasOption("solution-file")) {
                String outputStr = cmd.getOptionValue("solution-file");
                checkPointFilePrefix = ThreadedSimulatedAnnealing.getFileWithoutBinSuffix(outputStr);
            } else {
                File dir = new File(cmd.getOptionValue("directory"));
                String prefix = cmd.getOptionValue("branch-prefix");
                checkPointFilePrefix = new File(dir, prefix);
            }
            tsa.setCheckPointCriteria(timeCompletionCriteria, checkPointFilePrefix);
        }
        tsa.setConstraintRanges(constraintRanges);
        return tsa;
    }

    private static File getFileWithoutBinSuffix(String path) {
        if (path.endsWith(".bin")) {
            path = path.substring(0, path.lastIndexOf(".bin"));
        }
        return new File(path);
    }

    public static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ClassUtils.getClassNameWithoutPackage(ThreadedSimulatedAnnealing.class), options, true);
        System.exit(2);
    }

    public void writeBestSolution(File outputFile, double[] minimumRuptureRates) throws IOException {
        double[] solution = this.getBestSolution();
        if (minimumRuptureRates != null) {
            String outputFilePath = outputFile.getAbsolutePath();
            if (outputFilePath.endsWith(".bin")) {
                outputFilePath = outputFilePath.substring(0, outputFilePath.length() - 4);
            }
            File outputOrigFile = new File(outputFilePath + "_noMinRates.bin");
            System.out.println("Writing original solution to: " + outputOrigFile.getAbsolutePath());
            MatrixIO.doubleArrayToFile(solution, outputOrigFile);
            System.out.println("Applying minimum rupture rates");
            solution = InversionInputGenerator.adjustSolutionForWaterLevel(solution, minimumRuptureRates);
        }
        System.out.println("Writing solution to: " + outputFile.getAbsolutePath());
        MatrixIO.doubleArrayToFile(solution, outputFile);
    }

    public Map<ConstraintRange, Double> getEnergies() {
        if (this.constraintRanges == null) {
            return null;
        }
        HashMap energies = Maps.newHashMap();
        double[] e = this.getBestEnergy();
        for (int i = 4; i < e.length && i - 4 < this.constraintRanges.size(); ++i) {
            energies.put(this.constraintRanges.get(i - 4), e[i]);
        }
        return energies;
    }

    public String getMetadata(String[] args, CompletionCriteria criteria) {
        StringBuilder builder = new StringBuilder();
        builder.append("Distributed Simulated Annealing run completed on " + new SimpleDateFormat().format(new Date()) + "\n");
        builder.append("\n");
        Object argsStr = "";
        for (String arg : args) {
            argsStr = (String)argsStr + " " + arg;
        }
        builder.append("Arguments:" + (String)argsStr + "\n");
        builder.append("Completion Criteria: " + String.valueOf(criteria) + "\n");
        builder.append("Threads per node: " + this.getNumThreads() + "\n");
        builder.append("\n");
        builder.append("Solution size: " + this.getBestSolution().length + "\n");
        builder.append("A matrix size: " + this.equalityData.nRows + "x" + this.equalityData.nCols + "\n");
        if (this.inequalityData == null) {
            builder.append("A_ineq matrix size: (null)\n");
        } else {
            builder.append("A_ineq matrix size: " + this.inequalityData.nRows + "x" + this.inequalityData.nCols + "\n");
        }
        double[] e = this.getBestEnergy();
        builder.append("Best energy: " + Doubles.join((String)", ", (double[])e) + "\n");
        if (this.constraintRanges != null) {
            builder.append("Energy type breakdown\n");
            for (int i = 4; i < e.length && i - 4 < this.constraintRanges.size(); ++i) {
                builder.append("\t" + this.constraintRanges.get((int)(i - 4)).shortName + "\tenergy: " + e[i] + "\n");
            }
        }
        if (criteria instanceof ProgressTrackingCompletionCriteria) {
            ProgressTrackingCompletionCriteria track = (ProgressTrackingCompletionCriteria)criteria;
            AnnealingProgress progress = track.getProgress();
            int numSteps = progress.size();
            long millis = progress.getTime(numSteps - 1);
            double totMins = (double)millis / 1000.0 / 60.0;
            builder.append("Total time: " + totMins + " mins\n");
            long iters = progress.getIterations(numSteps - 1);
            long perturbs = progress.getNumPerturbations(numSteps - 1);
            builder.append("Total iterations: " + iters + "\n");
            float pertPercent = (float)((double)perturbs / (double)iters * 100.0);
            builder.append("Total perturbations: " + perturbs + " (" + pertPercent + " %)\n");
        }
        return builder.toString();
    }

    public void writeMetadata(File file, String[] args, CompletionCriteria criteria) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(this.getMetadata(args, criteria).toString());
        fw.close();
    }

    public static void main(String[] args) {
        Options options = ThreadedSimulatedAnnealing.createOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            ThreadedSimulatedAnnealing tsa = ThreadedSimulatedAnnealing.parseOptions(cmd);
            File outputFile = new File(cmd.getOptionValue("solution-file"));
            CompletionCriteria criteria = ThreadedSimulatedAnnealing.parseCompletionCriteria(cmd);
            tsa.iterate(criteria);
            tsa.writeBestSolution(outputFile, null);
            File prefix = ThreadedSimulatedAnnealing.getFileWithoutBinSuffix(outputFile.getAbsolutePath());
            tsa.writeMetadata(new File(prefix.getParentFile(), prefix.getName() + "_metadata.txt"), args, criteria);
            tsa.writePlots(criteria, prefix.getParentFile(), prefix.getName(), null);
            System.out.println("DONE...exiting.");
            System.exit(0);
        }
        catch (MissingOptionException e) {
            System.err.println(e.getMessage());
            ThreadedSimulatedAnnealing.printHelp(options);
        }
        catch (ParseException e) {
            System.err.println("Error parsing command line arguments:");
            e.printStackTrace();
            ThreadedSimulatedAnnealing.printHelp(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public double[] getInitialSolution() {
        return this.initialState;
    }

    @Override
    public int getNumNonZero() {
        return this.numNonZero;
    }

    @Override
    public ColumnOrganizedAnnealingData getEqualityData() {
        return this.equalityData;
    }

    @Override
    public DoubleMatrix2D getA() {
        return this.equalityData.A;
    }

    @Override
    public double[] getD() {
        return this.equalityData.d;
    }

    @Override
    public ColumnOrganizedAnnealingData getInequalityData() {
        return this.inequalityData;
    }

    @Override
    public DoubleMatrix2D getA_ineq() {
        return this.inequalityData == null ? null : this.inequalityData.A;
    }

    @Override
    public double[] getD_ineq() {
        return this.inequalityData == null ? null : this.inequalityData.d;
    }

    @Override
    public double[] calculateEnergy(double[] solution) {
        return this.sas.get(0).calculateEnergy(solution);
    }

    @Override
    public double[] calculateEnergy(double[] solution, double[] misfit, double[] misfit_ineq) {
        return this.sas.get(0).calculateEnergy(solution, misfit, misfit_ineq);
    }

    @Override
    public double[] calculateEnergy(double[] solution, double[] misfit, double[] misfit_ineq, List<ConstraintRange> constraintRanges) {
        return this.sas.get(0).calculateEnergy(solution, misfit, misfit_ineq, constraintRanges);
    }

    @Override
    public void setInputs(ColumnOrganizedAnnealingData equalityData, ColumnOrganizedAnnealingData inequalityData) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setInputs(equalityData, inequalityData);
        }
    }

    @Override
    public void setAll(ColumnOrganizedAnnealingData equalityData, ColumnOrganizedAnnealingData inequalityData, double[] Ebest, double[] xbest, double[] misfit, double[] misfit_ineq, int numNonZero) {
        for (SimulatedAnnealing simulatedAnnealing : this.sas) {
            simulatedAnnealing.setAll(equalityData, inequalityData, Ebest, xbest, misfit, misfit_ineq, numNonZero);
        }
        this.Ebest = Ebest;
        this.xbest = xbest;
        this.misfit = misfit;
        this.misfit_ineq = misfit_ineq;
        this.numNonZero = numNonZero;
    }

    static {
        cDF.setGroupingUsed(true);
        cDF.setGroupingSize(3);
        pDF = new DecimalFormat("0.00%");
    }

    private class SACall
    implements Callable<SACall> {
        private SimulatedAnnealing sa;
        private CompletionCriteria subComp;
        private InversionState startState;
        private InversionState endState;
        private boolean fatal = false;
        private Throwable t;

        public SACall(SimulatedAnnealing sa, InversionState startState, CompletionCriteria subComp) {
            this.sa = sa;
            this.startState = startState;
            this.subComp = subComp;
        }

        @Override
        public SACall call() {
            try {
                this.endState = this.sa.iterate(this.startState, ThreadedSimulatedAnnealing.getForStartIter(this.startState.iterations, this.subComp));
            }
            catch (Throwable t) {
                System.err.println("FATAL ERROR in thread!");
                t.printStackTrace();
                this.fatal = true;
                this.t = t;
            }
            return this;
        }
    }
}

