/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params;

import java.util.Random;

public enum GenerationFunctionType {
    UNIFORM_0p001{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            return (r.nextDouble() - 0.5) * 0.001;
        }
    }
    ,
    UNIFORM_0p0001{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            return (r.nextDouble() - 0.5) * 1.0E-4;
        }
    }
    ,
    VARIABLE_NO_TEMP_DEPENDENCE{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            double basis = variablePerturbationBasis[index];
            if (basis == 0.0) {
                basis = 1.0E-8;
            }
            return (r.nextDouble() - 0.5) * basis * 1000.0;
        }
    }
    ,
    GAUSSIAN{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            return 1.0 / Math.sqrt(temperature) * r.nextGaussian() * 1.0E-4 * Math.exp(1.0 / (2.0 * temperature));
        }
    }
    ,
    TANGENT{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            return temperature * 0.001 * Math.tan(Math.PI * r.nextDouble() - 1.5707963267948966);
        }
    }
    ,
    POWER_LAW{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            double r2 = r.nextDouble();
            return Math.signum(r2 - 0.5) * temperature * 0.001 * (Math.pow(1.0 + 1.0 / temperature, Math.abs(2.0 * r2 - 1.0)) - 1.0);
        }
    }
    ,
    EXPONENTIAL{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            double r2 = r.nextDouble();
            return Math.pow(10.0, r2) * temperature * 0.001;
        }
    }
    ,
    EXPONENTIAL_SCALE{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            double r2 = max_exp - r.nextDouble() * exp_orders_of_mag;
            double scale = Math.pow(10.0, r2);
            return (r.nextDouble() - 0.5) * scale;
        }
    }
    ,
    VARIABLE_EXPONENTIAL_SCALE{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            double basis = Math.log10(Math.max(1.0E-10, variablePerturbationBasis[index]));
            double r2 = basis + 2.0 - 4.0 * r.nextDouble();
            double scale = Math.pow(10.0, r2);
            return (r.nextDouble() - 0.5) * scale;
        }
    }
    ,
    FIXED_DEBUG{

        @Override
        public double getPerturbation(Random r, double temperature, int index, double[] variablePerturbationBasis) {
            return 0.01;
        }
    };

    public static double exp_orders_of_mag;
    public static double max_exp;

    public boolean isVariable() {
        return this == VARIABLE_NO_TEMP_DEPENDENCE || this == VARIABLE_EXPONENTIAL_SCALE;
    }

    public abstract double getPerturbation(Random var1, double var2, int var4, double[] var5);

    static {
        exp_orders_of_mag = 8.0;
        max_exp = -2.0;
    }
}

