/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.JSON_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class ClusterRuptures
implements SubModule<FaultSystemRupSet>,
Iterable<ClusterRupture>,
BranchAverageableModule<ClusterRuptures>,
AverageableModule.ConstantAverageable<ClusterRuptures>,
SplittableRuptureModule<ClusterRuptures> {
    protected FaultSystemRupSet rupSet;

    public ClusterRuptures(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }

    public abstract List<ClusterRupture> getAll();

    public ClusterRupture get(int rupIndex) {
        return this.getAll().get(rupIndex);
    }

    @Override
    public Iterator<ClusterRupture> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    public int size() {
        return this.getAll().size();
    }

    @Override
    public Class<ClusterRuptures> getAveragingType() {
        return ClusterRuptures.class;
    }

    public static ClusterRuptures instance(FaultSystemRupSet rupSet, RuptureConnectionSearch search) {
        return ClusterRuptures.instance(rupSet, search, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterRuptures instance(FaultSystemRupSet rupSet, RuptureConnectionSearch search, boolean maintainOrder) {
        PlausibilityConfiguration config = rupSet.getModule(PlausibilityConfiguration.class);
        System.out.println("Building ClusterRuptures for " + rupSet.getNumRuptures() + " ruptures");
        if (config != null && config.getMaxNumSplays() == 0) {
            System.out.println("Assuming simple single strand ruptures");
            return new SingleStranded(rupSet, null);
        }
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<ClusterRupture>> futures = new ArrayList<Future<ClusterRupture>>();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            futures.add(exec.submit(new ClusterRupCalc(search, r, maintainOrder)));
        }
        ArrayList<ClusterRupture> ruptures = new ArrayList<ClusterRupture>();
        for (int r = 0; r < futures.size(); ++r) {
            if (r % 1000 == 0) {
                System.out.println("Calculating for rupture " + r + "/" + rupSet.getNumRuptures());
            }
            Future future = (Future)futures.get(r);
            try {
                ruptures.add((ClusterRupture)future.get());
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                exec.shutdown();
                Class<ClusterRuptures> clazz = ClusterRuptures.class;
                synchronized (ClusterRuptures.class) {
                    System.err.println("Failed to build rupture for " + r + ", trying again with debug enabled");
                    System.err.flush();
                    System.out.flush();
                    ClusterRupCalc calc = new ClusterRupCalc(search, r, maintainOrder, true);
                    Exception secondary = null;
                    ClusterRupture ret = null;
                    try {
                        ret = calc.call();
                    }
                    catch (Exception e1) {
                        secondary = e1;
                    }
                    if (secondary == null) {
                        System.err.println("Weird: didn't get an exception on retry with debug=true");
                    }
                    if (ret != null) {
                        System.err.println("Weird: got this rupture on retry with debug=true: " + String.valueOf(ret));
                    }
                    System.err.flush();
                    System.out.flush();
                    // ** MonitorExit[var10_11] (shouldn't be in output)
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }
        System.out.println("Built " + ruptures.size() + " ruptures");
        exec.shutdown();
        return new Precomputed(rupSet, ruptures);
    }

    public static ClusterRuptures instance(FaultSystemRupSet rupSet, List<ClusterRupture> clusterRuptures) {
        return ClusterRuptures.instance(rupSet, clusterRuptures, false);
    }

    public static ClusterRuptures instance(FaultSystemRupSet rupSet, List<ClusterRupture> clusterRuptures, boolean forceSerialization) {
        if (!forceSerialization) {
            boolean singleStrand = true;
            for (ClusterRupture rup : clusterRuptures) {
                if (rup.singleStrand) continue;
                singleStrand = false;
                break;
            }
            if (singleStrand) {
                return new SingleStranded(rupSet, clusterRuptures);
            }
        }
        return new Precomputed(rupSet, clusterRuptures);
    }

    public static ClusterRuptures singleStranged(FaultSystemRupSet rupSet) {
        return new SingleStranded(rupSet, null);
    }

    @Override
    public boolean isIdentical(ClusterRuptures module) {
        return this.rupSet.isEquivalentTo(module.rupSet);
    }

    public static class SingleStranded
    extends ClusterRuptures
    implements ArchivableModule {
        private List<ClusterRupture> clusterRuptures;

        public SingleStranded() {
            this(null, null);
        }

        public SingleStranded(FaultSystemRupSet rupSet, List<ClusterRupture> clusterRuptures) {
            super(rupSet);
            if (clusterRuptures != null) {
                Preconditions.checkNotNull((Object)rupSet);
            }
            this.clusterRuptures = clusterRuptures;
        }

        @Override
        public String getName() {
            return "Single-Strand Cluster Ruptures";
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ClusterRupture> getAll() {
            Preconditions.checkNotNull((Object)this.rupSet, (Object)"Not initialized with a rupture set");
            if (this.clusterRuptures == null) {
                SingleStranded singleStranded = this;
                synchronized (singleStranded) {
                    if (this.clusterRuptures == null) {
                        int numCached;
                        SectionDistanceAzimuthCalculator distAzCalc = null;
                        PlausibilityConfiguration plausibility = this.rupSet.getModule(PlausibilityConfiguration.class, false);
                        if (plausibility != null) {
                            distAzCalc = plausibility.getDistAzCalc();
                        }
                        if (this.rupSet.hasModule(SectionDistanceAzimuthCalculator.class)) {
                            SectionDistanceAzimuthCalculator distAzCalc2 = this.rupSet.requireModule(SectionDistanceAzimuthCalculator.class);
                            if (distAzCalc == null || distAzCalc2.getNumCachedDistances() > distAzCalc.getNumCachedDistances()) {
                                distAzCalc = distAzCalc2;
                            }
                        }
                        if (distAzCalc == null) {
                            distAzCalc = new SectionDistanceAzimuthCalculator(this.rupSet.getFaultSectionDataList());
                            this.rupSet.addModule(distAzCalc);
                        }
                        if ((numCached = distAzCalc.getNumCachedDistances()) > 0) {
                            System.out.println("Building single-stranded ClusterRupture representations and with " + numCached + " already-cached distances");
                        } else {
                            System.out.println("Building single-stranded ClusterRupture representations and calculating necessary distances");
                        }
                        Stopwatch watch = Stopwatch.createStarted();
                        int threads = FaultSysTools.defaultNumThreads();
                        if (numCached == 0 && threads > 1 && !this.rupSet.hasModule(RuptureSubSetMappings.class) && this.rupSet.getNumSections() > 100) {
                            HashSet<IDPairing> directJumps = new HashSet<IDPairing>();
                            List<? extends FaultSection> sects = this.rupSet.getFaultSectionDataList();
                            Map<Integer, List<FaultSection>> parentsToSectsMap = sects.stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
                            ExecutorService exec = Executors.newFixedThreadPool(threads);
                            for (List<Integer> rup : this.rupSet.getSectionIndicesForAllRups()) {
                                int prevParentID = -1;
                                for (int sectIndex : rup) {
                                    int parentID = sects.get(sectIndex).getParentSectionId();
                                    if (prevParentID >= 0 && parentID != prevParentID) {
                                        IDPairing parentPair;
                                        IDPairing iDPairing = parentPair = parentID > prevParentID ? new IDPairing(prevParentID, parentID) : new IDPairing(parentID, prevParentID);
                                        if (!directJumps.contains(parentPair)) {
                                            directJumps.add(parentPair);
                                            exec.submit(new ParentSectsDistCacheRunnable(parentsToSectsMap.get(parentID), parentsToSectsMap.get(prevParentID), distAzCalc));
                                        }
                                    }
                                    prevParentID = parentID;
                                }
                            }
                            System.out.println("Pre-caching distances for " + directJumps.size() + " parent-to-parent jumps with " + threads + " threads");
                            exec.shutdown();
                        }
                        ArrayList<ClusterRupture> rups = new ArrayList<ClusterRupture>(this.rupSet.getNumRuptures());
                        for (int r = 0; r < this.rupSet.getNumRuptures(); ++r) {
                            rups.add(ClusterRupture.forOrderedSingleStrandRupture(this.rupSet.getFaultSectionDataForRupture(r), distAzCalc));
                        }
                        watch.stop();
                        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                        System.out.println("Took " + (float)secs + " secs to build " + rups.size() + " ClusterRupture representations");
                        this.clusterRuptures = rups;
                    }
                }
            }
            return this.clusterRuptures;
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) {
            if (this.clusterRuptures != null && newParent.isEquivalentTo(this.rupSet)) {
                return new SingleStranded(newParent, this.clusterRuptures);
            }
            return new SingleStranded(newParent, null);
        }

        @Override
        public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
            if (this.clusterRuptures != null) {
                Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(parent));
            }
            this.rupSet = parent;
        }

        @Override
        public SingleStranded getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            return new SingleStranded(rupSubSet, null);
        }

        @Override
        public ClusterRuptures getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            return new SingleStranded(splitRupSet, null);
        }
    }

    private static class ClusterRupCalc
    implements Callable<ClusterRupture> {
        private RuptureConnectionSearch search;
        private int rupIndex;
        private boolean debug;
        private boolean maintainOrder;

        public ClusterRupCalc(RuptureConnectionSearch search, int rupIndex, boolean maintainOrder) {
            this(search, rupIndex, maintainOrder, false);
        }

        public ClusterRupCalc(RuptureConnectionSearch search, int rupIndex, boolean maintainOrder, boolean debug) {
            this.search = search;
            this.rupIndex = rupIndex;
            this.maintainOrder = maintainOrder;
            this.debug = debug;
        }

        @Override
        public ClusterRupture call() throws Exception {
            ClusterRupture rupture = this.search.buildClusterRupture(this.rupIndex, this.maintainOrder, this.debug);
            int numSplays = rupture.getTotalNumSplays();
            if (numSplays > 0) {
                double mainStrandLen = 0.0;
                for (FaultSubsectionCluster cluster : rupture.clusters) {
                    for (FaultSection sect : cluster.subSects) {
                        mainStrandLen += sect.getTraceLength();
                    }
                }
                for (ClusterRupture alternative : rupture.getPreferredAltRepresentations(this.search)) {
                    int altNumSplays = alternative.getTotalNumSplays();
                    double altStrandLen = 0.0;
                    for (FaultSubsectionCluster cluster : alternative.clusters) {
                        for (FaultSection sect : cluster.subSects) {
                            altStrandLen += sect.getTraceLength();
                        }
                    }
                    if (altNumSplays >= numSplays && (altNumSplays != numSplays || !(altStrandLen > mainStrandLen))) continue;
                    rupture = alternative;
                    numSplays = altNumSplays;
                    break;
                }
            }
            return rupture;
        }
    }

    private static class Precomputed
    extends ClusterRuptures
    implements JSON_BackedModule {
        private List<ClusterRupture> clusterRuptures;

        public Precomputed() {
            super(null);
        }

        public Precomputed(FaultSystemRupSet rupSet, List<ClusterRupture> clusterRuptures) {
            super(rupSet);
            Preconditions.checkState((clusterRuptures.size() == rupSet.getNumRuptures() ? 1 : 0) != 0);
            this.clusterRuptures = clusterRuptures;
        }

        @Override
        public String getName() {
            return "Precomputed Cluster Ruptures";
        }

        @Override
        public String getFileName() {
            return "cluster_ruptures.json";
        }

        @Override
        public Gson buildGson() {
            return ClusterRupture.buildGson(this.rupSet.getFaultSectionDataList(), false);
        }

        @Override
        public void writeToJSON(JsonWriter out, Gson gson) throws IOException {
            Type listType = new TypeToken<List<ClusterRupture>>(){}.getType();
            gson.toJson(this.clusterRuptures, listType, out);
        }

        @Override
        public void initFromJSON(JsonReader in, Gson gson) throws IOException {
            Type listType = new TypeToken<List<ClusterRupture>>(){}.getType();
            List ruptures = (List)gson.fromJson(in, listType);
            Preconditions.checkState((ruptures.size() == this.rupSet.getNumRuptures() ? 1 : 0) != 0);
            this.clusterRuptures = ruptures;
        }

        @Override
        public List<ClusterRupture> getAll() {
            return this.clusterRuptures;
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(newParent));
            return new Precomputed(newParent, this.clusterRuptures);
        }

        @Override
        public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
            if (this.clusterRuptures != null) {
                Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(parent));
            }
            this.rupSet = parent;
        }

        @Override
        public AverageableModule.AveragingAccumulator<ClusterRuptures> averagingAccumulator() {
            return null;
        }

        @Override
        public ClusterRuptures getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            throw new UnsupportedOperationException("Not yet supported");
        }

        @Override
        public ClusterRuptures getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            throw new UnsupportedOperationException("Not yet supported");
        }
    }

    private static class ParentSectsDistCacheRunnable
    implements Runnable {
        private final List<FaultSection> sects1;
        private final List<FaultSection> sects2;
        private final SectionDistanceAzimuthCalculator distAzCalc;

        public ParentSectsDistCacheRunnable(List<FaultSection> sects1, List<FaultSection> sects2, SectionDistanceAzimuthCalculator distAzCalc) {
            this.sects1 = sects1;
            this.sects2 = sects2;
            this.distAzCalc = distAzCalc;
        }

        @Override
        public void run() {
            for (FaultSection s1 : this.sects1) {
                for (FaultSection s2 : this.sects2) {
                    this.distAzCalc.getDistance(s1, s2);
                }
            }
        }
    }
}

