/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.CSVReader;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.geo.CubedGriddedRegion;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.commons.util.modules.helpers.LargeCSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;

public interface FaultCubeAssociations
extends FaultGridAssociations {
    public static final String ARCHIVE_CUBE_ASSOC_FILE_NAME = "cube_association_weights.csv";
    public static final String ARCHIVE_CUBE_SECT_ASSOC_SUM_FILE_NAME = "cube_sect_association_sums.csv";

    public CubedGriddedRegion getCubedGriddedRegion();

    public int getNumCubes();

    public int[] getSectsAtCube(int var1);

    public double[] getScaledSectDistWeightsAtCube(int var1);

    public double getTotalScaledDistWtAtCubesForSect(int var1);

    public double[] getOrigSectDistWeightsAtCube(int var1);

    public double getTotalOrigDistWtAtCubesForSect(int var1);

    @Override
    default public AverageableModule.AveragingAccumulator<FaultGridAssociations> averagingAccumulator() {
        return new CubeIfPossibleAverager();
    }

    public static StitchedFaultCubeAssociations stitch(CubedGriddedRegion cgr, List<? extends FaultCubeAssociations> regionalAssociations) {
        return new StitchedFaultCubeAssociations(cgr, regionalAssociations);
    }

    public static class CubeIfPossibleAverager
    implements AverageableModule.AveragingAccumulator<FaultGridAssociations> {
        private FaultGridAssociations.Averager gridAverager;
        private CubeAverager cubeAverager;

        @Override
        public Class<FaultGridAssociations> getType() {
            return FaultGridAssociations.class;
        }

        @Override
        public void process(FaultGridAssociations module, double relWeight) {
            FaultCubeAssociations cubeModule;
            FaultCubeAssociations faultCubeAssociations = cubeModule = module instanceof FaultCubeAssociations ? (FaultCubeAssociations)module : null;
            if (this.gridAverager == null) {
                if (cubeModule != null) {
                    this.cubeAverager = new CubeAverager();
                    this.gridAverager = this.cubeAverager.gridAverager;
                } else {
                    this.gridAverager = new FaultGridAssociations.Averager();
                }
            }
            if (this.cubeAverager != null && cubeModule != null) {
                this.cubeAverager.process(cubeModule, relWeight);
            } else {
                this.cubeAverager = null;
                this.gridAverager.process(module, relWeight);
            }
        }

        @Override
        public FaultGridAssociations getAverage() {
            if (this.cubeAverager != null) {
                return this.cubeAverager.getAverage();
            }
            return this.gridAverager.getAverage();
        }
    }

    public static class StitchedFaultCubeAssociations
    implements FaultCubeAssociations {
        private CubedGriddedRegion cgr;
        private List<? extends FaultCubeAssociations> regionalAssociations;
        private int[][] sectsAtCubes;
        private double[][] sectOrigDistWeightsAtCubes;
        private double[][] sectScaledDistWeightsAtCubes;
        private double[] totScaledDistWtsAtCubesForSectArrays;
        private double[] totOrigDistWtsAtCubesForSectArrays;
        private double[] fractSectsInRegions;
        private CubeToGridNodeAggregator cubeGridAggregator;

        /*
         * WARNING - void declaration
         */
        private StitchedFaultCubeAssociations(CubedGriddedRegion cgr, List<? extends FaultCubeAssociations> regionalAssociations) {
            this.cgr = cgr;
            this.regionalAssociations = regionalAssociations;
            this.sectsAtCubes = new int[cgr.getNumCubes()][];
            this.sectOrigDistWeightsAtCubes = new double[this.sectsAtCubes.length][];
            this.sectScaledDistWeightsAtCubes = new double[this.sectsAtCubes.length][];
            GriddedRegion griddedRegion = cgr.getGriddedRegion();
            int maxSectIndex = -1;
            int numMapped = 0;
            int nodeCount = griddedRegion.getNodeCount();
            for (int gridIndex = 0; gridIndex < nodeCount; ++gridIndex) {
                int[] nArray;
                void var9_9;
                Location loc = griddedRegion.locationForIndex(gridIndex);
                Object var9_10 = null;
                int matchIndex = -1;
                for (FaultCubeAssociations faultCubeAssociations : regionalAssociations) {
                    int myIndex = faultCubeAssociations.getRegion().indexForLocation(loc);
                    if (myIndex < 0) continue;
                    Preconditions.checkState((var9_9 == null ? 1 : 0) != 0, (Object)"TODO: don't yet support grid locations that map to multiple sub-regions");
                    FaultCubeAssociations faultCubeAssociations2 = faultCubeAssociations;
                    matchIndex = myIndex;
                }
                if (var9_9 == null) continue;
                ++numMapped;
                int[] newCubeIndexes = cgr.getCubeIndicesForGridCell(gridIndex);
                Preconditions.checkState((newCubeIndexes.length == (nArray = var9_9.getCubedGriddedRegion().getCubeIndicesForGridCell(matchIndex)).length ? 1 : 0) != 0);
                for (int i = 0; i < nArray.length; ++i) {
                    this.sectsAtCubes[newCubeIndexes[i]] = var9_9.getSectsAtCube(nArray[i]);
                    if (this.sectsAtCubes[newCubeIndexes[i]] != null) {
                        for (int sectIndex : this.sectsAtCubes[newCubeIndexes[i]]) {
                            maxSectIndex = Integer.max(sectIndex, maxSectIndex);
                        }
                    }
                    this.sectOrigDistWeightsAtCubes[newCubeIndexes[i]] = var9_9.getOrigSectDistWeightsAtCube(nArray[i]);
                    this.sectScaledDistWeightsAtCubes[newCubeIndexes[i]] = var9_9.getScaledSectDistWeightsAtCube(nArray[i]);
                }
            }
            System.out.println("Mapped " + numMapped + "/" + nodeCount + " model region fault associations locations to sub-region grid locations");
            int numSects = maxSectIndex + 1;
            this.totScaledDistWtsAtCubesForSectArrays = new double[numSects];
            this.totOrigDistWtsAtCubesForSectArrays = new double[numSects];
            this.fractSectsInRegions = new double[numSects];
            for (FaultCubeAssociations faultCubeAssociations : regionalAssociations) {
                for (int s = 0; s < this.totScaledDistWtsAtCubesForSectArrays.length; ++s) {
                    int n = s;
                    this.totScaledDistWtsAtCubesForSectArrays[n] = this.totScaledDistWtsAtCubesForSectArrays[n] + faultCubeAssociations.getTotalScaledDistWtAtCubesForSect(s);
                    int n2 = s;
                    this.totOrigDistWtsAtCubesForSectArrays[n2] = this.totOrigDistWtsAtCubesForSectArrays[n2] + faultCubeAssociations.getTotalOrigDistWtAtCubesForSect(s);
                    int n3 = s;
                    this.fractSectsInRegions[n3] = this.fractSectsInRegions[n3] + faultCubeAssociations.getSectionFractInRegion(s);
                }
            }
            this.cubeGridAggregator = new CubeToGridNodeAggregator(this);
        }

        @Override
        public Map<Integer, Double> getNodeExtents() {
            return this.cubeGridAggregator.getNodeExtents();
        }

        @Override
        public double getNodeFraction(int nodeIdx) {
            return this.cubeGridAggregator.getNodeFraction(nodeIdx);
        }

        @Override
        public Map<Integer, Double> getScaledNodeFractions(int sectIdx) {
            return this.cubeGridAggregator.getScaledNodeFractions(sectIdx);
        }

        @Override
        public Map<Integer, Double> getScaledSectFracsOnNode(int nodeIdx) {
            return this.cubeGridAggregator.getScaledSectFracsOnNode(nodeIdx);
        }

        @Override
        public Map<Integer, Double> getNodeFractions(int sectIdx) {
            return this.cubeGridAggregator.getNodeFractions(sectIdx);
        }

        @Override
        public Map<Integer, Double> getSectionFracsOnNode(int nodeIdx) {
            return this.cubeGridAggregator.getSectionFracsOnNode(nodeIdx);
        }

        @Override
        public GriddedRegion getRegion() {
            return this.cubeGridAggregator.getRegion();
        }

        @Override
        public Collection<Integer> sectIndices() {
            return this.cubeGridAggregator.sectIndices();
        }

        @Override
        public String getName() {
            return "Stitched Fault Cube Associations (" + this.regionalAssociations.size() + " regions)";
        }

        @Override
        public CubedGriddedRegion getCubedGriddedRegion() {
            return this.cgr;
        }

        @Override
        public int[] getSectsAtCube(int cubeIndex) {
            return this.sectsAtCubes[cubeIndex];
        }

        @Override
        public double[] getScaledSectDistWeightsAtCube(int cubeIndex) {
            return this.sectScaledDistWeightsAtCubes[cubeIndex];
        }

        @Override
        public double getTotalScaledDistWtAtCubesForSect(int sectIndex) {
            return this.totScaledDistWtsAtCubesForSectArrays[sectIndex];
        }

        @Override
        public double[] getOrigSectDistWeightsAtCube(int cubeIndex) {
            return this.sectOrigDistWeightsAtCubes[cubeIndex];
        }

        @Override
        public double getTotalOrigDistWtAtCubesForSect(int sectIndex) {
            return this.totOrigDistWtsAtCubesForSectArrays[sectIndex];
        }

        @Override
        public double getSectionFractInRegion(int sectIndex) {
            return this.fractSectsInRegions[sectIndex];
        }

        public List<? extends FaultCubeAssociations> getRegionalAssociations() {
            return this.regionalAssociations;
        }

        @Override
        public int getNumCubes() {
            return this.cgr.getNumCubes();
        }
    }

    public static class CubeAverager
    implements AverageableModule.AveragingAccumulator<FaultCubeAssociations> {
        private FaultGridAssociations.Averager gridAverager = new FaultGridAssociations.Averager();
        private double sumWeight = 0.0;
        private CubedGriddedRegion cgr;
        private int[][] sectsAtCubes;
        private double[][] sectOrigDistWeightsAtCubes;
        private double[][] sectScaledDistWeightsAtCubes;
        private double[] totOrigDistWtsAtCubesForSectArray;
        private double[] totScaledDistWtsAtCubesForSectArray;
        private int maxSectIndex = 0;

        @Override
        public Class<FaultCubeAssociations> getType() {
            return FaultCubeAssociations.class;
        }

        @Override
        public void process(FaultCubeAssociations module, double relWeight) {
            if (this.cgr == null) {
                this.cgr = module.getCubedGriddedRegion();
            } else {
                Preconditions.checkState((module.getNumCubes() == this.cgr.getNumCubes() ? 1 : 0) != 0);
            }
            this.gridAverager.process(module, relWeight);
            if (this.sectsAtCubes == null) {
                this.sectsAtCubes = new int[this.cgr.getNumCubes()][];
                this.sectOrigDistWeightsAtCubes = new double[this.sectsAtCubes.length][];
                this.sectScaledDistWeightsAtCubes = new double[this.sectsAtCubes.length][];
                for (int c = 0; c < this.sectsAtCubes.length; ++c) {
                    int[] sects = module.getSectsAtCube(c);
                    if (sects == null) continue;
                    this.sectsAtCubes[c] = sects;
                    this.sectOrigDistWeightsAtCubes[c] = Arrays.copyOf(module.getOrigSectDistWeightsAtCube(c), sects.length);
                    this.sectScaledDistWeightsAtCubes[c] = Arrays.copyOf(module.getScaledSectDistWeightsAtCube(c), sects.length);
                    for (int s = 0; s < sects.length; ++s) {
                        double[] dArray = this.sectOrigDistWeightsAtCubes[c];
                        int n = s;
                        dArray[n] = dArray[n] * relWeight;
                        double[] dArray2 = this.sectScaledDistWeightsAtCubes[c];
                        int n2 = s;
                        dArray2[n2] = dArray2[n2] * relWeight;
                        this.maxSectIndex = Integer.max(this.maxSectIndex, sects[s]);
                    }
                }
                this.totOrigDistWtsAtCubesForSectArray = new double[this.maxSectIndex + 1];
                this.totScaledDistWtsAtCubesForSectArray = new double[this.maxSectIndex + 1];
                for (int s = 0; s < this.maxSectIndex + 1; ++s) {
                    this.totOrigDistWtsAtCubesForSectArray[s] = module.getTotalOrigDistWtAtCubesForSect(s) * relWeight;
                    this.totScaledDistWtsAtCubesForSectArray[s] = module.getTotalScaledDistWtAtCubesForSect(s) * relWeight;
                }
            } else {
                for (int c = 0; c < this.sectsAtCubes.length; ++c) {
                    int[] sects = module.getSectsAtCube(c);
                    if (sects == null) continue;
                    if (this.sectsAtCubes[c] == null) {
                        this.sectOrigDistWeightsAtCubes[c] = Arrays.copyOf(module.getOrigSectDistWeightsAtCube(c), sects.length);
                        this.sectScaledDistWeightsAtCubes[c] = Arrays.copyOf(module.getScaledSectDistWeightsAtCube(c), sects.length);
                        for (int s = 0; s < sects.length; ++s) {
                            double[] dArray = this.sectOrigDistWeightsAtCubes[c];
                            int n = s;
                            dArray[n] = dArray[n] * relWeight;
                            double[] dArray3 = this.sectScaledDistWeightsAtCubes[c];
                            int n3 = s;
                            dArray3[n3] = dArray3[n3] * relWeight;
                            this.maxSectIndex = Integer.max(this.maxSectIndex, sects[s]);
                        }
                        continue;
                    }
                    double[] moduleOrigWeights = module.getOrigSectDistWeightsAtCube(c);
                    double[] moduleScaledWeights = module.getScaledSectDistWeightsAtCube(c);
                    for (int s = 0; s < sects.length; ++s) {
                        int matchIndex;
                        int sectIndex = sects[s];
                        this.maxSectIndex = Integer.max(this.maxSectIndex, sectIndex);
                        if (s < this.sectsAtCubes[c].length && this.sectsAtCubes[c][s] == sectIndex) {
                            matchIndex = s;
                        } else {
                            matchIndex = -1;
                            for (int s1 = 0; s1 < this.sectsAtCubes[c].length; ++s1) {
                                if (this.sectsAtCubes[c][s1] != sectIndex) continue;
                                matchIndex = s1;
                                break;
                            }
                            if (matchIndex < 0) {
                                matchIndex = this.sectsAtCubes[c].length;
                                this.sectsAtCubes[c] = Arrays.copyOf(this.sectsAtCubes[c], matchIndex + 1);
                                this.sectsAtCubes[c][matchIndex] = sectIndex;
                                this.sectOrigDistWeightsAtCubes[c] = Arrays.copyOf(this.sectOrigDistWeightsAtCubes[c], matchIndex + 1);
                                this.sectScaledDistWeightsAtCubes[c] = Arrays.copyOf(this.sectScaledDistWeightsAtCubes[c], matchIndex + 1);
                            }
                        }
                        double[] dArray = this.sectOrigDistWeightsAtCubes[c];
                        int n = matchIndex;
                        dArray[n] = dArray[n] + moduleOrigWeights[s] * relWeight;
                        double[] dArray4 = this.sectScaledDistWeightsAtCubes[c];
                        int n4 = matchIndex;
                        dArray4[n4] = dArray4[n4] + moduleScaledWeights[s] * relWeight;
                    }
                }
                if (this.totOrigDistWtsAtCubesForSectArray.length < this.maxSectIndex + 1) {
                    this.totOrigDistWtsAtCubesForSectArray = Arrays.copyOf(this.totOrigDistWtsAtCubesForSectArray, this.maxSectIndex + 1);
                    this.totScaledDistWtsAtCubesForSectArray = Arrays.copyOf(this.totScaledDistWtsAtCubesForSectArray, this.maxSectIndex + 1);
                }
                for (int s = 0; s < this.maxSectIndex + 1; ++s) {
                    int n = s;
                    this.totOrigDistWtsAtCubesForSectArray[n] = this.totOrigDistWtsAtCubesForSectArray[n] + module.getTotalOrigDistWtAtCubesForSect(s) * relWeight;
                    int n5 = s;
                    this.totScaledDistWtsAtCubesForSectArray[n5] = this.totScaledDistWtsAtCubesForSectArray[n5] + module.getTotalScaledDistWtAtCubesForSect(s) * relWeight;
                }
            }
            this.sumWeight += relWeight;
        }

        @Override
        public FaultCubeAssociations getAverage() {
            FaultGridAssociations.Precomputed gridAssoc = this.gridAverager.getAverage();
            for (int c = 0; c < this.sectsAtCubes.length; ++c) {
                if (this.sectsAtCubes[c] == null) continue;
                boolean scaledEqual = true;
                int s = 0;
                while (s < this.sectsAtCubes[c].length) {
                    scaledEqual &= this.sectOrigDistWeightsAtCubes[c][s] == this.sectScaledDistWeightsAtCubes[c][s];
                    double[] dArray = this.sectOrigDistWeightsAtCubes[c];
                    int n = s;
                    dArray[n] = dArray[n] / this.sumWeight;
                    double[] dArray2 = this.sectScaledDistWeightsAtCubes[c];
                    int n2 = s++;
                    dArray2[n2] = dArray2[n2] / this.sumWeight;
                }
                if (!scaledEqual) continue;
                this.sectScaledDistWeightsAtCubes[c] = this.sectOrigDistWeightsAtCubes[c];
            }
            int i = 0;
            while (i < this.totOrigDistWtsAtCubesForSectArray.length) {
                int n = i;
                this.totOrigDistWtsAtCubesForSectArray[n] = this.totOrigDistWtsAtCubesForSectArray[n] / this.sumWeight;
                int n3 = i++;
                this.totScaledDistWtsAtCubesForSectArray[n3] = this.totScaledDistWtsAtCubesForSectArray[n3] / this.sumWeight;
            }
            return new Precomputed(gridAssoc, this.cgr, this.sectsAtCubes, this.sectOrigDistWeightsAtCubes, this.sectScaledDistWeightsAtCubes, this.totOrigDistWtsAtCubesForSectArray, this.totScaledDistWtsAtCubesForSectArray);
        }
    }

    public static class CubeToGridNodeAggregator
    implements FaultGridAssociations {
        private FaultCubeAssociations cubeAssoc;
        private ImmutableSet<Integer> sectIndices;
        private ImmutableMap<Integer, Double> nodeExtents;
        private ImmutableTable<Integer, Integer, Double> nodeInSectPartic;
        private ImmutableTable<Integer, Integer, Double> sectInNodePartic;

        public CubeToGridNodeAggregator(FaultCubeAssociations cubeAssoc) {
            this.cubeAssoc = cubeAssoc;
            this.aggregateToGridNodes();
        }

        private void aggregateToGridNodes() {
            HashSet<Integer> sectIndices = new HashSet<Integer>();
            ImmutableMap.Builder nodeExtentsBuilder = ImmutableMap.builder();
            ImmutableTable.Builder nodeInSectParticBuilder = ImmutableTable.builder();
            ImmutableTable.Builder sectInNodeParticBuilder = ImmutableTable.builder();
            CubedGriddedRegion cgr = this.cubeAssoc.getCubedGriddedRegion();
            GriddedRegion griddedRegion = cgr.getGriddedRegion();
            for (int nodeIndex = 0; nodeIndex < griddedRegion.getNodeCount(); ++nodeIndex) {
                int numCubes = 0;
                HashMap<Integer, Double> sectFracts = null;
                HashMap<Integer, Double> sectOrigFracts = null;
                for (int cubeIndex : cgr.getCubeIndicesForGridCell(nodeIndex)) {
                    ++numCubes;
                    int[] sects = this.cubeAssoc.getSectsAtCube(cubeIndex);
                    if (sects == null) continue;
                    if (sectFracts == null) {
                        sectFracts = new HashMap<Integer, Double>();
                        sectOrigFracts = new HashMap<Integer, Double>();
                    }
                    double[] sectDistWts = this.cubeAssoc.getScaledSectDistWeightsAtCube(cubeIndex);
                    double[] sectOrigDistWts = this.cubeAssoc.getOrigSectDistWeightsAtCube(cubeIndex);
                    for (int s = 0; s < sects.length; ++s) {
                        sectIndices.add(sects[s]);
                        Double prevWt = (Double)sectFracts.get(sects[s]);
                        Double prevOrigWt = (Double)sectOrigFracts.get(sects[s]);
                        if (prevWt == null) {
                            prevWt = 0.0;
                            prevOrigWt = 0.0;
                        }
                        Preconditions.checkState((sectDistWts[s] >= 0.0 && sectDistWts[s] <= 1.0 ? 1 : 0) != 0, (String)"Bad sectWeight for cube %s, sect %s: %s", (Object)cubeIndex, (Object)sects[s], (Object)sectDistWts[s]);
                        sectFracts.put(sects[s], prevWt + sectDistWts[s]);
                        Preconditions.checkState((sectOrigDistWts[s] >= 0.0 && sectOrigDistWts[s] <= 1.0 ? 1 : 0) != 0, (String)"Bad origWeight for cube %s, sect %s: %s", (Object)cubeIndex, (Object)sects[s], (Object)sectOrigDistWts[s]);
                        sectOrigFracts.put(sects[s], prevOrigWt + sectOrigDistWts[s]);
                    }
                }
                if (sectFracts == null) continue;
                double sumNodeWeight = 0.0;
                for (Integer sectIndex : sectFracts.keySet()) {
                    double sectWeight = (Double)sectFracts.get(sectIndex) / (double)numCubes;
                    Preconditions.checkState(((float)sectWeight <= 1.0f && (float)sectWeight >= 0.0f ? 1 : 0) != 0, (String)"Bad aggregated sectWeight for node %s, sect %s: %s", (Object)nodeIndex, (Object)sectIndex, (Object)sectWeight);
                    sumNodeWeight += sectWeight;
                    sectInNodeParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)sectWeight);
                    double origWeight = (Double)sectOrigFracts.get(sectIndex) / this.cubeAssoc.getTotalOrigDistWtAtCubesForSect(sectIndex);
                    Preconditions.checkState(((float)origWeight <= 1.0f && (float)origWeight >= 0.0f ? 1 : 0) != 0, (String)"Bad aggregated origWeight for node %s, sect %s: %s", (Object)nodeIndex, (Object)sectIndex, (Object)origWeight);
                    nodeInSectParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)origWeight);
                }
                nodeExtentsBuilder.put((Object)nodeIndex, (Object)sumNodeWeight);
            }
            this.sectIndices = ImmutableSet.copyOf(sectIndices);
            this.nodeExtents = nodeExtentsBuilder.build();
            this.nodeInSectPartic = nodeInSectParticBuilder.build();
            this.sectInNodePartic = sectInNodeParticBuilder.build();
        }

        @Override
        public String getName() {
            return this.cubeAssoc.getName();
        }

        @Override
        public Map<Integer, Double> getNodeExtents() {
            return ImmutableMap.copyOf(this.nodeExtents);
        }

        @Override
        public double getNodeFraction(int nodeIdx) {
            Double fraction = (Double)this.nodeExtents.get((Object)nodeIdx);
            return fraction == null ? 0.0 : fraction;
        }

        @Override
        public Map<Integer, Double> getScaledNodeFractions(int sectIdx) {
            return this.sectInNodePartic.row((Object)sectIdx);
        }

        @Override
        public Map<Integer, Double> getScaledSectFracsOnNode(int nodeIdx) {
            return this.sectInNodePartic.column((Object)nodeIdx);
        }

        @Override
        public Map<Integer, Double> getNodeFractions(int sectIdx) {
            return this.nodeInSectPartic.row((Object)sectIdx);
        }

        @Override
        public Map<Integer, Double> getSectionFracsOnNode(int nodeIdx) {
            return this.nodeInSectPartic.column((Object)nodeIdx);
        }

        @Override
        public GriddedRegion getRegion() {
            return this.cubeAssoc.getCubedGriddedRegion().getGriddedRegion();
        }

        @Override
        public Collection<Integer> sectIndices() {
            return this.sectIndices;
        }
    }

    public static class Precomputed
    extends FaultGridAssociations.Precomputed
    implements FaultCubeAssociations {
        private CubedGriddedRegion cgr;
        private ArchiveInput sourceInput;
        private String sourceZipEntryPrefix;
        private int[][] sectsAtCubes;
        private double[][] sectOrigDistWeightsAtCubes;
        private double[][] sectScaledDistWeightsAtCubes;
        private double[] totOrigDistWtsAtCubesForSectArray;
        private double[] totScaledDistWtsAtCubesForSectArray;

        protected Precomputed() {
        }

        public Precomputed(FaultCubeAssociations associations) {
            super(associations);
            this.cgr = associations.getCubedGriddedRegion();
            this.regionFeature = this.cgr.toFeature();
            this.sectsAtCubes = new int[this.getCubedGriddedRegion().getNumCubes()][];
            this.sectOrigDistWeightsAtCubes = new double[this.sectsAtCubes.length][];
            this.sectScaledDistWeightsAtCubes = new double[this.sectsAtCubes.length][];
            int maxSectIndex = 0;
            for (int c = 0; c < this.sectsAtCubes.length; ++c) {
                this.sectsAtCubes[c] = associations.getSectsAtCube(c);
                if (this.sectsAtCubes[c] == null) continue;
                this.sectOrigDistWeightsAtCubes[c] = associations.getOrigSectDistWeightsAtCube(c);
                this.sectScaledDistWeightsAtCubes[c] = associations.getScaledSectDistWeightsAtCube(c);
                for (int sectIndex : this.sectsAtCubes[c]) {
                    maxSectIndex = Integer.max(maxSectIndex, sectIndex);
                }
            }
            this.totOrigDistWtsAtCubesForSectArray = new double[maxSectIndex + 1];
            this.totScaledDistWtsAtCubesForSectArray = new double[maxSectIndex + 1];
            for (int s = 0; s < this.totOrigDistWtsAtCubesForSectArray.length; ++s) {
                this.totOrigDistWtsAtCubesForSectArray[s] = associations.getTotalOrigDistWtAtCubesForSect(s);
                this.totScaledDistWtsAtCubesForSectArray[s] = associations.getTotalScaledDistWtAtCubesForSect(s);
            }
        }

        private Precomputed(FaultGridAssociations gridAssociations, CubedGriddedRegion cgr, int[][] sectsAtCubes, double[][] sectOrigDistWeightsAtCubes, double[][] sectScaledDistWeightsAtCubes, double[] totOrigDistWtsAtCubesForSectArray, double[] totScaledDistWtsAtCubesForSectArray) {
            super(gridAssociations);
            this.regionFeature = cgr.toFeature();
            this.cgr = cgr;
            this.sectsAtCubes = sectsAtCubes;
            this.sectOrigDistWeightsAtCubes = sectOrigDistWeightsAtCubes;
            this.sectScaledDistWeightsAtCubes = sectScaledDistWeightsAtCubes;
            this.totOrigDistWtsAtCubesForSectArray = totOrigDistWtsAtCubesForSectArray;
            this.totScaledDistWtsAtCubesForSectArray = totScaledDistWtsAtCubesForSectArray;
        }

        @Override
        public String getName() {
            return "Fault Cube Associations";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CubedGriddedRegion getCubedGriddedRegion() {
            if (this.cgr == null) {
                Precomputed precomputed = this;
                synchronized (precomputed) {
                    if (this.cgr == null) {
                        Preconditions.checkNotNull((Object)this.regionFeature, (Object)"Feature must already be loaded to init a cgr (can't build it from a gridded region)");
                        if (!this.regionFeature.properties.containsKey("MaxDepth")) {
                            System.err.println("WARNING: gridded region doesn't have cube params attached, assuming default");
                            if (this.region == null) {
                                this.region = GriddedRegion.fromFeature(this.regionFeature);
                            }
                            this.cgr = new CubedGriddedRegion(this.region);
                        } else if (this.region == null) {
                            this.cgr = CubedGriddedRegion.fromFeature(this.regionFeature);
                            this.region = this.cgr.getGriddedRegion();
                        } else {
                            this.cgr = CubedGriddedRegion.fromFeature(this.region, this.regionFeature);
                        }
                    }
                }
            }
            return this.cgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkLazyInit() {
            if (this.sectsAtCubes == null) {
                Precomputed precomputed = this;
                synchronized (precomputed) {
                    if (this.sectsAtCubes == null) {
                        CSVFile<String> sectCSV;
                        CSVReader.Row row;
                        CSVReader csv;
                        System.out.println("Lazily loading cube associations...");
                        try {
                            csv = LargeCSV_BackedModule.loadFromArchive(this.sourceInput, this.sourceZipEntryPrefix, FaultCubeAssociations.ARCHIVE_CUBE_ASSOC_FILE_NAME);
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                        int[][] sectsAtCubes = new int[this.getCubedGriddedRegion().getNumCubes()][];
                        double[][] sectOrigDistWeightsAtCubes = new double[sectsAtCubes.length][];
                        double[][] sectScaledDistWeightsAtCubes = new double[sectsAtCubes.length][];
                        int maxSectIndex = 0;
                        csv.read();
                        while ((row = csv.read()) != null) {
                            List<String> line = row.getLine();
                            int cubeIndex = Integer.parseInt(line.get(0));
                            Preconditions.checkState((cubeIndex < sectsAtCubes.length ? 1 : 0) != 0, (String)"Unexpected cubeIndex=%s with numCubes=%s", (int)cubeIndex, (int)sectsAtCubes.length);
                            int numValCols = line.size() - 1;
                            if (numValCols % 3 == 2) {
                                line = new ArrayList<String>(line);
                                line.add("");
                                ++numValCols;
                            }
                            int num = numValCols / 3;
                            Preconditions.checkState((line.size() == num * 3 + 1 ? 1 : 0) != 0, (String)"Malformed row: %s", line);
                            sectsAtCubes[cubeIndex] = new int[num];
                            sectOrigDistWeightsAtCubes[cubeIndex] = new double[num];
                            boolean sameArray = true;
                            sectScaledDistWeightsAtCubes[cubeIndex] = sectOrigDistWeightsAtCubes[cubeIndex];
                            int col = 1;
                            for (int i = 0; i < num; ++i) {
                                String scaledWeightStr;
                                sectsAtCubes[cubeIndex][i] = Integer.parseInt(line.get(col++));
                                maxSectIndex = Integer.max(maxSectIndex, sectsAtCubes[cubeIndex][i]);
                                sectOrigDistWeightsAtCubes[cubeIndex][i] = Double.parseDouble(line.get(col++));
                                if ((scaledWeightStr = line.get(col++)) == null || scaledWeightStr.isBlank()) {
                                    if (sameArray) continue;
                                    sectScaledDistWeightsAtCubes[cubeIndex][i] = sectOrigDistWeightsAtCubes[cubeIndex][i];
                                    continue;
                                }
                                double newVal = Double.parseDouble(scaledWeightStr);
                                if (sameArray) {
                                    sectScaledDistWeightsAtCubes[cubeIndex] = i == 0 ? new double[num] : Arrays.copyOf(sectOrigDistWeightsAtCubes[cubeIndex], num);
                                    sameArray = false;
                                }
                                sectScaledDistWeightsAtCubes[cubeIndex][i] = newVal;
                            }
                        }
                        try {
                            sectCSV = CSV_BackedModule.loadFromArchive(this.sourceInput, this.sourceZipEntryPrefix, FaultCubeAssociations.ARCHIVE_CUBE_SECT_ASSOC_SUM_FILE_NAME);
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                        int numSects = Integer.max(maxSectIndex + 1, sectCSV.getNumRows() - 1);
                        double[] totOrigDistWtsAtCubesForSectArray = new double[numSects];
                        double[] totScaledDistWtsAtCubesForSectArray = new double[numSects];
                        for (int row2 = 1; row2 < sectCSV.getNumRows(); ++row2) {
                            int sectIndex = sectCSV.getInt(row2, 0);
                            totOrigDistWtsAtCubesForSectArray[sectIndex] = sectCSV.getDouble(row2, 1);
                            totScaledDistWtsAtCubesForSectArray[sectIndex] = sectCSV.getDouble(row2, 2);
                        }
                        this.sectOrigDistWeightsAtCubes = sectOrigDistWeightsAtCubes;
                        this.sectScaledDistWeightsAtCubes = sectScaledDistWeightsAtCubes;
                        this.totOrigDistWtsAtCubesForSectArray = totOrigDistWtsAtCubesForSectArray;
                        this.totScaledDistWtsAtCubesForSectArray = totScaledDistWtsAtCubesForSectArray;
                        this.sectsAtCubes = sectsAtCubes;
                        System.out.println("DONE Lazily loading cube associations...");
                    }
                }
            }
        }

        @Override
        public int[] getSectsAtCube(int cubeIndex) {
            this.checkLazyInit();
            return this.sectsAtCubes[cubeIndex];
        }

        @Override
        public double[] getScaledSectDistWeightsAtCube(int cubeIndex) {
            this.checkLazyInit();
            return this.sectScaledDistWeightsAtCubes[cubeIndex];
        }

        @Override
        public double getTotalScaledDistWtAtCubesForSect(int sectIndex) {
            this.checkLazyInit();
            return sectIndex >= this.totScaledDistWtsAtCubesForSectArray.length ? 0.0 : this.totScaledDistWtsAtCubesForSectArray[sectIndex];
        }

        @Override
        public double[] getOrigSectDistWeightsAtCube(int cubeIndex) {
            this.checkLazyInit();
            return this.sectOrigDistWeightsAtCubes[cubeIndex];
        }

        @Override
        public double getTotalOrigDistWtAtCubesForSect(int sectIndex) {
            this.checkLazyInit();
            return sectIndex >= this.totOrigDistWtsAtCubesForSectArray.length ? 0.0 : this.totOrigDistWtsAtCubesForSectArray[sectIndex];
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
            super.writeToArchive(output, entryPrefix);
            if (this.sectsAtCubes == null) {
                Preconditions.checkNotNull((Object)this.sourceInput, (Object)"Lazily initialized but no source zip?");
                System.out.println("Copying cube association data streams directly (without loading)");
                output.transferFrom(this.sourceInput, ArchivableModule.getEntryName(entryPrefix, FaultCubeAssociations.ARCHIVE_CUBE_ASSOC_FILE_NAME));
                output.transferFrom(this.sourceInput, ArchivableModule.getEntryName(entryPrefix, FaultCubeAssociations.ARCHIVE_CUBE_SECT_ASSOC_SUM_FILE_NAME));
                return;
            }
            FileBackedModule.initEntry(output, entryPrefix, FaultCubeAssociations.ARCHIVE_CUBE_ASSOC_FILE_NAME);
            CSVWriter csvWriter = new CSVWriter(output.getOutputStream(), false);
            csvWriter.write(List.of("Cube Index", "Sect Index 1", "Original Dist Weight 1", "Scaled Dist Weight 1 (if different)", "..."));
            for (int c = 0; c < this.sectsAtCubes.length; ++c) {
                if (this.sectsAtCubes[c] == null || this.sectsAtCubes[c].length <= 0) continue;
                ArrayList<String> row = new ArrayList<String>(1 + 3 * this.sectsAtCubes[c].length);
                row.add("" + c);
                for (int i = 0; i < this.sectsAtCubes[c].length; ++i) {
                    row.add("" + this.sectsAtCubes[c][i]);
                    row.add("" + this.sectOrigDistWeightsAtCubes[c][i]);
                    if (this.sectScaledDistWeightsAtCubes[c][i] != this.sectOrigDistWeightsAtCubes[c][i]) {
                        row.add("" + this.sectScaledDistWeightsAtCubes[c][i]);
                        continue;
                    }
                    row.add("");
                }
                csvWriter.write(row);
            }
            csvWriter.flush();
            output.closeEntry();
            CSVFile<String> csv = new CSVFile<String>(false);
            csv.addLine("Sect Index", "Total Original Dist Weight", "Total Scaled Dist Weight");
            for (int s = 0; s < this.totOrigDistWtsAtCubesForSectArray.length; ++s) {
                csv.addLine("" + s, "" + this.totOrigDistWtsAtCubesForSectArray[s], "" + this.totScaledDistWtsAtCubesForSectArray[s]);
            }
            CSV_BackedModule.writeToArchive(csv, output, entryPrefix, FaultCubeAssociations.ARCHIVE_CUBE_SECT_ASSOC_SUM_FILE_NAME);
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            super.initFromArchive(input, entryPrefix);
            this.sourceInput = input;
            this.sourceZipEntryPrefix = entryPrefix;
        }

        @Override
        public int getNumCubes() {
            this.checkLazyInit();
            return this.sectsAtCubes.length;
        }
    }
}

