/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;

public class InversionMisfitStats
implements CSV_BackedModule,
BranchAverageableModule<InversionMisfitStats> {
    public static final List<String> csvHeader = List.of("Constraint Name", "Short Name", "Weight", "Weight Type", "Inequality", "Rows", "Mean", "Mean Absolute", "Median", "Minimum", "Maximum", "L2 Norm", "Energy", "Standard Deviation", "Root Mean Squared Error");
    private List<MisfitStats> misfitStats;
    public static final String MISFIT_STATS_FILE_NAME = "inversion_misfit_stats.csv";

    public InversionMisfitStats(List<MisfitStats> misfitStats) {
        this.misfitStats = misfitStats;
    }

    public static InversionMisfitStats fromCSV(CSVFile<String> csv) {
        InversionMisfitStats stats = new InversionMisfitStats();
        stats.initFromCSV(csv);
        return stats;
    }

    private InversionMisfitStats() {
    }

    public List<MisfitStats> getStats() {
        return this.misfitStats;
    }

    public MisfitStats forRange(ConstraintRange range) {
        for (MisfitStats stats : this.misfitStats) {
            if (stats.range != range && !stats.range.name.equals(range.name)) continue;
            return stats;
        }
        return null;
    }

    public MisfitStats forRangeName(String name) {
        for (MisfitStats stats : this.misfitStats) {
            if (!stats.range.name.equals(name)) continue;
            return stats;
        }
        return null;
    }

    @Override
    public String getFileName() {
        return MISFIT_STATS_FILE_NAME;
    }

    @Override
    public String getName() {
        return "Inversion Misfit Statistics";
    }

    @Override
    public CSVFile<?> getCSV() {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine(csvHeader);
        for (MisfitStats stats : this.misfitStats) {
            csv.addLine(stats.buildCSVLine());
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        this.misfitStats = new ArrayList<MisfitStats>();
        for (int row = 1; row < csv.getNumRows(); ++row) {
            this.misfitStats.add(new MisfitStats(csv.getLine(row)));
        }
    }

    @Override
    public AverageableModule.AveragingAccumulator<InversionMisfitStats> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<InversionMisfitStats>(){
            private List<List<MisfitStats>> stats = new ArrayList<List<MisfitStats>>();
            private List<Double> weights = new ArrayList<Double>();

            @Override
            public void process(InversionMisfitStats module, double relWeight) {
                this.stats.add(module.misfitStats);
                this.weights.add(relWeight);
            }

            @Override
            public InversionMisfitStats getAverage() {
                HashMap nameMatchesMap = new HashMap();
                HashMap nameWeightsMap = new HashMap();
                ArrayList<ConstraintRange> ranges = new ArrayList<ConstraintRange>();
                for (int i = 0; i < this.stats.size(); ++i) {
                    List<MisfitStats> myStats = this.stats.get(i);
                    double weight = this.weights.get(i);
                    for (int j = 0; j < myStats.size(); ++j) {
                        MisfitStats stat = myStats.get(j);
                        String name = stat.range.name;
                        Preconditions.checkState((name != null && !name.isBlank() ? 1 : 0) != 0);
                        if (!nameMatchesMap.containsKey(name)) {
                            nameMatchesMap.put(name, new ArrayList());
                            nameWeightsMap.put(name, new ArrayList());
                            ranges.add(stat.range);
                        }
                        ((List)nameMatchesMap.get(name)).add(stat);
                        ((List)nameWeightsMap.get(name)).add(weight);
                    }
                }
                ArrayList<MisfitStats> avgStats = new ArrayList<MisfitStats>();
                for (ConstraintRange range : ranges) {
                    int numRows = 0;
                    double mean = 0.0;
                    double absMean = 0.0;
                    double median = 0.0;
                    double min = 0.0;
                    double max = 0.0;
                    double l2Norm = 0.0;
                    double energy = 0.0;
                    double std = 0.0;
                    double rmse = 0.0;
                    List matchingStats = (List)nameMatchesMap.get(range.name);
                    List matchingWeights = (List)nameWeightsMap.get(range.name);
                    Preconditions.checkState((matchingStats.size() == matchingWeights.size() ? 1 : 0) != 0);
                    double myTotWeight = 0.0;
                    for (Double weight : matchingWeights) {
                        myTotWeight += weight.doubleValue();
                    }
                    Preconditions.checkState((myTotWeight > 0.0 ? 1 : 0) != 0, (String)"Bad totWeight=%s with %s stats for constraint %s", (Object)myTotWeight, (Object)matchingStats.size(), (Object)range.name);
                    for (int i = 0; i < matchingStats.size(); ++i) {
                        double weight = (Double)matchingWeights.get(i) / myTotWeight;
                        MisfitStats myStats = (MisfitStats)matchingStats.get(i);
                        Preconditions.checkState((boolean)range.name.equals(myStats.range.name));
                        numRows = Integer.max(numRows, myStats.numRows);
                        mean += weight * myStats.mean;
                        absMean += weight * myStats.absMean;
                        median += weight * myStats.median;
                        min += weight * myStats.min;
                        max += weight * myStats.max;
                        l2Norm += weight * myStats.l2Norm;
                        energy += weight * myStats.energy;
                        std += weight * myStats.std;
                        rmse += weight * myStats.rmse;
                    }
                    avgStats.add(new MisfitStats(range, numRows, mean, absMean, median, min, max, l2Norm, energy, std, rmse));
                }
                return new InversionMisfitStats(avgStats);
            }

            @Override
            public Class<InversionMisfitStats> getType() {
                return InversionMisfitStats.class;
            }
        };
    }

    public static class MisfitStats {
        public final ConstraintRange range;
        public final int numRows;
        public final double mean;
        public final double absMean;
        public final double median;
        public final double min;
        public final double max;
        public final double l2Norm;
        public final double energy;
        public final double std;
        public final double rmse;

        public MisfitStats(double[] misfits, boolean inequality, double weight) {
            this(misfits, new ConstraintRange(inequality ? "Inequality" : "Equality", inequality ? "Ineq" : "Eq", 0, misfits.length, inequality, weight, null));
        }

        public MisfitStats(double[] misfits, ConstraintRange range) {
            this.range = range;
            this.numRows = misfits.length;
            Preconditions.checkState((this.numRows == range.endRow - range.startRow ? 1 : 0) != 0, (Object)"Misfits should already be trimmed to match constraint range rows");
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            double mean = 0.0;
            double absMean = 0.0;
            double l2Norm = 0.0;
            double energy = 0.0;
            StandardDeviation std = new StandardDeviation();
            for (double val : misfits) {
                if (range.inequality && val < 0.0) {
                    val = 0.0;
                }
                mean += val;
                absMean += Math.abs(val);
                min = Math.min(val, min);
                max = Math.max(val, max);
                l2Norm += val * val;
                energy += val * range.weight * (val * range.weight);
                std.increment(val);
            }
            this.mean = mean /= (double)this.numRows;
            this.absMean = absMean /= (double)this.numRows;
            this.median = DataUtils.median(misfits);
            this.min = min;
            this.max = max;
            this.l2Norm = l2Norm;
            this.energy = energy;
            this.std = this.numRows == 1 && range.weightingType == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY ? Math.abs(misfits[0]) : std.getResult();
            double mse = l2Norm / (double)this.numRows;
            this.rmse = Math.sqrt(mse);
        }

        MisfitStats(List<String> csvLine) {
            Preconditions.checkState((csvLine.size() == csvHeader.size() || csvLine.size() == csvHeader.size() - 1 ? 1 : 0) != 0);
            int index = 0;
            String name = csvLine.get(index++);
            String shortName = csvLine.get(index++);
            double weight = Double.parseDouble(csvLine.get(index++));
            String weightTypeName = csvLine.get(index++);
            ConstraintWeightingType weightType = weightTypeName == null || weightTypeName.isBlank() || weightTypeName.toLowerCase().trim().equals("null") ? null : ConstraintWeightingType.valueOf(weightTypeName);
            boolean inequality = Boolean.parseBoolean(csvLine.get(index++));
            this.numRows = Integer.parseInt(csvLine.get(index++));
            this.range = new ConstraintRange(name, shortName, 0, this.numRows, inequality, weight, weightType);
            this.mean = Double.parseDouble(csvLine.get(index++));
            this.absMean = Double.parseDouble(csvLine.get(index++));
            this.median = Double.parseDouble(csvLine.get(index++));
            this.min = Double.parseDouble(csvLine.get(index++));
            this.max = Double.parseDouble(csvLine.get(index++));
            this.l2Norm = Double.parseDouble(csvLine.get(index++));
            this.energy = Double.parseDouble(csvLine.get(index++));
            this.std = this.numRows == 1 && this.range.weightingType == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY && Double.parseDouble(csvLine.get(index)) == 0.0 ? this.absMean : Double.parseDouble(csvLine.get(index++));
            if (csvLine.size() == index) {
                double mse = this.l2Norm / (double)this.numRows;
                this.rmse = Math.sqrt(mse);
            } else {
                this.rmse = Double.parseDouble(csvLine.get(index++));
            }
        }

        private MisfitStats(ConstraintRange range, int numRows, double mean, double absMean, double median, double min, double max, double l2Norm, double energy, double std, double rmse) {
            this.range = range;
            this.numRows = numRows;
            this.mean = mean;
            this.absMean = absMean;
            this.median = median;
            this.min = min;
            this.max = max;
            this.l2Norm = l2Norm;
            this.energy = energy;
            this.std = std;
            this.rmse = rmse;
        }

        public double get(Quantity quantity) {
            return quantity.get(this);
        }

        public List<String> buildCSVLine() {
            return List.of(this.range.name, this.range.shortName, "" + this.range.weight, String.valueOf((Object)this.range.weightingType), "" + this.range.inequality, "" + this.numRows, "" + this.mean, "" + this.absMean, "" + this.median, "" + this.min, "" + this.max, "" + this.l2Norm, "" + this.energy, "" + this.std, "" + this.rmse);
        }
    }

    public static enum Quantity {
        MEAN("Mean"){

            @Override
            public double get(MisfitStats stats) {
                return stats.mean;
            }
        }
        ,
        MAD("Mean Absolute Deviation"){

            @Override
            public double get(MisfitStats stats) {
                return stats.absMean;
            }
        }
        ,
        MEDIAN("Median"){

            @Override
            public double get(MisfitStats stats) {
                return stats.median;
            }
        }
        ,
        MIN("Minimum"){

            @Override
            public double get(MisfitStats stats) {
                return stats.min;
            }
        }
        ,
        MAX("Maximum"){

            @Override
            public double get(MisfitStats stats) {
                return stats.max;
            }
        }
        ,
        L2_NORM("L2 Norm"){

            @Override
            public double get(MisfitStats stats) {
                return stats.l2Norm;
            }
        }
        ,
        ENERGY("Energy"){

            @Override
            public double get(MisfitStats stats) {
                return stats.energy;
            }
        }
        ,
        STD_DEV("Standard Deviation"){

            @Override
            public double get(MisfitStats stats) {
                return stats.std;
            }
        }
        ,
        RMSE("RMSE"){

            @Override
            public double get(MisfitStats stats) {
                return stats.rmse;
            }
        };

        private String name;

        private Quantity(String name) {
            this.name = name;
        }

        public abstract double get(MisfitStats var1);

        public String toString() {
            return this.name;
        }
    }
}

