/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.utils.MFD_InversionConstraint;

public abstract class InversionTargetMFDs
implements ArchivableModule,
SubModule<FaultSystemRupSet>,
BranchAverageableModule<InversionTargetMFDs> {
    private FaultSystemRupSet rupSet;

    public InversionTargetMFDs(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }

    public abstract IncrementalMagFreqDist getTotalRegionalMFD();

    public abstract IncrementalMagFreqDist getTotalOnFaultSupraSeisMFD();

    public abstract IncrementalMagFreqDist getTotalOnFaultSubSeisMFD();

    public abstract IncrementalMagFreqDist getTrulyOffFaultMFD();

    public abstract List<? extends IncrementalMagFreqDist> getMFD_Constraints();

    public abstract SubSeismoOnFaultMFDs getOnFaultSubSeisMFDs();

    public List<? extends IncrementalMagFreqDist> getOnFaultSupraSeisNucleationMFDs() {
        return null;
    }

    public IncrementalMagFreqDist getTotalGriddedSeisMFD() {
        IncrementalMagFreqDist subSeismo = this.getTotalOnFaultSubSeisMFD();
        IncrementalMagFreqDist offFault = this.getTrulyOffFaultMFD();
        if (subSeismo == null && offFault == null) {
            return null;
        }
        if (subSeismo == null) {
            return offFault;
        }
        if (offFault == null) {
            return subSeismo;
        }
        SummedMagFreqDist totGridSeisMFD = new SummedMagFreqDist(subSeismo.getMinX(), subSeismo.getMaxX(), subSeismo.size());
        totGridSeisMFD.addIncrementalMagFreqDist(subSeismo);
        totGridSeisMFD.addIncrementalMagFreqDist(offFault);
        totGridSeisMFD.setName("InversionTargetMFDs.getTotalGriddedSeisMFD()");
        return totGridSeisMFD;
    }

    public IncrementalMagFreqDist getTotalOnFaultMFD() {
        IncrementalMagFreqDist subSeismo = this.getTotalOnFaultSubSeisMFD();
        IncrementalMagFreqDist supraSeismo = this.getTotalOnFaultSupraSeisMFD();
        if (subSeismo == null && supraSeismo == null) {
            return supraSeismo;
        }
        if (subSeismo == null) {
            return supraSeismo;
        }
        if (supraSeismo == null) {
            return subSeismo;
        }
        SummedMagFreqDist totOnMFD = new SummedMagFreqDist(subSeismo.getMinX(), subSeismo.getMaxX(), subSeismo.size());
        totOnMFD.addIncrementalMagFreqDist(subSeismo);
        totOnMFD.addIncrementalMagFreqDist(supraSeismo);
        totOnMFD.setName("InversionTargetMFDs.getTotalOnFaultMFD()");
        return totOnMFD;
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    static IncrementalMagFreqDist buildSameSize(IncrementalMagFreqDist ref) {
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(ref.getMinX(), ref.size(), ref.getDelta());
        ret.setName(ref.getName());
        ret.setRegion(ref.getRegion());
        if (ref instanceof UncertainBoundedIncrMagFreqDist) {
            UncertainBoundedIncrMagFreqDist bounded = (UncertainBoundedIncrMagFreqDist)ref;
            ret = new UncertainBoundedIncrMagFreqDist(ret, InversionTargetMFDs.buildSameSize(bounded.getLower()), InversionTargetMFDs.buildSameSize(bounded.getUpper()), bounded.getBoundType(), new EvenlyDiscretizedFunc(ref.getMinX(), ref.size(), ref.getDelta()));
        } else if (ref instanceof UncertainIncrMagFreqDist) {
            ret = new UncertainIncrMagFreqDist(ret, new EvenlyDiscretizedFunc(ref.getMinX(), ref.size(), ref.getDelta()));
        }
        return ret;
    }

    static IncrementalMagFreqDist averageInWeighted(IncrementalMagFreqDist dest, IncrementalMagFreqDist mfd, String type, double weight) {
        if (dest == null || mfd == null) {
            Preconditions.checkState((dest == null ? 1 : 0) != 0, (String)"InversionTargetMFDs: some branches have %s, others don't", (Object)type);
            Preconditions.checkState((mfd == null ? 1 : 0) != 0, (String)"InversionTargetMFDs: some branches have %s, others don't", (Object)type);
            return null;
        }
        Preconditions.checkState(((float)dest.getMinX() == (float)mfd.getMinX() ? 1 : 0) != 0, (String)"MFD minX mismatch for %s between branches", (Object)type);
        Preconditions.checkState(((float)dest.getDelta() == (float)mfd.getDelta() ? 1 : 0) != 0, (String)"MFD delta mismatch for %s between branches", (Object)type);
        if (mfd.getRegion() != null || dest.getRegion() != null) {
            Preconditions.checkState((mfd.getRegion() != null ? 1 : 0) != 0, (String)"Some branches have a region for %s and others don't", (Object)type);
            Preconditions.checkState((dest.getRegion() != null ? 1 : 0) != 0, (String)"Some branches have a region for %s and others don't", (Object)type);
            Preconditions.checkState((boolean)mfd.getRegion().equalsRegion(dest.getRegion()), (String)"Region mismatch across branches for %s", (Object)type);
        }
        if (dest.size() < mfd.size()) {
            IncrementalMagFreqDist newDest = InversionTargetMFDs.expandCopy(dest, mfd.size());
            if (dest instanceof UncertainBoundedIncrMagFreqDist) {
                UncertainBoundedIncrMagFreqDist boundedDest = (UncertainBoundedIncrMagFreqDist)dest;
                IncrementalMagFreqDist upper = InversionTargetMFDs.expandCopy(boundedDest.getUpper(), mfd.size());
                IncrementalMagFreqDist lower = InversionTargetMFDs.expandCopy(boundedDest.getLower(), mfd.size());
                EvenlyDiscretizedFunc stdDevs = InversionTargetMFDs.expandCopy(boundedDest.getStdDevs(), mfd.size());
                newDest = new UncertainBoundedIncrMagFreqDist(newDest, lower, upper, boundedDest.getBoundType(), stdDevs);
            } else if (dest instanceof UncertainIncrMagFreqDist) {
                UncertainIncrMagFreqDist uncert = (UncertainIncrMagFreqDist)dest;
                EvenlyDiscretizedFunc stdDevs = InversionTargetMFDs.expandCopy(uncert.getStdDevs(), mfd.size());
                newDest = new UncertainIncrMagFreqDist(newDest, stdDevs);
            }
            dest = newDest;
        }
        Preconditions.checkState((dest.size() >= mfd.size() ? 1 : 0) != 0, (String)"MFD size mismatch for %s between branches", (Object)type);
        for (int i = 0; i < mfd.size(); ++i) {
            dest.add(i, weight * mfd.getY(i));
        }
        if (dest instanceof UncertainBoundedIncrMagFreqDist) {
            if (mfd instanceof UncertainBoundedIncrMagFreqDist) {
                UncertainBoundedIncrMagFreqDist boundedDest = (UncertainBoundedIncrMagFreqDist)dest;
                UncertainBoundedIncrMagFreqDist boundedMFD = (UncertainBoundedIncrMagFreqDist)mfd;
                Preconditions.checkState((boundedDest.getBoundType() == boundedMFD.getBoundType() ? 1 : 0) != 0, (String)"Bound type mismatch for %s", (Object)type);
                InversionTargetMFDs.averageInWeighted(boundedDest.getLower(), boundedMFD.getLower(), type + " LOWER", weight);
                InversionTargetMFDs.averageInWeighted(boundedDest.getUpper(), boundedMFD.getUpper(), type + " UPPER", weight);
            } else if (mfd instanceof UncertainIncrMagFreqDist) {
                System.err.println("WARNING: " + type + " doesn't have bounded uncertainties on all branches, reverting to UncertainIncrMagFreqDist");
                dest = new UncertainIncrMagFreqDist(dest, ((UncertainIncrMagFreqDist)dest).getStdDevs());
            } else {
                System.err.println("WARNING: " + type + " doesn't have uncertainties on all branches, reverting to IncrementalMagFreqDist");
                dest = new IncrementalMagFreqDist(dest);
            }
        }
        if (dest instanceof UncertainIncrMagFreqDist) {
            if (mfd instanceof UncertainIncrMagFreqDist) {
                EvenlyDiscretizedFunc destStdDevs = ((UncertainIncrMagFreqDist)dest).getStdDevs();
                EvenlyDiscretizedFunc mfdStdDevs = ((UncertainIncrMagFreqDist)mfd).getStdDevs();
                for (int i = 0; i < mfdStdDevs.size(); ++i) {
                    destStdDevs.add(i, mfdStdDevs.getY(i) * weight);
                }
            } else {
                System.err.println("WARNING: " + type + " doesn't have uncertainties on all branches, reverting to IncrementalMagFreqDist");
                dest = new IncrementalMagFreqDist(dest);
            }
        }
        return dest;
    }

    private static IncrementalMagFreqDist expandCopy(IncrementalMagFreqDist mfd, int newSize) {
        Preconditions.checkState((newSize > mfd.size() ? 1 : 0) != 0);
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(mfd.getMinX(), newSize, mfd.getDelta());
        for (int i = 0; i < mfd.size(); ++i) {
            ret.set(i, mfd.getY(i));
        }
        return ret;
    }

    private static EvenlyDiscretizedFunc expandCopy(EvenlyDiscretizedFunc mfd, int newSize) {
        Preconditions.checkState((newSize > mfd.size() ? 1 : 0) != 0);
        EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(mfd.getMinX(), newSize, mfd.getDelta());
        for (int i = 0; i < mfd.size(); ++i) {
            ret.set(i, mfd.getY(i));
        }
        return ret;
    }

    static void scaleToTotWeight(EvenlyDiscretizedFunc dest, double totWeight) {
        if (dest == null) {
            return;
        }
        double scale = 1.0 / totWeight;
        for (int i = 0; i < dest.size(); ++i) {
            double val = dest.getY(i);
            if (val == 0.0) continue;
            dest.set(i, val * scale);
        }
        if (dest instanceof UncertainBoundedIncrMagFreqDist) {
            UncertainBoundedIncrMagFreqDist bounded = (UncertainBoundedIncrMagFreqDist)dest;
            InversionTargetMFDs.scaleToTotWeight(bounded.getLower(), totWeight);
            InversionTargetMFDs.scaleToTotWeight(bounded.getUpper(), totWeight);
        }
        if (dest instanceof UncertainIncrMagFreqDist) {
            InversionTargetMFDs.scaleToTotWeight(((UncertainIncrMagFreqDist)dest).getStdDevs(), totWeight);
        }
    }

    protected static class Averager
    implements AverageableModule.AveragingAccumulator<InversionTargetMFDs> {
        private IncrementalMagFreqDist totalRegionalMFD;
        private IncrementalMagFreqDist onFaultSupraSeisMFD;
        private IncrementalMagFreqDist onFaultSubSeisMFD;
        private IncrementalMagFreqDist trulyOffFaultMFD;
        private List<IncrementalMagFreqDist> mfdConstraints;
        private AverageableModule.AveragingAccumulator<SubSeismoOnFaultMFDs> subSeismoOnFaultAccumulator;
        private List<IncrementalMagFreqDist> supraSeisOnFaultNuclMFDs;
        private boolean first = true;
        protected double totWeight = 0.0;
        private boolean averaged = false;

        protected Averager() {
        }

        @Override
        public Class<InversionTargetMFDs> getType() {
            return InversionTargetMFDs.class;
        }

        @Override
        public void process(InversionTargetMFDs module, double relWeight) {
            IncrementalMagFreqDist myTotReg = module.getTotalRegionalMFD();
            IncrementalMagFreqDist myOnFaultSupra = module.getTotalOnFaultSupraSeisMFD();
            IncrementalMagFreqDist myOnFaultSub = module.getTotalOnFaultSubSeisMFD();
            IncrementalMagFreqDist myTrulyOff = module.getTrulyOffFaultMFD();
            List<? extends IncrementalMagFreqDist> myConstraints = module.getMFD_Constraints();
            SubSeismoOnFaultMFDs mySubSeismoMFDs = module.getOnFaultSubSeisMFDs();
            List<? extends IncrementalMagFreqDist> mySupraSeismoMFDs = module.getOnFaultSupraSeisNucleationMFDs();
            if (this.first) {
                if (myTotReg != null) {
                    this.totalRegionalMFD = InversionTargetMFDs.buildSameSize(myTotReg);
                }
                if (myOnFaultSupra != null) {
                    this.onFaultSupraSeisMFD = InversionTargetMFDs.buildSameSize(myOnFaultSupra);
                }
                if (myOnFaultSub != null) {
                    this.onFaultSubSeisMFD = InversionTargetMFDs.buildSameSize(myOnFaultSub);
                }
                if (myTrulyOff != null) {
                    this.trulyOffFaultMFD = InversionTargetMFDs.buildSameSize(myTrulyOff);
                }
                if (myConstraints != null) {
                    this.mfdConstraints = new ArrayList<IncrementalMagFreqDist>();
                    for (IncrementalMagFreqDist incrementalMagFreqDist : myConstraints) {
                        this.mfdConstraints.add(InversionTargetMFDs.buildSameSize(incrementalMagFreqDist));
                    }
                }
                if (mySubSeismoMFDs != null) {
                    this.subSeismoOnFaultAccumulator = mySubSeismoMFDs.averagingAccumulator();
                }
                if (mySupraSeismoMFDs != null) {
                    this.supraSeisOnFaultNuclMFDs = new ArrayList<IncrementalMagFreqDist>();
                    for (IncrementalMagFreqDist incrementalMagFreqDist : mySupraSeismoMFDs) {
                        this.supraSeisOnFaultNuclMFDs.add(InversionTargetMFDs.buildSameSize(incrementalMagFreqDist));
                    }
                }
                this.first = false;
            }
            this.totalRegionalMFD = InversionTargetMFDs.averageInWeighted(this.totalRegionalMFD, myTotReg, "total regional", relWeight);
            this.onFaultSupraSeisMFD = InversionTargetMFDs.averageInWeighted(this.onFaultSupraSeisMFD, myOnFaultSupra, "on fault supra", relWeight);
            this.onFaultSubSeisMFD = InversionTargetMFDs.averageInWeighted(this.onFaultSubSeisMFD, myOnFaultSub, "on fault sub", relWeight);
            this.trulyOffFaultMFD = InversionTargetMFDs.averageInWeighted(this.trulyOffFaultMFD, myTrulyOff, "truly off", relWeight);
            if (myConstraints != null || this.mfdConstraints != null) {
                Preconditions.checkNotNull(myConstraints, (Object)"Some branches have MFD constraints and others don't");
                Preconditions.checkNotNull(this.mfdConstraints, (Object)"Some branches have MFD constraints and others don't");
                Preconditions.checkState((this.mfdConstraints.size() == myConstraints.size() ? 1 : 0) != 0, (Object)"MFD constraint count varies by branch");
                for (int i = 0; i < myConstraints.size(); ++i) {
                    this.mfdConstraints.set(i, InversionTargetMFDs.averageInWeighted(this.mfdConstraints.get(i), myConstraints.get(i), "MFD constraint " + i, relWeight));
                }
            }
            if (mySubSeismoMFDs != null || this.subSeismoOnFaultAccumulator != null) {
                Preconditions.checkNotNull((Object)mySubSeismoMFDs, (Object)"Some branches have sub seismo MFDs and others don't");
                Preconditions.checkNotNull(this.subSeismoOnFaultAccumulator, (Object)"Some branches have sub seismo MFDs and others don't");
                this.subSeismoOnFaultAccumulator.process(mySubSeismoMFDs, relWeight);
            }
            if (mySupraSeismoMFDs != null || this.supraSeisOnFaultNuclMFDs != null) {
                if (mySupraSeismoMFDs == null) {
                    this.supraSeisOnFaultNuclMFDs = null;
                } else if (this.supraSeisOnFaultNuclMFDs != null) {
                    Preconditions.checkState((this.supraSeisOnFaultNuclMFDs.size() == mySupraSeismoMFDs.size() ? 1 : 0) != 0, (Object)"Section nucleation MFD constraint count varies by branch?");
                    for (int i = 0; i < mySupraSeismoMFDs.size(); ++i) {
                        this.supraSeisOnFaultNuclMFDs.set(i, InversionTargetMFDs.averageInWeighted(this.supraSeisOnFaultNuclMFDs.get(i), mySupraSeismoMFDs.get(i), "Sect Nucl MFD constraint " + i, relWeight));
                    }
                }
            }
            this.totWeight += relWeight;
        }

        @Override
        public synchronized InversionTargetMFDs getAverage() {
            Preconditions.checkState((!this.averaged ? 1 : 0) != 0, (Object)"Cannot call getAverage more than once!");
            InversionTargetMFDs.scaleToTotWeight(this.totalRegionalMFD, this.totWeight);
            InversionTargetMFDs.scaleToTotWeight(this.onFaultSupraSeisMFD, this.totWeight);
            InversionTargetMFDs.scaleToTotWeight(this.onFaultSubSeisMFD, this.totWeight);
            InversionTargetMFDs.scaleToTotWeight(this.trulyOffFaultMFD, this.totWeight);
            if (this.mfdConstraints != null) {
                for (IncrementalMagFreqDist constr : this.mfdConstraints) {
                    InversionTargetMFDs.scaleToTotWeight(constr, this.totWeight);
                }
            }
            SubSeismoOnFaultMFDs subSeismoMFDs = null;
            if (this.subSeismoOnFaultAccumulator != null) {
                subSeismoMFDs = this.subSeismoOnFaultAccumulator.getAverage();
            }
            if (this.supraSeisOnFaultNuclMFDs != null) {
                for (IncrementalMagFreqDist constr : this.supraSeisOnFaultNuclMFDs) {
                    InversionTargetMFDs.scaleToTotWeight(constr, this.totWeight);
                }
            }
            this.averaged = true;
            return new Precomputed(null, this.totalRegionalMFD, this.onFaultSupraSeisMFD, this.onFaultSubSeisMFD, this.trulyOffFaultMFD, this.mfdConstraints, subSeismoMFDs, this.supraSeisOnFaultNuclMFDs);
        }
    }

    public static class Precomputed
    extends InversionTargetMFDs
    implements ArchivableModule {
        private static TypeAdapter<IncrementalMagFreqDist> mfdAdapter = new IncrementalMagFreqDist.Adapter();
        private static TypeAdapter<MFD_InversionConstraint> mfdConstraintAdapter = new MFD_InversionConstraint.Adapter();
        private IncrementalMagFreqDist totalRegionalMFD;
        private IncrementalMagFreqDist onFaultSupraSeisMFD;
        private IncrementalMagFreqDist onFaultSubSeisMFD;
        private IncrementalMagFreqDist trulyOffFaultMFD;
        private ImmutableList<? extends IncrementalMagFreqDist> mfdConstraints;
        private SubSeismoOnFaultMFDs subSeisOnFaultMFDs;
        private ImmutableList<? extends IncrementalMagFreqDist> supraSeisOnFaultNuclMFDs;

        protected Precomputed() {
            super(null);
        }

        public Precomputed(InversionTargetMFDs targetMFDs) {
            this(targetMFDs.rupSet, targetMFDs.getTotalRegionalMFD(), targetMFDs.getTotalOnFaultSupraSeisMFD(), targetMFDs.getTotalOnFaultSubSeisMFD(), targetMFDs.getTrulyOffFaultMFD(), targetMFDs.getMFD_Constraints(), targetMFDs.getOnFaultSubSeisMFDs(), targetMFDs.getOnFaultSupraSeisNucleationMFDs());
        }

        public Precomputed(FaultSystemRupSet rupSet, IncrementalMagFreqDist totalRegionalMFD, IncrementalMagFreqDist onFaultSupraSeisMFD, IncrementalMagFreqDist onFaultSubSeisMFD, IncrementalMagFreqDist trulyOffFaultMFD, List<? extends IncrementalMagFreqDist> mfdConstraints, SubSeismoOnFaultMFDs subSeisOnFaultMFDs, List<? extends IncrementalMagFreqDist> supraSeisOnFaultNuclMFDs) {
            super(rupSet);
            this.totalRegionalMFD = totalRegionalMFD;
            this.onFaultSupraSeisMFD = onFaultSupraSeisMFD;
            this.onFaultSubSeisMFD = onFaultSubSeisMFD;
            this.trulyOffFaultMFD = trulyOffFaultMFD;
            this.subSeisOnFaultMFDs = subSeisOnFaultMFDs;
            this.mfdConstraints = mfdConstraints == null ? null : ImmutableList.copyOf(mfdConstraints);
            this.supraSeisOnFaultNuclMFDs = supraSeisOnFaultNuclMFDs == null ? null : ImmutableList.copyOf(supraSeisOnFaultNuclMFDs);
        }

        @Override
        public String getName() {
            return "Inversion Target MFDs";
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
            ModuleContainer rupSet = this.getParent();
            Preconditions.checkState((rupSet == null || ((FaultSystemRupSet)rupSet).isEquivalentTo(newParent) ? 1 : 0) != 0);
            return new Precomputed(newParent, this.totalRegionalMFD, this.onFaultSupraSeisMFD, this.onFaultSubSeisMFD, this.trulyOffFaultMFD, (List<? extends IncrementalMagFreqDist>)this.mfdConstraints, this.subSeisOnFaultMFDs, (List<? extends IncrementalMagFreqDist>)this.supraSeisOnFaultNuclMFDs);
        }

        private void writeToJSON(JsonWriter out) throws IOException {
            out.beginObject();
            out.name("totalRegionalMFD");
            mfdAdapter.write(out, (Object)this.totalRegionalMFD);
            out.name("onFaultSupraSeisMFD");
            mfdAdapter.write(out, (Object)this.onFaultSupraSeisMFD);
            out.name("onFaultSubSeisMFD");
            mfdAdapter.write(out, (Object)this.onFaultSubSeisMFD);
            out.name("trulyOffFaultMFD");
            mfdAdapter.write(out, (Object)this.trulyOffFaultMFD);
            if (this.supraSeisOnFaultNuclMFDs != null) {
                out.name("supraSeisOnFaultNuclMFDs");
                out.beginArray();
                for (IncrementalMagFreqDist constraint : this.supraSeisOnFaultNuclMFDs) {
                    mfdAdapter.write(out, (Object)constraint);
                }
                out.endArray();
            }
            out.name("constraints");
            if (this.mfdConstraints == null) {
                out.nullValue();
            } else {
                out.beginArray();
                for (IncrementalMagFreqDist constraint : this.mfdConstraints) {
                    mfdAdapter.write(out, (Object)constraint);
                }
                out.endArray();
            }
            out.endObject();
        }

        private void initFromJSON(JsonReader in) throws IOException {
            in.beginObject();
            block18: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "totalRegionalMFD": {
                        this.totalRegionalMFD = (IncrementalMagFreqDist)mfdAdapter.read(in);
                        continue block18;
                    }
                    case "onFaultSupraSeisMFD": {
                        this.onFaultSupraSeisMFD = (IncrementalMagFreqDist)mfdAdapter.read(in);
                        continue block18;
                    }
                    case "onFaultSubSeisMFD": {
                        this.onFaultSubSeisMFD = (IncrementalMagFreqDist)mfdAdapter.read(in);
                        continue block18;
                    }
                    case "trulyOffFaultMFD": {
                        this.trulyOffFaultMFD = (IncrementalMagFreqDist)mfdAdapter.read(in);
                        continue block18;
                    }
                    case "mfdConstraints": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            this.mfdConstraints = null;
                            continue block18;
                        }
                        ImmutableList.Builder builder = ImmutableList.builder();
                        in.beginArray();
                        while (in.hasNext()) {
                            MFD_InversionConstraint oldConstr = (MFD_InversionConstraint)mfdConstraintAdapter.read(in);
                            IncrementalMagFreqDist mfd = oldConstr.getMagFreqDist();
                            mfd.setRegion(oldConstr.getRegion());
                            builder.add((Object)mfd);
                        }
                        in.endArray();
                        this.mfdConstraints = builder.build();
                        continue block18;
                    }
                    case "constraints": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            this.mfdConstraints = null;
                            continue block18;
                        }
                        ImmutableList.Builder builder = ImmutableList.builder();
                        in.beginArray();
                        while (in.hasNext()) {
                            builder.add((Object)((IncrementalMagFreqDist)mfdAdapter.read(in)));
                        }
                        in.endArray();
                        this.mfdConstraints = builder.build();
                        continue block18;
                    }
                    case "supraSeisOnFaultNuclMFDs": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            this.supraSeisOnFaultNuclMFDs = null;
                            continue block18;
                        }
                        ImmutableList.Builder builder = ImmutableList.builder();
                        in.beginArray();
                        while (in.hasNext()) {
                            builder.add((Object)((IncrementalMagFreqDist)mfdAdapter.read(in)));
                        }
                        in.endArray();
                        this.supraSeisOnFaultNuclMFDs = builder.build();
                        continue block18;
                    }
                }
                in.skipValue();
            }
            in.endObject();
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
            BufferedOutputStream out = new BufferedOutputStream(FileBackedModule.initOutputStream(output, entryPrefix, "inversion_target_mfds.json"));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            this.writeToJSON(gson.newJsonWriter((Writer)writer));
            writer.flush();
            out.flush();
            output.closeEntry();
            if (this.subSeisOnFaultMFDs != null) {
                this.subSeisOnFaultMFDs.writeToArchive(output, entryPrefix);
            }
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            BufferedInputStream in = FileBackedModule.getInputStream(input, entryPrefix, "inversion_target_mfds.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            InputStreamReader reader = new InputStreamReader(in);
            this.initFromJSON(gson.newJsonReader((Reader)reader));
            String subSeisName = ArchivableModule.getEntryName(entryPrefix, "sub_seismo_on_fault_mfds.csv");
            if (input.hasEntry(subSeisName)) {
                CSVFile<String> csv = CSVFile.readStream(input.getInputStream(subSeisName), false);
                this.subSeisOnFaultMFDs = SubSeismoOnFaultMFDs.fromCSV(csv);
            }
        }

        @Override
        public final IncrementalMagFreqDist getTotalRegionalMFD() {
            return this.totalRegionalMFD;
        }

        @Override
        public final IncrementalMagFreqDist getTotalOnFaultSupraSeisMFD() {
            return this.onFaultSupraSeisMFD;
        }

        @Override
        public final IncrementalMagFreqDist getTrulyOffFaultMFD() {
            return this.trulyOffFaultMFD;
        }

        @Override
        public final IncrementalMagFreqDist getTotalOnFaultSubSeisMFD() {
            return this.onFaultSubSeisMFD;
        }

        @Override
        public final List<? extends IncrementalMagFreqDist> getMFD_Constraints() {
            return this.mfdConstraints;
        }

        @Override
        public final SubSeismoOnFaultMFDs getOnFaultSubSeisMFDs() {
            return this.subSeisOnFaultMFDs;
        }

        @Override
        public List<? extends IncrementalMagFreqDist> getOnFaultSupraSeisNucleationMFDs() {
            return this.supraSeisOnFaultNuclMFDs;
        }

        @Override
        public AverageableModule.AveragingAccumulator<InversionTargetMFDs> averagingAccumulator() {
            return new Averager();
        }
    }
}

