/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.JSON_TypeAdapterBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;

public class PaleoseismicConstraintData
implements SubModule<FaultSystemRupSet>,
JSON_TypeAdapterBackedModule<PaleoseismicConstraintData>,
BranchAverageableModule<PaleoseismicConstraintData>,
SplittableRuptureModule<PaleoseismicConstraintData> {
    private transient FaultSystemRupSet rupSet;
    private List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints;
    private PaleoProbabilityModel paleoProbModel;
    private List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoSlipConstraints;
    private PaleoSlipProbabilityModel paleoSlipProbModel;
    private boolean prevAppliedRateUncertainty;
    List<UncertainDataConstraint.SectMappedUncertainDataConstraint> prevInferred = null;
    private static final double LOC_CHECK_DEGREE_TOLERANCE = 3.0;
    private static final double LOC_CHECK_DEGREE_TOLERANCE_SQ = 9.0;

    public static PaleoseismicConstraintData loadUCERF3(FaultSystemRupSet rupSet) throws IOException {
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = UCERF3_PaleoRateConstraintFetcher.getConstraints(rupSet.getFaultSectionDataList());
        UCERF3_PaleoProbabilityModel paleoProbModel = UCERF3_PaleoProbabilityModel.load();
        List<U3AveSlipConstraint> aveSlipConstraints = U3AveSlipConstraint.load(rupSet.getFaultSectionDataList());
        PaleoSlipProbabilityModel paleoSlipProbModel = U3AveSlipConstraint.slip_prob_model;
        return new PaleoseismicConstraintData(rupSet, paleoRateConstraints, paleoProbModel, aveSlipConstraints, paleoSlipProbModel);
    }

    private PaleoseismicConstraintData() {
    }

    public PaleoseismicConstraintData(FaultSystemRupSet rupSet, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints, PaleoProbabilityModel paleoProbModel, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoSlipConstraints, PaleoSlipProbabilityModel paleoSlipProbModel) {
        this.rupSet = rupSet;
        this.paleoRateConstraints = paleoRateConstraints;
        this.paleoProbModel = paleoProbModel;
        this.paleoSlipConstraints = paleoSlipConstraints;
        this.paleoSlipProbModel = paleoSlipProbModel;
    }

    @Override
    public String getName() {
        return "Paleoseismic Constraint Data";
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        if (this.rupSet != null && parent != null) {
            Preconditions.checkState((boolean)this.rupSet.areSectionsEquivalentTo(parent));
        }
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    @Override
    public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
        if (this.rupSet != null && newParent != null) {
            Preconditions.checkState((boolean)this.rupSet.areSectionsEquivalentTo(newParent));
        }
        return new PaleoseismicConstraintData(newParent, this.paleoRateConstraints, this.paleoProbModel, this.paleoSlipConstraints, this.paleoSlipProbModel);
    }

    @Override
    public String getFileName() {
        return "paleo_constraint_data.json";
    }

    @Override
    public Type getType() {
        return PaleoseismicConstraintData.class;
    }

    @Override
    public PaleoseismicConstraintData get() {
        return this;
    }

    @Override
    public void set(PaleoseismicConstraintData value) {
        this.rupSet = value.rupSet;
        this.paleoRateConstraints = value.paleoRateConstraints;
        this.paleoProbModel = value.paleoProbModel;
        this.paleoSlipConstraints = value.paleoSlipConstraints;
        this.paleoSlipProbModel = value.paleoSlipProbModel;
    }

    @Override
    public void registerTypeAdapters(GsonBuilder builder) {
    }

    public boolean hasPaleoRateConstraints() {
        return this.paleoRateConstraints != null && !this.paleoRateConstraints.isEmpty();
    }

    public List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> getPaleoRateConstraints() {
        return this.paleoRateConstraints;
    }

    public PaleoProbabilityModel getPaleoProbModel() {
        return this.paleoProbModel;
    }

    public boolean hasPaleoSlipConstraints() {
        return this.paleoSlipConstraints != null && !this.paleoSlipConstraints.isEmpty();
    }

    public List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> getPaleoSlipConstraints() {
        return this.paleoSlipConstraints;
    }

    public PaleoSlipProbabilityModel getPaleoSlipProbModel() {
        return this.paleoSlipProbModel;
    }

    public synchronized List<UncertainDataConstraint.SectMappedUncertainDataConstraint> inferRatesFromSlipConstraints(boolean applySlipRateUncertainty) {
        if (this.prevInferred != null && this.prevAppliedRateUncertainty == applySlipRateUncertainty) {
            return new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>(this.prevInferred);
        }
        this.prevInferred = PaleoseismicConstraintData.inferRatesFromSlipConstraints(this.rupSet, this.paleoSlipConstraints, applySlipRateUncertainty);
        this.prevAppliedRateUncertainty = applySlipRateUncertainty;
        return new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>(this.prevInferred);
    }

    public static List<UncertainDataConstraint.SectMappedUncertainDataConstraint> inferRatesFromSlipConstraints(FaultSystemRupSet rupSet, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoSlipConstraints, boolean applySlipRateUncertainty) {
        SectSlipRates targetSlipRates = rupSet.requireModule(SectSlipRates.class);
        double[] slipRateStdDevs = null;
        if (applySlipRateUncertainty) {
            slipRateStdDevs = targetSlipRates.getSlipRateStdDevs();
            for (int s = 0; s < slipRateStdDevs.length; ++s) {
                double origFractSlip;
                FaultSection sect = rupSet.getFaultSectionData(s);
                double d = targetSlipRates.getSlipRate(s);
                if (!(d > 0.0) || !(sect instanceof GeoJSONFaultSection) || !((origFractSlip = ((GeoJSONFaultSection)sect).getProperties().getDouble("OrigFractStdDev", Double.NaN)) > 0.0)) continue;
                slipRateStdDevs[s] = Math.max(slipRateStdDevs[s], d * origFractSlip);
            }
        }
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> inferred = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : paleoSlipConstraints) {
            double targetSlipRate = targetSlipRates.getSlipRate(sectMappedUncertainDataConstraint.sectionIndex);
            double targetSlipRateStdDev = applySlipRateUncertainty ? slipRateStdDevs[sectMappedUncertainDataConstraint.sectionIndex] : 0.0;
            double aveSlip = sectMappedUncertainDataConstraint.bestEstimate;
            double aveSlipStdDev = sectMappedUncertainDataConstraint.getPreferredStdDev();
            System.out.println("Inferring rate constraint from paleo slip constraint on " + sectMappedUncertainDataConstraint.sectionName);
            System.out.println("\tslip=" + (float)aveSlip + " +/- " + (float)aveSlipStdDev);
            System.out.println("\tslip rate=" + (float)targetSlipRate + " +/- " + (float)targetSlipRateStdDev);
            double meanRate = targetSlipRate / aveSlip;
            double rateSD = applySlipRateUncertainty ? (targetSlipRate == 0.0 ? targetSlipRateStdDev / (aveSlip - aveSlipStdDev) : meanRate * Math.sqrt(Math.pow(targetSlipRateStdDev / targetSlipRate, 2.0) + Math.pow(aveSlipStdDev / aveSlip, 2.0))) : meanRate * aveSlipStdDev / aveSlip;
            System.out.println("\trate=" + (float)meanRate + " +/- " + (float)rateSD);
            inferred.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(sectMappedUncertainDataConstraint.name, sectMappedUncertainDataConstraint.sectionIndex, sectMappedUncertainDataConstraint.sectionName, sectMappedUncertainDataConstraint.dataLocation, meanRate, new Uncertainty(rateSD)));
        }
        return inferred;
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/markdown/inversions/fm3_1_u3ref_uniform_coulomb.zip"));
        PaleoseismicConstraintData data = PaleoseismicConstraintData.loadUCERF3(rupSet);
        data.inferRatesFromSlipConstraints(true);
    }

    @Override
    public AverageableModule.AveragingAccumulator<PaleoseismicConstraintData> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<PaleoseismicConstraintData>(){
            PaleoseismicConstraintData paleoData;

            @Override
            public void process(PaleoseismicConstraintData module, double relWeight) {
                if (this.paleoData == null) {
                    this.paleoData = module;
                } else {
                    boolean same = PaleoseismicConstraintData.paleoConstraintsSame(this.paleoData.getPaleoRateConstraints(), module.getPaleoRateConstraints());
                    boolean bl = same = same && PaleoseismicConstraintData.paleoConstraintsSame(this.paleoData.getPaleoSlipConstraints(), module.getPaleoSlipConstraints());
                    if (same && this.paleoData.getPaleoProbModel() != null) {
                        same = this.paleoData.getPaleoProbModel().getClass().equals(module.getPaleoProbModel().getClass());
                    }
                    if (same && this.paleoData.getPaleoSlipProbModel() != null) {
                        same = this.paleoData.getPaleoSlipProbModel().getClass().equals(module.getPaleoSlipProbModel().getClass());
                    }
                    if (!same) {
                        throw new IllegalStateException("Paleo-seismic data varies by branch, averaging not (yet) supported");
                    }
                }
            }

            @Override
            public PaleoseismicConstraintData getAverage() {
                return this.paleoData;
            }

            @Override
            public Class<PaleoseismicConstraintData> getType() {
                return PaleoseismicConstraintData.class;
            }
        };
    }

    private static boolean paleoConstraintsSame(List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> constr1, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> constr2) {
        if (constr1 == null != (constr2 == null)) {
            return false;
        }
        if (constr1 == null && constr2 == null) {
            return true;
        }
        if (constr1.size() != constr2.size()) {
            return false;
        }
        for (int i = 0; i < constr1.size(); ++i) {
            UncertainDataConstraint.SectMappedUncertainDataConstraint c1 = constr1.get(i);
            UncertainDataConstraint.SectMappedUncertainDataConstraint c2 = constr2.get(i);
            if (c1.sectionIndex != c2.sectionIndex) {
                return false;
            }
            if ((float)c1.bestEstimate == (float)c2.bestEstimate) continue;
            return false;
        }
        return true;
    }

    @Override
    public PaleoseismicConstraintData getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> filteredRateConstraints = PaleoseismicConstraintData.getRemapped(this.paleoRateConstraints, mappings);
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> filteredSlipConstraints = PaleoseismicConstraintData.getRemapped(this.paleoSlipConstraints, mappings);
        if (filteredRateConstraints == null && filteredSlipConstraints == null) {
            return null;
        }
        return new PaleoseismicConstraintData(rupSubSet, filteredRateConstraints, this.paleoProbModel, filteredSlipConstraints, this.paleoSlipProbModel);
    }

    private static List<UncertainDataConstraint.SectMappedUncertainDataConstraint> getRemapped(List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> constraints, RuptureSubSetMappings mappings) {
        if (constraints == null || constraints.isEmpty()) {
            return null;
        }
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> remapped = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : constraints) {
            if (!mappings.isSectRetained(sectMappedUncertainDataConstraint.sectionIndex)) continue;
            remapped.add(sectMappedUncertainDataConstraint.forRemappedSectionIndex(mappings.getNewSectID(sectMappedUncertainDataConstraint.sectionIndex)));
        }
        if (remapped.isEmpty()) {
            return null;
        }
        return remapped;
    }

    @Override
    public PaleoseismicConstraintData getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> filteredRateConstraints = PaleoseismicConstraintData.getRemapped(this.paleoRateConstraints, mappings);
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> filteredSlipConstraints = PaleoseismicConstraintData.getRemapped(this.paleoSlipConstraints, mappings);
        if (filteredRateConstraints == null && filteredSlipConstraints == null) {
            return null;
        }
        return new PaleoseismicConstraintData(splitRupSet, filteredRateConstraints, this.paleoProbModel, filteredSlipConstraints, this.paleoSlipProbModel);
    }

    private static List<UncertainDataConstraint.SectMappedUncertainDataConstraint> getRemapped(List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> constraints, RuptureSetSplitMappings mappings) {
        if (constraints == null || constraints.isEmpty()) {
            return null;
        }
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> remapped = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : constraints) {
            List<Integer> newIDs = mappings.getNewSectIDs(sectMappedUncertainDataConstraint.sectionIndex);
            Preconditions.checkState((newIDs.size() == 1 ? 1 : 0) != 0, (Object)"Can't split paleo constraints");
            remapped.add(sectMappedUncertainDataConstraint.forRemappedSectionIndex(newIDs.get(0)));
        }
        if (remapped.isEmpty()) {
            return null;
        }
        return remapped;
    }

    public static PaleoseismicConstraintData fromSimpleCSV(FaultSystemRupSet rupSet, CSVFile<String> csv, PaleoProbabilityModel probModel) {
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> constraints = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        double maxDist = 100.0;
        Preconditions.checkState((csv.getNumCols() == 6 ? 1 : 0) != 0, (String)"Expected 6 columns, have %s", (int)csv.getNumCols());
        for (int row = 1; row < csv.getNumRows(); ++row) {
            double dist;
            FaultSection sect;
            String name = csv.get(row, 0);
            String sectStr = csv.get(row, 1);
            int subsectionIndex = sectStr == null || sectStr.isBlank() ? -1 : Integer.parseInt(sectStr);
            double lat = csv.getDouble(row, 2);
            double lon = csv.getDouble(row, 3);
            double rate = csv.getDouble(row, 4);
            double rateStdDev = csv.getDouble(row, 5);
            Location loc = new Location(lat, lon);
            if (subsectionIndex < 0) {
                System.out.println("Looking for nearest subsection to paleoseidmic site: " + (float)lat + ", " + (float)lon);
                sect = PaleoseismicConstraintData.findMatchingSect(loc, rupSet.getFaultSectionDataList(), maxDist, maxDist, maxDist);
                Preconditions.checkNotNull((Object)sect, (String)"No fault sections found within %s km of site '%s' at location %s", (Object)Float.valueOf((float)maxDist), (Object)name, (Object)loc);
                dist = sect.getFaultTrace().minDistToLine(loc);
                System.out.println("\tClosest match is " + sect.getSectionId() + ". " + sect.getSectionName() + " (" + (float)dist + " km away)");
                subsectionIndex = sect.getSectionId();
            } else {
                sect = rupSet.getFaultSectionData(subsectionIndex);
                dist = sect.getFaultTrace().minDistToLine(loc);
                System.out.println("Supplied section for " + name + " is " + sect.getSectionId() + ". " + sect.getSectionName() + " (" + (float)dist + " km away)");
            }
            Preconditions.checkState((rate > 0.0 ? 1 : 0) != 0, (String)"Bad rate for paleo site '%s': %s", (Object)name, (Object)rate);
            Preconditions.checkState((rateStdDev > 0.0 ? 1 : 0) != 0, (String)"Bad rate std. dev. for paleo site '%s': %s", (Object)name, (Object)rateStdDev);
            constraints.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(name, sect.getSectionId(), sect.getName(), loc, rate, new Uncertainty(rateStdDev)));
        }
        return new PaleoseismicConstraintData(rupSet, constraints, probModel, null, null);
    }

    public static FaultSection findMatchingSect(Location loc, List<? extends FaultSection> subSects, double maxDistNoneContained, double maxDistOtherContained, double maxDistContained) {
        ArrayList<FaultSection> candidates = new ArrayList<FaultSection>();
        ArrayList<FaultSection> containsCandidates = new ArrayList<FaultSection>();
        HashMap<FaultSection, Double> candidateDists = new HashMap<FaultSection, Double>();
        for (FaultSection faultSection : subSects) {
            boolean candidate = false;
            for (Location traceLoc : faultSection.getFaultTrace()) {
                double lonDiff;
                double latDiff = loc.getLatitude() - traceLoc.getLatitude();
                if (!(latDiff * latDiff + (lonDiff = loc.getLongitude() - traceLoc.getLongitude()) * lonDiff < 9.0)) continue;
                candidate = true;
                break;
            }
            if (!candidate) continue;
            candidates.add(faultSection);
            double dist = faultSection.getFaultTrace().minDistToLine(loc);
            candidateDists.put(faultSection, dist);
            if (!(faultSection.getAveDip() < 89.0)) continue;
            LocationList perim = new LocationList();
            perim.addAll(faultSection.getFaultSurface(1.0).getEvenlyDiscritizedPerimeter());
            if (!perim.last().equals(perim.first())) {
                perim.add(perim.first());
            }
            Region region = null;
            try {
                region = new Region(perim, BorderType.GREAT_CIRCLE);
            }
            catch (Exception e) {
                perim = new LocationList();
                perim.addAll(faultSection.getFaultSurface(1.0).getPerimeter());
                if (!perim.last().equals(perim.first())) {
                    perim.add(perim.first());
                }
                try {
                    region = new Region(perim, BorderType.GREAT_CIRCLE);
                }
                catch (Exception e1) {
                    System.err.println("WARNING: failed to create polygon for section " + faultSection.getSectionId() + ". " + faultSection.getSectionName() + " when searching for paleo mappings for site at " + String.valueOf(loc));
                }
            }
            if (region == null || !region.contains(loc)) continue;
            containsCandidates.add(faultSection);
        }
        FaultSection closest = null;
        double d = Double.POSITIVE_INFINITY;
        for (FaultSection sect : candidates) {
            double dist = (Double)candidateDists.get(sect);
            if (!(dist < d)) continue;
            d = dist;
            closest = sect;
        }
        if (containsCandidates.isEmpty()) {
            if (d < maxDistNoneContained) {
                return closest;
            }
            return null;
        }
        if (d < maxDistOtherContained) {
            return closest;
        }
        FaultSection closestContaining = null;
        double closestContainingDist = Double.POSITIVE_INFINITY;
        for (FaultSection sect : containsCandidates) {
            double dist = (Double)candidateDists.get(sect);
            if (!(dist < closestContainingDist)) continue;
            closestContainingDist = dist;
            closestContaining = sect;
        }
        if (closestContainingDist < maxDistContained) {
            return closestContaining;
        }
        return null;
    }
}

