/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;

public interface PolygonFaultGridAssociations
extends FaultGridAssociations {
    public Region getPoly(int var1);

    @Override
    default public AverageableModule.AveragingAccumulator<FaultGridAssociations> averagingAccumulator() {
        return new Averager();
    }

    public static class Averager
    implements AverageableModule.AveragingAccumulator<FaultGridAssociations> {
        private FaultGridAssociations.Averager gridAverager;
        private ImmutableMap<Integer, Region> polys;

        @Override
        public Class<FaultGridAssociations> getType() {
            return FaultGridAssociations.class;
        }

        @Override
        public void process(FaultGridAssociations module, double relWeight) {
            if (this.gridAverager == null) {
                this.gridAverager = new FaultGridAssociations.Averager();
                if (module instanceof PolygonFaultGridAssociations) {
                    if (module instanceof Precomputed) {
                        this.polys = ((Precomputed)module).polygons;
                    } else {
                        ImmutableMap.Builder polyBuilder = ImmutableMap.builder();
                        PolygonFaultGridAssociations associations = (PolygonFaultGridAssociations)module;
                        for (int sectIndex : associations.sectIndices()) {
                            polyBuilder.put((Object)sectIndex, (Object)associations.getPoly(sectIndex));
                        }
                        this.polys = polyBuilder.build();
                    }
                }
            } else if (this.polys != null) {
                if (module instanceof PolygonFaultGridAssociations) {
                    PolygonFaultGridAssociations associations = (PolygonFaultGridAssociations)module;
                    int numPolys = 0;
                    for (int sectIndex : associations.sectIndices()) {
                        Region poly = associations.getPoly(sectIndex);
                        if (poly == null) continue;
                        ++numPolys;
                        Region prevPoly = (Region)this.polys.get((Object)sectIndex);
                        if (prevPoly != null && prevPoly.equalsRegion(poly)) continue;
                        System.err.println("WARNING: poly mismatch for sect " + sectIndex + ", will average as simple FaultGridAssociations");
                        this.polys = null;
                        break;
                    }
                    if (this.polys != null && numPolys != this.polys.size()) {
                        System.err.println("WARNING: polys.size() mismatch, will average as simple FaultGridAssociations: " + numPolys + " != " + this.polys.size());
                        this.polys = null;
                    }
                } else {
                    System.err.println("WARNING: sub module doesn't have polys, will average as simple FaultGridAssociations");
                    this.polys = null;
                }
            }
            this.gridAverager.process(module, relWeight);
        }

        @Override
        public FaultGridAssociations getAverage() {
            FaultGridAssociations.Precomputed associations = this.gridAverager.getAverage();
            if (this.polys != null) {
                return new Precomputed(associations, (Map<Integer, Region>)this.polys);
            }
            System.err.println("WARNING: don't have average polys, returning a simple FaultGridAssociations");
            return associations;
        }
    }

    public static class Precomputed
    extends FaultGridAssociations.Precomputed
    implements PolygonFaultGridAssociations {
        private ImmutableMap<Integer, Region> polygons;
        private static final String ARCHIVE_SECT_POLYGONS_FILE_NAME = "sect_polygons.geojson";

        public Precomputed() {
        }

        public Precomputed(FaultGridAssociations associations, Map<Integer, Region> polygons) {
            super(associations);
            this.polygons = ImmutableMap.copyOf(polygons);
        }

        public Precomputed(PolygonFaultGridAssociations associations) {
            super(associations);
            ImmutableMap.Builder polyBuilder = ImmutableMap.builder();
            for (int sectIndex : associations.sectIndices()) {
                polyBuilder.put((Object)sectIndex, (Object)associations.getPoly(sectIndex));
            }
            this.polygons = polyBuilder.build();
        }

        @Override
        public String getName() {
            return "Polygon Fault Grid Associations";
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
            super.writeToArchive(output, entryPrefix);
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (int sectIndex = 0; sectIndex < this.polygons.size(); ++sectIndex) {
                Region polygon = (Region)this.polygons.get((Object)sectIndex);
                if (polygon == null) continue;
                Feature feature = polygon.toFeature();
                feature = new Feature(sectIndex, feature.geometry, feature.properties);
                features.add(feature);
            }
            FeatureCollection collection = new FeatureCollection(features);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(FileBackedModule.initOutputStream(output, entryPrefix, ARCHIVE_SECT_POLYGONS_FILE_NAME)));
            FeatureCollection.write(collection, writer);
            writer.flush();
            output.closeEntry();
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            super.initFromArchive(input, entryPrefix);
            BufferedInputStream polysIS = FileBackedModule.getInputStream(input, entryPrefix, ARCHIVE_SECT_POLYGONS_FILE_NAME);
            InputStreamReader regionReader = new InputStreamReader(polysIS);
            FeatureCollection features = FeatureCollection.read(regionReader);
            ImmutableMap.Builder polyBuilder = ImmutableMap.builder();
            for (Feature feature : features.features) {
                if (feature == null) continue;
                Preconditions.checkState((boolean)(feature.id instanceof Number), (Object)"Polygon feature must have integer ID polulated");
                int id = ((Number)feature.id).intValue();
                polyBuilder.put((Object)id, (Object)Region.fromFeature(feature));
            }
            this.polygons = polyBuilder.build();
        }

        @Override
        public Region getPoly(int sectIdx) {
            return (Region)this.polygons.get((Object)sectIdx);
        }
    }
}

