/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.util.TectonicRegionType;

public class RupSetTectonicRegimes
implements CSV_BackedModule,
SubModule<FaultSystemRupSet>,
BranchAverageableModule<RupSetTectonicRegimes>,
AverageableModule.ConstantAverageable<RupSetTectonicRegimes>,
SplittableRuptureModule<RupSetTectonicRegimes> {
    private FaultSystemRupSet rupSet;
    private TectonicRegionType[] regimes;
    public static final String DATA_FILE_NAME = "tectonic_regimes.csv";
    private EnumSet<TectonicRegionType> regimeSet;
    private static final DecimalFormat pDF = new DecimalFormat("0.00%");

    public static RupSetTectonicRegimes forCSV(FaultSystemRupSet rupSet, CSVFile<String> csv) {
        RupSetTectonicRegimes regimes = new RupSetTectonicRegimes();
        regimes.setParent(rupSet);
        regimes.initFromCSV(csv);
        return regimes;
    }

    public RupSetTectonicRegimes(FaultSystemRupSet rupSet, TectonicRegionType[] regimes) {
        if (rupSet != null) {
            Preconditions.checkState((rupSet.getNumRuptures() == regimes.length ? 1 : 0) != 0);
        }
        this.rupSet = rupSet;
        this.regimes = regimes;
    }

    public static RupSetTectonicRegimes constant(FaultSystemRupSet rupSet, TectonicRegionType regime) {
        TectonicRegionType[] regimes = new TectonicRegionType[rupSet.getNumRuptures()];
        for (int i = 0; i < regimes.length; ++i) {
            regimes[i] = regime;
        }
        return new RupSetTectonicRegimes(rupSet, regimes);
    }

    public static RupSetTectonicRegimes forRegions(FaultSystemRupSet rupSet, Map<Region, TectonicRegionType> regRegimes, TectonicRegionType fallback, double minFractInside) {
        TectonicRegionType[] regimes = new TectonicRegionType[rupSet.getNumRuptures()];
        RuptureSurface[] sectSurfs = new RuptureSurface[rupSet.getNumSections()];
        double[] sectAreas = new double[sectSurfs.length];
        for (int s = 0; s < sectSurfs.length; ++s) {
            sectSurfs[s] = rupSet.getFaultSectionData(s).getFaultSurface(1.0, false, false);
            sectAreas[s] = sectSurfs[s].getArea();
        }
        HashMap<Region, double[]> regSectAreasInside = new HashMap<Region, double[]>();
        for (Region reg : regRegimes.keySet()) {
            double[] areasInside = new double[sectSurfs.length];
            for (int s = 0; s < sectSurfs.length; ++s) {
                FaultSection sect = rupSet.getFaultSectionData(s);
                boolean traceContains = false;
                for (Object loc : sect.getFaultTrace()) {
                    if (!reg.contains((Location)loc)) continue;
                    traceContains = true;
                    break;
                }
                if (!traceContains) continue;
                areasInside[s] = sectSurfs[s].getAreaInsideRegion(reg);
            }
            regSectAreasInside.put(reg, areasInside);
        }
        EnumMap<TectonicRegionType, Integer> mappedCounts = new EnumMap<TectonicRegionType, Integer>(TectonicRegionType.class);
        for (int r = 0; r < regimes.length; ++r) {
            double sumArea = 0.0;
            List<Integer> sects = rupSet.getSectionsIndicesForRup(r);
            for (int sectIndex : sects) {
                sumArea += sectAreas[sectIndex];
            }
            double maxFract = 0.0;
            for (Region reg : regRegimes.keySet()) {
                double fract;
                double[] sectAreasInside = (double[])regSectAreasInside.get(reg);
                double areaIn = 0.0;
                for (int sectIndex : sects) {
                    areaIn += sectAreasInside[sectIndex];
                }
                if (!(areaIn > 0.0) || !((fract = areaIn / sumArea) > maxFract) || !((float)fract >= (float)minFractInside)) continue;
                maxFract = fract;
                regimes[r] = regRegimes.get(reg);
            }
            if (regimes[r] == null) {
                regimes[r] = fallback;
            }
            if (regimes[r] == null) continue;
            Integer prevCount = (Integer)mappedCounts.get(regimes[r]);
            if (prevCount == null) {
                prevCount = 0;
            }
            mappedCounts.put(regimes[r], prevCount + 1);
        }
        for (TectonicRegionType trt : mappedCounts.keySet()) {
            int count = (Integer)mappedCounts.get(trt);
            System.out.println("Mapped " + count + "/" + regimes.length + " (" + pDF.format((double)count / (double)regimes.length) + ") to " + trt.name());
        }
        return new RupSetTectonicRegimes(rupSet, regimes);
    }

    public synchronized Set<TectonicRegionType> getSet() {
        if (this.regimeSet == null) {
            this.regimeSet = EnumSet.noneOf(TectonicRegionType.class);
            for (TectonicRegionType trt : this.regimes) {
                this.regimeSet.add(trt);
            }
        }
        return Collections.unmodifiableSet(this.regimeSet);
    }

    private RupSetTectonicRegimes() {
    }

    @Override
    public String getFileName() {
        return DATA_FILE_NAME;
    }

    public TectonicRegionType get(int rupIndex) {
        return this.regimes[rupIndex];
    }

    @Override
    public String getName() {
        return "Rupture Tectonic Regimes";
    }

    @Override
    public CSVFile<?> getCSV() {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Rupture Index", "Tectonic Regime");
        for (int r = 0; r < this.regimes.length; ++r) {
            TectonicRegionType type = this.regimes[r];
            if (type == null) {
                csv.addLine("" + r, "");
                continue;
            }
            csv.addLine("" + r, type.name());
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        Preconditions.checkNotNull((Object)this.rupSet, (Object)"Rupture set must be attached before initialization");
        this.regimes = new TectonicRegionType[this.rupSet.getNumRuptures()];
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int index = csv.getInt(row, 0);
            Preconditions.checkState((index >= 0 && index < this.regimes.length ? 1 : 0) != 0, (String)"Bad rupture index encountered: %s, numRups=%s", (int)index, (int)this.regimes.length);
            String regimeStr = csv.get(row, 1);
            this.regimes[index] = regimeStr.isBlank() ? null : TectonicRegionType.valueOf(regimeStr);
        }
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        if (this.regimes != null && parent != null) {
            Preconditions.checkState((this.regimes.length == parent.getNumRuptures() ? 1 : 0) != 0);
        }
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    public RupSetTectonicRegimes copy(FaultSystemRupSet newParent) throws IllegalStateException {
        return new RupSetTectonicRegimes(newParent, this.regimes);
    }

    @Override
    public Class<RupSetTectonicRegimes> getAveragingType() {
        return RupSetTectonicRegimes.class;
    }

    @Override
    public boolean isIdentical(RupSetTectonicRegimes module) {
        return Arrays.equals(this.regimes, module.regimes);
    }

    @Override
    public RupSetTectonicRegimes getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
        TectonicRegionType[] trts = new TectonicRegionType[rupSubSet.getNumRuptures()];
        for (int r = 0; r < trts.length; ++r) {
            trts[r] = this.regimes[mappings.getOrigRupID(r)];
        }
        return new RupSetTectonicRegimes(rupSubSet, trts);
    }

    @Override
    public RupSetTectonicRegimes getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
        TectonicRegionType[] trts = new TectonicRegionType[splitRupSet.getNumRuptures()];
        for (int r = 0; r < trts.length; ++r) {
            trts[r] = this.regimes[mappings.getOrigRupID(r)];
        }
        return new RupSetTectonicRegimes(splitRupSet, trts);
    }
}

