/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.modules.helpers.JSON_BackedModule;

public class RuptureSetSplitMappings
implements JSON_BackedModule {
    private Map<Integer, Integer> sectIDs_newToOld;
    private Map<Integer, List<Integer>> sectIDs_oldToNew;
    private Map<Integer, Double> sectSplitWeights;
    private Map<Integer, Integer> rupIDs_newToOld;
    private Map<Integer, List<Integer>> rupIDs_oldToNew;
    private Map<Integer, Double> rupSplitWeights;

    private RuptureSetSplitMappings() {
    }

    public RuptureSetSplitMappings(Map<Integer, List<Integer>> sectIDs_oldToNew, Map<Integer, List<Integer>> rupIDs_oldToNew) {
        this(sectIDs_oldToNew, null, rupIDs_oldToNew, null);
    }

    public RuptureSetSplitMappings(Map<Integer, List<Integer>> sectIDs_oldToNew, Map<Integer, Double> sectSplitWeights, Map<Integer, List<Integer>> rupIDs_oldToNew, Map<Integer, Double> rupSplitWeights) {
        this.sectIDs_oldToNew = sectIDs_oldToNew;
        this.sectIDs_newToOld = RuptureSetSplitMappings.inverse(sectIDs_oldToNew);
        this.sectSplitWeights = sectSplitWeights;
        this.rupIDs_oldToNew = rupIDs_oldToNew;
        this.rupIDs_newToOld = RuptureSetSplitMappings.inverse(rupIDs_oldToNew);
        this.rupSplitWeights = rupSplitWeights;
    }

    private static Map<Integer, Integer> inverse(Map<Integer, List<Integer>> oldToNew) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Integer oldID : oldToNew.keySet()) {
            for (Integer newID : oldToNew.get(oldID)) {
                Preconditions.checkState((!ret.containsKey(newID) ? 1 : 0) != 0);
                ret.put(newID, oldID);
            }
        }
        return ret;
    }

    public List<Integer> getNewSectIDs(int origSectID) {
        return this.sectIDs_oldToNew.get(origSectID);
    }

    public Double getNewSectWeight(int newSectID) {
        return RuptureSetSplitMappings.getNewWeights(newSectID, this.sectIDs_oldToNew, this.sectIDs_newToOld, this.sectSplitWeights);
    }

    private static Double getNewWeights(int newID, Map<Integer, List<Integer>> oldToNew, Map<Integer, Integer> newToOld, Map<Integer, Double> weightsMap) {
        if (weightsMap != null) {
            Double weight = weightsMap.get(newID);
            if (weight == null) {
                int origID = newToOld.get(newID);
                Preconditions.checkState((oldToNew.get(origID).size() == 1 ? 1 : 0) != 0);
                return 1.0;
            }
            return weight;
        }
        int origID = newToOld.get(newID);
        List<Integer> allNewIDs = oldToNew.get(origID);
        if (allNewIDs.size() == 1) {
            return 1.0;
        }
        return 1.0 / (double)allNewIDs.size();
    }

    public int getOrigSectID(int newSectID) {
        return this.sectIDs_newToOld.get(newSectID);
    }

    public List<Integer> getNewRupIDs(int origRupID) {
        return this.rupIDs_oldToNew.get(origRupID);
    }

    public Double getNewRupWeight(int newRupID) {
        return RuptureSetSplitMappings.getNewWeights(newRupID, this.rupIDs_oldToNew, this.rupIDs_newToOld, this.rupSplitWeights);
    }

    public int getOrigRupID(int newRupID) {
        return this.rupIDs_newToOld.get(newRupID);
    }

    public int getNewNumRuptures() {
        return this.rupIDs_newToOld.size();
    }

    public int getNewNumSections() {
        return this.sectIDs_newToOld.size();
    }

    @Override
    public String getName() {
        return "Rupture Set Split Mappings";
    }

    @Override
    public String getFileName() {
        return "rupture_set_split_mappings.json";
    }

    @Override
    public void writeToJSON(JsonWriter out, Gson gson) throws IOException {
        out.beginObject();
        out.name("sectIDs_oldToNew");
        RuptureSetSplitMappings.writeIntListMapJSON(out, this.sectIDs_oldToNew);
        if (this.sectSplitWeights != null) {
            out.name("sectSplitWeights");
            RuptureSetSplitMappings.writeDoubleMapJSON(out, this.sectSplitWeights);
        }
        out.name("rupIDs_oldToNew");
        RuptureSetSplitMappings.writeIntListMapJSON(out, this.rupIDs_oldToNew);
        if (this.rupSplitWeights != null) {
            out.name("rupSplitWeights");
            RuptureSetSplitMappings.writeDoubleMapJSON(out, this.rupSplitWeights);
        }
        out.endObject();
    }

    private static void writeIntListMapJSON(JsonWriter out, Map<Integer, List<Integer>> map) throws IOException {
        out.beginArray();
        for (Integer key : map.keySet()) {
            out.beginArray();
            out.value((long)key.intValue());
            for (int val : map.get(key)) {
                out.value((long)val);
            }
            out.endArray();
        }
        out.endArray();
    }

    private static void writeDoubleMapJSON(JsonWriter out, Map<Integer, Double> map) throws IOException {
        out.beginArray();
        for (Integer key : map.keySet()) {
            out.beginArray();
            out.value((long)key.intValue());
            out.value(map.get(key).doubleValue());
            out.endArray();
        }
        out.endArray();
    }

    private static Map<Integer, List<Integer>> readIntListMapJSON(JsonReader in) throws IOException {
        HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>();
        in.beginArray();
        while (in.hasNext()) {
            in.beginArray();
            int key = in.nextInt();
            ArrayList<Integer> vals = new ArrayList<Integer>();
            while (in.hasNext()) {
                vals.add(in.nextInt());
            }
            Preconditions.checkState((!vals.isEmpty() ? 1 : 0) != 0);
            map.put(key, vals);
            in.endArray();
        }
        in.endArray();
        return map;
    }

    private static Map<Integer, Double> readDoubleMapJSON(JsonReader in) throws IOException {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        in.beginArray();
        while (in.hasNext()) {
            in.beginArray();
            int key = in.nextInt();
            map.put(key, in.nextDouble());
            in.endArray();
        }
        in.endArray();
        return map;
    }

    @Override
    public void initFromJSON(JsonReader in, Gson gson) throws IOException {
        in.beginObject();
        block12: while (in.hasNext()) {
            switch (in.nextName()) {
                case "sectIDs_oldToNew": {
                    this.sectIDs_oldToNew = RuptureSetSplitMappings.readIntListMapJSON(in);
                    continue block12;
                }
                case "sectSplitWeights": {
                    this.sectSplitWeights = RuptureSetSplitMappings.readDoubleMapJSON(in);
                    continue block12;
                }
                case "rupIDs_oldToNew": {
                    this.rupIDs_oldToNew = RuptureSetSplitMappings.readIntListMapJSON(in);
                    continue block12;
                }
                case "rupSplitWeights": {
                    this.rupSplitWeights = RuptureSetSplitMappings.readDoubleMapJSON(in);
                    continue block12;
                }
            }
            in.skipValue();
        }
        Preconditions.checkNotNull(this.sectIDs_newToOld);
        Preconditions.checkNotNull(this.rupIDs_newToOld);
        in.endObject();
    }
}

