/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;

public abstract class SectSlipRates
implements SubModule<FaultSystemRupSet>,
BranchAverageableModule<SectSlipRates>,
SplittableRuptureModule<SectSlipRates> {
    protected FaultSystemRupSet parent;
    public static final String DATA_FILE_NAME = "sect_slip_rates.csv";

    private SectSlipRates(FaultSystemRupSet parent) {
        this.parent = parent;
    }

    public static SectSlipRates precomputed(FaultSystemRupSet rupSet, double[] slipRates, double[] slipRateStdDevs) {
        return new Precomputed(rupSet, slipRates, slipRateStdDevs);
    }

    public static SectSlipRates fromFaultSectData(FaultSystemRupSet rupSet) {
        return new Default(rupSet);
    }

    public abstract double getSlipRate(int var1);

    public double[] getSlipRates() {
        FaultSystemRupSet rupSet = this.getParent();
        Preconditions.checkNotNull((Object)rupSet, (Object)"parent rupture set not set");
        double[] ret = new double[rupSet.getNumSections()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getSlipRate(i);
        }
        return ret;
    }

    public int size() {
        return this.parent.getNumSections();
    }

    public abstract double getSlipRateStdDev(int var1);

    public double[] getSlipRateStdDevs() {
        FaultSystemRupSet rupSet = this.getParent();
        Preconditions.checkNotNull((Object)rupSet, (Object)"parent rupture set not set");
        double[] ret = new double[rupSet.getNumSections()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getSlipRateStdDev(i);
        }
        return ret;
    }

    public double calcTotalMomentRate() {
        FaultSystemRupSet rupSet = this.getParent();
        Preconditions.checkNotNull((Object)rupSet, (Object)"parent rupture set not set");
        double totMomentRate = 0.0;
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            totMomentRate += FaultMomentCalc.getMoment(rupSet.getAreaForSection(s), this.getSlipRate(s));
        }
        return totMomentRate;
    }

    public double calcMomentRate(int sectIndex) {
        FaultSystemRupSet rupSet = this.getParent();
        Preconditions.checkNotNull((Object)rupSet, (Object)"parent rupture set not set");
        return FaultMomentCalc.getMoment(rupSet.getAreaForSection(sectIndex), this.getSlipRate(sectIndex));
    }

    @Override
    public String getName() {
        return "Section Slip Rates";
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        this.parent = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.parent;
    }

    public static class Precomputed
    extends SectSlipRates
    implements CSV_BackedModule {
        private double[] slipRates;
        private double[] slipRateStdDevs;

        private Precomputed() {
            super(null);
        }

        private Precomputed(FaultSystemRupSet rupSet, double[] slipRates, double[] slipRateStdDevs) {
            super(rupSet);
            int numSects = rupSet.getNumSections();
            Preconditions.checkState((slipRates == null || slipRates.length == numSects ? 1 : 0) != 0, (Object)"Num slip rates != num sections");
            Preconditions.checkState((slipRateStdDevs == null || slipRateStdDevs.length == numSects ? 1 : 0) != 0, (Object)"Num slip rates std devs != num sections");
            this.slipRates = slipRates;
            this.slipRateStdDevs = slipRateStdDevs;
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
            Preconditions.checkNotNull((Object)newParent);
            if (this.slipRates != null) {
                Preconditions.checkState((newParent.getNumSections() == this.slipRates.length ? 1 : 0) != 0);
            }
            if (this.slipRateStdDevs != null) {
                Preconditions.checkState((newParent.getNumSections() == this.slipRateStdDevs.length ? 1 : 0) != 0);
            }
            return new Precomputed(newParent, this.slipRates, this.slipRateStdDevs);
        }

        @Override
        public double getSlipRate(int sectIndex) {
            return this.slipRates == null ? Double.NaN : this.slipRates[sectIndex];
        }

        @Override
        public double[] getSlipRates() {
            return this.slipRates;
        }

        @Override
        public double[] getSlipRateStdDevs() {
            return this.slipRateStdDevs;
        }

        @Override
        public double getSlipRateStdDev(int sectIndex) {
            return this.slipRateStdDevs == null ? Double.NaN : this.slipRateStdDevs[sectIndex];
        }

        @Override
        public String getFileName() {
            return SectSlipRates.DATA_FILE_NAME;
        }

        @Override
        public CSVFile<?> getCSV() {
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Section Index", "Slip Rate (m/yr)", "Slip Rate Standard Deviation (m/yr)");
            int numSections = ((FaultSystemRupSet)this.getParent()).getNumSections();
            for (int s = 0; s < numSections; ++s) {
                csv.addLine("" + s, "" + this.getSlipRate(s), "" + this.getSlipRateStdDev(s));
            }
            return csv;
        }

        @Override
        public void initFromCSV(CSVFile<String> csv) {
            int numSects = ((FaultSystemRupSet)this.getParent()).getNumSections();
            Preconditions.checkState((csv.getNumRows() == numSects + 1 ? 1 : 0) != 0, (String)"Expected 1 header row and %s section rows, have %s", (int)numSects, (int)csv.getNumRows());
            double[] slipRates = new double[numSects];
            double[] slipRateStdDevs = new double[numSects];
            for (int s = 0; s < numSects; ++s) {
                int row = s + 1;
                Preconditions.checkState((csv.getInt(row, 0) == s ? 1 : 0) != 0, (Object)"Rows out of order or not 0-based");
                slipRates[s] = csv.getDouble(row, 1);
                slipRateStdDevs[s] = csv.getDouble(row, 2);
            }
            this.slipRates = slipRates;
            this.slipRateStdDevs = slipRateStdDevs;
        }

        @Override
        public AverageableModule.AveragingAccumulator<SectSlipRates> averagingAccumulator() {
            return new AverageableModule.AveragingAccumulator<SectSlipRates>(){
                private double[] slipRates = null;
                private double[] slipRateStdDevs = null;
                private double totWeight = 0.0;

                @Override
                public void process(SectSlipRates module, double relWeight) {
                    if (this.slipRates == null) {
                        this.slipRates = new double[module.getSlipRates().length];
                        this.slipRateStdDevs = new double[this.slipRates.length];
                    }
                    for (int i = 0; i < this.slipRates.length; ++i) {
                        int n = i;
                        this.slipRates[n] = this.slipRates[n] + module.getSlipRate(i) * relWeight;
                        int n2 = i;
                        this.slipRateStdDevs[n2] = this.slipRateStdDevs[n2] + module.getSlipRateStdDev(i) * relWeight;
                    }
                    this.totWeight += relWeight;
                }

                @Override
                public SectSlipRates getAverage() {
                    AverageableModule.scaleToTotalWeight(this.slipRates, this.totWeight);
                    AverageableModule.scaleToTotalWeight(this.slipRateStdDevs, this.totWeight);
                    Precomputed ret = new Precomputed();
                    ret.slipRates = this.slipRates;
                    ret.slipRateStdDevs = this.slipRateStdDevs;
                    return ret;
                }

                @Override
                public Class<SectSlipRates> getType() {
                    return SectSlipRates.class;
                }
            };
        }

        @Override
        public Precomputed getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            double[] filteredSlipRateStdDevs;
            double[] filteredSlipRates = this.slipRates == null ? null : new double[rupSubSet.getNumSections()];
            double[] dArray = filteredSlipRateStdDevs = this.slipRateStdDevs == null ? null : new double[rupSubSet.getNumSections()];
            if (filteredSlipRates == null && filteredSlipRateStdDevs == null) {
                return null;
            }
            for (int s = 0; s < rupSubSet.getNumSections(); ++s) {
                int origID = mappings.getOrigSectID(s);
                if (filteredSlipRates != null) {
                    filteredSlipRates[s] = this.slipRates[origID];
                }
                if (filteredSlipRateStdDevs == null) continue;
                filteredSlipRateStdDevs[s] = this.slipRateStdDevs[origID];
            }
            return new Precomputed(rupSubSet, filteredSlipRates, filteredSlipRateStdDevs);
        }

        @Override
        public SectSlipRates getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            double[] filteredSlipRateStdDevs;
            double[] filteredSlipRates = this.slipRates == null ? null : new double[splitRupSet.getNumSections()];
            double[] dArray = filteredSlipRateStdDevs = this.slipRateStdDevs == null ? null : new double[splitRupSet.getNumSections()];
            if (filteredSlipRates == null && filteredSlipRateStdDevs == null) {
                return null;
            }
            for (int s = 0; s < splitRupSet.getNumSections(); ++s) {
                int origID = mappings.getOrigSectID(s);
                double weight = mappings.getNewSectWeight(s);
                if (filteredSlipRates != null) {
                    filteredSlipRates[s] = weight * this.slipRates[origID];
                }
                if (filteredSlipRateStdDevs == null) continue;
                filteredSlipRateStdDevs[s] = weight * this.slipRateStdDevs[origID];
            }
            return new Precomputed(splitRupSet, filteredSlipRates, filteredSlipRateStdDevs);
        }
    }

    public static class Default
    extends SectSlipRates
    implements SubModule<FaultSystemRupSet> {
        private Default(FaultSystemRupSet rupSet) {
            super(rupSet);
        }

        public SectSlipRates copy(FaultSystemRupSet newParent) throws IllegalStateException {
            Preconditions.checkNotNull((Object)newParent);
            return new Default(newParent);
        }

        @Override
        public double getSlipRate(int sectIndex) {
            return this.parent.getFaultSectionData(sectIndex).getReducedAveSlipRate() * 0.001;
        }

        @Override
        public double getSlipRateStdDev(int sectIndex) {
            return this.parent.getFaultSectionData(sectIndex).getReducedSlipRateStdDev() * 0.001;
        }

        @Override
        public AverageableModule.AveragingAccumulator<SectSlipRates> averagingAccumulator() {
            return new Precomputed(this.parent, this.getSlipRates(), this.getSlipRateStdDevs()).averagingAccumulator();
        }

        @Override
        public SectSlipRates getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            return this.copy(rupSubSet);
        }

        @Override
        public SectSlipRates getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            return this.copy(splitRupSet);
        }
    }
}

