/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;

public class ReportMetadata {
    public final RupSetMetadata primary;
    public final RupSetOverlap primaryOverlap;
    public final RupSetMetadata comparison;
    public final RupSetOverlap comparisonOverlap;
    public final boolean comparisonHasSameSects;
    public final Region region;

    public ReportMetadata(RupSetMetadata primary) {
        this(primary, null);
    }

    public ReportMetadata(RupSetMetadata primary, RupSetMetadata comparison) {
        this(primary, comparison, null);
    }

    public ReportMetadata(RupSetMetadata primary, RupSetMetadata comparison, Region region) {
        Preconditions.checkNotNull((Object)primary);
        this.primary = primary;
        this.comparison = comparison;
        if (comparison == null) {
            this.primaryOverlap = null;
            this.comparisonOverlap = null;
            this.comparisonHasSameSects = false;
        } else {
            this.comparisonHasSameSects = primary.rupSet.areSectionsEquivalentTo(comparison.rupSet);
            this.primaryOverlap = new RupSetOverlap(primary, comparison, this.comparisonHasSameSects);
            this.comparisonOverlap = new RupSetOverlap(comparison, primary, this.comparisonHasSameSects);
        }
        if (region == null) {
            region = ReportMetadata.detectRegion(primary);
            if (region == null && comparison != null) {
                region = ReportMetadata.detectRegion(comparison);
            }
            if (region == null) {
                region = RupSetMapMaker.buildBufferedRegion(primary.rupSet.getFaultSectionDataList());
            }
        }
        this.region = region;
    }

    public static Region detectRegion(RupSetMetadata meta) {
        return ReportMetadata.detectRegion(meta.rupSet, meta.sol);
    }

    public static Region detectRegion(FaultSystemRupSet rupSet) {
        return ReportMetadata.detectRegion(rupSet, null);
    }

    public static Region detectRegion(FaultSystemSolution sol) {
        return ReportMetadata.detectRegion(sol.getRupSet(), sol);
    }

    private static Region detectRegion(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        GridSourceProvider gridProv;
        GriddedRegion gridReg;
        if (rupSet.hasModule(ModelRegion.class)) {
            return rupSet.requireModule(ModelRegion.class).getRegion();
        }
        if (ReportPageGen.getUCERF3FM(rupSet) != null) {
            return new CaliforniaRegions.RELM_TESTING();
        }
        if (rupSet.hasModule(FaultGridAssociations.class)) {
            return new Region(rupSet.getModule(FaultGridAssociations.class).getRegion());
        }
        if (sol != null && sol.hasModule(GridSourceProvider.class) && (gridReg = (gridProv = sol.requireModule(GridSourceProvider.class)).getGriddedRegion()) != null) {
            return gridReg;
        }
        return null;
    }

    public boolean hasComparison() {
        return this.comparison != null;
    }

    public boolean hasComparisonSol() {
        return this.comparison != null && this.comparison.sol != null;
    }

    public boolean hasPrimarySol() {
        return this.primary.sol != null;
    }

    public boolean hasAnySol() {
        return this.hasPrimarySol() || this.hasComparisonSol();
    }

    public static class RupSetOverlap {
        public final int numCommonRuptures;
        public final int numUniqueRuptures;
        public final transient HashSet<Integer> commonIndexes = new HashSet();
        public final transient HashSet<Integer> uniqueIndexes = new HashSet();
        public final transient HashSet<UniqueRupture> commonUniques = new HashSet();
        public final transient HashSet<UniqueRupture> uniqueUniques = new HashSet();
        public final double commonRuptureRate;
        public final double uniqueRuptureRate;
        public final int numCommonJumps;
        public final transient HashSet<Jump> commonJumps;
        public final int numUniqueJumps;
        public final transient HashSet<Jump> uniqueJumps;

        public RupSetOverlap(RupSetMetadata meta, RupSetMetadata comp, boolean sameSects) {
            if (sameSects) {
                double commonRuptureRate = Double.NaN;
                double uniqueRuptureRate = Double.NaN;
                if (meta.sol != null) {
                    commonRuptureRate = 0.0;
                    uniqueRuptureRate = 0.0;
                }
                HashSet<UniqueRupture> compUniques = new HashSet<UniqueRupture>(comp.uniques);
                for (int r = 0; r < meta.numRuptures; ++r) {
                    UniqueRupture unique = meta.uniques.get(r);
                    if (compUniques.contains(unique)) {
                        this.commonUniques.add(unique);
                        this.commonIndexes.add(r);
                        if (meta.sol == null) continue;
                        commonRuptureRate += meta.sol.getRateForRup(r);
                        continue;
                    }
                    this.uniqueUniques.add(unique);
                    this.uniqueIndexes.add(r);
                    if (meta.sol == null) continue;
                    uniqueRuptureRate += meta.sol.getRateForRup(r);
                }
                this.numCommonRuptures = this.commonIndexes.size();
                this.numUniqueRuptures = this.uniqueIndexes.size();
                this.commonRuptureRate = commonRuptureRate;
                this.uniqueRuptureRate = uniqueRuptureRate;
                this.commonJumps = new HashSet();
                this.uniqueJumps = new HashSet();
                for (Jump jump : meta.jumps) {
                    if (comp.jumps.contains(jump)) {
                        this.commonJumps.add(jump);
                        continue;
                    }
                    this.uniqueJumps.add(jump);
                }
                this.numCommonJumps = this.commonJumps.size();
                this.numUniqueJumps = this.uniqueJumps.size();
            } else {
                double commonRuptureRate = Double.NaN;
                double uniqueRuptureRate = Double.NaN;
                if (meta.sol != null) {
                    commonRuptureRate = 0.0;
                    uniqueRuptureRate = meta.sol.getTotalFaultSolutionMomentRate();
                }
                this.numCommonRuptures = 0;
                this.numUniqueRuptures = 0;
                this.commonRuptureRate = commonRuptureRate;
                this.uniqueRuptureRate = uniqueRuptureRate;
                this.commonJumps = new HashSet();
                this.uniqueJumps = new HashSet();
                this.numCommonJumps = 0;
                this.numUniqueJumps = 0;
            }
        }
    }
}

