/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPolygonAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public class JumpAzimuthsPlot
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "Jump Azimuths";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<RupHistogramPlots.RakeType> rakeTypes = new ArrayList<RupHistogramPlots.RakeType>();
        rakeTypes.add(null);
        for (RupHistogramPlots.RakeType type : RupHistogramPlots.RakeType.values()) {
            rakeTypes.add(type);
        }
        Table<RupHistogramPlots.RakeType, RupHistogramPlots.RakeType, List<Double>> inputRakeAzTable = JumpAzimuthsPlot.calcJumpAzimuths(rupSet);
        Table<RupHistogramPlots.RakeType, RupHistogramPlots.RakeType, List<Double>> compRakeAzTable = null;
        if (meta.comparison != null) {
            compRakeAzTable = JumpAzimuthsPlot.calcJumpAzimuths(meta.comparison.rupSet);
        }
        for (RupHistogramPlots.RakeType sourceType : rakeTypes) {
            Object title;
            Object prefix;
            if (sourceType == null) {
                prefix = "jump_az_any";
                title = "Jumps from Any";
                lines.add(this.getSubHeading() + " Jump Azimuths From Any");
            } else {
                prefix = "jump_az_" + sourceType.prefix;
                title = "Jumps from " + sourceType.name;
                lines.add(this.getSubHeading() + " Jump Azimuths From " + sourceType.name);
            }
            System.out.println("Plotting " + (String)title);
            lines.add(topLink);
            lines.add("");
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            if (meta.comparison != null) {
                table.addLine(meta.primary.name, meta.comparison.name);
            }
            table.initNewLine();
            File plotFile = JumpAzimuthsPlot.plotJumpAzimuths(sourceType, rakeTypes, inputRakeAzTable, resourcesDir, (String)prefix, (String)title);
            table.addColumn("![" + (String)title + "](" + relPathToResources + "/" + plotFile.getName() + ")");
            if (meta.comparison != null) {
                plotFile = JumpAzimuthsPlot.plotJumpAzimuths(sourceType, rakeTypes, compRakeAzTable, resourcesDir, (String)prefix + "_comp", (String)title);
                table.addColumn("![" + (String)title + "](" + relPathToResources + "/" + plotFile.getName() + ")");
            }
            table.finalizeLine();
            lines.addAll(table.build());
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            for (RupHistogramPlots.RakeType destType : rakeTypes) {
                String myPrefix = (String)prefix + "_";
                String myTitle = (String)title + " to ";
                if (destType == null) {
                    myPrefix = myPrefix + "any";
                    myTitle = myTitle + "Any";
                } else {
                    myPrefix = myPrefix + destType.prefix;
                    myTitle = myTitle + destType.name;
                }
                plotFile = JumpAzimuthsPlot.plotJumpAzimuthsRadial(sourceType, destType, inputRakeAzTable, resourcesDir, myPrefix, myTitle);
                table.addColumn("![" + (String)title + "](" + relPathToResources + "/" + plotFile.getName() + ")");
            }
            table.finalizeLine();
            lines.addAll(table.wrap(3, 0).build());
            lines.add("");
        }
        return lines;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(SectionDistanceAzimuthCalculator.class, ClusterRuptures.class);
    }

    public static Table<RupHistogramPlots.RakeType, RupHistogramPlots.RakeType, List<Double>> calcJumpAzimuths(FaultSystemRupSet rupSet) {
        SectionDistanceAzimuthCalculator distAzCalc = rupSet.getModule(SectionDistanceAzimuthCalculator.class);
        ClusterRuptures rups = rupSet.getModule(ClusterRuptures.class);
        JumpAzimuthChangeFilter.SimpleAzimuthCalc azCalc = new JumpAzimuthChangeFilter.SimpleAzimuthCalc(distAzCalc);
        HashBasedTable ret = HashBasedTable.create();
        for (RupHistogramPlots.RakeType r1 : RupHistogramPlots.RakeType.values()) {
            for (RupHistogramPlots.RakeType rakeType : RupHistogramPlots.RakeType.values()) {
                ret.put((Object)r1, (Object)rakeType, new ArrayList());
            }
        }
        for (ClusterRupture rup : rups) {
            RuptureTreeNavigator navigator = rup.getTreeNavigator();
            for (Jump jump : rup.getJumpsIterable()) {
                RupHistogramPlots.RakeType sourceRake = null;
                RupHistogramPlots.RakeType destRake = null;
                for (RupHistogramPlots.RakeType type : RupHistogramPlots.RakeType.values()) {
                    if (type.isMatch(jump.fromSection.getAveRake())) {
                        sourceRake = type;
                    }
                    if (!type.isMatch(jump.toSection.getAveRake())) continue;
                    destRake = type;
                }
                Preconditions.checkNotNull(sourceRake);
                Preconditions.checkNotNull(destRake);
                FaultSection faultSection = navigator.getPredecessor(jump.fromSection);
                if (faultSection == null) continue;
                FaultSection before2 = jump.fromSection;
                double beforeAz = azCalc.calcAzimuth(faultSection, before2);
                FaultSection after1 = jump.toSection;
                for (FaultSection after2 : navigator.getDescendants(after1)) {
                    double dipDir;
                    double dipDirDiff;
                    double afterAz = azCalc.calcAzimuth(after1, after2);
                    double rawDiff = JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz);
                    Preconditions.checkState((rawDiff >= -180.0 && rawDiff <= 180.0 ? 1 : 0) != 0);
                    double[] azDiffs = (float)before2.getAveDip() == 90.0f ? new double[]{rawDiff, -rawDiff} : ((dipDirDiff = JumpAzimuthChangeFilter.getAzimuthDifference(dipDir = (double)before2.getDipDirection(), beforeAz)) < 0.0 ? new double[]{rawDiff} : new double[]{-rawDiff});
                    for (double azDiff : azDiffs) {
                        ((List)ret.get((Object)sourceRake, (Object)destRake)).add(azDiff);
                    }
                }
            }
        }
        return ret;
    }

    public static Map<RupHistogramPlots.RakeType, List<Double>> getAzimuthsFrom(RupHistogramPlots.RakeType sourceRake, Table<RupHistogramPlots.RakeType, RupHistogramPlots.RakeType, List<Double>> azTable) {
        HashMap<RupHistogramPlots.RakeType, List<Double>> azMap;
        if (sourceRake == null) {
            azMap = new HashMap();
            for (RupHistogramPlots.RakeType type : RupHistogramPlots.RakeType.values()) {
                azMap.put(type, new ArrayList());
            }
            for (RupHistogramPlots.RakeType source : RupHistogramPlots.RakeType.values()) {
                Map row = azTable.row((Object)source);
                for (RupHistogramPlots.RakeType dest : row.keySet()) {
                    ((List)azMap.get((Object)dest)).addAll((Collection)row.get((Object)dest));
                }
            }
        } else {
            azMap = azTable.row((Object)sourceRake);
        }
        return azMap;
    }

    public static File plotJumpAzimuths(RupHistogramPlots.RakeType sourceRake, List<RupHistogramPlots.RakeType> destRakes, Table<RupHistogramPlots.RakeType, RupHistogramPlots.RakeType, List<Double>> azTable, File outputDir, String prefix, String title) throws IOException {
        Map<RupHistogramPlots.RakeType, List<Double>> azMap = JumpAzimuthsPlot.getAzimuthsFrom(sourceRake, azTable);
        Range xRange = new Range(-180.0, 180.0);
        ArrayList<Range> xRanges = new ArrayList<Range>();
        xRanges.add(xRange);
        ArrayList<Range> yRanges = new ArrayList<Range>();
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        for (int i = 0; i < destRakes.size(); ++i) {
            String label;
            Color color;
            RupHistogramPlots.RakeType destRake = destRakes.get(i);
            HistogramFunction hist = HistogramFunction.getEncompassingHistogram(-179.0, 179.0, 15.0);
            for (RupHistogramPlots.RakeType oRake : azMap.keySet()) {
                if (destRake != null && destRake != oRake) continue;
                for (double azDiff : azMap.get((Object)oRake)) {
                    hist.add(hist.getClosestXIndex(azDiff), 1.0);
                }
            }
            if (destRake == null) {
                color = Color.DARK_GRAY;
                label = "Any";
            } else {
                color = destRake.color;
                label = destRake.name;
            }
            ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(hist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
            double maxY = Math.max(1.1 * hist.getMaxY(), 1.0);
            Range yRange = new Range(0.0, maxY);
            PlotSpec spec = new PlotSpec(funcs, chars, title, "Azimuthal Difference", "Count");
            XYTextAnnotation ann = new XYTextAnnotation("To " + label, 175.0, maxY * 0.975);
            ann.setFont(new Font("SansSerif", 1, 24));
            ann.setTextAnchor(TextAnchor.TOP_RIGHT);
            spec.addPlotAnnotation((XYAnnotation)ann);
            specs.add(spec);
            yRanges.add(yRange);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(24);
        gp.setBackgroundColor(Color.WHITE);
        gp.drawGraphPanel(specs, false, false, xRanges, yRanges);
        File pngFile = new File(outputDir, prefix + ".png");
        File pdfFile = new File(outputDir, prefix + ".pdf");
        File txtFile = new File(outputDir, prefix + ".txt");
        gp.getChartPanel().setSize(700, 1000);
        gp.saveAsPNG(pngFile.getAbsolutePath());
        gp.saveAsPDF(pdfFile.getAbsolutePath());
        gp.saveAsTXT(txtFile.getAbsolutePath());
        return pngFile;
    }

    private static double azDiffDegreesToAngleRad(double azDiff) {
        Preconditions.checkState(((float)azDiff >= -180.0f && (float)azDiff <= 180.0f ? 1 : 0) != 0, (String)"Bad azDiff: %s", (Object)azDiff);
        azDiff *= -1.0;
        return Math.toRadians(azDiff += 90.0);
    }

    public static File plotJumpAzimuthsRadial(RupHistogramPlots.RakeType sourceRake, RupHistogramPlots.RakeType destRake, Table<RupHistogramPlots.RakeType, RupHistogramPlots.RakeType, List<Double>> azTable, File outputDir, String prefix, String title) throws IOException {
        System.out.println("Plotting " + title);
        Map<RupHistogramPlots.RakeType, List<Double>> azMap = JumpAzimuthsPlot.getAzimuthsFrom(sourceRake, azTable);
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        HashMap<Float, ArrayList<Color>> azColorMap = new HashMap<Float, ArrayList<Color>>();
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(-179.0, 179.0, 15.0);
        long totCount = 0L;
        for (RupHistogramPlots.RakeType oRake : azMap.keySet()) {
            if (destRake != null && destRake != oRake) continue;
            for (double azDiff : azMap.get((Object)oRake)) {
                hist.add(hist.getClosestXIndex(azDiff), 1.0);
                Float azFloat = Float.valueOf((float)azDiff);
                ArrayList<Color> colors = (ArrayList<Color>)azColorMap.get(azFloat);
                if (colors == null) {
                    colors = new ArrayList<Color>();
                    azColorMap.put(azFloat, colors);
                }
                colors.add(oRake.color);
                ++totCount;
            }
        }
        System.out.println("Have " + azColorMap.size() + " unique azimuths, " + totCount + " total");
        double alphaEach = 0.025;
        if (totCount > 0L) {
            alphaEach = Math.max(alphaEach, 1.0 / (double)totCount);
        }
        for (Float azFloat : azColorMap.keySet()) {
            double sumRed = 0.0;
            double sumGreen = 0.0;
            double sumBlue = 0.0;
            double sumAlpha = 0.0;
            int count = 0;
            for (Color azColor : (List)azColorMap.get(azFloat)) {
                sumRed += (double)azColor.getRed();
                sumGreen += (double)azColor.getGreen();
                sumBlue += (double)azColor.getBlue();
                if (sumAlpha < 1.0) {
                    sumAlpha += alphaEach;
                }
                ++count;
            }
            double red = sumRed / (double)count;
            double green = sumGreen / (double)count;
            double blue = sumBlue / (double)count;
            if (red > 1.0) {
                red = 1.0;
            }
            if (green > 1.0) {
                green = 1.0;
            }
            if (blue > 1.0) {
                blue = 1.0;
            }
            if (sumAlpha > 1.0) {
                sumAlpha = 1.0;
            }
            Color color = new Color((float)red, (float)green, (float)blue, (float)sumAlpha);
            DefaultXY_DataSet line = new DefaultXY_DataSet();
            line.set(0.0, 0.0);
            double azRad = JumpAzimuthsPlot.azDiffDegreesToAngleRad(azFloat.floatValue());
            double x = Math.cos(azRad);
            double y = Math.sin(azRad);
            line.set(x, y);
            funcs.add(line);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
        }
        double dip = sourceRake == RupHistogramPlots.RakeType.LEFT_LATERAL || sourceRake == RupHistogramPlots.RakeType.RIGHT_LATERAL ? 90.0 : (sourceRake == RupHistogramPlots.RakeType.NORMAL || sourceRake == RupHistogramPlots.RakeType.REVERSE ? 60.0 : 75.0);
        double traceLen = 0.5;
        double lowerDepth = 0.25;
        if (dip < 90.0) {
            double horzWidth = lowerDepth / Math.tan(Math.toRadians(dip));
            DefaultXY_DataSet outline = new DefaultXY_DataSet();
            outline.set(0.0, 0.0);
            outline.set(horzWidth, 0.0);
            outline.set(horzWidth, -traceLen);
            outline.set(0.0, -traceLen);
            funcs.add(outline);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GRAY));
        }
        DefaultXY_DataSet trace = new DefaultXY_DataSet();
        trace.set(0.0, 0.0);
        trace.set(0.0, -traceLen);
        funcs.add(trace);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 6.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(funcs, chars, title, "", " ");
        CPT cpt = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().reverse();
        cpt = cpt.rescale(2.8E-45f, 0.25);
        cpt.setBelowMinColor(Color.WHITE);
        double halfDelta = 0.5 * hist.getDelta();
        double innerMult = 0.95;
        double outerMult = 1.05;
        double sumY = Math.max(1.0, hist.calcSumOfY_Vals());
        for (int i = 0; i < hist.size(); ++i) {
            double centerAz = hist.getX(i);
            double startAz = JumpAzimuthsPlot.azDiffDegreesToAngleRad(centerAz - halfDelta);
            double endAz = JumpAzimuthsPlot.azDiffDegreesToAngleRad(centerAz + halfDelta);
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            double startX = Math.cos(startAz);
            double startY = Math.sin(startAz);
            double endX = Math.cos(endAz);
            double endY = Math.sin(endAz);
            points.add(new Point2D.Double(innerMult * startX, innerMult * startY));
            points.add(new Point2D.Double(outerMult * startX, outerMult * startY));
            points.add(new Point2D.Double(outerMult * endX, outerMult * endY));
            points.add(new Point2D.Double(innerMult * endX, innerMult * endY));
            points.add(new Point2D.Double(innerMult * startX, innerMult * startY));
            double[] polygon = new double[points.size() * 2];
            int cnt = 0;
            for (Point2D point2D : points) {
                polygon[cnt++] = point2D.getX();
                polygon[cnt++] = point2D.getY();
            }
            Color color = cpt.getColor((float)(hist.getY(i) / sumY));
            Stroke stroke = PlotLineType.SOLID.buildStroke(2.0f);
            spec.addPlotAnnotation((XYAnnotation)new XYPolygonAnnotation(polygon, stroke, (Paint)Color.DARK_GRAY, (Paint)color));
        }
        PaintScaleLegend cptBar = GraphPanel.getLegendForCPT(cpt, "Fraction", 24, 18, 0.05, RectangleEdge.BOTTOM);
        spec.addSubtitle((Title)cptBar);
        Range xRange = new Range(-1.1, 1.1);
        Range yRange = new Range(-1.1, 1.1);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(22);
        gp.setBackgroundColor(Color.WHITE);
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        gp.getXAxis().setTickLabelsVisible(false);
        gp.getYAxis().setTickLabelsVisible(false);
        File file = new File(outputDir, prefix + ".png");
        gp.getChartPanel().setSize(800, 800);
        gp.saveAsPNG(file.getAbsolutePath());
        return file;
    }
}

