/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public class JumpCountsOverDistancePlot
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "Jump Counts Over Distance";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        float[] maxJumpDists = new float[]{0.1f, 1.0f, 3.0f};
        double rsMinMag = rupSet.getMinMag();
        double rsMaxMag = rupSet.getMaxMag();
        ArrayList<Double> minMags = new ArrayList<Double>();
        minMags.add(0.0);
        if (rsMinMag < 7.0 && rsMaxMag > 7.0) {
            minMags.add(7.0);
        }
        if (rsMinMag < 8.0 && rsMinMag > 7.0 && rsMaxMag > 8.0) {
            minMags.add(8.0);
        }
        FaultSystemRupSet compRupSet = null;
        FaultSystemSolution compSol = null;
        String compName = null;
        if (meta.comparison != null && meta.comparison.rupSet.hasModule(ClusterRuptures.class)) {
            compRupSet = meta.comparison.rupSet;
            compSol = meta.comparison.sol;
            compName = meta.comparison.name;
        }
        boolean hasSols = sol != null || compSol != null;
        ArrayList<String> lines = new ArrayList<String>();
        Iterator iterator = minMags.iterator();
        while (iterator.hasNext()) {
            double minMag = (Double)iterator.next();
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            if (hasSols) {
                table.addLine("As Discretized", "Rate Weighted");
            }
            if (minMag > 0.0) {
                lines.add(this.getSubHeading() + " M&ge;" + optionalDigitDF.format(minMag) + " Jump Counts");
            } else {
                lines.add(this.getSubHeading() + " Supra-seismogenic Jump Counts");
            }
            lines.add(topLink);
            lines.add("");
            List<ClusterRupture> inputRups = rupSet.getModule(ClusterRuptures.class).getAll();
            List<ClusterRupture> compRups = compRupSet == null ? null : compRupSet.getModule(ClusterRuptures.class).getAll();
            for (float jumpDist : maxJumpDists) {
                System.out.println("Plotting num jumps");
                table.initNewLine();
                File plotFile = JumpCountsOverDistancePlot.plotFixedJumpDist(rupSet, null, inputRups, JumpCountsOverDistancePlot.getTruncatedTitle(meta.primary.name), compRupSet, null, compRups, JumpCountsOverDistancePlot.getTruncatedTitle(compName), minMag, jumpDist, resourcesDir);
                table.addColumn("![Plausibility Filter](" + resourcesDir.getName() + "/" + plotFile.getName() + ")");
                if (hasSols) {
                    plotFile = JumpCountsOverDistancePlot.plotFixedJumpDist(sol == null ? null : rupSet, sol, inputRups, JumpCountsOverDistancePlot.getTruncatedTitle(meta.primary.name), compSol == null ? null : compRupSet, compSol, compRups, JumpCountsOverDistancePlot.getTruncatedTitle(compName), minMag, jumpDist, resourcesDir);
                    table.addColumn("![Plausibility Filter](" + resourcesDir.getName() + "/" + plotFile.getName() + ")");
                }
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
        }
        if (sol != null) {
            lines.add(this.getSubHeading() + " Max Jump Distance Distribution");
            lines.add(topLink);
            lines.add("");
            File plot = JumpCountsOverDistancePlot.plotJumpDistRates(rupSet, sol, meta.primary.name, compRupSet, compSol, compName, resourcesDir, false);
            lines.add("![Max Jump Dist Plot](" + relPathToResources + "/" + plot.getName() + ")");
            lines.add(this.getSubHeading() + " Cumulative Jump Distance Distribution");
            lines.add(topLink);
            lines.add("");
            plot = JumpCountsOverDistancePlot.plotJumpDistRates(rupSet, sol, meta.primary.name, compRupSet, compSol, compName, resourcesDir, true);
            lines.add("![Cumulative Jump Dist Plot](" + relPathToResources + "/" + plot.getName() + ")");
        }
        return lines;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(ClusterRuptures.class, SectionDistanceAzimuthCalculator.class);
    }

    public static File plotFixedJumpDist(FaultSystemRupSet inputRupSet, FaultSystemSolution inputSol, List<ClusterRupture> inputClusterRups, String inputName, FaultSystemRupSet compRupSet, FaultSystemSolution compSol, List<ClusterRupture> compClusterRups, String compName, double minMag, float jumpDist, File outputDir) throws IOException {
        String yAxisLabel;
        Object prefixAdd;
        String title;
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        if (inputRupSet != null) {
            DiscretizedFunc func = JumpCountsOverDistancePlot.calcJumpDistFunc(inputRupSet, inputSol, inputClusterRups, minMag, jumpDist);
            func.scale(1.0 / func.calcSumOfY_Vals());
            funcs.add(func);
            func.setName(inputName);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, MAIN_COLOR));
        }
        if (compRupSet != null) {
            DiscretizedFunc compFunc = JumpCountsOverDistancePlot.calcJumpDistFunc(compRupSet, compSol, compClusterRups, minMag, jumpDist);
            compFunc.scale(1.0 / compFunc.calcSumOfY_Vals());
            compFunc.setName(compName);
            funcs.add(compFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, COMP_COLOR));
        }
        String xAxisLabel = "Num Jumps \u2265" + jumpDist + " km";
        if (minMag > 0.0) {
            title = "M\u2265" + (float)minMag + " " + jumpDist + " km Jump Comparison";
            prefixAdd = "_m" + optionalDigitDF.format(minMag);
        } else {
            title = jumpDist + " km Jump Comparison";
            prefixAdd = "";
        }
        Range yRange = null;
        if (inputSol != null || compSol != null) {
            yAxisLabel = "Fraction (Rate-Weighted)";
            yRange = new Range(0.0, 1.0);
            prefixAdd = (String)prefixAdd + "_rates";
        } else {
            yAxisLabel = "Count";
            prefixAdd = (String)prefixAdd + "_counts";
        }
        PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        String prefix = new File(outputDir, "jumps_" + jumpDist + "km" + (String)prefixAdd).getAbsolutePath();
        gp.drawGraphPanel(spec, false, false, null, yRange);
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(1.0);
        tus.add((TickUnit)tu);
        gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
        gp.getChartPanel().setSize(1000, 500);
        gp.saveAsPNG(prefix + ".png");
        gp.saveAsPDF(prefix + ".pdf");
        gp.saveAsTXT(prefix + ".txt");
        return new File(prefix + ".png");
    }

    private static DiscretizedFunc calcJumpDistFunc(FaultSystemRupSet rupSet, FaultSystemSolution sol, List<ClusterRupture> clusterRups, double minMag, float jumpDist) {
        EvenlyDiscretizedFunc solFunc = new EvenlyDiscretizedFunc(0.0, 5, 1.0);
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            double rate;
            double mag = rupSet.getMagForRup(r);
            if (mag < minMag) continue;
            ClusterRupture rup = clusterRups.get(r);
            int jumpsOverDist = 0;
            for (Jump jump : rup.getJumpsIterable()) {
                if (!((float)jump.distance > jumpDist)) continue;
                ++jumpsOverDist;
            }
            double d = rate = sol == null ? 1.0 : sol.getRateForRup(r);
            if (jumpsOverDist >= solFunc.size()) continue;
            solFunc.set(jumpsOverDist, solFunc.getY(jumpsOverDist) + rate);
        }
        return solFunc;
    }

    /*
     * WARNING - void declaration
     */
    public static File plotJumpDistRates(FaultSystemRupSet inputRupSet, FaultSystemSolution inputSol, String inputName, FaultSystemRupSet compRupSet, FaultSystemSolution compSol, String compName, File outputDir, boolean cumulative) throws IOException {
        void var22_33;
        String prefix;
        double maxDist = 0.0;
        ArrayList<Double> inputDists = new ArrayList<Double>();
        for (ClusterRupture clusterRupture : inputRupSet.requireModule(ClusterRuptures.class).getAll()) {
            double dist = 0.0;
            for (Jump jump : clusterRupture.getJumpsIterable()) {
                if (cumulative) {
                    dist += jump.distance;
                    continue;
                }
                dist = Math.max(dist, jump.distance);
            }
            maxDist = Math.max(maxDist, dist);
            inputDists.add(dist);
        }
        ArrayList<Double> compDists = null;
        if (compSol != null) {
            compDists = new ArrayList<Double>();
            for (ClusterRupture rup : compRupSet.requireModule(ClusterRuptures.class).getAll()) {
                double dist = 0.0;
                for (Jump jump : rup.getJumpsIterable()) {
                    if (cumulative) {
                        dist += jump.distance;
                        continue;
                    }
                    dist = Math.max(dist, jump.distance);
                }
                maxDist = Math.max(maxDist, dist);
                compDists.add(dist);
            }
        }
        HistogramFunction histogramFunction = HistogramFunction.getEncompassingHistogram(0.01, Math.max(4.9, maxDist), 1.0);
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        EvenlyDiscretizedFunc inputRateFunc = JumpCountsOverDistancePlot.rupDistRateFunc(histogramFunction, inputDists, inputSol);
        funcs.add(inputRateFunc);
        inputRateFunc.setName(inputName);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, MAIN_COLOR));
        EvenlyDiscretizedFunc evenlyDiscretizedFunc = JumpCountsOverDistancePlot.rupDistRateFunc(histogramFunction, inputDists, null);
        evenlyDiscretizedFunc.scale(inputRateFunc.calcSumOfY_Vals() / evenlyDiscretizedFunc.calcSumOfY_Vals());
        evenlyDiscretizedFunc.setName("(as discretized)");
        funcs.add(evenlyDiscretizedFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, MAIN_COLOR));
        if (compSol != null) {
            EvenlyDiscretizedFunc func = JumpCountsOverDistancePlot.rupDistRateFunc(histogramFunction, compDists, compSol);
            funcs.add(func);
            func.setName(compName);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, COMP_COLOR));
        }
        double maxY = 0.0;
        double minY = Double.POSITIVE_INFINITY;
        for (DiscretizedFunc discretizedFunc : funcs) {
            for (Point2D pt : discretizedFunc) {
                if (!(pt.getY() > 0.0)) continue;
                maxY = Math.max(maxY, pt.getY());
                minY = Math.min(minY, pt.getY());
            }
        }
        if ((maxY = Math.pow(10.0, Math.ceil(Math.log10(maxY)))) <= (minY = Math.pow(10.0, Math.floor(Math.log10(minY))))) {
            maxY = minY + 10.0;
        }
        String title = " ";
        if (cumulative) {
            String string = "Rupture Cumulative Jump Distance (km)";
            prefix = "jump_rate_cumulative";
        } else {
            String string = "Rupture Maximum Jump Distance (km)";
            prefix = "jump_rate_max";
        }
        String yAxisLabel = "Incremental Rate (1/yr)";
        Range yRange = new Range(minY, maxY);
        PlotSpec spec = new PlotSpec(funcs, chars, title, (String)var22_33, yAxisLabel);
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        prefix = new File(outputDir, prefix).getAbsolutePath();
        gp.drawGraphPanel(spec, false, true, null, yRange);
        gp.getChartPanel().setSize(1000, 850);
        gp.saveAsPNG(prefix + ".png");
        gp.saveAsPDF(prefix + ".pdf");
        gp.saveAsTXT(prefix + ".txt");
        return new File(prefix + ".png");
    }

    private static EvenlyDiscretizedFunc rupDistRateFunc(EvenlyDiscretizedFunc refVals, List<Double> dists, FaultSystemSolution sol) {
        EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(refVals.getMinX(), refVals.size(), refVals.getDelta());
        for (int r = 0; r < dists.size(); ++r) {
            int ind = ret.getClosestXIndex(dists.get(r));
            if (sol == null) {
                ret.add(ind, 1.0);
                continue;
            }
            ret.add(ind, sol.getRateForRup(r));
        }
        return ret;
    }
}

