/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectBySectDetailPlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.faultSurface.FaultSection;

public class NamedFaultPlot
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "Special Fault Detail Pages";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        File faultsDir = new File(resourcesDir.getParentFile(), "special_fault_pages");
        Preconditions.checkState((faultsDir.exists() || faultsDir.mkdir() ? 1 : 0) != 0);
        NamedFaults faults = rupSet.requireModule(NamedFaults.class);
        HashMap<String, String> linksMap = new HashMap<String, String>();
        for (String faultName : faults.getFaultNames()) {
            try {
                String subDirName = NamedFaultPlot.writeFaultPage(meta, faults, faultName, faultsDir);
                if (subDirName == null) continue;
                linksMap.put(faultName, relPathToResources + "/../" + faultsDir.getName() + "/" + subDirName);
            }
            catch (RuntimeException e) {
                System.err.println("Error processing SectBySectDetailPlots plot for fault: " + faultName);
                e.printStackTrace();
                linksMap.put(faultName, null);
                System.err.flush();
            }
        }
        ArrayList<String> sortedNames = new ArrayList<String>(linksMap.keySet());
        Collections.sort(sortedNames);
        String plotPrefix = "named_faults_map";
        this.writeFaultsPlot(resourcesDir, plotPrefix, rupSet, meta.region, sortedNames, faults);
        ArrayList<String> lines = new ArrayList<String>();
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine("![Map plot](" + relPathToResources + "/" + plotPrefix + ".png)");
        table.addLine(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + plotPrefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + plotPrefix + ".geojson)");
        lines.addAll(table.build());
        lines.add("");
        table = SectBySectDetailPlots.buildSectLinksTable(linksMap, sortedNames, "Fault Name");
        lines.addAll(table.build());
        return lines;
    }

    private static String writeFaultPage(ReportMetadata meta, NamedFaults faults, String faultName, File faultsDir) throws IOException {
        System.out.println("Building page for: " + faultName);
        String dirName = NamedFaultPlot.getFileSafe(faultName);
        File faultDir = new File(faultsDir, dirName);
        Preconditions.checkState((faultDir.exists() || faultDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(faultDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# " + faultName + " Details");
        lines.add("");
        List<FaultSection> faultSects = faults.getSectsForFault(faultName);
        if (faultSects.isEmpty()) {
            return null;
        }
        HashSet<Integer> allRups = new HashSet<Integer>();
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = Double.NEGATIVE_INFINITY;
        double totRate = 0.0;
        for (FaultSection faultSection : faultSects) {
            allRups.addAll(meta.primary.rupSet.getRupturesForSection(faultSection.getSectionId()));
        }
        int rupCountNonZero = 0;
        Iterator iterator = allRups.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            double mag = meta.primary.rupSet.getMagForRup(rupIndex);
            minMag = Math.min(minMag, mag);
            maxMag = Math.max(maxMag, mag);
            if (meta.primary.sol == null) continue;
            double rate = meta.primary.sol.getRateForRup(rupIndex);
            totRate += rate;
            if (!(rate > 0.0)) continue;
            ++rupCountNonZero;
        }
        MarkdownUtils.TableBuilder tableBuilder = MarkdownUtils.tableBuilder();
        tableBuilder.addLine("_Property_", "_Value_");
        tableBuilder.addLine("**Rupture Count**", countDF.format(allRups.size()));
        if (meta.primary.sol != null) {
            tableBuilder.addLine("**Ruptures w/ Nonzero Rates**", countDF.format(rupCountNonZero));
        }
        tableBuilder.addLine("**Magnitude Range**", "[" + twoDigits.format(minMag) + ", " + twoDigits.format(maxMag) + "]");
        tableBuilder.addLine("**Total Rate**", (float)totRate + " /yr");
        lines.addAll(tableBuilder.build());
        lines.add("");
        int tocIndex = lines.size();
        String topLink = "_[(top)](#table-of-contents)_";
        if (meta.hasPrimarySol()) {
            lines.addAll(SectBySectDetailPlots.getMFDLines(meta, faultName, faultSects, resourcesDir, topLink));
            lines.add("");
        }
        lines.addAll(SectBySectDetailPlots.getAlongStrikeLines(meta, faultName, faultSects, resourcesDir, topLink));
        lines.add("");
        if (meta.hasPrimarySol()) {
            lines.addAll(SectBySectDetailPlots.getLengthLines(meta, faultName, faultSects, resourcesDir, topLink));
            lines.add("");
            lines.addAll(SectBySectDetailPlots.getRateWeightedLengthExampleLines(meta, faultName, faultSects, resourcesDir, topLink));
            lines.add("");
        }
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 3));
        lines.add(tocIndex, "## Table Of Contents");
        MarkdownUtils.writeReadmeAndHTML(lines, faultDir);
        return dirName;
    }

    private void writeFaultsPlot(File resourcesDir, String prefix, FaultSystemRupSet rupSet, Region region, List<String> sortedNames, NamedFaults faults) throws IOException {
        int i;
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, region);
        mapMaker.setWriteGeoJSON(true);
        mapMaker.setWritePDFs(false);
        mapMaker.setSkipNaNs(true);
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, Math.max(1.0, (double)sortedNames.size()));
        double[] scalars = new double[rupSet.getNumSections()];
        for (i = 0; i < scalars.length; ++i) {
            scalars[i] = Double.NaN;
        }
        for (i = 0; i < sortedNames.size(); ++i) {
            for (FaultSection sect : faults.getSectsForFault(sortedNames.get(i))) {
                scalars[sect.getSectionId()] = i;
            }
        }
        mapMaker.plotSectScalars(scalars, cpt, null);
        mapMaker.plot(resourcesDir, prefix, "Special Faults");
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(NamedFaults.class);
    }
}

