/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.PlausibilityFilterPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeRakeChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.BiasiWesnouskyJumpProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupCartoonGenerator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import org.opensha.sha.faultSurface.FaultSection;

public class RupHistogramPlots
extends AbstractRupSetPlot {
    private HistScalar[] scalars;
    public static final HistScalar[] RUP_SET_LIGHT_SCALARS = new HistScalar[]{HistScalar.LENGTH, HistScalar.MAG, HistScalar.SECT_COUNT, HistScalar.CLUSTER_COUNT, HistScalar.AREA, HistScalar.MAX_JUMP_DIST, HistScalar.CUM_JUMP_DIST, HistScalar.RAKE, HistScalar.CUM_RAKE_CHANGE};
    public static final HistScalar[] RUP_SET_SCALARS = HistScalar.values();
    public static final HistScalar[] SOL_SCALARS = new HistScalar[]{HistScalar.LENGTH, HistScalar.MAG, HistScalar.MAX_JUMP_DIST, HistScalar.CUM_JUMP_DIST, HistScalar.CUM_RAKE_CHANGE};
    public static PlotPreferences PLOT_PREFS_DEFAULT = PlotUtils.getDefaultFigurePrefs();
    public static boolean TITLES = true;
    private static double[] example_fractiles_default = new double[]{0.0, 0.5, 0.9, 0.95, 0.975, 0.99, 0.999, 1.0};

    public RupHistogramPlots() {
        this(HistScalar.values());
    }

    public RupHistogramPlots(HistScalar[] scalars) {
        this.scalars = scalars;
    }

    @Override
    public String getName() {
        return "Rupture Scalar Histograms";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        File rupHtmlDir;
        ArrayList<String> lines = new ArrayList<String>();
        List<ClusterRupture> inputRups = rupSet.requireModule(ClusterRuptures.class).getAll();
        FaultSystemRupSet compRupSet = meta.comparison == null ? null : meta.comparison.rupSet;
        List<ClusterRupture> compRups = null;
        if (compRupSet != null && compRupSet.hasModule(ClusterRuptures.class)) {
            compRups = compRupSet.getModule(ClusterRuptures.class).getAll();
        }
        Preconditions.checkState(((rupHtmlDir = new File(resourcesDir.getParentFile(), "hist_rup_pages")).exists() || rupHtmlDir.mkdir() ? 1 : 0) != 0);
        ArrayList<HistScalarValues> inputScalarVals = new ArrayList<HistScalarValues>();
        ArrayList<HistScalarValues> compScalarVals = compRups == null ? null : new ArrayList<HistScalarValues>();
        HashSet<UniqueRupture> inputUniques = new HashSet<UniqueRupture>(meta.primary.uniques);
        HashSet<UniqueRupture> compUniques = meta.comparison == null ? null : new HashSet<UniqueRupture>(meta.comparison.uniques);
        SectionDistanceAzimuthCalculator distAzCalc = rupSet.getModule(SectionDistanceAzimuthCalculator.class);
        if (distAzCalc == null) {
            distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
            rupSet.addModule(distAzCalc);
        }
        boolean doMechHists = sol != null && (this.getPlotLevel() == ReportPageGen.PlotLevel.FULL || this.getPlotLevel() == ReportPageGen.PlotLevel.REVIEW);
        RakeType[] sectRakes = null;
        HashSet<RakeType> uniqueRakes = null;
        if (doMechHists) {
            sectRakes = new RakeType[rupSet.getNumSections()];
            uniqueRakes = new HashSet<RakeType>();
            for (int s = 0; s < sectRakes.length; ++s) {
                sectRakes[s] = RakeType.getType(rupSet.getFaultSectionData(s).getAveRake());
                uniqueRakes.add(sectRakes[s]);
            }
            if (uniqueRakes.size() < 2) {
                doMechHists = false;
            }
        }
        for (HistScalar scalar : this.scalars) {
            lines.add(this.getSubHeading() + " " + scalar.getName());
            lines.add(topLink);
            lines.add("");
            lines.add(scalar.description);
            lines.add("");
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            HistScalarValues inputScalars = new HistScalarValues(scalar, rupSet, sol, inputRups, distAzCalc);
            inputScalarVals.add(inputScalars);
            meta.primary.addScalar(inputScalars);
            HistScalarValues compScalars = null;
            if (compRupSet != null) {
                table.addLine(meta.primary.name, meta.comparison.name);
                compScalars = new HistScalarValues(scalar, compRupSet, meta.comparison.sol, compRups, distAzCalc);
                meta.comparison.addScalar(compScalars);
                compScalarVals.add(compScalars);
            }
            try {
                RupHistogramPlots.plotRuptureHistograms(resourcesDir, relPathToResources, "hist_" + scalar.name(), table, inputScalars, inputUniques, compScalars, compUniques);
            }
            catch (Exception err) {
                System.out.println("Caught exception: " + err.getLocalizedMessage());
                continue;
            }
            lines.addAll(table.build());
            lines.add("");
            if (sol == null) {
                if (this.getPlotLevel() != ReportPageGen.PlotLevel.LIGHT) {
                    double[] fractiles = scalar.getExampleRupPlotFractiles();
                    if (fractiles == null) continue;
                    lines.add(this.getSubHeading() + "# " + scalar.getName() + " Extremes & Examples");
                    lines.add(topLink);
                    lines.add("");
                    lines.add("Example ruptures at various percentiles of " + scalar.getName());
                    lines.add("");
                    ArrayList<List<ClusterRupture>> ruptureLists = new ArrayList<List<ClusterRupture>>();
                    ArrayList uniqueLists = new ArrayList();
                    ArrayList<CallSite> headings = new ArrayList<CallSite>();
                    ArrayList<List<Double>> scalarValsList = new ArrayList<List<Double>>();
                    ArrayList<String> prefixes = new ArrayList<String>();
                    ArrayList<FaultSystemRupSet> rupSets = new ArrayList<FaultSystemRupSet>();
                    ruptureLists.add(inputRups);
                    uniqueLists.add(null);
                    if (compRupSet == null) {
                        headings.add(null);
                    } else {
                        headings.add((CallSite)((Object)("From the primary rupture set (" + meta.primary.name + "):")));
                    }
                    scalarValsList.add(inputScalars.getValues());
                    prefixes.add("hist_rup");
                    rupSets.add(rupSet);
                    if (compRupSet != null) {
                        HashSet<UniqueRupture> includeUniques;
                        if (meta.primaryOverlap.numUniqueRuptures > 0) {
                            includeUniques = new HashSet<UniqueRupture>();
                            for (ClusterRupture rup : inputRups) {
                                if (compUniques.contains(rup.unique)) continue;
                                includeUniques.add(rup.unique);
                            }
                            Preconditions.checkState((!includeUniques.isEmpty() ? 1 : 0) != 0);
                            ruptureLists.add(inputRups);
                            uniqueLists.add(includeUniques);
                            headings.add((CallSite)((Object)("Ruptures that are unique to the primary rupture set (" + meta.primary.name + "):")));
                            scalarValsList.add(inputScalars.getValues());
                            prefixes.add("hist_rup");
                            rupSets.add(rupSet);
                        }
                        if (meta.comparisonOverlap.numUniqueRuptures > 0) {
                            includeUniques = new HashSet();
                            for (ClusterRupture rup : compRups) {
                                if (inputUniques.contains(rup.unique)) continue;
                                includeUniques.add(rup.unique);
                            }
                            Preconditions.checkState((!includeUniques.isEmpty() ? 1 : 0) != 0);
                            ruptureLists.add(compRups);
                            uniqueLists.add(includeUniques);
                            headings.add((CallSite)((Object)("Ruptures that are unique to the comparison rupture set (" + meta.comparison.name + "):")));
                            scalarValsList.add(compScalars.getValues());
                            prefixes.add("hist_comp_rup");
                            rupSets.add(compRupSet);
                        }
                    }
                    for (int i = 0; i < headings.size(); ++i) {
                        int j;
                        void var43_69;
                        List rups = (List)ruptureLists.get(i);
                        String heading = (String)headings.get(i);
                        List vals = (List)scalarValsList.get(i);
                        HashSet includeUniques = (HashSet)uniqueLists.get(i);
                        FaultSystemRupSet myRupSet = (FaultSystemRupSet)rupSets.get(i);
                        String prefix = (String)prefixes.get(i);
                        if (heading != null) {
                            lines.add(heading);
                            lines.add("");
                        }
                        ArrayList<Integer> filteredIndexes = new ArrayList<Integer>();
                        ArrayList<Double> filteredVals = new ArrayList<Double>();
                        boolean bl = false;
                        while (var43_69 < rups.size()) {
                            if (includeUniques == null || includeUniques.contains(((ClusterRupture)rups.get((int)var43_69)).unique)) {
                                filteredIndexes.add((int)var43_69);
                                filteredVals.add((Double)vals.get((int)var43_69));
                            }
                            ++var43_69;
                        }
                        List list = ComparablePairing.getSortedData(filteredVals, filteredIndexes);
                        int[] fractileIndexes = new int[fractiles.length];
                        for (j = 0; j < fractiles.length; ++j) {
                            double f = fractiles[j];
                            fractileIndexes[j] = f == 1.0 ? filteredIndexes.size() - 1 : (int)(f * (double)filteredIndexes.size());
                        }
                        table = MarkdownUtils.tableBuilder();
                        table.initNewLine();
                        for (j = 0; j < fractiles.length; ++j) {
                            int index = (Integer)list.get(fractileIndexes[j]);
                            double val = (Double)vals.get(index);
                            double f = fractiles[j];
                            Object str = f == 0.0 ? "Minimum" : (f == 1.0 ? "Maximum" : "p" + new DecimalFormat("0.#").format(f * 100.0));
                            str = (String)str + ": ";
                            str = val < 0.1 ? (String)str + (float)val : (String)str + new DecimalFormat("0.##").format(val);
                            table.addColumn("**" + (String)str + "**");
                        }
                        table.finalizeLine();
                        table.initNewLine();
                        for (int rawIndex : fractileIndexes) {
                            int index = (Integer)list.get(rawIndex);
                            String rupPrefix = prefix + "_" + index;
                            ClusterRupture rup = (ClusterRupture)rups.get(index);
                            if (includeUniques != null) {
                                Preconditions.checkState((boolean)includeUniques.contains(rup.unique), (String)"IncludeUniques doesn't contain rupture at rawIndex=%s, index=%s: %s", (Object)rawIndex, (Object)index, (Object)rup);
                            }
                            RupCartoonGenerator.plotRupture(resourcesDir, rupPrefix, rup, "Rupture " + index, false, true);
                            table.addColumn("[<img src=\"" + relPathToResources + "/" + rupPrefix + ".png\" />](" + relPathToResources + "/../" + RupHistogramPlots.generateRuptureInfoPage(myRupSet, (ClusterRupture)rups.get(index), index, rupHtmlDir, rupPrefix, null, distAzCalc) + ")");
                        }
                        lines.addAll(table.wrap(4, 0).build());
                        lines.add("");
                    }
                }
            } else if (this.getPlotLevel() == ReportPageGen.PlotLevel.FULL) {
                double[] rates = sol.getRateForAllRups();
                RakeType[] valRateScatter = new DefaultXY_DataSet();
                DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
                for (int r = 0; r < rates.length; ++r) {
                    double val = inputScalars.getValue(r);
                    track.addValue(val);
                    if (scalar.isLogX()) {
                        val = Math.log10(val);
                    }
                    valRateScatter.set(val, rates[r]);
                }
                HistogramFunction refXFunc = scalar.getHistogram(track);
                ArrayList<RakeType[]> funcs = new ArrayList<RakeType[]>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                funcs.add(valRateScatter);
                chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
                Range xRange = new Range(refXFunc.getMinX() - 0.5 * refXFunc.getDelta(), refXFunc.getMaxX() + 0.5 * refXFunc.getDelta());
                Range yRange = new Range(Math.max(1.0E-16, valRateScatter.getMinY()), Math.max(0.01, valRateScatter.getMaxY()));
                Range logYRange = new Range(Math.log10(yRange.getLowerBound()), Math.log10(yRange.getUpperBound()));
                Object xAxisLabel = scalar.getxAxisLabel();
                if (scalar.isLogX()) {
                    xAxisLabel = "Log10 " + (String)xAxisLabel;
                }
                PlotSpec spec = new PlotSpec(funcs, chars, scalar.getName() + " vs Rupture Rate", (String)xAxisLabel, "Rupture Rate (/yr)");
                HeadlessGraphPanel gp = new HeadlessGraphPanel(PLOT_PREFS_DEFAULT);
                gp.drawGraphPanel(spec, false, true, xRange, yRange);
                String prefix = "hist_" + scalar.name() + "_vs_rate";
                PlotUtils.writePlots(resourcesDir, prefix, (GraphPanel)gp, 1000, 850, true, false, false);
                funcs = new ArrayList();
                chars = new ArrayList();
                EvenlyDiscretizedFunc refYFunc = new EvenlyDiscretizedFunc(logYRange.getLowerBound(), logYRange.getUpperBound(), 50);
                EvenlyDiscrXYZ_DataSet xyz = new EvenlyDiscrXYZ_DataSet(refXFunc.size(), refYFunc.size(), refXFunc.getMinX(), refYFunc.getMinX(), refXFunc.getDelta(), refYFunc.getDelta());
                for (Point2D point2D : valRateScatter) {
                    double x = point2D.getX();
                    double logY = Math.log10(point2D.getY());
                    int xInd = refXFunc.getClosestXIndex(x);
                    int yInd = refYFunc.getClosestXIndex(logY);
                    xyz.set(xInd, yInd, xyz.get(xInd, yInd) + 1.0);
                }
                xyz.log10();
                double maxZ = xyz.getMaxZ();
                CPT cpt = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().reverse().rescale(0.0, Math.ceil(maxZ));
                cpt.setNanColor(new Color(255, 255, 255, 0));
                cpt.setBelowMinColor(cpt.getNanColor());
                for (int i = 0; i < xyz.size(); ++i) {
                    if (xyz.get(i) != 0.0) continue;
                    xyz.set(i, Double.NaN);
                }
                XYZPlotSpec xyzSpec = new XYZPlotSpec(xyz, cpt, spec.getTitle(), spec.getXAxisLabel(), "Log10 " + spec.getYAxisLabel(), "Log10 Count");
                xyzSpec.setCPTPosition(RectangleEdge.BOTTOM);
                xyzSpec.setXYElems(funcs);
                xyzSpec.setXYChars(chars);
                gp.drawGraphPanel(xyzSpec, false, false, xRange, logYRange);
                gp.getChartPanel().setSize(1000, 850);
                gp.saveAsPNG(new File(resourcesDir, prefix + "_hist2D.png").getAbsolutePath());
                table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                table.addColumn("![rate comparison](" + relPathToResources + "/" + prefix + ".png)");
                table.addColumn("![rate hist](" + relPathToResources + "/" + prefix + "_hist2D.png)");
                table.finalizeLine();
                lines.add(this.getSubHeading() + "# " + scalar.getName() + " vs Rupture Rate");
                lines.add(topLink);
                lines.add("");
                lines.add("");
                lines.addAll(table.build());
            }
            if (!doMechHists) continue;
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            ArrayList<RakeType> types = new ArrayList<RakeType>();
            for (RakeType type : RakeType.values()) {
                if (!uniqueRakes.contains((Object)type)) continue;
                table.addColumn(MarkdownUtils.boldCentered(type.name));
                types.add(type);
            }
            table.finalizeLine();
            ArrayList<HistogramFunction> countHists = new ArrayList<HistogramFunction>();
            ArrayList<HistogramFunction> rateHists = new ArrayList<HistogramFunction>();
            DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
            int numRups = rupSet.getNumRuptures();
            for (int r = 0; r < numRups; ++r) {
                double val = inputScalars.getValue(r);
                track.addValue(val);
            }
            boolean logX = scalar.isLogX();
            for (RakeType type : types) {
                HistogramFunction countHist = scalar.getHistogram(track);
                HistogramFunction rateHist = scalar.getHistogram(track);
                for (int r = 0; r < numRups; ++r) {
                    int numMatches = 0;
                    int numSects = 0;
                    for (int s : rupSet.getSectionsIndicesForRup(r)) {
                        ++numSects;
                        if (sectRakes[s] != type) continue;
                        ++numMatches;
                    }
                    if (numMatches <= 0) continue;
                    double fract = (double)numMatches / (double)numSects;
                    double val = inputScalars.getValue(r);
                    int index = logX ? (val <= 0.0 ? 0 : countHist.getClosestXIndex(Math.log10(val))) : countHist.getClosestXIndex(val);
                    countHist.add(index, fract);
                    rateHist.add(index, fract * sol.getRateForRup(r));
                }
                countHists.add(countHist);
                rateHists.add(rateHist);
            }
            String prefix = "hist_" + scalar.name();
            table.initNewLine();
            for (int i = 0; i < types.size(); ++i) {
                RakeType type = (RakeType)((Object)types.get(i));
                File plot = RupHistogramPlots.plotMechSpecificHist(resourcesDir, prefix + "_" + type.prefix, scalar, (HistogramFunction)countHists.get(i), (HistogramFunction)rateHists.get(i), type);
                table.addColumn("![Hists](" + relPathToResources + "/" + plot.getName() + ")");
            }
            table.finalizeLine();
            table = table.wrap(3, 0);
            lines.add("");
            lines.add(this.getSubHeading() + "# " + scalar.getName() + " Mechanism-Specific Histograms");
            lines.add(topLink);
            lines.add("");
            lines.addAll(table.build());
            lines.add("");
        }
        return lines;
    }

    @Override
    public List<String> getSummary(ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) {
        if (meta.primary.scalarRanges.isEmpty()) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.getSubHeading() + " Scalar Values Table");
        lines.add(topLink);
        lines.add("");
        boolean comp = meta.comparison != null && !meta.comparison.scalarRanges.isEmpty();
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (comp) {
            table.addLine("*Name*", "*Primary Range*", "*Comparison (" + meta.comparison.name + ") Range*");
        } else {
            table.addLine("*Name*", "*Range*");
        }
        HashMap<HistScalar, RupSetMetadata.ScalarRange> primaryScalars = new HashMap<HistScalar, RupSetMetadata.ScalarRange>();
        for (RupSetMetadata.ScalarRange range : meta.primary.scalarRanges) {
            primaryScalars.put(range.scalar, range);
        }
        HashMap<HistScalar, RupSetMetadata.ScalarRange> compScalars = new HashMap<HistScalar, RupSetMetadata.ScalarRange>();
        if (comp) {
            for (RupSetMetadata.ScalarRange range : meta.comparison.scalarRanges) {
                compScalars.put(range.scalar, range);
            }
        }
        for (HistScalar scalar : HistScalar.values()) {
            RupSetMetadata.ScalarRange primaryScalar = (RupSetMetadata.ScalarRange)primaryScalars.get((Object)scalar);
            RupSetMetadata.ScalarRange compScalar = (RupSetMetadata.ScalarRange)compScalars.get((Object)scalar);
            if (primaryScalar == null && compScalar == null) continue;
            table.initNewLine();
            table.addColumn("**" + scalar.getName() + "**");
            if (primaryScalar == null) {
                table.addColumn("");
            } else {
                table.addColumn("[" + (float)primaryScalar.min + ", " + (float)primaryScalar.max + "]");
            }
            if (comp) {
                if (compScalar == null) {
                    table.addColumn("");
                } else {
                    table.addColumn("[" + (float)compScalar.min + ", " + (float)compScalar.max + "]");
                }
            }
            table.finalizeLine();
        }
        lines.addAll(table.build());
        lines.add("");
        lines.add(this.getSubHeading() + " Length Figures");
        lines.add(topLink);
        lines.add("");
        table = MarkdownUtils.tableBuilder();
        if (comp) {
            table.addLine(meta.primary.name, meta.comparison.name);
            table.addLine("![Primary](" + relPathToResources + "/hist_LENGTH.png)", "![Comparison](" + relPathToResources + "/hist_LENGTH_comp.png)");
            if (new File(resourcesDir, "hist_LENGTH_rates.png").exists() || new File(resourcesDir, "hist_LENGTH_comp_rates.png").exists()) {
                table.initNewLine();
                if (new File(resourcesDir, "hist_LENGTH_rates.png").exists()) {
                    table.addColumn("![Primary](" + relPathToResources + "/hist_LENGTH_rates.png)");
                } else {
                    table.addColumn("*N/A*");
                }
                if (new File(resourcesDir, "hist_LENGTH_comp_rates.png").exists()) {
                    table.addColumn("![Comparison](" + relPathToResources + "/hist_LENGTH_comp_rates.png)");
                } else {
                    table.addColumn("*N/A*");
                }
                table.finalizeLine();
            }
            if (new File(resourcesDir, "hist_LENGTH_rates_log.png").exists() || new File(resourcesDir, "hist_LENGTH_comp_rates_log.png").exists()) {
                table.initNewLine();
                if (new File(resourcesDir, "hist_LENGTH_rates_log.png").exists()) {
                    table.addColumn("![Primary](" + relPathToResources + "/hist_LENGTH_rates_log.png)");
                } else {
                    table.addColumn("*N/A*");
                }
                if (new File(resourcesDir, "hist_LENGTH_comp_rates_log.png").exists()) {
                    table.addColumn("![Comparison](" + relPathToResources + "/hist_LENGTH_comp_rates_log.png)");
                } else {
                    table.addColumn("*N/A*");
                }
                table.finalizeLine();
            }
        } else {
            table.addLine("![Primary](" + relPathToResources + "/hist_LENGTH.png)");
            if (new File(resourcesDir, "hist_LENGTH_rates.png").exists()) {
                table.addLine("![Primary](" + relPathToResources + "/hist_LENGTH_rates.png)");
            }
            if (new File(resourcesDir, "hist_LENGTH_rates_log.png").exists()) {
                table.addLine("![Primary](" + relPathToResources + "/hist_LENGTH_rates_log.png)");
            }
        }
        lines.addAll(table.build());
        return lines;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(ClusterRuptures.class);
    }

    public static void plotRuptureHistograms(File outputDir, String relPathToOutput, String prefix, MarkdownUtils.TableBuilder table, HistScalarValues inputScalars, HashSet<UniqueRupture> inputUniques, HistScalarValues compScalars, HashSet<UniqueRupture> compUniques) throws IOException {
        boolean hasCompSol;
        File main = RupHistogramPlots.plotRuptureHistogram(outputDir, prefix, inputScalars, compScalars, compUniques, MAIN_COLOR, false, false);
        table.initNewLine();
        table.addColumn("![hist](" + relPathToOutput + "/" + main.getName() + ")");
        if (compScalars != null) {
            File comp = RupHistogramPlots.plotRuptureHistogram(outputDir, prefix + "_comp", compScalars, inputScalars, inputUniques, COMP_COLOR, false, false);
            table.addColumn("![hist](" + relPathToOutput + "/" + comp.getName() + ")");
        }
        table.finalizeLine();
        boolean bl = hasCompSol = compScalars != null && compScalars.getSol() != null;
        if (inputScalars.getSol() != null || hasCompSol) {
            for (boolean logY : new boolean[]{false, true}) {
                String logAdd;
                table.initNewLine();
                String string = logAdd = logY ? "_log" : "";
                if (inputScalars.getSol() != null) {
                    main = RupHistogramPlots.plotRuptureHistogram(outputDir, prefix + "_rates" + logAdd, inputScalars, compScalars, compUniques, MAIN_COLOR, logY, true);
                    table.addColumn("![hist](" + relPathToOutput + "/" + main.getName() + ")");
                } else {
                    table.addColumn("*N/A*");
                }
                if (hasCompSol) {
                    File comp = RupHistogramPlots.plotRuptureHistogram(outputDir, prefix + "_comp_rates" + logAdd, compScalars, inputScalars, inputUniques, COMP_COLOR, logY, true);
                    table.addColumn("![hist](" + relPathToOutput + "/" + comp.getName() + ")");
                } else {
                    table.addColumn("*N/A*");
                }
                table.finalizeLine();
            }
        }
        table.initNewLine();
        main = RupHistogramPlots.plotRuptureCumulatives(outputDir, prefix + "_cumulative", inputScalars, compScalars, compUniques, MAIN_COLOR, false);
        table.addColumn("![hist](" + relPathToOutput + "/" + main.getName() + ")");
        if (compScalars != null) {
            File comp = RupHistogramPlots.plotRuptureCumulatives(outputDir, prefix + "_cumulative_comp", compScalars, inputScalars, inputUniques, COMP_COLOR, false);
            table.addColumn("![hist](" + relPathToOutput + "/" + comp.getName() + ")");
        }
        table.finalizeLine();
    }

    public static File plotRuptureHistogram(File outputDir, String prefix, HistScalarValues scalarVals, HistScalarValues compScalarVals, HashSet<UniqueRupture> compUniques, Color color, boolean logY, boolean rateWeighted) throws IOException {
        ArrayList<Integer> includeIndexes = new ArrayList<Integer>();
        for (int r = 0; r < scalarVals.getRupSet().getNumRuptures(); ++r) {
            includeIndexes.add(r);
        }
        return RupHistogramPlots.plotRuptureHistogram(outputDir, prefix, scalarVals, includeIndexes, compScalarVals, compUniques, color, logY, rateWeighted);
    }

    public static File plotRuptureHistogram(File outputDir, String prefix, HistScalarValues scalarVals, Collection<Integer> includeIndexes, HistScalarValues compScalarVals, HashSet<UniqueRupture> compUniques, Color color, boolean logY, boolean rateWeighted) throws IOException {
        Range yRange;
        int i;
        List<Object> indexesList = includeIndexes instanceof List ? (List<Object>)includeIndexes : new ArrayList<Integer>(includeIndexes);
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        Iterator<Object> iterator = indexesList.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)iterator.next();
            track.addValue(scalarVals.getValue(r));
        }
        if (compScalarVals != null) {
            iterator = compScalarVals.getValues().iterator();
            while (iterator.hasNext()) {
                double scalar = (Double)iterator.next();
                track.addValue(scalar);
            }
        }
        HistScalar histScalar = scalarVals.getScalar();
        HistogramFunction hist = histScalar.getHistogram(track);
        boolean logX = histScalar.isLogX();
        HistogramFunction commonHist = null;
        if (compUniques != null) {
            commonHist = new HistogramFunction(hist.getMinX(), hist.getMaxX(), hist.size());
        }
        HistogramFunction compHist = null;
        if (!(compScalarVals == null || rateWeighted && compScalarVals.getSol() == null)) {
            compHist = new HistogramFunction(hist.getMinX(), hist.getMaxX(), hist.size());
            for (i = 0; i < compScalarVals.getValues().size(); ++i) {
                double y;
                double scalar = compScalarVals.getValue(i);
                double d = y = rateWeighted ? compScalarVals.getSol().getRateForRup(i) : 1.0;
                int index = logX ? (scalar <= 0.0 ? 0 : compHist.getClosestXIndex(Math.log10(scalar))) : compHist.getClosestXIndex(scalar);
                compHist.add(index, y);
            }
        }
        for (i = 0; i < indexesList.size(); ++i) {
            double y;
            int rupIndex = (Integer)indexesList.get(i);
            double scalar = scalarVals.getValue(i);
            double d = y = rateWeighted ? scalarVals.getSol().getRateForRup(rupIndex) : 1.0;
            int index = logX ? (scalar <= 0.0 ? 0 : hist.getClosestXIndex(Math.log10(scalar))) : hist.getClosestXIndex(scalar);
            hist.add(index, y);
            if (compUniques == null || !compUniques.contains(scalarVals.getRups().get((int)rupIndex).unique)) continue;
            commonHist.add(index, y);
        }
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        if (logX) {
            ArbitrarilyDiscretizedFunc linearHist = new ArbitrarilyDiscretizedFunc();
            for (Point2D pt : hist) {
                linearHist.set(Math.pow(10.0, pt.getX()), pt.getY());
            }
            linearHist.setName("Unique");
            funcs.add(linearHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
            if (commonHist != null) {
                linearHist = new ArbitrarilyDiscretizedFunc();
                for (Point2D pt : commonHist) {
                    linearHist.set(Math.pow(10.0, pt.getX()), pt.getY());
                }
                linearHist.setName("Common To Both");
                funcs.add(linearHist);
                chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, COMMON_COLOR));
            }
        } else {
            hist.setName("Unique");
            funcs.add(hist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
            if (commonHist != null) {
                commonHist.setName("Common To Both");
                funcs.add(commonHist);
                chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, COMMON_COLOR));
            }
        }
        String title = TITLES ? histScalar.getName() + " Histogram" : " ";
        String xAxisLabel = histScalar.getxAxisLabel();
        String yAxisLabel = rateWeighted ? "Annual Rate" : "Count";
        PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
        spec.setLegendVisible(compUniques != null);
        Range xRange = logX ? new Range(Math.pow(10.0, hist.getMinX() - 0.5 * hist.getDelta()), Math.pow(10.0, hist.getMaxX() + 0.5 * hist.getDelta())) : new Range(hist.getMinX() - 0.5 * hist.getDelta(), hist.getMaxX() + 0.5 * hist.getDelta());
        HeadlessGraphPanel gp = new HeadlessGraphPanel(PLOT_PREFS_DEFAULT);
        if (logY) {
            double minY = Double.POSITIVE_INFINITY;
            double maxY = 0.0;
            for (DiscretizedFunc discretizedFunc : funcs) {
                for (Point2D pt : discretizedFunc) {
                    double y = pt.getY();
                    if (!(y > 0.0)) continue;
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                }
            }
            if (compHist != null) {
                for (Point2D point2D : compHist) {
                    double y = point2D.getY();
                    if (!(y > 0.0)) continue;
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                }
            }
            yRange = new Range(Math.pow(10.0, Math.floor(Math.log10(minY))), Math.pow(10.0, Math.ceil(Math.log10(maxY))));
        } else {
            double maxY = hist.getMaxY();
            if (compHist != null) {
                maxY = Math.max(maxY, compHist.getMaxY());
            }
            yRange = new Range(0.0, 1.05 * maxY);
        }
        gp.drawGraphPanel(spec, logX, logY, xRange, yRange);
        gp.getChartPanel().setSize(800, 600);
        File pngFile = new File(outputDir, prefix + ".png");
        File pdfFile = new File(outputDir, prefix + ".pdf");
        File txtFile = new File(outputDir, prefix + ".txt");
        gp.saveAsPNG(pngFile.getAbsolutePath());
        gp.saveAsPDF(pdfFile.getAbsolutePath());
        gp.saveAsTXT(txtFile.getAbsolutePath());
        return pngFile;
    }

    private static File plotMechSpecificHist(File outputDir, String prefix, HistScalar histScalar, HistogramFunction countHist, HistogramFunction rateHist, RakeType type) throws IOException {
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        ArrayList<Range> yRanges = new ArrayList<Range>();
        ArrayList<Boolean> yLogs = new ArrayList<Boolean>();
        Range xRange = null;
        boolean logX = histScalar.isLogX();
        Color color = type.color;
        for (int p = 0; p < 3; ++p) {
            Range yRange;
            boolean rateWeighted;
            boolean logY;
            HistogramFunction hist;
            if (p == 0) {
                hist = countHist;
                logY = false;
                rateWeighted = false;
            } else if (p == 1) {
                hist = rateHist;
                logY = false;
                rateWeighted = true;
            } else {
                hist = rateHist;
                logY = true;
                rateWeighted = true;
            }
            ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            if (logX) {
                ArbitrarilyDiscretizedFunc linearHist = new ArbitrarilyDiscretizedFunc();
                for (Point2D pt : hist) {
                    linearHist.set(Math.pow(10.0, pt.getX()), pt.getY());
                }
                funcs.add(linearHist);
                chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
            } else {
                funcs.add(hist);
                chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
            }
            String title = TITLES ? histScalar.getName() + " Histogram" : " ";
            String xAxisLabel = histScalar.getxAxisLabel();
            String yAxisLabel = rateWeighted ? "Annual Rate" : "Count";
            PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
            if (xRange == null) {
                xRange = logX ? new Range(Math.pow(10.0, hist.getMinX() - 0.5 * hist.getDelta()), Math.pow(10.0, hist.getMaxX() + 0.5 * hist.getDelta())) : new Range(hist.getMinX() - 0.5 * hist.getDelta(), hist.getMaxX() + 0.5 * hist.getDelta());
            }
            if (logY) {
                double minY = Double.POSITIVE_INFINITY;
                double maxY = 0.0;
                for (DiscretizedFunc discretizedFunc : funcs) {
                    for (Point2D pt : discretizedFunc) {
                        double y = pt.getY();
                        if (!(y > 0.0)) continue;
                        minY = Math.min(minY, y);
                        maxY = Math.max(maxY, y);
                    }
                }
                yRange = new Range(Math.pow(10.0, Math.floor(Math.log10(minY))), Math.pow(10.0, Math.ceil(Math.log10(maxY))));
            } else {
                double maxY = hist.getMaxY();
                yRange = new Range(0.0, 1.05 * maxY);
            }
            specs.add(spec);
            yRanges.add(yRange);
            yLogs.add(logY);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel(PLOT_PREFS_DEFAULT);
        gp.drawGraphPanel(specs, List.of(Boolean.valueOf(logX)), yLogs, List.of(xRange), yRanges);
        gp.getChartPanel().setSize(800, 1200);
        File pngFile = new File(outputDir, prefix + ".png");
        gp.saveAsPNG(pngFile.getAbsolutePath());
        return pngFile;
    }

    private static HistogramFunction getCumulativeFractionalHist(HistogramFunction hist) {
        HistogramFunction ret = new HistogramFunction(hist.getMinX(), hist.getMaxX(), hist.size());
        double sum = 0.0;
        for (int i = 0; i < hist.size(); ++i) {
            ret.set(i, sum += hist.getY(i));
        }
        ret.scale(1.0 / sum);
        return ret;
    }

    public static File plotRuptureCumulatives(File outputDir, String prefix, HistScalarValues scalarVals, HistScalarValues compScalarVals, HashSet<UniqueRupture> compUniques, Color color, boolean logY) throws IOException {
        ArrayList<Integer> includeIndexes = new ArrayList<Integer>();
        for (int r = 0; r < scalarVals.getRupSet().getNumRuptures(); ++r) {
            includeIndexes.add(r);
        }
        return RupHistogramPlots.plotRuptureCumulatives(outputDir, prefix, scalarVals, includeIndexes, compScalarVals, compUniques, color, logY);
    }

    public static File plotRuptureCumulatives(File outputDir, String prefix, HistScalarValues scalarVals, Collection<Integer> includeIndexes, HistScalarValues compScalarVals, HashSet<UniqueRupture> compUniques, Color color, boolean logY) throws IOException {
        List<Object> indexesList = includeIndexes instanceof List ? (List<Object>)includeIndexes : new ArrayList<Integer>(includeIndexes);
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        Iterator<Object> iterator = indexesList.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)iterator.next();
            track.addValue(scalarVals.getValue(r));
        }
        if (compScalarVals != null) {
            iterator = compScalarVals.getValues().iterator();
            while (iterator.hasNext()) {
                double scalar = (Double)iterator.next();
                track.addValue(scalar);
            }
        }
        HistScalar histScalar = scalarVals.getScalar();
        HistogramFunction hist = histScalar.getHistogram(track);
        double origDelta = hist.getDelta();
        double origMin = hist.getMinX();
        double newDelta = origDelta / 50.0;
        double newMin = origMin - 0.5 * origDelta + 0.5 * newDelta;
        int newNum = hist.size() == 1 ? 1 : hist.size() * 50;
        hist = new HistogramFunction(newMin, newNum, newDelta);
        boolean logX = histScalar.isLogX();
        HistogramFunction commonHist = null;
        if (compUniques != null) {
            commonHist = new HistogramFunction(hist.getMinX(), hist.getMaxX(), hist.size());
        }
        HistogramFunction rateHist = null;
        HistogramFunction commonRateHist = null;
        if (scalarVals.getSol() != null) {
            rateHist = new HistogramFunction(hist.getMinX(), hist.getMaxX(), hist.size());
            commonRateHist = new HistogramFunction(hist.getMinX(), hist.getMaxX(), hist.size());
        }
        for (int i = 0; i < indexesList.size(); ++i) {
            int rupIndex = (Integer)indexesList.get(i);
            double scalar = scalarVals.getValue(i);
            int index = logX ? (scalar <= 0.0 ? 0 : hist.getClosestXIndex(Math.log10(scalar))) : hist.getClosestXIndex(scalar);
            hist.add(index, 1.0);
            if (rateHist != null) {
                rateHist.add(index, scalarVals.getSol().getRateForRup(rupIndex));
            }
            if (compUniques == null || !compUniques.contains(scalarVals.getRups().get((int)rupIndex).unique)) continue;
            commonHist.add(index, 1.0);
            if (commonRateHist == null) continue;
            commonRateHist.add(index, scalarVals.getSol().getRateForRup(rupIndex));
        }
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        hist = RupHistogramPlots.getCumulativeFractionalHist(hist);
        if (commonHist != null) {
            commonHist = RupHistogramPlots.getCumulativeFractionalHist(commonHist);
        }
        if (rateHist != null) {
            rateHist = RupHistogramPlots.getCumulativeFractionalHist(rateHist);
        }
        if (commonRateHist != null) {
            commonRateHist = RupHistogramPlots.getCumulativeFractionalHist(commonRateHist);
        }
        boolean[] rateWeighteds = rateHist == null ? new boolean[]{false} : new boolean[]{false, true};
        for (boolean rateWeighted : rateWeighteds) {
            PlotLineType plt;
            HistogramFunction myHist;
            HistogramFunction myCommonHist = null;
            if (rateWeighted) {
                myHist = rateHist;
                myHist.setName("Rate-Weighted");
                if (commonRateHist != null) {
                    myCommonHist = commonRateHist;
                    myCommonHist.setName("Common");
                }
                plt = PlotLineType.DASHED;
            } else {
                myHist = hist;
                myHist.setName("As Discretized");
                if (commonHist != null) {
                    myCommonHist = commonHist;
                    myCommonHist.setName("Common");
                }
                plt = PlotLineType.SOLID;
            }
            if (logX) {
                ArbitrarilyDiscretizedFunc linearHist = new ArbitrarilyDiscretizedFunc();
                for (Point2D pt : myHist) {
                    linearHist.set(Math.pow(10.0, pt.getX()), pt.getY());
                }
                funcs.add(linearHist);
                chars.add(new PlotCurveCharacterstics(plt, 3.0f, color));
                if (myCommonHist == null) continue;
                linearHist = new ArbitrarilyDiscretizedFunc();
                for (Point2D pt : myCommonHist) {
                    linearHist.set(Math.pow(10.0, pt.getX()), pt.getY());
                }
                funcs.add(linearHist);
                chars.add(new PlotCurveCharacterstics(plt, 3.0f, COMMON_COLOR));
                continue;
            }
            funcs.add(myHist);
            chars.add(new PlotCurveCharacterstics(plt, 3.0f, color));
            if (myCommonHist == null) continue;
            funcs.add(myCommonHist);
            chars.add(new PlotCurveCharacterstics(plt, 3.0f, COMMON_COLOR));
        }
        String title = TITLES ? histScalar.getName() + " Cumulative Distribution" : " ";
        String xAxisLabel = histScalar.getxAxisLabel();
        String yAxisLabel = "Cumulative Fraction";
        PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
        spec.setLegendVisible(true);
        Range xRange = logX ? new Range(Math.pow(10.0, hist.getMinX() - 0.5 * hist.getDelta()), Math.pow(10.0, hist.getMaxX() + 0.5 * hist.getDelta())) : new Range(hist.getMinX() - 0.5 * hist.getDelta(), hist.getMaxX() + 0.5 * hist.getDelta());
        HeadlessGraphPanel gp = new HeadlessGraphPanel(PLOT_PREFS_DEFAULT);
        Range yRange = logY ? new Range(1.0E-8, 1.0) : new Range(0.0, 1.0);
        gp.drawGraphPanel(spec, logX, logY, xRange, yRange);
        gp.getChartPanel().setSize(800, 600);
        File pngFile = new File(outputDir, prefix + ".png");
        File pdfFile = new File(outputDir, prefix + ".pdf");
        File txtFile = new File(outputDir, prefix + ".txt");
        gp.saveAsPNG(pngFile.getAbsolutePath());
        gp.saveAsPDF(pdfFile.getAbsolutePath());
        gp.saveAsTXT(txtFile.getAbsolutePath());
        return pngFile;
    }

    private static double calcIdealMinLength(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distAzCalc) {
        FaultSection farS1 = subSects.get(0);
        if (subSects.size() == 1) {
            return LocationUtils.horzDistance(farS1.getFaultTrace().first(), farS1.getFaultTrace().last());
        }
        FaultSection farS2 = null;
        double maxDist = 0.0;
        for (int i = 1; i < subSects.size(); ++i) {
            FaultSection s2 = subSects.get(i);
            double dist = distAzCalc.getDistance(farS1, s2);
            if (!(dist >= maxDist)) continue;
            maxDist = dist;
            farS2 = s2;
        }
        if (farS1 == farS2) {
            return farS1.getTraceLength();
        }
        maxDist = 0.0;
        for (Location l1 : farS1.getFaultTrace()) {
            for (Location l2 : farS2.getFaultTrace()) {
                maxDist = Math.max(maxDist, LocationUtils.horzDistanceFast(l1, l2));
            }
        }
        return maxDist;
    }

    static String generateRuptureInfoPage(FaultSystemRupSet rupSet, ClusterRupture rupture, int rupIndex, File outputDir, String fileNamePrefix, PlausibilityFilterPlot.RupSetPlausibilityResult plausibiltyResult, SectionDistanceAzimuthCalculator distAzCalc) throws IOException {
        HistScalar[] scalars;
        DecimalFormat format = new DecimalFormat("###,###.#");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("## Rupture " + rupIndex);
        lines.add("");
        lines.add("![Rupture " + rupIndex + "](../resources/" + fileNamePrefix + ".png)");
        HashMap<Integer, Jump> jumps = new HashMap<Integer, Jump>();
        for (Jump jump : rupture.getJumpsIterable()) {
            jumps.put(jump.fromSection.getSectionId(), jump);
        }
        lines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder().initNewLine();
        for (HistScalar scalar : scalars = HistScalar.values()) {
            table.addColumn("**" + scalar.getxAxisLabel() + "**");
        }
        table.finalizeLine().initNewLine();
        for (HistScalar scalar : scalars) {
            double val = scalar.getValue(rupIndex, rupSet, rupture, distAzCalc);
            if (Math.abs(val) < 1.0) {
                table.addColumn("" + (float)val);
                continue;
            }
            table.addColumn(format.format(val));
        }
        table.finalizeLine();
        lines.addAll(table.wrap(5, 0).build());
        lines.add("");
        lines.add("Text representation:");
        lines.add("");
        lines.add("```");
        lines.add(rupture.toString());
        lines.add("```");
        lines.add("");
        List<FaultSection> sections = rupSet.getFaultSectionDataForRupture(rupIndex);
        Location startLocation = (Location)sections.get(0).getFaultTrace().get(0);
        Location lastLocation = (Location)sections.get(sections.size() - 1).getFaultTrace().get(sections.get(sections.size() - 1).getFaultTrace().size() - 1);
        Object location = null;
        location = startLocation.getLatitude() < lastLocation.getLatitude() ? " South " : " North ";
        location = startLocation.getLongitude() < lastLocation.getLongitude() ? (String)location + " West " : (String)location + " East ";
        lines.add("");
        lines.add("Fault section list. First section listed is " + (String)location + " relative to the last section.");
        lines.add("");
        int lastParent = Integer.MIN_VALUE;
        ArrayList<CallSite> sectionIds = new ArrayList<CallSite>();
        for (FaultSection section : sections) {
            if (lastParent != section.getParentSectionId()) {
                if (lastParent != Integer.MIN_VALUE) {
                    lines.add("    * " + String.join((CharSequence)", ", sectionIds));
                    sectionIds.clear();
                }
                lines.add("* " + section.getParentSectionName());
                lastParent = section.getParentSectionId();
            }
            if (jumps.containsKey(section.getSectionId())) {
                Jump jump = (Jump)jumps.get(section.getSectionId());
                sectionIds.add((CallSite)((Object)(section.getSectionId() + " (jump to " + jump.toSection.getSectionId() + ", " + format.format(jump.distance) + "km)")));
                continue;
            }
            sectionIds.add((CallSite)((Object)("" + section.getSectionId())));
        }
        lines.add("    * " + String.join((CharSequence)", ", sectionIds));
        if (plausibiltyResult != null) {
            lines.add("");
            lines.add("### Plausibility Filters Results");
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.addLine("Name", "Result", "Scalar Value");
            for (int f = 0; f < plausibiltyResult.filters.size(); ++f) {
                table.initNewLine();
                table.addColumn(plausibiltyResult.filters.get(f).getName());
                PlausibilityResult result = plausibiltyResult.filterResults.get(f).get(rupIndex);
                if (result == null) {
                    table.addColumn("Erred");
                } else {
                    table.addColumn(result.toString());
                }
                if (plausibiltyResult.scalarVals.get(f) == null) {
                    table.addColumn("*N/A*");
                    continue;
                }
                Double scalar = plausibiltyResult.scalarVals.get(f).get(rupIndex);
                if (scalar == null) {
                    table.addColumn("*N/A*");
                    continue;
                }
                String str = "" + scalar.floatValue();
                PlausibilityFilter filter = plausibiltyResult.filters.get(f);
                String units = ((ScalarValuePlausibiltyFilter)filter).getScalarUnits();
                if (units != null) {
                    str = str + " (" + units + ")";
                }
                table.addColumn(str);
            }
            table.finalizeLine();
            lines.addAll(table.build());
        }
        MarkdownUtils.writeHTML(lines, new File(outputDir, fileNamePrefix + ".html"));
        return outputDir.getName() + "/" + fileNamePrefix + ".html";
    }

    public static enum HistScalar {
        LENGTH("Rupture Length", "Length (km)", "Total length (km) of the rupture, not including jumps or gaps."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                HistogramFunction hist = scalarTrack.getMax() <= 250.0 ? HistogramFunction.getEncompassingHistogram(0.0, Math.max(100.0, scalarTrack.getMax()), 10.0) : (scalarTrack.getMax() <= 500.0 ? HistogramFunction.getEncompassingHistogram(0.0, scalarTrack.getMax(), 20.0) : HistogramFunction.getEncompassingHistogram(0.0, scalarTrack.getMax(), 50.0));
                return hist;
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                return rupSet.getLengthForRup(index) * 0.001;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        MAG("Rupture Magnitude", "Magnitude", "Magnitude of the rupture."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                double minMag = 0.5 * Math.floor(scalarTrack.getMin() * 2.0);
                double maxMag = scalarTrack.getMax() > 8.5 ? 0.5 * Math.ceil(scalarTrack.getMax() * 2.0) : (scalarTrack.getMax() > 7.5 ? 8.5 : 8.0);
                return HistogramFunction.getEncompassingHistogram(minMag, maxMag - 0.1, 0.1);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                return rupSet.getMagForRup(index);
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        SECT_COUNT("Subsection Count", "# Subsections", "Total number of subsections involved in a rupture."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                return new HistogramFunction(1.0, (int)Math.max(10.0, scalarTrack.getMax()), 1.0);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                return rupSet.getSectionsIndicesForRup(index).size();
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        CLUSTER_COUNT("Cluster Count", "# Clusters", "Total number of clusters (of contiguous subsections on the same parent fault section) in a rupture."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                return new HistogramFunction(1.0, (int)Math.max(2.0, scalarTrack.getMax()), 1.0);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                return rup.getTotalNumClusters();
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        AREA("Area", "Area (km^2)", "Total area of the rupture (km^2)."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                HistogramFunction hist = HistogramFunction.getEncompassingHistogram(0.0, scalarTrack.getMax(), 100.0);
                return hist;
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                return rupSet.getAreaForRup(index) * 1.0E-6;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        MAX_JUMP_DIST("Maximum Jump Dist", "Maximum Jump Distance (km)", "The maximum jump distance in the rupture."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                double delta = scalarTrack.getMax() > 20.0 ? 2.0 : 1.0;
                return HistogramFunction.getEncompassingHistogram(0.0, scalarTrack.getMax(), delta);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                double max = 0.0;
                for (Jump jump : rup.getJumpsIterable()) {
                    max = Math.max(max, jump.distance);
                }
                return max;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        CUM_JUMP_DIST("Cumulative Jump Dist", "Cumulative Jump Distance (km)", "The total cumulative jump distance summed over all jumps in the rupture."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                double delta = scalarTrack.getMax() > 20.0 ? 2.0 : 1.0;
                return HistogramFunction.getEncompassingHistogram(0.0, Math.max(1.0, scalarTrack.getMax()), delta);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                double sum = 0.0;
                for (Jump jump : rup.getJumpsIterable()) {
                    sum += jump.distance;
                }
                return sum;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        IDEAL_LEN_RATIO("Ideal Length Ratio", "Ideal Length Ratio", "The ratio between the total length of this rupture and the 'idealized length,' which we define as the straight line distance between the furthest two subsections."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                return new HistogramFunction(0.25, 10, 0.5);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                double idealLen = RupHistogramPlots.calcIdealMinLength(rupSet.getFaultSectionDataForRupture(index), distAzCalc);
                double len = LENGTH.getValue(index, rupSet, rup, distAzCalc);
                return len / idealLen;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        IDEAL_LEN_DIFF("Ideal Length Difference", "Ideal Length Difference", "The difference between the total length of this rupture and the 'idealized length,' which we define as the straight line distance between the furthest two subsections."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                HistogramFunction hist = scalarTrack.getMax() <= 100.0 ? HistogramFunction.getEncompassingHistogram(scalarTrack.getMin(), 100.0, 10.0) : HistogramFunction.getEncompassingHistogram(scalarTrack.getMin(), scalarTrack.getMax(), 50.0);
                return hist;
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                double idealLen = RupHistogramPlots.calcIdealMinLength(rupSet.getFaultSectionDataForRupture(index), distAzCalc);
                double len = LENGTH.getValue(index, rupSet, rup, distAzCalc);
                return len - idealLen;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        RAKE("Rake", "Rake (degrees)", "The area-averaged rake for this rupture."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                return new HistogramFunction(-175.0, 36, 10.0);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                return rupSet.getAveRakeForRup(index);
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return null;
            }
        }
        ,
        CUM_RAKE_CHANGE("Cumulative Rake Change", "Cumulative Rake Change (degrees)", "Cumulative rake change for this rupture."){
            CumulativeRakeChangeFilter filter = null;

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                return HistogramFunction.getEncompassingHistogram(0.0, Math.max(180.0, scalarTrack.getMax()), 60.0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                if (this.filter == null) {
                    11 var5_5 = this;
                    synchronized (var5_5) {
                        if (this.filter == null) {
                            this.filter = new CumulativeRakeChangeFilter(180.0f);
                        }
                    }
                }
                return this.filter.getValue(rup).floatValue();
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        MECH_CHANGE("Mechanism Change", "# Mechanism Changes", "The number of times a rupture changed mechanisms, e.g., from right-lateral SS to left-lateral or SS to reverse."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                int num = Integer.max(2, 1 + (int)scalarTrack.getMax());
                return new HistogramFunction(0.0, num, 1.0);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                if (rup.getTotalNumClusters() == 1) {
                    return 0.0;
                }
                int count = 0;
                for (Jump jump : rup.getJumpsIterable()) {
                    if (RakeType.getType(jump.fromSection.getAveRake()) == RakeType.getType(jump.toSection.getAveRake())) continue;
                    ++count;
                }
                return count;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        CUM_AZ_CHANGE("Cumulative Azimuth Change", "Cumulative Azimuth Change (degrees)", "Cumulative azimuth change for this rupture."){
            CumulativeAzimuthChangeFilter filter = null;

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                return HistogramFunction.getEncompassingHistogram(0.0, scalarTrack.getMax(), 20.0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                if (this.filter == null) {
                    13 var5_5 = this;
                    synchronized (var5_5) {
                        if (this.filter == null) {
                            this.filter = new CumulativeAzimuthChangeFilter(new JumpAzimuthChangeFilter.SimpleAzimuthCalc(distAzCalc), 560.0f);
                        }
                    }
                }
                return this.filter.getValue(rup).floatValue();
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        }
        ,
        BW_PROB("Biasi & Wesnousky (2016,2017) Prob", "BS '16-'17 Prob", "Biasi & Wesnousky (2016,2017) conditional probability of passing through each jump."){
            private CumulativeProbabilityFilter filter = null;

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                return HistogramFunction.getEncompassingHistogram(-5.0, 0.0, 0.1);
            }

            @Override
            public boolean isLogX() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                if (this.filter == null) {
                    14 var5_5 = this;
                    synchronized (var5_5) {
                        if (this.filter == null) {
                            this.filter = new CumulativeProbabilityFilter(1.0E-10f, BiasiWesnouskyJumpProb.getPrefferedBWCalcs(distAzCalc));
                        }
                    }
                }
                return this.filter.getValue(rup).doubleValue();
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return new double[]{1.0, 0.5, 0.1, 0.05, 0.025, 0.01, 0.001, 0.0};
            }
        }
        ,
        MAX_SLIP_DIFF("Max Slip Rate Difference", "Section Max - Min Slip Rate in Rupture (mm/yr)", "The difference between the slip rate of the sections with the highest and lowest slip rate in the rupture."){

            @Override
            public HistogramFunction getHistogram(DataUtils.MinMaxAveTracker scalarTrack) {
                double max = Math.max(5.0, scalarTrack.getMax());
                if (max > 50.0) {
                    return HistogramFunction.getEncompassingHistogram(0.0, max, 5.0);
                }
                if (max > 20.0) {
                    return HistogramFunction.getEncompassingHistogram(0.0, max, 2.0);
                }
                return HistogramFunction.getEncompassingHistogram(0.0, max, 1.0);
            }

            @Override
            public double getValue(int index, FaultSystemRupSet rupSet, ClusterRupture rup, SectionDistanceAzimuthCalculator distAzCalc) {
                SectSlipRates slipRates = rupSet.getModule(SectSlipRates.class);
                double max = 0.0;
                double min = Double.POSITIVE_INFINITY;
                for (int s : rupSet.getSectionsIndicesForRup(index)) {
                    double slipRate = slipRates.getSlipRate(s) * 1000.0;
                    max = Math.max(max, slipRate);
                    min = Math.min(min, slipRate);
                }
                return max - min;
            }

            @Override
            public double[] getExampleRupPlotFractiles() {
                return example_fractiles_default;
            }
        };

        private String name;
        private String xAxisLabel;
        private String description;

        private HistScalar(String name, String xAxisLabel, String description) {
            this.name = name;
            this.xAxisLabel = xAxisLabel;
            this.description = description;
        }

        public boolean isLogX() {
            return false;
        }

        public abstract HistogramFunction getHistogram(DataUtils.MinMaxAveTracker var1);

        public abstract double getValue(int var1, FaultSystemRupSet var2, ClusterRupture var3, SectionDistanceAzimuthCalculator var4);

        public abstract double[] getExampleRupPlotFractiles();

        public String getName() {
            return this.name;
        }

        public String getxAxisLabel() {
            return this.xAxisLabel;
        }
    }

    public static enum RakeType {
        RIGHT_LATERAL("Right-Lateral SS", "rl", Color.RED.darker()){

            @Override
            public boolean isMatch(double rake) {
                return (float)rake >= -180.0f && (float)rake <= -170.0f || (float)rake <= 180.0f && (float)rake >= 170.0f;
            }
        }
        ,
        LEFT_LATERAL("Left-Lateral SS", "ll", Color.GREEN.darker()){

            @Override
            public boolean isMatch(double rake) {
                return (float)rake >= -10.0f && (float)rake <= 10.0f;
            }
        }
        ,
        REVERSE("Reverse", "rev", Color.BLUE.darker()){

            @Override
            public boolean isMatch(double rake) {
                return (float)rake >= 80.0f && (float)rake <= 100.0f;
            }
        }
        ,
        NORMAL("Normal", "norm", Color.YELLOW.darker()){

            @Override
            public boolean isMatch(double rake) {
                return (float)rake >= -100.0f && (float)rake <= -80.0f;
            }
        }
        ,
        OBLIQUE("Oblique", "oblique", Color.MAGENTA.darker()){

            @Override
            public boolean isMatch(double rake) {
                for (RakeType type : 5.values()) {
                    if (type == this || !type.isMatch(rake)) continue;
                    return false;
                }
                return true;
            }
        };

        public final String name;
        public final String prefix;
        public final Color color;

        private RakeType(String name, String prefix, Color color) {
            this.name = name;
            this.prefix = prefix;
            this.color = color;
        }

        public abstract boolean isMatch(double var1);

        public static RakeType getType(double rake) {
            for (RakeType type : RakeType.values()) {
                if (type == OBLIQUE || !type.isMatch(rake)) continue;
                return type;
            }
            return OBLIQUE;
        }
    }

    public static class HistScalarValues {
        private final HistScalar scalar;
        private final FaultSystemRupSet rupSet;
        private final FaultSystemSolution sol;
        private final List<ClusterRupture> rups;
        private final List<Double> values;

        public HistScalarValues(HistScalar scalar, FaultSystemRupSet rupSet, FaultSystemSolution sol, List<ClusterRupture> rups, SectionDistanceAzimuthCalculator distAzCalc) {
            this.scalar = scalar;
            this.rupSet = rupSet;
            this.sol = sol;
            this.rups = rups;
            this.values = new ArrayList<Double>();
            System.out.println("Calculating " + scalar.getName() + " for " + rups.size() + " ruptures");
            for (int r = 0; r < rups.size(); ++r) {
                this.values.add(scalar.getValue(r, rupSet, rups.get(r), distAzCalc));
            }
        }

        public FaultSystemRupSet getRupSet() {
            return this.rupSet;
        }

        public List<Double> getValues() {
            return this.values;
        }

        public double getValue(int rupIndex) {
            return this.values.get(rupIndex);
        }

        public HistScalar getScalar() {
            return this.scalar;
        }

        public FaultSystemSolution getSol() {
            return this.sol;
        }

        public List<ClusterRupture> getRups() {
            return this.rups;
        }
    }
}

