/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.data.Range;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public class SectMaxValuesPlot
extends AbstractRupSetPlot {
    public static final List<RupHistogramPlots.HistScalar> RUP_SET_DEFAULTS = List.of(RupHistogramPlots.HistScalar.LENGTH, RupHistogramPlots.HistScalar.MAG, RupHistogramPlots.HistScalar.CUM_JUMP_DIST, RupHistogramPlots.HistScalar.CUM_RAKE_CHANGE, RupHistogramPlots.HistScalar.CUM_AZ_CHANGE);
    public static final List<RupHistogramPlots.HistScalar> SOL_DEFAULTS = List.of(RupHistogramPlots.HistScalar.LENGTH, RupHistogramPlots.HistScalar.MAG);
    private List<RupHistogramPlots.HistScalar> scalars;

    public SectMaxValuesPlot() {
        this(RUP_SET_DEFAULTS);
    }

    public SectMaxValuesPlot(List<RupHistogramPlots.HistScalar> scalars) {
        this.scalars = scalars;
    }

    @Override
    public String getName() {
        return "Subsection Maximum Values";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("These plots show the maximum value of various quantities across all ruptures for which each individual subsection participates. This is useful, for example, to find sections with low maximum magnitudes (due to low or no connectivity).");
        lines.add("");
        Map<RupHistogramPlots.HistScalar, RupHistogramPlots.HistScalarValues> imputVals = this.getInputs(meta.primary);
        Map<RupHistogramPlots.HistScalar, RupHistogramPlots.HistScalarValues> compVals = null;
        if (meta.comparison != null && meta.comparisonHasSameSects && meta.comparison.rupSet.hasModule(ClusterRuptures.class)) {
            compVals = this.getInputs(meta.comparison);
        }
        for (RupHistogramPlots.HistScalar scalar : this.scalars) {
            String prefix;
            MarkdownUtils.TableBuilder table;
            RupHistogramPlots.HistScalarValues compScalars;
            RupHistogramPlots.HistScalarValues inputScalars;
            block10: {
                inputScalars = imputVals.get((Object)scalar);
                compScalars = compVals == null ? null : compVals.get((Object)scalar);
                lines.add(this.getSubHeading() + " Subsection Maximum " + scalar.getName());
                lines.add(topLink);
                lines.add("");
                table = MarkdownUtils.tableBuilder();
                if (compScalars != null) {
                    table.addLine(meta.primary.name, meta.comparison.name);
                }
                prefix = "sect_max_" + scalar.name();
                try {
                    if (!SectMaxValuesPlot.plotScalarMaxMapView(rupSet, resourcesDir, prefix, SectMaxValuesPlot.getTruncatedTitle(meta.primary.name), inputScalars, compScalars, meta.region, MAIN_COLOR, false, false)) {
                    }
                    break block10;
                }
                catch (Exception err) {
                    System.out.println("Caught exception: " + err.getLocalizedMessage());
                }
                continue;
            }
            table.initNewLine();
            table.addColumn("![map](" + relPathToResources + "/" + prefix + ".png)");
            if (compScalars != null) {
                SectMaxValuesPlot.plotScalarMaxMapView(meta.comparison.rupSet, resourcesDir, prefix + "_comp", SectMaxValuesPlot.getTruncatedTitle(meta.comparison.name), compScalars, inputScalars, meta.region, COMP_COLOR, false, false);
                table.addColumn("![map](" + relPathToResources + "/" + prefix + "_comp.png)");
            }
            table.finalizeLine().initNewLine();
            table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + prefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + prefix + ".geojson)");
            if (compScalars != null) {
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + prefix + "_comp.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + prefix + "_comp.geojson)");
            }
            table.finalizeLine().initNewLine();
            table.addColumn("![map](" + relPathToResources + "/" + prefix + "_hist.png)");
            if (compScalars != null) {
                table.addColumn("![map](" + relPathToResources + "/" + prefix + "_comp_hist.png)");
            }
            table.finalizeLine();
            if (compScalars != null) {
                table.addLine("**Difference**", "**Ratio**");
                table.initNewLine();
                SectMaxValuesPlot.plotScalarMaxMapView(rupSet, resourcesDir, prefix + "_diff", "Difference", inputScalars, compScalars, meta.region, MAIN_COLOR, true, false);
                table.addColumn("![map](" + relPathToResources + "/" + prefix + "_diff.png)");
                SectMaxValuesPlot.plotScalarMaxMapView(rupSet, resourcesDir, prefix + "_ratio", "Ratio", inputScalars, compScalars, meta.region, MAIN_COLOR, false, true);
                table.addColumn("![map](" + relPathToResources + "/" + prefix + "_ratio.png)");
                table.finalizeLine().initNewLine();
                table.addColumn("![map](" + relPathToResources + "/" + prefix + "_diff_hist.png)");
                table.addColumn("![map](" + relPathToResources + "/" + prefix + "_ratio_hist.png)");
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
        }
        return lines;
    }

    private Map<RupHistogramPlots.HistScalar, RupHistogramPlots.HistScalarValues> getInputs(RupSetMetadata meta) {
        HashMap<RupHistogramPlots.HistScalar, RupHistogramPlots.HistScalarValues> ret = new HashMap<RupHistogramPlots.HistScalar, RupHistogramPlots.HistScalarValues>();
        for (RupHistogramPlots.HistScalar scalar : this.scalars) {
            RupHistogramPlots.HistScalarValues values = null;
            for (RupHistogramPlots.HistScalarValues oVals : meta.scalarValues) {
                if (oVals.getScalar() != scalar) continue;
                values = oVals;
                break;
            }
            if (values == null) {
                values = new RupHistogramPlots.HistScalarValues(scalar, meta.rupSet, meta.sol, meta.rupSet.requireModule(ClusterRuptures.class).getAll(), meta.rupSet.requireModule(SectionDistanceAzimuthCalculator.class));
            }
            ret.put(scalar, values);
        }
        return ret;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(SectionDistanceAzimuthCalculator.class, ClusterRuptures.class);
    }

    @Override
    public List<String> getSummary(ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) {
        if (!new File(resourcesDir, "sect_max_LENGTH.png").exists()) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (meta.comparison != null && meta.comparisonHasSameSects) {
            table.addLine(meta.primary.name, meta.comparison.name);
            table.addLine("![Primary](" + relPathToResources + "/sect_max_LENGTH.png)", "![Comparison](" + relPathToResources + "/sect_max_LENGTH_comp.png)");
            table.initNewLine();
            table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/sect_max_LENGTH.geojson") + " [Download GeoJSON](" + relPathToResources + "/sect_max_LENGTH.geojson)");
            table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/sect_max_LENGTH_comp.geojson") + " [Download GeoJSON](" + relPathToResources + "/sect_max_LENGTH_comp.geojson)");
            table.finalizeLine();
            table.addLine("![Primary](" + relPathToResources + "/sect_max_LENGTH_diff.png)", "![Comparison](" + relPathToResources + "/sect_max_LENGTH_ratio.png)");
        } else {
            table.addLine("![Primary](" + relPathToResources + "/hist_LENGTH.png)");
            table.addLine("![Primary](" + relPathToResources + "/sect_max_LENGTH.png)");
            table.addLine(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/sect_max_LENGTH.geojson") + " [Download GeoJSON](" + relPathToResources + "/sect_max_LENGTH.geojson)");
        }
        lines.addAll(table.build());
        return lines;
    }

    public static boolean plotScalarMaxMapView(FaultSystemRupSet rupSet, File outputDir, String prefix, String title, RupHistogramPlots.HistScalarValues scalarVals, RupHistogramPlots.HistScalarValues compScalarVals, Region reg, Color mainColor, boolean difference, boolean ratio) throws IOException {
        CPT cpt;
        HistogramFunction hist;
        ArrayList<Double> values = new ArrayList<Double>();
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            values.add(Double.NEGATIVE_INFINITY);
        }
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            double value = scalarVals.getValues().get(r);
            for (int s : rupSet.getSectionsIndicesForRup(r)) {
                double prevMax = (Double)values.get(s);
                if (!(value > prevMax)) continue;
                values.set(s, value);
            }
        }
        DataUtils.MinMaxAveTracker maxTrack = new DataUtils.MinMaxAveTracker();
        Iterator value = values.iterator();
        while (value.hasNext()) {
            double value2 = (Double)value.next();
            if (!Double.isFinite(value2)) continue;
            maxTrack.addValue(value2);
        }
        if (maxTrack.getNum() == 0) {
            return false;
        }
        Preconditions.checkState((compScalarVals != null || !difference && !ratio ? 1 : 0) != 0);
        if (compScalarVals != null) {
            ArrayList<Double> compValues = new ArrayList<Double>();
            for (int s = 0; s < compScalarVals.getRupSet().getNumSections(); ++s) {
                compValues.add(Double.NEGATIVE_INFINITY);
            }
            for (int r = 0; r < compScalarVals.getRupSet().getNumRuptures(); ++r) {
                double value3 = compScalarVals.getValues().get(r);
                for (int s : compScalarVals.getRupSet().getSectionsIndicesForRup(r)) {
                    double prevMax = (Double)compValues.get(s);
                    if (!(value3 > prevMax)) continue;
                    compValues.set(s, value3);
                }
            }
            Iterator r = compValues.iterator();
            while (r.hasNext()) {
                double value4 = (Double)r.next();
                if (!Double.isFinite(value4)) continue;
                maxTrack.addValue(value4);
            }
            if (difference) {
                Preconditions.checkState((compValues.size() == values.size() ? 1 : 0) != 0);
                for (int i = 0; i < values.size(); ++i) {
                    values.set(i, (Double)values.get(i) - (Double)compValues.get(i));
                }
            } else if (ratio) {
                Preconditions.checkState((compValues.size() == values.size() ? 1 : 0) != 0);
                for (int i = 0; i < values.size(); ++i) {
                    values.set(i, (Double)values.get(i) / (Double)compValues.get(i));
                }
            }
        }
        RupHistogramPlots.HistScalar histScalar = scalarVals.getScalar();
        if (difference) {
            double maxAbsDiff = 0.0;
            Iterator s = values.iterator();
            while (s.hasNext()) {
                double value5 = (Double)s.next();
                if (!Double.isFinite(value5)) continue;
                maxAbsDiff = Math.max(maxAbsDiff, Math.abs(value5));
            }
            if (histScalar == RupHistogramPlots.HistScalar.MAG) {
                maxAbsDiff = Math.min(maxAbsDiff, 2.0);
            }
            if ((maxAbsDiff = Math.ceil(maxAbsDiff)) == 0.0) {
                maxAbsDiff = 1.0;
            }
            double delta = histScalar == RupHistogramPlots.HistScalar.CLUSTER_COUNT ? 1.0 : maxAbsDiff / 10.0;
            int num = 2 * (int)(maxAbsDiff / delta) + 1;
            hist = new HistogramFunction(-maxAbsDiff - 0.5 * delta, num, delta);
            cpt = new CPT(-maxAbsDiff, maxAbsDiff, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
        } else if (ratio) {
            hist = histScalar == RupHistogramPlots.HistScalar.MAG ? new HistogramFunction(0.666667, 1.5, 30) : new HistogramFunction(0.5, 2.0, 30);
            CPT belowCPT = new CPT(hist.getMinX(), 1.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE);
            CPT aboveCPT = new CPT(1.0, hist.getMaxX(), Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
            cpt = new CPT();
            cpt.addAll(belowCPT);
            cpt.addAll(aboveCPT);
        } else {
            hist = histScalar.getHistogram(maxTrack);
            cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance();
            cpt = hist.size() == 1 ? cpt.rescale(hist.getX(0), hist.getX(0) <= 0.0 ? 1.0 : hist.getX(0) * 1.5) : cpt.rescale(hist.getMinX() - 0.5 * hist.getDelta(), hist.getMaxX() + 0.5 * hist.getDelta());
        }
        cpt.setBelowMinColor(cpt.getMinColor());
        cpt.setAboveMaxColor(cpt.getMaxColor());
        RupSetMapMaker plotter = new RupSetMapMaker(rupSet, reg);
        plotter.setWriteGeoJSON(!((String)prefix).contains("_ratio") && !((String)prefix).contains("_diff"));
        String cptTitle = "Section Max Participating " + histScalar.getxAxisLabel();
        if (difference) {
            cptTitle = cptTitle + ", Difference";
        }
        if (histScalar.isLogX()) {
            cptTitle = "Log10 " + cptTitle;
        }
        if (histScalar.isLogX()) {
            for (int i = 0; i < values.size(); ++i) {
                values.set(i, Math.log10((Double)values.get(i)));
            }
        }
        plotter.plotSectScalars(values, cpt, cptTitle);
        plotter.plot(outputDir, (String)prefix, title);
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        Iterator num = values.iterator();
        while (num.hasNext()) {
            double value6 = (Double)num.next();
            int index = histScalar.isLogX() && value6 <= 0.0 ? 0 : hist.getClosestXIndex(value6);
            hist.add(index, 1.0);
        }
        if (histScalar.isLogX()) {
            ArbitrarilyDiscretizedFunc linearHist = new ArbitrarilyDiscretizedFunc();
            for (Point2D pt : hist) {
                linearHist.set(Math.pow(10.0, pt.getX()), pt.getY());
            }
            funcs.add(linearHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, mainColor));
        } else {
            funcs.add(hist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, mainColor));
        }
        String xAxisLabel = "Section Max " + histScalar.getxAxisLabel();
        if (difference) {
            xAxisLabel = xAxisLabel + ", Difference";
        }
        String yAxisLabel = "Count";
        PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
        Range xRange = histScalar.isLogX() ? new Range(Math.pow(10.0, hist.getMinX() - 0.5 * hist.getDelta()), Math.pow(10.0, hist.getMaxX() + 0.5 * hist.getDelta())) : new Range(hist.getMinX() - 0.5 * hist.getDelta(), hist.getMaxX() + 0.5 * hist.getDelta());
        Range yRange = new Range(0.0, 1.05 * hist.getMaxY());
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        gp.setLegendFontSize(22);
        gp.drawGraphPanel(spec, histScalar.isLogX(), false, xRange, yRange);
        gp.getChartPanel().setSize(800, 600);
        prefix = (String)prefix + "_hist";
        File pngFile = new File(outputDir, (String)prefix + ".png");
        File pdfFile = new File(outputDir, (String)prefix + ".pdf");
        gp.saveAsPNG(pngFile.getAbsolutePath());
        gp.saveAsPDF(pdfFile.getAbsolutePath());
        return true;
    }
}

