/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;

public class RuptureLengthFilter
implements PlausibilityFilter {
    private double maxLen;

    public RuptureLengthFilter(double maxLen) {
        Preconditions.checkArgument((maxLen > 0.0 ? 1 : 0) != 0);
        this.maxLen = maxLen;
    }

    @Override
    public String getShortName() {
        return "MaxLen";
    }

    @Override
    public String getName() {
        return "Maximum Length " + (float)this.maxLen + " km";
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        double len = 0.0;
        if (rupture != null) {
            for (FaultSubsectionCluster cluster : rupture.clusters) {
                for (FaultSection sect : cluster.subSects) {
                    if (!((len += sect.getTraceLength()) > this.maxLen)) continue;
                    return PlausibilityResult.FAIL_HARD_STOP;
                }
            }
        }
        return PlausibilityResult.PASS;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return false;
    }
}

