/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class TotalAzimuthChangeFilter
implements ScalarValuePlausibiltyFilter<Float> {
    private JumpAzimuthChangeFilter.AzimuthCalc azCalc;
    private float threshold;
    private boolean multiFaultOnly;
    private boolean testFullEnd;

    public TotalAzimuthChangeFilter(JumpAzimuthChangeFilter.AzimuthCalc calc, float threshold, boolean multiFaultOnly, boolean testFullEnd) {
        this.azCalc = calc;
        this.threshold = threshold;
        this.multiFaultOnly = multiFaultOnly;
        this.testFullEnd = testFullEnd;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (rupture.getTotalNumSects() < 3) {
            if (verbose) {
                System.out.println(this.getShortName() + ": passing because <3 sects");
            }
            return PlausibilityResult.PASS;
        }
        if (this.multiFaultOnly && rupture.getTotalNumJumps() == 0) {
            if (verbose) {
                System.out.println(this.getShortName() + ": passing because no jumps");
            }
            return PlausibilityResult.PASS;
        }
        RuptureTreeNavigator navigator = rupture.getTreeNavigator();
        PlausibilityResult result = this.apply(rupture.clusters[0], rupture.clusters[rupture.clusters.length - 1], navigator, verbose);
        if (verbose) {
            System.out.println(this.getShortName() + ": primary starnd result=" + String.valueOf((Object)result));
        }
        for (ClusterRupture splay : rupture.splays.values()) {
            result = result.logicalAnd(this.apply(rupture.clusters[0], splay.clusters[splay.clusters.length - 1], navigator, verbose));
        }
        return result;
    }

    private PlausibilityResult apply(FaultSubsectionCluster startCluster, FaultSubsectionCluster endCluster, RuptureTreeNavigator navigator, boolean verbose) {
        double maxDiff = this.getValue(startCluster, endCluster, navigator, verbose);
        if ((float)maxDiff <= this.threshold) {
            return PlausibilityResult.PASS;
        }
        if (verbose) {
            System.out.println(this.getShortName() + ": failing with diff=" + maxDiff);
        }
        if (endCluster.subSects.size() < 2) {
            return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    private double getValue(FaultSubsectionCluster startCluster, FaultSubsectionCluster endCluster, RuptureTreeNavigator navigator, boolean verbose) {
        FaultSection before1 = startCluster.startSect;
        ArrayList<FaultSection> before2s = new ArrayList<FaultSection>();
        if (startCluster.subSects.size() == 1) {
            before2s.addAll(navigator.getDescendants(before1));
        } else {
            before2s.add((FaultSection)startCluster.subSects.get(1));
        }
        Preconditions.checkState((!before2s.isEmpty() ? 1 : 0) != 0);
        double maxDiff = 0.0;
        for (FaultSection before2 : before2s) {
            int startIndex;
            double beforeAz = this.azCalc.calcAzimuth(before1, before2);
            if (endCluster.subSects.size() == 1) {
                FaultSection after2 = (FaultSection)endCluster.subSects.get(0);
                FaultSection after1 = navigator.getPredecessor(after2);
                double afterAz = this.azCalc.calcAzimuth(after1, after2);
                double diff = JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz);
                if (verbose) {
                    System.out.println(this.getShortName() + ": [" + before1.getSectionId() + "," + before2.getSectionId() + "]=" + beforeAz + " => [" + after1.getSectionId() + "," + after2.getSectionId() + "]=" + afterAz + " = " + diff);
                }
                maxDiff = Math.max(Math.abs(diff), maxDiff);
                continue;
            }
            for (int i = startIndex = this.testFullEnd ? 0 : endCluster.subSects.size() - 2; i < endCluster.subSects.size() - 1; ++i) {
                FaultSection after1 = (FaultSection)endCluster.subSects.get(i);
                FaultSection after2 = (FaultSection)endCluster.subSects.get(i + 1);
                double afterAz = this.azCalc.calcAzimuth(after1, after2);
                double diff = JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz);
                if (verbose) {
                    System.out.println(this.getShortName() + ": [" + before1.getSectionId() + "," + before2.getSectionId() + "]=" + beforeAz + " => [" + after1.getSectionId() + "," + after2.getSectionId() + "]=" + afterAz + " = " + diff);
                }
                maxDiff = Math.max(Math.abs(diff), maxDiff);
            }
        }
        return maxDiff;
    }

    @Override
    public String getShortName() {
        return "TotalAz";
    }

    @Override
    public String getName() {
        return "Total Azimuth Change Filter";
    }

    public Float getValue(FaultSubsectionCluster startCluster, ClusterRupture rupture, RuptureTreeNavigator navigator) {
        if (rupture.getTotalNumSects() < 3) {
            return null;
        }
        float maxVal = (float)this.getValue(startCluster, rupture.clusters[rupture.clusters.length - 1], navigator, false);
        for (ClusterRupture splay : rupture.splays.values()) {
            Float splayVal = this.getValue(startCluster, splay, navigator);
            if (splayVal == null) {
                return null;
            }
            maxVal = Float.max(maxVal, splayVal.floatValue());
        }
        return Float.valueOf(maxVal);
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        return this.getValue(rupture.clusters[0], rupture, rupture.getTreeNavigator());
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atMost((Comparable)Float.valueOf(this.threshold));
    }

    @Override
    public String getScalarName() {
        return "Total Azimuth Change";
    }

    @Override
    public String getScalarUnits() {
        return "Degrees";
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }
}

