/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opensha.commons.data.Named;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.PrecomputedClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.DeformationModelFetcher;

public abstract class ClusterConnectionStrategy
implements Named {
    private List<? extends FaultSection> subSections;
    private List<FaultSubsectionCluster> clusters;
    private SectionDistanceAzimuthCalculator distCalc;
    protected transient HashSet<IDPairing> connectedParents;
    protected transient boolean connectionsAdded = false;
    protected transient Multimap<FaultSection, Jump> jumpsFrom;

    public ClusterConnectionStrategy(List<? extends FaultSection> subSections, SectionDistanceAzimuthCalculator distCalc) {
        this(subSections, ClusterConnectionStrategy.buildClusters(subSections), distCalc);
    }

    public ClusterConnectionStrategy(List<? extends FaultSection> subSections, List<FaultSubsectionCluster> clusters, SectionDistanceAzimuthCalculator distCalc) {
        this.subSections = ImmutableList.copyOf(subSections);
        this.clusters = ImmutableList.copyOf(clusters);
        this.distCalc = distCalc;
    }

    public SectionDistanceAzimuthCalculator getDistCalc() {
        return this.distCalc;
    }

    public static List<FaultSubsectionCluster> buildClusters(List<? extends FaultSection> subSections) {
        ArrayList<FaultSubsectionCluster> clusters = new ArrayList<FaultSubsectionCluster>();
        ArrayList<FaultSection> curClusterSects = null;
        int curParentID = -1;
        for (FaultSection faultSection : subSections) {
            int parentID = faultSection.getParentSectionId();
            Preconditions.checkState((parentID >= 0 ? 1 : 0) != 0, (String)"Subsections are required, but this section doesn't have a parent ID set: %s. %s", (int)faultSection.getSectionId(), (Object)faultSection.getSectionName());
            if (parentID != curParentID) {
                if (curClusterSects != null) {
                    clusters.add(new FaultSubsectionCluster((List<? extends FaultSection>)curClusterSects));
                }
                curParentID = parentID;
                curClusterSects = new ArrayList<FaultSection>();
            }
            curClusterSects.add(faultSection);
        }
        clusters.add(new FaultSubsectionCluster(curClusterSects));
        return clusters;
    }

    public synchronized List<? extends FaultSection> getSubSections() {
        return this.subSections;
    }

    protected List<FaultSubsectionCluster> getRawClusters() {
        return this.clusters;
    }

    public synchronized void checkBuildThreaded(int numThreads) {
        if (!this.connectionsAdded) {
            this.buildConnections(numThreads);
        }
    }

    public synchronized List<FaultSubsectionCluster> getClusters() {
        if (!this.connectionsAdded) {
            this.buildConnections(1);
        }
        return this.clusters;
    }

    private int buildConnections(int numThreads) {
        ArrayList jumps = new ArrayList();
        ArrayList<ConnSearchCallable> calls = new ArrayList<ConnSearchCallable>();
        for (int c1 = 0; c1 < this.clusters.size(); ++c1) {
            FaultSubsectionCluster cluster1 = this.clusters.get(c1);
            for (int c2 = c1 + 1; c2 < this.clusters.size(); ++c2) {
                FaultSubsectionCluster faultSubsectionCluster = this.clusters.get(c2);
                calls.add(new ConnSearchCallable(cluster1, faultSubsectionCluster));
            }
        }
        if (numThreads <= 1) {
            for (ConnSearchCallable call : calls) {
                Object newJumps;
                try {
                    newJumps = call.call();
                }
                catch (Exception exception) {
                    throw ExceptionUtils.asRuntimeException(exception);
                }
                if (newJumps == null) continue;
                jumps.addAll(newJumps);
            }
        } else {
            ExecutorService exec = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<List<Jump>>> futures = new ArrayList<Future<List<Jump>>>();
            for (ConnSearchCallable connSearchCallable : calls) {
                futures.add(exec.submit(connSearchCallable));
            }
            for (Future future : futures) {
                try {
                    List newJumps = (List)future.get();
                    if (newJumps == null) continue;
                    jumps.addAll(newJumps);
                }
                catch (Exception e) {
                    exec.shutdown();
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            exec.shutdown();
        }
        this.connectedParents = new HashSet();
        this.jumpsFrom = HashMultimap.create();
        for (Jump jump : jumps) {
            this.connectedParents.add(new IDPairing(jump.fromCluster.parentSectionID, jump.toCluster.parentSectionID));
            this.connectedParents.add(new IDPairing(jump.toCluster.parentSectionID, jump.fromCluster.parentSectionID));
            jump.fromCluster.addConnection(jump);
            Jump reverse = jump.reverse();
            jump.toCluster.addConnection(reverse);
            this.jumpsFrom.put((Object)jump.fromSection, (Object)jump);
            this.jumpsFrom.put((Object)reverse.fromSection, (Object)reverse);
        }
        this.connectionsAdded = true;
        return jumps.size();
    }

    public List<Jump> getAllPossibleJumps() {
        this.getClusters();
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        for (int c1 = 0; c1 < this.clusters.size(); ++c1) {
            FaultSubsectionCluster cluster1 = this.clusters.get(c1);
            jumps.addAll(cluster1.getConnections());
        }
        return jumps;
    }

    public Collection<Jump> getJumpsFrom(FaultSection sect) {
        this.getClusters();
        return this.jumpsFrom.get((Object)sect);
    }

    protected abstract List<Jump> buildPossibleConnections(FaultSubsectionCluster var1, FaultSubsectionCluster var2);

    public boolean areParentSectsConnected(int parentID1, int parentID2) {
        this.getClusters();
        return this.connectedParents.contains(new IDPairing(parentID1, parentID2));
    }

    public abstract double getMaxJumpDist();

    public static void main(String[] args) throws IOException {
        FaultModels fm = FaultModels.FM3_1;
        DeformationModels dm = fm.getFilterBasis();
        DeformationModelFetcher dmFetch = new DeformationModelFetcher(fm, dm, null, 0.1);
        List<FaultSection> parentSects = fm.getFaultSections();
        List<? extends FaultSection> subSects = dmFetch.getSubSectionList();
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        File cacheFile = new File("/tmp/dist_az_cache_" + fm.encodeChoiceString() + "_" + subSects.size() + "_sects_" + parentSects.size() + "_parents.csv");
        if (cacheFile.exists()) {
            System.out.println("Loading dist/az cache from " + cacheFile.getAbsolutePath());
            distAzCalc.loadCacheFile(cacheFile);
        }
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(subSects, distAzCalc, 5.0);
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeHierarchyAdapter(ClusterConnectionStrategy.class, (Object)new ConnStratTypeAdapter(subSects, distAzCalc));
        Gson gson = builder.create();
        String json = gson.toJson((Object)connStrat);
        System.out.println(json);
        System.out.println("Loading...");
        ClusterConnectionStrategy loaded = (ClusterConnectionStrategy)gson.fromJson(json, ClusterConnectionStrategy.class);
        System.out.println("Validating...");
        List<FaultSubsectionCluster> clusters1 = connStrat.getClusters();
        List<FaultSubsectionCluster> clusters2 = loaded.getClusters();
        Preconditions.checkState((clusters1.size() == clusters2.size() ? 1 : 0) != 0);
        for (int i = 0; i < clusters1.size(); ++i) {
            FaultSubsectionCluster c1 = clusters1.get(i);
            FaultSubsectionCluster c2 = clusters2.get(i);
            Preconditions.checkState((boolean)c1.equals(c2), (String)"Cluster mismatch at %s:\n\tOrig: %s\n\tLoaded", (Object)i, (Object)c1, (Object)c2);
            List<Jump> jumps1 = c1.getConnections();
            List<Jump> jumps2 = c2.getConnections();
            if (jumps1 == null) {
                Preconditions.checkState((jumps2 == null ? 1 : 0) != 0);
                continue;
            }
            Preconditions.checkState((jumps1.size() == jumps2.size() ? 1 : 0) != 0);
            for (int j = 0; j < jumps1.size(); ++j) {
                Preconditions.checkState((boolean)jumps1.get(j).equals(jumps2.get(j)));
            }
        }
        System.out.println("DONE");
    }

    private class ConnSearchCallable
    implements Callable<List<Jump>> {
        private FaultSubsectionCluster cluster1;
        private FaultSubsectionCluster cluster2;

        public ConnSearchCallable(FaultSubsectionCluster cluster1, FaultSubsectionCluster cluster2) {
            this.cluster1 = cluster1;
            this.cluster2 = cluster2;
        }

        @Override
        public List<Jump> call() throws Exception {
            return ClusterConnectionStrategy.this.buildPossibleConnections(this.cluster1, this.cluster2);
        }
    }

    public static class ConnStratTypeAdapter
    extends TypeAdapter<ClusterConnectionStrategy> {
        private List<? extends FaultSection> subSects;
        private SectionDistanceAzimuthCalculator distCalc;

        public ConnStratTypeAdapter(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distCalc) {
            this.subSects = subSects;
            this.distCalc = distCalc;
        }

        public void write(JsonWriter out, ClusterConnectionStrategy value) throws IOException {
            out.beginObject();
            out.name("name").value(value.getName());
            if (Double.isFinite(value.getMaxJumpDist())) {
                out.name("maxJumpDist").value(value.getMaxJumpDist());
            }
            out.name("clusters").beginArray();
            for (FaultSubsectionCluster cluster : value.getClusters()) {
                cluster.writeJSON(out);
            }
            out.endArray();
            out.endObject();
        }

        public ClusterConnectionStrategy read(JsonReader in) throws IOException {
            in.beginObject();
            String name = null;
            double maxJumpDist = Double.POSITIVE_INFINITY;
            List<FaultSubsectionCluster> clusters = null;
            block10: while (in.hasNext()) {
                String jsonName;
                switch (jsonName = in.nextName()) {
                    case "name": {
                        name = in.nextString();
                        continue block10;
                    }
                    case "maxJumpDist": {
                        maxJumpDist = in.nextDouble();
                        continue block10;
                    }
                    case "clusters": {
                        clusters = this.loadClusters(in);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unexpected JSON with name=" + jsonName);
            }
            in.endObject();
            Preconditions.checkNotNull(clusters);
            return new PrecomputedClusterConnectionStrategy(name, this.subSects, clusters, maxJumpDist, this.distCalc);
        }

        private List<FaultSubsectionCluster> loadClusters(JsonReader in) throws IOException {
            ArrayList<FaultSubsectionCluster> clusters = new ArrayList<FaultSubsectionCluster>();
            in.beginArray();
            HashMap<Integer, FaultSubsectionCluster> parentsToClusters = new HashMap<Integer, FaultSubsectionCluster>();
            HashMap<FaultSubsectionCluster, List<FaultSubsectionCluster.JumpStub>> clusterJumps = new HashMap<FaultSubsectionCluster, List<FaultSubsectionCluster.JumpStub>>();
            while (in.hasNext()) {
                FaultSubsectionCluster cluster = FaultSubsectionCluster.readJSON(in, this.subSects, clusterJumps, null);
                clusters.add(cluster);
                parentsToClusters.put(cluster.parentSectionID, cluster);
            }
            in.endArray();
            FaultSubsectionCluster.buildJumpsFromStubs(clusters, clusterJumps);
            return clusters;
        }
    }
}

