/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.FaultSectionConnectionsPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.NetRuptureCoulombFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.CumulativeProbPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CoulombSectRatioProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeCoulombProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.AdaptiveClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCache;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class PlausibleClusterConnectionStrategy
extends ClusterConnectionStrategy {
    private SectionDistanceAzimuthCalculator distCalc;
    private double maxJumpDist;
    private JumpSelector selector;
    private List<PlausibilityFilter> filters;
    private ScalarValuePlausibiltyFilter<Double> scalarFilter;
    private Range<Double> scalarRange;
    private static Comparator<CandidateJump> reproducible_tie_breaker = new Comparator<CandidateJump>(){

        @Override
        public int compare(CandidateJump o1, CandidateJump o2) {
            int cmp = Integer.compare(o1.fromSection.getSectionId(), o2.fromSection.getSectionId());
            if (cmp == 0) {
                cmp = Integer.compare(o1.toSection.getSectionId(), o2.toSection.getSectionId());
            }
            return cmp;
        }
    };
    private static final boolean allow_failures_if_none_pass = false;
    public static final JumpSelector JUMP_SELECTOR_DEFAULT_MULTI = new FallbackJumpSelector(false, new PassesMinimizeFailedSelector(false), new AllowMultiEndsSelector(5.0f, new FallbackJumpSelector(true, new BestScalarSelector(2.0))));
    public static final JumpSelector JUMP_SELECTOR_DEFAULT_SINGLE = new FallbackJumpSelector(false, new PassesMinimizeFailedSelector(false), new BestScalarSelector(2.0));
    public static final JumpSelector JUMP_SELECTOR_DEFAULT = JUMP_SELECTOR_DEFAULT_MULTI;
    private static final int debug_parent_1 = -1;
    private static final int debug_parent_2 = -1;
    private static final Comparator<CandidateJump> distCompare = new Comparator<CandidateJump>(){

        @Override
        public int compare(CandidateJump o1, CandidateJump o2) {
            return Float.compare((float)o1.connDistance, (float)o2.connDistance);
        }
    };

    private static double getMinPassingDist(Collection<CandidateJump> candidates) {
        double minDist = Double.POSITIVE_INFINITY;
        for (CandidateJump candidate : candidates) {
            if (candidate.allowedJumps.isEmpty() || !((double)((float)candidate.connDistance) < minDist)) continue;
            minDist = candidate.connDistance;
        }
        return minDist;
    }

    private static List<CandidateJump> onlyPassing(List<CandidateJump> selections) {
        if (selections == null || selections.isEmpty()) {
            return selections;
        }
        ArrayList<CandidateJump> ret = new ArrayList<CandidateJump>();
        for (CandidateJump jump : selections) {
            if (jump.allowedJumps.isEmpty()) continue;
            ret.add(jump);
        }
        return ret;
    }

    public PlausibleClusterConnectionStrategy(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distCalc, double maxJumpDist, PlausibilityFilter ... filters) {
        this(subSects, distCalc, maxJumpDist, JUMP_SELECTOR_DEFAULT, filters);
    }

    public PlausibleClusterConnectionStrategy(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distCalc, double maxJumpDist, JumpSelector selector, PlausibilityFilter ... filters) {
        this(subSects, distCalc, maxJumpDist, selector, Lists.newArrayList((Object[])filters));
    }

    public PlausibleClusterConnectionStrategy(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distCalc, double maxJumpDist, JumpSelector selector, List<PlausibilityFilter> filters) {
        super(subSects, distCalc);
        Preconditions.checkState((!filters.isEmpty() ? 1 : 0) != 0);
        this.maxJumpDist = maxJumpDist;
        this.distCalc = distCalc;
        this.filters = filters;
        this.selector = selector;
        for (PlausibilityFilter filter : filters) {
            Range range;
            if (!(filter instanceof ScalarValuePlausibiltyFilter) || (range = ((ScalarValuePlausibiltyFilter)filter).getAcceptableRange()) == null) continue;
            this.scalarFilter = new ScalarValuePlausibiltyFilter.DoubleWrapper((ScalarValuePlausibiltyFilter)filter);
            this.scalarRange = this.scalarFilter.getAcceptableRange();
            break;
        }
    }

    @Override
    protected List<Jump> buildPossibleConnections(FaultSubsectionCluster from, FaultSubsectionCluster to) {
        return this.buildPossibleConnections(from, to, from.parentSectionID == -1 && to.parentSectionID == -1 || to.parentSectionID == -1 && from.parentSectionID == -1);
    }

    protected List<Jump> buildPossibleConnections(FaultSubsectionCluster from, FaultSubsectionCluster to, boolean debug) {
        ArrayList<CandidateJump> candidates = new ArrayList<CandidateJump>();
        double minDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < from.subSects.size(); ++i) {
            FaultSection s1 = (FaultSection)from.subSects.get(i);
            List<List<? extends FaultSection>> fromStrands = this.getStrandsTo((List<? extends FaultSection>)from.subSects, i);
            boolean fromEnd = i == 0 || i == from.subSects.size() - 1;
            for (int j = 0; j < to.subSects.size(); ++j) {
                boolean toEnd;
                FaultSection s2 = (FaultSection)to.subSects.get(j);
                double dist = this.distCalc.getDistance(s1, s2);
                minDist = Double.min(minDist, dist);
                boolean bl = toEnd = j == 0 || j == to.subSects.size() - 1;
                if (!((float)dist <= (float)this.maxJumpDist)) continue;
                if (debug) {
                    System.out.println(s1.getSectionId() + " => " + s2.getSectionId() + ": " + dist + " km");
                }
                ArrayList<Jump> allowedJumps = new ArrayList<Jump>();
                ArrayList<Jump> failedJumps = new ArrayList<Jump>();
                HashMap<Jump, Double> jumpScalars = this.scalarFilter == null ? null : new HashMap<Jump, Double>();
                Double bestScalar = null;
                List<List<? extends FaultSection>> toStrands = this.getStrandsTo((List<? extends FaultSection>)to.subSects, j);
                double minPassingDist = Double.POSITIVE_INFINITY;
                for (List<? extends FaultSection> fromStrand : fromStrands) {
                    FaultSubsectionCluster fromCluster = new FaultSubsectionCluster(fromStrand);
                    if (!((FaultSection)fromCluster.subSects.get(fromCluster.subSects.size() - 1)).equals(s1)) {
                        fromCluster = fromCluster.reversed();
                    }
                    for (List<? extends FaultSection> toStrand : toStrands) {
                        FaultSubsectionCluster toCluster = new FaultSubsectionCluster(toStrand);
                        if (!((FaultSection)toCluster.subSects.get(0)).equals(s2)) {
                            toCluster = toCluster.reversed();
                        }
                        Jump testJump = new Jump(s1, fromCluster, s2, toCluster, dist);
                        ClusterRupture rupture = new ClusterRupture(fromCluster).take(testJump);
                        if (debug) {
                            System.out.println("\tTrying rupture: " + String.valueOf(rupture));
                        }
                        PlausibilityResult result = PlausibilityResult.PASS;
                        boolean directional = false;
                        for (PlausibilityFilter filter : this.filters) {
                            if (result.canContinue()) {
                                result = result.logicalAnd(filter.apply(rupture, false));
                            }
                            directional = directional || filter.isDirectional(false);
                        }
                        if (debug) {
                            System.out.println("\tResult: " + String.valueOf((Object)result));
                        }
                        Double myScalar = null;
                        if (this.scalarFilter != null && result.isPass()) {
                            myScalar = this.scalarFilter.getValue(rupture);
                            if (debug) {
                                System.out.println("\tScalar val: " + myScalar);
                            }
                        }
                        if (directional && (this.scalarFilter != null || !result.isPass())) {
                            PlausibilityFilter filter;
                            rupture = rupture.reversed();
                            if (debug) {
                                System.out.println("\tTrying reversed: " + String.valueOf(rupture));
                            }
                            PlausibilityResult reverseResult = PlausibilityResult.PASS;
                            Iterator<PlausibilityFilter> iterator = this.filters.iterator();
                            while (iterator.hasNext() && (reverseResult = reverseResult.logicalAnd((filter = iterator.next()).apply(rupture, false))).canContinue()) {
                            }
                            if (debug) {
                                System.out.println("\tResult: " + String.valueOf((Object)reverseResult));
                            }
                            if (this.scalarFilter != null && reverseResult.isPass()) {
                                Double myScalar2 = this.scalarFilter.getValue(rupture);
                                if (debug) {
                                    System.out.println("\tScalar val: " + myScalar2);
                                }
                                if (myScalar == null || myScalar2 != null && ScalarValuePlausibiltyFilter.isValueBetter(myScalar2, myScalar, this.scalarRange)) {
                                    myScalar = myScalar2;
                                }
                            }
                            result = result.logicalOr(reverseResult);
                        }
                        if (myScalar != null) {
                            jumpScalars.put(testJump, myScalar);
                            if (bestScalar == null || ScalarValuePlausibiltyFilter.isValueBetter(myScalar, bestScalar, this.scalarRange)) {
                                bestScalar = myScalar;
                            }
                        }
                        if (result.isPass()) {
                            allowedJumps.add(testJump);
                            for (FaultSection ss1 : testJump.fromCluster.subSects) {
                                for (FaultSection ss2 : testJump.toCluster.subSects) {
                                    minPassingDist = Double.min(minPassingDist, this.distCalc.getDistance(ss1, ss2));
                                }
                            }
                            continue;
                        }
                        failedJumps.add(testJump);
                    }
                }
                CandidateJump candidate = new CandidateJump(from, s1, fromEnd, to, s2, toEnd, dist, minPassingDist, allowedJumps, failedJumps, jumpScalars, bestScalar);
                if (debug) {
                    System.out.println("New candidate: " + String.valueOf(candidate));
                }
                candidates.add(candidate);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (debug) {
            System.out.println("All candidates (distance sorted)");
            Collections.sort(candidates, distCompare);
            for (CandidateJump candidate : candidates) {
                System.out.println("\t" + String.valueOf(candidate));
            }
        }
        List<CandidateJump> selected = this.selector.select(candidates, this.scalarRange, debug);
        if (debug && selected != null) {
            System.out.println("Selected candidate(s):\n\t" + selected.stream().map(S -> S.toString()).collect(Collectors.joining("\n\t")));
        }
        if (selected == null) {
            return null;
        }
        ArrayList<Jump> ret = new ArrayList<Jump>();
        for (CandidateJump candidate : selected) {
            ret.add(new Jump(candidate.fromSection, from, candidate.toSection, to, candidate.minDistance));
        }
        return ret;
    }

    private List<List<? extends FaultSection>> getStrandsTo(List<? extends FaultSection> subSects, int index) {
        Preconditions.checkState((!subSects.isEmpty() ? 1 : 0) != 0);
        ArrayList<List<? extends FaultSection>> ret = new ArrayList<List<? extends FaultSection>>();
        if (subSects.size() == 1) {
            ret.add(subSects.subList(index, index + 1));
        } else {
            if (index > 0) {
                ret.add(subSects.subList(0, index + 1));
            }
            if (index < subSects.size() - 1) {
                ret.add(subSects.subList(index, subSects.size()));
            }
        }
        return ret;
    }

    @Override
    public String getName() {
        String summary = "maxDist=" + new DecimalFormat("0.#").format(this.maxJumpDist) + " km";
        if (this.selector instanceof FallbackJumpSelector) {
            for (JumpSelector sub : ((FallbackJumpSelector)this.selector).selectors) {
                if (!(sub instanceof AllowMultiEndsSelector)) continue;
                summary = summary + ", MultiEnds";
            }
        }
        if (this.filters.size() == 1) {
            return String.valueOf(this.filters.get(0)) + " Plausibile: " + summary;
        }
        return "Plausible (" + this.filters.size() + " filters): " + summary;
    }

    @Override
    public double getMaxJumpDist() {
        return this.maxJumpDist;
    }

    public static void main(String[] args) throws IOException {
        List<? extends FaultSection> subSects = DeformationModels.loadSubSects(FaultModels.FM3_1, DeformationModels.GEOLOGIC);
        SubSectStiffnessCalculator stiffnessCalc = new SubSectStiffnessCalculator(subSects, 2.0, 30000.0, 30000.0, 0.5, SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP, 1.0);
        AggregatedStiffnessCache stiffnessCache = stiffnessCalc.getAggregationCache(SubSectStiffnessCalculator.StiffnessType.CFF);
        File rupSetsDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets/");
        File stiffnessCacheFile = new File(rupSetsDir, stiffnessCache.getCacheFileName());
        int stiffnessCacheSize = 0;
        if (stiffnessCacheFile.exists()) {
            stiffnessCacheSize = stiffnessCache.loadCacheFile(stiffnessCacheFile);
        }
        AggregatedStiffnessCalculator sumAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        AggregatedStiffnessCalculator fractIntsAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.NUM_POSITIVE, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.NORM_BY_COUNT);
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        File distAzCacheFile = new File(rupSetsDir, "fm3_1_dist_az_cache.csv");
        if (distAzCacheFile.exists()) {
            System.out.println("Loading dist/az cache from " + distAzCacheFile.getAbsolutePath());
            distAzCalc.loadCacheFile(distAzCacheFile);
        }
        double maxJumpDist = 15.0;
        boolean favJump = true;
        float cffProb = 0.02f;
        RelativeCoulombProb cffProbCalc = new RelativeCoulombProb(sumAgg, new DistCutoffClosestSectClusterConnectionStrategy(subSects, distAzCalc, 0.1), false, true, favJump, (float)maxJumpDist, distAzCalc);
        float cffRatio = 0.5f;
        CoulombSectRatioProb sectRatioCalc = new CoulombSectRatioProb(sumAgg, 2, favJump, (float)maxJumpDist, distAzCalc);
        NetRuptureCoulombFilter fractInts = new NetRuptureCoulombFilter(fractIntsAgg, (Range<Float>)Range.greaterThan((Comparable)Float.valueOf(0.75f)));
        PathPlausibilityFilter combinedPathFilter = new PathPlausibilityFilter(new CumulativeProbPathEvaluator(cffRatio, PlausibilityResult.FAIL_HARD_STOP, sectRatioCalc), new CumulativeProbPathEvaluator(cffProb, PlausibilityResult.FAIL_HARD_STOP, cffProbCalc));
        PlausibleClusterConnectionStrategy orig = new PlausibleClusterConnectionStrategy(subSects, distAzCalc, maxJumpDist, JUMP_SELECTOR_DEFAULT, new CumulativeProbabilityFilter(cffRatio, sectRatioCalc), combinedPathFilter, fractInts);
        String origName = "15km";
        AdaptiveClusterConnectionStrategy newStrat = new AdaptiveClusterConnectionStrategy(orig, 6.0, 1);
        String newName = "Adaptive 6-15km";
        int threads = Integer.max(1, Integer.min(31, Runtime.getRuntime().availableProcessors() - 2));
        orig.checkBuildThreaded(threads);
        ((ClusterConnectionStrategy)newStrat).checkBuildThreaded(threads);
        HashSet<Jump> origJumps = new HashSet<Jump>();
        for (FaultSubsectionCluster faultSubsectionCluster : orig.getClusters()) {
            for (Jump jump : faultSubsectionCluster.getConnections()) {
                if (jump.fromSection.getSectionId() >= jump.toSection.getSectionId()) continue;
                origJumps.add(jump);
            }
        }
        HashSet<Jump> cffJumps = new HashSet<Jump>();
        for (FaultSubsectionCluster cluster : newStrat.getClusters()) {
            for (Jump jump : cluster.getConnections()) {
                if (jump.fromSection.getSectionId() >= jump.toSection.getSectionId()) continue;
                cffJumps.add(jump);
            }
        }
        HashSet<Jump> hashSet = new HashSet<Jump>();
        HashSet<Jump> cffUniqueJumps = new HashSet<Jump>();
        HashSet<Jump> hashSet2 = new HashSet<Jump>();
        for (Jump jump : origJumps) {
            if (cffJumps.contains(jump)) {
                hashSet2.add(jump);
                continue;
            }
            hashSet.add(jump);
        }
        for (Jump jump : cffJumps) {
            if (hashSet2.contains(jump)) continue;
            cffUniqueJumps.add(jump);
        }
        System.out.println(hashSet2.size() + " common");
        System.out.println(hashSet.size() + " unique to " + origName);
        System.out.println(cffUniqueJumps.size() + " unique to " + newName);
        RupSetMapMaker rupSetMapMaker = new RupSetMapMaker(subSects, RupSetMapMaker.buildBufferedRegion(subSects));
        rupSetMapMaker.plotJumps(hashSet2, FaultSectionConnectionsPlot.darkerTrans(Color.GREEN), "Common Jumps");
        rupSetMapMaker.plotJumps(hashSet, FaultSectionConnectionsPlot.darkerTrans(Color.BLUE), origName);
        rupSetMapMaker.plotJumps(cffUniqueJumps, FaultSectionConnectionsPlot.darkerTrans(Color.RED), newName);
        rupSetMapMaker.plot(new File("/tmp"), "cff_jumps_compare", "CFF Jump Comparison", 5000);
    }

    public static class CandidateJump {
        public final FaultSubsectionCluster fromCluster;
        public final FaultSection fromSection;
        public final boolean fromEnd;
        public final FaultSubsectionCluster toCluster;
        public final FaultSection toSection;
        public final boolean toEnd;
        public final double connDistance;
        public final double minDistance;
        public final List<Jump> allowedJumps;
        public final List<Jump> failedJumps;
        public final Map<Jump, Double> jumpScalars;
        public final Double bestScalar;
        public final int totalJumps;

        public CandidateJump(FaultSubsectionCluster fromCluster, FaultSection fromSection, boolean fromEnd, FaultSubsectionCluster toCluster, FaultSection toSection, boolean toEnd, double connDistance, double minDistance, List<Jump> allowedJumps, List<Jump> failedJumps, Map<Jump, Double> jumpScalars, Double bestScalar) {
            this.fromCluster = fromCluster;
            this.fromSection = fromSection;
            this.fromEnd = fromEnd;
            this.toCluster = toCluster;
            this.toSection = toSection;
            this.toEnd = toEnd;
            this.connDistance = connDistance;
            this.minDistance = minDistance;
            this.allowedJumps = allowedJumps;
            this.failedJumps = failedJumps;
            this.jumpScalars = jumpScalars;
            this.bestScalar = bestScalar;
            this.totalJumps = allowedJumps.size() + failedJumps.size();
        }

        public String toString() {
            String ret = "" + this.fromSection.getSectionId();
            if (this.fromEnd) {
                ret = ret + "[end]";
            }
            ret = ret + "->" + this.toSection.getSectionId();
            if (this.toEnd) {
                ret = ret + "[end]";
            }
            ret = ret + ": dist=" + (float)this.connDistance + "\t" + this.allowedJumps.size() + "/" + (this.allowedJumps.size() + this.failedJumps.size()) + " pass";
            if (this.bestScalar != null) {
                ret = ret + "\tbestScalar: " + this.bestScalar.floatValue();
            }
            return ret;
        }

        public int numEnds() {
            int ret = 0;
            if (this.fromEnd) {
                ++ret;
            }
            if (this.toEnd) {
                ++ret;
            }
            return ret;
        }
    }

    public static interface JumpSelector {
        default public List<CandidateJump> select(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            if (candidates == null || candidates.isEmpty()) {
                return null;
            }
            if (candidates.size() == 1) {
                return candidates;
            }
            Comparator<CandidateJump> comp = this.comparator(candidates, acceptableScalarRange, verbose);
            Collections.sort(candidates, comp);
            ArrayList<CandidateJump> ret = new ArrayList<CandidateJump>();
            CandidateJump best = candidates.get(0);
            if (verbose) {
                System.out.println("First candidate: " + String.valueOf(best));
            }
            ret.add(best);
            for (int c = 1; c < candidates.size(); ++c) {
                CandidateJump candidate = candidates.get(c);
                if (comp.compare(best, candidate) != 0) continue;
                if (verbose) {
                    System.out.println("\t" + String.valueOf(candidate) + " is equivalent, adding");
                }
                ret.add(candidate);
            }
            return ret;
        }

        public Comparator<CandidateJump> comparator(List<CandidateJump> var1, Range<Double> var2, boolean var3);
    }

    public static class FallbackJumpSelector
    implements JumpSelector {
        private JumpSelector[] selectors;
        private boolean pickFirst;

        public FallbackJumpSelector(JumpSelector ... selectors) {
            this(false, selectors);
        }

        public FallbackJumpSelector(boolean pickFirst, JumpSelector ... selectors) {
            this.pickFirst = pickFirst;
            Preconditions.checkArgument((selectors.length > 0 ? 1 : 0) != 0);
            this.selectors = selectors;
        }

        @Override
        public List<CandidateJump> select(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            if (candidates == null || candidates.isEmpty()) {
                return null;
            }
            for (JumpSelector selector : this.selectors) {
                if ((candidates = selector.select(candidates, acceptableScalarRange, verbose)) == null || candidates.isEmpty()) {
                    return null;
                }
                if (candidates.size() != 1) continue;
                return candidates;
            }
            if (this.pickFirst && candidates.size() > 1) {
                Collections.sort(candidates, reproducible_tie_breaker);
                return candidates.subList(0, 1);
            }
            return candidates;
        }

        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            final ArrayList<Comparator<CandidateJump>> comps = new ArrayList<Comparator<CandidateJump>>();
            for (JumpSelector selector : this.selectors) {
                comps.add(selector.comparator(candidates, acceptableScalarRange, verbose));
            }
            return new Comparator<CandidateJump>(){
                final /* synthetic */ FallbackJumpSelector this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(CandidateJump o1, CandidateJump o2) {
                    for (Comparator comp : comps) {
                        int cmp = comp.compare(o1, o2);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            };
        }
    }

    public static class AllowMultiEndsSelector
    implements JumpSelector {
        private JumpSelector fallback;
        private float maxAdditionalJumpDist;

        public AllowMultiEndsSelector(float maxAdditionalJumpDist, JumpSelector fallback) {
            this.maxAdditionalJumpDist = maxAdditionalJumpDist;
            this.fallback = fallback;
        }

        @Override
        public List<CandidateJump> select(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            if (candidates == null || candidates.isEmpty()) {
                return null;
            }
            if (candidates.size() == 1) {
                return candidates;
            }
            if (this.fallback != null) {
                Collections.sort(candidates, this.fallback.comparator(candidates, acceptableScalarRange, verbose));
            }
            CandidateJump first = candidates.get(0);
            int firstEnds = first.numEnds();
            if (!first.allowedJumps.isEmpty() && firstEnds > 0) {
                ArrayList<CandidateJump> ret = new ArrayList<CandidateJump>();
                ret.add(first);
                HashSet<FaultSection> prevJumpPoints = new HashSet<FaultSection>();
                prevJumpPoints.add(first.fromSection);
                prevJumpPoints.add(first.toSection);
                for (CandidateJump candidate : candidates) {
                    if (!((float)candidate.connDistance <= this.maxAdditionalJumpDist) || candidate.allowedJumps.isEmpty() || candidate.numEnds() < firstEnds || prevJumpPoints.contains(candidate.fromSection) || prevJumpPoints.contains(candidate.toSection)) continue;
                    ret.add(candidate);
                    prevJumpPoints.add(candidate.fromSection);
                    prevJumpPoints.add(candidate.toSection);
                }
                return ret;
            }
            if (this.fallback != null) {
                candidates = this.fallback.select(candidates, acceptableScalarRange, verbose);
            }
            return candidates;
        }

        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            return new Comparator<CandidateJump>(){

                @Override
                public int compare(CandidateJump o1, CandidateJump o2) {
                    return -Integer.compare(o1.numEnds(), o2.numEnds());
                }
            };
        }
    }

    public static class PassesMinimizeFailedSelector
    implements JumpSelector {
        private boolean allowFailuresIfNonePass;

        public PassesMinimizeFailedSelector(boolean allowFailuresIfNonePass) {
            this.allowFailuresIfNonePass = allowFailuresIfNonePass;
        }

        @Override
        public List<CandidateJump> select(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            List<CandidateJump> selections = JumpSelector.super.select(candidates, acceptableScalarRange, verbose);
            if (!this.allowFailuresIfNonePass) {
                return PlausibleClusterConnectionStrategy.onlyPassing(selections);
            }
            return selections;
        }

        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, final boolean verbose) {
            return new Comparator<CandidateJump>(){
                final /* synthetic */ PassesMinimizeFailedSelector this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(CandidateJump o1, CandidateJump o2) {
                    if (verbose) {
                        System.out.println("Comparing " + String.valueOf(o1) + " to " + String.valueOf(o2));
                    }
                    if (o1.allowedJumps.isEmpty() != o2.allowedJumps.isEmpty()) {
                        if (o1.allowedJumps.isEmpty()) {
                            if (verbose) {
                                System.out.println("\tsecond passes first doesn't, returning 1");
                            }
                            return 1;
                        }
                        if (verbose) {
                            System.out.println("\tfirst passes second doesn't, returning 1");
                        }
                        return -1;
                    }
                    if (o1.allowedJumps.isEmpty() && o2.allowedJumps.isEmpty()) {
                        int cmp = distCompare.compare(o1, o2);
                        if (verbose) {
                            System.out.println("\tneither pass, going with closest: " + cmp);
                        }
                        return cmp;
                    }
                    int cmp = Integer.compare(o1.failedJumps.size(), o2.failedJumps.size());
                    if (verbose) {
                        System.out.println("\tfailCMP=" + cmp);
                    }
                    if (cmp == 0) {
                        cmp = Integer.compare(o1.totalJumps, o2.totalJumps);
                        if (verbose) {
                            System.out.println("\tfellback to totalJumps: jumpCMP=" + cmp + "\to1: " + o1.totalJumps + "\to2=" + o2.totalJumps);
                        }
                    }
                    return cmp;
                }
            };
        }
    }

    public static class BestScalarSelector
    implements JumpSelector {
        private final double equivDistance;

        public BestScalarSelector(double equivDistance) {
            this.equivDistance = equivDistance;
        }

        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, final Range<Double> acceptableScalarRange, final boolean verbose) {
            final float maxScalarDist = this.equivDistance > 0.0 ? (float)(PlausibleClusterConnectionStrategy.getMinPassingDist(candidates) + this.equivDistance) : Float.POSITIVE_INFINITY;
            if (verbose) {
                System.out.println("MaxScalarDist=" + maxScalarDist);
            }
            return new Comparator<CandidateJump>(){
                final /* synthetic */ BestScalarSelector this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(CandidateJump o1, CandidateJump o2) {
                    if (verbose) {
                        System.out.println("Comparing scalars (dist fallback) for " + String.valueOf(o1) + " and " + String.valueOf(o2));
                    }
                    if (((float)o1.connDistance <= maxScalarDist && (float)o2.connDistance <= maxScalarDist || (float)o1.connDistance == (float)o2.connDistance) && (o1.bestScalar != null || o2.bestScalar != null)) {
                        if (o2.bestScalar == null || ScalarValuePlausibiltyFilter.isValueBetter(o1.bestScalar, o2.bestScalar, acceptableScalarRange)) {
                            if (verbose) {
                                System.out.println("\tfirst (" + o1.bestScalar + ") is better than second (" + o2.bestScalar + ")");
                            }
                            return -1;
                        }
                        if (o1.bestScalar == null || ScalarValuePlausibiltyFilter.isValueBetter(o2.bestScalar, o1.bestScalar, acceptableScalarRange)) {
                            if (verbose) {
                                System.out.println("\tsecond (" + o2.bestScalar + ") is better than first (" + o1.bestScalar + ")");
                            }
                            return 1;
                        }
                    }
                    int cmp = distCompare.compare(o1, o2);
                    if (verbose) {
                        System.out.println("\tFellback to distance: " + cmp);
                    }
                    return cmp;
                }
            };
        }
    }

    public static class AnyPassSelector
    implements JumpSelector {
        private boolean allowFailuresIfNonePass;

        public AnyPassSelector(boolean allowFailuresIfNonePass) {
            this.allowFailuresIfNonePass = allowFailuresIfNonePass;
        }

        @Override
        public List<CandidateJump> select(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            List<CandidateJump> selections = JumpSelector.super.select(candidates, acceptableScalarRange, verbose);
            if (!this.allowFailuresIfNonePass) {
                return PlausibleClusterConnectionStrategy.onlyPassing(selections);
            }
            return selections;
        }

        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            return new Comparator<CandidateJump>(){

                @Override
                public int compare(CandidateJump o1, CandidateJump o2) {
                    if (o1.allowedJumps.isEmpty() != o2.allowedJumps.isEmpty()) {
                        if (o1.allowedJumps.isEmpty()) {
                            return 1;
                        }
                        return -1;
                    }
                    return 0;
                }
            };
        }
    }

    public static class WithinDistanceSelector
    implements JumpSelector {
        private float maxDist;

        public WithinDistanceSelector(float maxDist) {
            this.maxDist = maxDist;
        }

        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            return new Comparator<CandidateJump>(){

                @Override
                public int compare(CandidateJump o1, CandidateJump o2) {
                    boolean within2;
                    boolean within1 = (float)o1.connDistance <= maxDist;
                    boolean bl = within2 = (float)o2.connDistance <= maxDist;
                    if (within1 != within2) {
                        if (within1) {
                            return -1;
                        }
                        return 1;
                    }
                    return 0;
                }
            };
        }
    }

    public static class MinDistanceSelector
    implements JumpSelector {
        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            return distCompare;
        }
    }

    public static class OnlyEndsJumpSelector
    implements JumpSelector {
        private boolean requireBoth;

        public OnlyEndsJumpSelector(boolean requireBoth) {
            this.requireBoth = requireBoth;
        }

        @Override
        public List<CandidateJump> select(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            ArrayList<CandidateJump> ret = new ArrayList<CandidateJump>();
            for (CandidateJump jump : candidates) {
                if (!jump.fromEnd && !jump.toEnd || this.requireBoth && (!jump.fromEnd || !jump.toEnd)) continue;
                ret.add(jump);
            }
            return ret;
        }

        @Override
        public Comparator<CandidateJump> comparator(List<CandidateJump> candidates, Range<Double> acceptableScalarRange, boolean verbose) {
            return null;
        }
    }
}

