/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public class ClusterRupturePlausibilityDebug {
    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        System.out.println("Loading rupture set...");
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/OpenSHA/UCERF4/rup_sets/../prvi/2024_02-initial_dm/rup_set.zip"));
        System.out.println("Loaded " + rupSet.getNumRuptures() + " ruptures");
        PlausibilityConfiguration config = rupSet.requireModule(PlausibilityConfiguration.class);
        boolean verbose = false;
        int[] parents = new int[]{19, 23};
        int startParent = -1;
        FaultSubsectionCluster startCluster = null;
        ArrayList<FaultSubsectionCluster> clusters = new ArrayList<FaultSubsectionCluster>();
        HashSet<Integer> parentIDsSet = new HashSet<Integer>();
        for (int parent : parents) {
            parentIDsSet.add(parent);
        }
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupSet.getFaultSectionDataList(), distAzCalc, 15.0);
        for (FaultSubsectionCluster cluster : connStrat.getClusters()) {
            if (parentIDsSet.contains(cluster.parentSectionID)) {
                clusters.add(cluster);
            }
            if (cluster.parentSectionID != startParent) continue;
            startCluster = cluster;
        }
        RuptureConnectionSearch connSearch = new RuptureConnectionSearch(rupSet, config.getDistAzCalc());
        List<Jump> jumps = connSearch.calcRuptureJumps(clusters, true);
        ArrayList<ClusterRupture> testRuptures = new ArrayList<ClusterRupture>();
        testRuptures.add(connSearch.buildClusterRupture(clusters, jumps, true, startCluster));
        boolean tryLastJump = false;
        Object testFilters = null;
        for (ClusterRupture rup : testRuptures) {
            System.out.println("===================");
            System.out.println(rup);
            System.out.println("===================");
            if (testFilters != null) {
                System.out.println("Test filters");
                System.out.println("===================");
                for (void filter : testFilters) {
                    System.out.println("Testing " + filter.getName());
                    PlausibilityResult result = filter.apply(rup, verbose);
                    System.out.println("result: " + String.valueOf((Object)result));
                    if (filter instanceof ScalarValuePlausibiltyFilter) {
                        System.out.println("scalar: " + String.valueOf(((ScalarValuePlausibiltyFilter)filter).getValue(rup)));
                    }
                    System.out.println("===================");
                }
            } else if (config.getFilters() != null) {
                System.out.println("Rup Set filters");
                System.out.println("===================");
                ArrayList<PlausibilityFilter> filters = new ArrayList<PlausibilityFilter>(config.getFilters());
                for (int f = 0; f < filters.size(); ++f) {
                    PathPlausibilityFilter pFilter;
                    PlausibilityFilter filter = (PlausibilityFilter)filters.get(f);
                    if (!(filter instanceof PathPlausibilityFilter) || (pFilter = (PathPlausibilityFilter)filter).getEvaluators().length <= 1) continue;
                    for (NucleationClusterEvaluator eval : pFilter.getEvaluators()) {
                        if (eval instanceof NucleationClusterEvaluator.Scalar) {
                            filters.add(f + 1, new PathPlausibilityFilter.Scalar((NucleationClusterEvaluator.Scalar)eval));
                            continue;
                        }
                        filters.add(f + 1, new PathPlausibilityFilter(eval));
                    }
                }
                for (PlausibilityFilter filter : filters) {
                    System.out.println("Testing " + filter.getName());
                    PlausibilityResult result = filter.apply(rup, verbose);
                    System.out.println("result: " + String.valueOf((Object)result));
                    if (filter instanceof ScalarValuePlausibiltyFilter) {
                        System.out.println("scalar: " + String.valueOf(((ScalarValuePlausibiltyFilter)filter).getValue(rup)));
                    }
                    System.out.println("===================");
                }
            }
            System.out.println();
        }
    }
}

