/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.opensha.commons.data.Named;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class GeoJSONFaultReader {
    public static final String NSHM23_SECTS_CUR_VERSION = "v1p4";
    private static final String NSHM23_SECTS_PATH_PREFIX = "/data/erf/nshm23/fault_models/";
    public static final String NSHM23_DM_CUR_VERSION = "v1p2";
    private static final String NSHM23_DM_PATH_PREFIX = "/data/erf/nshm23/def_models/";

    public static List<GeoJSONFaultSection> readFaultSections(File file) throws IOException {
        return GeoJSONFaultReader.readFaultSections(new BufferedReader(new FileReader(file)));
    }

    public static List<GeoJSONFaultSection> readFaultSections(Reader reader) throws IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        FeatureCollection features = FeatureCollection.read(reader);
        ArrayList<GeoJSONFaultSection> ret = new ArrayList<GeoJSONFaultSection>();
        HashSet<Integer> prevIDs = new HashSet<Integer>();
        HashMap<String, Integer> nameCounts = new HashMap<String, Integer>();
        HashMap<Object, GeoJSONFaultSection> nameSectMap = new HashMap<Object, GeoJSONFaultSection>();
        for (Feature feature : features.features) {
            GeoJSONFaultSection sect = GeoJSONFaultSection.fromFeature(feature);
            int id = sect.getSectionId();
            Preconditions.checkState((!prevIDs.contains(id) ? 1 : 0) != 0, (String)"Duplicate fault ID detected: %s", (int)id);
            String sectName = sect.getSectionName();
            Integer nameCount = (Integer)nameCounts.get(sectName);
            if (nameCount == null) {
                nameCount = 1;
            } else {
                Integer n = nameCount;
                nameCount = nameCount + 1;
                String state = sect.getProperty("PrimState", "");
                Preconditions.checkState((!state.isBlank() ? 1 : 0) != 0, (Object)"State cannot be blank in the case of duplicate fault names");
                String newSectName = sectName + " (" + state + ")";
                System.err.println("WARNING: duplicate fault section name detected, changing '" + sectName + "' to '" + newSectName + "'");
                sect.setSectionName(newSectName);
                if (nameSectMap.containsKey(sectName)) {
                    GeoJSONFaultSection prevSect = (GeoJSONFaultSection)nameSectMap.remove(sectName);
                    String prevState = prevSect.getProperty("PrimState", "");
                    Preconditions.checkState((!prevState.isBlank() ? 1 : 0) != 0, (Object)"State cannot be blank in the case of duplicate fault names");
                    String newPrevSectName = sectName + " (" + prevState + ")";
                    prevSect.setSectionName(newPrevSectName);
                    nameSectMap.put(newPrevSectName, prevSect);
                    System.err.println("\tretroactively changing previous '" + sectName + "' to '" + newPrevSectName + "'");
                }
            }
            nameCounts.put(sectName, nameCount);
            sectName = sect.getSectionName();
            Preconditions.checkState((!nameSectMap.containsKey(sectName) ? 1 : 0) != 0, (String)"Duplicate name should have been caught: %s", (Object)sectName);
            nameSectMap.put(sectName, sect);
            ret.add(sect);
            prevIDs.add(id);
        }
        reader.close();
        return ret;
    }

    public static void writeFaultSections(File file, List<? extends FaultSection> sects) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        GeoJSONFaultReader.writeFaultSections(writer, sects);
        ((Writer)writer).close();
    }

    public static void writeFaultSections(Writer writer, List<? extends FaultSection> sects) throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>(sects.size());
        for (FaultSection faultSection : sects) {
            features.add(GeoJSONFaultSection.toFeature(faultSection));
        }
        FeatureCollection collection = new FeatureCollection(features);
        FeatureCollection.write(collection, writer);
        writer.flush();
    }

    public static List<GeoJSONFaultSection> filterByState(List<GeoJSONFaultSection> sects, String state, boolean includeSecondary) {
        ArrayList<GeoJSONFaultSection> ret = new ArrayList<GeoJSONFaultSection>();
        for (GeoJSONFaultSection sect : sects) {
            String primState = sect.getProperty("PrimState", null);
            Preconditions.checkNotNull((Object)primState, (String)"Fault does not contain 'PrimState' property: %s", (int)sect.getSectionId());
            String secState = sect.getProperty("SecState", null);
            if (!state.equalsIgnoreCase(primState) && (!includeSecondary || !state.equalsIgnoreCase(secState))) continue;
            ret.add(sect);
        }
        return ret;
    }

    private static <E extends FaultSection> Map<Integer, E> idMappedSects(List<E> sects) {
        return sects.stream().collect(Collectors.toMap(FaultSection::getSectionId, Function.identity()));
    }

    public static void attachGeoDefModel(List<GeoJSONFaultSection> sects, File dmGeoJSONFile) throws IOException {
        GeoJSONFaultReader.attachGeoDefModel(sects, FeatureCollection.read(dmGeoJSONFile));
    }

    public static void attachGeoDefModel(List<GeoJSONFaultSection> sects, FeatureCollection defModel) {
        Map<Integer, GeoJSONFaultSection> idMapped = GeoJSONFaultReader.idMappedSects(sects);
        Preconditions.checkState((sects.size() == idMapped.size() ? 1 : 0) != 0, (Object)"Duplicate fault ids in list?");
        HashSet<Integer> processed = new HashSet<Integer>();
        int numInferred = 0;
        for (Object dmSect : defModel.features) {
            String compDMName;
            String compSectName;
            Object parentObj;
            Object treatObj;
            FeatureProperties props = ((Feature)dmSect).properties;
            int id = props.getInt("FaultID", -1);
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (Object)"Feature is missing FaultID field");
            Preconditions.checkState((!processed.contains(id) ? 1 : 0) != 0, (String)"Duplicate id encountered: %s", (int)id);
            if (!idMapped.containsKey(id)) continue;
            double prefRate = props.getDouble("PrefRate", Double.NaN);
            double lowRate = props.getDouble("LowRate", Double.NaN);
            double highRate = props.getDouble("HighRate", Double.NaN);
            String treatment = null;
            if (props.containsKey("Treat") && (treatObj = props.get("Treat")) instanceof String) {
                treatment = (String)treatObj;
            }
            String rateType = props.get("RateType", null);
            double stdDev = props.getDouble("StdDev", Double.NaN);
            String parentName = null;
            if (props.containsKey("ParentName") && (parentObj = props.get("ParentName")) instanceof String) {
                parentName = (String)parentObj;
            }
            processed.add(id);
            GeoJSONFaultSection sect = idMapped.get(id);
            String sectName = sect.getName();
            String dmFaultName = props.get("FaultName", "");
            if (!sectName.startsWith(dmFaultName)) {
                System.err.println("WARNING: name mismatch for " + id + ": '" + sectName + "' != '" + dmFaultName + "'");
            }
            Preconditions.checkState(((compSectName = sectName.replaceAll("\\W+", "")).startsWith(compDMName = dmFaultName.replaceAll("\\W+", "")) || compDMName.startsWith(compSectName) ? 1 : 0) != 0, (String)"DM/FM name mismatch for %s: '%s' != '%s'", (Object)id, (Object)sect.getName(), (Object)dmFaultName);
            if (prefRate < 0.0 || !Double.isFinite(prefRate)) {
                System.err.println("No rate available (setting to zero) for " + id + ". " + sect.getSectionName());
                sect.setAveSlipRate(0.0);
                continue;
            }
            if ((float)prefRate >= 999.0f) {
                System.err.println("Slip rate magic number of " + (int)prefRate + " encountered, which makes Kevin very angry. Will treat as zero for now, but please fix ASAP. " + id + ". " + sect.getSectionName());
                sect.setAveSlipRate(0.0);
                continue;
            }
            if (lowRate > prefRate) {
                System.err.println("WARNING: LowRate is > PrefRate for " + id + ". " + sectName + ": low=" + (float)lowRate + ", pref=" + (float)prefRate);
                lowRate = prefRate;
            }
            if (highRate < prefRate) {
                System.err.println("WARNING: HighRate is < PrefRate for " + id + ". " + sectName + ": high=" + (float)highRate + ", pref=" + (float)prefRate);
                highRate = prefRate;
            }
            Preconditions.checkState((Double.isFinite(highRate) && highRate >= 0.0 && highRate >= prefRate ? 1 : 0) != 0, (String)"Bad HighRate for %s. %s: %s", (Object)id, (Object)sectName, (Object)highRate);
            Preconditions.checkState((Double.isFinite(lowRate) && lowRate >= 0.0 && lowRate <= prefRate ? 1 : 0) != 0, (String)"Bad LowRate for %s. %s: %s", (Object)id, (Object)sectName, (Object)lowRate);
            sect.setAveSlipRate(prefRate);
            sect.setProperty("HighRate", highRate);
            sect.setProperty("LowRate", lowRate);
            if (treatment == null) {
                sect.getProperties().remove("Treatment");
            } else {
                sect.setProperty("Treatment", treatment);
            }
            if (rateType == null) {
                sect.getProperties().remove("RateType");
            } else {
                sect.setProperty("RateType", rateType);
            }
            if (parentName != null) {
                sect.setParentSectionName(parentName);
            }
            if (!Double.isFinite(stdDev)) {
                ++numInferred;
                stdDev = (highRate - lowRate) / 4.0;
            }
            sect.setSlipRateStdDev(stdDev);
        }
        System.out.println("Attached deformation model rates for " + processed.size() + " sections");
        if (numInferred > 0) {
            System.err.println("WARNING: inferred " + numInferred + " slip rate values from bounds, assuming bounds are 2-sigma");
        }
        if (sects.size() != processed.size()) {
            Object missingStr = null;
            for (GeoJSONFaultSection sect : sects) {
                if (processed.contains(sect.getSectionId())) continue;
                missingStr = missingStr == null ? "" : (String)missingStr + "; ";
                missingStr = (String)missingStr + sect.getSectionId() + ". " + sect.getSectionName();
            }
            int num = sects.size() - processed.size();
            throw new IllegalStateException("No mappings found for " + num + " section(s): " + missingStr);
        }
    }

    public static Map<Integer, List<GeoDBSlipRateRecord>> readGeoDB(File file) throws IOException {
        return GeoJSONFaultReader.readGeoDB(new BufferedReader(new FileReader(file)));
    }

    public static Map<Integer, List<GeoDBSlipRateRecord>> readGeoDB(Reader reader) throws IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        HashMap<Integer, List<GeoDBSlipRateRecord>> ret = new HashMap<Integer, List<GeoDBSlipRateRecord>>();
        FeatureCollection features = FeatureCollection.read(reader);
        for (Feature feature : features.features) {
            GeoDBSlipRateRecord record = new GeoDBSlipRateRecord(feature);
            ArrayList<GeoDBSlipRateRecord> faultRecords = (ArrayList<GeoDBSlipRateRecord>)ret.get(record.faultID);
            if (faultRecords == null) {
                faultRecords = new ArrayList<GeoDBSlipRateRecord>();
                ret.put(record.faultID, faultRecords);
            }
            faultRecords.add(record);
        }
        reader.close();
        return ret;
    }

    public static void testMapSlipRates(Collection<? extends FaultSection> sects, Map<Integer, List<GeoDBSlipRateRecord>> recsMap, Double defaultSlipRate, List<FaultSection> fallbacks) {
        if (defaultSlipRate == null) {
            defaultSlipRate = Double.NaN;
        }
        for (FaultSection faultSection : sects) {
            List<GeoDBSlipRateRecord> records = recsMap.get(faultSection.getSectionId());
            if (records == null) {
                String testName = faultSection.getSectionName().toLowerCase();
                if (testName.contains("[")) {
                    testName = testName.substring(0, testName.indexOf("["));
                }
                testName = testName.replaceAll("\\W+", "").trim();
                ArrayList<String> matchNames = new ArrayList<String>();
                ArrayList<FaultSection> matches = new ArrayList<FaultSection>();
                if (fallbacks != null) {
                    for (FaultSection fallback : fallbacks) {
                        String fallbackName = fallback.getName().toLowerCase();
                        if (fallbackName.contains(" alt")) {
                            fallbackName = fallbackName.substring(0, fallbackName.indexOf(" alt"));
                        }
                        if (!(fallbackName = fallbackName.replaceAll("\\W+", "").trim()).contains(testName)) continue;
                        matches.add(fallback);
                        matchNames.add(fallbackName);
                    }
                }
                if (matchNames.isEmpty()) {
                    System.err.println("WARNING: no slip rate for " + faultSection.getSectionId() + ". " + faultSection.getSectionName() + ". Setting to default=" + defaultSlipRate.floatValue());
                    faultSection.setAveSlipRate(defaultSlipRate);
                    continue;
                }
                Named match = null;
                LevenshteinDistance ld = new LevenshteinDistance();
                int numAway = Integer.MAX_VALUE;
                for (int i = 0; i < matches.size(); ++i) {
                    int myAway = ld.apply((CharSequence)testName, (CharSequence)matchNames.get(i));
                    if (myAway >= numAway) continue;
                    numAway = myAway;
                    match = (FaultSection)matches.get(i);
                }
                System.err.println("WARNING: no slip rate for " + faultSection.getSectionId() + ". " + faultSection.getSectionName() + ". Matched to old section: " + match.getName() + ". Using prev value=" + match.getOrigAveSlipRate());
                faultSection.setAveSlipRate(match.getOrigAveSlipRate());
                continue;
            }
            Double aveSlipRate = null;
            int numAvg = 0;
            for (GeoDBSlipRateRecord record : records) {
                Double guess = GeoJSONFaultReader.bestGuessSlipRate(record);
                if (guess == null) continue;
                aveSlipRate = aveSlipRate == null ? guess : Double.valueOf(aveSlipRate + guess);
                ++numAvg;
            }
            if (aveSlipRate == null) {
                System.err.println("WARNING: no useable slip rate estimates found for " + faultSection.getSectionId() + ". " + faultSection.getSectionName() + ". Setting to default=" + defaultSlipRate.floatValue());
                aveSlipRate = defaultSlipRate;
            } else if (numAvg > 1) {
                aveSlipRate = aveSlipRate / (double)numAvg;
            }
            faultSection.setAveSlipRate(aveSlipRate);
        }
    }

    private static Double bestGuessSlipRate(GeoDBSlipRateRecord record) {
        if (Double.isFinite(record.prefRate)) {
            return record.prefRate;
        }
        if (Double.isFinite(record.rate2014)) {
            return record.rate2014;
        }
        if (Double.isFinite(record.lowRate) && Double.isFinite(record.highRate)) {
            return 0.5 * (record.lowRate + record.highRate);
        }
        System.err.println("WARNING: Couldn't guess slip rate for " + record.faultID + ". " + record.faultName + ": " + record.slipRateID);
        return null;
    }

    public static List<FaultSection> buildNSHM23SubSects() throws IOException {
        return GeoJSONFaultReader.buildNSHM23SubSects(null);
    }

    public static List<FaultSection> buildNSHM23SubSects(String state) throws IOException {
        String sectPath = "/data/erf/nshm23/fault_models/v1p4/NSHM23_FaultSections_v1p4.geojson";
        BufferedReader sectsReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(sectPath)));
        Preconditions.checkNotNull((Object)sectsReader, (String)"Fault model file not found: %s", (Object)sectPath);
        List<GeoJSONFaultSection> sects = GeoJSONFaultReader.readFaultSections(sectsReader);
        if (state != null) {
            sects = GeoJSONFaultReader.filterByState(sects, state, true);
        }
        String dmPath = "/data/erf/nshm23/def_models/geologic/v1p2/NSHM23_GeolDefMod_v1p2.geojson";
        BufferedReader dmReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(dmPath)));
        Preconditions.checkNotNull((Object)dmReader, (String)"Deformation model file not found: %s", (Object)dmPath);
        FeatureCollection defModel = FeatureCollection.read(dmReader);
        GeoJSONFaultReader.attachGeoDefModel(sects, defModel);
        return SubSectionBuilder.buildSubSects(sects);
    }

    public static List<FaultSection> buildSubSects(File sectsFile, File geoDBFile, String state) throws IOException {
        return GeoJSONFaultReader.buildSubSects(new BufferedReader(new FileReader(sectsFile)), new BufferedReader(new FileReader(geoDBFile)), state);
    }

    public static List<FaultSection> buildSubSects(Reader sectsReader, Reader geoDBReader, String state) throws IOException {
        List<GeoJSONFaultSection> sects = GeoJSONFaultReader.readFaultSections(sectsReader);
        if (state != null) {
            sects = GeoJSONFaultReader.filterByState(sects, state, true);
        }
        System.out.println("Loaded " + sects.size() + " sections");
        Collections.sort(sects, new Comparator<FaultSection>(){

            @Override
            public int compare(FaultSection o1, FaultSection o2) {
                return o1.getSectionName().compareTo(o2.getSectionName());
            }
        });
        Map<Integer, List<GeoDBSlipRateRecord>> slipRates = GeoJSONFaultReader.readGeoDB(geoDBReader);
        ArrayList<FaultSection> fallbacks = new ArrayList<FaultSection>();
        fallbacks.addAll(FaultModels.FM3_1.getFaultSections());
        fallbacks.addAll(FaultModels.FM3_2.getFaultSections());
        GeoJSONFaultReader.testMapSlipRates(sects, slipRates, 1.0, fallbacks);
        return SubSectionBuilder.buildSubSects(sects);
    }

    public static void main(String[] args) throws IOException {
        String sectPath = "/data/erf/nshm23/fault_models/v1p4/NSHM23_FaultSections_v1p4.geojson";
        BufferedReader sectsReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(sectPath)));
        Preconditions.checkNotNull((Object)sectsReader, (String)"Fault model file not found: %s", (Object)sectPath);
        List<GeoJSONFaultSection> sects = GeoJSONFaultReader.readFaultSections(sectsReader);
        String dmPath = "/data/erf/nshm23/def_models/geologic/v1p2/NSHM23_GeolDefMod_v1p2.geojson";
        BufferedReader dmReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(dmPath)));
        Preconditions.checkNotNull((Object)dmReader, (String)"Deformation model file not found: %s", (Object)dmPath);
        FeatureCollection defModel = FeatureCollection.read(dmReader);
        GeoJSONFaultReader.attachGeoDefModel(sects, defModel);
        for (GeoJSONFaultSection sect : sects) {
            double calc;
            FeatureProperties props = sect.getProperties();
            double high = props.getDouble("HighRate", Double.NaN);
            double low = props.getDouble("LowRate", Double.NaN);
            double stdDev = sect.getOrigSlipRateStdDev();
            String treat = props.get("Treatment", null);
            if (treat.equals("tribox")) {
                calc = (high - low) / 4.0;
                System.out.println(sect.getSectionName() + " is " + treat + ". high=" + (float)high + "\tlow=" + (float)low + "\tsd=" + (float)stdDev + "\tcalc=" + (float)calc);
                continue;
            }
            calc = (high - low) / 2.0;
            System.out.println(sect.getSectionName() + " is " + treat + ". high=" + (float)high + "\tlow=" + (float)low + "\tsd=" + (float)stdDev + "\tcalc=" + (float)calc);
        }
    }

    public static class GeoDBSlipRateRecord {
        public final String slipRateID;
        public final int faultID;
        public final String faultName;
        public final String state;
        public final String dataType;
        public final String observation;
        public final double prefRate;
        public final double lowRate;
        public final double highRate;
        public final double rate2014;
        public final Location location;

        public GeoDBSlipRateRecord(Feature feature) {
            Preconditions.checkNotNull((Object)feature);
            FeatureProperties properties = feature.properties;
            Preconditions.checkNotNull((Object)properties);
            this.slipRateID = properties.get("SlipRateID").toString();
            this.faultID = properties.getInt("FaultID", -1);
            Preconditions.checkState((this.faultID > 0 ? 1 : 0) != 0);
            this.faultName = properties.get("FaultName").toString();
            this.state = properties.get("State").toString();
            this.dataType = properties.get("DataType", null);
            this.observation = properties.get("Observn", null);
            this.prefRate = this.tryGetDouble(properties, "PrefRate");
            this.lowRate = this.tryGetDouble(properties, "LowRate");
            this.highRate = this.tryGetDouble(properties, "HighRate");
            this.rate2014 = this.tryGetDouble(properties, "2014rate");
            Preconditions.checkNotNull((Object)feature.geometry);
            Preconditions.checkState((boolean)(feature.geometry instanceof Geometry.Point), (Object)"Only Point geometry supported");
            this.location = ((Geometry.Point)feature.geometry).point;
        }

        private double tryGetDouble(FeatureProperties properties, String name) {
            Object value = properties.get(name);
            if (value == null) {
                return Double.NaN;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            String str = value.toString();
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
    }
}

