/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.DocumentException;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.MultiDirectionalPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.SectCountAdaptiveRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class PlausibilityConsistencyCheck {
    public static void main(String[] args) throws IOException, DocumentException {
        File rupSetFile = new File("/home/kevin/OpenSHA/UCERF4/rup_sets/fm3_1_cmlAz_cffClusterPathPositive_sectFractPerm0.1.zip");
        File altRupSetFile = new File("/home/kevin/OpenSHA/UCERF4/rup_sets/fm3_1_cmlAz_cffClusterPathPositive.zip");
        boolean testUniqueAltRups = true;
        boolean useAltRupOrders = false;
        int maxNumVerbose = 5;
        HashSet<Class<SectCountAdaptiveRuptureGrowingStrategy.ConnPointCleanupFilter>> includeTypes = new HashSet<Class<SectCountAdaptiveRuptureGrowingStrategy.ConnPointCleanupFilter>>();
        includeTypes.add(SectCountAdaptiveRuptureGrowingStrategy.ConnPointCleanupFilter.class);
        System.out.println("Loading rupture set");
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSet(rupSetFile);
        PlausibilityConfiguration config = rupSet.getPlausibilityConfiguration();
        Preconditions.checkNotNull((Object)config, (Object)"Rup set doesn't have plausbility configuration attached");
        List<ClusterRupture> rups = rupSet.getClusterRuptures();
        Preconditions.checkNotNull(rups, (Object)"Rup set doesn't have cluster ruptures attached");
        List<ClusterRupture> origRups = rups;
        PlausibilityConfiguration configForMulti = config;
        if (altRupSetFile != null && (useAltRupOrders || testUniqueAltRups)) {
            Preconditions.checkState((!useAltRupOrders || !testUniqueAltRups ? 1 : 0) != 0, (Object)"testUniqueAltRups and useAltRupOrders are mutually exclusive");
            System.out.println("Loading alt rupture set");
            U3FaultSystemRupSet altRupSet = U3FaultSystemIO.loadRupSet(altRupSetFile);
            List<ClusterRupture> altRups = altRupSet.getClusterRuptures();
            HashMap<UniqueRupture, ClusterRupture> uniques = new HashMap<UniqueRupture, ClusterRupture>();
            for (ClusterRupture rup : rups) {
                uniques.put(rup.unique, rup);
            }
            rups = new ArrayList<ClusterRupture>();
            for (ClusterRupture rup : altRups) {
                boolean common = uniques.containsKey(rup.unique);
                if ((!common || !useAltRupOrders) && (common || !testUniqueAltRups)) continue;
                rups.add(rup);
            }
            System.out.println("Using " + rups.size() + " identical ruptures from alt source");
            configForMulti = altRupSet.getPlausibilityConfiguration();
        } else {
            useAltRupOrders = false;
            testUniqueAltRups = false;
        }
        int failCount = 0;
        List<PlausibilityFilter> filters = config.getFilters();
        if (includeTypes != null) {
            int i = filters.size();
            while (--i >= 0) {
                if (includeTypes.contains(filters.get(i).getClass())) continue;
                filters.remove(i);
            }
        }
        System.out.println("Testing " + rups.size() + " ruptures against " + filters.size() + " filters");
        for (int i = 0; i < filters.size(); ++i) {
            PlausibilityFilter filter = filters.get(i);
            if (!filter.isDirectional(false)) continue;
            System.out.println("Wrapping " + filter.getName() + " with a multi-directional");
            filters.set(i, new MultiDirectionalPlausibilityFilter(filter, configForMulti, false));
        }
        for (ClusterRupture rup : rups) {
            boolean fail = false;
            for (PlausibilityFilter filter : filters) {
                if (filter.apply(rup, false).isPass() != testUniqueAltRups) continue;
                fail = true;
                if (failCount >= maxNumVerbose) continue;
                System.out.println("=======================");
                if (testUniqueAltRups) {
                    System.out.println("Found an alt rupture which passes!");
                } else {
                    System.out.println("Found a failure!");
                }
                System.out.println("\tFilter: " + filter.getName());
                System.out.println("\tRupture: " + String.valueOf(rup));
                System.out.println("Applying verbose...");
                PlausibilityResult result = filter.apply(rup, true);
                System.out.println("Result: " + String.valueOf((Object)result));
                System.out.println("=======================");
                if (origRups == rups) continue;
                ClusterRupture origMatch = null;
                for (ClusterRupture oRup : origRups) {
                    if (!rup.unique.equals(oRup.unique)) continue;
                    origMatch = oRup;
                    break;
                }
                if (origMatch == null) {
                    System.out.println("No original match found");
                } else {
                    System.out.println("Testing original match");
                    System.out.println("\tRupture: " + String.valueOf(origMatch));
                    System.out.println("Applying verbose...");
                    result = filter.apply(origMatch, true);
                    System.out.println("Result: " + String.valueOf((Object)result));
                }
                System.out.println("=======================");
            }
            if (!fail) continue;
            ++failCount;
        }
        if (testUniqueAltRups) {
            System.out.println("Total number alt ruptures which pass: " + failCount + "/" + rups.size());
        } else {
            System.out.println("Total number of ruptures which fail: " + failCount + "/" + rups.size());
        }
    }
}

