/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.gui.plot.AnimatedGIFRenderer;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRuptureBuilder;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.DirectPathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpDistFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.MinSectsPerParentFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.SectCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.AbstractRelativeProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CoulombSectRatioProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeCoulombProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeSlipRateProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ConnectionPointsRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveBilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveUnilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.PlausibleClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.SectCountAdaptiveRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;

public class RupCartoonGenerator {
    private static boolean write_pdfs = false;
    public static SectionCharacteristicsFunction sectCharFun = (section, traceChar, outlineChar) -> {
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(traceChar);
        chars.add(outlineChar);
        chars.add(null);
        return chars;
    };
    private static Color[] strand_colors = new Color[]{Color.BLACK, Color.MAGENTA.darker(), Color.ORANGE.darker()};
    private static PlotCurveCharacterstics reg_jump_char = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED);
    private static PlotCurveCharacterstics splay_jump_char = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.CYAN);
    private static PlotCurveCharacterstics az_arrow_char = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN);

    private static void plotSection(FaultSection sect, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, PlotCurveCharacterstics traceChar, PlotCurveCharacterstics outlineChar) {
        List<PlotCurveCharacterstics> charOverrides = sectCharFun.getChars(sect, traceChar, outlineChar);
        traceChar = charOverrides.get(0);
        outlineChar = charOverrides.get(1);
        PlotCurveCharacterstics fillChar = charOverrides.get(2);
        if (sect.getAveDip() < 90.0) {
            RuptureSurface surf = sect.getFaultSurface(1.0, false, false);
            LocationList perimeter = surf.getPerimeter();
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (Location loc : perimeter) {
                xy.set(loc.getLongitude(), loc.getLatitude());
            }
            xy.set(xy.get(0));
            if (fillChar != null) {
                funcs.add(xy);
                chars.add(fillChar);
            }
            if (outlineChar != null) {
                funcs.add(xy);
                chars.add(outlineChar);
            }
        }
        if (traceChar != null) {
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (Location loc : sect.getFaultTrace()) {
                xy.set(loc.getLongitude(), loc.getLatitude());
            }
            funcs.add(xy);
            chars.add(traceChar);
        }
    }

    private static List<XY_DataSet> line(FaultSection from, FaultSection to, boolean arrow, double lenScale) {
        return RupCartoonGenerator.line(from, to, arrow, lenScale, null);
    }

    private static List<XY_DataSet> line(FaultSection from, FaultSection to, boolean arrow, double lenScale, Double arrowLen) {
        Location center1 = GriddedSurfaceUtils.getSurfaceMiddleLoc(from.getFaultSurface(1.0, false, false));
        Location center2 = GriddedSurfaceUtils.getSurfaceMiddleLoc(to.getFaultSurface(1.0, false, false));
        double arrowAz = LocationUtils.azimuth(center1, center2);
        double length = LocationUtils.horzDistanceFast(center1, center2);
        if (lenScale != 1.0) {
            center2 = LocationUtils.location(center1, Math.toRadians(arrowAz), length *= lenScale);
        }
        ArrayList<XY_DataSet> ret = new ArrayList<XY_DataSet>();
        ret.add(RupCartoonGenerator.buildLine(center1, center2));
        if (arrow) {
            if (arrowLen == null) {
                arrowLen = Math.max(1.0, Math.min(0.33 * length, 4.0));
            }
            double az1 = arrowAz + 135.0;
            double az2 = arrowAz - 135.0;
            Location arrow1 = LocationUtils.location(center2, Math.toRadians(az1), arrowLen);
            Location arrow2 = LocationUtils.location(center2, Math.toRadians(az2), arrowLen);
            ret.add(RupCartoonGenerator.buildLine(center2, arrow1));
            ret.add(RupCartoonGenerator.buildLine(center2, arrow2));
        }
        return ret;
    }

    private static XY_DataSet buildLine(Location from, Location to) {
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        xy.set(from.getLongitude(), from.getLatitude());
        xy.set(to.getLongitude(), to.getLatitude());
        return xy;
    }

    public static PlotSpec buildRupturePlot(ClusterRupture rup, String title, boolean plotAzimuths, boolean axisLabels) {
        return RupCartoonGenerator.buildRupturePlot(rup, title, plotAzimuths, axisLabels, null, null, null);
    }

    public static PlotSpec buildRupturePlot(ClusterRupture rup, String title, boolean plotAzimuths, boolean axisLabels, Set<? extends FaultSection> highlightSects, Color highlightColor, String highlightName) {
        String yAxisLabel;
        String xAxisLabel;
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        RupturePlotBuilder builder = new RupturePlotBuilder(plotAzimuths);
        if (highlightSects != null) {
            builder.setHighlightSects(highlightSects, highlightColor, highlightName);
        }
        builder.plotRecursive(rup);
        funcs.addAll(builder.sectFuncs);
        chars.addAll(builder.sectChars);
        funcs.addAll(builder.arrowFuncs);
        chars.addAll(builder.arrowChars);
        if (axisLabels) {
            xAxisLabel = "Longitude";
            yAxisLabel = "Latitude";
        } else {
            xAxisLabel = " ";
            yAxisLabel = " ";
        }
        PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
        spec.setLegendVisible(true);
        return spec;
    }

    public static void plotRupture(File outputDir, String prefix, ClusterRupture rup, String title, boolean plotAzimuths, boolean axisLabels) throws IOException {
        PlotSpec spec = RupCartoonGenerator.buildRupturePlot(rup, title, plotAzimuths, axisLabels);
        RupCartoonGenerator.plotRupture(outputDir, prefix, spec, axisLabels);
    }

    public static void plotRupture(File outputDir, String prefix, PlotSpec spec, boolean axisLabels) throws IOException {
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (PlotElement plotElement : spec.getPlotElems()) {
            for (Point2D pt : (XY_DataSet)plotElement) {
                latTrack.addValue(pt.getY());
                lonTrack.addValue(pt.getX());
            }
        }
        double minLon = lonTrack.getMin();
        double maxLon = lonTrack.getMax();
        double minLat = latTrack.getMin();
        double maxLat = latTrack.getMax();
        int width = 800;
        Range xRange = new Range(minLon -= 0.05, maxLon += 0.05);
        Range yRange = new Range(minLat -= 0.05, maxLat += 0.05);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        PlotUtils.setAxisVisible(gp, axisLabels, axisLabels);
        PlotUtils.setGridLinesVisible(gp, axisLabels, axisLabels);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, width, true, true, write_pdfs, false);
    }

    private static PlotSpec plotConnStrat(File outputDir, String prefix, String title, ClusterConnectionStrategy connStrat, List<PlausibilityFilter> filters, boolean axisLabels, List<Jump> extraPassing, List<Jump> extraFailing) throws IOException {
        String yAxisLabel;
        String xAxisLabel;
        List<XY_DataSet> lines;
        List<FaultSubsectionCluster> clusters = connStrat.getClusters();
        ConnectionPointsRuptureGrowingStrategy permStrat = new ConnectionPointsRuptureGrowingStrategy();
        ClusterRuptureBuilder build = new ClusterRuptureBuilder(clusters, filters, 0, connStrat.getDistCalc());
        System.out.println("Building ruptures with connStrat=" + connStrat.getName());
        List<ClusterRupture> rups = build.build(permStrat);
        System.out.println("Built " + rups.size() + " ruptures");
        HashSet<FaultSection> coruptureSects = new HashSet<FaultSection>();
        for (ClusterRupture rup : rups) {
            if (rup.clusters.length <= 1) continue;
            for (FaultSubsectionCluster cluster : rup.clusters) {
                coruptureSects.addAll((Collection<FaultSection>)cluster.subSects);
            }
        }
        System.out.println("Found " + coruptureSects.size() + " co-rupture sects");
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        PlotCurveCharacterstics corupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
        PlotCurveCharacterstics isolatedChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics outlineChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK);
        boolean firstIsolated = true;
        for (FaultSubsectionCluster faultSubsectionCluster : clusters) {
            for (FaultSection sect : faultSubsectionCluster.subSects) {
                RupCartoonGenerator.plotSection(sect, funcs, chars, isolatedChar, outlineChar);
                if (firstIsolated) {
                    ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Isolated Section");
                }
                firstIsolated = false;
            }
        }
        boolean firstCorup = true;
        for (Iterator<Jump> cluster : clusters) {
            for (FaultSection sect : ((FaultSubsectionCluster)((Object)cluster)).subSects) {
                if (!coruptureSects.contains(sect)) continue;
                RupCartoonGenerator.plotSection(sect, funcs, chars, corupChar, outlineChar);
                if (firstCorup) {
                    ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Co-rupturing Section");
                }
                firstCorup = false;
            }
        }
        boolean bl = true;
        for (Jump jump : clusters.get(0).getConnections()) {
            boolean bl2;
            lines = RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0);
            if (bl2) {
                lines.get(0).setName("Selected");
            }
            bl2 = false;
            for (XY_DataSet line : lines) {
                funcs.add(line);
                chars.add(reg_jump_char);
            }
        }
        boolean bl3 = true;
        for (Jump jump : extraPassing) {
            boolean bl4;
            lines = RupCartoonGenerator.line(jump.fromSection, jump.toSection, false, 1.0);
            if (bl4) {
                lines.get(0).setName("Passes");
            }
            bl4 = false;
            for (XY_DataSet line : lines) {
                funcs.add(line);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, new Color(255, 0, 0, 127)));
            }
        }
        boolean bl5 = true;
        for (Jump jump : extraFailing) {
            boolean bl6;
            lines = RupCartoonGenerator.line(jump.fromSection, jump.toSection, false, 1.0);
            if (bl6) {
                lines.get(0).setName("Fails");
            }
            bl6 = false;
            for (XY_DataSet line : lines) {
                funcs.add(line);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, new Color(0, 0, 0, 80)));
            }
        }
        if (axisLabels) {
            xAxisLabel = "Longitude";
            yAxisLabel = "Latitude";
        } else {
            xAxisLabel = " ";
            yAxisLabel = " ";
        }
        PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
        spec.setLegendVisible(true);
        RupCartoonGenerator.plotRupture(outputDir, prefix, spec, axisLabels);
        return spec;
    }

    private static FaultSection buildSect(int parentID, double dip, double upperDepth, double lowerDepth, Location ... traceLocs) {
        Preconditions.checkArgument((traceLocs.length > 1 ? 1 : 0) != 0);
        FaultTrace trace = new FaultTrace("");
        for (Location loc : traceLocs) {
            trace.add(loc);
        }
        FaultSectionPrefData sect = new FaultSectionPrefData();
        sect.setFaultTrace(trace);
        sect.setAveDip(dip);
        sect.setDipDirection((float)(trace.getAveStrike() + 90.0));
        sect.setAveLowerDepth(lowerDepth);
        sect.setAveUpperDepth(upperDepth);
        sect.setSectionId(parentID);
        return sect;
    }

    private static double getAnnY(Range yRange, int index, double startYMult, double deltaYMult) {
        return yRange.getLowerBound() + (startYMult - (double)index * deltaYMult) * (yRange.getUpperBound() - yRange.getLowerBound());
    }

    private static void animateRuptureBuilding(File outputDir, String prefix, SubSectBuilder rupBuild, List<PlausibilityFilter> filters, ClusterConnectionStrategy connStrat, int maxNumSplays, boolean includeDuplicates, boolean plotAzimuths, boolean axisLabels, double fps) throws IOException {
        RupCartoonGenerator.animateRuptureBuilding(outputDir, prefix, rupBuild, filters, connStrat, new ExhaustiveUnilateralRuptureGrowingStrategy(), maxNumSplays, includeDuplicates, true, plotAzimuths, axisLabels, fps, null);
    }

    private static void animateRuptureBuilding(File outputDir, String prefix, SubSectBuilder rupBuild, List<PlausibilityFilter> filters, ClusterConnectionStrategy connStrat, RuptureGrowingStrategy permStrat, int maxNumSplays, boolean includeDuplicates, boolean includeFailures, boolean plotAzimuths, boolean axisLabels, double fps, Set<FaultSection> startSects) throws IOException {
        TrackAllDebugCriteria tracker = new TrackAllDebugCriteria();
        ClusterRuptureBuilder builder = new ClusterRuptureBuilder(connStrat.getClusters(), filters, maxNumSplays, connStrat.getDistCalc());
        builder.setDebugCriteria(tracker, false);
        List<ClusterRupture> finalRups = builder.build(permStrat);
        if (startSects != null) {
            int r = finalRups.size();
            while (--r >= 0) {
                if (startSects.contains(finalRups.get((int)r).clusters[0].subSects.get(0))) continue;
                finalRups.remove(r);
            }
            r = tracker.allRups.size();
            while (--r >= 0) {
                if (startSects.contains(tracker.allRups.get((int)r).clusters[0].subSects.get(0))) continue;
                tracker.allRups.remove(r);
            }
        }
        System.out.println("Built " + finalRups.size() + " final rups");
        System.out.println("Tested " + tracker.allRups.size() + " rups");
        ArrayList<XY_DataSet> backgroundFuncs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> backgroundChars = new ArrayList<PlotCurveCharacterstics>();
        PlotCurveCharacterstics bgTraceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics bgOutlineChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.LIGHT_GRAY);
        for (FaultSection sect : rupBuild.subSectsList) {
            RupCartoonGenerator.plotSection(sect, backgroundFuncs, backgroundChars, bgTraceChar, bgOutlineChar);
        }
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (PlotElement plotElement : backgroundFuncs) {
            for (Point2D pt : (XY_DataSet)plotElement) {
                latTrack.addValue(pt.getY());
                lonTrack.addValue(pt.getX());
            }
        }
        double minLon = lonTrack.getMin();
        double maxLon = lonTrack.getMax();
        double minLat = latTrack.getMin();
        double maxLat = latTrack.getMax();
        int width = 800;
        Range xRange = new Range(minLon -= 0.05, maxLon += 0.05);
        Range yRange = new Range(minLat -= 0.05, maxLat += 0.05);
        HashSet<UniqueRupture> uniques = new HashSet<UniqueRupture>();
        Font annFont = new Font("SansSerif", 1, 22);
        double startYMult = 0.98;
        double deltaYMult = 0.08;
        double rightAnnX = xRange.getLowerBound() + 0.98 * (xRange.getUpperBound() - xRange.getLowerBound());
        double leftAnnX = xRange.getLowerBound() + 0.02 * (xRange.getUpperBound() - xRange.getLowerBound());
        File outputFile = new File(outputDir, prefix + ".gif");
        AnimatedGIFRenderer gifRender = new AnimatedGIFRenderer(outputFile, fps, true);
        int count = 0;
        for (ClusterRupture possible : tracker.allRups) {
            boolean duplicate = uniques.contains(possible.unique);
            if (duplicate && !includeDuplicates) continue;
            uniques.add(possible.unique);
            PlausibilityResult result = PlausibilityResult.PASS;
            ArrayList<PlausibilityResult> results = new ArrayList<PlausibilityResult>();
            for (PlausibilityFilter filter : filters) {
                PlausibilityResult subResult = filter.apply(possible, false);
                results.add(subResult);
                result = result.logicalAnd(subResult);
            }
            if (!includeFailures && !result.isPass()) continue;
            PlotSpec spec = RupCartoonGenerator.buildRupturePlot(possible, " ", false, false);
            ArrayList<XY_DataSet> newFuncs = new ArrayList<XY_DataSet>(backgroundFuncs);
            ArrayList<PlotCurveCharacterstics> newChars = new ArrayList<PlotCurveCharacterstics>(backgroundChars);
            newFuncs.addAll(spec.getPlotElems());
            newChars.addAll(spec.getChars());
            spec.setPlotElems(newFuncs);
            spec.setChars(newChars);
            XYTextAnnotation resultAnn = new XYTextAnnotation(result.name(), rightAnnX, RupCartoonGenerator.getAnnY(yRange, 0, startYMult, deltaYMult));
            resultAnn.setFont(annFont);
            resultAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
            if (result.isPass()) {
                resultAnn.setPaint((Paint)Color.GREEN.darker());
            } else if (result.canContinue()) {
                resultAnn.setPaint((Paint)Color.DARK_GRAY);
            } else {
                resultAnn.setPaint((Paint)Color.RED.darker());
            }
            spec.addPlotAnnotation((XYAnnotation)resultAnn);
            if (duplicate && result.isPass()) {
                XYTextAnnotation dupAnn = new XYTextAnnotation("DUPLICATE", rightAnnX, RupCartoonGenerator.getAnnY(yRange, 1, startYMult, deltaYMult));
                dupAnn.setFont(annFont);
                dupAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
                spec.addPlotAnnotation((XYAnnotation)dupAnn);
            }
            for (int i = 0; i < filters.size(); ++i) {
                String text = filters.get(i).getShortName() + ": ";
                PlausibilityResult subResult = (PlausibilityResult)((Object)results.get(i));
                if (subResult.isPass()) {
                    text = text + "\u2714";
                } else {
                    text = text + "X";
                    if (subResult.canContinue()) {
                        text = text + "*";
                    }
                }
                XYTextAnnotation resAnn = new XYTextAnnotation(text, leftAnnX, RupCartoonGenerator.getAnnY(yRange, i, startYMult, deltaYMult));
                resAnn.setFont(annFont);
                resAnn.setTextAnchor(TextAnchor.TOP_LEFT);
                spec.addPlotAnnotation((XYAnnotation)resAnn);
            }
            System.out.println("Plotting frame " + count++);
            HeadlessGraphPanel gp = PlotUtils.initHeadless();
            gp.drawGraphPanel(spec, false, false, xRange, yRange);
            PlotUtils.setAxisVisible(gp, axisLabels, axisLabels);
            PlotUtils.setGridLinesVisible(gp, axisLabels, axisLabels);
            int height = PlotUtils.calcHeight(gp, width, true);
            gp.getChartPanel().setSize(width, height);
            BufferedImage img = gp.getBufferedImage(width, height);
            gifRender.writeFrame(img);
        }
        gifRender.finalizeAnimation();
    }

    private static FaultSubsectionCluster buildCluster(FaultSection parentSect, double fractDDW, int startIndex) {
        double width = parentSect.getOrigDownDipWidth();
        return new FaultSubsectionCluster(parentSect.getSubSectionsList(fractDDW * width, startIndex, 2));
    }

    private static void plot(File outputDir, String prefix, String title, double fractDDW, boolean plotAzimuths, FaultSection ... parents) throws IOException {
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        for (FaultSection parent : parents) {
            rupBuild.addFault(parent);
        }
        SectionDistanceAzimuthCalculator distCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        RuptureConnectionSearch search = new RuptureConnectionSearch(null, distCalc, Double.POSITIVE_INFINITY, false);
        List<FaultSubsectionCluster> clusters = search.calcClusters(rupBuild.subSectsList, false);
        List<Jump> rupJumps = search.calcRuptureJumps(clusters, true);
        ClusterRupture fullRup = search.buildClusterRupture(clusters, rupJumps, true, clusters.get(0));
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        RupCartoonGenerator.plotRupture(outputDir, prefix, fullRup, title, plotAzimuths, false);
    }

    private static ClusterRupture getFullSectionsRup(ClusterRupture rup, Map<Integer, List<FaultSection>> parentSectsMap, SectionDistanceAzimuthCalculator distCalc) {
        ArrayList<FaultSubsectionCluster> fullClusters = new ArrayList<FaultSubsectionCluster>();
        for (FaultSubsectionCluster cluster : rup.clusters) {
            List<FaultSection> fullSects = parentSectsMap.get(cluster.parentSectionID);
            if (cluster.subSects.size() == fullSects.size()) {
                fullClusters.add(cluster);
                continue;
            }
            int fullStartID = fullSects.get(0).getSectionId();
            int fullEndID = fullSects.get(fullSects.size() - 1).getSectionId();
            int clusterStartID = cluster.startSect.getSectionId();
            int clusterEndID = ((FaultSection)cluster.subSects.get(cluster.subSects.size() - 1)).getSectionId();
            if (fullStartID == clusterEndID || fullEndID == clusterStartID) {
                fullSects = new ArrayList<FaultSection>(fullSects);
                Collections.reverse(fullSects);
            }
            fullClusters.add(new FaultSubsectionCluster(fullSects));
        }
        RuptureConnectionSearch search = new RuptureConnectionSearch(null, distCalc, Double.POSITIVE_INFINITY, false);
        List<Jump> rupJumps = search.calcRuptureJumps(fullClusters, true);
        return search.buildClusterRupture(fullClusters, rupJumps, true, (FaultSubsectionCluster)fullClusters.get(0));
    }

    private static void buildStandardDemos(File outputDir) throws IOException {
        double upperDepth = 0.0;
        double lowerDepth = 20.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        FaultSection firstHorz = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 0.0), new Location(0.0, 1.0));
        FaultSection secondHorz = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 1.05), new Location(0.0, 2.05));
        FaultSection jumpBelowFromEndSecond = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(-0.1, 2.0), new Location(-0.5, 2.5));
        FaultSection jumpAboveFromEndSecond = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.1, 2.0), new Location(0.5, 2.5));
        FaultSection jumpAboveFromMidSecond = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.2, 1.5), new Location(0.6, 2.1));
        FaultSection tVert = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(-0.5, 2.1), new Location(0.5, 2.1));
        RupCartoonGenerator.plot(outputDir, "simple_jump_1", "Single Strand, 2 Jumps", fractDDW, false, firstHorz, secondHorz, jumpBelowFromEndSecond);
        RupCartoonGenerator.plot(outputDir, "splay_jump_1", "Multiple Strands, 2 Jumps", fractDDW, false, firstHorz, secondHorz, jumpAboveFromMidSecond);
        RupCartoonGenerator.plot(outputDir, "splay_jump_2", "Multiple Strands, 3 Jumps", fractDDW, false, firstHorz, secondHorz, jumpBelowFromEndSecond, jumpAboveFromMidSecond);
        RupCartoonGenerator.plot(outputDir, "y_jump_1", "Y Jump (Simple+Splay)", fractDDW, false, firstHorz, secondHorz, jumpBelowFromEndSecond, jumpAboveFromEndSecond);
        RupCartoonGenerator.plot(outputDir, "t_jump_1", "T Jump", fractDDW, false, firstHorz, secondHorz, tVert);
        FaultSection almostParallelTowardEndFirst = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.3, 0.6), new Location(0.28, 1.0));
        FaultSection almostParallelTowardMiddleFirst = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.3, 0.6), new Location(0.32, 1.0));
        FaultSection shorterFirstHorz = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 0.0), new Location(0.0, 0.6));
        RupCartoonGenerator.plot(outputDir, "parallel_as_primary", "Parallel Single Strand", fractDDW, true, firstHorz, almostParallelTowardEndFirst);
        RupCartoonGenerator.plot(outputDir, "parallel_as_splay", "Parallel Splay", fractDDW, true, firstHorz, almostParallelTowardMiddleFirst);
        RupCartoonGenerator.plot(outputDir, "parallel_simple", "Parallel Simple", fractDDW, true, shorterFirstHorz, almostParallelTowardEndFirst);
        FaultSection azExampleAbove = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(-0.03, 1.02), new Location(0.15, 1.02));
        RupCartoonGenerator.plot(outputDir, "az_example_1", "Azimuth Example 1", fractDDW, true, firstHorz, azExampleAbove);
        FaultSection azExampleBelow = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(-0.15, 1.02), new Location(0.03, 1.02));
        RupCartoonGenerator.plot(outputDir, "az_example_2", "Azimuth Example 2", fractDDW, true, firstHorz, azExampleBelow);
        FaultSection smallHorz = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 0.0), new Location(0.0, 0.2));
        FaultSection smallSE = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(-0.01, 0.22), new Location(-0.02, 0.28));
        FaultSection smallNE = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.04, 0.22), new Location(0.1, 0.35));
        FaultSection smallNConn = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(-0.038, 0.27), new Location(0.09, 0.45));
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(smallHorz);
        rupBuild.addFault(smallSE);
        rupBuild.addFault(smallNE);
        rupBuild.addFault(smallNConn);
        ArrayList<PlausibilityFilter> filters = new ArrayList<PlausibilityFilter>();
        SectionDistanceAzimuthCalculator animDistAzCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, animDistAzCalc, Double.POSITIVE_INFINITY);
        filters.add(new MinSectsPerParentFilter(2, false, false, connStrat));
        filters.add(new JumpAzimuthChangeFilter(new JumpAzimuthChangeFilter.SimpleAzimuthCalc(animDistAzCalc), 60.0f));
        RupCartoonGenerator.animateRuptureBuilding(outputDir, "system_build_anim", rupBuild, filters, connStrat, 0, true, false, false, 1.0);
    }

    private static void buildThinningAnimDemo(File outputDir) throws IOException {
        double upperDepth = 0.0;
        double lowerDepth = 20.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        FaultSection s1 = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 0.0), new Location(0.0, 0.95));
        FaultSection s2 = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 1.05), new Location(0.0, 1.95));
        FaultSection s3 = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 2.05), new Location(0.0, 2.95));
        FaultSection s4 = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.0, 3.05), new Location(0.0, 3.95));
        FaultSection s5 = RupCartoonGenerator.buildSect(parentID++, 85.0, upperDepth, lowerDepth, new Location(0.05, 3.65), new Location(0.55, 3.9));
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(s1);
        HashSet<FaultSection> s1Sects = new HashSet<FaultSection>(rupBuild.subSectsList);
        rupBuild.addFault(s2);
        rupBuild.addFault(s3);
        rupBuild.addFault(s4);
        rupBuild.addFault(s5);
        SectionDistanceAzimuthCalculator animDistAzCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, animDistAzCalc, 20.0);
        ArrayList<PlausibilityFilter> filters = new ArrayList<PlausibilityFilter>();
        filters.add(new MinSectsPerParentFilter(2, false, false, connStrat));
        RupCartoonGenerator.animateRuptureBuilding(outputDir, "system_build_anim_thin", rupBuild, filters, connStrat, new SectCountAdaptiveRuptureGrowingStrategy(0.1f, true, 2), 0, true, true, false, false, 2.0, s1Sects);
        RupCartoonGenerator.animateRuptureBuilding(outputDir, "system_build_anim_no_thin", rupBuild, filters, connStrat, new ExhaustiveUnilateralRuptureGrowingStrategy(), 0, true, true, false, false, 2.0, s1Sects);
    }

    private static void buildPermStratDemos(File outputDir) throws IOException {
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        int numRupsToPlot = 20;
        double dip = 84.0;
        float fract = 0.1f;
        double x1 = 50.0;
        double x2 = x1 + 2.0;
        double x3 = x2 + 35.0;
        double x4 = x3 + 15.0;
        double x5 = x2 + 75.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double y3 = -3.0;
        double y4 = 2.0;
        FaultSection s1 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, y1), RupCartoonGenerator.loc(x1, y1));
        s1.setAveRake(180.0);
        FaultSection s2 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(x2, y1), RupCartoonGenerator.loc(x5, y4));
        s2.setAveRake(180.0);
        FaultSection s3 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(x3, y2), RupCartoonGenerator.loc(x4, y3));
        s3.setAveRake(180.0);
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(s1);
        HashSet<FaultSection> s1Sects = new HashSet<FaultSection>(rupBuild.subSectsList);
        System.out.println("S1 has " + s1Sects.size() + " sects");
        rupBuild.addFault(s2);
        rupBuild.addFault(s3);
        SectionDistanceAzimuthCalculator animDistAzCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, animDistAzCalc, 5.0);
        ArrayList filters = new ArrayList();
        ArrayList<RuptureGrowingStrategy> permStrats = new ArrayList<RuptureGrowingStrategy>();
        ArrayList<String> prefixes = new ArrayList<String>();
        permStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(fract, true, 1));
        prefixes.add("perm_strat_adaptive");
        permStrats.add(new ExhaustiveUnilateralRuptureGrowingStrategy());
        prefixes.add("perm_strat_exhaustive");
        permStrats.add(new ConnectionPointsRuptureGrowingStrategy());
        prefixes.add("perm_strat_conn_points");
        PlotCurveCharacterstics rupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
        PlotCurveCharacterstics noRupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
        PlotCurveCharacterstics whiteChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.WHITE);
        for (int p = 0; p < permStrats.size(); ++p) {
            RuptureGrowingStrategy permStrat = (RuptureGrowingStrategy)permStrats.get(p);
            String title = permStrat.getName().replaceAll("Unilateral", "").trim();
            if (title.startsWith(",")) {
                title = title.substring(1).trim();
            }
            if (title.endsWith(",")) {
                title = title.substring(0, title.length() - 1).trim();
            }
            System.out.println(title);
            ArrayList<PlausibilityFilter> myFilters = new ArrayList<PlausibilityFilter>(filters);
            if (permStrat instanceof SectCountAdaptiveRuptureGrowingStrategy) {
                myFilters.add(((SectCountAdaptiveRuptureGrowingStrategy)permStrat).buildConnPointCleanupFilter(connStrat));
            }
            ClusterRuptureBuilder builder = new ClusterRuptureBuilder(connStrat.getClusters(), myFilters, 0, connStrat.getDistCalc());
            List<ClusterRupture> rups = builder.build(permStrat);
            ArrayList<ClusterRupture> matchingRups = new ArrayList<ClusterRupture>();
            for (ClusterRupture rup : rups) {
                if (rup.clusters[0].parentSectionID != s1.getSectionId() || rup.clusters[0].subSects.size() != s1Sects.size()) continue;
                matchingRups.add(rup);
                if (matchingRups.size() != numRupsToPlot) continue;
                break;
            }
            System.out.println("Plotting " + matchingRups.size() + " ruptures");
            ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
            ArrayList<String> titles = new ArrayList<String>();
            for (ClusterRupture rup : matchingRups) {
                ArrayList funcs = new ArrayList();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                titles.add(" ");
                boolean firstRup = true;
                boolean firstNoRup = true;
                for (FaultSection faultSection : rupBuild.subSectsList) {
                    if (rup.contains(faultSection)) {
                        RupCartoonGenerator.plotSection(faultSection, funcs, chars, rupChar, traceChar);
                        if (firstRup) {
                            ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Ruptured Section");
                        }
                        firstRup = false;
                        continue;
                    }
                    RupCartoonGenerator.plotSection(faultSection, funcs, chars, noRupChar, traceChar);
                    if (firstNoRup) {
                        ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Other Section");
                    }
                    firstNoRup = false;
                }
                boolean firstJump = true;
                for (Jump jump : rup.getJumpsIterable()) {
                    List<XY_DataSet> arrow = RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0, 1.0);
                    if (firstJump) {
                        arrow.get(0).setName("Jump");
                    }
                    for (XY_DataSet xy : arrow) {
                        funcs.add(xy);
                        chars.add(reg_jump_char);
                    }
                }
                PlotSpec plotSpec = new PlotSpec(funcs, chars, title, null, " ");
                plotSpec.setLegendVisible(specs.isEmpty());
                specs.add(plotSpec);
            }
            while (specs.size() < numRupsToPlot) {
                ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                titles.add(" ");
                for (FaultSection sect : rupBuild.subSectsList) {
                    RupCartoonGenerator.plotSection(sect, funcs, chars, whiteChar, whiteChar);
                }
                PlotSpec spec = new PlotSpec(funcs, chars, title, null, " ");
                spec.setLegendVisible(false);
                specs.add(spec);
            }
            RupCartoonGenerator.plotTileMulti(outputDir, (String)prefixes.get(p), specs, title, titles, 0.01, 16, 0);
        }
    }

    private static void buildPermStratBilateralDemos(File outputDir) throws IOException {
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        int numRupsToPlot = 13;
        double dip = 84.0;
        float fract = 0.1f;
        FaultSection s1 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(20.0, -2.5), RupCartoonGenerator.loc(45.0, -0.5));
        s1.setAveRake(180.0);
        FaultSection s2 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(33.0, 1.0), RupCartoonGenerator.loc(60.0, -2.5));
        s2.setAveRake(180.0);
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(s1);
        HashSet<FaultSection> s1Sects = new HashSet<FaultSection>(rupBuild.subSectsList);
        System.out.println("S1 has " + s1Sects.size() + " sects");
        rupBuild.addFault(s2);
        SectionDistanceAzimuthCalculator animDistAzCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, animDistAzCalc, 5.0);
        ArrayList filters = new ArrayList();
        ArrayList<RuptureGrowingStrategy> permStrats = new ArrayList<RuptureGrowingStrategy>();
        ArrayList<String> prefixes = new ArrayList<String>();
        permStrats.add(new ExhaustiveUnilateralRuptureGrowingStrategy());
        prefixes.add("perm_strat_bilateral_unilateral");
        permStrats.add(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.ALL, false));
        prefixes.add("perm_strat_bilateral_all");
        permStrats.add(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.SINGLE_FULL, false));
        prefixes.add("perm_strat_bilateral_single_full");
        permStrats.add(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.EQUAL_LEN, false));
        prefixes.add("perm_strat_bilateral_equal_len");
        permStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.SINGLE_FULL, false), fract, true, 1));
        prefixes.add("perm_strat_bilateral_adaptive_single_full");
        permStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.EQUAL_LEN, false), fract, true, 1));
        prefixes.add("perm_strat_bilateral_adaptive_equal_len");
        PlotCurveCharacterstics rupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
        PlotCurveCharacterstics noRupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
        PlotCurveCharacterstics whiteChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.WHITE);
        for (int p = 0; p < permStrats.size(); ++p) {
            RuptureGrowingStrategy permStrat = (RuptureGrowingStrategy)permStrats.get(p);
            String title = permStrat.getName();
            System.out.println(title);
            ArrayList<PlausibilityFilter> myFilters = new ArrayList<PlausibilityFilter>(filters);
            if (permStrat instanceof SectCountAdaptiveRuptureGrowingStrategy) {
                myFilters.add(((SectCountAdaptiveRuptureGrowingStrategy)permStrat).buildConnPointCleanupFilter(connStrat));
            }
            ClusterRuptureBuilder builder = new ClusterRuptureBuilder(connStrat.getClusters(), myFilters, 0, connStrat.getDistCalc());
            List<ClusterRupture> rups = builder.build(permStrat);
            ArrayList<ClusterRupture> matchingRups = new ArrayList<ClusterRupture>();
            for (ClusterRupture rup : rups) {
                if (rup.clusters[0].parentSectionID != s1.getSectionId() || rup.clusters[0].subSects.size() != s1Sects.size()) continue;
                matchingRups.add(rup);
                if (matchingRups.size() != numRupsToPlot) continue;
                break;
            }
            System.out.println("Plotting " + matchingRups.size() + " ruptures");
            ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
            ArrayList<String> titles = new ArrayList<String>();
            for (ClusterRupture rup : matchingRups) {
                ArrayList funcs = new ArrayList();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                titles.add(" ");
                boolean firstRup = true;
                boolean firstNoRup = true;
                for (FaultSection faultSection : rupBuild.subSectsList) {
                    if (rup.contains(faultSection)) {
                        RupCartoonGenerator.plotSection(faultSection, funcs, chars, rupChar, traceChar);
                        if (firstRup) {
                            ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Ruptured Section");
                        }
                        firstRup = false;
                        continue;
                    }
                    RupCartoonGenerator.plotSection(faultSection, funcs, chars, noRupChar, traceChar);
                    if (firstNoRup) {
                        ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Other Section");
                    }
                    firstNoRup = false;
                }
                boolean firstJump = true;
                for (Jump jump : rup.getJumpsIterable()) {
                    List<XY_DataSet> arrow = RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0, 1.0);
                    if (firstJump) {
                        arrow.get(0).setName("Jump");
                    }
                    for (XY_DataSet xy : arrow) {
                        funcs.add(xy);
                        chars.add(reg_jump_char);
                    }
                }
                PlotSpec plotSpec = new PlotSpec(funcs, chars, title, null, " ");
                plotSpec.setLegendVisible(specs.isEmpty());
                specs.add(plotSpec);
            }
            while (specs.size() < numRupsToPlot) {
                ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                titles.add(" ");
                for (FaultSection sect : rupBuild.subSectsList) {
                    RupCartoonGenerator.plotSection(sect, funcs, chars, whiteChar, whiteChar);
                }
                PlotSpec spec = new PlotSpec(funcs, chars, title, null, " ");
                spec.setLegendVisible(false);
                specs.add(spec);
            }
            RupCartoonGenerator.plotTileMulti(outputDir, (String)prefixes.get(p), specs, title, titles, 0.0, 16, 0);
        }
    }

    private static XY_DataSet cloneOffset(XY_DataSet xy, double xOff, double yOff) {
        DefaultXY_DataSet ret = new DefaultXY_DataSet();
        ret.setName(xy.getName());
        for (Point2D pt : xy) {
            ret.set(pt.getX() + xOff, pt.getY() + yOff);
        }
        return ret;
    }

    private static void plotTileMulti(File outputDir, String prefix, List<PlotSpec> specs, String title, List<String> titles, double yDelta, int titleFontSize, int refRangeIndex) throws IOException {
        double maxLat;
        double minLat;
        double maxLon;
        double minLon;
        ArrayList<XY_DataSet> combFuncs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> combChars = new ArrayList<PlotCurveCharacterstics>();
        double yOffset = 0.0;
        ArrayList<XYTextAnnotation> anns = new ArrayList<XYTextAnnotation>();
        Double prevBottom = null;
        DataUtils.MinMaxAveTracker refLatTrack = null;
        DataUtils.MinMaxAveTracker refLonTrack = null;
        if (refRangeIndex >= 0) {
            refLatTrack = new DataUtils.MinMaxAveTracker();
            refLonTrack = new DataUtils.MinMaxAveTracker();
            for (PlotElement plotElement : specs.get(refRangeIndex).getPlotElems()) {
                for (Point2D pt : (XY_DataSet)plotElement) {
                    refLatTrack.addValue(pt.getY());
                    refLonTrack.addValue(pt.getX());
                }
            }
        }
        for (int i = 0; i < specs.size(); ++i) {
            List<XYAnnotation> specAnns;
            PlotSpec plotSpec = specs.get(i);
            DataUtils.MinMaxAveTracker subLatTrack = refLatTrack;
            DataUtils.MinMaxAveTracker subLonTrack = refLonTrack;
            if (refRangeIndex < 0) {
                subLatTrack = new DataUtils.MinMaxAveTracker();
                subLonTrack = new DataUtils.MinMaxAveTracker();
                for (PlotElement plotElement : plotSpec.getPlotElems()) {
                    for (Point2D pt : (XY_DataSet)plotElement) {
                        subLatTrack.addValue(pt.getY());
                        subLonTrack.addValue(pt.getX());
                    }
                    if (refRangeIndex < 0 || i != 0) continue;
                    System.out.println("REFERENCE RANGES");
                    System.out.println("\tX:");
                }
            }
            for (XY_DataSet xY_DataSet : plotSpec.getPlotElems()) {
                XY_DataSet modFunc = RupCartoonGenerator.cloneOffset(xY_DataSet, 0.0, yOffset);
                if (!plotSpec.isLegendVisible()) {
                    modFunc.setName(null);
                }
                combFuncs.add(modFunc);
            }
            combChars.addAll(plotSpec.getChars());
            if (titles != null) {
                double titleX = subLonTrack.getMin() + 0.5 * (subLonTrack.getMax() - subLonTrack.getMin());
                double myTop = subLatTrack.getMax() + yOffset;
                if (prevBottom == null) {
                    prevBottom = myTop + yDelta;
                }
                double titleY = 0.5 * (myTop + prevBottom);
                XYTextAnnotation ann = new XYTextAnnotation(titles.get(i), titleX, titleY);
                ann.setTextAnchor(TextAnchor.CENTER);
                ann.setFont(new Font("SansSerif", 1, titleFontSize));
                anns.add(ann);
            }
            if ((specAnns = plotSpec.getPlotAnnotations()) != null) {
                for (XYAnnotation ann : specAnns) {
                    if (!(ann instanceof XYTextAnnotation)) continue;
                    XYTextAnnotation tAnn = (XYTextAnnotation)ann;
                    try {
                        tAnn = (XYTextAnnotation)tAnn.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    tAnn.setY(tAnn.getY() + yOffset);
                    anns.add(tAnn);
                }
            }
            prevBottom = subLatTrack.getMin() + yOffset;
            yOffset -= subLatTrack.getMax() - subLatTrack.getMin();
            yOffset -= yDelta;
        }
        if (refRangeIndex < 0) {
            DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
            for (PlotElement plotElement : combFuncs) {
                for (Point2D pt : (XY_DataSet)plotElement) {
                    latTrack.addValue(pt.getY());
                    lonTrack.addValue(pt.getX());
                }
            }
            minLon = lonTrack.getMin();
            maxLon = lonTrack.getMax();
            minLat = latTrack.getMin();
            maxLat = latTrack.getMax();
        } else {
            minLon = refLonTrack.getMin();
            maxLon = refLonTrack.getMax();
            minLat = refLatTrack.getMin();
            maxLat = refLatTrack.getMax();
            minLat -= (double)(specs.size() - 1) * (yDelta + maxLat - minLat);
        }
        double maxDelta = Math.max(maxLat - minLat, maxLon - minLon);
        double buffer = Math.min(maxDelta * 0.1, 0.05);
        double latSpan = (maxLat += titles == null ? buffer : buffer * 1.2) - (minLat -= buffer);
        double lonSpan = (maxLon += buffer) - (minLon -= buffer);
        int width = 800;
        double plotWidth = width - 70;
        double plotHeight = plotWidth * latSpan / lonSpan;
        int height = 150 + (int)plotHeight;
        Range xRange = new Range(minLon, maxLon);
        Range yRange = new Range(minLat, maxLat);
        PlotSpec combSpec = new PlotSpec(combFuncs, combChars, title, null, " ");
        combSpec.setLegendVisible(true);
        combSpec.setPlotAnnotations(anns);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        if (titles != null && titles.size() >= 10) {
            gp.setLegendFontSize(26);
        }
        gp.drawGraphPanel(combSpec, false, false, xRange, yRange);
        PlotUtils.setAxisVisible(gp, false, false);
        PlotUtils.setGridLinesVisible(gp, false, false);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, width, -1, true, write_pdfs, false);
    }

    private static void buildConnStratDemo(File outputDir) throws IOException {
        int i;
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        double dip = 88.0;
        double maxDist = 10.0;
        float r0 = 5.0f;
        FaultSection s1 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, 0.0), RupCartoonGenerator.loc(31.0, 0.0));
        s1.setAveRake(180.0);
        FaultSection s2 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(15.0, -4.0), RupCartoonGenerator.loc(22.5, -3.5), RupCartoonGenerator.loc(30.0, -4.0), RupCartoonGenerator.loc(40.0, -12.0));
        s2.setAveRake(180.0);
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        FaultSection[] startsWithSects = new FaultSection[2];
        rupBuild.addFault(s2);
        startsWithSects[0] = rupBuild.subSectsList.get(rupBuild.subSectsList.size() - 1);
        int startNext = rupBuild.subSectsList.size();
        rupBuild.addFault(s1);
        startsWithSects[1] = rupBuild.subSectsList.get(startNext);
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        ArrayList<PlausibilityFilter> filters = new ArrayList<PlausibilityFilter>();
        SubSectStiffnessCalculator stiffCalc = new SubSectStiffnessCalculator(rupBuild.subSectsList, 2.0, 30000.0, 30000.0, 0.5);
        AggregatedStiffnessCalculator aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffCalc, false, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        filters.add(new CumulativeProbabilityFilter(0.5f, new CoulombSectRatioProb(aggCalc, 2)));
        filters.add(new StartsWithFitler(startsWithSects));
        ArrayList<ClusterConnectionStrategy> connStrats = new ArrayList<ClusterConnectionStrategy>();
        ArrayList<String> connPrefixes = new ArrayList<String>();
        ArrayList<String> connTitles = new ArrayList<String>();
        connStrats.add(new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, distAzCalc, maxDist));
        connPrefixes.add("conn_min_dist");
        connTitles.add("Minimum Distance");
        PlausibleClusterConnectionStrategy.FallbackJumpSelector singleSelect = new PlausibleClusterConnectionStrategy.FallbackJumpSelector(true, new PlausibleClusterConnectionStrategy.PassesMinimizeFailedSelector(true), new PlausibleClusterConnectionStrategy.BestScalarSelector(2.0));
        PlausibleClusterConnectionStrategy.FallbackJumpSelector multiSelect = new PlausibleClusterConnectionStrategy.FallbackJumpSelector(false, new PlausibleClusterConnectionStrategy.PassesMinimizeFailedSelector(true), new PlausibleClusterConnectionStrategy.AllowMultiEndsSelector(r0, new PlausibleClusterConnectionStrategy.FallbackJumpSelector(true, new PlausibleClusterConnectionStrategy.BestScalarSelector(2.0))));
        PlausibleClusterConnectionStrategy.AnyPassSelector allSelect = new PlausibleClusterConnectionStrategy.AnyPassSelector(true);
        PlausibleClusterConnectionStrategy.WithinDistanceSelector withinSelect = new PlausibleClusterConnectionStrategy.WithinDistanceSelector((float)maxDist);
        connStrats.add(new PlausibleClusterConnectionStrategy(rupBuild.subSectsList, distAzCalc, maxDist, (PlausibleClusterConnectionStrategy.JumpSelector)singleSelect, filters));
        connPrefixes.add("conn_plausible_single");
        connTitles.add("Path-Optimized, Plausible, Single Connection");
        connStrats.add(new PlausibleClusterConnectionStrategy(rupBuild.subSectsList, distAzCalc, maxDist, (PlausibleClusterConnectionStrategy.JumpSelector)multiSelect, filters));
        connPrefixes.add("conn_plausible_multi");
        connTitles.add("Path-Optimized, Plausible, Multiple Connections");
        ArrayList<Jump> allPossibleJumps = new ArrayList<Jump>();
        PlausibleClusterConnectionStrategy all = new PlausibleClusterConnectionStrategy(rupBuild.subSectsList, distAzCalc, maxDist, (PlausibleClusterConnectionStrategy.JumpSelector)allSelect, filters);
        allPossibleJumps.addAll(all.getClusters().get(0).getConnections());
        System.out.println("Plotting " + allPossibleJumps.size() + " extra possible jumps");
        PlausibleClusterConnectionStrategy allDist = new PlausibleClusterConnectionStrategy(rupBuild.subSectsList, distAzCalc, maxDist, (PlausibleClusterConnectionStrategy.JumpSelector)withinSelect, filters);
        ArrayList<Jump> failedJumps = new ArrayList<Jump>();
        for (Jump jump : allDist.getClusters().get(0).getConnections()) {
            if (allPossibleJumps.contains(jump)) continue;
            failedJumps.add(jump);
        }
        System.out.println("Plotting " + failedJumps.size() + " extra failed jumps");
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        for (i = 0; i < connStrats.size(); ++i) {
            specs.add(RupCartoonGenerator.plotConnStrat(outputDir, (String)connPrefixes.get(i), (String)connTitles.get(i), (ClusterConnectionStrategy)connStrats.get(i), filters, false, allPossibleJumps, failedJumps));
        }
        for (i = 1; i < specs.size(); ++i) {
            ((PlotSpec)specs.get(i)).setLegendVisible(false);
        }
        RupCartoonGenerator.plotTileMulti(outputDir, "conn_combined", specs, "Connection Strategy Example", connTitles, 0.025, 22, 0);
    }

    private static void buildPathCoulombDemos(File outputDir) throws IOException {
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        double dip = 88.0;
        FaultSection s1 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, 0.0), RupCartoonGenerator.loc(15.0, 0.0));
        s1.setAveRake(180.0);
        FaultSection s2 = RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(13.0, -1.0), RupCartoonGenerator.loc(33.0, -1.0));
        s2.setAveRake(180.0);
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(s1);
        HashSet<FaultSection> s1Sects = new HashSet<FaultSection>(rupBuild.subSectsList);
        System.out.println("S1 has " + s1Sects.size() + " sects");
        rupBuild.addFault(s2);
        RupCartoonGenerator.buildPathCoulombDemo(outputDir, "cff_ratio_overlapping_ss", SubSectStiffnessCalculator.StiffnessType.CFF.getName() + " Ratio, Simple Path", false, 10.0, rupBuild);
        RupCartoonGenerator.buildPathCoulombDemo(outputDir, "cff_ratio_overlapping_ss_favjump", SubSectStiffnessCalculator.StiffnessType.CFF.getName() + " Ratio, Favorable Path", true, 10.0, rupBuild);
    }

    private static void buildPathCoulombDemo(File outputDir, String prefix, String title, boolean jumpToMostFavorable, double maxJumpDist, SubSectBuilder rupBuild) throws IOException {
        int numDenominatorSubsects = 2;
        float threshold = 0.5f;
        CPT favCPT = new CPT();
        favCPT.add(new CPTVal(0.0, Color.BLUE, 0.5, Color.BLUE));
        favCPT.add(new CPTVal(0.5, Color.RED, 1.0, Color.RED.darker().darker()));
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, distAzCalc, maxJumpDist);
        SubSectStiffnessCalculator stiffCalc = new SubSectStiffnessCalculator(rupBuild.subSectsList, 2.0, 30000.0, 30000.0, 0.5);
        AggregatedStiffnessCalculator aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffCalc, false, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        DecimalFormat df = new DecimalFormat("0.00");
        List<FaultSubsectionCluster> clusters = connStrat.getClusters();
        for (int n = 0; n < clusters.size(); ++n) {
            int i;
            System.out.println("Nucleation cluster: " + String.valueOf(clusters.get(n)));
            ClusterRupture rup = new ClusterRupture(clusters.get(n));
            if (n == clusters.size() - 1) {
                rup = rup.reversed();
            }
            for (i = n + 1; i < clusters.size(); ++i) {
                rup = rup.take(clusters.get(i - 1).getConnectionsTo(clusters.get(i)).iterator().next());
            }
            i = n;
            while (--i >= 0) {
                FaultSubsectionCluster prev = clusters.get(i + 1);
                FaultSubsectionCluster to = clusters.get(i);
                Jump jump = prev.getConnectionsTo(to).iterator().next();
                jump = rup.clusters.length == 1 ? new Jump(jump.fromSection, jump.fromCluster.reversed(), jump.toSection, jump.toCluster.reversed(), jump.distance) : new Jump(jump.fromSection, jump.fromCluster, jump.toSection, jump.toCluster.reversed(), jump.distance);
                rup = rup.take(jump);
            }
            System.out.println("Rupture: " + String.valueOf(rup));
            PathEvaluator.SectionPathNavigator nav = jumpToMostFavorable ? new SectCoulombPathEvaluator.CoulombFavorableSectionPathNavigator((Collection<FaultSection>)rup.clusters[0].subSects, rup.getTreeNavigator(), aggCalc, (com.google.common.collect.Range<Float>)com.google.common.collect.Range.atLeast((Comparable)Float.valueOf(0.0f)), distAzCalc, (float)maxJumpDist) : new PathEvaluator.SectionPathNavigator((Collection<? extends FaultSection>)rup.clusters[0].subSects, rup.getTreeNavigator());
            nav.setVerbose(true);
            double prob = 1.0;
            List<FaultSection> currentSects = null;
            Set<PathEvaluator.PathAddition> nextAdds = null;
            PlotCurveCharacterstics rupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
            PlotCurveCharacterstics futureChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.LIGHT_GRAY);
            PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
            PlotCurveCharacterstics sourceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GREEN.darker());
            double arrowLen = 0.4;
            PlotCurveCharacterstics jumpChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, new Color(210, 105, 30, 127));
            boolean firstRupSect = true;
            boolean firstSourceSect = true;
            boolean firstEffective = true;
            XY_DataSet lastRecieverFunc = null;
            XY_DataSet bestRecieverFunc = null;
            double bestReceiverScore = -1.0;
            ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
            ArrayList<String> titles = new ArrayList<String>();
            do {
                if (currentSects == null) {
                    ArrayList funcs = new ArrayList();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    for (FaultSubsectionCluster cluster : rup.clusters) {
                        for (FaultSection sect : cluster.subSects) {
                            RupCartoonGenerator.plotSection(sect, funcs, chars, rupChar, traceChar);
                            if (firstRupSect) {
                                ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Full Rupture");
                            }
                            firstRupSect = false;
                        }
                    }
                    titles.add("Full Rupture");
                    for (Jump jump : rup.getJumpsIterable()) {
                        for (Object xy2 : RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0, arrowLen)) {
                            funcs.add(xy2);
                            chars.add(jumpChar);
                        }
                    }
                    PlotSpec spec = new PlotSpec(funcs, chars, null, null, " ");
                    spec.setLegendVisible(true);
                    specs.add(spec);
                } else {
                    for (PathEvaluator.PathAddition add : nextAdds) {
                        Object xy3;
                        Object xy2;
                        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
                        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                        HashSet<FaultSection> processed = new HashSet<FaultSection>();
                        xy2 = currentSects.iterator();
                        while (xy2.hasNext()) {
                            FaultSection source = xy2.next();
                            RupCartoonGenerator.plotSection(source, funcs, chars, sourceChar, traceChar);
                            if (firstSourceSect) {
                                ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Source");
                            }
                            firstSourceSect = false;
                            processed.add(source);
                        }
                        Preconditions.checkState((add.toSects.size() == 1 ? 1 : 0) != 0);
                        FaultSection receiver = add.toSects.iterator().next();
                        CoulombSectRatioProb.HighestNTracker track = new CoulombSectRatioProb.HighestNTracker(numDenominatorSubsects);
                        for (FaultSection source : currentSects) {
                            track.addValue(aggCalc.calc(source, receiver));
                        }
                        double myProb = track.getSum() / Math.abs(track.getSumHighest());
                        if (myProb < 0.0) {
                            myProb = 0.0;
                        } else if (myProb > 1.0) {
                            myProb = 1.0;
                        }
                        System.out.println("Probability of adding " + receiver.getSectionId() + " with " + currentSects.size() + " sources: " + track.getSum() + "/|" + track.getSumHighest() + "| = " + myProb);
                        prob *= myProb;
                        Color color = favCPT.getColor((float)myProb);
                        RupCartoonGenerator.plotSection(receiver, funcs, chars, new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, color), traceChar);
                        processed.add(receiver);
                        if (myProb > bestReceiverScore) {
                            bestReceiverScore = myProb;
                            bestRecieverFunc = (XY_DataSet)funcs.get(funcs.size() - 1);
                        }
                        for (Object xy3 : RupCartoonGenerator.line(add.fromSect, receiver, true, 1.0, arrowLen)) {
                            funcs.add((XY_DataSet)xy3);
                            chars.add(jumpChar);
                            if (firstEffective) {
                                xy3.setName("Effective Jump");
                            }
                            firstEffective = false;
                        }
                        String str = "R" + specs.size() + "=" + df.format(track.getSum()) + "/|" + df.format(track.getSumHighest()) + "|=" + df.format(myProb);
                        str = str + "; Cumulative P=" + df.format(prob);
                        xy3 = rupBuild.subSectsList.iterator();
                        while (xy3.hasNext()) {
                            FaultSection sect = (FaultSection)xy3.next();
                            if (processed.contains(sect)) continue;
                            RupCartoonGenerator.plotSection(sect, funcs, chars, futureChar, traceChar);
                            lastRecieverFunc = (XY_DataSet)funcs.get(funcs.size() - 1);
                        }
                        PlotSpec spec = new PlotSpec(funcs, chars, null, null, " ");
                        spec.setLegendVisible(true);
                        specs.add(spec);
                        String passStr = (float)prob >= threshold ? "PASS" : "FAIL";
                        titles.add(str);
                    }
                }
                currentSects = nav.getCurrentSects();
                nextAdds = nav.getNextAdditions();
                System.out.println("Have " + nextAdds.size() + " nextAdds");
            } while (!nextAdds.isEmpty());
            int expectedNum = rupBuild.subSectsList.size() - clusters.get((int)n).subSects.size() + 1;
            PlotCurveCharacterstics whiteChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.WHITE);
            bestRecieverFunc.setName("Receiver");
            lastRecieverFunc.setName("Future Section");
            RupCartoonGenerator.plotTileMulti(outputDir, prefix + "_" + n, specs, title, titles, 0.02, 20, 0);
        }
    }

    private static Location loc(double x, double y) {
        Location loc = new Location(0.0, 0.0);
        if (x != 0.0) {
            loc = LocationUtils.location(loc, 1.5707963267948966, x);
        }
        if (y != 0.0) {
            loc = LocationUtils.location(loc, 0.0, y);
        }
        return loc;
    }

    private static SubSectBuilder buildRelativeDemoSystem() {
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        double ssDip = 85.0;
        FaultSection s1 = RupCartoonGenerator.buildSect(parentID++, ssDip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, 0.0), RupCartoonGenerator.loc(120.0, 0.0));
        s1.setAveRake(180.0);
        s1.setAveSlipRate(20.0);
        FaultSection s2 = RupCartoonGenerator.buildSect(parentID++, ssDip, upperDepth, lowerDepth, RupCartoonGenerator.loc(33.0, -1.0), RupCartoonGenerator.loc(80.0, -17.0));
        s2.setAveRake(180.0);
        s2.setAveSlipRate(10.0);
        FaultSection s3 = RupCartoonGenerator.buildSect(parentID++, ssDip, upperDepth, lowerDepth, RupCartoonGenerator.loc(66.0, -11.2), RupCartoonGenerator.loc(70.0, -10.5), RupCartoonGenerator.loc(73.0, -10.0), RupCartoonGenerator.loc(80.0, -3.0), RupCartoonGenerator.loc(90.3, -1.0));
        s3.setAveRake(180.0);
        s3.setAveSlipRate(1.0);
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(s1);
        rupBuild.addFault(s2);
        rupBuild.addFault(s3);
        return rupBuild;
    }

    /*
     * WARNING - void declaration
     */
    private static List<ClusterRupture> getRelProbExampleRups(List<FaultSubsectionCluster> clusters, SectionDistanceAzimuthCalculator distCalc) {
        void var8_16;
        void var7_10;
        ArrayList<PlausibilityFilter> buildFilters = new ArrayList<PlausibilityFilter>();
        buildFilters.add(new StartsWithFitler(clusters.get((int)0).startSect));
        List<ClusterRupture> allRups = new ClusterRuptureBuilder(clusters, buildFilters, 0, distCalc).build(new ConnectionPointsRuptureGrowingStrategy());
        System.out.println("Building relative probability example ruptures");
        ArrayList<ClusterRupture> targetRups = new ArrayList<ClusterRupture>();
        ClusterRupture largeNoJump = null;
        for (ClusterRupture clusterRupture : allRups) {
            if (clusterRupture.getTotalNumJumps() > 0) continue;
            if (largeNoJump == null) {
                largeNoJump = clusterRupture;
                continue;
            }
            if (clusterRupture.getTotalNumSects() <= largeNoJump.getTotalNumSects()) continue;
            largeNoJump = clusterRupture;
        }
        System.out.println("Largest without a jump: " + String.valueOf(largeNoJump));
        targetRups.add(largeNoJump);
        ClusterRupture full2nd = null;
        for (ClusterRupture clusterRupture : allRups) {
            if (clusterRupture.clusters.length != 2 || clusterRupture.clusters[1].parentSectionID != clusters.get((int)1).parentSectionID || clusterRupture.clusters[1].subSects.size() != clusters.get((int)1).subSects.size()) continue;
            if (full2nd == null) {
                full2nd = clusterRupture;
                continue;
            }
            if (clusterRupture.getTotalNumSects() <= full2nd.getTotalNumSects()) continue;
            full2nd = clusterRupture;
        }
        targetRups.add(full2nd);
        System.out.println("Largest full 2nd: " + String.valueOf(full2nd));
        Object var7_9 = null;
        for (ClusterRupture rup : allRups) {
            if (rup.clusters.length != 3 || rup.clusters[1].parentSectionID != clusters.get((int)1).parentSectionID || rup.clusters[2].parentSectionID != clusters.get((int)2).parentSectionID || rup.clusters[2].subSects.size() != clusters.get((int)2).subSects.size()) continue;
            if (var7_10 == null) {
                ClusterRupture clusterRupture = rup;
                continue;
            }
            if (rup.getTotalNumSects() <= var7_10.getTotalNumSects()) continue;
            ClusterRupture clusterRupture = rup;
        }
        targetRups.add((ClusterRupture)var7_10);
        System.out.println("Largest full 3rd: " + String.valueOf(var7_10));
        Object var8_15 = null;
        for (ClusterRupture rup : allRups) {
            if (rup.clusters.length != 4 || rup.clusters[1].parentSectionID != clusters.get((int)1).parentSectionID || rup.clusters[2].parentSectionID != clusters.get((int)2).parentSectionID || rup.clusters[3].parentSectionID != clusters.get((int)0).parentSectionID) continue;
            if (var8_16 == null) {
                ClusterRupture clusterRupture = rup;
                continue;
            }
            if (rup.getTotalNumSects() <= var8_16.getTotalNumSects()) continue;
            ClusterRupture clusterRupture = rup;
        }
        targetRups.add((ClusterRupture)var8_16);
        System.out.println("Largest 3 jump: " + String.valueOf(var8_16));
        return targetRups;
    }

    private static void buildSlipProbDemo(File outputDir) throws IOException {
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        SubSectBuilder rupBuild = RupCartoonGenerator.buildRelativeDemoSystem();
        SectionDistanceAzimuthCalculator distCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, distCalc, 10.0);
        RelativeSlipRateProb relProb = new RelativeSlipRateProb(connStrat, true, true);
        List<ClusterRupture> targetRups = RupCartoonGenerator.getRelProbExampleRups(connStrat.getClusters(), distCalc);
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        String title = "Relative Slip Rate Probability";
        for (int i = 0; i < targetRups.size(); ++i) {
            PlotSpec spec = RupCartoonGenerator.buildRelativeProbDemo(relProb, targetRups.get(i), title, "mm/yr");
            spec.setLegendVisible(i == targetRups.size() - 1);
            specs.add(spec);
        }
        RupCartoonGenerator.plotTileMulti(outputDir, "slip_prob_demo", specs, title, null, 0.02, 22, specs.size() - 1);
    }

    private static void buildCoulombProbDemo(File outputDir) throws IOException {
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        SubSectBuilder rupBuild = RupCartoonGenerator.buildRelativeDemoSystem();
        SubSectStiffnessCalculator stiffCalc = new SubSectStiffnessCalculator(rupBuild.subSectsList, 2.0, 30000.0, 30000.0, 0.5);
        AggregatedStiffnessCalculator aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffCalc, false, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        float favDist = 0.0f;
        SectionDistanceAzimuthCalculator distCalc = new SectionDistanceAzimuthCalculator(rupBuild.subSectsList);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(rupBuild.subSectsList, distCalc, 10.0);
        RelativeCoulombProb relProb = new RelativeCoulombProb(aggCalc, connStrat, false, true, favDist > 0.0f, favDist, distCalc);
        List<ClusterRupture> targetRups = RupCartoonGenerator.getRelProbExampleRups(connStrat.getClusters(), distCalc);
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        String title = "Relative " + SubSectStiffnessCalculator.StiffnessType.CFF.getName() + " Probability";
        for (int i = 0; i < targetRups.size(); ++i) {
            PlotSpec spec = RupCartoonGenerator.buildRelativeProbDemo(relProb, targetRups.get(i), title, SubSectStiffnessCalculator.StiffnessType.CFF.getUnits());
            spec.setLegendVisible(i == targetRups.size() - 1);
            specs.add(spec);
        }
        RupCartoonGenerator.plotTileMulti(outputDir, "cff_prob_demo", specs, title, null, 0.02, 22, specs.size() - 1);
    }

    private static PlotSpec buildRelativeProbDemo(AbstractRelativeProb relProb, ClusterRupture fullRup, String title, String units) throws IOException {
        Object label;
        RelativeProbWrapper wrapper = new RelativeProbWrapper(relProb);
        double fullProb = wrapper.calcRuptureProb(fullRup, true);
        HashSet<FaultSubsectionCluster> skipToClusters = wrapper.getSkipToClusters(fullRup);
        if (skipToClusters != null && !skipToClusters.isEmpty()) {
            wrapper.disableSkip = true;
            wrapper.reset();
            wrapper.calcRuptureProb(fullRup, false);
        } else {
            skipToClusters = new HashSet();
        }
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        PlotCurveCharacterstics rupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
        PlotCurveCharacterstics optionChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
        boolean firstRup = true;
        boolean firstOption = true;
        for (FaultSubsectionCluster faultSubsectionCluster : relProb.getConnStrat().getClusters()) {
            for (Object sect : faultSubsectionCluster.subSects) {
                if (fullRup.contains((FaultSection)sect)) {
                    RupCartoonGenerator.plotSection((FaultSection)sect, funcs, chars, rupChar, traceChar);
                    if (firstRup) {
                        ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Ruptured Section");
                    }
                    firstRup = false;
                    continue;
                }
                RupCartoonGenerator.plotSection((FaultSection)sect, funcs, chars, optionChar, traceChar);
                if (firstOption) {
                    ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Other Section");
                }
                firstOption = false;
            }
        }
        boolean firstJump = true;
        for (Jump jump : fullRup.getJumpsIterable()) {
            for (XY_DataSet xy : RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0, 1.0)) {
                funcs.add(xy);
                chars.add(reg_jump_char);
                if (firstJump) {
                    xy.setName("Jump");
                }
                firstJump = false;
            }
        }
        DataUtils.MinMaxAveTracker minMaxAveTracker = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker yTrack = new DataUtils.MinMaxAveTracker();
        for (XY_DataSet xy : funcs) {
            minMaxAveTracker.addValue(xy.getMaxX());
            minMaxAveTracker.addValue(xy.getMinX());
            yTrack.addValue(xy.getMaxY());
            yTrack.addValue(xy.getMinY());
        }
        double probY = yTrack.getMax() + 0.065;
        DefaultXY_DataSet fakeLine = new DefaultXY_DataSet();
        fakeLine.set(minMaxAveTracker.getMin(), probY);
        fakeLine.set(minMaxAveTracker.getMax(), probY);
        funcs.add(fakeLine);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.WHITE));
        fakeLine = new DefaultXY_DataSet();
        fakeLine.set(minMaxAveTracker.getMin(), yTrack.getMin() - 0.05);
        fakeLine.set(minMaxAveTracker.getMax(), yTrack.getMin() - 0.05);
        funcs.add(fakeLine);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.WHITE));
        DecimalFormat df = new DecimalFormat("0.00");
        Font probFont = new Font("SansSerif", 1, 22);
        Font deferredProbFont = new Font("SansSerif", 2, 22);
        ArrayList<XYTextAnnotation> anns = new ArrayList<XYTextAnnotation>();
        XYTextAnnotation startProbAnn = new XYTextAnnotation("P", minMaxAveTracker.getMin(), probY);
        startProbAnn.setFont(probFont);
        startProbAnn.setTextAnchor(TextAnchor.CENTER_LEFT);
        anns.add(startProbAnn);
        HashSet<FaultSection> jumpFroms = new HashSet<FaultSection>();
        for (int i = 0; wrapper.actualAdditionsList != null && i < wrapper.actualAdditionsList.size(); ++i) {
            PathEvaluator.PathAddition add = wrapper.actualAdditionsList.get(i);
            if (add.fromCluster.parentSectionID == add.toCluster.parentSectionID) continue;
            jumpFroms.add(add.fromSect);
            DataUtils.MinMaxAveTracker addXTrack = new DataUtils.MinMaxAveTracker();
            for (Location loc : add.fromSect.getFaultTrace()) {
                addXTrack.addValue(loc.getLongitude());
            }
            for (Location loc : add.toSects.iterator().next().getFaultTrace()) {
                addXTrack.addValue(loc.getLongitude());
            }
            double x = addXTrack.getMin() + 0.5 * (addXTrack.getMax() - addXTrack.getMin());
            double prevX = ((XYTextAnnotation)anns.get(anns.size() - 1)).getX();
            XYTextAnnotation timesAnn = new XYTextAnnotation(i > 0 ? "x" : "=", 0.5 * (prevX + x), probY);
            timesAnn.setFont(probFont);
            timesAnn.setTextAnchor(TextAnchor.CENTER);
            anns.add(timesAnn);
            label = df.format(wrapper.additionProbs.get(i));
            if (skipToClusters.contains(add.toCluster)) {
                label = "[" + (String)label + "]";
            }
            XYTextAnnotation pAnn = new XYTextAnnotation((String)label, x, probY);
            if (skipToClusters.contains(add.toCluster)) {
                pAnn.setFont(deferredProbFont);
                pAnn.setPaint((Paint)Color.GRAY);
            } else {
                pAnn.setFont(probFont);
            }
            pAnn.setTextAnchor(TextAnchor.CENTER);
            anns.add(pAnn);
        }
        double prevX = ((XYTextAnnotation)anns.get(anns.size() - 1)).getX();
        XYTextAnnotation equalsAnn = new XYTextAnnotation("=", 0.5 * (prevX + minMaxAveTracker.getMax()), probY);
        equalsAnn.setFont(probFont);
        equalsAnn.setTextAnchor(TextAnchor.CENTER);
        anns.add(equalsAnn);
        XYTextAnnotation endProbAnn = new XYTextAnnotation(df.format(fullProb), minMaxAveTracker.getMax(), probY);
        endProbAnn.setFont(probFont);
        endProbAnn.setTextAnchor(TextAnchor.CENTER_RIGHT);
        anns.add(endProbAnn);
        Font branchFont = new Font("SansSerif", 1, 18);
        for (int i = 0; wrapper.availableAdditionsList != null && i < wrapper.availableAdditionsList.size(); ++i) {
            double yPin;
            TextAnchor anchor;
            PathEvaluator.PathAddition add = wrapper.availableAdditionsList.get(i);
            if (!jumpFroms.contains(add.fromSect)) continue;
            FaultSection toSect = add.toSects.iterator().next();
            label = df.format(wrapper.valuesList.get(i)) + " " + units;
            double minX = Double.POSITIVE_INFINITY;
            double yAtMin = 0.0;
            double maxX = Double.NEGATIVE_INFINITY;
            double yAtMax = 0.0;
            for (Location loc : toSect.getFaultTrace()) {
                if (loc.getLongitude() < minX) {
                    minX = loc.getLongitude();
                    yAtMin = loc.getLatitude();
                }
                if (!(loc.getLongitude() > maxX)) continue;
                maxX = loc.getLongitude();
                yAtMax = loc.getLatitude();
            }
            if ((float)yAtMax >= (float)yAtMin) {
                anchor = TextAnchor.BOTTOM_LEFT;
                yPin = yAtMin + 0.005;
            } else {
                anchor = TextAnchor.TOP_LEFT;
                yPin = yAtMin - 0.005;
            }
            XYTextAnnotation ann = new XYTextAnnotation((String)label, minX, yPin);
            ann.setFont(branchFont);
            ann.setTextAnchor(anchor);
            if ((float)yAtMax != (float)yAtMin) {
                double angle = Math.atan((yAtMin - yAtMax) / (maxX - minX));
                ann.setRotationAngle(angle);
                ann.setRotationAnchor(anchor);
            }
            ann.setBackgroundPaint((Paint)new Color(255, 255, 255, 160));
            anns.add(ann);
        }
        PlotSpec spec = new PlotSpec(funcs, chars, title, null, " ");
        spec.setLegendVisible(true);
        spec.setPlotAnnotations(anns);
        return spec;
    }

    private static void buildNoIndirectExamples(File outputDir) throws IOException {
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        double dip = 88.0;
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, 0.0), RupCartoonGenerator.loc(22.0, 0.0)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(23.0, 0.0), RupCartoonGenerator.loc(44.0, 0.0)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(18.0, 0.0), RupCartoonGenerator.loc(28.0, 4.0)));
        List<FaultSection> subSects = rupBuild.subSectsList;
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(subSects, distAzCalc, 10.0);
        List<FaultSubsectionCluster> clusters = connStrat.getClusters();
        ArrayList<PlausibilityFilter> buildFilters = new ArrayList<PlausibilityFilter>();
        buildFilters.add(new StartsWithFitler(clusters.get((int)0).startSect));
        List<ClusterRupture> allRups = new ClusterRuptureBuilder(clusters, buildFilters, 0, distAzCalc).build(new ConnectionPointsRuptureGrowingStrategy());
        ArrayList<ClusterRupture> plotRups = new ArrayList<ClusterRupture>();
        ArrayList<int[]> parentSets = new ArrayList<int[]>();
        parentSets.add(new int[]{clusters.get((int)0).parentSectionID, clusters.get((int)1).parentSectionID});
        parentSets.add(new int[]{clusters.get((int)0).parentSectionID, clusters.get((int)2).parentSectionID});
        parentSets.add(new int[]{clusters.get((int)0).parentSectionID, clusters.get((int)2).parentSectionID, clusters.get((int)1).parentSectionID});
        for (int[] parentSet : parentSets) {
            ClusterRupture match = null;
            for (ClusterRupture rup : allRups) {
                if (rup.clusters.length != parentSet.length) continue;
                boolean sameParents = true;
                for (int i = 0; i < parentSet.length; ++i) {
                    if (rup.clusters[i].parentSectionID == parentSet[i]) continue;
                    sameParents = false;
                }
                if (!sameParents || match != null && rup.getTotalNumSects() <= match.getTotalNumSects()) continue;
                match = rup;
            }
            Preconditions.checkNotNull(match, (String)"No match found for parents: %s", (Object)Joiner.on((String)",").join((Iterable)Ints.asList((int[])parentSet)));
            plotRups.add(match);
        }
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        DirectPathPlausibilityFilter filter = new DirectPathPlausibilityFilter(connStrat, false);
        PlotCurveCharacterstics rupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
        PlotCurveCharacterstics otherChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
        String title = "No Indirect Connections";
        ArrayList<String> titles = new ArrayList<String>();
        for (int i = 0; i < plotRups.size(); ++i) {
            Object xy3;
            Object sect2;
            ClusterRupture rup = (ClusterRupture)plotRups.get(i);
            boolean passes = filter.apply(rup, true).isPass();
            String label = "Rupture " + (i + 1) + ": ";
            label = passes ? label + "PASS" : label + "FAIL";
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            boolean firstRup = true;
            for (FaultSubsectionCluster faultSubsectionCluster : rup.getClustersIterable()) {
                for (Object sect2 : faultSubsectionCluster.subSects) {
                    RupCartoonGenerator.plotSection((FaultSection)sect2, funcs, chars, rupChar, traceChar);
                    if (firstRup) {
                        ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Ruptured Section");
                    }
                    firstRup = false;
                }
            }
            boolean firstJump = true;
            for (Jump jump : rup.getJumpsIterable()) {
                sect2 = RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0, 0.5).iterator();
                while (sect2.hasNext()) {
                    XY_DataSet xy2 = (XY_DataSet)sect2.next();
                    funcs.add(xy2);
                    chars.add(reg_jump_char);
                    if (firstJump) {
                        xy2.setName("Jump");
                    }
                    firstJump = false;
                }
            }
            for (Object xy3 : funcs) {
                if (xy3.getName() == null || !xy3.getName().contains("Sect")) continue;
                xy3.setName("Ruptured Section");
            }
            boolean bl = true;
            xy3 = subSects.iterator();
            while (xy3.hasNext()) {
                boolean bl2;
                sect2 = (FaultSection)xy3.next();
                if (rup.contains((FaultSection)sect2)) continue;
                RupCartoonGenerator.plotSection((FaultSection)sect2, funcs, chars, otherChar, traceChar);
                if (bl2) {
                    ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Other Section");
                }
                bl2 = false;
            }
            PlotSpec spec = new PlotSpec(funcs, chars, title, null, " ");
            spec.setLegendVisible(i == 0);
            specs.add(spec);
            titles.add(label);
        }
        RupCartoonGenerator.plotTileMulti(outputDir, "indirect_demo", specs, title, titles, 0.02, 22, 0);
    }

    private static void buildCoulombInteractionDemo(File outputDir) throws IOException {
        double y2;
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        double dip = 88.0;
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        double x1 = 75.0;
        double x2 = x1 + 15.0;
        double y0 = 0.0;
        double y1 = -10.0;
        double y3 = y2 = -20.0;
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, y0), RupCartoonGenerator.loc(0.98 * x1, 0.0)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(x1, 0.0), RupCartoonGenerator.loc(x1 + 0.33 * (x2 - x1), 0.15 * y1), RupCartoonGenerator.loc(x1 + 0.67 * (x2 - x1), 0.5 * y1), RupCartoonGenerator.loc(0.95 * x2, 0.9 * y1)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.95 * x2, 1.1 * y1), RupCartoonGenerator.loc(x1 + 0.67 * (x2 - x1), y1 + 0.5 * (y2 - y1)), RupCartoonGenerator.loc(x1 + 0.33 * (x2 - x1), y1 + 0.85 * (y2 - y1)), RupCartoonGenerator.loc(x1, y2)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.98 * x1, y2), RupCartoonGenerator.loc(0.0, y3)));
        List<FaultSection> subSects = rupBuild.subSectsList;
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(subSects, distAzCalc, 10.0);
        List<FaultSubsectionCluster> clusters = connStrat.getClusters();
        SubSectStiffnessCalculator stiffCalc = new SubSectStiffnessCalculator(rupBuild.subSectsList, 2.0, 30000.0, 30000.0, 0.5, SubSectStiffnessCalculator.PatchAlignment.CENTER, 1.0);
        AggregatedStiffnessCalculator aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffCalc, false, AggregatedStiffnessCalculator.AggregationMethod.NUM_POSITIVE, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.NORM_BY_COUNT);
        ArrayList<PlausibilityFilter> buildFilters = new ArrayList<PlausibilityFilter>();
        buildFilters.add(new StartsWithFitler(clusters.get((int)0).startSect));
        List<ClusterRupture> allRups = new ClusterRuptureBuilder(clusters, buildFilters, 0, distAzCalc).build(new ConnectionPointsRuptureGrowingStrategy());
        ArrayList<ClusterRupture> plotRups = new ArrayList<ClusterRupture>();
        for (int i = 1; i < clusters.size(); ++i) {
            ClusterRupture match = null;
            for (ClusterRupture rup : allRups) {
                if (rup.clusters.length != i + 1) continue;
                boolean inOrder = true;
                for (int c = 0; c <= i; ++c) {
                    if (rup.clusters[c].parentSectionID == clusters.get((int)c).parentSectionID) continue;
                    inOrder = false;
                }
                if (!inOrder || match != null && rup.getTotalNumSects() <= match.getTotalNumSects()) continue;
                match = rup;
            }
            Preconditions.checkNotNull(match);
            plotRups.add(match);
        }
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        PlotCurveCharacterstics rupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
        PlotCurveCharacterstics otherChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.LIGHT_GRAY);
        PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
        PlotCurveCharacterstics posChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, new Color(255, 0, 0, 5));
        PlotCurveCharacterstics negChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, new Color(0, 0, 255, 5));
        String title = "Fraction of " + SubSectStiffnessCalculator.StiffnessType.CFF.getName() + " Interactions Positive";
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormat ndf = new DecimalFormat("0");
        ndf.setGroupingSize(3);
        ndf.setGroupingUsed(true);
        ArrayList<String> titles = new ArrayList<String>();
        for (int i = 0; i < plotRups.size(); ++i) {
            ClusterRupture rup = (ClusterRupture)plotRups.get(i);
            ArrayList<FaultSection> rupSects = new ArrayList<FaultSection>();
            for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                rupSects.addAll((Collection<FaultSection>)cluster.subSects);
            }
            long numInts = 0L;
            HashMap<SubSectStiffnessCalculator.PatchLocation, List<XY_DataSet>> negFuncs = new HashMap<SubSectStiffnessCalculator.PatchLocation, List<XY_DataSet>>();
            HashMap<SubSectStiffnessCalculator.PatchLocation, List<XY_DataSet>> posFuncs = new HashMap<SubSectStiffnessCalculator.PatchLocation, List<XY_DataSet>>();
            for (FaultSection faultSection : rupSects) {
                for (FaultSection faultSection2 : rupSects) {
                    SubSectStiffnessCalculator.StiffnessDistribution dist = stiffCalc.calcStiffnessDistribution(faultSection, faultSection2);
                    List<SubSectStiffnessCalculator.PatchLocation> sPatches = dist.sourcePatches;
                    List<SubSectStiffnessCalculator.PatchLocation> rPatches = dist.receiverPatches;
                    double[][] values = dist.get(aggCalc.getType());
                    for (int r = 0; r < values.length; ++r) {
                        SubSectStiffnessCalculator.PatchLocation patchLocation = rPatches.get(r);
                        for (int s = 0; s < values[r].length; ++s) {
                            if (faultSection == faultSection2 && s == r) continue;
                            SubSectStiffnessCalculator.PatchLocation sPatch = sPatches.get(s);
                            ++numInts;
                            if (values[r][s] >= 0.0) {
                                RupCartoonGenerator.bundleAddInteraction(posFuncs, sPatch, patchLocation);
                                continue;
                            }
                            RupCartoonGenerator.bundleAddInteraction(negFuncs, sPatch, patchLocation);
                        }
                    }
                }
            }
            System.out.println("have " + numInts + " interactions for " + String.valueOf(rup));
            ArrayList<Object[]> funcCharPairs = new ArrayList<Object[]>();
            for (SubSectStiffnessCalculator.PatchLocation patch : posFuncs.keySet()) {
                for (XY_DataSet xy : (List)posFuncs.get(patch)) {
                    funcCharPairs.add(new Object[]{xy, posChar});
                }
            }
            for (SubSectStiffnessCalculator.PatchLocation patch : negFuncs.keySet()) {
                for (XY_DataSet xy : (List)negFuncs.get(patch)) {
                    funcCharPairs.add(new Object[]{xy, negChar});
                }
            }
            System.out.println("combined down to " + funcCharPairs.size() + " functions");
            Collections.shuffle(funcCharPairs, new Random(funcCharPairs.size()));
            double d = aggCalc.calc(rupSects, rupSects);
            long l = (long)(d * (double)numInts);
            String label = "Rupture " + (i + 1) + ": " + ndf.format(l) + "/" + ndf.format(numInts) + " = " + df.format(d);
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>(funcCharPairs.size());
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>(funcCharPairs.size());
            for (Object[] objectArray : funcCharPairs) {
                funcs.add((XY_DataSet)objectArray[0]);
                chars.add((PlotCurveCharacterstics)objectArray[1]);
            }
            boolean firstRup = true;
            for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                for (FaultSection sect : cluster.subSects) {
                    RupCartoonGenerator.plotSection(sect, funcs, chars, rupChar, traceChar);
                    if (firstRup) {
                        ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Ruptured Section");
                    }
                    firstRup = false;
                }
            }
            for (XY_DataSet xy : funcs) {
                if (xy.getName() == null || !xy.getName().contains("Sect")) continue;
                xy.setName("Ruptured Section");
            }
            boolean bl = true;
            for (FaultSection sect : subSects) {
                boolean bl2;
                if (rup.contains(sect)) continue;
                RupCartoonGenerator.plotSection(sect, funcs, chars, otherChar, traceChar);
                if (bl2) {
                    ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Other Section");
                }
                bl2 = false;
            }
            PlotSpec spec = new PlotSpec(funcs, chars, title, null, " ");
            spec.setLegendVisible(i == 0);
            specs.add(spec);
            titles.add(label);
        }
        RupCartoonGenerator.plotTileMulti(outputDir, "cff_interact_demo", specs, title, titles, 0.04, 22, 0);
    }

    private static void bundleAddInteraction(Map<SubSectStiffnessCalculator.PatchLocation, List<XY_DataSet>> prevXYs, SubSectStiffnessCalculator.PatchLocation p1, SubSectStiffnessCalculator.PatchLocation p2) {
        List<XY_DataSet> prevs = prevXYs.get(p1);
        if (prevs != null && !prevs.isEmpty()) {
            XY_DataSet newXY = prevs.remove(prevs.size() - 1);
            newXY.set(p2.center.getLongitude(), p2.center.getLatitude());
            List<XY_DataSet> news = prevXYs.get(p2);
            if (news == null) {
                news = new ArrayList<XY_DataSet>();
                prevXYs.put(p2, news);
            }
            news.add(newXY);
            return;
        }
        prevs = prevXYs.get(p2);
        if (prevs != null && !prevs.isEmpty()) {
            XY_DataSet newXY = prevs.remove(prevs.size() - 1);
            newXY.set(p1.center.getLongitude(), p1.center.getLatitude());
            List<XY_DataSet> news = prevXYs.get(p1);
            if (news == null) {
                news = new ArrayList<XY_DataSet>();
                prevXYs.put(p1, news);
            }
            news.add(newXY);
            return;
        }
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        xy.set(p1.center.getLongitude(), p1.center.getLatitude());
        xy.set(p2.center.getLongitude(), p2.center.getLatitude());
        List<XY_DataSet> news = prevXYs.get(p2);
        if (news == null) {
            news = new ArrayList<XY_DataSet>();
            prevXYs.put(p2, news);
        }
        news.add(xy);
    }

    private static void buildCumulativeAzimuthDemo(File outputDir) throws IOException {
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double upperDepth = 0.0;
        double lowerDepth = 10.0;
        double fractDDW = 0.5;
        int parentID = 1001;
        double dip = 85.0;
        SubSectBuilder rupBuild = new SubSectBuilder(fractDDW);
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, 0.0), RupCartoonGenerator.loc(50.0, 0.0)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(45.0, 5.0), RupCartoonGenerator.loc(100.0, 5.0)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(50.0, 5.0), RupCartoonGenerator.loc(100.0, 5.0)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(0.0, 0.0), RupCartoonGenerator.loc(70.0, 0.0)));
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, RupCartoonGenerator.loc(55.0, 0.0), RupCartoonGenerator.loc(100.0, 10.0)));
        int numPoints = 11;
        double deltaX = 10.0;
        Location[] locs = new Location[numPoints];
        Random r = new Random(numPoints * 3);
        for (int i = 0; i < numPoints; ++i) {
            double x = deltaX * (double)i;
            double y = 0.0;
            if (i > 0 && i < numPoints - 1) {
                x += deltaX * 0.5 * (r.nextDouble() - 0.5);
                y += deltaX * 0.5 * (r.nextDouble() - 0.25);
            }
            locs[i] = RupCartoonGenerator.loc(x, y += 0.5);
        }
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, locs));
        ArrayList<Location> simpleLocsList = new ArrayList<Location>();
        for (int i = 0; i < numPoints; ++i) {
            if (i != 0 && i % 2 != 1 && i != numPoints - 1) continue;
            simpleLocsList.add(locs[i]);
        }
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, simpleLocsList.toArray(new Location[0])));
        ArrayList<Location> complicatedLocsList = new ArrayList<Location>();
        double compMult = 0.02;
        for (int i = 0; i < numPoints; ++i) {
            if (i > 0) {
                double lat = 0.5 * (locs[i - 1].getLatitude() + locs[i].getLatitude());
                double lon = 0.5 * (locs[i - 1].getLongitude() + locs[i].getLongitude());
                complicatedLocsList.add(new Location(lat += compMult * (r.nextDouble() - 0.5), lon += compMult * (r.nextDouble() - 0.5)));
            }
            complicatedLocsList.add(locs[i]);
        }
        rupBuild.addFault(RupCartoonGenerator.buildSect(parentID++, dip, upperDepth, lowerDepth, complicatedLocsList.toArray(new Location[0])));
        List<FaultSection> subSects = rupBuild.subSectsList;
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        CumulativeAzimuthChangeFilter filter = new CumulativeAzimuthChangeFilter(new JumpAzimuthChangeFilter.SimpleAzimuthCalc(distAzCalc), 560.0f);
        List<FaultSubsectionCluster> clusters = new PlausibleClusterConnectionStrategy(subSects, distAzCalc, 20.0, (PlausibleClusterConnectionStrategy.JumpSelector)new PlausibleClusterConnectionStrategy.OnlyEndsJumpSelector(true), new JumpDistFilter(20.0)).getClusters();
        FaultSubsectionCluster cluster1 = clusters.get(0);
        FaultSubsectionCluster cluster2 = clusters.get(1);
        FaultSubsectionCluster cluster3 = clusters.get(2);
        FaultSubsectionCluster cluster4 = clusters.get(3);
        FaultSubsectionCluster cluster5 = clusters.get(4);
        FaultSubsectionCluster cluster6 = clusters.get(5);
        FaultSubsectionCluster cluster7 = clusters.get(6);
        FaultSubsectionCluster cluster8 = clusters.get(7);
        ArrayList<ClusterRupture> rups = new ArrayList<ClusterRupture>();
        rups.add(new ClusterRupture(cluster1).take(cluster1.getConnectionsTo(cluster5).iterator().next()));
        rups.add(new ClusterRupture(cluster1).take(cluster1.getConnectionsTo(cluster3).iterator().next()));
        rups.add(new ClusterRupture(cluster1).take(cluster1.getConnectionsTo(cluster2).iterator().next()));
        rups.add(new ClusterRupture(cluster7));
        rups.add(new ClusterRupture(cluster6));
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        ArrayList<String> labels = new ArrayList<String>();
        for (ClusterRupture rup : rups) {
            Object sect2;
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            PlotCurveCharacterstics rupChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK);
            PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
            PlotCurveCharacterstics azChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN.darker());
            PlotCurveCharacterstics azMidPointChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLUE.darker());
            boolean firstSect = true;
            for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                for (Object sect2 : cluster.subSects) {
                    RupCartoonGenerator.plotSection((FaultSection)sect2, funcs, chars, rupChar, traceChar);
                    if (firstSect) {
                        ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Ruptured Section");
                    }
                    firstSect = false;
                }
            }
            ArrayList<Double> changes = new ArrayList<Double>();
            DefaultXY_DataSet midPoints = new DefaultXY_DataSet();
            midPoints.setName("Section Midpoint");
            RupCartoonGenerator.addAzArrowsRecursive(rup.getTreeNavigator(), rup.clusters[0].startSect, null, funcs, chars, azChar, midPoints, distAzCalc, 3.0, changes);
            ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Azimuth");
            funcs.add(midPoints);
            chars.add(azMidPointChar);
            boolean firstJump = true;
            sect2 = rup.getJumpsIterable().iterator();
            while (sect2.hasNext()) {
                Jump jump = (Jump)sect2.next();
                for (XY_DataSet xy : RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0, 1.0)) {
                    funcs.add(xy);
                    chars.add(reg_jump_char);
                    if (firstJump) {
                        xy.setName("Jump");
                    }
                    firstJump = false;
                }
            }
            PlotSpec spec = new PlotSpec(funcs, chars, null, " ", " ");
            spec.setLegendVisible(specs.isEmpty());
            specs.add(spec);
            Object label = null;
            if (changes.isEmpty()) {
                label = "";
            } else {
                double total = 0.0;
                int intTotal = 0;
                ArrayList<Integer> intChanges = new ArrayList<Integer>();
                for (Double change : changes) {
                    int chInt = (int)(change + 0.5);
                    total += change.doubleValue();
                    intChanges.add(chInt);
                    intTotal += chInt;
                }
                while (intTotal != (int)(total + 0.5)) {
                    System.out.println("Fixing rounding drift with total=" + (float)total + "~=" + (int)(total + 0.5) + " and intTotal=" + intTotal);
                    boolean higher = intTotal > (int)(total + 0.5);
                    int changeIndex = -1;
                    double minChangeDelta = 0.0;
                    for (int i = 0; i < intChanges.size(); ++i) {
                        double delta;
                        int intVal = (Integer)intChanges.get(i);
                        double val = (Double)changes.get(i);
                        if (higher && (double)intVal > val && intVal > 0) {
                            delta = (double)intVal - val;
                            if (!(delta > minChangeDelta)) continue;
                            minChangeDelta = delta;
                            changeIndex = i;
                            continue;
                        }
                        if (higher || !((double)intVal < val) || !((delta = val - (double)intVal) > minChangeDelta)) continue;
                        minChangeDelta = delta;
                        changeIndex = i;
                    }
                    Preconditions.checkState((changeIndex >= 0 ? 1 : 0) != 0, (Object)"Change index not found");
                    int changeInt = (Integer)intChanges.get(changeIndex);
                    int newChangeInt = higher ? changeInt - 1 : changeInt + 1;
                    System.out.println("\tChanging value at " + changeIndex + " from " + changeInt + " to " + newChangeInt + " with val=" + ((Double)changes.get(changeIndex)).floatValue());
                    intChanges.set(changeIndex, newChangeInt);
                    intTotal += newChangeInt - changeInt;
                }
                intTotal = 0;
                Iterator iterator = intChanges.iterator();
                while (iterator.hasNext()) {
                    int chInt = (Integer)iterator.next();
                    if (chInt == 0) continue;
                    label = label == null ? "" : (String)label + "+";
                    intTotal += chInt;
                    label = (String)label + chInt;
                }
                System.out.println("Calculated total=" + total + ", intTotal=" + intTotal);
                label = (String)label + "=";
            }
            labels.add("Rupture " + specs.size() + ": " + (String)label + (int)(filter.getValue(rup).floatValue() + 0.5f) + "\u00b0");
        }
        RupCartoonGenerator.plotTileMulti(outputDir, "cumulative_azimuth", specs, "Cumulative Azimuth Change", labels, 0.025, 18, 1);
    }

    private static void addAzArrowsRecursive(RuptureTreeNavigator nav, FaultSection curSect, Double prevAz, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, PlotCurveCharacterstics azChar, XY_DataSet midPoints, SectionDistanceAzimuthCalculator distAzCalc, double arrowLen, List<Double> changes) {
        for (FaultSection descendant : nav.getDescendants(curSect)) {
            double azimuth = distAzCalc.getAzimuth(curSect, descendant);
            if (prevAz != null && Math.abs(prevAz - azimuth) > 1.0E-4 || descendant.getParentSectionId() != curSect.getParentSectionId()) {
                Location center1 = GriddedSurfaceUtils.getSurfaceMiddleLoc(nav.getPredecessor(curSect).getFaultSurface(1.0, false, false));
                Location center2 = GriddedSurfaceUtils.getSurfaceMiddleLoc(curSect.getFaultSurface(1.0, false, false));
                Location center3 = GriddedSurfaceUtils.getSurfaceMiddleLoc(descendant.getFaultSurface(1.0, false, false));
                midPoints.set(center1.getLongitude(), center1.getLatitude());
                midPoints.set(center2.getLongitude(), center2.getLatitude());
                midPoints.set(center3.getLongitude(), center3.getLatitude());
                for (XY_DataSet xy : RupCartoonGenerator.line(nav.getPredecessor(curSect), curSect, true, 2.0, arrowLen)) {
                    funcs.add(xy);
                    chars.add(azChar);
                }
                for (XY_DataSet xy : RupCartoonGenerator.line(curSect, descendant, true, 2.0, arrowLen)) {
                    funcs.add(xy);
                    chars.add(azChar);
                }
                double change = Math.abs(prevAz - azimuth);
                if (change >= 0.5) {
                    changes.add(change);
                }
            }
            RupCartoonGenerator.addAzArrowsRecursive(nav, descendant, azimuth, funcs, chars, azChar, midPoints, distAzCalc, arrowLen, changes);
        }
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File mainDir = new File("/tmp/cartoons");
        write_pdfs = true;
        Preconditions.checkState((mainDir.exists() || mainDir.mkdir() ? 1 : 0) != 0);
        File rupDocsDir = new File(mainDir, "doc");
        File stratDocsDir = new File(mainDir, "strategies/doc");
        Preconditions.checkState((stratDocsDir.getParentFile().exists() || stratDocsDir.getParentFile().mkdir() ? 1 : 0) != 0);
        File plausiblityDocsDir = new File(mainDir, "plausibility/doc");
        Preconditions.checkState((plausiblityDocsDir.getParentFile().exists() || plausiblityDocsDir.getParentFile().mkdir() ? 1 : 0) != 0);
        RupCartoonGenerator.buildConnStratDemo(stratDocsDir);
        RupCartoonGenerator.buildPermStratDemos(stratDocsDir);
        RupCartoonGenerator.buildPermStratBilateralDemos(stratDocsDir);
        RupCartoonGenerator.buildPathCoulombDemos(plausiblityDocsDir);
        RupCartoonGenerator.buildSlipProbDemo(plausiblityDocsDir);
        RupCartoonGenerator.buildCoulombProbDemo(plausiblityDocsDir);
        RupCartoonGenerator.buildNoIndirectExamples(plausiblityDocsDir);
        RupCartoonGenerator.buildCoulombInteractionDemo(plausiblityDocsDir);
        RupCartoonGenerator.buildCumulativeAzimuthDemo(plausiblityDocsDir);
    }

    public static interface SectionCharacteristicsFunction {
        public List<PlotCurveCharacterstics> getChars(FaultSection var1, PlotCurveCharacterstics var2, PlotCurveCharacterstics var3);
    }

    private static class RupturePlotBuilder {
        private boolean[] firstSects = null;
        private boolean firstStrandJump = true;
        private boolean firstSplayJump = true;
        private boolean firstAz = true;
        private List<XY_DataSet> sectFuncs;
        private List<PlotCurveCharacterstics> sectChars;
        private List<XY_DataSet> arrowFuncs;
        private List<PlotCurveCharacterstics> arrowChars;
        private boolean plotAzimuths;
        private Set<? extends FaultSection> highlightSects;
        private Color highlightColor;
        private String highlightName;
        private boolean firstHighlight = true;

        public RupturePlotBuilder(boolean plotAzimuths) {
            this.plotAzimuths = plotAzimuths;
            this.sectFuncs = new ArrayList<XY_DataSet>();
            this.sectChars = new ArrayList<PlotCurveCharacterstics>();
            this.arrowFuncs = new ArrayList<XY_DataSet>();
            this.arrowChars = new ArrayList<PlotCurveCharacterstics>();
            this.firstSects = new boolean[strand_colors.length];
            for (int i = 0; i < this.firstSects.length; ++i) {
                this.firstSects[i] = true;
            }
        }

        public void setHighlightSects(Set<? extends FaultSection> highlightSects, Color highlightColor, String highlightName) {
            this.highlightSects = highlightSects;
            this.highlightColor = highlightColor;
            this.highlightName = highlightName;
        }

        public void plotRecursive(ClusterRupture rup) {
            this.plotRecursive(rup, 0);
        }

        public void plotRecursive(ClusterRupture rup, int strandIndex) {
            if (strandIndex >= strand_colors.length) {
                strandIndex = strand_colors.length - 1;
            }
            Color strandColor = strand_colors[strandIndex];
            PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, strandColor);
            PlotCurveCharacterstics outlineChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
            for (int i = 0; i < rup.clusters.length; ++i) {
                for (FaultSection sect : rup.clusters[i].subSects) {
                    Object name;
                    if (this.highlightSects != null && this.highlightSects.contains(sect)) {
                        PlotCurveCharacterstics hTraceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, this.highlightColor);
                        RupCartoonGenerator.plotSection(sect, this.sectFuncs, this.sectChars, hTraceChar, outlineChar);
                        if (!this.firstHighlight) continue;
                        this.firstHighlight = false;
                        this.sectFuncs.get(this.sectFuncs.size() - 1).setName(this.highlightName);
                        continue;
                    }
                    RupCartoonGenerator.plotSection(sect, this.sectFuncs, this.sectChars, traceChar, outlineChar);
                    if (!this.firstSects[strandIndex]) continue;
                    this.firstSects[strandIndex] = false;
                    if (strandIndex == 0) {
                        name = "Primary Strand";
                    } else {
                        name = "Splay Strand";
                        if (strandIndex > 1) {
                            name = (String)name + " (L" + strandIndex;
                            if (strandIndex == strand_colors.length - 1) {
                                name = (String)name + "+";
                            }
                            name = (String)name + ")";
                        }
                    }
                    this.sectFuncs.get(this.sectFuncs.size() - 1).setName((String)name);
                }
            }
            for (Jump jump : rup.internalJumps) {
                List<XY_DataSet> lines = RupCartoonGenerator.line(jump.fromSection, jump.toSection, true, 1.0);
                if (this.firstStrandJump) {
                    lines.get(0).setName("Regular Jump");
                }
                this.firstStrandJump = false;
                for (XY_DataSet line : lines) {
                    this.arrowFuncs.add(line);
                    this.arrowChars.add(reg_jump_char);
                }
                if (!this.plotAzimuths) continue;
                this.addAzimuths(rup, jump);
            }
            for (Jump splayJump : rup.splays.keySet()) {
                ClusterRupture splay = (ClusterRupture)rup.splays.get((Object)splayJump);
                List<XY_DataSet> lines = RupCartoonGenerator.line(splayJump.fromSection, splayJump.toSection, true, 1.0);
                if (this.firstSplayJump) {
                    lines.get(0).setName("Splay Jump");
                }
                this.firstSplayJump = false;
                for (XY_DataSet line : lines) {
                    this.arrowFuncs.add(line);
                    this.arrowChars.add(splay_jump_char);
                }
                if (this.plotAzimuths) {
                    this.addAzimuths(rup, splayJump);
                }
                this.plotRecursive(splay, strandIndex + 1);
            }
        }

        private void addAzimuths(ClusterRupture rup, Jump jump) {
            RuptureTreeNavigator navigator = rup.getTreeNavigator();
            FaultSection before = navigator.getPredecessor(jump.fromSection);
            if (before != null) {
                this.addAzimuth(before, jump.fromSection, az_arrow_char);
            }
            for (FaultSection after : navigator.getDescendants(jump.toSection)) {
                this.addAzimuth(jump.toSection, after, az_arrow_char);
            }
        }

        private void addAzimuth(FaultSection from, FaultSection to, PlotCurveCharacterstics azChar) {
            List<XY_DataSet> xys = RupCartoonGenerator.line(from, to, true, 2.5);
            if (this.firstAz) {
                xys.get(0).setName("Azimuth");
            }
            this.firstAz = false;
            for (XY_DataSet xy : xys) {
                this.arrowFuncs.add(xy);
                this.arrowChars.add(azChar);
            }
        }
    }

    private static class SubSectBuilder {
        private double fractDDW;
        private List<FaultSection> subSectsList;

        public SubSectBuilder(double fractDDW) {
            this.fractDDW = fractDDW;
            this.subSectsList = new ArrayList<FaultSection>();
        }

        public void addFault(FaultSection parent) {
            double width = parent.getOrigDownDipWidth();
            this.subSectsList.addAll(parent.getSubSectionsList(this.fractDDW * width, this.subSectsList.size(), 2));
        }
    }

    private static class TrackAllDebugCriteria
    implements ClusterRuptureBuilder.RupDebugCriteria {
        private List<ClusterRupture> allRups = new ArrayList<ClusterRupture>();

        private TrackAllDebugCriteria() {
        }

        @Override
        public boolean isMatch(ClusterRupture rup) {
            this.allRups.add(rup);
            return false;
        }

        @Override
        public boolean isMatch(ClusterRupture rup, Jump newJump) {
            this.allRups.add(rup.take(newJump));
            return false;
        }

        @Override
        public boolean appliesTo(PlausibilityResult result) {
            return true;
        }
    }

    private static class StartsWithFitler
    implements PlausibilityFilter {
        private FaultSection[] firstSects;

        public StartsWithFitler(FaultSection ... firstSects) {
            this.firstSects = firstSects;
        }

        @Override
        public String getShortName() {
            return "Starts With";
        }

        @Override
        public String getName() {
            return "Starts With";
        }

        @Override
        public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
            for (FaultSection firstSect : this.firstSects) {
                if (!rupture.clusters[0].startSect.equals(firstSect)) continue;
                return PlausibilityResult.PASS;
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
    }

    private static class RelativeProbWrapper
    extends AbstractRelativeProb {
        private AbstractRelativeProb relProb;
        private ClusterRupture curRup;
        private List<Collection<? extends FaultSection>> currentSectsList;
        private List<PathEvaluator.PathAddition> availableAdditionsList;
        private List<Double> valuesList;
        private List<PathEvaluator.PathAddition> actualAdditionsList;
        private List<Double> additionProbs;
        private boolean disableSkip = false;

        public RelativeProbWrapper(AbstractRelativeProb relProb) {
            super(relProb.getConnStrat(), relProb.isAllowNegative(), relProb.isRelativeToBest(), true);
            this.relProb = relProb;
        }

        @Override
        public PathEvaluator.PathNavigator getPathNav(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster) {
            return this.relProb.getPathNav(rupture, nucleationCluster);
        }

        @Override
        public HashSet<FaultSubsectionCluster> getSkipToClusters(ClusterRupture rupture) {
            if (this.disableSkip) {
                return null;
            }
            return this.relProb.getSkipToClusters(rupture);
        }

        @Override
        public PathEvaluator.PathAddition targetJumpToAddition(Collection<? extends FaultSection> curSects, PathEvaluator.PathAddition testAddition, Jump alternateJump) {
            return this.relProb.targetJumpToAddition(curSects, testAddition, alternateJump);
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return this.relProb.isDirectional(splayed);
        }

        @Override
        public String getName() {
            return this.relProb.getName();
        }

        private void reset() {
            this.currentSectsList = new ArrayList<Collection<? extends FaultSection>>();
            this.availableAdditionsList = new ArrayList<PathEvaluator.PathAddition>();
            this.valuesList = new ArrayList<Double>();
            this.actualAdditionsList = new ArrayList<PathEvaluator.PathAddition>();
            this.additionProbs = new ArrayList<Double>();
        }

        @Override
        public double calcAdditionValue(ClusterRupture fullRupture, Collection<? extends FaultSection> currentSects, PathEvaluator.PathAddition addition) {
            if (fullRupture != this.curRup) {
                System.out.println("Tracking additions for a new rupture: " + String.valueOf(fullRupture));
                this.curRup = fullRupture;
                this.reset();
            }
            double value = this.relProb.calcAdditionValue(fullRupture, currentSects, addition);
            this.currentSectsList.add(new ArrayList<FaultSection>(currentSects));
            this.availableAdditionsList.add(addition);
            this.valuesList.add(value);
            return value;
        }

        @Override
        protected double calcAdditionProb(ClusterRupture rupture, List<FaultSection> curSects, PathEvaluator.PathAddition add, boolean verbose) {
            if (rupture != this.curRup) {
                System.out.println("Tracking additions for a new rupture: " + String.valueOf(rupture));
                this.curRup = rupture;
                this.reset();
            }
            double prob = super.calcAdditionProb(rupture, curSects, add, verbose);
            System.out.println("**********ADD " + String.valueOf(add) + "+: " + prob);
            this.actualAdditionsList.add(add);
            this.additionProbs.add(prob);
            return prob;
        }

        @Override
        public boolean isAddFullClusters() {
            return this.relProb.isAddFullClusters();
        }
    }
}

