/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class SectionDistanceAzimuthCalculator
implements OpenSHA_Module {
    private List<? extends FaultSection> subSects;
    private double[][] distCache;
    private double[][] azCache;
    private ConcurrentMap<Integer, RuptureSurface> sectSurfs;
    public static final double SURF_DISCRETIZATION_DEFAULT = 1.0;
    private double surfDiscretization = 1.0;
    private static boolean CREEP_REDUCED = false;

    public SectionDistanceAzimuthCalculator(List<? extends FaultSection> subSects) {
        this.subSects = ImmutableList.copyOf(subSects);
        this.sectSurfs = new ConcurrentHashMap<Integer, RuptureSurface>();
        this.distCache = new double[subSects.size()][];
        this.azCache = new double[subSects.size()][];
    }

    public void setDiscretization(double surfDicretization) {
        this.sectSurfs.clear();
        this.surfDiscretization = surfDicretization;
    }

    private RuptureSurface getSurface(int id) {
        RuptureSurface surf = (RuptureSurface)this.sectSurfs.get(id);
        if (surf == null) {
            FaultSection sect = this.subSects.get(id);
            Preconditions.checkState((id == sect.getSectionId() ? 1 : 0) != 0, (Object)"Section IDs are not indexes");
            surf = sect.getFaultSurface(this.surfDiscretization, false, CREEP_REDUCED);
            this.sectSurfs.putIfAbsent(id, surf);
        }
        return surf;
    }

    public List<? extends FaultSection> getSubSections() {
        return this.subSects;
    }

    public boolean isDistanceCached(int id1, int id2) {
        if (id1 == id2) {
            return false;
        }
        if (id2 < id1) {
            int tmp = id1;
            id1 = id2;
            id2 = tmp;
        }
        return this.distCache[id1] != null && Double.isFinite(this.distCache[id1][SectionDistanceAzimuthCalculator.calcDistIndexOffset(id1, id2)]);
    }

    public synchronized void setDistance(int id1, int id2, double dist) {
        if (id1 == id2) {
            return;
        }
        if (id2 < id1) {
            int tmp = id1;
            id1 = id2;
            id2 = tmp;
        }
        if (this.distCache[id1] == null) {
            double[] cache = new double[this.subSects.size() - id1];
            for (int i = 0; i < cache.length; ++i) {
                cache[i] = Double.NaN;
            }
            this.distCache[id1] = cache;
        }
        this.distCache[id1][SectionDistanceAzimuthCalculator.calcDistIndexOffset((int)id1, (int)id2)] = dist;
    }

    public double getDistance(FaultSection sect1, FaultSection sect2) {
        return this.getDistance(sect1.getSectionId(), sect2.getSectionId());
    }

    private static int calcDistIndexOffset(int id1, int id2) {
        Preconditions.checkState((id1 < id2 ? 1 : 0) != 0);
        return id2 - (id1 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDistance(int id1, int id2) {
        if (id1 == id2) {
            return 0.0;
        }
        if (id2 < id1) {
            int tmp = id1;
            id1 = id2;
            id2 = tmp;
        }
        int offset = SectionDistanceAzimuthCalculator.calcDistIndexOffset(id1, id2);
        if (this.distCache[id1] == null) {
            double[][] dArray = this.distCache;
            synchronized (this.distCache) {
                if (this.distCache[id1] == null) {
                    double[] cache = new double[this.subSects.size() - id1];
                    for (int i = 0; i < cache.length; ++i) {
                        cache[i] = Double.NaN;
                    }
                    this.distCache[id1] = cache;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else if (Double.isFinite(this.distCache[id1][offset])) {
            return this.distCache[id1][offset];
        }
        {
            Location loc;
            RuptureSurface surf1 = this.getSurface(id1);
            Preconditions.checkNotNull((Object)surf1);
            RuptureSurface surf2 = this.getSurface(id2);
            Preconditions.checkNotNull((Object)surf2);
            double quickDistThreshold = 5.0 * Math.max(surf1.getAveLength(), surf2.getAveLength());
            double minDist = Double.POSITIVE_INFINITY;
            Iterator iterator = surf1.getPerimeter().iterator();
            while (iterator.hasNext() && !((minDist = Math.min(minDist, surf2.getQuickDistance(loc = (Location)iterator.next()))) < quickDistThreshold)) {
            }
            if (minDist < quickDistThreshold) {
                minDist = surf1.getMinDistance(surf2);
            }
            this.distCache[id1][offset] = minDist;
            return minDist;
        }
    }

    public synchronized void setAzimuth(int id1, int id2, double azimuth) {
        if (id1 == id2) {
            return;
        }
        if (this.azCache[id1] == null) {
            double[] cache = new double[this.subSects.size()];
            for (int i = 0; i < cache.length; ++i) {
                cache[i] = Double.NaN;
            }
            this.azCache[id1] = cache;
        }
        this.azCache[id1][id2] = azimuth;
    }

    public double getAzimuth(FaultSection sect1, FaultSection sect2) {
        return this.getAzimuth(sect1.getSectionId(), sect2.getSectionId());
    }

    public boolean isAzimuthCached(int id1, int id2) {
        return this.azCache[id1] != null && Double.isFinite(this.azCache[id1][id2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAzimuth(int id1, int id2) {
        if (id1 == id2) {
            return Double.NaN;
        }
        if (this.azCache[id1] == null) {
            double[][] dArray = this.azCache;
            synchronized (this.azCache) {
                if (this.azCache[id1] == null) {
                    double[] cache = new double[this.subSects.size()];
                    for (int i = 0; i < cache.length; ++i) {
                        cache[i] = Double.NaN;
                    }
                    this.azCache[id1] = cache;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (Double.isFinite(this.azCache[id1][id2])) {
            return this.azCache[id1][id2];
        }
        {
            RuptureSurface surf1 = this.getSurface(id1);
            Preconditions.checkNotNull((Object)surf1);
            RuptureSurface surf2 = this.getSurface(id2);
            Preconditions.checkNotNull((Object)surf2);
            Location loc1 = GriddedSurfaceUtils.getSurfaceMiddleLoc(surf1);
            Location loc2 = GriddedSurfaceUtils.getSurfaceMiddleLoc(surf2);
            this.azCache[id1][id2] = LocationUtils.azimuth(loc1, loc2);
            return this.azCache[id1][id2];
        }
    }

    public int getNumCachedDistances() {
        int count = 0;
        for (double[] cache : this.distCache) {
            if (cache == null) continue;
            for (double val : cache) {
                if (!Double.isFinite(val)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getNumCachedAzimuths() {
        int count = 0;
        for (double[] cache : this.azCache) {
            if (cache == null) continue;
            for (double val : cache) {
                if (!Double.isFinite(val)) continue;
                ++count;
            }
        }
        return count;
    }

    CSVFile<String> buildCache() {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("ID1", "ID2", "Distance", "Azimuth");
        int numDist = 0;
        int numAz = 0;
        for (int id1 = 0; id1 < this.subSects.size(); ++id1) {
            for (int id2 = 0; id2 < this.subSects.size(); ++id2) {
                boolean distCached = this.isDistanceCached(id1, id2);
                boolean azCached = this.isAzimuthCached(id1, id2);
                if (!distCached && !azCached) continue;
                ArrayList<Object> line = new ArrayList<Object>();
                line.add("" + id1);
                line.add("" + id2);
                if (distCached) {
                    line.add("" + this.getDistance(id1, id2));
                    ++numDist;
                } else {
                    line.add("");
                }
                if (azCached) {
                    line.add("" + this.getAzimuth(id1, id2));
                    ++numAz;
                } else {
                    line.add("");
                }
                csv.addLine((List<String>)line);
            }
        }
        System.out.println("Built cache file for " + numDist + " distances and " + numAz + " azimuths");
        return csv;
    }

    public void writeCacheFile(File cacheFile) throws IOException {
        CSVFile<String> csv = this.buildCache();
        csv.writeToFile(cacheFile);
    }

    public void loadCacheFile(File cacheFile) throws IOException {
        CSVFile<String> csv = CSVFile.readFile(cacheFile, true);
        this.loadCache(csv);
    }

    public String getDefaultCacheFileName() {
        return "dist_az_cache_" + SectionDistanceAzimuthCalculator.getUniqueSectCacheFileStr(this.subSects) + ".csv";
    }

    public static String getUniqueSectCacheFileStr(Collection<? extends FaultSection> subSects) {
        int numLocs = 0;
        double area = 0.0;
        for (FaultSection faultSection : subSects) {
            numLocs += faultSection.getFaultTrace().size();
            area += faultSection.getArea(CREEP_REDUCED);
        }
        return subSects.size() + "_sects_" + numLocs + "_trace_locs_" + (long)(area + 0.5) + "_area";
    }

    void loadCache(CSVFile<String> csv) {
        int numAz = 0;
        int numDist = 0;
        for (int row = 1; row < csv.getNumRows(); ++row) {
            String azStr;
            int id2;
            int id1 = csv.getInt(row, 0);
            if (id1 == (id2 = csv.getInt(row, 1))) continue;
            String distStr = csv.get(row, 2);
            if (!distStr.isEmpty()) {
                this.setDistance(id1, id2, Double.parseDouble(distStr));
                ++numDist;
            }
            if ((azStr = csv.get(row, 3)).isEmpty()) continue;
            this.setAzimuth(id1, id2, Double.parseDouble(azStr));
            ++numAz;
        }
        System.out.println("Loaded cache file for " + numDist + " distances and " + numAz + " azimuths");
    }

    synchronized void copyCacheFrom(SectionDistanceAzimuthCalculator o) {
        Preconditions.checkState((o.subSects.size() == this.subSects.size() ? 1 : 0) != 0);
        this.copyCache(o.distCache, this.distCache);
        this.copyCache(o.azCache, this.azCache);
        this.sectSurfs.putAll(o.sectSurfs);
    }

    private void copyCache(double[][] from, double[][] to) {
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == null) continue;
            to[i] = Arrays.copyOf(from[i], from[i].length);
        }
    }

    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        File rupSetFile = new File("/home/kevin/OpenSHA/UCERF4/rup_sets/fm3_1_ucerf3.zip");
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSet(rupSetFile);
        SectionDistanceAzimuthCalculator calc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
        System.out.println("516=>521: " + calc.getDistance(516, 521));
        System.out.println("516=>522: " + calc.getDistance(516, 522));
    }

    @Override
    public String getName() {
        return "Section Distance-Azimuth Calculator";
    }

    public static SectionDistanceAzimuthCalculator archivableInstance(List<? extends FaultSection> subSects) {
        return new ArchivableSectionDistAzCalc(subSects);
    }

    public static SectionDistanceAzimuthCalculator archivableInstance(SectionDistanceAzimuthCalculator calc) {
        ArchivableSectionDistAzCalc archivable = new ArchivableSectionDistAzCalc(calc.subSects);
        archivable.copyCacheFrom(calc);
        return archivable;
    }

    private static class ArchivableSectionDistAzCalc
    extends SectionDistanceAzimuthCalculator
    implements CSV_BackedModule {
        public ArchivableSectionDistAzCalc(List<? extends FaultSection> subSects) {
            super(subSects);
        }

        @Override
        public String getFileName() {
            return "dist_az_cache.csv";
        }

        @Override
        public CSVFile<?> getCSV() {
            return this.buildCache();
        }

        @Override
        public void initFromCSV(CSVFile<String> csv) {
            this.loadCache(csv);
        }
    }
}

