/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class SingleStrandRuptureTreeNavigator
implements RuptureTreeNavigator {
    private ClusterRupture rupture;
    private static final Collection<FaultSubsectionCluster> emptyClusters = Collections.emptySet();
    private static final Collection<FaultSection> emptySects = Collections.emptySet();

    public SingleStrandRuptureTreeNavigator(ClusterRupture rupture) {
        this.rupture = rupture;
        Preconditions.checkState((boolean)rupture.singleStrand);
    }

    @Override
    public FaultSubsectionCluster getPredecessor(FaultSubsectionCluster cluster) {
        for (int i = 0; i < this.rupture.clusters.length; ++i) {
            if (this.rupture.clusters[i] != cluster) continue;
            if (i == 0) {
                return null;
            }
            return this.rupture.clusters[i - 1];
        }
        throw new IllegalStateException("Cluster not found in rupture: " + String.valueOf(cluster));
    }

    @Override
    public Collection<FaultSubsectionCluster> getDescendants(FaultSubsectionCluster cluster) {
        for (int i = 0; i < this.rupture.clusters.length; ++i) {
            if (this.rupture.clusters[i] != cluster) continue;
            if (i == this.rupture.clusters.length - 1) {
                return emptyClusters;
            }
            return Collections.singleton(this.rupture.clusters[i + 1]);
        }
        throw new IllegalStateException("Cluster not found in rupture: " + String.valueOf(cluster));
    }

    @Override
    public Jump getJump(FaultSubsectionCluster fromCluster, FaultSubsectionCluster toCluster) {
        Jump ret = this.doGetJump(fromCluster, toCluster);
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("Rupture does not use a direct jump between " + String.valueOf(fromCluster) + " to " + String.valueOf(toCluster));
    }

    @Override
    public boolean hasJump(FaultSubsectionCluster fromCluster, FaultSubsectionCluster toCluster) {
        return this.doGetJump(fromCluster, toCluster) != null;
    }

    private Jump doGetJump(FaultSubsectionCluster fromCluster, FaultSubsectionCluster toCluster) {
        for (Jump jump : this.rupture.getJumpsIterable()) {
            FaultSubsectionCluster myFrom = jump.fromCluster;
            FaultSubsectionCluster myTo = jump.toCluster;
            if (myFrom.equals(fromCluster) && myTo.equals(toCluster)) {
                return jump;
            }
            if (!myTo.equals(fromCluster) || !myFrom.equals(toCluster)) continue;
            return jump.reverse();
        }
        return null;
    }

    @Override
    public Jump getJump(FaultSection fromSection, FaultSection toSection) {
        Jump ret = this.doGetJump(fromSection, toSection);
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("Rupture does not use a direct jump between " + fromSection.getSectionId() + " to " + toSection.getSectionId());
    }

    @Override
    public boolean hasJump(FaultSection fromSection, FaultSection toSection) {
        return this.doGetJump(fromSection, toSection) != null;
    }

    private Jump doGetJump(FaultSection fromSection, FaultSection toSection) {
        for (Jump jump : this.rupture.getJumpsIterable()) {
            FaultSection myFrom = jump.fromSection;
            FaultSection myTo = jump.toSection;
            if (myFrom == fromSection && myTo == toSection) {
                return jump;
            }
            if (myTo != fromSection || myFrom != toSection) continue;
            return jump.reverse();
        }
        return null;
    }

    @Override
    public FaultSection getPredecessor(FaultSection sect) {
        for (int i = 0; i < this.rupture.clusters.length; ++i) {
            if (!this.rupture.clusters[i].contains(sect)) continue;
            int j = this.rupture.clusters[i].subSects.indexOf((Object)sect);
            Preconditions.checkState((j >= 0 ? 1 : 0) != 0);
            if (j > 0) {
                return (FaultSection)this.rupture.clusters[i].subSects.get(j - 1);
            }
            if (i == 0) {
                return null;
            }
            return (FaultSection)this.rupture.clusters[i - 1].subSects.get(this.rupture.clusters[i - 1].subSects.size() - 1);
        }
        throw new IllegalStateException("Section not found in rupture: " + String.valueOf(sect));
    }

    @Override
    public Collection<FaultSection> getDescendants(FaultSection sect) {
        for (int i = 0; i < this.rupture.clusters.length; ++i) {
            if (!this.rupture.clusters[i].contains(sect)) continue;
            int j = this.rupture.clusters[i].subSects.indexOf((Object)sect);
            Preconditions.checkState((j >= 0 ? 1 : 0) != 0);
            if (j < this.rupture.clusters[i].subSects.size() - 1) {
                return Collections.singleton((FaultSection)this.rupture.clusters[i].subSects.get(j + 1));
            }
            if (i == this.rupture.clusters.length - 1) {
                return emptySects;
            }
            return Collections.singleton((FaultSection)this.rupture.clusters[i + 1].subSects.get(0));
        }
        throw new IllegalStateException("Section not found in rupture: " + String.valueOf(sect));
    }

    @Override
    public FaultSubsectionCluster locateCluster(FaultSection section) {
        for (int i = 0; i < this.rupture.clusters.length; ++i) {
            if (!this.rupture.clusters[i].contains(section)) continue;
            return this.rupture.clusters[i];
        }
        throw new IllegalStateException("Section " + section.getSectionId() + " not found in rupture: " + String.valueOf(this.rupture));
    }

    @Override
    public Jump getJumpTo(FaultSubsectionCluster cluster) {
        for (int i = 0; i < this.rupture.clusters.length; ++i) {
            if (!this.rupture.clusters[i].equals(cluster)) continue;
            if (i == 0) {
                return null;
            }
            return this.getJump(this.rupture.clusters[i - 1], cluster);
        }
        throw new IllegalStateException("Cluster " + String.valueOf(cluster) + " not found in rupture: " + String.valueOf(this.rupture));
    }
}

