/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.modules.IndividualSolutionRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.InfoModule;

public class AverageSolutionCreator {
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("USAGE: <output-solution> <input-solution-1> <input-solution-2> [... <input-solution-N>]");
            System.exit(1);
        }
        File outputFile = new File(args[0]);
        ArrayList<File> inputFiles = new ArrayList<File>();
        for (int i = 1; i < args.length; ++i) {
            File file = new File(args[i]);
            Preconditions.checkArgument((boolean)file.exists(), (String)"Input solution doesn't exist: %s", (Object)file.getAbsolutePath());
            inputFiles.add(file);
        }
        AverageSolutionCreator.average(outputFile, inputFiles);
    }

    public static void average(File outputFile, List<File> inputFiles) throws IOException {
        FaultSystemSolution[] inputs = new FaultSystemSolution[inputFiles.size()];
        ModuleContainer refRupSet = null;
        for (int i = 0; i < inputs.length; ++i) {
            File file = inputFiles.get(i);
            Preconditions.checkArgument((boolean)file.exists(), (String)"Input solution doesn't exist: %s", (Object)file.getAbsolutePath());
            if (i >= 10) {
                if (i == 10) {
                    refRupSet.loadAllAvailableModules();
                }
                ((FaultSystemRupSet)refRupSet).setParent((ModuleArchive<OpenSHA_Module>)null);
                inputs[i] = FaultSystemSolution.load(file, (FaultSystemRupSet)refRupSet);
            } else {
                inputs[i] = FaultSystemSolution.load(file);
            }
            if (i == 0) {
                refRupSet = inputs[i].getRupSet();
                continue;
            }
            Preconditions.checkState((boolean)((FaultSystemRupSet)refRupSet).isEquivalentTo(inputs[i].getRupSet()), (Object)"Solutions don't all use the same ruptures, cannot average");
        }
        FaultSystemSolution avgSol = AverageSolutionCreator.buildAverage(inputs);
        avgSol.write(outputFile);
    }

    public static FaultSystemSolution buildAverage(FaultSystemSolution ... inputs) {
        return AverageSolutionCreator.buildAverage(inputs, null);
    }

    public static FaultSystemSolution buildAverage(FaultSystemSolution[] inputs, double[] weights) {
        Preconditions.checkState((inputs.length > 1 ? 1 : 0) != 0);
        if (weights == null) {
            weights = new double[inputs.length];
            double scale = 1.0 / (double)inputs.length;
            for (int i = 0; i < inputs.length; ++i) {
                weights[i] = scale;
            }
        } else {
            Preconditions.checkState((weights.length == inputs.length ? 1 : 0) != 0);
        }
        FaultSystemRupSet refRupSet = null;
        for (int i = 0; i < inputs.length; ++i) {
            if (i == 0) {
                refRupSet = inputs[i].getRupSet();
                continue;
            }
            Preconditions.checkState((boolean)refRupSet.isEquivalentTo(inputs[i].getRupSet()), (Object)"Solutions don't all use the same ruptures, cannot average");
        }
        ArrayList<double[]> ratesList = new ArrayList<double[]>();
        for (FaultSystemSolution sol : inputs) {
            ratesList.add(sol.getRateForAllRups());
        }
        double totWeight = 0.0;
        boolean allWeightsSame = true;
        for (Object weight : (FaultSystemSolution)weights) {
            totWeight += weight;
            allWeightsSame = allWeightsSame && (float)weight == (float)weights[0];
        }
        int numRups = refRupSet.getNumRuptures();
        double[] rates = new double[numRups];
        int r = 0;
        while (r < numRups) {
            for (int i = 0; i < inputs.length; ++i) {
                int n = r;
                rates[n] = rates[n] + inputs[i].getRateForRup(r) * weights[i];
            }
            int n = r++;
            rates[n] = rates[n] / totWeight;
        }
        FaultSystemSolution avgSol = new FaultSystemSolution(refRupSet, rates);
        for (OpenSHA_Module module : inputs[0].getModulesAssignableTo(AverageableModule.class, true)) {
            Preconditions.checkState((boolean)(module instanceof AverageableModule));
            System.out.println("Building average instance of " + module.getName());
            try {
                AverageableModule.AveragingAccumulator<OpenSHA_Module> accumulator = ((AverageableModule)module).averagingAccumulator();
                for (int i = 0; i < inputs.length; ++i) {
                    FaultSystemSolution sol = inputs[i];
                    accumulator.processContainer(sol, weights[i]);
                }
                Object avgModule = accumulator.getAverage();
                if (avgModule == null) {
                    System.err.println("Averaging returned null for " + module.getName() + ", skipping");
                    continue;
                }
                avgSol.addModule(avgModule);
            }
            catch (Exception e) {
                System.err.println("Error averaging module: " + module.getName());
                e.printStackTrace();
                System.err.flush();
            }
        }
        if (inputs[0].hasModule(InversionConfiguration.class)) {
            InversionConfiguration config = inputs[0].getModule(InversionConfiguration.class);
            for (int i = 1; i < inputs.length; ++i) {
                if (!inputs[i].hasModule(InversionConfiguration.class)) {
                    config = null;
                    break;
                }
                InversionConfiguration oConfig = inputs[i].getModule(InversionConfiguration.class);
                if (oConfig.equals(config)) continue;
                config = null;
                break;
            }
            if (config != null) {
                avgSol.addModule(config);
            }
        }
        if (allWeightsSame) {
            avgSol.addModule(new IndividualSolutionRates(avgSol, ratesList));
        }
        String info = "Average of " + inputs.length + " solutions, generated with 'fst_solution_averager.sh'";
        if (inputs[0].hasModule(InfoModule.class)) {
            info = info + "\n\nInfo from first input solution:\n\n" + inputs[0].getModule(InfoModule.class).getText();
        }
        avgSol.addModule(new InfoModule(info));
        return avgSol;
    }

    private static boolean equivalent(double[] vals1, double[] vals2) {
        if (vals1.length != vals2.length) {
            return false;
        }
        for (int i = 0; i < vals1.length; ++i) {
            if ((float)vals1[i] == (float)vals2[i]) continue;
            return false;
        }
        return true;
    }
}

