/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;

public class FaultSectionBranchAverager {
    private List<? extends FaultSection> refSects;
    private int numSects;
    private double[] avgSectAseis;
    private double[] avgSectCoupling;
    private boolean[] sectAnyCreeps;
    private double[] avgSectCreep;
    private double[] avgSectSlipRates;
    private double[] avgSectSlipRateStdDevs;
    private double[] avgSectOrigFractUncert;
    private List<FaultUtils.AngleAverager> avgSectRakes;
    private double totWeight;

    public FaultSectionBranchAverager(List<? extends FaultSection> refSects) {
        this.refSects = refSects;
        this.numSects = refSects.size();
        this.totWeight = 0.0;
        this.avgSectAseis = new double[this.numSects];
        this.avgSectCreep = null;
        this.avgSectOrigFractUncert = new double[this.numSects];
        for (int i = 0; i < this.avgSectOrigFractUncert.length; ++i) {
            this.avgSectOrigFractUncert[i] = Double.NaN;
        }
        for (FaultSection faultSection : refSects) {
            if (!(faultSection instanceof GeoJSONFaultSection)) continue;
            GeoJSONFaultSection geoSect = (GeoJSONFaultSection)faultSection;
            double creepRate = geoSect.getProperties().getDouble("CreepRate", Double.NaN);
            if (Double.isFinite(creepRate)) {
                this.avgSectCreep = new double[this.numSects];
                this.sectAnyCreeps = new boolean[this.numSects];
                break;
            }
            double origFractUncert = geoSect.getProperties().getDouble("OrigFractStdDev", Double.NaN);
            if (!Double.isFinite(origFractUncert)) continue;
            this.avgSectOrigFractUncert[faultSection.getSectionId()] = 0.0;
        }
        this.avgSectSlipRates = new double[this.numSects];
        this.avgSectSlipRateStdDevs = new double[this.numSects];
        this.avgSectCoupling = new double[this.numSects];
        this.avgSectRakes = new ArrayList<FaultUtils.AngleAverager>();
        for (int s = 0; s < this.numSects; ++s) {
            this.avgSectRakes.add(new FaultUtils.AngleAverager());
        }
    }

    public void addWeighted(List<? extends FaultSection> sects, double weight) {
        Preconditions.checkState((sects.size() == this.numSects ? 1 : 0) != 0);
        this.totWeight += weight;
        for (int s = 0; s < sects.size(); ++s) {
            double creepRate;
            FaultSection sect = sects.get(s);
            int n = s;
            this.avgSectAseis[n] = this.avgSectAseis[n] + sect.getAseismicSlipFactor() * weight;
            int n2 = s;
            this.avgSectSlipRates[n2] = this.avgSectSlipRates[n2] + sect.getOrigAveSlipRate() * weight;
            int n3 = s;
            this.avgSectSlipRateStdDevs[n3] = this.avgSectSlipRateStdDevs[n3] + sect.getOrigSlipRateStdDev() * weight;
            int n4 = s;
            this.avgSectCoupling[n4] = this.avgSectCoupling[n4] + sect.getCouplingCoeff() * weight;
            this.avgSectRakes.get(s).add(sect.getAveRake(), weight);
            if (!(sect instanceof GeoJSONFaultSection)) continue;
            GeoJSONFaultSection geoSect = (GeoJSONFaultSection)sect;
            if (this.avgSectCreep != null && Double.isFinite(creepRate = geoSect.getProperties().getDouble("CreepRate", Double.NaN))) {
                this.sectAnyCreeps[s] = true;
                int n5 = s;
                this.avgSectCreep[n5] = this.avgSectCreep[n5] + Math.max(0.0, creepRate) * weight;
            }
            if (!Double.isFinite(this.avgSectOrigFractUncert[s])) continue;
            int n6 = s;
            this.avgSectOrigFractUncert[n6] = this.avgSectOrigFractUncert[n6] + weight * geoSect.getProperties().getDouble("OrigFractStdDev", Double.NaN);
        }
    }

    public List<FaultSection> buildAverageSects() {
        ArrayList<FaultSection> subSects = new ArrayList<FaultSection>();
        for (int s = 0; s < this.numSects; ++s) {
            FaultSection refSect = this.refSects.get(s);
            int n = s;
            this.avgSectAseis[n] = this.avgSectAseis[n] / this.totWeight;
            int n2 = s;
            this.avgSectCoupling[n2] = this.avgSectCoupling[n2] / this.totWeight;
            int n3 = s;
            this.avgSectSlipRates[n3] = this.avgSectSlipRates[n3] / this.totWeight;
            int n4 = s;
            this.avgSectSlipRateStdDevs[n4] = this.avgSectSlipRateStdDevs[n4] / this.totWeight;
            double avgRake = FaultUtils.getInRakeRange(this.avgSectRakes.get(s).getAverage());
            GeoJSONFaultSection avgSect = new GeoJSONFaultSection(new AvgFaultSection(refSect, this.avgSectAseis[s], this.avgSectCoupling[s], avgRake, this.avgSectSlipRates[s], this.avgSectSlipRateStdDevs[s]));
            if (this.avgSectCreep != null && this.sectAnyCreeps[s]) {
                int n5 = s;
                this.avgSectCreep[n5] = this.avgSectCreep[n5] / this.totWeight;
                avgSect.setProperty("CreepRate", this.avgSectCreep[s]);
            }
            if (Double.isFinite(this.avgSectOrigFractUncert[s])) {
                int n6 = s;
                this.avgSectOrigFractUncert[n6] = this.avgSectOrigFractUncert[n6] / this.totWeight;
                avgSect.setProperty("OrigFractStdDev", this.avgSectOrigFractUncert[s]);
            }
            subSects.add(avgSect);
        }
        this.avgSectAseis = null;
        this.avgSectCoupling = null;
        this.avgSectSlipRates = null;
        this.avgSectSlipRateStdDevs = null;
        this.refSects = null;
        this.numSects = -1;
        return subSects;
    }

    private class AvgFaultSection
    implements FaultSection {
        private FaultSection refSect;
        private double avgAseis;
        private double avgCoupling;
        private double avgRake;
        private double avgSlip;
        private double avgSlipStdDev;

        public AvgFaultSection(FaultSection refSect, double avgAseis, double avgCoupling, double avgRake, double avgSlip, double avgSlipStdDev) {
            this.refSect = refSect;
            this.avgAseis = avgAseis;
            this.avgCoupling = avgCoupling;
            this.avgRake = avgRake;
            this.avgSlip = avgSlip;
            this.avgSlipStdDev = avgSlipStdDev;
        }

        @Override
        public String getName() {
            return this.refSect.getName();
        }

        @Override
        public Element toXMLMetadata(Element root) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getDateOfLastEvent() {
            return this.refSect.getDateOfLastEvent();
        }

        @Override
        public void setDateOfLastEvent(long dateOfLastEventMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSlipInLastEvent(double slipInLastEvent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getSlipInLastEvent() {
            return this.refSect.getSlipInLastEvent();
        }

        @Override
        public double getAseismicSlipFactor() {
            if ((float)this.avgCoupling == 0.0f) {
                return 0.0;
            }
            return this.avgAseis;
        }

        @Override
        public void setAseismicSlipFactor(double aseismicSlipFactor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getCouplingCoeff() {
            if ((float)this.avgCoupling == 1.0f) {
                return 1.0;
            }
            return this.avgCoupling;
        }

        @Override
        public void setCouplingCoeff(double couplingCoeff) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getAveDip() {
            return this.refSect.getAveDip();
        }

        @Override
        public double getOrigAveSlipRate() {
            return this.avgSlip;
        }

        @Override
        public void setAveSlipRate(double aveLongTermSlipRate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getAveLowerDepth() {
            return this.refSect.getAveLowerDepth();
        }

        @Override
        public FaultTrace getLowerFaultTrace() {
            return this.refSect.getLowerFaultTrace();
        }

        @Override
        public double getAveRake() {
            return this.avgRake;
        }

        @Override
        public void setAveRake(double aveRake) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getOrigAveUpperDepth() {
            return this.refSect.getOrigAveUpperDepth();
        }

        @Override
        public float getDipDirection() {
            return this.refSect.getDipDirection();
        }

        @Override
        public FaultTrace getFaultTrace() {
            return this.refSect.getFaultTrace();
        }

        @Override
        public int getSectionId() {
            return this.refSect.getSectionId();
        }

        @Override
        public void setSectionId(int sectID) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSectionName(String sectName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getParentSectionId() {
            return this.refSect.getParentSectionId();
        }

        @Override
        public void setParentSectionId(int parentSectionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParentSectionName() {
            return this.refSect.getParentSectionName();
        }

        @Override
        public void setParentSectionName(String parentSectionName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends FaultSection> getSubSectionsList(double maxSubSectionLen, int startId, int minSubSections) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getOrigSlipRateStdDev() {
            return this.avgSlipStdDev;
        }

        @Override
        public void setSlipRateStdDev(double slipRateStdDev) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isConnector() {
            return this.refSect.isConnector();
        }

        @Override
        public Region getZonePolygon() {
            return this.refSect.getZonePolygon();
        }

        @Override
        public void setZonePolygon(Region zonePolygon) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element toXMLMetadata(Element root, String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RuptureSurface getFaultSurface(double gridSpacing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RuptureSurface getFaultSurface(double gridSpacing, boolean preserveGridSpacingExactly, boolean aseisReducesArea) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FaultSection clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isProxyFault() {
            return this.refSect.isProxyFault();
        }
    }
}

