/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.util.ClassUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class FaultSysTools {
    private static final String s = File.separator;
    public static File DEFAULT_SCRATCH_DATA_DIR = new File("src" + s + "main" + s + "resources" + s + "scratchData" + s + "rupture_sets");
    public static final double MIN_MAG = 0.05;
    public static final double DELTA_MAG = 0.1;
    private static double LOWEST_SNAPPED_MIN_MAG = 0.05;
    private static double LOWEST_ALLOWED_MIN_MAG = LOWEST_SNAPPED_MIN_MAG - 0.05;
    private static double LARGEST_SNAPPED_MAX_MAG = 15.05;
    private static double LARGEST_ALLOWED_MAX_MAG = LARGEST_SNAPPED_MAX_MAG + 0.05;
    private static int FULL_REF_SIZE = (int)((LARGEST_SNAPPED_MAX_MAG - LOWEST_SNAPPED_MIN_MAG) / 0.1) + 1;
    public static EvenlyDiscretizedFunc fullRefGridding = new EvenlyDiscretizedFunc(LOWEST_SNAPPED_MIN_MAG, FULL_REF_SIZE, 0.1);

    public static int defaultNumThreads() {
        int available = Runtime.getRuntime().availableProcessors();
        if (available >= 10) {
            available -= 2;
        }
        return Integer.max(1, Integer.min(32, available));
    }

    public static String enumOptions(Class<? extends Enum<?>> enumClass) {
        return Arrays.stream(enumClass.getEnumConstants()).map(c -> c.name()).collect(Collectors.joining(", "));
    }

    public static Option threadsOption() {
        Option threadsOption = new Option("t", "threads", true, "Number of calculation threads. Default is the lesser of 32 and the number of processors on the system: " + FaultSysTools.defaultNumThreads());
        threadsOption.setRequired(false);
        return threadsOption;
    }

    public static int getNumThreads(CommandLine cmd) {
        if (cmd.hasOption("threads")) {
            return Integer.parseInt(cmd.getOptionValue("threads"));
        }
        return FaultSysTools.defaultNumThreads();
    }

    public static Option cacheDirOption() {
        Option cacheOption = new Option("cd", "cache-dir", true, "Optional directory to store/load cache files (distances, coulomb, etc) to speed up rupture set building and processing.");
        cacheOption.setRequired(false);
        return cacheOption;
    }

    public static Option helpOption() {
        Option threadsOption = new Option("?", "help", false, "Displays usage including command line arguments, and exits.");
        threadsOption.setRequired(false);
        return threadsOption;
    }

    public static CommandLine parseOptions(Options options, String[] args, Class<?> mainClass) {
        CommandLine cmd;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            FaultSysTools.printHelpAndExit(options, mainClass);
            throw new IllegalStateException("Should never reach this");
        }
        return cmd;
    }

    public static void checkPrintHelp(Options options, CommandLine cmd, Class<?> mainClass) {
        if (cmd.hasOption("help")) {
            FaultSysTools.printHelpAndExit(options, mainClass);
        }
    }

    public static void printHelpAndExit(Options options, Class<?> mainClass) {
        HelpFormatter formatter = new HelpFormatter();
        int columns = 120;
        String colStr = System.getenv("COLUMNS");
        if (colStr != null && !colStr.isBlank()) {
            try {
                columns = Integer.max(80, Integer.parseInt(colStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        formatter.printHelp(columns, ClassUtils.getClassNameWithoutPackage(mainClass), null, options, null, true);
        System.exit(2);
    }

    public static File getCacheDir() {
        return FaultSysTools.getCacheDir(null);
    }

    public static File getCacheDir(CommandLine cmd) {
        if (cmd != null && cmd.hasOption("cache-dir")) {
            File cacheDir = new File(cmd.getOptionValue("cache-dir"));
            Preconditions.checkArgument((cacheDir.exists() || cacheDir.mkdir() ? 1 : 0) != 0, (String)"Specified cache directory doesn't exist and could not be created: %s", (Object)cacheDir.getAbsolutePath());
            return cacheDir;
        }
        if (!DEFAULT_SCRATCH_DATA_DIR.exists() && !DEFAULT_SCRATCH_DATA_DIR.mkdir()) {
            return null;
        }
        File cacheDir = new File(DEFAULT_SCRATCH_DATA_DIR, "caches");
        if (!cacheDir.exists() && !cacheDir.mkdir()) {
            return null;
        }
        return cacheDir;
    }

    public static IncrementalMagFreqDist initEmptyMFD(FaultSystemRupSet rupSet) {
        return FaultSysTools.initEmptyMFD(rupSet.getMaxMag());
    }

    public static IncrementalMagFreqDist initEmptyMFD(double maxRupSetMag) {
        return FaultSysTools.initEmptyMFD(0.05, maxRupSetMag);
    }

    public static IncrementalMagFreqDist initEmptyMFD(double minRupSetMag, double maxRupSetMag) {
        Preconditions.checkState(((float)minRupSetMag >= (float)LOWEST_ALLOWED_MIN_MAG ? 1 : 0) != 0, (String)"Minimum magnitude not allowed (too small, must be >=%s): %s", (Object)minRupSetMag, (Object)LOWEST_ALLOWED_MIN_MAG);
        Preconditions.checkState(((float)maxRupSetMag <= (float)LARGEST_ALLOWED_MAX_MAG ? 1 : 0) != 0, (String)"Maximum magnitude not allowed (too large, must be <=%s): %s", (Object)maxRupSetMag, (Object)LARGEST_ALLOWED_MAX_MAG);
        Preconditions.checkState((maxRupSetMag >= minRupSetMag ? 1 : 0) != 0, (String)"Max mag is less than min? max=%s, min=%s", (Object)maxRupSetMag, (Object)minRupSetMag);
        int minIndex = fullRefGridding.getClosestXIndex(minRupSetMag);
        int maxIndex = fullRefGridding.getClosestXIndex(maxRupSetMag);
        double snappedMin = minRupSetMag == 0.05 ? 0.05 : fullRefGridding.getX(minIndex);
        int NUM_MAG = 2 + maxIndex - minIndex;
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(snappedMin, NUM_MAG, 0.1);
        double lowerBin = ret.getMinX() - 0.05;
        Preconditions.checkState(((float)minRupSetMag >= (float)lowerBin ? 1 : 0) != 0, (String)"Bad MFD gridding with minMag=%s, lowerBinCenter=%s, lowerBinEdge=%s", (Object)minRupSetMag, (Object)ret.get(0).getX(), (Object)lowerBin);
        double upperBin = ret.getMaxX() + 0.05;
        Preconditions.checkState(((float)maxRupSetMag <= (float)upperBin ? 1 : 0) != 0, (String)"Bad MFD gridding with maxMag=%s, upperBinCenter=%s, upperBinEdge=%s", (Object)maxRupSetMag, (Object)ret.get(NUM_MAG - 1).getX(), (Object)upperBin);
        return ret;
    }
}

