/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.ReturnPeriodUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.params.filters.FixedDistanceCutoffFilter;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.calc.params.filters.SourceFilters;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffFilter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.DistCachedERFWrapper;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.ProxyFaultSectionInstances;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.HazardMapPlot;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysHazardCalcSettings;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelSupplier;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class SolHazardMapCalc {
    public static double SPACING_DEFAULT = 0.25;
    public static boolean PDFS = false;
    private FaultSystemSolution sol;
    private Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmpeRefMap;
    private GriddedRegion region;
    private Region mapPlotRegion;
    private double[] periods;
    private BaseFaultSystemSolutionERF fssERF;
    private List<Site> sites;
    private DiscretizedFunc[] xVals;
    private DiscretizedFunc[] logXVals;
    private List<DiscretizedFunc[]> curvesList;
    private List<XY_DataSet> extraFuncs;
    private List<PlotCurveCharacterstics> extraChars;
    private SourceFilterManager sourceFilter = FaultSysHazardCalcSettings.SOURCE_FILTER_DEFAULT;
    static final SourceFilterManager SITE_SKIP_SOURCE_FILTER_DEFAULT;
    private SourceFilterManager siteSkipSourceFilter = SITE_SKIP_SOURCE_FILTER_DEFAULT;
    private static IncludeBackgroundOption GRID_SEIS_DEFAULT;
    private IncludeBackgroundOption backSeisOption;
    private GriddedSeismicitySettings backSeisSettings = BaseFaultSystemSolutionERF.GRID_SETTINGS_DEFAULT;
    private boolean cacheGridSources = true;
    private boolean applyAftershockFilter;
    private boolean aseisReducesArea = true;
    private boolean noMFDs = false;
    private boolean useProxyRuptures = true;
    public static ReturnPeriods[] MAP_RPS;
    protected static DecimalFormat percentDF;
    protected static DecimalFormat twoDigitsDF;
    protected static DecimalFormat periodDF;
    protected static DecimalFormat oDF;

    public SolHazardMapCalc(FaultSystemSolution sol, Supplier<ScalarIMR> gmpeRef, GriddedRegion region, double ... periods) {
        this(sol, gmpeRef, region, GRID_SEIS_DEFAULT, periods);
    }

    public SolHazardMapCalc(FaultSystemSolution sol, Supplier<ScalarIMR> gmpeRef, GriddedRegion region, IncludeBackgroundOption backSeisOption, double ... periods) {
        this(sol, FaultSysHazardCalcSettings.wrapInTRTMap(gmpeRef), region, backSeisOption, periods);
    }

    public SolHazardMapCalc(FaultSystemSolution sol, Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmpeRefMap, GriddedRegion region, IncludeBackgroundOption backSeisOption, double ... periods) {
        this(sol, gmpeRefMap, region, backSeisOption, false, periods);
    }

    public SolHazardMapCalc(FaultSystemSolution sol, Supplier<ScalarIMR> gmpeRef, GriddedRegion region, IncludeBackgroundOption backSeisOption, boolean applyAftershockFilter, double ... periods) {
        this(sol, FaultSysHazardCalcSettings.wrapInTRTMap(gmpeRef), region, backSeisOption, applyAftershockFilter, periods);
    }

    public SolHazardMapCalc(FaultSystemSolution sol, Map<TectonicRegionType, ? extends Supplier<ScalarIMR>> gmpeRefMap, GriddedRegion region, IncludeBackgroundOption backSeisOption, boolean applyAftershockFilter, double ... periods) {
        this.sol = sol;
        this.gmpeRefMap = gmpeRefMap;
        this.region = region;
        this.backSeisOption = backSeisOption;
        this.applyAftershockFilter = applyAftershockFilter;
        Preconditions.checkState((periods.length > 0 ? 1 : 0) != 0);
        this.periods = periods;
        for (double period : periods) {
            Preconditions.checkState((period == -1.0 || period >= 0.0 ? 1 : 0) != 0, (Object)"supplied map calculation periods must be -1 (PGV), 0 (PGA), or a positive value");
        }
        if (gmpeRefMap != null) {
            this.sites = new ArrayList<Site>();
            ParameterList siteParams = FaultSysHazardCalcSettings.getDefaultRefSiteParams(gmpeRefMap);
            for (Location loc : region.getNodeList()) {
                Site site = new Site(loc);
                for (Parameter<?> param : siteParams) {
                    site.addParameter((Parameter)param.clone());
                }
                this.sites.add(site);
            }
        }
    }

    public void setBackSeisOption(IncludeBackgroundOption backSeisOption) {
        Preconditions.checkState((this.fssERF == null ? 1 : 0) != 0, (Object)"ERF already initialized");
        this.backSeisOption = backSeisOption;
    }

    public void setBackSeisType(BackgroundRupType backSeisType) {
        this.setGriddedSeismicitySettings(this.backSeisSettings.forSurfaceType(backSeisType));
    }

    public void setPointSourceDistanceCorrection(PointSourceDistanceCorrections distCorrType) {
        this.setGriddedSeismicitySettings(this.backSeisSettings.forDistanceCorrections(distCorrType));
    }

    public void setSupersamplingSettings(GridCellSupersamplingSettings supersamplingSettings) {
        this.setGriddedSeismicitySettings(this.backSeisSettings.forSupersamplingSettings(supersamplingSettings));
    }

    public void setGriddedSeismicitySettings(GriddedSeismicitySettings backSeisSettings) {
        Preconditions.checkState((this.fssERF == null ? 1 : 0) != 0, (Object)"ERF already initialized");
        this.backSeisSettings = backSeisSettings;
    }

    public void setCacheGridSources(boolean cacheGridSources) {
        Preconditions.checkState((this.fssERF == null ? 1 : 0) != 0, (Object)"ERF already initialized");
        this.cacheGridSources = cacheGridSources;
    }

    public void setApplyAftershockFilter(boolean applyAftershockFilter) {
        Preconditions.checkState((this.fssERF == null ? 1 : 0) != 0, (Object)"ERF already initialized");
        this.applyAftershockFilter = applyAftershockFilter;
    }

    public void setAseisReducesArea(boolean aseisReducesArea) {
        Preconditions.checkState((this.fssERF == null ? 1 : 0) != 0, (Object)"ERF already initialized");
        this.aseisReducesArea = aseisReducesArea;
    }

    public void setNoMFDs(boolean noMFDs) {
        Preconditions.checkState((this.fssERF == null ? 1 : 0) != 0, (Object)"ERF already initialized");
        this.noMFDs = noMFDs;
    }

    public void setUseProxyRups(boolean useProxyRuptures) {
        Preconditions.checkState((this.fssERF == null ? 1 : 0) != 0, (Object)"ERF already initialized");
        this.useProxyRuptures = useProxyRuptures;
    }

    public void setERF(BaseFaultSystemSolutionERF fssERF) {
        this.fssERF = fssERF;
    }

    public BaseFaultSystemSolutionERF getERF() {
        this.checkInitERF();
        return this.fssERF;
    }

    private synchronized void checkInitERF() {
        if (this.fssERF == null) {
            System.out.println("Building ERF");
            this.fssERF = new FaultSystemSolutionERF(this.sol);
            if (this.sol.hasAvailableModule(RupMFDsModule.class)) {
                this.fssERF.setParameter("Use Rupture MFDs", !this.noMFDs);
            }
            if (this.sol.hasAvailableModule(ProxyFaultSectionInstances.class)) {
                this.fssERF.setParameter("Use Proxy Rupture Realizations", this.useProxyRuptures);
            }
            this.fssERF.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
            this.fssERF.setParameter("Background Seismicity", (Object)this.backSeisOption);
            if (this.backSeisOption != IncludeBackgroundOption.EXCLUDE) {
                this.fssERF.setGriddedSeismicitySettings(this.backSeisSettings);
                this.fssERF.setCacheGridSources(this.cacheGridSources);
            }
            this.fssERF.setParameter("Apply Aftershock Filter", this.applyAftershockFilter);
            this.fssERF.setParameter("Aseismicity Reduces Area", this.aseisReducesArea);
            this.fssERF.getTimeSpan().setDuration(1.0);
            this.fssERF.updateForecast();
        }
    }

    public void setXVals(DiscretizedFunc xVals) {
        ArbitrarilyDiscretizedFunc logXVals = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : xVals) {
            logXVals.set(Math.log(pt.getX()), 0.0);
        }
        this.xVals = new DiscretizedFunc[this.periods.length];
        this.logXVals = new DiscretizedFunc[this.periods.length];
        for (int p = 0; p < this.periods.length; ++p) {
            this.xVals[p] = xVals;
            this.logXVals[p] = logXVals;
        }
    }

    public void setSourceFilter(SourceFilterManager sourceFilter) {
        this.sourceFilter = sourceFilter;
    }

    public void setSiteSkipSourceFilter(SourceFilterManager siteSkipSourceFilter) {
        this.siteSkipSourceFilter = siteSkipSourceFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitXVals() {
        if (this.xVals == null) {
            SolHazardMapCalc solHazardMapCalc = this;
            synchronized (solHazardMapCalc) {
                if (this.xVals == null) {
                    DiscretizedFunc[] xVals = new DiscretizedFunc[this.periods.length];
                    DiscretizedFunc[] logXVals = new DiscretizedFunc[this.periods.length];
                    IMT_Info imtInfo = new IMT_Info();
                    for (int p = 0; p < this.periods.length; ++p) {
                        xVals[p] = FaultSysHazardCalcSettings.getDefaultXVals(imtInfo, this.periods[p]);
                        logXVals[p] = new ArbitrarilyDiscretizedFunc();
                        for (Point2D pt : xVals[p]) {
                            logXVals[p].set(Math.log(pt.getX()), 0.0);
                        }
                    }
                    this.logXVals = logXVals;
                    this.xVals = xVals;
                }
            }
        }
    }

    public DiscretizedFunc getXVals(double period) {
        this.checkInitXVals();
        return this.xVals[this.periodIndex(period)];
    }

    private int periodIndex(double period) {
        for (int p = 0; p < this.periods.length; ++p) {
            if ((float)period != (float)this.periods[p]) continue;
            return p;
        }
        throw new IllegalStateException("Period not found: " + (float)period);
    }

    public void calcHazardCurves(int numThreads) {
        this.calcHazardCurves(numThreads, null);
    }

    public void calcHazardCurves(int numThreads, SolHazardMapCalc combineWith) {
        int numSites = this.region.getNodeCount();
        ArrayList<Integer> calcIndexes = new ArrayList<Integer>();
        for (int i = 0; i < numSites; ++i) {
            calcIndexes.add(i);
        }
        this.calcHazardCurves(numThreads, calcIndexes, combineWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcHazardCurves(int numThreads, List<Integer> calcIndexes, SolHazardMapCalc combineWith) {
        SolHazardMapCalc solHazardMapCalc = this;
        synchronized (solHazardMapCalc) {
            if (this.curvesList == null) {
                ArrayList<DiscretizedFunc[]> curvesList = new ArrayList<DiscretizedFunc[]>();
                for (int p = 0; p < this.periods.length; ++p) {
                    curvesList.add(new DiscretizedFunc[this.region.getNodeCount()]);
                }
                this.curvesList = curvesList;
            }
        }
        ConcurrentLinkedDeque<Integer> deque = new ConcurrentLinkedDeque<Integer>(calcIndexes);
        this.checkInitERF();
        System.out.println("Calculating hazard maps with " + numThreads + " threads and " + calcIndexes.size() + " sites...");
        ArrayList<CalcThread> threads = new ArrayList<CalcThread>();
        CalcTracker track = new CalcTracker(calcIndexes.size());
        for (int i = 0; i < numThreads; ++i) {
            CalcThread thread = new CalcThread(deque, this.fssERF, track, combineWith);
            thread.start();
            threads.add(thread);
        }
        for (CalcThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
    }

    public static double getMaxDistForTRT(SourceFilterManager sourceFilters, TectonicRegionType trt) {
        FixedDistanceCutoffFilter fixedCutoffFilter = sourceFilters.isEnabled(SourceFilters.FIXED_DIST_CUTOFF) ? (FixedDistanceCutoffFilter)sourceFilters.getFilterInstance(SourceFilters.FIXED_DIST_CUTOFF) : null;
        TectonicRegionDistCutoffFilter trtCutoffFilter = sourceFilters.isEnabled(SourceFilters.TRT_DIST_CUTOFFS) ? (TectonicRegionDistCutoffFilter)sourceFilters.getFilterInstance(SourceFilters.TRT_DIST_CUTOFFS) : null;
        double maxDist = Double.POSITIVE_INFINITY;
        if (fixedCutoffFilter != null) {
            maxDist = fixedCutoffFilter.getMaxDistance();
        }
        if (trtCutoffFilter != null) {
            maxDist = Math.min(maxDist, trtCutoffFilter.getCutoffs().getCutoffDist(trt));
        }
        return maxDist;
    }

    public static boolean shouldSkipSite(Site site, SourceFilterManager siteSkipSourceFilter, AbstractERF erf, int numFaultSysSources, GridSourceProvider gridProv) {
        if (siteSkipSourceFilter == null) {
            return false;
        }
        boolean hasSourceWithin = false;
        List<SourceFilter> fitlers = siteSkipSourceFilter.getEnabledFilters();
        if (gridProv != null) {
            Location siteLoc = site.getLocation();
            GriddedRegion gridReg = gridProv.getGriddedRegion();
            for (TectonicRegionType trt : gridProv.getTectonicRegionTypes()) {
                double maxDist = SolHazardMapCalc.getMaxDistForTRT(siteSkipSourceFilter, trt);
                if (Double.isInfinite(maxDist)) {
                    return false;
                }
                if (gridReg != null && gridProv.getNumSources() == gridProv.getNumLocations() * gridProv.getTectonicRegionTypes().size()) {
                    hasSourceWithin = gridReg.contains(siteLoc) || gridReg.distanceToLocation(siteLoc) <= maxDist;
                    continue;
                }
                for (int gridIndex = 0; !hasSourceWithin && gridIndex < gridProv.getNumLocations(); ++gridIndex) {
                    hasSourceWithin = LocationUtils.horzDistanceFast(siteLoc, gridProv.getLocation(gridIndex)) <= maxDist;
                }
            }
        }
        for (int sourceID = 0; !hasSourceWithin && sourceID < numFaultSysSources; ++sourceID) {
            ProbEqkSource source = erf.getSource(sourceID);
            if (HazardCurveCalculator.canSkipSource(fitlers, source, site)) continue;
            hasSourceWithin = true;
            break;
        }
        return !hasSourceWithin;
    }

    private List<DiscretizedFunc> calcSiteCurves(HazardCurveCalculator calc, AbstractERF erf, EnumMap<TectonicRegionType, ScalarIMR> gmpeMap, Site site, SolHazardMapCalc combineWith, int index) {
        this.checkInitXVals();
        ArrayList<DiscretizedFunc> ret = new ArrayList<DiscretizedFunc>(this.periods.length);
        for (int p = 0; p < this.periods.length; ++p) {
            FaultSysHazardCalcSettings.setIMforPeriod(gmpeMap, this.periods[p]);
            DiscretizedFunc logCurve = this.logXVals[p].deepClone();
            calc.getHazardCurve(logCurve, site, gmpeMap, (ERF)erf);
            DiscretizedFunc curve = this.xVals[p].deepClone();
            for (int i = 0; i < curve.size(); ++i) {
                curve.set(i, logCurve.getY(i));
            }
            if (combineWith != null) {
                DiscretizedFunc oCurve = combineWith.curvesList.get(p)[index];
                Preconditions.checkNotNull((Object)oCurve, (String)"CombineWith curve is null for period=%s, index=%s", (Object)this.periods[p], (Object)index);
                SolHazardMapCalc.combineIn(curve, oCurve);
            }
            ret.add(curve);
        }
        return ret;
    }

    public static void combineIn(DiscretizedFunc curve, DiscretizedFunc oCurve) {
        boolean equal = oCurve.size() == curve.size() && (float)oCurve.getMinX() == (float)curve.getMinX() && (float)oCurve.getMaxX() == (float)curve.getMaxX();
        for (int i = 0; i < curve.size(); ++i) {
            double y2;
            Point2D pt1 = curve.get(i);
            double y1 = pt1.getY();
            if (equal) {
                Point2D pt2 = oCurve.get(i);
                Preconditions.checkState(((float)pt1.getX() == (float)pt2.getX() ? 1 : 0) != 0);
                y2 = pt2.getY();
            } else {
                y2 = (float)pt1.getX() <= (float)oCurve.getMinX() ? oCurve.getY(0) : ((float)pt1.getX() >= (float)oCurve.getMaxX() ? oCurve.getY(oCurve.size() - 1) : oCurve.getInterpolatedY_inLogYDomain(pt1.getX()));
            }
            if (!(y2 > 0.0)) continue;
            if (y1 == 0.0) {
                curve.set(i, y2);
                continue;
            }
            curve.set(i, 1.0 - (1.0 - y1) * (1.0 - y2));
        }
    }

    public DiscretizedFunc[] getCurves(double period) {
        return this.curvesList.get(this.periodIndex(period));
    }

    public GriddedGeoDataSet buildMap(double period, ReturnPeriods returnPeriod) {
        return this.buildMap(period, returnPeriod.oneYearProb, false);
    }

    public GriddedGeoDataSet buildMap(double period, double curveLevel, boolean isProbAtIML) {
        int p = this.periodIndex(period);
        Preconditions.checkState((this.curvesList != null ? 1 : 0) != 0, (Object)"Must call calcHazardCurves first");
        GriddedGeoDataSet xyz = new GriddedGeoDataSet(this.region, false);
        DiscretizedFunc[] curves = this.curvesList.get(p);
        Preconditions.checkState((curves.length == this.region.getNodeCount() ? 1 : 0) != 0);
        for (int i = 0; i < curves.length; ++i) {
            DiscretizedFunc curve = curves[i];
            Preconditions.checkNotNull((Object)curve, (String)"Curve not calculated at index %s", (int)i);
            double val = isProbAtIML ? curve.getInterpolatedY_inLogXLogYDomain(curveLevel) : (curveLevel > curve.getMaxY() ? 0.0 : (curveLevel < curve.getMinY() ? curve.getMaxX() : curve.getFirstInterpolatedX_inLogXLogYDomain(curveLevel)));
            xyz.set(i, val);
        }
        return xyz;
    }

    public void setMapPlotRegion(Region mapPlotRegion) {
        this.mapPlotRegion = mapPlotRegion;
    }

    public File plotMap(File outputDir, String prefix, GriddedGeoDataSet xyz, CPT cpt, String title, String zLabel) throws IOException {
        return this.plotMap(outputDir, prefix, xyz, cpt, title, zLabel, false);
    }

    public File plotMap(File outputDir, String prefix, GriddedGeoDataSet xyz, CPT cpt, String title, String zLabel, boolean diffStats) throws IOException {
        MapPlot plot = this.buildMapPlot(outputDir, prefix, xyz, cpt, title, zLabel, diffStats);
        return new File(plot.outputDir, prefix + ".png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitExtraFuncs(double maxSpan) {
        if (this.extraFuncs == null) {
            SolHazardMapCalc solHazardMapCalc = this;
            synchronized (solHazardMapCalc) {
                if (this.extraFuncs == null) {
                    XY_DataSet[] boundaries;
                    float outlineWidth;
                    ArrayList<XY_DataSet> extraFuncs = new ArrayList<XY_DataSet>();
                    ArrayList<PlotCurveCharacterstics> extraChars = new ArrayList<PlotCurveCharacterstics>();
                    Color outlineColor = new Color(0, 0, 0, 180);
                    Color faultColor = new Color(0, 0, 0, 100);
                    float f = outlineWidth = maxSpan > 30.0 ? 1.0f : 2.0f;
                    if (!this.region.isRectangular()) {
                        DefaultXY_DataSet outline = new DefaultXY_DataSet();
                        for (Location loc : this.region.getBorder()) {
                            outline.set(loc.getLongitude(), loc.getLatitude());
                        }
                        outline.set(outline.get(0));
                        extraFuncs.add(outline);
                        extraChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, outlineColor));
                    }
                    if ((boundaries = PoliticalBoundariesData.loadDefaultOutlines(this.region)) != null) {
                        for (XY_DataSet xY_DataSet : boundaries) {
                            extraFuncs.add(xY_DataSet);
                            extraChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, outlineWidth, outlineColor));
                        }
                    }
                    if (this.sol != null) {
                        PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, faultColor);
                        DefaultXY_DataSet prevTrace = null;
                        for (FaultSection faultSection : this.sol.getRupSet().getFaultSectionDataList()) {
                            DefaultXY_DataSet trace = new DefaultXY_DataSet();
                            for (Location loc : faultSection.getFaultTrace()) {
                                trace.set(loc.getLongitude(), loc.getLatitude());
                            }
                            boolean reused = false;
                            if (prevTrace != null) {
                                Point2D prevLast = prevTrace.get(prevTrace.size() - 1);
                                Point2D newFirst = trace.get(0);
                                if ((float)prevLast.getX() == (float)newFirst.getX() && (float)prevLast.getY() == (float)newFirst.getY()) {
                                    for (int i = 1; i < trace.size(); ++i) {
                                        prevTrace.set(trace.get(i));
                                    }
                                    reused = true;
                                }
                            }
                            if (reused) continue;
                            extraFuncs.add(trace);
                            prevTrace = trace;
                            extraChars.add(traceChar);
                        }
                    }
                    this.extraChars = extraChars;
                    this.extraFuncs = extraFuncs;
                }
            }
        }
    }

    public MapPlot buildMapPlot(File outputDir, String prefix, GriddedGeoDataSet xyz, CPT cpt, String title, String zLabel, boolean diffStats) throws IOException {
        Range latRange;
        Range lonRange;
        if (this.mapPlotRegion == null) {
            GriddedRegion gridReg = xyz.getRegion();
            lonRange = new Range(Math.min(gridReg.getMinLon() - 0.05, xyz.getMinLon() - 0.75 * gridReg.getLonSpacing()), Math.max(gridReg.getMaxLon() + 0.05, xyz.getMaxLon() + 0.75 * gridReg.getLonSpacing()));
            latRange = new Range(Math.min(gridReg.getMinLat() - 0.05, xyz.getMinLat() - 0.75 * gridReg.getLatSpacing()), Math.max(gridReg.getMaxLat() + 0.05, xyz.getMaxLat() + 0.75 * gridReg.getLatSpacing()));
        } else {
            lonRange = new Range(this.mapPlotRegion.getMinLon(), this.mapPlotRegion.getMaxLon());
            latRange = new Range(this.mapPlotRegion.getMinLat(), this.mapPlotRegion.getMaxLat());
        }
        double latSpan = latRange.getLength();
        double lonSpan = lonRange.getLength();
        double maxSpan = Math.max(latSpan, lonSpan);
        this.checkInitExtraFuncs(maxSpan);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        XYZPlotSpec spec = new XYZPlotSpec(xyz, cpt, title, "Longitude", "Latitude", zLabel);
        spec.setCPTPosition(RectangleEdge.BOTTOM);
        spec.setXYElems(this.extraFuncs);
        spec.setXYChars(this.extraChars);
        if (diffStats) {
            boolean left;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int exactly0 = 0;
            int numBelow = 0;
            int numAbove = 0;
            int numWithin1 = 0;
            int numWithin5 = 0;
            int numWithin10 = 0;
            double mean = 0.0;
            double meanAbs = 0.0;
            int numFinite = 0;
            for (int i = 0; i < xyz.size(); ++i) {
                if (this.mapPlotRegion != null && !this.mapPlotRegion.contains(xyz.getLocation(i))) continue;
                double val = xyz.get(i);
                if (Double.isFinite(val)) {
                    min = Math.min(min, val);
                    max = Math.max(max, val);
                }
                if ((float)val == 0.0f) {
                    ++exactly0;
                }
                if (val >= -1.0 && val <= 1.0) {
                    ++numWithin1;
                }
                if (val >= -5.0 && val <= 5.0) {
                    ++numWithin5;
                }
                if (val >= -10.0 && val <= 10.0) {
                    ++numWithin10;
                }
                if ((float)val < 0.0f) {
                    ++numBelow;
                }
                if ((float)val > 0.0f) {
                    ++numAbove;
                }
                if (!Double.isFinite(val)) continue;
                ++numFinite;
                mean += val;
                meanAbs += Math.abs(val);
            }
            ArrayList<CallSite> labels = new ArrayList<CallSite>();
            labels.add((CallSite)((Object)("Range: [" + oDF.format(min) + "%," + oDF.format(max) + "%]")));
            labels.add((CallSite)((Object)("Mean: " + twoDigitsDF.format(mean /= (double)numFinite) + "%, Abs: " + twoDigitsDF.format(meanAbs /= (double)numFinite) + "%")));
            if (exactly0 >= numFinite / 2) {
                labels.add((CallSite)((Object)("Exactly 0%: " + percentDF.format((double)exactly0 / (double)numFinite))));
            }
            labels.add((CallSite)((Object)(percentDF.format((double)numBelow / (double)numFinite) + " < 0, " + percentDF.format((double)numAbove / (double)numFinite) + " > 0")));
            labels.add((CallSite)((Object)("Within 1%: " + percentDF.format((double)numWithin1 / (double)numFinite))));
            labels.add((CallSite)((Object)("Within 5%: " + percentDF.format((double)numWithin5 / (double)numFinite))));
            labels.add((CallSite)((Object)("Within 10%: " + percentDF.format((double)numWithin10 / (double)numFinite))));
            double testTopLat = latRange.getLowerBound() + 0.8 * latRange.getLength();
            double testBotLat = latRange.getLowerBound() + 0.2 * latRange.getLength();
            double testRightLon = lonRange.getLowerBound() + 0.8 * lonRange.getLength();
            double testLeftLon = lonRange.getLowerBound() + 0.2 * lonRange.getLength();
            if (!this.region.contains(new Location(testTopLat, testRightLon))) {
                boolean top = true;
                left = false;
            } else if (!this.region.contains(new Location(testTopLat, testLeftLon))) {
                boolean top = true;
                left = true;
            } else if (!this.region.contains(new Location(testBotLat, testLeftLon))) {
                boolean top = false;
                left = true;
            } else if (!this.region.contains(new Location(testBotLat, testRightLon))) {
                boolean top = false;
                boolean bl = false;
            }
            double yDiff = latSpan;
            yDiff = yDiff > 30.0 ? (yDiff /= 30.0) : (yDiff > 10.0 ? (yDiff /= 30.0) : (yDiff > 5.0 ? (yDiff /= 20.0) : (yDiff /= 15.0)));
            if (lonSpan > 1.75 * latSpan) {
                yDiff *= 1.5;
            }
            double y = latRange.getUpperBound() - 0.5 * yDiff;
            for (String string : labels) {
                double x = lonRange.getUpperBound();
                XYTextAnnotation ann = new XYTextAnnotation(string + "  ", x, y);
                ann.setTextAnchor(TextAnchor.TOP_RIGHT);
                ann.setFont(new Font("SansSerif", 1, 18));
                y -= yDiff;
                spec.addPlotAnnotation((XYAnnotation)ann);
            }
        }
        gp.drawGraphPanel(spec, false, false, lonRange, latRange);
        double tick = maxSpan > 20.0 ? 5.0 : (maxSpan > 8.0 ? 2.0 : (maxSpan > 3.0 ? 1.0 : (maxSpan > 1.0 ? 0.5 : 0.2)));
        PlotUtils.setTick(gp.getXAxis(), tick);
        PlotUtils.setTick(gp.getYAxis(), tick);
        PlotUtils.fixAspectRatio((GraphPanel)gp, 800, true);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        if (PDFS) {
            gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        }
        return new MapPlot(spec, lonRange, latRange, tick, tick, outputDir, prefix);
    }

    public void plotMultiMap(File outputDir, String prefix, List<GriddedGeoDataSet> xyzs, CPT cpt, String title, int titleFontSize, List<String> subtitles, int subtitleFontSize, String zLabel, boolean horizontal, int shorterDimension, boolean axisLables, boolean axesTicks) throws IOException {
        int height;
        int width;
        String yLabel;
        Range latRange;
        Range lonRange;
        GriddedGeoDataSet refXYZ = xyzs.get(0);
        if (this.mapPlotRegion == null) {
            GriddedRegion gridReg = refXYZ.getRegion();
            lonRange = new Range(Math.min(gridReg.getMinLon() - 0.05, refXYZ.getMinLon() - 0.75 * gridReg.getLonSpacing()), Math.max(gridReg.getMaxLon() + 0.05, refXYZ.getMaxLon() + 0.75 * gridReg.getLonSpacing()));
            latRange = new Range(Math.min(gridReg.getMinLat() - 0.05, refXYZ.getMinLat() - 0.75 * gridReg.getLatSpacing()), Math.max(gridReg.getMaxLat() + 0.05, refXYZ.getMaxLat() + 0.75 * gridReg.getLatSpacing()));
        } else {
            lonRange = new Range(this.mapPlotRegion.getMinLon(), this.mapPlotRegion.getMaxLon());
            latRange = new Range(this.mapPlotRegion.getMinLat(), this.mapPlotRegion.getMaxLat());
        }
        double latSpan = latRange.getLength();
        double lonSpan = lonRange.getLength();
        double maxSpan = Math.max(latSpan, lonSpan);
        this.checkInitExtraFuncs(maxSpan);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.getPlotPrefs().setPlotLabelFontSize(titleFontSize);
        ArrayList<XYZPlotSpec> specs = new ArrayList<XYZPlotSpec>();
        ArrayList<Range> lonRanges = new ArrayList<Range>();
        ArrayList<Range> latRanges = new ArrayList<Range>();
        String xLabel = axisLables ? "Longitude" : " ";
        String string = yLabel = axisLables ? "Latitutde" : " ";
        if (!axesTicks) {
            gp.getPlotPrefs().setAxisLabelFontSize(10);
        }
        for (int i = 0; i < xyzs.size(); ++i) {
            GriddedGeoDataSet xyz = xyzs.get(i);
            XYZPlotSpec spec = new XYZPlotSpec(xyz, cpt, title, xLabel, yLabel, zLabel);
            if (zLabel == null) {
                spec.setCPTVisible(false);
            } else if (horizontal) {
                spec.setCPTPosition(RectangleEdge.RIGHT);
            } else {
                spec.setCPTPosition(RectangleEdge.BOTTOM);
            }
            spec.setXYElems(this.extraFuncs);
            spec.setXYChars(this.extraChars);
            specs.add(spec);
            if (horizontal) {
                lonRanges.add(lonRange);
                if (!latRanges.isEmpty()) continue;
                latRanges.add(latRange);
                continue;
            }
            latRanges.add(latRange);
            if (!lonRanges.isEmpty()) continue;
            lonRanges.add(lonRange);
        }
        gp.drawGraphPanel(specs, false, false, lonRanges, latRanges);
        if (subtitles != null) {
            Font subtitleFont = new Font("SansSerif", 0, subtitleFontSize);
            PlotUtils.addSubplotTitles(gp, subtitles, subtitleFont);
        }
        if (axesTicks) {
            double tick = maxSpan > 20.0 ? 5.0 : (maxSpan > 8.0 ? 2.0 : (maxSpan > 3.0 ? 1.0 : (maxSpan > 1.0 ? 0.5 : 0.2)));
            PlotUtils.setXTick(gp, tick);
            PlotUtils.setYTick(gp, tick);
        } else {
            for (XYPlot subplot : PlotUtils.getSubPlots(gp)) {
                subplot.getDomainAxis().setTickLabelsVisible(false);
                subplot.getRangeAxis().setTickLabelsVisible(false);
            }
        }
        if (horizontal) {
            width = -1;
            height = shorterDimension;
        } else {
            width = shorterDimension;
            height = -1;
        }
        PlotUtils.writePlots(outputDir, prefix, gp, width, height, true, true, PDFS, false);
    }

    public static String getCSV_FileName(String prefix, double period) {
        Object fileName = prefix;
        fileName = period == -1.0 ? (String)fileName + "_pgv" : (period == 0.0 ? (String)fileName + "_pga" : (String)fileName + "_sa_" + periodDF.format(period));
        return (String)fileName + ".csv";
    }

    public void writeCurvesCSVs(File outputDir, String prefix, boolean gzip) throws IOException {
        this.writeCurvesCSVs(outputDir, prefix, gzip, false);
    }

    public void writeCurvesCSVs(File outputDir, String prefix, boolean gzip, boolean allowNull) throws IOException {
        for (double period : this.periods) {
            Object fileName = SolHazardMapCalc.getCSV_FileName(prefix, period);
            if (gzip) {
                fileName = (String)fileName + ".gz";
            }
            File outputFile = new File(outputDir, (String)fileName);
            this.writeCurvesCSV(outputFile, period, allowNull);
        }
    }

    public void writeCurvesCSV(File outputFile, double period) throws IOException {
        this.writeCurvesCSV(outputFile, period, false);
    }

    public void writeCurvesCSV(File outputFile, double period, boolean allowNull) throws IOException {
        Preconditions.checkState((this.curvesList != null ? 1 : 0) != 0, (Object)"Must call calcHazardCurves first");
        int p = this.periodIndex(period);
        DiscretizedFunc[] curves = this.curvesList.get(p);
        Preconditions.checkState((allowNull || curves[0] != null ? 1 : 0) != 0, (Object)"Curve not calculated at index 0");
        SolHazardMapCalc.writeCurvesCSV(outputFile, curves, this.region.getNodeList(), allowNull);
    }

    public static CSVFile<String> buildCurvesCSV(DiscretizedFunc[] curves, LocationList locs) {
        return SolHazardMapCalc.buildCurvesCSV(curves, locs, false);
    }

    public static CSVFile<String> buildCurvesCSV(DiscretizedFunc[] curves, LocationList locs, boolean allowNull) {
        CurveCSVLineIterator iterator = new CurveCSVLineIterator(curves, locs, allowNull);
        CSVFile<String> csv = new CSVFile<String>(true);
        while (iterator.hasNext()) {
            Object line = iterator.next();
            if (line == null) continue;
            csv.addLine((List<String>)line);
        }
        Preconditions.checkState((allowNull || csv.getNumRows() == locs.size() + 1 ? 1 : 0) != 0);
        return csv;
    }

    public static void writeCurvesCSV(File outputFile, DiscretizedFunc[] curves, LocationList locs) throws IOException {
        SolHazardMapCalc.writeCurvesCSV(outputFile, curves, locs, false);
    }

    public static void writeCurvesCSV(File outputFile, DiscretizedFunc[] curves, LocationList locs, boolean allowNull) throws IOException {
        CurveCSVLineIterator iterator = new CurveCSVLineIterator(curves, locs, allowNull);
        OutputStreamWriter fw = outputFile.getName().toLowerCase().endsWith(".gz") ? new OutputStreamWriter(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile)))) : new FileWriter(outputFile);
        while (iterator.hasNext()) {
            Object line = iterator.next();
            if (line == null) continue;
            CSVFile.writeLine((Writer)fw, line);
        }
        ((Writer)fw).close();
    }

    public static SolHazardMapCalc loadCurves(FaultSystemSolution sol, GriddedRegion region, double[] periods, File dir, String prefix) throws IOException {
        ArrayList<DiscretizedFunc[]> curvesList = new ArrayList<DiscretizedFunc[]>();
        for (double period : periods) {
            File curvesFile = new File(dir, SolHazardMapCalc.getCSV_FileName(prefix, period));
            if (!curvesFile.exists()) {
                curvesFile = new File(curvesFile.getAbsolutePath() + ".gz");
            }
            Preconditions.checkState((boolean)curvesFile.exists(), (String)"Curve files doesn't exist: %s", (Object)curvesFile.getAbsolutePath());
            CSVFile<String> csv = CSVFile.readFile(curvesFile, true);
            DiscretizedFunc[] curves = SolHazardMapCalc.loadCurvesCSV(csv, region);
            curvesList.add(curves);
        }
        return SolHazardMapCalc.forCurves(sol, region, periods, curvesList);
    }

    public static SolHazardMapCalc forCurves(FaultSystemSolution sol, GriddedRegion region, double[] periods, List<DiscretizedFunc[]> curvesList) throws IOException {
        Preconditions.checkState((periods.length == curvesList.size() ? 1 : 0) != 0);
        for (DiscretizedFunc[] curves : curvesList) {
            Preconditions.checkState((region.getNodeCount() == curves.length ? 1 : 0) != 0);
        }
        SolHazardMapCalc calc = new SolHazardMapCalc(sol, null, region, periods);
        calc.curvesList = curvesList;
        return calc;
    }

    public static DiscretizedFunc[] loadCurvesCSV(CSVFile<String> csv, GriddedRegion region) {
        return SolHazardMapCalc.loadCurvesCSV(csv, region, false);
    }

    public static DiscretizedFunc[] loadCurvesCSV(CSVFile<String> csv, GriddedRegion region, boolean allowNull) {
        DiscretizedFunc[] curves;
        boolean remap;
        double[] xVals = new double[csv.getNumCols() - 3];
        for (int i = 0; i < xVals.length; ++i) {
            xVals[i] = csv.getDouble(0, i + 3);
        }
        boolean bl = remap = !allowNull && region != null && region.getNodeCount() != csv.getNumRows() - 1;
        if (remap) {
            Preconditions.checkState((region.getNodeCount() < csv.getNumRows() - 1 ? 1 : 0) != 0, (Object)"Can only remap if the passed in region is a subset of the CSV region");
        }
        if (region != null) {
            Preconditions.checkState((allowNull || remap || csv.getNumRows() == region.getNodeCount() + 1 ? 1 : 0) != 0, (String)"Region node count discrepancy: %s != %s", (int)(csv.getNumRows() - 1), (int)region.getNodeCount());
            curves = new DiscretizedFunc[region.getNodeCount()];
        } else {
            curves = new DiscretizedFunc[csv.getNumRows() - 1];
        }
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int index;
            int n = index = allowNull ? csv.getInt(row, 0) : row - 1;
            if (region != null) {
                Location loc = new Location(csv.getDouble(row, 1), csv.getDouble(row, 2));
                if (remap) {
                    index = region.indexForLocation(loc);
                    if (index < 0) {
                        continue;
                    }
                } else {
                    Location regLoc = region.getLocation(index);
                    Preconditions.checkState((boolean)LocationUtils.areSimilar(loc, regLoc), (String)"Region location mismatch: %s != %s", (Object)loc, (Object)regLoc);
                }
            }
            if (!remap) {
                int csvIndex = csv.getInt(row, 0);
                Preconditions.checkState((index == csvIndex ? 1 : 0) != 0, (String)"CSV index mismatch: %s != %s", (int)index, (int)csvIndex);
            }
            double[] yVals = new double[xVals.length];
            for (int i = 0; i < xVals.length; ++i) {
                yVals[i] = csv.getDouble(row, i + 3);
            }
            curves[index] = new LightFixedXFunc(xVals, yVals);
        }
        if (remap) {
            for (int i = 0; i < curves.length; ++i) {
                Preconditions.checkNotNull((Object)curves[i], (String)"Can only remap if the passed in region is a subset of the CSV region. No match for index %s: %s", (int)i, (Object)region.locationForIndex(i));
            }
        }
        return curves;
    }

    private static Options createOptions() {
        Options ops = new Options();
        ops.addOption(FaultSysTools.threadsOption());
        FaultSysHazardCalcSettings.addCommonOptions(ops, true);
        Option inputOption = new Option("if", "input-file", true, "Input solution file");
        inputOption.setRequired(true);
        ops.addOption(inputOption);
        Option compOption = new Option("cf", "comp-file", true, "Comparison solution file");
        compOption.setRequired(false);
        ops.addOption(compOption);
        Option outputOption = new Option("od", "output-dir", true, "Output directory");
        outputOption.setRequired(true);
        ops.addOption(outputOption);
        Option gridSpacingOption = new Option("gs", "grid-spacing", true, "Grid spacing in degrees. Default: " + (float)SPACING_DEFAULT);
        gridSpacingOption.setRequired(false);
        ops.addOption(gridSpacingOption);
        Option recalcOption = new Option("rc", "recalc", false, "Flag to force recalculation (ignore existing curves files)");
        recalcOption.setRequired(false);
        ops.addOption(recalcOption);
        ops.addOption("gs", "gridded-seis", true, "Gridded seismicity option. One of " + FaultSysTools.enumOptions(IncludeBackgroundOption.class) + ". Default: " + GRID_SEIS_DEFAULT.name());
        ops.getOption("periods").setRequired(true);
        return ops;
    }

    public static void main(String[] args) throws IOException {
        CommandLine cmd = FaultSysTools.parseOptions(SolHazardMapCalc.createOptions(), args, SolHazardMapCalc.class);
        File inputFile = new File(cmd.getOptionValue("input-file"));
        FaultSystemSolution sol = FaultSystemSolution.load(inputFile);
        File outputDir = new File(cmd.getOptionValue("output-dir"));
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        Region region = new ReportMetadata((RupSetMetadata)new RupSetMetadata(null, (FaultSystemSolution)sol)).region;
        IncludeBackgroundOption gridSeisOp = GRID_SEIS_DEFAULT;
        if (cmd.hasOption("gridded-seis")) {
            gridSeisOp = IncludeBackgroundOption.valueOf(cmd.getOptionValue("gridded-seis"));
        }
        GriddedSeismicitySettings griddedSettings = FaultSysHazardCalcSettings.getGridSeisSettings(cmd);
        if (gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
            System.out.println("Gridded settings: " + String.valueOf(griddedSettings));
        }
        SourceFilterManager sourceFilter = FaultSysHazardCalcSettings.getSourceFilters(cmd);
        SourceFilterManager siteSkipSourceFilter = FaultSysHazardCalcSettings.getSiteSkipSourceFilters(sourceFilter, cmd);
        Map<TectonicRegionType, AttenRelSupplier> gmmRefs = FaultSysHazardCalcSettings.getGMMs(cmd);
        System.out.println("GMMs:");
        for (TectonicRegionType trt : gmmRefs.keySet()) {
            System.out.println("\tGMM for " + trt.name() + ": " + gmmRefs.get(trt).getName());
        }
        double gridSpacing = SPACING_DEFAULT;
        if (cmd.hasOption("grid-spacing")) {
            gridSpacing = Double.parseDouble(cmd.getOptionValue("grid-spacing"));
        }
        GriddedRegion gridReg = new GriddedRegion(region, gridSpacing, GriddedRegion.ANCHOR_0_0);
        ArrayList<Double> periodsList = new ArrayList<Double>();
        String periodsStr = cmd.getOptionValue("periods");
        if (periodsStr.contains(",")) {
            String[] split;
            for (String str : split = periodsStr.split(",")) {
                periodsList.add(Double.parseDouble(str));
            }
        } else {
            periodsList.add(Double.parseDouble(periodsStr));
        }
        double[] periods = Doubles.toArray(periodsList);
        SolHazardMapCalc calc = null;
        boolean recalc = cmd.hasOption("recalc");
        if (!recalc) {
            try {
                calc = SolHazardMapCalc.loadCurves(sol, gridReg, periods, outputDir, "curves");
                System.out.println("Loaded existing curves!");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SourceFilterManager sourceFilters = SITE_SKIP_SOURCE_FILTER_DEFAULT;
        if (cmd.hasOption("max-distance")) {
            double maxDistance = Double.parseDouble(cmd.getOptionValue("max-distance"));
            sourceFilters = new SourceFilterManager(SourceFilters.FIXED_DIST_CUTOFF);
            ((FixedDistanceCutoffFilter)sourceFilters.getFilterInstance(SourceFilters.FIXED_DIST_CUTOFF)).setMaxDistance(maxDistance);
        }
        if (calc == null) {
            calc = new SolHazardMapCalc(sol, gmmRefs, gridReg, gridSeisOp, periods);
            calc.setSourceFilter(sourceFilters);
            calc.setSiteSkipSourceFilter(siteSkipSourceFilter);
            calc.calcHazardCurves(FaultSysTools.getNumThreads(cmd));
            calc.writeCurvesCSVs(outputDir, "curves", gridSpacing < 0.1);
        }
        SolHazardMapCalc compCalc = null;
        if (cmd.hasOption("comp-file")) {
            System.out.println("Calculating comparison...");
            FaultSystemSolution compSol = FaultSystemSolution.load(new File(cmd.getOptionValue("comp-file")));
            if (!recalc) {
                try {
                    compCalc = SolHazardMapCalc.loadCurves(compSol, gridReg, periods, outputDir, "comp_curves");
                    System.out.println("Loaded existing curves!");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (compCalc == null) {
                compCalc = new SolHazardMapCalc(compSol, gmmRefs, gridReg, gridSeisOp, periods);
                compCalc.setSourceFilter(sourceFilters);
                compCalc.setSiteSkipSourceFilter(siteSkipSourceFilter);
                compCalc.calcHazardCurves(FaultSysTools.getNumThreads(cmd));
                compCalc.writeCurvesCSVs(outputDir, "comp_curves", gridSpacing < 0.1);
            }
        }
        HazardMapPlot plot = new HazardMapPlot(null, gridSpacing, periods);
        File resourcesDir = new File(outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# Hazard Maps");
        lines.add("");
        lines.addAll(plot.plot(resourcesDir, resourcesDir.getName(), "", gridReg, calc, compCalc));
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
    }

    static {
        String spacingEnv = System.getenv("FST_HAZARD_SPACING");
        if (spacingEnv != null && !spacingEnv.isBlank()) {
            try {
                SPACING_DEFAULT = Double.parseDouble(spacingEnv);
            }
            catch (NumberFormatException e) {
                System.err.println("Couldn't parse FST_HAZARD_SPACING environmental variable as a double: " + spacingEnv);
                e.printStackTrace();
            }
        }
        SITE_SKIP_SOURCE_FILTER_DEFAULT = new SourceFilterManager(SourceFilters.TRT_DIST_CUTOFFS);
        TectonicRegionDistCutoffFilter filter = (TectonicRegionDistCutoffFilter)SITE_SKIP_SOURCE_FILTER_DEFAULT.getFilterInstance(SourceFilters.TRT_DIST_CUTOFFS);
        TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs cutoffs = filter.getCutoffs();
        for (TectonicRegionType trt : TectonicRegionType.values()) {
            cutoffs.setCutoffDist(trt, cutoffs.getCutoffDist(trt) * 0.8);
        }
        GRID_SEIS_DEFAULT = IncludeBackgroundOption.EXCLUDE;
        MAP_RPS = new ReturnPeriods[]{ReturnPeriods.TWO_IN_50, ReturnPeriods.TEN_IN_50};
        percentDF = new DecimalFormat("0.00%");
        twoDigitsDF = new DecimalFormat("0.00");
        periodDF = new DecimalFormat("0.####");
        oDF = new DecimalFormat("0.#");
    }

    private class CalcTracker {
        private int numDone;
        private int size;
        private int mod;
        private String printPrefix;

        public CalcTracker(int size) {
            this.size = size;
            this.numDone = 0;
            this.mod = size > 10000 ? 200 : (size > 5000 ? 100 : (size > 1000 ? 20 : 10));
            try {
                int rank = MPI.COMM_WORLD.Rank();
                String hostname = InetAddress.getLocalHost().getHostName();
                this.printPrefix = hostname != null && !hostname.isBlank() ? hostname + ", " + rank + ": " : rank + ": ";
            }
            catch (Throwable t) {
                this.printPrefix = "";
            }
        }

        public synchronized void taskCompleted() {
            ++this.numDone;
            if (this.numDone == this.size || this.numDone % this.mod == 0) {
                System.out.println(this.printPrefix + "Computed " + this.numDone + "/" + this.size + " curves (" + percentDF.format((double)this.numDone / (double)this.size) + ")");
            }
        }
    }

    private class CalcThread
    extends Thread {
        private ConcurrentLinkedDeque<Integer> calcIndexes;
        private AbstractERF erf;
        private int numFaultSysSources;
        private GridSourceProvider gridProv;
        private CalcTracker track;
        private SolHazardMapCalc combineWith;

        public CalcThread(ConcurrentLinkedDeque<Integer> calcIndexes, BaseFaultSystemSolutionERF erf, CalcTracker track, SolHazardMapCalc combineWith) {
            this.calcIndexes = calcIndexes;
            this.track = track;
            this.combineWith = combineWith;
            this.numFaultSysSources = erf.getNumFaultSystemSources();
            IncludeBackgroundOption bgOption = (IncludeBackgroundOption)((Object)erf.getParameter("Background Seismicity").getValue());
            if (bgOption == IncludeBackgroundOption.INCLUDE || bgOption == IncludeBackgroundOption.ONLY) {
                this.gridProv = erf.getSolution().requireModule(GridSourceProvider.class);
            }
            this.erf = new DistCachedERFWrapper(erf);
        }

        @Override
        public void run() {
            Integer index;
            EnumMap<TectonicRegionType, ScalarIMR> gmpeMap = new EnumMap<TectonicRegionType, ScalarIMR>(TectonicRegionType.class);
            for (TectonicRegionType trt : SolHazardMapCalc.this.gmpeRefMap.keySet()) {
                gmpeMap.put(trt, SolHazardMapCalc.this.gmpeRefMap.get(trt).get());
            }
            HazardCurveCalculator calc = new HazardCurveCalculator(SolHazardMapCalc.this.sourceFilter);
            while ((index = this.calcIndexes.pollFirst()) != null) {
                Site site = SolHazardMapCalc.this.sites.get(index);
                if (SolHazardMapCalc.this.siteSkipSourceFilter != null && SolHazardMapCalc.shouldSkipSite(site, SolHazardMapCalc.this.siteSkipSourceFilter, this.erf, this.numFaultSysSources, this.gridProv)) {
                    SolHazardMapCalc.this.checkInitXVals();
                    for (int p = 0; p < SolHazardMapCalc.this.periods.length; ++p) {
                        DiscretizedFunc curve = SolHazardMapCalc.this.xVals[p].deepClone();
                        for (int i = 0; i < curve.size(); ++i) {
                            curve.set(i, 0.0);
                        }
                        if (this.combineWith != null) {
                            DiscretizedFunc oCurve = this.combineWith.curvesList.get(p)[index];
                            Preconditions.checkNotNull((Object)oCurve, (String)"CombineWith curve is null for period=%s, index=%s", (Object)SolHazardMapCalc.this.periods[p], (Object)index);
                            SolHazardMapCalc.combineIn(curve, oCurve);
                        }
                        SolHazardMapCalc.this.curvesList.get((int)p)[index.intValue()] = curve;
                    }
                    this.track.taskCompleted();
                    continue;
                }
                List<DiscretizedFunc> curves = SolHazardMapCalc.this.calcSiteCurves(calc, this.erf, gmpeMap, site, this.combineWith, index);
                for (int p = 0; p < SolHazardMapCalc.this.periods.length; ++p) {
                    SolHazardMapCalc.this.curvesList.get((int)p)[index.intValue()] = curves.get(p);
                }
                this.track.taskCompleted();
            }
        }
    }

    public static enum ReturnPeriods {
        TWO_IN_50(0.02, 50.0, "2% in 50 year"),
        TEN_IN_50(0.1, 50.0, "10% in 50 year"),
        FORTY_IN_50(0.4, 50.0, "40% in 50 year");

        public final double refProb;
        public final double refDuration;
        public final String label;
        public final double oneYearProb;
        public final double returnPeriod;

        private ReturnPeriods(double refProb, double refDuration, String label) {
            this.refProb = refProb;
            this.refDuration = refDuration;
            this.label = label;
            this.oneYearProb = ReturnPeriodUtils.calcExceedanceProb(refProb, refDuration, 1.0);
            this.returnPeriod = ReturnPeriodUtils.calcReturnPeriod(refProb, refDuration);
        }
    }

    public static class MapPlot {
        public final XYZPlotSpec spec;
        public final Range xRnage;
        public final Range yRange;
        public final double xTick;
        public final double yTick;
        public final File outputDir;
        public final String prefix;

        public MapPlot(XYZPlotSpec spec, Range xRnage, Range yRange, double xTick, double yTick, File outputDir, String prefix) {
            this.spec = spec;
            this.xRnage = xRnage;
            this.yRange = yRange;
            this.xTick = xTick;
            this.yTick = yTick;
            this.outputDir = outputDir;
            this.prefix = prefix;
        }
    }

    private static class CurveCSVLineIterator
    implements Iterator<List<String>> {
        private int curIndex;
        private DiscretizedFunc[] curves;
        private LocationList locs;
        private boolean allowNull;
        private DiscretizedFunc refCurve = null;
        private int cols = -1;

        public CurveCSVLineIterator(DiscretizedFunc[] curves, LocationList locs, boolean allowNull) {
            this.curves = curves;
            this.locs = locs;
            this.allowNull = allowNull;
            this.curIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.curIndex < this.locs.size();
        }

        @Override
        public List<String> next() {
            Preconditions.checkState((this.curIndex >= -1 && this.curIndex < this.locs.size() ? 1 : 0) != 0);
            if (this.curIndex == -1) {
                ArrayList<String> header = new ArrayList<String>();
                header.add("Index");
                header.add("Latitude");
                header.add("Longitude");
                for (DiscretizedFunc curve : this.curves) {
                    if (curve == null) continue;
                    this.refCurve = curve;
                    break;
                }
                Preconditions.checkNotNull((Object)this.refCurve, (Object)"All curves are null");
                for (int i = 0; i < this.refCurve.size(); ++i) {
                    header.add(String.valueOf((float)this.refCurve.getX(i)));
                }
                this.cols = header.size();
                ++this.curIndex;
                return header;
            }
            DiscretizedFunc curve = this.curves[this.curIndex];
            if (this.allowNull && curve == null) {
                ++this.curIndex;
                return null;
            }
            Preconditions.checkNotNull((Object)curve, (String)"Curve not calculated at index %s", (int)this.curIndex);
            Preconditions.checkState((this.refCurve.size() == curve.size() ? 1 : 0) != 0, (Object)"Curve size mismatch");
            Preconditions.checkState(((float)curve.getX(0) == (float)this.refCurve.getX(0) ? 1 : 0) != 0);
            Preconditions.checkState(((float)curve.getX(this.refCurve.size() - 1) == (float)this.refCurve.getX(this.refCurve.size() - 1) ? 1 : 0) != 0);
            ArrayList<String> line = new ArrayList<String>(this.cols);
            line.add(String.valueOf(this.curIndex));
            Location loc = (Location)this.locs.get(this.curIndex);
            line.add(String.valueOf(loc.lat));
            line.add(String.valueOf(loc.lon));
            for (int j = 0; j < curve.size(); ++j) {
                line.add(String.valueOf(curve.getY(j)));
            }
            ++this.curIndex;
            return line;
        }
    }
}

