/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.mahdilamb.colormap.Colors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.xyz.AbstractGeoDataSet;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.gui.plot.GeographicMapMaker;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ExecutorUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.ReturnPeriodUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationPlotData;
import org.opensha.sha.calc.disaggregation.DisaggregationSourceRuptureInfo;
import org.opensha.sha.calc.disaggregation.chart3d.PureJavaDisaggPlotter;
import org.opensha.sha.calc.params.filters.FixedDistanceCutoffFilter;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.calc.params.filters.SourceFilters;
import org.opensha.sha.calc.params.filters.TectonicRegionDistCutoffFilter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.DistCachedERFWrapper;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.GeneralInfoPlot;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysHazardCalcSettings;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.earthquake.faultSysSolution.util.SolutionDisaggConsolidator;
import org.opensha.sha.earthquake.faultSysSolution.util.SolutionDisaggSourceTypeConsolidator;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelSupplier;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.NEHRP_TestCity;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class SolSiteHazardCalc {
    private static final String NAME_HEADER = "Name";
    private static final String LAT_HEADER = "Latitude";
    private static final String LON_HEADER = "Longitude";
    private static final String VS30_HEADER = "Vs30";
    private static final String Z10_HEADER = "Z1.0";
    private static final String Z25_HEADER = "Z2.5";
    private static final String SOL_NAME_DEFAULT = "Solution";
    private static final String COMP_SOL_NAME_DEFAULT = "Comparison Solution";
    private static boolean THREAD_LOCAL_ERFS = false;
    private static final DecimalFormat pDF = new DecimalFormat("0.##%");
    private static final DecimalFormat oDF = new DecimalFormat("0.##");
    private static final DecimalFormat periodDF = new DecimalFormat("0.####");

    private static Options createOptions() {
        Options ops = new Options();
        ops.addOption(FaultSysTools.helpOption());
        ops.addOption(FaultSysTools.threadsOption());
        ops.addRequiredOption("if", "input-file", true, "Path to input solution zip file.");
        ops.addOption("n", "name", true, "Name of the solution (used in plots). Default: Solution");
        ops.addOption("cmp", "compare-to", true, "Optional path to an alternative solution for comparison.");
        ops.addOption("cn", "comp-name", true, "Name of the comparison solution. Default: Comparison Solution");
        ops.addOption("od", "output-dir", true, "Output directory where curves and a report (with plots) will be written. You must supply either this, or --output-file to write curves only (without the repoort). The report will be written to `index.html` and `README.md`, curves will be written to `curves_<period>.csv`, and all plots will be placed in a `resources` subdirctory.");
        ops.addOption("of", "output-file", true, "Output CSV file where hazard curves will be written if you don't want to generate a report with plots (alternative to --output-dir). If multiple periods are supplied, a period-specific suffix will be added before the .csv extension. If a comparison model, '_comp' will also be appended.");
        ops.addOption(null, "site-location", true, "Site location specified as <lat>,<lon>; must supply either this, --sites, or --nehrp-sites.");
        ops.addOption(null, "site-name", true, "Site name, optionally used in conjunction with --site-location.");
        ops.addOption(null, "sites", true, "Path to a site list CSV file. The first 3 columns must be: `Name`, `Latitude`, and `Longitude`. The first row is assumed to be a header, and site parameters can optionally be passed in via additional columns (supplied in any combination/order). Recognized site paramter column headers are: `Vs30` (unts are m/s), `Z1.0` (units are m, supply `NaN` for default treatment), and `Z2.5` (units are km, supply `NaN` for default treatment).");
        ops.addOption(null, "nehrp-sites", false, "Flag to calculate at NEHRP sites. If the solutions supplies a model region, sites in that region will be included, otherwise sites within the hazard calculation maximum distance (see --max-distance) will be included.");
        ops.addOption(null, "vs30", true, "Site Vs30 in m/s.");
        ops.addOption(null, "z10", true, "Site Z1.0 (depth Vs=1.0 km/s), supplied in meters. If not supplied (and the chosen GMPE uses Z1.0), the default (usually Vs30-dependent) model will be used.");
        ops.addOption(null, "z25", true, "Site Z2.5 (depth Vs=2.5 km/s), supplied in kilometers. If not supplied (and the chosen GMPE uses Z2.5), the default (usually Vs30-dependent) model will be used.");
        FaultSysHazardCalcSettings.addCommonOptions(ops, false);
        ops.addOption(null, "spectra", false, "Flag to calculate and plot hazard spectra. Usually used in conjunction with --all-periods. Also see --return-periods.");
        ops.addOption(null, "all-periods", false, "Flag to calculate all available periods (alternative to --periods).");
        ops.addOption(null, "gridded-seis", true, "By default, gridded seismicity will be included in calculations if gridded sources are present in the input fault system solution. You can override this behavior with this argument, and options are: " + FaultSysTools.enumOptions(IncludeBackgroundOption.class));
        ops.addOption(null, "duration", true, "Sets the duration for curve calculations; default is 1 year (annual probabilities of exceedance).");
        ops.addOption(null, "disagg-prob", true, "Enables disaggregation at the specified probability of exceedance level(s); multiple levels can be comma separated.");
        ops.addOption(null, "disagg-iml", true, "Enables disaggregation at the specified intensity measure level(s); multiple levels can be comma separated.");
        ops.addOption(null, "disagg-rps", false, "Enables disaggregation at the recurrence intervals. By default, those corresponding to 2% and 10% in 50 years (override with --return-periods).");
        ops.addOption(null, "disagg-max-dist", true, "Sets the maximum distance for disaggregation plots.");
        ops.addOption(null, "disagg-min-mag", true, "Sets the minimum magnitude for disaggregation plots.");
        ops.addOption(null, "disagg-max-mag", true, "Sets the maximum magnitude for disaggregation plots.");
        ops.addOption(null, "return-periods", true, "Sets custom return periods (in years) to highlight in plots (or use in disaggregations if --disagg-rps is supplied). Default are those corresponding to 2% and 10% probability in 50 years.");
        ops.addOption(null, "disagg-by-source", false, "Flag to enable disaggregation into source-specific hazard curves. This is automatically done if any of the traditional disaggregations are enabled, but can be enabled separately via this flag.");
        ops.addOption(null, "write-pdfs", false, "Flag to also write figures as PDFs. Plotting may take significantly longer if there are many sites, periods, and/or disaggregations.");
        return ops;
    }

    /*
     * Could not resolve type clashes
     */
    public static void main(String[] args) throws IOException {
        boolean[] blArray;
        Object csvName;
        int i;
        CustomReturnPeriod[] rps;
        double[] periods;
        File outputFile;
        File outputDir;
        System.setProperty("java.awt.headless", "true");
        CommandLine cmd = FaultSysTools.parseOptions(SolSiteHazardCalc.createOptions(), args, SolSiteHazardCalc.class);
        FaultSysTools.checkPrintHelp(null, cmd, SolSiteHazardCalc.class);
        File inputFile = new File(cmd.getOptionValue("input-file"));
        FaultSystemSolution sol = FaultSystemSolution.load(inputFile);
        String name = cmd.hasOption("name") ? cmd.getOptionValue("name") : SOL_NAME_DEFAULT;
        File compFile = null;
        FaultSystemSolution compSol = null;
        String compName = null;
        if (cmd.hasOption("compare-to")) {
            compFile = new File(cmd.getOptionValue("compare-to"));
            compSol = FaultSystemSolution.load(compFile);
            String string = compName = cmd.hasOption("comp-name") ? cmd.getOptionValue("comp-name") : COMP_SOL_NAME_DEFAULT;
        }
        if (cmd.hasOption("output-dir")) {
            Preconditions.checkArgument((!cmd.hasOption("output-file") ? 1 : 0) != 0, (Object)"Can't supply both --output-file and --output-dir");
            outputDir = new File(cmd.getOptionValue("output-dir"));
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
            outputFile = null;
        } else {
            Preconditions.checkArgument((boolean)cmd.hasOption("output-file"), (Object)"Must supply either --output-file or --output-dir");
            outputFile = new File(cmd.getOptionValue("output-file"));
            outputDir = null;
        }
        IncludeBackgroundOption mainGridOp = SolSiteHazardCalc.getGridOp(cmd, sol);
        IncludeBackgroundOption compGridOp = compSol == null ? null : SolSiteHazardCalc.getGridOp(cmd, compSol);
        Map<TectonicRegionType, AttenRelSupplier> gmmSuppliers = FaultSysHazardCalcSettings.getGMMs(cmd);
        if (gmmSuppliers.size() > 1) {
            GridSourceProvider prov;
            RupSetTectonicRegimes rupSetTRTs = sol.getRupSet().getModule(RupSetTectonicRegimes.class);
            EnumSet<TectonicRegionType> trts = rupSetTRTs == null ? EnumSet.of(TectonicRegionType.ACTIVE_SHALLOW) : EnumSet.copyOf(rupSetTRTs.getSet());
            if (mainGridOp == IncludeBackgroundOption.INCLUDE || mainGridOp == IncludeBackgroundOption.ONLY) {
                prov = sol.getGridSourceProvider();
                Preconditions.checkNotNull((Object)prov);
                trts.addAll(prov.getTectonicRegionTypes());
            }
            if (compGridOp == IncludeBackgroundOption.INCLUDE || compGridOp == IncludeBackgroundOption.ONLY) {
                prov = compSol.getGridSourceProvider();
                Preconditions.checkNotNull((Object)prov);
                trts.addAll(prov.getTectonicRegionTypes());
            }
            for (TectonicRegionType trt : trts) {
                Preconditions.checkState((boolean)gmmSuppliers.containsKey(trt), (String)"Solution has %s sources but we don't have a GMM for it", (Object)trt);
            }
            if (trts.size() < gmmSuppliers.size()) {
                for (TectonicRegionType trt : List.copyOf(gmmSuppliers.keySet())) {
                    if (trts.contains(trt)) continue;
                    gmmSuppliers.remove(trt);
                }
            }
        }
        SourceFilterManager sourceFilters = FaultSysHazardCalcSettings.getSourceFilters(cmd);
        double largestMaxDist = Double.NaN;
        double smallestMaxDist = Double.NaN;
        if (sourceFilters.isEnabled(SourceFilters.FIXED_DIST_CUTOFF)) {
            smallestMaxDist = largestMaxDist = sourceFilters.getFilterInstance(FixedDistanceCutoffFilter.class).getMaxDistance();
        }
        if (sourceFilters.isEnabled(SourceFilters.TRT_DIST_CUTOFFS)) {
            TectonicRegionDistCutoffFilter.TectonicRegionDistanceCutoffs cutoffs = sourceFilters.getFilterInstance(TectonicRegionDistCutoffFilter.class).getCutoffs();
            if (Double.isNaN(largestMaxDist)) {
                largestMaxDist = 0.0;
                smallestMaxDist = 1000.0;
            }
            for (TectonicRegionType trt : gmmSuppliers.keySet()) {
                largestMaxDist = Double.max(largestMaxDist, cutoffs.getCutoffDist(trt));
                smallestMaxDist = Double.min(smallestMaxDist, cutoffs.getCutoffDist(trt));
            }
        }
        if (Double.isNaN(largestMaxDist)) {
            smallestMaxDist = largestMaxDist = TectonicRegionType.ACTIVE_SHALLOW.defaultCutoffDist();
        }
        Map<TectonicRegionType, ScalarIMR> gmms0 = FaultSysHazardCalcSettings.getGmmInstances(gmmSuppliers);
        ArrayList<Site> sites = new ArrayList<Site>();
        if (cmd.hasOption("site-location")) {
            Preconditions.checkArgument((!cmd.hasOption("sites") ? 1 : 0) != 0, (Object)"Can't supply both --sites and --site-location");
            Preconditions.checkArgument((!cmd.hasOption("sites") ? 1 : 0) != 0, (Object)"Can't supply both --nehrpsites and --site-location");
            String locStr = cmd.getOptionValue("site-location");
            Preconditions.checkState((boolean)locStr.contains(","), (String)"Unexpected site location format, should be <lat>,<lon>, e.g.: 34,-118, supplied: %s", (Object)locStr);
            String[] locSplit = locStr.split(",");
            Preconditions.checkState((locSplit.length == 2 ? 1 : 0) != 0, (String)"Unexpected site location format, should be <lat>,<lon>, e.g.: 34,-118, supplied: %s", (Object)locStr);
            Location loc = new Location(Double.parseDouble(locSplit[0]), Double.parseDouble(locSplit[1]));
            Object siteName = cmd.hasOption("site-name") ? cmd.getOptionValue("site-name") : "Site (" + locStr + ")";
            Site site = new Site(loc, (String)siteName);
            SolSiteHazardCalc.addDefaultSiteParams(site, gmms0, cmd);
            sites.add(site);
        } else if (cmd.hasOption("nehrp-sites")) {
            Preconditions.checkArgument((!cmd.hasOption("sites") ? 1 : 0) != 0, (Object)"Can't supply both --nehrpsites and --sites");
            Region region = null;
            if (sol.getRupSet().hasModule(ModelRegion.class)) {
                region = sol.getRupSet().getModule(ModelRegion.class).getRegion();
            } else if (sol.getGridSourceProvider() != null) {
                region = sol.getGridSourceProvider().getGriddedRegion();
            }
            Region compRegion = null;
            if (compSol != null) {
                if (compSol.getRupSet().hasModule(ModelRegion.class)) {
                    compRegion = compSol.getRupSet().getModule(ModelRegion.class).getRegion();
                } else if (compSol.getGridSourceProvider() != null) {
                    compRegion = compSol.getGridSourceProvider().getGriddedRegion();
                }
            }
            for (NEHRP_TestCity nehrp : NEHRP_TestCity.values()) {
                boolean include;
                if (region == null) {
                    include = false;
                    block6: for (FaultSection sect : sol.getRupSet().getFaultSectionDataList()) {
                        for (Location loc : sect.getFaultTrace()) {
                            if (!(LocationUtils.horzDistanceFast(loc, nehrp.location()) < largestMaxDist)) continue;
                            include = true;
                            continue block6;
                        }
                    }
                    if (!include) {
                        continue;
                    }
                } else if (!region.contains(nehrp.location())) continue;
                if (compSol != null) {
                    if (compRegion == null) {
                        include = false;
                        block8: for (FaultSection sect : compSol.getRupSet().getFaultSectionDataList()) {
                            for (Location loc : sect.getFaultTrace()) {
                                if (!(LocationUtils.horzDistanceFast(loc, nehrp.location()) < largestMaxDist)) continue;
                                include = true;
                                continue block8;
                            }
                        }
                        if (!include) {
                            continue;
                        }
                    } else if (!compRegion.contains(nehrp.location())) continue;
                }
                Site site = new Site(nehrp.location(), nehrp.toString());
                SolSiteHazardCalc.addDefaultSiteParams(site, gmms0, cmd);
                sites.add(site);
            }
            sites.sort(new NamedComparator());
        } else {
            Preconditions.checkArgument((boolean)cmd.hasOption("sites"), (Object)"Must supply either --sites or --site-location");
            File csvFile = new File(cmd.getOptionValue("sites"));
            CSVFile<String> csv = CSVFile.readFile(csvFile, true);
            Preconditions.checkState((csv.getNumRows() > 1 ? 1 : 0) != 0, (String)"Expected at least 2 ros (1 header and at least 1 site), have %s", (int)csv.getNumRows());
            Preconditions.checkState((csv.getNumCols() >= 3 && csv.getNumCols() <= 6 ? 1 : 0) != 0, (String)"Expected between 3 and 6 columns, have %s", (int)csv.getNumCols());
            Preconditions.checkState((boolean)csv.get(0, 0).trim().toLowerCase().equals(NAME_HEADER.toLowerCase()), (String)"First header coulumn must be `%s`, got: %s", (Object)NAME_HEADER, (Object)csv.get(0, 0));
            Preconditions.checkState((boolean)csv.get(0, 1).trim().toLowerCase().equals(LAT_HEADER.toLowerCase()), (String)"Second header coulumn must be `%s`, got: %s", (Object)LAT_HEADER, (Object)csv.get(0, 1));
            Preconditions.checkState((boolean)csv.get(0, 2).trim().toLowerCase().equals(LON_HEADER.toLowerCase()), (String)"Third header coulumn must be `%s`, got: %s", (Object)LON_HEADER, (Object)csv.get(0, 2));
            int vsCol = -1;
            int z10Col = -1;
            int z25Col = -1;
            for (int col = 3; col < csv.getNumCols(); ++col) {
                String colName = csv.get(0, col).toLowerCase().trim();
                if (colName.equals(VS30_HEADER.toLowerCase())) {
                    Preconditions.checkState((vsCol < 0 ? 1 : 0) != 0, (Object)"Multiple Vs30 columns supplied.");
                    Preconditions.checkState((!cmd.hasOption("vs30") ? 1 : 0) != 0, (Object)"Can't supply Vs30 both in the site CSV file and via the command line");
                    vsCol = col;
                    continue;
                }
                if (colName.equals(Z10_HEADER.toLowerCase())) {
                    Preconditions.checkState((z10Col < 0 ? 1 : 0) != 0, (Object)"Multiple Z1.0 columns supplied.");
                    Preconditions.checkState((!cmd.hasOption("z10") ? 1 : 0) != 0, (Object)"Can't supply Z1.0 both in the site CSV file and via the command line");
                    z10Col = col;
                    continue;
                }
                if (colName.equals(Z25_HEADER.toLowerCase())) {
                    Preconditions.checkState((z25Col < 0 ? 1 : 0) != 0, (Object)"Multiple Z2.5 columns supplied.");
                    Preconditions.checkState((!cmd.hasOption("z25") ? 1 : 0) != 0, (Object)"Can't supply Z2.5 both in the site CSV file and via the command line");
                    z25Col = col;
                    continue;
                }
                throw new IllegalStateException("Unexpected column in header: " + csv.get(0, col));
            }
            for (int row = 1; row < csv.getNumRows(); ++row) {
                Site site = new Site(new Location(csv.getDouble(row, 1), csv.getDouble(row, 2)), csv.get(row, 0));
                SolSiteHazardCalc.addDefaultSiteParams(site, gmms0, cmd);
                if (vsCol >= 0 && site.containsParameter(VS30_HEADER)) {
                    SolSiteHazardCalc.setDoubleParam(site.getParameter(VS30_HEADER), csv.getDouble(row, vsCol));
                }
                if (z10Col >= 0 && site.containsParameter("Depth 1.0 km/sec")) {
                    SolSiteHazardCalc.setDoubleParam(site.getParameter("Depth 1.0 km/sec"), csv.getDouble(row, z10Col));
                }
                if (z25Col >= 0 && site.containsParameter("Depth 2.5 km/sec")) {
                    SolSiteHazardCalc.setDoubleParam(site.getParameter("Depth 2.5 km/sec"), csv.getDouble(row, z25Col));
                }
                sites.add(site);
            }
        }
        Preconditions.checkState((!sites.isEmpty() ? 1 : 0) != 0, (Object)"No sites supplied?");
        if (cmd.hasOption("periods")) {
            Preconditions.checkArgument((!cmd.hasOption("all-periods") ? 1 : 0) != 0, (Object)"Can't supply both --periods and --all-periods");
            String perStr = cmd.getOptionValue("periods");
            if (perStr.contains(",")) {
                String[] split = perStr.split(",");
                periods = new double[split.length];
                for (int p = 0; p < periods.length; ++p) {
                    periods[p] = Double.parseDouble(split[p]);
                }
            } else {
                periods = new double[]{Double.parseDouble(perStr)};
            }
        } else {
            Preconditions.checkArgument((boolean)cmd.hasOption("all-periods"), (Object)"Must supply either --periods or --all-periods");
            ArrayList<Double> periodsList = null;
            for (ScalarIMR gmm0 : gmms0.values()) {
                ArrayList<Double> gmmPeriodsList = new ArrayList<Double>();
                if (gmm0.getSupportedIntensityMeasures().containsParameter("PGV")) {
                    gmmPeriodsList.add(-1.0);
                }
                if (gmm0.getSupportedIntensityMeasures().containsParameter("PGA")) {
                    gmmPeriodsList.add(0.0);
                }
                if (gmm0.getSupportedIntensityMeasures().containsParameter("SA")) {
                    SA_Param saParam = (SA_Param)gmm0.getSupportedIntensityMeasures().getParameter("SA");
                    gmmPeriodsList.addAll(saParam.getPeriodParam().getSupportedPeriods());
                }
                if (periodsList == null) {
                    periodsList = gmmPeriodsList;
                    continue;
                }
                periodsList.retainAll(gmmPeriodsList);
            }
            Collections.sort(periodsList);
            periods = Doubles.toArray(periodsList);
        }
        Preconditions.checkState((periods.length > 0 ? 1 : 0) != 0, (Object)"No periods specified?");
        DiscretizedFunc[] periodXVals = new DiscretizedFunc[periods.length];
        IMT_Info imtInfo = new IMT_Info();
        for (int p = 0; p < periods.length; ++p) {
            if (periods[p] == -1.0) {
                periodXVals[p] = imtInfo.getDefaultHazardCurve("PGV");
                continue;
            }
            if (periods[p] == 0.0) {
                periodXVals[p] = imtInfo.getDefaultHazardCurve("PGA");
                continue;
            }
            Preconditions.checkState((periods[p] > 0.0 ? 1 : 0) != 0, (String)"Unexpected period: %s", (Object)periods[p]);
            periodXVals[p] = imtInfo.getDefaultHazardCurve("SA");
        }
        int numCurves = sites.size() * periods.length;
        int threads = Integer.min(FaultSysTools.getNumThreads(cmd), numCurves);
        if (threads == 1) {
            SurfaceCachingPolicy.force(SurfaceCachingPolicy.CacheTypes.SINGLE);
        } else if (!THREAD_LOCAL_ERFS) {
            SurfaceCachingPolicy.force(SurfaceCachingPolicy.CacheTypes.THREAD_LOCAL);
        }
        double duration = cmd.hasOption("duration") ? Double.parseDouble(cmd.getOptionValue("duration")) : 1.0;
        System.out.println("Building ERF for " + name);
        GriddedSeismicitySettings griddedSettings = GriddedSeismicitySettings.DEFAULT;
        if (mainGridOp != IncludeBackgroundOption.EXCLUDE || compGridOp != null && compGridOp != IncludeBackgroundOption.EXCLUDE) {
            griddedSettings = FaultSysHazardCalcSettings.getGridSeisSettings(cmd);
            System.out.println("Gridded seismicity settings: " + String.valueOf(griddedSettings));
        }
        FaultSystemSolutionERF erf = SolSiteHazardCalc.buildERF(sol, mainGridOp, griddedSettings, duration);
        ArrayList<HazardCalcThread> calcThreads = new ArrayList<HazardCalcThread>(threads);
        for (int i2 = 0; i2 < threads; ++i2) {
            HazardCurveCalculator calc = new HazardCurveCalculator(sourceFilters);
            calcThreads.add(new HazardCalcThread(calc, i2 == 0 ? gmms0 : FaultSysHazardCalcSettings.getGmmInstances(gmmSuppliers)));
        }
        List<DiscretizedFunc[]> curves = SolSiteHazardCalc.calcHazardCurves(calcThreads, sites, erf, periods, periodXVals);
        for (int p = 0; p < periods.length; ++p) {
            File csvFile;
            if (outputDir == null) {
                csvFile = outputFile;
                if (periods.length > 1) {
                    String prefix = csvFile.getName();
                    if (prefix.toLowerCase().endsWith(".csv")) {
                        prefix = prefix.substring(0, prefix.toLowerCase().indexOf(".csv"));
                    }
                    csvFile = new File(csvFile.getParentFile(), SolHazardMapCalc.getCSV_FileName(prefix, periods[p]));
                }
            } else {
                csvFile = new File(outputDir, SolHazardMapCalc.getCSV_FileName("curves", periods[p]));
            }
            SolSiteHazardCalc.writeCurvesCSV(csvFile, SolSiteHazardCalc.extractPeriodCurves(curves, p), sites);
        }
        FaultSystemSolutionERF compERF = null;
        List<DiscretizedFunc[]> compCurves = null;
        if (compSol != null) {
            System.out.println("Building ERF for " + compName);
            compERF = SolSiteHazardCalc.buildERF(compSol, compGridOp, griddedSettings, duration);
            ArrayList<HazardCalcThread> compCalcThreads = new ArrayList<HazardCalcThread>(threads);
            for (int i3 = 0; i3 < threads; ++i3) {
                compCalcThreads.add(new HazardCalcThread(((HazardCalcThread)calcThreads.get((int)i3)).calc, ((HazardCalcThread)calcThreads.get((int)i3)).gmms));
            }
            compCurves = SolSiteHazardCalc.calcHazardCurves(compCalcThreads, sites, compERF, periods, periodXVals);
            for (int p = 0; p < periods.length; ++p) {
                File csvFile;
                if (outputDir == null) {
                    csvFile = outputFile;
                    if (periods.length > 1) {
                        Object prefix = csvFile.getName();
                        if (((String)prefix).toLowerCase().endsWith(".csv")) {
                            prefix = ((String)prefix).substring(0, ((String)prefix).toLowerCase().indexOf(".csv"));
                        }
                        prefix = (String)prefix + "_comp";
                        csvFile = new File(csvFile.getParentFile(), SolHazardMapCalc.getCSV_FileName((String)prefix, periods[p]));
                    }
                } else {
                    csvFile = new File(outputDir, SolHazardMapCalc.getCSV_FileName("comp_curves", periods[p]));
                }
                SolSiteHazardCalc.writeCurvesCSV(csvFile, SolSiteHazardCalc.extractPeriodCurves(compCurves, p), sites);
            }
        }
        if (cmd.hasOption("return-periods")) {
            double[] rpYears;
            String rpStr = cmd.getOptionValue("return-periods");
            if (rpStr.contains(",")) {
                String[] split = rpStr.split(",");
                rpYears = new double[split.length];
                for (int p = 0; p < periods.length; ++p) {
                    rpYears[p] = Double.parseDouble(split[p]);
                }
            } else {
                rpYears = new double[]{Double.parseDouble(rpStr)};
            }
            rps = new CustomReturnPeriod[rpYears.length];
            for (int r = 0; r < rps.length; ++r) {
                rps[r] = new CustomReturnPeriod(rpYears[r], erf.getTimeSpan().getDuration());
            }
        } else {
            rps = new CustomReturnPeriod[]{new CustomReturnPeriod(SolHazardMapCalc.ReturnPeriods.TWO_IN_50, erf.getTimeSpan().getDuration()), new CustomReturnPeriod(SolHazardMapCalc.ReturnPeriods.TEN_IN_50, erf.getTimeSpan().getDuration())};
        }
        boolean doSpectra = cmd.hasOption("spectra");
        ArrayList<List<DiscretizedFunc>> siteSpectra = null;
        File[] spectraFiles = null;
        ArrayList<List<DiscretizedFunc>> compSiteSpectra = null;
        File[] compSpectraFiles = null;
        if (doSpectra) {
            String prefix;
            File csvFile;
            List<DiscretizedFunc> spectra;
            CustomReturnPeriod rp;
            int r;
            int numSA = 0;
            for (int p = 0; p < periods.length; ++p) {
                if (!(periods[p] > 0.0)) continue;
                ++numSA;
            }
            Preconditions.checkState((numSA > 1 ? 1 : 0) != 0, (Object)"Must have more than 1 SA periods to calculate and plot spectra");
            siteSpectra = new ArrayList<List<DiscretizedFunc>>();
            spectraFiles = new File[rps.length];
            for (r = 0; r < rps.length; ++r) {
                rp = rps[r];
                spectra = SolSiteHazardCalc.calcSpectra(curves, periods, rp);
                siteSpectra.add(spectra);
                if (outputDir == null) {
                    csvFile = outputFile;
                    prefix = csvFile.getName();
                    if (prefix.toLowerCase().endsWith(".csv")) {
                        prefix = prefix.substring(0, prefix.toLowerCase().indexOf(".csv"));
                    }
                    csvFile = new File(csvFile.getParentFile(), prefix + "_spectra_" + rp.prefix + ".csv");
                } else {
                    csvFile = new File(outputDir, "spectra_" + rp.prefix + ".csv");
                }
                spectraFiles[r] = csvFile;
                SolSiteHazardCalc.writeCurvesCSV(csvFile, spectra, sites);
            }
            if (compSol != null) {
                compSiteSpectra = new ArrayList<List<DiscretizedFunc>>();
                compSpectraFiles = new File[rps.length];
                for (r = 0; r < rps.length; ++r) {
                    rp = rps[r];
                    spectra = SolSiteHazardCalc.calcSpectra(compCurves, periods, rp);
                    compSiteSpectra.add(spectra);
                    if (outputDir == null) {
                        csvFile = outputFile;
                        prefix = csvFile.getName();
                        if (prefix.toLowerCase().endsWith(".csv")) {
                            prefix = prefix.substring(0, prefix.toLowerCase().indexOf(".csv"));
                        }
                        csvFile = new File(csvFile.getParentFile(), prefix + "_comp_spectra_" + rp.prefix + ".csv");
                    } else {
                        csvFile = new File(outputDir, "comp_spectra_" + rp.prefix + ".csv");
                    }
                    compSpectraFiles[r] = csvFile;
                    SolSiteHazardCalc.writeCurvesCSV(csvFile, spectra, sites);
                }
            }
        }
        int numDisagg = 0;
        double[] disaggProbs = null;
        Object firstDisaggName = null;
        if (cmd.hasOption("disagg-rps")) {
            disaggProbs = new double[rps.length];
            for (int r = 0; r < rps.length; ++r) {
                disaggProbs[r] = rps[r].prob;
            }
            numDisagg += disaggProbs.length;
            firstDisaggName = rps[0].label;
        }
        if (cmd.hasOption("disagg-prob")) {
            double[] newDisaggProbs;
            String dStr = cmd.getOptionValue("disagg-prob");
            if (dStr.contains(",")) {
                String[] split = dStr.split(",");
                newDisaggProbs = new double[split.length];
                for (i = 0; i < newDisaggProbs.length; ++i) {
                    newDisaggProbs[i] = Double.parseDouble(split[i]);
                }
            } else {
                newDisaggProbs = new double[]{Double.parseDouble(dStr)};
            }
            numDisagg += newDisaggProbs.length;
            if (disaggProbs != null) {
                int prevNum = disaggProbs.length;
                disaggProbs = Arrays.copyOf(disaggProbs, disaggProbs.length + newDisaggProbs.length);
                System.arraycopy(newDisaggProbs, 0, disaggProbs, prevNum, newDisaggProbs.length);
            } else {
                disaggProbs = newDisaggProbs;
            }
            if (firstDisaggName == null) {
                firstDisaggName = "P=" + (float)disaggProbs[0];
            }
        }
        double[] disaggIMLs = null;
        if (cmd.hasOption("disagg-iml")) {
            String dStr = cmd.getOptionValue("disagg-iml");
            if (dStr.contains(",")) {
                String[] split = dStr.split(",");
                disaggIMLs = new double[split.length];
                for (i = 0; i < disaggIMLs.length; ++i) {
                    disaggIMLs[i] = Double.parseDouble(split[i]);
                }
            } else {
                disaggIMLs = new double[]{Double.parseDouble(dStr)};
            }
            numDisagg += disaggIMLs.length;
            if (firstDisaggName == null) {
                firstDisaggName = "IML=" + (float)disaggIMLs[0];
            }
        }
        IncludeBackgroundOption gridSeisOp = (IncludeBackgroundOption)((Object)erf.getParameter("Background Seismicity").getValue());
        List<DisaggResult[][]> disaggResults = null;
        boolean disaggBySourceOnly = false;
        if (cmd.hasOption("disagg-by-source") && numDisagg == 0) {
            disaggBySourceOnly = true;
            disaggProbs = new double[]{rps[0].prob};
            numDisagg = disaggProbs.length;
        }
        if (numDisagg > 0) {
            double distDelta;
            double minDist;
            double disaggMaxDist;
            System.out.println("Disaggregating at " + numDisagg + " levels per site/period");
            double minMag = Double.POSITIVE_INFINITY;
            double maxMag = Double.NEGATIVE_INFINITY;
            for (ProbEqkSource source : erf) {
                for (ProbEqkRupture rup : source) {
                    double mag = rup.getMag();
                    minMag = Math.min(minMag, mag);
                    maxMag = Math.max(maxMag, mag);
                }
            }
            minMag = Math.max(5.0, minMag);
            maxMag = Math.max(minMag, maxMag);
            if (cmd.hasOption("disagg-min-mag")) {
                minMag = Double.parseDouble("disagg-min-mag");
            }
            if (cmd.hasOption("disagg-max-mag")) {
                maxMag = Double.parseDouble("disagg-max-mag");
            }
            EvenlyDiscretizedFunc magRange = SolSiteHazardCalc.disaggRange(minMag, maxMag, 0.5, false);
            double d = disaggMaxDist = cmd.hasOption("disagg-max-dist") ? Double.parseDouble(cmd.getOptionValue("disagg-max-dist")) : Math.min(largestMaxDist, 200.0);
            if (disaggMaxDist > 150.0) {
                minDist = 10.0;
                distDelta = 20.0;
            } else {
                minDist = 5.0;
                distDelta = 10.0;
            }
            EvenlyDiscretizedFunc distRange = SolSiteHazardCalc.disaggRange(minDist, disaggMaxDist, distDelta, true);
            ArrayList<DisaggCalcThread> disaggThreads = new ArrayList<DisaggCalcThread>(threads);
            HazardCurveCalculator curveCalc = new HazardCurveCalculator(sourceFilters);
            ParameterList calcParams = curveCalc.getAdjustableParams();
            for (int i4 = 0; i4 < threads; ++i4) {
                DisaggregationCalculator calc = new DisaggregationCalculator();
                calc.setMagRange(magRange.getMinX(), magRange.size(), magRange.getDelta());
                calc.setDistanceRange(distRange.getMinX(), distRange.size(), distRange.getDelta());
                disaggThreads.add(new DisaggCalcThread(calc, sourceFilters.getEnabledFilters(), calcParams, ((HazardCalcThread)calcThreads.get((int)i4)).gmms, disaggProbs, disaggIMLs));
            }
            disaggResults = SolSiteHazardCalc.calcDisagg(disaggThreads, sites, erf, periods, curves);
            if (outputDir == null) {
                String prefix = outputFile.getName();
                if (prefix.toLowerCase().endsWith(".csv")) {
                    prefix = prefix.substring(0, prefix.toLowerCase().indexOf(".csv"));
                }
                SolSiteHazardCalc.writeDisaggCSVs(outputDir, prefix + "_disagg", sites, periods, disaggResults, rps);
            } else {
                SolSiteHazardCalc.writeDisaggCSVs(outputDir, "disagg", sites, periods, disaggResults, rps);
            }
        }
        if (outputDir == null) {
            System.exit(0);
        }
        System.out.println("Writing report");
        final File resourcesDir = new File(outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        int perWrap = periods.length > 6 ? 4 : (periods.length > 4 ? 3 : 2);
        ArrayList<String> lines = new ArrayList<String>();
        final boolean writePDFs = cmd.hasOption("write-pdfs");
        lines.add("# " + name + " Site Hazard Calculations");
        lines.add("");
        ArrayList plotFutures = new ArrayList();
        GeographicMapMaker mapMaker = new GeographicMapMaker(sol.getRupSet().getFaultSectionDataList());
        ExecutorService exec = ExecutorUtils.newBlockingThreadPool(threads, Integer.min(threads * 2, threads + 4));
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        plotFutures.add(SolSiteHazardCalc.plotSitesMap(resourcesDir, "sites_map", mapMaker, sites, smallestMaxDist, exec, writePDFs, true));
        table.addLine("![Sites Map](" + resourcesDir.getName() + "/sites_map.png)");
        table.addLine(GeographicMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", resourcesDir.getName() + "/sites_map.geojson") + " [Download GeoJSON](" + resourcesDir.getName() + "/sites_map.geojson)");
        lines.addAll(table.build());
        if (compSol == null) {
            lines.add("Hazard calculations for _" + name + "_:");
            lines.add("");
            if (periods.length > 1) {
                if (doSpectra) {
                    lines.add("__Curve CSV Files:__");
                    lines.add("");
                }
                table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                for (double period : periods) {
                    table.addColumn(MarkdownUtils.boldCentered(SolSiteHazardCalc.periodLabel(period)));
                }
                table.finalizeLine().initNewLine();
                for (double period : periods) {
                    csvName = SolHazardMapCalc.getCSV_FileName("curves", period);
                    table.addColumn("[_" + (String)csvName + "_](" + (String)csvName + ")");
                }
                table.finalizeLine();
                lines.addAll(table.wrap(5, 0).build());
            } else {
                String csvName2 = SolHazardMapCalc.getCSV_FileName("curves", periods[0]);
                lines.add("Curve CSV File: [_" + (String)csvName2 + "_](" + (String)csvName2 + ")");
            }
            lines.add("");
        } else {
            lines.add("Hazard calculations for _" + name + "_ compared to _" + compName + "_:");
            lines.add("");
            if (doSpectra) {
                lines.add("__Curve CSV Files:__");
                lines.add("");
            }
            table = MarkdownUtils.tableBuilder();
            if (periods.length == 1) {
                table.addLine(name, compName);
            } else {
                table.addLine("", name, compName);
            }
            for (Object period : (String)periods) {
                table.initNewLine();
                if (periods.length > 1) {
                    table.addColumn("__" + SolSiteHazardCalc.periodLabel((double)period) + "__");
                }
                csvName = SolHazardMapCalc.getCSV_FileName("curves", (double)period);
                table.addColumn("[_" + (String)csvName + "_](" + (String)csvName + ")");
                csvName = "comp_" + (String)csvName;
                table.addColumn("[_" + (String)csvName + "_](" + (String)csvName + ")");
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
        }
        if (doSpectra) {
            int r;
            lines.add("__Spectra CSV Files:__");
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            if (compSol != null) {
                table.addColumn("");
            }
            for (r = 0; r < rps.length; ++r) {
                table.addColumn(rps[r].label);
            }
            table.finalizeLine();
            table.initNewLine();
            if (compSol != null) {
                table.addColumn("__" + name + "__");
            }
            for (r = 0; r < rps.length; ++r) {
                table.addColumn("[_" + spectraFiles[r].getName() + "_](" + spectraFiles[r].getName() + ")");
            }
            table.finalizeLine();
            if (compSol != null) {
                table.initNewLine();
                table.addColumn("__" + compName + "__");
                for (r = 0; r < rps.length; ++r) {
                    table.addColumn("[_" + spectraFiles[r].getName() + "_](" + spectraFiles[r].getName() + ")");
                }
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
        }
        int tocIndex = lines.size();
        String topLink = "_[(top)](#table-of-contents)_";
        lines.add("## Calculation Parameters");
        lines.add(topLink);
        lines.add("");
        table = MarkdownUtils.tableBuilder();
        table.addLine("_Calculation Parameters_", "_Values_");
        for (TectonicRegionType trt : gmms0.keySet()) {
            ScalarIMR gmm = gmms0.get(trt);
            if (gmms0.size() > 1) {
                table.addLine("_" + String.valueOf(trt) + "_", "");
            }
            SolSiteHazardCalc.addTRTParamLines(table, trt, gmm, sourceFilters);
        }
        Object gridSeisStr = gridSeisOp.toString();
        if (compERF != null && !compERF.getParameter("Background Seismicity").getValue().equals((Object)gridSeisOp)) {
            gridSeisStr = name + ": " + String.valueOf((Object)gridSeisOp) + ", " + compName + ": " + String.valueOf(compERF.getParameter("Background Seismicity").getValue());
        }
        table.addLine(new String[]{"Gridded Seismicity", gridSeisStr});
        table.addLine(new String[]{"Duration", duration == 1.0 ? "1 year" : oDF.format(duration) + " years"});
        lines.addAll(table.build());
        lines.add("");
        if (compSol == null) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = false;
        } else {
            boolean[] blArray3 = new boolean[2];
            blArray3[0] = false;
            blArray = blArray3;
            blArray3[1] = true;
        }
        boolean[] isComps = blArray;
        for (Object isComp : (ScalarIMR)isComps) {
            FaultSystemSolution mySol;
            String myName = isComp != false ? compName : name;
            FaultSystemSolution faultSystemSolution = mySol = isComp != false ? compSol : sol;
            if (isComp != false) {
                if (myName.equals(COMP_SOL_NAME_DEFAULT)) {
                    lines.add("## Comparison Solution Metadata");
                } else {
                    lines.add("## Comparison Solution (" + (String)myName + ") Metadata");
                }
            } else if (myName.equals(SOL_NAME_DEFAULT)) {
                lines.add("## Solution Metadata");
            } else {
                lines.add("## Solution (" + (String)myName + ") Metadata");
            }
            lines.add(topLink);
            lines.add("");
            GeneralInfoPlot plot = new GeneralInfoPlot();
            plot.setSubHeading("###");
            ReportMetadata meta = null;
            lines.addAll(plot.plot(mySol.getRupSet(), mySol, meta, resourcesDir, resourcesDir.getName(), topLink));
            lines.add("");
        }
        int numDisaggSources = 10;
        ProgressTrack siteTrack = new ProgressTrack(sites.size());
        CPT contribCPT = null;
        EnumMap<TectonicRegionType, Color> trtColors = null;
        if (numDisagg > 0) {
            contribCPT = GMT_CPT_Files.CATEGORICAL_TAB10_NOGRAY.instance();
            if (gmmSuppliers.keySet().size() > 1) {
                trtColors = new EnumMap<TectonicRegionType, Color>(TectonicRegionType.class);
                for (TectonicRegionType trt : gmmSuppliers.keySet()) {
                    Color color = ((CPTVal)contribCPT.remove((int)0)).minColor;
                    trtColors.put(trt, color);
                }
            }
        }
        PlotLineType griddedContribPLT = gridSeisOp == IncludeBackgroundOption.INCLUDE ? PlotLineType.DASHED : PlotLineType.SOLID;
        PlotLineType faultContribPLT = PlotLineType.SOLID;
        for (int s = 0; s < sites.size(); ++s) {
            int p;
            boolean[] blArray4;
            int n;
            Site site = (Site)sites.get(s);
            String prefix = FileNameUtils.simplify(site.getName());
            while (prefix.contains("__")) {
                prefix = prefix.replace("__", "_");
            }
            if (sites.size() == 1) {
                lines.add("## Results");
            } else {
                lines.add("## " + site.getName());
            }
            lines.add(topLink);
            lines.add("");
            if (sites.size() > 1) {
                plotFutures.add(SolSiteHazardCalc.plotSiteMap(resourcesDir, prefix + "_map", mapMaker, site, smallestMaxDist, exec, writePDFs));
                lines.add("![Site Map](" + resourcesDir.getName() + "/" + prefix + "_map.png)");
                lines.add("");
            }
            table = MarkdownUtils.tableBuilder();
            table.addLine("_Parameter_", "_Value_");
            table.addLine("__Location__", (float)site.getLocation().lat + ", " + (float)site.getLocation().lon);
            for (Parameter<?> param : site) {
                table.addLine("__" + param.getName() + "__", SolSiteHazardCalc.paramValStr(param));
            }
            lines.addAll(table.build());
            lines.add("");
            if (doSpectra) {
                lines.add("### " + site.getName() + " Hazard Spectra");
                lines.add(topLink);
                lines.add("");
                table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                CustomReturnPeriod[] customReturnPeriodArray = rps;
                int param = customReturnPeriodArray.length;
                for (n = 0; n < param; ++n) {
                    CustomReturnPeriod rp = customReturnPeriodArray[n];
                    table.addColumn(rp.label);
                }
                table.finalizeLine();
                table.initNewLine();
                for (int r = 0; r < rps.length; ++r) {
                    String spectraPrefix = "spectra_" + prefix + "_" + rps[r].prefix;
                    plotFutures.add(SolSiteHazardCalc.plotSpectra(resourcesDir, spectraPrefix, rps[r], site.getName(), (DiscretizedFunc)((List)siteSpectra.get(r)).get(s), name, compSiteSpectra == null ? null : (DiscretizedFunc)((List)compSiteSpectra.get(r)).get(s), compName, exec, writePDFs));
                    table.addColumn("![" + rps[r].label + " Spectra](" + resourcesDir.getName() + "/" + spectraPrefix + ".png)");
                }
                table.finalizeLine();
                lines.addAll(table.wrap(perWrap, 0).build());
                lines.add("");
            }
            lines.add("### " + site.getName() + " Hazard Curves");
            lines.add(topLink);
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            double[] r = periods;
            int spectraPrefix = r.length;
            for (n = 0; n < spectraPrefix; ++n) {
                double period = r[n];
                table.addColumn(MarkdownUtils.boldCentered(SolSiteHazardCalc.periodLabel(period)));
            }
            table.finalizeLine();
            table.initNewLine();
            for (int p2 = 0; p2 < periods.length; ++p2) {
                String curvePrefix = "curves_" + prefix + "_" + SolSiteHazardCalc.periodPrefix(periods[p2]);
                plotFutures.add(SolSiteHazardCalc.plotCurve(resourcesDir, curvePrefix, periods[p2], site.getName(), duration, rps, curves.get(s)[p2], name, compCurves == null ? null : compCurves.get(s)[p2], compName, exec, writePDFs));
                table.addColumn("![" + SolSiteHazardCalc.periodLabel(periods[p2]) + " Curves](" + resourcesDir.getName() + "/" + curvePrefix + ".png)");
            }
            table.finalizeLine();
            lines.addAll(table.wrap(perWrap, 0).build());
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            table.addColumn("Return Period");
            for (double period : periods) {
                table.addColumn(SolSiteHazardCalc.periodLabel(period));
            }
            table.finalizeLine();
            if (compSol == null) {
                boolean[] blArray5 = new boolean[1];
                blArray4 = blArray5;
                blArray5[0] = false;
            } else {
                boolean[] blArray6 = new boolean[2];
                blArray6[0] = false;
                blArray4 = blArray6;
                blArray6[1] = true;
            }
            boolean[] comps = blArray4;
            CustomReturnPeriod[] curvePrefix = rps;
            n = curvePrefix.length;
            for (int period = 0; period < n; ++period) {
                CustomReturnPeriod rp = curvePrefix[period];
                if (compSol != null) {
                    table.initNewLine();
                    table.addColumn("__" + rp.label + "__");
                    for (int p3 = 0; p3 < periods.length; ++p3) {
                        double val = SolSiteHazardCalc.curveVal(curves.get(s)[p3], rp);
                        double compVal = SolSiteHazardCalc.curveVal(compCurves.get(s)[p3], rp);
                        double pDiff = 100.0 * (val - compVal) / compVal;
                        String str = oDF.format(pDiff) + "%";
                        if (pDiff >= 0.0) {
                            str = "+" + str;
                        }
                        table.addColumn("_(" + str + ")_");
                    }
                }
                for (boolean isComp : comps) {
                    table.initNewLine();
                    if (compSol != null) {
                        table.addColumn("_" + (isComp ? compName : name) + "_");
                    } else {
                        table.addColumn("__" + rp.label + "__");
                    }
                    for (p = 0; p < periods.length; ++p) {
                        DiscretizedFunc curve = isComp ? compCurves.get(s)[p] : curves.get(s)[p];
                        double val = SolSiteHazardCalc.curveVal(curve, rp);
                        table.addColumn((float)val + " " + SolSiteHazardCalc.periodUnits(periods[p]));
                    }
                    table.finalizeLine();
                }
            }
            lines.addAll(table.build());
            lines.add("");
            if (numDisagg > 0) {
                String sourceTypeStr;
                boolean[] doSourceTypes;
                DisaggResult[][] results = disaggResults.get(s);
                if (disaggBySourceOnly) {
                    lines.add("### " + site.getName() + " Source Contribution Curves");
                    lines.add(topLink);
                    lines.add("");
                } else {
                    lines.add("### " + site.getName() + " Disaggregations");
                    lines.add(topLink);
                    lines.add("");
                    lines.add("#### " + site.getName() + " Source Contribution Curves");
                    lines.add(topLink);
                    lines.add("");
                }
                int maxNumContribs = 5;
                if (gridSeisOp == IncludeBackgroundOption.INCLUDE || gmmSuppliers.size() > 1) {
                    doSourceTypes = new boolean[]{false, true};
                    sourceTypeStr = "source and source type";
                } else {
                    doSourceTypes = new boolean[]{false};
                    sourceTypeStr = "source";
                }
                String varyStr = periods.length > 1 ? " Colors and order vary for each spectral period." : "";
                Object gridStr = "";
                if (gridSeisOp == IncludeBackgroundOption.INCLUDE) {
                    gridStr = " Gridded seismicity sources are plotted with " + griddedContribPLT.toString().toLowerCase() + " lines and fault sources with " + faultContribPLT.toString().toLowerCase() + " lines.";
                }
                lines.add("This section includes hazard curves disaggregated by " + sourceTypeStr + ". At most " + maxNumContribs + " individual fault sources are included in order of their " + (String)firstDisaggName + " contribution." + (String)gridStr + varyStr);
                lines.add("");
                table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                for (double period : periods) {
                    table.addColumn(MarkdownUtils.boldCentered(SolSiteHazardCalc.periodLabel(period)));
                }
                table.finalizeLine();
                Object[] objectArray = doSourceTypes;
                int isComp = objectArray.length;
                for (p = 0; p < isComp; ++p) {
                    double doSourceType = objectArray[p];
                    if (doSourceTypes.length > 1) {
                        table.initNewLine();
                        table.addColumn(doSourceType != false ? "__Aggregated by Source Type__" : "__Aggregated by Source__");
                        for (int p4 = 1; p4 < periods.length; ++p4) {
                            table.addColumn("");
                        }
                        table.finalizeLine();
                    }
                    table.initNewLine();
                    ArrayList<String> csvLinks = new ArrayList<String>();
                    for (int p5 = 0; p5 < periods.length; ++p5) {
                        PlotLineType plt;
                        List<DisaggregationSourceRuptureInfo> consolidated;
                        DisaggResult result = results[p5][0];
                        ArrayList<DiscretizedFunc> contribCurves = new ArrayList<DiscretizedFunc>();
                        ArrayList<PlotCurveCharacterstics> contribChars = new ArrayList<PlotCurveCharacterstics>();
                        String disaggPrefix = "disagg_contrib_" + prefix + "_" + SolSiteHazardCalc.periodPrefix(periods[p5]);
                        if (doSourceType != false) {
                            consolidated = new SolutionDisaggSourceTypeConsolidator(erf).apply(result.sourceInfo);
                            disaggPrefix = disaggPrefix + "_sourceType";
                            int cptIndex = 0;
                            for (DisaggregationSourceRuptureInfo info : consolidated) {
                                PlotCurveCharacterstics consolidatedChar;
                                DiscretizedFunc consolidatedCurve = SolSiteHazardCalc.toLinear(info.getExceedProbs());
                                String type = info.getName();
                                consolidatedCurve.setName(type);
                                if (type.equals("All Fault Sources")) {
                                    consolidatedChar = new PlotCurveCharacterstics(faultContribPLT, 3.0f, Color.DARK_GRAY);
                                } else if (type.equals("All Gridded Sources")) {
                                    consolidatedChar = new PlotCurveCharacterstics(griddedContribPLT, 3.0f, Color.DARK_GRAY);
                                } else {
                                    Color color = null;
                                    if (trtColors != null) {
                                        for (TectonicRegionType trt : trtColors.keySet()) {
                                            if (!type.contains(trt.toString())) continue;
                                            color = (Color)trtColors.get(trt);
                                            break;
                                        }
                                    }
                                    if (color == null) {
                                        color = ((CPTVal)contribCPT.get((int)(cptIndex++ % contribCPT.size()))).minColor;
                                    }
                                    plt = type.startsWith("Gridded Sources, ") ? griddedContribPLT : faultContribPLT;
                                    consolidatedChar = new PlotCurveCharacterstics(plt, 2.0f, color);
                                }
                                contribCurves.add(consolidatedCurve);
                                contribChars.add(consolidatedChar);
                            }
                        } else {
                            String type;
                            DiscretizedFunc consolidatedCurve;
                            consolidated = new ArrayList<DisaggregationSourceRuptureInfo>(result.consolidatedSourceInfo);
                            ArrayList<DisaggregationSourceRuptureInfo> consolidatedGridded = new ArrayList<DisaggregationSourceRuptureInfo>();
                            int c = consolidated.size();
                            while (--c >= 0) {
                                DisaggregationSourceRuptureInfo contrib = consolidated.get(c);
                                if (contrib.getRate() == 0.0) {
                                    consolidated.remove(c);
                                    continue;
                                }
                                if (contrib.getId() >= 0) continue;
                                consolidated.remove(c);
                                consolidatedGridded.add(contrib);
                            }
                            DisaggregationSourceRuptureInfo other = null;
                            if (consolidated.size() > maxNumContribs) {
                                Object orig2;
                                List<DisaggregationSourceRuptureInfo> nuclConsolidated = result.consolidatedNucleationSourceInfo;
                                HashSet<Integer> prevParents = new HashSet<Integer>();
                                consolidated = consolidated.subList(0, maxNumContribs);
                                for (Object orig2 : consolidated) {
                                    if (((DisaggregationSourceRuptureInfo)orig2).getId() < 0) continue;
                                    prevParents.add(((DisaggregationSourceRuptureInfo)orig2).getId());
                                }
                                ArrayList<DisaggregationSourceRuptureInfo> otherSources = new ArrayList<DisaggregationSourceRuptureInfo>();
                                orig2 = nuclConsolidated.iterator();
                                while (orig2.hasNext()) {
                                    DisaggregationSourceRuptureInfo nuclSect = (DisaggregationSourceRuptureInfo)orig2.next();
                                    if (nuclSect.getId() < 0 || prevParents.contains(nuclSect.getId())) continue;
                                    otherSources.add(nuclSect);
                                }
                                other = DisaggregationSourceRuptureInfo.consolidate(otherSources, -1, "Other Faults");
                            }
                            int cptIndex = 0;
                            for (int i5 = 0; i5 < consolidated.size(); ++i5) {
                                DisaggregationSourceRuptureInfo info = consolidated.get(i5);
                                consolidatedCurve = info.getExceedProbs();
                                type = info.getName();
                                consolidatedCurve.setName(type);
                                plt = type.equals("Gridded Sources") || type.startsWith("Gridded Sources, ") ? griddedContribPLT : faultContribPLT;
                                Color color = null;
                                if (trtColors != null) {
                                    for (TectonicRegionType trt : trtColors.keySet()) {
                                        if (!type.contains(trt.toString())) continue;
                                        color = (Color)trtColors.get(trt);
                                        break;
                                    }
                                }
                                if (color == null) {
                                    color = ((CPTVal)contribCPT.get((int)(cptIndex++ % contribCPT.size()))).minColor;
                                }
                                contribCurves.add(SolSiteHazardCalc.toLinear(consolidatedCurve));
                                contribChars.add(new PlotCurveCharacterstics(plt, 2.0f, color));
                            }
                            if (other != null) {
                                DiscretizedFunc otherCurve = other.getExceedProbs();
                                otherCurve.setName(other.getName());
                                contribCurves.add(SolSiteHazardCalc.toLinear(otherCurve));
                                contribChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Colors.tab_grey));
                            }
                            if (!consolidatedGridded.isEmpty()) {
                                for (DisaggregationSourceRuptureInfo info : consolidatedGridded) {
                                    consolidatedCurve = info.getExceedProbs();
                                    type = info.getName();
                                    consolidatedCurve.setName(type);
                                    Color color = null;
                                    if (trtColors != null) {
                                        for (TectonicRegionType trt : trtColors.keySet()) {
                                            if (!type.contains(trt.toString())) continue;
                                            color = (Color)trtColors.get(trt);
                                            break;
                                        }
                                    }
                                    if (color == null) {
                                        color = Color.DARK_GRAY;
                                    }
                                    contribCurves.add(SolSiteHazardCalc.toLinear(consolidatedCurve));
                                    contribChars.add(new PlotCurveCharacterstics(griddedContribPLT, 2.0f, color));
                                }
                            }
                        }
                        plotFutures.add(SolSiteHazardCalc.plotContributionCurve(resourcesDir, disaggPrefix, periods[p5], site.getName(), duration, rps, curves.get(s)[p5], name, contribCurves, contribChars, exec, writePDFs));
                        table.addColumn("![" + SolSiteHazardCalc.periodLabel(periods[p5]) + " Curves](" + resourcesDir.getName() + "/" + disaggPrefix + ".png)");
                        csvLinks.add("[Download CSV](" + resourcesDir.getName() + "/" + disaggPrefix + ".csv)");
                    }
                    table.finalizeLine();
                    table.addLine(csvLinks);
                }
                lines.addAll(table.build());
                lines.add("");
                if (!disaggBySourceOnly) {
                    lines.add("#### " + site.getName() + " Traditional Disaggregations & Contribution Maps");
                    lines.add(topLink);
                    lines.add("");
                    table = MarkdownUtils.tableBuilder();
                    for (int p6 = 0; p6 < periods.length; ++p6) {
                        int d;
                        int d2;
                        if (periods.length > 1) {
                            table.initNewLine();
                            table.addColumn(MarkdownUtils.boldCentered(SolSiteHazardCalc.periodLabel(periods[p6])));
                            for (int i6 = 0; i6 < numDisagg - 1; ++i6) {
                                table.addColumn("");
                            }
                            table.finalizeLine();
                        }
                        table.initNewLine();
                        for (d2 = 0; d2 < numDisagg; ++d2) {
                            String label = SolSiteHazardCalc.disaggLabel(results[p6][d2], periods[p6], rps);
                            table.addColumn(MarkdownUtils.boldCentered(label));
                        }
                        table.finalizeLine();
                        table.initNewLine();
                        for (d2 = 0; d2 < numDisagg; ++d2) {
                            final String disaggPrefix = "disagg_" + prefix + "_" + SolSiteHazardCalc.periodPrefix(periods[p6]) + "_" + SolSiteHazardCalc.disaggPrefix(results[p6][d2], rps);
                            final DisaggResult result = results[p6][d2];
                            plotFutures.add(exec.submit(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        PureJavaDisaggPlotter.writeChartPlot(resourcesDir, disaggPrefix, result.plotData, 800, 800, true, writePDFs);
                                    }
                                    catch (IOException e) {
                                        throw ExceptionUtils.asRuntimeException(e);
                                    }
                                }
                            }));
                            table.addColumn("![Disagg Plot](" + resourcesDir.getName() + "/" + disaggPrefix + ".png)");
                        }
                        table.finalizeLine();
                        table.initNewLine();
                        for (d2 = 0; d2 < numDisagg; ++d2) {
                            String disaggPrefix = "disagg_" + prefix + "_" + SolSiteHazardCalc.periodPrefix(periods[p6]) + "_" + SolSiteHazardCalc.disaggPrefix(results[p6][d2], rps) + "_source_map";
                            plotFutures.add(SolSiteHazardCalc.plotDisaggMap(resourcesDir, disaggPrefix, mapMaker, site, smallestMaxDist, results[p6][d2], erf, gridSeisOp, exec, writePDFs));
                            table.addColumn("![Disagg Source Map](" + resourcesDir.getName() + "/" + disaggPrefix + ".png)");
                        }
                        table.finalizeLine();
                        int maxDisaggSources = 0;
                        for (DisaggResult result : results[p6]) {
                            maxDisaggSources = Integer.max(maxDisaggSources, result.consolidatedSourceInfo == null ? 0 : result.consolidatedSourceInfo.size());
                        }
                        int myNumSources = Integer.min(numDisaggSources, maxDisaggSources);
                        if (myNumSources > 1) {
                            int i7;
                            table.initNewLine();
                            for (d = 0; d < numDisagg; ++d) {
                                String disaggPrefix = SolSiteHazardCalc.getDisaggCSV_Prefix("disagg", sites, site, periods[p6], results[p6][d], rps);
                                table.addColumn("Download CSVs: [Dist/Mag Binned](" + disaggPrefix + ".csv), [Source List](" + disaggPrefix + "_sources.csv)");
                            }
                            table.finalizeLine();
                            table.initNewLine();
                            table.addColumn(MarkdownUtils.boldCentered("Top Contributing Participating Sources"));
                            for (i7 = 0; i7 < numDisagg - 1; ++i7) {
                                table.addColumn("");
                            }
                            table.finalizeLine();
                            for (i7 = 0; i7 < numDisaggSources; ++i7) {
                                table.initNewLine();
                                for (int d3 = 0; d3 < numDisagg; ++d3) {
                                    List<DisaggregationSourceRuptureInfo> sources = results[p6][d3].consolidatedSourceInfo;
                                    if (sources == null || sources.size() < i7) {
                                        table.addColumn("");
                                        continue;
                                    }
                                    DisaggregationSourceRuptureInfo source = sources.get(i7);
                                    table.addColumn(source.getName() + " (" + pDF.format(source.getRate() / results[p6][d3].totRate) + ")");
                                }
                                table.finalizeLine();
                            }
                            continue;
                        }
                        table.initNewLine();
                        for (d = 0; d < numDisagg; ++d) {
                            String disaggPrefix = SolSiteHazardCalc.getDisaggCSV_Prefix("disagg", sites, site, periods[p6], results[p6][d], rps);
                            table.addColumn("Download CSV: [Dist/Mag Binned](" + disaggPrefix + ".csv)");
                        }
                        table.finalizeLine();
                    }
                    lines.addAll(table.build());
                    lines.add("");
                }
            }
            if (site.size() <= 1) continue;
            System.out.println("Done with site " + siteTrack.getInrementProgress() + ": " + site.getName());
        }
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 2));
        lines.add(tocIndex, "## Table Of Contents");
        System.out.println("Waiting on " + plotFutures.size() + " plot futures");
        try {
            for (Future future : plotFutures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            System.exit(1);
        }
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
        System.out.println("DONE");
        exec.shutdown();
        System.exit(0);
    }

    public static void writeExampleSitesCSV(File outputFile, boolean params) throws IOException {
        CSVFile csv = new CSVFile(true);
        Location[] siteLocs = new Location[]{new Location(34.0, -118.0), new Location(35.0, -117.0), new Location(37.2, -120.0), new Location(38.0, -119.5)};
        ArrayList<String> header = new ArrayList<String>();
        header.add(NAME_HEADER);
        header.add(LAT_HEADER);
        header.add(LON_HEADER);
        if (params) {
            header.add(VS30_HEADER);
            header.add(Z10_HEADER);
            header.add(Z25_HEADER);
        }
        csv.addLine(header);
        for (int i = 0; i < siteLocs.length; ++i) {
            ArrayList<Object> line = new ArrayList<Object>(header.size());
            line.add("Site " + (i + 1));
            line.add("" + (float)siteLocs[i].lat);
            line.add("" + (float)siteLocs[i].lon);
            if (params) {
                line.add("760");
                line.add("100");
                line.add("1.25");
            }
            csv.addLine(line);
        }
        csv.writeToFile(outputFile);
    }

    public static String paramValStr(Parameter<?> param) {
        Object val = param.getValue();
        Object valStr = val == null ? "_(null)_" : (val instanceof Double ? "" + ((Double)val).floatValue() : val.toString());
        if (val != null && param.getUnits() != null && !param.getUnits().isBlank()) {
            valStr = (String)valStr + " (" + param.getUnits() + ")";
        }
        return valStr;
    }

    private static void addTRTParamLines(MarkdownUtils.TableBuilder table, TectonicRegionType trt, ScalarIMR gmm, SourceFilterManager sourceFilters) {
        table.addLine("Ground Motion Model:", gmm.getName());
        double maxDist = Double.NaN;
        if (sourceFilters.isEnabled(SourceFilters.FIXED_DIST_CUTOFF)) {
            maxDist = sourceFilters.getFilterInstance(FixedDistanceCutoffFilter.class).getMaxDistance();
        }
        if (sourceFilters.isEnabled(SourceFilters.TRT_DIST_CUTOFFS)) {
            double trtDist = sourceFilters.getFilterInstance(TectonicRegionDistCutoffFilter.class).getCutoffs().getCutoffDist(trt);
            maxDist = Double.isFinite(maxDist) ? Math.min(maxDist, trtDist) : trtDist;
        }
        if (Double.isFinite(maxDist)) {
            table.addLine("Maximum Source-Site Distance", oDF.format(maxDist) + " km");
        } else if (sourceFilters.isEnabled(SourceFilters.MAG_DIST_CUTOFFS)) {
            table.addLine("Maximum Source-Site Distance", "Magnitude-dependent");
        }
    }

    private static void addDefaultSiteParams(Site site, Map<TectonicRegionType, ScalarIMR> gmms0, CommandLine cmd) {
        for (Parameter param : FaultSysHazardCalcSettings.getDefaultSiteParams(gmms0)) {
            if ((param = (Parameter)param.clone()).getName().equals(VS30_HEADER) && cmd.hasOption("vs30")) {
                SolSiteHazardCalc.setDoubleParam(param, Double.parseDouble(cmd.getOptionValue("vs30")));
            } else if (param.getName().equals("Depth 1.0 km/sec") && cmd.hasOption("z10")) {
                SolSiteHazardCalc.setDoubleParam(param, Double.parseDouble(cmd.getOptionValue("z10")));
            } else if (param.getName().equals("Depth 2.5 km/sec") && cmd.hasOption("z25")) {
                SolSiteHazardCalc.setDoubleParam(param, Double.parseDouble(cmd.getOptionValue("z25")));
            }
            site.addParameter(param);
        }
    }

    private static void setDoubleParam(Parameter<?> param, double value) {
        Preconditions.checkState((boolean)(param instanceof DoubleParameter), (String)"Expected DoubleParamter for %s, is %s", (Object)param.getName(), (Object)param.getType());
        if (param instanceof WarningDoubleParameter) {
            WarningDoubleParameter warn = (WarningDoubleParameter)param;
            if (!warn.isRecommended(value)) {
                System.err.println("WARNING: Value '" + value + "' is not recommented for parameter " + param.getName());
            }
            warn.setValueIgnoreWarning(value);
        } else {
            ((DoubleParameter)param).setValue(value);
        }
    }

    private static IncludeBackgroundOption getGridOp(CommandLine cmd, FaultSystemSolution sol) {
        boolean hasGridProv;
        boolean bl = hasGridProv = sol.getGridSourceProvider() != null;
        if (cmd.hasOption("gridded-seis")) {
            IncludeBackgroundOption gridOp = IncludeBackgroundOption.valueOf(cmd.getOptionValue("gridded-seis").toUpperCase());
            if (gridOp != IncludeBackgroundOption.EXCLUDE) {
                Preconditions.checkState((boolean)hasGridProv, (String)"Gridded seismicity enabled via --gridded-seis %s, but solution doesn't have gridded sources", (Object)gridOp.name());
            }
            return gridOp;
        }
        return hasGridProv ? IncludeBackgroundOption.INCLUDE : IncludeBackgroundOption.EXCLUDE;
    }

    private static FaultSystemSolutionERF buildERF(FaultSystemSolution sol, IncludeBackgroundOption gridOp, GriddedSeismicitySettings gridSettings, double duration) {
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(sol);
        erf.setParameter("Background Seismicity", (Object)gridOp);
        erf.setGriddedSeismicitySettings(gridSettings);
        erf.setCacheGridSources(true);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        return erf;
    }

    private static List<DiscretizedFunc[]> calcHazardCurves(List<HazardCalcThread> calcThreads, List<Site> sites, FaultSystemSolutionERF erf, double[] periods, DiscretizedFunc[] periodXVals) {
        SiteHazardTaskDistributor hazardTasks = new SiteHazardTaskDistributor(sites, periods, periodXVals);
        int numCurves = sites.size() * periods.length;
        System.out.println("Calculating " + numCurves + " hazard curves (" + sites.size() + " sites and " + periods.length + " periods) with " + calcThreads.size() + " threads");
        Stopwatch watch = Stopwatch.createStarted();
        for (HazardCalcThread thread : calcThreads) {
            AbstractERF threadERF = THREAD_LOCAL_ERFS && calcThreads.size() > 1 && sites.size() > 1 ? new DistCachedERFWrapper(erf) : erf;
            thread.init(threadERF, hazardTasks);
            thread.start();
        }
        for (HazardCalcThread thread : calcThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        ArrayList<DiscretizedFunc[]> ret = new ArrayList<DiscretizedFunc[]>(sites.size());
        for (Site site : sites) {
            DiscretizedFunc[] curves = hazardTasks.getSiteResults(site).toArray(new DiscretizedFunc[0]);
            Preconditions.checkState((curves.length == periods.length ? 1 : 0) != 0);
            ret.add(curves);
        }
        watch.stop();
        System.out.println("Calculated " + numCurves + " curves in " + SolSiteHazardCalc.timeStr(watch) + " (" + SolSiteHazardCalc.timeStr(watch, numCurves) + " per curve)");
        SolSiteHazardCalc.checkClearERFCache(calcThreads.size(), sites.size(), erf);
        return ret;
    }

    private static void checkClearERFCache(int threads, int sites, FaultSystemSolutionERF erf) {
        if (sites > 1 && threads > 1 && !THREAD_LOCAL_ERFS && erf.getNumFaultSystemSources() > 0) {
            for (int i = 0; i < erf.getNumFaultSystemSources(); ++i) {
                ProbEqkSource source = erf.getSource(i);
                for (ProbEqkRupture rup : source) {
                    RuptureSurface ruptureSurface = rup.getRuptureSurface();
                    if (!(ruptureSurface instanceof CompoundSurface)) continue;
                    ((CompoundSurface)ruptureSurface).clearCache();
                }
            }
            boolean aseisReducesArea = (Boolean)erf.getParameter("Aseismicity Reduces Area").getValue();
            double gridSpacing = (Double)erf.getParameter("Fault Grid Spacing").getValue();
            for (FaultSection faultSection : erf.getSolution().getRupSet().getFaultSectionDataList()) {
                RuptureSurface surf = faultSection.getFaultSurface(gridSpacing, false, aseisReducesArea);
                if (!(surf instanceof CacheEnabledSurface)) continue;
                ((CacheEnabledSurface)surf).clearCache();
            }
        }
    }

    private static String timeStr(Stopwatch watch) {
        return SolSiteHazardCalc.timeStr(watch, 1.0);
    }

    private static String timeStr(Stopwatch watch, double divide) {
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / (divide * 1000.0);
        if (secs < 60.0) {
            return oDF.format(secs) + " s";
        }
        double mins = secs / 60.0;
        if (mins < 60.0) {
            return oDF.format(mins) + " m";
        }
        double hours = mins / 60.0;
        return oDF.format(hours) + " h";
    }

    private static List<DiscretizedFunc> extractPeriodCurves(List<DiscretizedFunc[]> curves, int periodIndex) {
        ArrayList<DiscretizedFunc> ret = new ArrayList<DiscretizedFunc>(curves.size());
        for (DiscretizedFunc[] array : curves) {
            ret.add(array[periodIndex]);
        }
        return ret;
    }

    private static List<DiscretizedFunc> calcSpectra(List<DiscretizedFunc[]> curves, double[] periods, CustomReturnPeriod rp) {
        ArrayList<DiscretizedFunc> ret = new ArrayList<DiscretizedFunc>(curves.size());
        for (DiscretizedFunc[] array : curves) {
            ret.add(SolSiteHazardCalc.calcSpectra(array, periods, rp));
        }
        return ret;
    }

    private static DiscretizedFunc calcSpectra(DiscretizedFunc[] curves, double[] periods, CustomReturnPeriod rp) {
        Preconditions.checkState((curves.length == periods.length ? 1 : 0) != 0);
        ArbitrarilyDiscretizedFunc spectra = new ArbitrarilyDiscretizedFunc();
        for (int p = 0; p < periods.length; ++p) {
            if (periods[p] <= 0.0) continue;
            spectra.set(periods[p], SolSiteHazardCalc.curveVal(curves[p], rp));
        }
        return spectra;
    }

    private static void writeCurvesCSV(File csvFile, List<DiscretizedFunc> curves, List<Site> sites) throws IOException {
        CSVFile csv = new CSVFile(true);
        DiscretizedFunc curve0 = curves.get(0);
        ArrayList<Object> header = new ArrayList<Object>(curve0.size() + 3);
        header.add(NAME_HEADER);
        header.add(LAT_HEADER);
        header.add(LON_HEADER);
        for (int i = 0; i < curve0.size(); ++i) {
            header.add("" + (float)curve0.getX(i));
        }
        csv.addLine(header);
        for (int s = 0; s < sites.size(); ++s) {
            ArrayList<Object> line = new ArrayList<Object>(header.size());
            Site site = sites.get(s);
            line.add(site.getName());
            line.add("" + (float)site.getLocation().getLatitude());
            line.add("" + (float)site.getLocation().getLongitude());
            DiscretizedFunc curve = curves.get(s);
            Preconditions.checkState((curve.size() == curve0.size() ? 1 : 0) != 0);
            for (int i = 0; i < curve.size(); ++i) {
                line.add("" + curve.getY(i));
            }
            csv.addLine(line);
        }
        System.out.println("Writing " + csvFile.getAbsolutePath());
        csv.writeToFile(csvFile);
    }

    private static void writeSourceTypeCurvesCSV(File csvFile, List<DiscretizedFunc> curves) throws IOException {
        CSVFile csv = new CSVFile(true);
        DiscretizedFunc curve0 = curves.get(0);
        ArrayList<Object> header = new ArrayList<Object>(curve0.size() + 1);
        header.add("Type");
        for (int i = 0; i < curve0.size(); ++i) {
            header.add("" + (float)curve0.getX(i));
        }
        csv.addLine(header);
        for (DiscretizedFunc curve : curves) {
            ArrayList<Object> line = new ArrayList<Object>(header.size());
            line.add(curve.getName());
            Preconditions.checkState((curve.size() == curve0.size() ? 1 : 0) != 0);
            for (int i = 0; i < curve.size(); ++i) {
                line.add("" + curve.getY(i));
            }
            csv.addLine(line);
        }
        System.out.println("Writing " + csvFile.getAbsolutePath());
        csv.writeToFile(csvFile);
    }

    private static String periodLabel(double period) {
        if (period == 0.0) {
            return "PGA";
        }
        if (period == -1.0) {
            return "PGV";
        }
        return periodDF.format(period) + "s SA";
    }

    private static String periodPrefix(double period) {
        if (period == 0.0) {
            return "pga";
        }
        if (period == -1.0) {
            return "pgv";
        }
        return "sa_" + periodDF.format(period) + "s";
    }

    private static String periodUnits(double period) {
        if (period == -1.0) {
            return "(cm/s)";
        }
        return "(g)";
    }

    public static double curveVal(DiscretizedFunc curve, CustomReturnPeriod rp) {
        double curveLevel = rp.prob;
        if (curveLevel > curve.getMaxY()) {
            return 0.0;
        }
        if (curveLevel < curve.getMinY()) {
            return curve.getMaxX();
        }
        return curve.getFirstInterpolatedX_inLogXLogYDomain(curveLevel);
    }

    private static Range calcXRange(List<DiscretizedFunc> funcs, Range yRange) {
        double maxX = 0.0;
        for (DiscretizedFunc func : funcs) {
            for (Point2D pt : func) {
                if (!((float)pt.getY() < (float)yRange.getUpperBound()) || !((float)pt.getY() > (float)yRange.getLowerBound())) continue;
                maxX = Math.max(maxX, pt.getX());
            }
        }
        double threshold = maxX > 1.0 ? 0.01 : (maxX > 0.1 ? 0.001 : 1.0E-4);
        double minX = Double.POSITIVE_INFINITY;
        for (DiscretizedFunc func : funcs) {
            for (Point2D pt : func) {
                if (!(pt.getX() > threshold) || !((float)pt.getY() < (float)yRange.getUpperBound()) || !((float)pt.getY() > (float)yRange.getLowerBound())) continue;
                minX = Math.min(minX, pt.getX());
            }
        }
        minX = Math.pow(10.0, Math.floor(Math.log10(minX)));
        maxX = Math.pow(10.0, Math.ceil(Math.log10(maxX)));
        return new Range(minX, maxX);
    }

    private static Future<?> plotCurve(final File outputDir, final String prefix, double period, String siteName, double duration, CustomReturnPeriod[] rps, DiscretizedFunc curve, String name, DiscretizedFunc compCurve, String compName, ExecutorService exec, final boolean writePDFs) throws IOException {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        curve.setName(name);
        funcs.add(curve);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Colors.tab_blue));
        if (compCurve != null) {
            compCurve.setName(compName);
            funcs.add(compCurve);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Colors.tab_orange));
        }
        final Range yRange = new Range(1.0E-6, 1.0);
        final Range xRange = SolSiteHazardCalc.calcXRange(funcs, yRange);
        List<XYAnnotation> anns = SolSiteHazardCalc.addRPAnnotations(funcs, chars, xRange, yRange, rps, false);
        Object yAxisLabel = duration == 1.0 ? "Annual Probability of Exceedance" : oDF.format(duration) + "-Year Probability of Exceedance";
        final PlotSpec spec = new PlotSpec(funcs, chars, siteName, SolSiteHazardCalc.periodLabel(period) + " " + SolSiteHazardCalc.periodUnits(period), (String)yAxisLabel);
        spec.setLegendInset(compCurve != null);
        if (anns != null) {
            spec.setPlotAnnotations(anns);
        }
        return exec.submit(new Runnable(){

            @Override
            public void run() {
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                gp.drawGraphPanel(spec, true, true, xRange, yRange);
                try {
                    PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 1000, 800, true, writePDFs, false);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
    }

    private static Future<?> plotContributionCurve(final File outputDir, final String prefix, double period, String siteName, double duration, CustomReturnPeriod[] rps, DiscretizedFunc curve, String name, List<DiscretizedFunc> contribCurves, List<PlotCurveCharacterstics> contribChars, ExecutorService exec, final boolean writePDFs) throws IOException {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        curve.setName(name);
        funcs.add(curve);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
        funcs.addAll(contribCurves);
        chars.addAll(contribChars);
        SolSiteHazardCalc.writeSourceTypeCurvesCSV(new File(outputDir, prefix + ".csv"), funcs);
        curve = curve.deepClone();
        curve.setName(null);
        funcs.add(curve);
        chars.add((PlotCurveCharacterstics)chars.get(0));
        final Range yRange = new Range(1.0E-6, 1.0);
        final Range xRange = SolSiteHazardCalc.calcXRange(funcs, yRange);
        List<XYAnnotation> anns = SolSiteHazardCalc.addRPAnnotations(funcs, chars, xRange, yRange, rps, true);
        Object yAxisLabel = duration == 1.0 ? "Annual Probability of Exceedance" : oDF.format(duration) + "-Year Probability of Exceedance";
        final PlotSpec spec = new PlotSpec(funcs, chars, siteName, SolSiteHazardCalc.periodLabel(period) + " " + SolSiteHazardCalc.periodUnits(period), (String)yAxisLabel);
        spec.setLegendInset(true);
        if (anns != null) {
            spec.setPlotAnnotations(anns);
        }
        return exec.submit(new Runnable(){

            @Override
            public void run() {
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.drawGraphPanel(spec, true, true, xRange, yRange);
                try {
                    PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 1000, 800, true, writePDFs, false);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
    }

    private static DiscretizedFunc toLinear(DiscretizedFunc curve) {
        ArbitrarilyDiscretizedFunc ret = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : curve) {
            ret.set(Math.exp(pt.getX()), pt.getY());
        }
        ret.setName(curve.getName());
        return ret;
    }

    public static List<XYAnnotation> addRPAnnotations(List<? super DiscretizedFunc> funcs, List<PlotCurveCharacterstics> chars, Range xRange, Range yRange, SolHazardMapCalc.ReturnPeriods[] rps, boolean first) {
        CustomReturnPeriod[] crps = new CustomReturnPeriod[rps.length];
        for (int i = 0; i < rps.length; ++i) {
            crps[i] = new CustomReturnPeriod(rps[i], 1.0);
        }
        return SolSiteHazardCalc.addRPAnnotations(funcs, chars, xRange, yRange, crps, first);
    }

    public static List<XYAnnotation> addRPAnnotations(List<? super DiscretizedFunc> funcs, List<PlotCurveCharacterstics> chars, Range xRange, Range yRange, CustomReturnPeriod[] rps, boolean first) {
        ArrayList<XYAnnotation> anns = new ArrayList<XYAnnotation>();
        for (CustomReturnPeriod rp : rps) {
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            func.set(xRange.getLowerBound(), rp.prob);
            func.set(xRange.getUpperBound(), rp.prob);
            PlotCurveCharacterstics pChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.DARK_GRAY);
            if (first) {
                funcs.add(0, func);
                chars.add(0, pChar);
            } else {
                funcs.add(func);
                chars.add(pChar);
            }
            Range logXRange = new Range(Math.log10(xRange.getLowerBound()), Math.log10(xRange.getUpperBound()));
            Range logYRange = new Range(Math.log10(yRange.getLowerBound()), Math.log10(yRange.getUpperBound()));
            double annX = Math.pow(10.0, logXRange.getLowerBound() + 0.99 * logXRange.getLength());
            double annY = Math.pow(10.0, Math.log10(rp.prob) + 0.01 * logYRange.getLength());
            XYTextAnnotation ann = new XYTextAnnotation(rp.label, annX, annY);
            ann.setTextAnchor(TextAnchor.BASELINE_RIGHT);
            ann.setFont(new Font("SansSerif", 1, 20));
            anns.add((XYAnnotation)ann);
        }
        return anns;
    }

    private static Future<?> plotSpectra(final File outputDir, final String prefix, CustomReturnPeriod rp, String siteName, DiscretizedFunc curve, String name, DiscretizedFunc compCurve, String compName, ExecutorService exec, final boolean writePDFs) throws IOException {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        curve.setName(name);
        funcs.add(curve);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED.darker()));
        if (compCurve != null) {
            compCurve.setName(compName);
            funcs.add(compCurve);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE.darker()));
        }
        final Range xRange = new Range(curve.getMinX(), curve.getMaxX());
        double minY = Double.POSITIVE_INFINITY;
        double maxY = 0.0;
        for (DiscretizedFunc func : funcs) {
            for (Point2D pt : func) {
                if (!Doubles.isFinite((double)pt.getY()) || !(pt.getY() > 0.0)) continue;
                minY = Math.min(minY, pt.getY());
                maxY = Math.max(maxY, pt.getY());
            }
        }
        minY = Math.pow(10.0, Math.floor(Math.log10(minY)));
        maxY = Math.pow(10.0, Math.ceil(Math.log10(maxY)));
        final Range yRange = new Range(minY, maxY);
        String xAxisLabel = "Period (s)";
        String yAxisLabel = "SA (g), " + rp.label;
        final PlotSpec spec = new PlotSpec(funcs, chars, siteName, xAxisLabel, yAxisLabel);
        spec.setLegendInset(compCurve != null);
        return exec.submit(new Runnable(){

            @Override
            public void run() {
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                gp.drawGraphPanel(spec, true, true, xRange, yRange);
                try {
                    PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 1000, 800, true, writePDFs, false);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
    }

    public static EvenlyDiscretizedFunc disaggRange(double min, double max, double delta, boolean recenter) {
        double bin;
        int num = 1;
        Preconditions.checkArgument((max >= min ? 1 : 0) != 0);
        double halfDelta = 0.5 * delta;
        double numBinsAwayFromZero = Math.floor(min / delta);
        double firstBin = numBinsAwayFromZero * delta;
        if (recenter) {
            firstBin += halfDelta;
        }
        while (!((float)max <= (float)((bin = firstBin + delta * (double)(num - 1)) + 0.5 * delta))) {
            ++num;
        }
        return new EvenlyDiscretizedFunc(firstBin, num, delta);
    }

    private static List<DisaggResult[][]> calcDisagg(List<DisaggCalcThread> calcThreads, List<Site> sites, FaultSystemSolutionERF erf, double[] periods, List<DiscretizedFunc[]> siteCurves) {
        SiteDisaggCalcTaskDistributor disaggTasks = new SiteDisaggCalcTaskDistributor(sites, periods, siteCurves);
        System.out.println("Disaggregating for " + sites.size() + " sites and " + periods.length + " periods with " + calcThreads.size() + " threads");
        int numCurves = sites.size() * periods.length;
        Stopwatch watch = Stopwatch.createStarted();
        for (DisaggCalcThread thread : calcThreads) {
            AbstractERF threadERF = THREAD_LOCAL_ERFS && calcThreads.size() > 1 && sites.size() > 1 ? new DistCachedERFWrapper(erf) : erf;
            thread.init(threadERF, disaggTasks);
            thread.start();
        }
        for (DisaggCalcThread thread : calcThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        ArrayList<DisaggResult[][]> ret = new ArrayList<DisaggResult[][]>(sites.size());
        for (Site site : sites) {
            DisaggResult[][] results = (DisaggResult[][])disaggTasks.getSiteResults(site).toArray((T[])new DisaggResult[0][]);
            Preconditions.checkState((results.length == periods.length ? 1 : 0) != 0);
            ret.add(results);
        }
        watch.stop();
        System.out.println("Disaggregated " + numCurves + " curves in " + SolSiteHazardCalc.timeStr(watch) + " (" + SolSiteHazardCalc.timeStr(watch, numCurves) + " per curve)");
        SolSiteHazardCalc.checkClearERFCache(calcThreads.size(), sites.size(), erf);
        return ret;
    }

    private static String disaggPrefix(DisaggResult result, CustomReturnPeriod[] rps) {
        if (result.isFromProb) {
            for (CustomReturnPeriod rp : rps) {
                if ((float)rp.prob != (float)result.prob) continue;
                return rp.prefix;
            }
            return "prob_" + (float)result.prob;
        }
        return "iml_" + (float)result.iml;
    }

    private static String disaggLabel(DisaggResult result, double period, CustomReturnPeriod[] rps) {
        if (result.isFromProb) {
            for (CustomReturnPeriod rp : rps) {
                if ((float)rp.prob != (float)result.prob) continue;
                return rp.label + ", " + (float)result.iml + " " + SolSiteHazardCalc.periodUnits(period);
            }
        }
        return "P=" + (float)result.prob + ", " + (float)result.iml + " " + SolSiteHazardCalc.periodUnits(period);
    }

    private static String getDisaggCSV_Prefix(String commonPrefix, List<Site> sites, Site site, double period, DisaggResult result, CustomReturnPeriod[] rps) {
        Object sitePrefix = commonPrefix;
        if (sites.size() > 1) {
            if (!((String)sitePrefix).isBlank()) {
                sitePrefix = (String)sitePrefix + "_";
            }
            sitePrefix = (String)sitePrefix + FileNameUtils.simplify(site.getName());
            while (((String)sitePrefix).contains("__")) {
                sitePrefix = ((String)sitePrefix).replace("__", "_");
            }
        }
        return (String)sitePrefix + "_" + SolSiteHazardCalc.periodPrefix(period) + "_" + SolSiteHazardCalc.disaggPrefix(result, rps);
    }

    private static void writeDisaggCSVs(File outputDir, String commonPrefix, List<Site> sites, double[] periods, List<DisaggResult[][]> results, CustomReturnPeriod[] rps) throws IOException {
        for (int s = 0; s < sites.size(); ++s) {
            Site site = sites.get(s);
            DisaggResult[][] siteResults = results.get(s);
            Object sitePrefix = commonPrefix;
            if (sites.size() > 1) {
                if (!((String)sitePrefix).isBlank()) {
                    sitePrefix = (String)sitePrefix + "_";
                }
                sitePrefix = (String)sitePrefix + FileNameUtils.simplify(site.getName());
                while (((String)sitePrefix).contains("__")) {
                    sitePrefix = ((String)sitePrefix).replace("__", "_");
                }
            }
            for (int p = 0; p < periods.length; ++p) {
                DisaggResult[] perResults = siteResults[p];
                for (int i = 0; i < perResults.length; ++i) {
                    String prefix = SolSiteHazardCalc.getDisaggCSV_Prefix(commonPrefix, sites, site, periods[p], perResults[i], rps);
                    CSVFile csv = new CSVFile(true);
                    ArrayList<String> header = new ArrayList<String>();
                    header.add("Distance (km)");
                    header.add("Magnitude");
                    for (DisaggregationCalculator.EpsilonCategories cat : DisaggregationCalculator.EpsilonCategories.values()) {
                        header.add(cat.label);
                    }
                    header.add("Sum");
                    csv.addLine(header);
                    DisaggregationPlotData data = perResults[i].plotData;
                    int numE = DisaggregationCalculator.EpsilonCategories.values().length;
                    double[][][] pdf = data.getPdf3D();
                    for (int d = 0; d < data.getDist_center().length; ++d) {
                        for (int m = 0; m < data.getMag_center().length; ++m) {
                            ArrayList<CallSite> line = new ArrayList<CallSite>(header.size());
                            line.add((CallSite)((Object)("" + (float)data.getDist_center()[d])));
                            line.add((CallSite)((Object)("" + (float)data.getMag_center()[m])));
                            for (int e = 0; e < numE; ++e) {
                                line.add((CallSite)((Object)("" + (float)pdf[d][m][e])));
                            }
                            line.add((CallSite)((Object)("" + (float)StatUtils.sum((double[])pdf[d][m]))));
                            csv.addLine(line);
                        }
                    }
                    csv.writeToFile(new File(outputDir, prefix + ".csv"));
                    double totalRate = perResults[i].totRate;
                    List<DisaggregationSourceRuptureInfo> sources = perResults[i].consolidatedSourceInfo;
                    if (sources == null || sources.size() <= 1) continue;
                    csv = new CSVFile(true);
                    header = new ArrayList();
                    header.add("Source Name");
                    header.add("Contribution (%)");
                    csv.addLine(header);
                    for (DisaggregationSourceRuptureInfo source : sources) {
                        ArrayList<Object> line = new ArrayList<Object>(header.size());
                        line.add(source.getName());
                        line.add("" + (float)(100.0 * source.getRate() / totalRate));
                        csv.addLine(line);
                    }
                    csv.writeToFile(new File(outputDir, prefix + "_sources.csv"));
                }
            }
        }
    }

    private static Future<?> plotSiteMap(File resourcesDir, String prefix, GeographicMapMaker mapMaker, Site site, double maxDist, ExecutorService exec, boolean writePDFs) throws IOException {
        return SolSiteHazardCalc.plotSitesMap(resourcesDir, prefix, mapMaker, List.of(site), maxDist, exec, writePDFs, false);
    }

    private static Future<?> plotSitesMap(final File resourcesDir, final String prefix, final GeographicMapMaker mapMaker, final List<Site> sites, final double maxDist, ExecutorService exec, final boolean writePDFs, final boolean writeGeoJSON) throws IOException {
        Preconditions.checkState((maxDist > 0.0 ? 1 : 0) != 0, (String)"Bad maxDist=%s", (Object)maxDist);
        return exec.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                double minLat = Double.POSITIVE_INFINITY;
                double minLon = Double.POSITIVE_INFINITY;
                double maxLat = Double.NEGATIVE_INFINITY;
                double maxLon = Double.NEGATIVE_INFINITY;
                double buffer = 10.0;
                for (Site site : sites) {
                    double latDelta = LocationUtils.location(site.getLocation(), 0.0, maxDist + buffer).getLatitude() - site.getLocation().getLatitude();
                    double lonDelta = LocationUtils.location(site.getLocation(), 1.5707963267948966, maxDist + buffer).getLongitude() - site.getLocation().getLongitude();
                    minLat = Math.min(minLat, site.getLocation().lat - latDelta);
                    maxLat = Math.max(maxLat, site.getLocation().lat + latDelta);
                    minLon = Math.min(minLon, site.getLocation().lon - lonDelta);
                    maxLon = Math.max(maxLon, site.getLocation().lon + lonDelta);
                }
                Region mapRegion = new Region(new Location(minLat, minLon), new Location(maxLat, maxLon));
                GeographicMapMaker geographicMapMaker = mapMaker;
                synchronized (geographicMapMaker) {
                    mapMaker.setRegion(mapRegion);
                    mapMaker.setSkipNaNs(false);
                    mapMaker.clearScatters();
                    mapMaker.clearSectScalars();
                    mapMaker.clearXYZData();
                    SolSiteHazardCalc.plotSiteScatters(mapMaker, sites, writeGeoJSON);
                    mapMaker.setWriteGeoJSON(writeGeoJSON);
                    mapMaker.setWritePDFs(writePDFs);
                    try {
                        mapMaker.plot(resourcesDir, prefix, sites.size() == 1 ? ((Site)sites.get(0)).getName() : " ");
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            }
        });
    }

    private static Future<?> plotDisaggMap(final File resourcesDir, final String prefix, final GeographicMapMaker mapMaker, final Site site, final double maxDist, final DisaggResult result, final FaultSystemSolutionERF erf, final IncludeBackgroundOption gridSeisOp, ExecutorService exec, final boolean writePDFs) throws IOException {
        Preconditions.checkState((maxDist > 0.0 ? 1 : 0) != 0, (String)"Bad maxDist=%s", (Object)maxDist);
        return exec.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Range yRange;
                Range xRange;
                PlotSpec spec;
                CPT gridCPT;
                AbstractGeoDataSet gridXYZ;
                CPT sectCPT;
                double[] sectScalars;
                double buffer = 10.0;
                double latDelta = LocationUtils.location(site.getLocation(), 0.0, maxDist + buffer).getLatitude() - site.getLocation().getLatitude();
                double lonDelta = LocationUtils.location(site.getLocation(), 1.5707963267948966, maxDist + buffer).getLongitude() - site.getLocation().getLongitude();
                Region mapRegion = new Region(new Location(site.getLocation().getLatitude() + latDelta, site.getLocation().getLongitude() + lonDelta), new Location(site.getLocation().getLatitude() - latDelta, site.getLocation().getLongitude() - lonDelta));
                FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
                int numFaultSources = erf.getNumFaultSystemSources();
                double overallCPTMax = 0.0;
                if (gridSeisOp != IncludeBackgroundOption.ONLY && numFaultSources > 0) {
                    CPT cpt;
                    try {
                        cpt = GMT_CPT_Files.SEQUENTIAL_LAJOLLA_UNIFORM.instance().reverse().rescale(0.0, 100.0);
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    cpt.setNanColor(Color.WHITE);
                    double[] scalars = new double[rupSet.getNumSections()];
                    for (DisaggregationSourceRuptureInfo source : result.sourceInfo) {
                        int sourceID = source.getId();
                        if (sourceID <= 0 || sourceID >= numFaultSources) continue;
                        int rupIndex = erf.getFltSysRupIndexForSource(sourceID);
                        Iterator<Integer> iterator = rupSet.getSectionsIndicesForRup(rupIndex).iterator();
                        while (iterator.hasNext()) {
                            int sectID;
                            int n = sectID = iterator.next().intValue();
                            scalars[n] = scalars[n] + source.getRate();
                        }
                    }
                    double cptMax = 0.0;
                    for (int i = 0; i < scalars.length; ++i) {
                        if (scalars[i] == 0.0) {
                            scalars[i] = Double.NaN;
                            continue;
                        }
                        double val = 100.0 * scalars[i] / result.totRate;
                        cptMax = Math.max(cptMax, val);
                        scalars[i] = val;
                    }
                    overallCPTMax = cptMax = Math.ceil(cptMax / 20.0) * 20.0;
                    cpt = cpt.rescale(0.0, cptMax);
                    sectScalars = scalars;
                    sectCPT = cpt;
                } else {
                    sectScalars = null;
                    sectCPT = null;
                }
                if (gridSeisOp != IncludeBackgroundOption.EXCLUDE && erf.getNumSources() > erf.getNumFaultSystemSources()) {
                    AbstractGeoDataSet xyz;
                    CPT cpt;
                    try {
                        cpt = GMT_CPT_Files.SEQUENTIAL_OSLO_UNIFORM.instance().reverse().rescale(0.0, 100.0);
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    cpt.setNanColor(Color.WHITE);
                    GridSourceProvider gridProv = erf.getSolution().getGridSourceProvider();
                    GriddedRegion gridReg = gridProv.getGriddedRegion();
                    if (gridReg == null) {
                        xyz = new ArbDiscrGeoDataSet(false);
                        for (int i = 0; i < gridProv.getNumLocations(); ++i) {
                            xyz.set(gridProv.getLocation(i), 0.0);
                        }
                        Preconditions.checkState((xyz.size() == gridProv.getNumLocations() ? 1 : 0) != 0);
                    } else {
                        xyz = new GriddedGeoDataSet(gridProv.getGriddedRegion());
                    }
                    for (DisaggregationSourceRuptureInfo source : result.sourceInfo) {
                        int sourceID = source.getId();
                        if (sourceID <= 0 || sourceID < numFaultSources) continue;
                        int sourceIndex = sourceID - numFaultSources;
                        int gridIndex = gridProv.getLocationIndexForSource(sourceIndex);
                        Preconditions.checkState((gridIndex < xyz.size() ? 1 : 0) != 0);
                        xyz.set(gridIndex, xyz.get(gridIndex) + source.getRate());
                    }
                    double cptMax = 0.0;
                    for (int i = 0; i < xyz.size(); ++i) {
                        if (xyz.get(i) == 0.0) {
                            xyz.set(i, Double.NaN);
                            continue;
                        }
                        xyz.set(i, 100.0 * xyz.get(i) / result.totRate);
                        cptMax = Math.max(cptMax, xyz.get(i));
                    }
                    if (cptMax > 0.0) {
                        cptMax = cptMax > 10.0 ? Math.ceil(cptMax / 20.0) * 20.0 : Math.ceil(cptMax);
                        overallCPTMax = Math.max(overallCPTMax, cptMax);
                        cpt = cpt.rescale(0.0, cptMax);
                        gridXYZ = xyz;
                        gridCPT = cpt;
                    } else {
                        gridXYZ = null;
                        gridCPT = null;
                    }
                } else {
                    gridXYZ = null;
                    gridCPT = null;
                }
                double zTick = (float)overallCPTMax >= 40.0f ? 10.0 : ((float)overallCPTMax >= 10.0f ? 5.0 : 1.0);
                if (gridCPT != null) {
                    gridCPT = gridCPT.rescale(0.0, overallCPTMax);
                    gridCPT.setPreferredTickInterval(zTick);
                }
                if (sectCPT != null) {
                    sectCPT = sectCPT.rescale(0.0, overallCPTMax);
                    sectCPT.setPreferredTickInterval(zTick);
                }
                GeographicMapMaker source = mapMaker;
                synchronized (source) {
                    mapMaker.setRegion(mapRegion);
                    mapMaker.setSkipNaNs(true);
                    mapMaker.clearScatters();
                    mapMaker.clearSectScalars();
                    mapMaker.clearXYZData();
                    if (sectScalars != null) {
                        mapMaker.plotSectScalars(sectScalars, sectCPT, "Fault Source Participation Contribution (%)");
                        mapMaker.clearScatters();
                    }
                    if (gridXYZ != null) {
                        mapMaker.plotXYZData(gridXYZ, gridCPT, "Grid Source Cell Contribution (%)");
                    }
                    SolSiteHazardCalc.plotSiteScatters(mapMaker, List.of(site), false);
                    spec = mapMaker.buildPlot(" ");
                    xRange = mapMaker.getXRange();
                    yRange = mapMaker.getYRange();
                }
                HeadlessGraphPanel gp = new HeadlessGraphPanel(GeographicMapMaker.PLOT_PREFS_DEFAULT);
                gp.drawGraphPanel(spec, false, false, xRange, yRange);
                double maxSpan = Math.max(xRange.getLength(), yRange.getLength());
                double tick = maxSpan > 20.0 ? 5.0 : (maxSpan > 8.0 ? 2.0 : (maxSpan > 3.0 ? 1.0 : (maxSpan > 1.0 ? 0.5 : 0.2)));
                PlotUtils.setXTick(gp, tick);
                PlotUtils.setYTick(gp, tick);
                try {
                    PlotUtils.writePlots(resourcesDir, prefix, (GraphPanel)gp, 800, true, true, writePDFs, false);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
    }

    private static void plotSiteScatters(GeographicMapMaker mapMaker, List<Site> sites, boolean writeGeoJSON) {
        Color siteColor = SolSiteHazardCalc.modAlpha(Colors.tab_green.darker(), 180);
        ArrayList<Location> siteLocs = new ArrayList<Location>(sites.size());
        ArrayList<FeatureProperties> siteProps = writeGeoJSON ? new ArrayList<FeatureProperties>(sites.size()) : null;
        for (Site site : sites) {
            siteLocs.add(site.getLocation());
            if (!writeGeoJSON) continue;
            FeatureProperties props = new FeatureProperties();
            props.set(NAME_HEADER, site.getName());
            props.set(LAT_HEADER, Float.valueOf((float)site.getLocation().lat));
            props.set(LON_HEADER, Float.valueOf((float)site.getLocation().lon));
            siteProps.add(props);
        }
        mapMaker.plotScatters(siteLocs, siteColor);
        if (writeGeoJSON) {
            mapMaker.setScatterProperties(siteProps);
        }
        float size = sites.size() > 10 ? 3.0f : (sites.size() > 1 ? 5.0f : 7.0f);
        mapMaker.setScatterSymbol(PlotSymbol.FILLED_INV_TRIANGLE, size, PlotSymbol.INV_TRIANGLE, Color.BLACK);
    }

    private static Color modAlpha(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    private static class HazardCalcThread
    extends Thread {
        private HazardCurveCalculator calc;
        private AbstractERF erf;
        private Map<TectonicRegionType, ScalarIMR> gmms;
        private SiteHazardTaskDistributor tasks;
        private ProgressTrack track;

        public HazardCalcThread(HazardCurveCalculator calc, Map<TectonicRegionType, ScalarIMR> gmms) {
            this.calc = calc;
            this.gmms = gmms;
        }

        public void init(AbstractERF erf, SiteHazardTaskDistributor tasks) {
            this.erf = erf;
            this.tasks = tasks;
            this.track = tasks.getProgressTrack();
        }

        @Override
        public void run() {
            HazardCalcTask task = (HazardCalcTask)this.tasks.getNextTask(null);
            while (task != null) {
                DiscretizedFunc xValCurve = task.xValues;
                double[] linearXVals = new double[xValCurve.size()];
                double[] logXVals = new double[xValCurve.size()];
                for (int i = 0; i < xValCurve.size(); ++i) {
                    double x;
                    linearXVals[i] = x = xValCurve.getX(i);
                    logXVals[i] = Math.log(x);
                }
                LightFixedXFunc logCurve = new LightFixedXFunc(logXVals, new double[logXVals.length]);
                FaultSysHazardCalcSettings.setIMforPeriod(this.gmms, task.period);
                this.calc.getHazardCurve((DiscretizedFunc)logCurve, task.site, this.gmms, (ERF)this.erf);
                LightFixedXFunc linearCurve = new LightFixedXFunc(linearXVals, logCurve.getYVals());
                task.setResult(linearCurve);
                System.out.println("done calculating curve " + this.track.getInrementProgress() + ": " + task.site.name + ", period=" + (float)task.period);
                task = (HazardCalcTask)this.tasks.getNextTask(task.site);
            }
            this.erf = null;
        }
    }

    private static class CustomReturnPeriod {
        public final double prob;
        public final String label;
        public final String prefix;

        public CustomReturnPeriod(SolHazardMapCalc.ReturnPeriods rp, double duration) {
            this.prob = duration == 1.0 ? rp.oneYearProb : ReturnPeriodUtils.calcExceedanceProb(rp.oneYearProb, 1.0, duration);
            this.label = rp.label;
            this.prefix = rp.name();
        }

        public CustomReturnPeriod(double returnPeriod, double duration) {
            this.prob = ReturnPeriodUtils.calcExceedanceProbForReturnPeriod(returnPeriod, duration);
            this.label = oDF.format(returnPeriod) + " years";
            this.prefix = oDF.format(returnPeriod) + "yr";
        }
    }

    private static class DisaggCalcThread
    extends Thread {
        private DisaggregationCalculator calc;
        private List<SourceFilter> sourceFilters;
        private ParameterList calcParams;
        private AbstractERF erf;
        private Map<TectonicRegionType, ScalarIMR> gmms;
        private SiteDisaggCalcTaskDistributor tasks;
        private double[] disaggProbs;
        private double[] disaggIMLs;
        private ProgressTrack track;

        public DisaggCalcThread(DisaggregationCalculator calc, List<SourceFilter> sourceFilters, ParameterList calcParams, Map<TectonicRegionType, ScalarIMR> gmms, double[] disaggProbs, double[] disaggIMLs) {
            this.calc = calc;
            this.sourceFilters = sourceFilters;
            this.calcParams = calcParams;
            this.gmms = gmms;
            this.disaggProbs = disaggProbs;
            this.disaggIMLs = disaggIMLs;
        }

        public void init(AbstractERF erf, SiteDisaggCalcTaskDistributor tasks) {
            this.erf = erf;
            this.tasks = tasks;
            this.track = tasks.getProgressTrack();
        }

        @Override
        public void run() {
            DisaggCalcTask task = (DisaggCalcTask)this.tasks.getNextTask(null);
            int numDisagg = 0;
            if (this.disaggProbs != null) {
                numDisagg += this.disaggProbs.length;
            }
            if (this.disaggIMLs != null) {
                numDisagg += this.disaggIMLs.length;
            }
            while (task != null) {
                FaultSysHazardCalcSettings.setIMforPeriod(this.gmms, task.period);
                DisaggResult[] results = new DisaggResult[numDisagg];
                for (int i = 0; i < numDisagg; ++i) {
                    boolean isFromProb;
                    double iml;
                    double prob;
                    if (this.disaggProbs == null) {
                        prob = Double.NaN;
                        iml = this.disaggIMLs[i];
                        isFromProb = false;
                    } else if (i < this.disaggProbs.length) {
                        prob = this.disaggProbs[i];
                        iml = task.siteCurve.getFirstInterpolatedX_inLogXLogYDomain(prob);
                        isFromProb = true;
                    } else {
                        prob = Double.NaN;
                        iml = this.disaggIMLs[i - this.disaggProbs.length];
                        isFromProb = false;
                    }
                    if (i == 0) {
                        ArbitrarilyDiscretizedFunc xVals = new ArbitrarilyDiscretizedFunc();
                        for (Point2D pt : task.siteCurve) {
                            xVals.set(Math.log(pt.getX()), 0.0);
                        }
                        this.calc.setCalculateSourceExceedanceCurves(xVals);
                    } else {
                        this.calc.setSkipCalculateSourceExceedanceCurves();
                    }
                    this.calc.disaggregate(Math.log(iml), task.site, this.gmms, (ERF)this.erf, this.sourceFilters, this.calcParams);
                    List<DisaggregationSourceRuptureInfo> consolidatedNucleationSourceInfo = null;
                    if (i == 0) {
                        BaseFaultSystemSolutionERF fssERF;
                        if (this.erf instanceof BaseFaultSystemSolutionERF) {
                            fssERF = (BaseFaultSystemSolutionERF)this.erf;
                        } else {
                            Preconditions.checkState((boolean)(this.erf instanceof DistCachedERFWrapper));
                            fssERF = (BaseFaultSystemSolutionERF)((DistCachedERFWrapper)this.erf).getOriginalERF();
                        }
                        SolutionDisaggConsolidator nuclConsolodate = new SolutionDisaggConsolidator(fssERF, false);
                        consolidatedNucleationSourceInfo = nuclConsolodate.apply(this.calc.getDisaggregationSourceList());
                    }
                    results[i] = new DisaggResult(iml, prob, isFromProb, this.calc.getDisaggPlotData(), this.calc.getTotalRate(), this.calc.getDisaggregationSourceList(), this.calc.getConsolidatedDisaggregationSourceList(), consolidatedNucleationSourceInfo);
                }
                task.setResult(results);
                System.out.println("done disaggregating " + this.track.getInrementProgress() + ": " + task.site.name + ", " + numDisagg + " IMLs, period=" + (float)task.period);
                task = (DisaggCalcTask)this.tasks.getNextTask(task.site);
            }
            this.erf = null;
        }
    }

    private static class ProgressTrack {
        private int numDone = 0;
        private final int totNum;

        public ProgressTrack(int totNum) {
            this.totNum = totNum;
        }

        public synchronized String getInrementProgress() {
            ++this.numDone;
            return this.numDone + "/" + this.totNum + " (" + pDF.format((double)this.numDone / (double)this.totNum) + ")";
        }
    }

    private static class DisaggResult {
        private final double iml;
        private final double prob;
        private final boolean isFromProb;
        private final DisaggregationPlotData plotData;
        private final double totRate;
        private final List<DisaggregationSourceRuptureInfo> sourceInfo;
        private final List<DisaggregationSourceRuptureInfo> consolidatedSourceInfo;
        private final List<DisaggregationSourceRuptureInfo> consolidatedNucleationSourceInfo;

        public DisaggResult(double iml, double prob, boolean isFromProb, DisaggregationPlotData plotData, double totRate, List<DisaggregationSourceRuptureInfo> sourceInfo, List<DisaggregationSourceRuptureInfo> consolidatedSourceInfo, List<DisaggregationSourceRuptureInfo> consolidatedNucleationSourceInfo) {
            this.iml = iml;
            this.prob = prob;
            this.isFromProb = isFromProb;
            this.plotData = plotData;
            this.totRate = totRate;
            this.sourceInfo = sourceInfo;
            this.consolidatedSourceInfo = consolidatedSourceInfo;
            this.consolidatedNucleationSourceInfo = consolidatedNucleationSourceInfo;
        }
    }

    private static class SiteHazardTaskDistributor
    extends AbstractSiteHazardTaskDistributor<HazardCalcTask, DiscretizedFunc> {
        private DiscretizedFunc[] periodXVals;

        public SiteHazardTaskDistributor(List<Site> sites, double[] periods, DiscretizedFunc[] periodXVals) {
            super(sites, periods);
            this.periodXVals = periodXVals;
        }

        @Override
        protected HazardCalcTask buildTask(int siteIndex, Site site, int periodIndex, double period) {
            return new HazardCalcTask(site, period, this.periodXVals[periodIndex]);
        }
    }

    private static class SiteDisaggCalcTaskDistributor
    extends AbstractSiteHazardTaskDistributor<DisaggCalcTask, DisaggResult[]> {
        private List<DiscretizedFunc[]> siteCurves;

        public SiteDisaggCalcTaskDistributor(List<Site> sites, double[] periods, List<DiscretizedFunc[]> siteCurves) {
            super(sites, periods);
            this.siteCurves = siteCurves;
        }

        @Override
        protected DisaggCalcTask buildTask(int siteIndex, Site site, int periodIndex, double period) {
            return new DisaggCalcTask(site, period, this.siteCurves.get(siteIndex)[periodIndex]);
        }
    }

    private static class DisaggCalcTask
    extends AbstractHazardCalcTask<DisaggResult[]> {
        private DiscretizedFunc siteCurve;

        public DisaggCalcTask(Site site, double period, DiscretizedFunc siteCurve) {
            super(site, period);
            this.siteCurve = siteCurve;
        }
    }

    private static class HazardCalcTask
    extends AbstractHazardCalcTask<DiscretizedFunc> {
        final DiscretizedFunc xValues;

        public HazardCalcTask(Site site, double period, DiscretizedFunc xValues) {
            super(site, period);
            this.xValues = xValues;
        }
    }

    private static abstract class AbstractHazardCalcTask<E> {
        final Site site;
        final double period;
        E result;

        public AbstractHazardCalcTask(Site site, double period) {
            this.site = site;
            this.period = period;
        }

        public void setResult(E result) {
            this.result = result;
        }

        public E getResult() {
            Preconditions.checkState((boolean)this.isCalculated(), (String)"Not yet calculated for site %s period %s", (Object)this.site.getName(), (Object)this.period);
            return this.result;
        }

        public boolean isCalculated() {
            return this.result != null;
        }
    }

    private static abstract class AbstractSiteHazardTaskDistributor<E extends AbstractHazardCalcTask<T>, T> {
        protected List<Site> sites;
        protected double[] periods;
        private Map<Site, List<E>> siteTasks;
        private int curSiteIndex;
        private int numSitesDone = 0;
        private ProgressTrack track;

        public AbstractSiteHazardTaskDistributor(List<Site> sites, double[] periods) {
            this.sites = sites;
            this.periods = periods;
            this.siteTasks = new HashMap<Site, List<E>>(sites.size());
            for (Site site : sites) {
                ArrayList<Object> perTaskList = new ArrayList<Object>(periods.length);
                for (int i = 0; i < periods.length; ++i) {
                    perTaskList.add(null);
                }
                this.siteTasks.put(site, perTaskList);
            }
            this.curSiteIndex = 0;
            this.track = new ProgressTrack(sites.size() * periods.length);
        }

        protected abstract E buildTask(int var1, Site var2, int var3, double var4);

        public synchronized E getNextTask(Site preferredSite) {
            if (this.numSitesDone == this.sites.size()) {
                return null;
            }
            if (preferredSite != null) {
                int prefSiteIndex = this.sites.indexOf(preferredSite);
                Preconditions.checkState((prefSiteIndex >= 0 ? 1 : 0) != 0);
                List<E> tasks = this.siteTasks.get(preferredSite);
                for (int p = 0; p < tasks.size(); ++p) {
                    if (tasks.get(p) != null) continue;
                    E task = this.buildTask(prefSiteIndex, preferredSite, p, this.periods[p]);
                    tasks.set(p, task);
                    if (p == tasks.size() - 1) {
                        ++this.numSitesDone;
                    }
                    return task;
                }
            }
            for (int i = 0; i < this.sites.size(); ++i) {
                int siteIndex = (this.curSiteIndex + i) % this.sites.size();
                Site site = this.sites.get(siteIndex);
                List<E> tasks = this.siteTasks.get(site);
                for (int p = 0; p < tasks.size(); ++p) {
                    if (tasks.get(p) != null) continue;
                    E task = this.buildTask(siteIndex, site, p, this.periods[p]);
                    tasks.set(p, task);
                    if (p == tasks.size() - 1) {
                        ++this.numSitesDone;
                    }
                    this.curSiteIndex = (siteIndex + 1) % this.sites.size();
                    return task;
                }
            }
            throw new IllegalStateException(this.numSitesDone + "/" + this.sites.size() + " sites are done, but didn't find any tasks?");
        }

        public List<T> getSiteResults(Site site) {
            List<E> tasks = this.siteTasks.get(site);
            ArrayList ret = new ArrayList(tasks.size());
            for (AbstractHazardCalcTask task : tasks) {
                ret.add(task.getResult());
            }
            return ret;
        }

        public ProgressTrack getProgressTrack() {
            return this.track;
        }
    }
}

