/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util.minisections;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opensha.commons.geo.Location;

public abstract class AbstractMinisectionDataRecord {
    public final int parentID;
    public final int minisectionID;
    public final Location startLoc;
    public final Location endLoc;

    public AbstractMinisectionDataRecord(int parentID, int minisectionID, Location startLoc, Location endLoc) {
        Preconditions.checkState((parentID >= 0 ? 1 : 0) != 0);
        this.parentID = parentID;
        Preconditions.checkState((minisectionID >= 0 ? 1 : 0) != 0);
        this.minisectionID = minisectionID;
        this.startLoc = startLoc;
        this.endLoc = endLoc;
    }

    public int hashCode() {
        return Objects.hash(this.endLoc, this.minisectionID, this.parentID, this.startLoc);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMinisectionDataRecord other = (AbstractMinisectionDataRecord)obj;
        return Objects.equals(this.endLoc, other.endLoc) && this.minisectionID == other.minisectionID && this.parentID == other.parentID && Objects.equals(this.startLoc, other.startLoc);
    }
}

