/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util.minisections;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.AbstractMinisectionDataRecord;

public class MinisectionSlipRecord
extends AbstractMinisectionDataRecord {
    public final double rake;
    public final double slipRate;
    public final double slipRateStdDev;

    public MinisectionSlipRecord(int parentID, int minisectionID, Location startLoc, Location endLoc, double rake, double slipRate, double slipRateStdDev) {
        super(parentID, minisectionID, startLoc, endLoc);
        this.rake = rake;
        this.slipRate = slipRate;
        this.slipRateStdDev = slipRateStdDev;
    }

    public static Map<Integer, List<MinisectionSlipRecord>> readMinisectionsFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        Map<Integer, List<MinisectionSlipRecord>> ret = MinisectionSlipRecord.readMinisectionsFile(reader);
        reader.close();
        return ret;
    }

    public static Map<Integer, List<MinisectionSlipRecord>> readMinisectionsFile(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        Map<Integer, List<MinisectionSlipRecord>> ret = MinisectionSlipRecord.readMinisectionsFile(reader);
        reader.close();
        return ret;
    }

    public static Map<Integer, List<MinisectionSlipRecord>> readMinisectionsFile(Reader reader) throws IOException {
        BufferedReader bRead = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        HashMap<Integer, List<MinisectionSlipRecord>> ret = new HashMap<Integer, List<MinisectionSlipRecord>>();
        String line = null;
        while ((line = bRead.readLine()) != null) {
            double slipRateStdDev;
            if ((line = line.trim()).isBlank() || line.startsWith("#")) continue;
            line = line.replaceAll("\t", " ");
            while (line.contains("  ")) {
                line = line.replaceAll("  ", " ");
            }
            String[] split = line.split(" ");
            Preconditions.checkState((split.length == 9 || split.length == 8 ? 1 : 0) != 0, (String)"Expected 8/9 columns, have %s. Line: %s", (int)split.length, (Object)line);
            int index = 0;
            int parentID = Integer.parseInt(split[index++]);
            Preconditions.checkState((parentID >= 0 ? 1 : 0) != 0, (String)"Bad parentID=%s. Line: %s", (int)parentID, (Object)line);
            int minisectionID = Integer.parseInt(split[index++]);
            Preconditions.checkState((minisectionID >= 1 ? 1 : 0) != 0, (String)"Bad minisectionID=%s. Line: %s", (int)minisectionID, (Object)line);
            double startLat = Double.parseDouble(split[index++]);
            double startLon = Double.parseDouble(split[index++]);
            Location startLoc = new Location(startLat, startLon);
            double endLat = Double.parseDouble(split[index++]);
            double endLon = Double.parseDouble(split[index++]);
            Location endLoc = new Location(endLat, endLon);
            double rake = Double.parseDouble(split[index++]);
            Preconditions.checkState((Double.isFinite(rake) && (float)rake >= -180.0f && (float)rake <= 180.0f ? 1 : 0) != 0, (String)"Bad rake=%s. Line: %s", (Object)rake, (Object)line);
            double slipRate = Double.parseDouble(split[index++]);
            Preconditions.checkState((slipRate >= 0.0 && Double.isFinite(slipRate) ? 1 : 0) != 0, (String)"Bad slipRate=%s. Line: %s", (Object)slipRate, (Object)line);
            if (split.length > index) {
                Preconditions.checkState(((slipRateStdDev = Double.parseDouble(split[index++])) >= 0.0 && Double.isFinite(slipRateStdDev) ? 1 : 0) != 0, (String)"Bad slipRateStdDev=%s. Line: %s", (Object)slipRateStdDev, (Object)line);
            } else {
                slipRateStdDev = Double.NaN;
            }
            ArrayList<MinisectionSlipRecord> parentRecs = (ArrayList<MinisectionSlipRecord>)ret.get(parentID);
            if (parentRecs == null) {
                parentRecs = new ArrayList<MinisectionSlipRecord>();
                ret.put(parentID, parentRecs);
                Preconditions.checkState((minisectionID == 1 ? 1 : 0) != 0, (String)"First minisection encounterd for fault %s, but minisection ID is %s", (int)parentID, (int)minisectionID);
            } else {
                MinisectionSlipRecord prev = (MinisectionSlipRecord)parentRecs.get(parentRecs.size() - 1);
                Preconditions.checkState((minisectionID == prev.minisectionID + 2 ? 1 : 0) != 0, (String)"Minisections are out of order for fault %s, %s is directly after %s", (Object)parentID, (Object)minisectionID, (Object)prev.minisectionID);
                Preconditions.checkState((startLoc.equals(prev.endLoc) || LocationUtils.areSimilar(startLoc, prev.endLoc) ? 1 : 0) != 0, (String)"Previons endLoc does not match startLoc for %s %s:\n\t%s\n\t%s", (Object)parentID, (Object)minisectionID, (Object)prev.endLoc, (Object)startLoc);
            }
            parentRecs.add(new MinisectionSlipRecord(parentID, minisectionID - 1, startLoc, endLoc, rake, slipRate, slipRateStdDev));
        }
        return ret;
    }

    public static void writeMinisectionsFile(File file, Map<Integer, List<MinisectionSlipRecord>> recsMap) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write("#FaultID\tMinisectionID\tStartLat\tStartLon\tEndLat\tEndLon\tRake\tSlipRate(mm/y)\tStdDev\n");
        ArrayList<Integer> parentsSorted = new ArrayList<Integer>(recsMap.keySet());
        Collections.sort(parentsSorted);
        Iterator iterator = parentsSorted.iterator();
        while (iterator.hasNext()) {
            int parentID = (Integer)iterator.next();
            List<MinisectionSlipRecord> recs = recsMap.get(parentID);
            Preconditions.checkNotNull(recs);
            for (MinisectionSlipRecord rec : recs) {
                Preconditions.checkNotNull((Object)rec);
                Preconditions.checkState((rec.parentID == parentID ? 1 : 0) != 0);
                String line = rec.parentID + "\t" + (rec.minisectionID + 1);
                line = line + "\t" + (float)rec.startLoc.lat + "\t" + (float)rec.startLoc.lon;
                line = line + "\t" + (float)rec.endLoc.lat + "\t" + (float)rec.endLoc.lon;
                line = line + "\t" + (float)rec.rake + "\t" + rec.slipRate + "\t" + rec.slipRateStdDev;
                fw.write(line + "\n");
            }
        }
        fw.close();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.rake, this.slipRate, this.slipRateStdDev);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MinisectionSlipRecord other = (MinisectionSlipRecord)obj;
        return Double.doubleToLongBits(this.rake) == Double.doubleToLongBits(other.rake) && Double.doubleToLongBits(this.slipRate) == Double.doubleToLongBits(other.slipRate) && Double.doubleToLongBits(this.slipRateStdDev) == Double.doubleToLongBits(other.slipRateStdDev);
    }
}

