/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake.Declustering;

import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class GardnerKnopoffDeclustering {
    static boolean D = false;
    ObsEqkRupList fullCatalog = new ObsEqkRupList();
    ObsEqkRupList mainshockList;
    ObsEqkRupList aftershockList;
    ObsEqkRupList forshockList;
    ObsEqkRupList bothAftershockAndForeshockList;
    EvenlyDiscretizedFunc timeWindowDaysFunc;
    EvenlyDiscretizedFunc distanceWindowKmFunc;
    int[] numAftershocksForRupArray;
    boolean[] rupIsAfteshockArray;
    boolean[] rupIsForeshockArray;

    public GardnerKnopoffDeclustering(ObsEqkRupList catalog) {
        for (ObsEqkRupture rup : catalog) {
            if (!(rup.getMag() >= 2.5)) continue;
            this.fullCatalog.add(rup);
        }
        if (D) {
            System.out.println("Num Events (M\u22652.5): " + this.fullCatalog.size());
        }
        this.numAftershocksForRupArray = new int[this.fullCatalog.size()];
        this.rupIsAfteshockArray = new boolean[this.fullCatalog.size()];
        this.rupIsForeshockArray = new boolean[this.fullCatalog.size()];
        this.distanceWindowKmFunc = new EvenlyDiscretizedFunc(2.5, 12, 0.5);
        this.distanceWindowKmFunc.set(2.5, 19.5);
        this.distanceWindowKmFunc.set(3.0, 22.5);
        this.distanceWindowKmFunc.set(3.5, 26.0);
        this.distanceWindowKmFunc.set(4.0, 30.0);
        this.distanceWindowKmFunc.set(4.5, 35.0);
        this.distanceWindowKmFunc.set(5.0, 40.0);
        this.distanceWindowKmFunc.set(5.5, 47.0);
        this.distanceWindowKmFunc.set(6.0, 54.0);
        this.distanceWindowKmFunc.set(6.5, 61.0);
        this.distanceWindowKmFunc.set(7.0, 70.0);
        this.distanceWindowKmFunc.set(7.5, 81.0);
        this.distanceWindowKmFunc.set(8.0, 94.0);
        this.timeWindowDaysFunc = new EvenlyDiscretizedFunc(2.5, 12, 0.5);
        this.timeWindowDaysFunc.set(2.5, 6.0);
        this.timeWindowDaysFunc.set(3.0, 11.5);
        this.timeWindowDaysFunc.set(3.5, 22.0);
        this.timeWindowDaysFunc.set(4.0, 42.0);
        this.timeWindowDaysFunc.set(4.5, 83.0);
        this.timeWindowDaysFunc.set(5.0, 155.0);
        this.timeWindowDaysFunc.set(5.5, 290.0);
        this.timeWindowDaysFunc.set(6.0, 510.0);
        this.timeWindowDaysFunc.set(6.5, 790.0);
        this.timeWindowDaysFunc.set(7.0, 915.0);
        this.timeWindowDaysFunc.set(7.5, 960.0);
        this.timeWindowDaysFunc.set(8.0, 985.0);
        this.decluster();
    }

    private void decluster() {
        double distKm;
        int j;
        long timeCutoffMillis;
        double distanceCutoffKm;
        double tempMag;
        int i;
        block0: for (i = 0; i < this.fullCatalog.size(); ++i) {
            ObsEqkRupture rup = (ObsEqkRupture)this.fullCatalog.get(i);
            tempMag = rup.getMag();
            if (tempMag > 8.0) {
                tempMag = 8.0;
            }
            distanceCutoffKm = this.distanceWindowKmFunc.getInterpolatedY(tempMag);
            timeCutoffMillis = (long)(this.timeWindowDaysFunc.getInterpolatedY(tempMag) * 24.0 * 60.0 * 60.0 * 1000.0);
            for (j = i + 1; j < this.fullCatalog.size(); ++j) {
                ObsEqkRupture candidateAftershock = (ObsEqkRupture)this.fullCatalog.get(j);
                if (rup.getOriginTime() > candidateAftershock.getOriginTime()) {
                    throw new RuntimeException("Error: catalog is not in chronological order");
                }
                if (candidateAftershock.getOriginTime() - rup.getOriginTime() > timeCutoffMillis) continue block0;
                if (candidateAftershock.getMag() > rup.getMag() || (distKm = LocationUtils.linearDistanceFast(rup.getHypocenterLocation(), candidateAftershock.getHypocenterLocation())) > distanceCutoffKm) continue;
                int n = i;
                this.numAftershocksForRupArray[n] = this.numAftershocksForRupArray[n] + 1;
                this.rupIsAfteshockArray[j] = true;
            }
        }
        block2: for (i = 0; i < this.fullCatalog.size(); ++i) {
            ObsEqkRupture candidateForeshock = (ObsEqkRupture)this.fullCatalog.get(i);
            tempMag = candidateForeshock.getMag();
            if (tempMag > 8.0) {
                tempMag = 8.0;
            }
            distanceCutoffKm = this.distanceWindowKmFunc.getInterpolatedY(tempMag);
            timeCutoffMillis = (long)(this.timeWindowDaysFunc.getInterpolatedY(tempMag) * 24.0 * 60.0 * 60.0 * 1000.0);
            for (j = i + 1; j < this.fullCatalog.size(); ++j) {
                if (this.rupIsAfteshockArray[j]) continue;
                ObsEqkRupture rup = (ObsEqkRupture)this.fullCatalog.get(j);
                if (candidateForeshock.getOriginTime() > rup.getOriginTime()) {
                    throw new RuntimeException("Error: catalog is not in chronological order");
                }
                if (rup.getOriginTime() - candidateForeshock.getOriginTime() > timeCutoffMillis) continue block2;
                if (candidateForeshock.getMag() > rup.getMag() || (distKm = LocationUtils.linearDistanceFast(candidateForeshock.getHypocenterLocation(), rup.getHypocenterLocation())) > distanceCutoffKm) continue;
                this.rupIsForeshockArray[i] = true;
            }
        }
        this.mainshockList = new ObsEqkRupList();
        this.aftershockList = new ObsEqkRupList();
        this.forshockList = new ObsEqkRupList();
        this.bothAftershockAndForeshockList = new ObsEqkRupList();
        for (i = 0; i < this.fullCatalog.size(); ++i) {
            if (this.rupIsAfteshockArray[i] && this.rupIsForeshockArray[i]) {
                this.bothAftershockAndForeshockList.add((ObsEqkRupture)this.fullCatalog.get(i));
                continue;
            }
            if (this.rupIsAfteshockArray[i]) {
                this.aftershockList.add((ObsEqkRupture)this.fullCatalog.get(i));
                continue;
            }
            if (this.rupIsForeshockArray[i]) {
                this.forshockList.add((ObsEqkRupture)this.fullCatalog.get(i));
                continue;
            }
            this.mainshockList.add((ObsEqkRupture)this.fullCatalog.get(i));
        }
        if (D) {
            System.out.println("Num Main Shocks: " + this.mainshockList.size());
            System.out.println("Num Aftershocks: " + this.aftershockList.size());
            System.out.println("Num Foreshocks: " + this.forshockList.size());
            System.out.println("Num Both Aft. & Fore.: " + this.bothAftershockAndForeshockList.size());
        }
    }

    private void decluster_alt() {
        int i;
        block0: for (i = 0; i < this.fullCatalog.size(); ++i) {
            ObsEqkRupture rup = (ObsEqkRupture)this.fullCatalog.get(i);
            double tempMag = rup.getMag();
            if (tempMag > 8.0) {
                tempMag = 8.0;
            }
            double distanceCutoffKm = this.distanceWindowKmFunc.getInterpolatedY(tempMag);
            long timeCutoffMillis = (long)(this.timeWindowDaysFunc.getInterpolatedY(tempMag) * 24.0 * 60.0 * 60.0 * 1000.0);
            for (int j = i + 1; j < this.fullCatalog.size(); ++j) {
                ObsEqkRupture candidateAftershock = (ObsEqkRupture)this.fullCatalog.get(j);
                if (rup.getOriginTime() > candidateAftershock.getOriginTime()) {
                    throw new RuntimeException("Error: catalog is not in chronological order");
                }
                if (candidateAftershock.getOriginTime() - rup.getOriginTime() > timeCutoffMillis) continue block0;
                double distKm = LocationUtils.linearDistanceFast(rup.getHypocenterLocation(), candidateAftershock.getHypocenterLocation());
                if (distKm > distanceCutoffKm) continue;
                if (rup.getMag() >= candidateAftershock.getMag()) {
                    this.rupIsAfteshockArray[j] = true;
                    continue;
                }
                this.rupIsForeshockArray[i] = true;
            }
        }
        this.mainshockList = new ObsEqkRupList();
        this.aftershockList = new ObsEqkRupList();
        this.forshockList = new ObsEqkRupList();
        this.bothAftershockAndForeshockList = new ObsEqkRupList();
        for (i = 0; i < this.fullCatalog.size(); ++i) {
            if (this.rupIsAfteshockArray[i] && this.rupIsForeshockArray[i]) {
                this.bothAftershockAndForeshockList.add((ObsEqkRupture)this.fullCatalog.get(i));
                continue;
            }
            if (this.rupIsAfteshockArray[i]) {
                this.aftershockList.add((ObsEqkRupture)this.fullCatalog.get(i));
                continue;
            }
            if (this.rupIsForeshockArray[i]) {
                this.forshockList.add((ObsEqkRupture)this.fullCatalog.get(i));
                continue;
            }
            this.mainshockList.add((ObsEqkRupture)this.fullCatalog.get(i));
        }
        if (D) {
            System.out.println("Num Main Shocks: " + this.mainshockList.size());
            System.out.println("Num Aftershocks: " + this.aftershockList.size());
            System.out.println("Num Foreshocks: " + this.forshockList.size());
            System.out.println("Num Both Aft. & Fore.: " + this.bothAftershockAndForeshockList.size());
        }
    }

    public ObsEqkRupList getDeclusteredCatalog() {
        return this.mainshockList;
    }

    public static ObsEqkRupList getDeclusteredCatalog(ObsEqkRupList rupList) {
        GardnerKnopoffDeclustering gk_decluster = new GardnerKnopoffDeclustering(rupList);
        return gk_decluster.getDeclusteredCatalog();
    }

    public static void main(String[] args) {
    }

    public static double getDistanceKM(Location loc1, Location loc2) {
        double sorlat = loc1.getLatitude();
        double sorlon = loc1.getLongitude();
        double stnlat = loc2.getLatitude();
        double stnlon = loc2.getLongitude();
        double coef = Math.atan(1.0) / 45.0;
        double xlat = sorlat * coef;
        double xlon = sorlon * coef;
        double st0 = Math.cos(xlat);
        double ct0 = Math.sin(xlat);
        double phi0 = xlon;
        xlat = stnlat * coef;
        xlon = stnlon * coef;
        double st1 = Math.cos(xlat);
        double ct1 = Math.sin(xlat);
        double sdlon = Math.sin(xlon - phi0);
        double cdlon = Math.cos(xlon - phi0);
        double cdelt = st0 * st1 * cdlon + ct0 * ct1;
        double x = st0 * ct1 - st1 * ct0 * cdlon;
        double y = st1 * sdlon;
        double sdelt = Math.sqrt(x * x + y * y);
        double delta = Math.atan2(sdelt, cdelt);
        delta /= coef;
        double az = Math.atan2(y, x);
        az /= coef;
        x = st1 * ct0 - st0 * ct1 * cdlon;
        y = -sdlon * st0;
        double baz = Math.atan2(y, x);
        baz /= coef;
        return delta *= 111.1;
    }
}

