/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupOrigTimeComparator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.util.EqkRuptureMagComparator;

public class ObsEqkRupList
extends ArrayList<ObsEqkRupture>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ObsEqkRupList";
    protected static final boolean D = false;

    public ObsEqkRupList getRupsAboveMag(double mag) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            if (!(eqkRup.getMag() >= mag)) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getRupsBelowMag(double mag) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            if (!(eqkRup.getMag() < mag)) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getRupsBetweenMag(double mag1, double mag2) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            double eventMag = eqkRup.getMag();
            if (!(eventMag >= mag1) || !(eventMag < mag2)) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getRupsBefore(long timeInMillis) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            long eventTime = eqkRup.getOriginTime();
            if (eventTime >= timeInMillis) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getRupsAfter(long timeInMillis) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            long eventTime = eqkRup.getOriginTime();
            if (eventTime <= timeInMillis) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getRupsBetween(long timeInMillis1, long timeInMillis2) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            long eventTime = eqkRup.getOriginTime();
            if (eventTime <= timeInMillis1 || eventTime >= timeInMillis2) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getRupsInside(Region region) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            Location loc = eqkRup.getHypocenterLocation();
            if (!region.contains(loc)) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public ObsEqkRupList getRupsOutside(Region region) {
        ObsEqkRupList obsEventList = new ObsEqkRupList();
        for (ObsEqkRupture eqkRup : this) {
            Location loc = eqkRup.getHypocenterLocation();
            if (region.contains(loc)) continue;
            obsEventList.add(eqkRup);
        }
        return obsEventList;
    }

    public void sortByMag() {
        Collections.sort(this, new EqkRuptureMagComparator());
    }

    public void sortByOriginTime() {
        Collections.sort(this, new ObsEqkRupOrigTimeComparator());
    }
}

